<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';
$listaEmpreendimento = $this->get('listaEmpreendimento');
$listaLote = $this->get('listaLote');
$tpAudiencia = $this->get('tpAudiencia');
$processo = $this->get('processo');
?>
    <link xmlns="http://www.w3.org/1999/html">
    <div class="content">
            <div class="page-heading">
                <?= $this->getHeader(); ?>
            </div>
            <div class="widget">
                <div class="widget-content padding">
                    <!-- MENSAGENS -->
                    <?php if (count($this->_helper->getMensagens()) > 0): ?>
                        <div class="alert alert-danger alert-dismissable">
                            <?php foreach ($this->_helper->getMensagens() as $message): ?>
                                <?= $message ?><br>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                    <form action="" method="POST" id="form" enctype="multipart/form-data">
                        <fieldset>
                            <legend>Informaes do Juridico <span style=" font-size: 12pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                                <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                                    <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                                        <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                                    </svg>
                                </span>
                            </legend>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-6">
                                        <label class="control-label" for="id_empreendimento">
                                            Empreendimento:<span class="require" style="color: red">*</span>
                                        </label>
                                        <select class="form-control select2 empreendimento_juridico"
                                                data-placeholder="Escolha o empreendimento" id="id_empreendimento"
                                                name="id_empreendimento" required="required">
                                            <option value=""></option>
                                            <?php foreach ($listaEmpreendimento as $k => $empreendimento) : ?>
                                                <option
                                                    value="<?= $empreendimento['id']; ?>"<?php if ($processo['id_empreendimento'] == $empreendimento['id']): ?> selected<?php endif; ?>>
                                                    <?= $empreendimento['nm_empreendimento']; ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-sm-6">
                                        <label class="control-label" for="id_contrato">
                                            Contrato:<span class="require" style="color: red">*</span>
                                        </label>
                                        <select class="form-control select2 contratos" name="id_contrato"
                                                data-placeholder="Escolha o contrato"
                                                id="id_contrato" required>
                                            <option value="">Selecione ...</option>
                                            <?php if($listaLote):
                                                foreach ($listaLote as $lote): ?>
                                                <option value="<?= $lote['id']; ?>"
                                                    <?php if ($lote['id'] == $processo['id_contrato']): ?> selected<?php endif; ?>><?= $lote['nm_pessoa'] . ' - Quadra ' . $lote['quadra'] . ' - Lote ' . $lote['lote']; ?></option>
                                            <?php endforeach; endif;?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-6">
                                        <label class="control-label" for="id_tipo_audiencia">
                                            Tipo de audincia:<span class="require" style="color: red">*</span>
                                        </label>
                                        <select class="form-control select2" name="id_tipo_audiencia"
                                                data-placeholder="Escolha o tipo de audincia"
                                                id="id_tipo_audiencia" required="required">
                                            <option value="">Selecione ...</option>
                                            <?php foreach ($tpAudiencia as $tipo): ?>
                                                <option
                                                    value="<?= $tipo['idCampo']; ?>" <?= ($tipo['idCampo'] == $processo['id_tipo_audiencia']) ? 'selected' : '' ?>>
                                                    <?= $tipo['descricao'] ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-sm-3">
                                        <label class="control-label">
                                            Processo:<span class="require" style="color: red">*</span>
                                        </label><br>

                                        <div class="col-sm-6">
                                            <label for="reu">Ru</label>
                                            <input id="reu" class="form-control icheck"
                                                   style="margin-left: 20px" <?php if ($processo['fl_tipo'] == 'R') echo 'checked'; ?>
                                                   type="radio" name="fl_tipo" value="R" />
                                        </div>
                                        <div class="col-sm-6">
                                            <label for="autor">Autor</label>
                                            <input id="autor" class="form-control icheck"
                                                   style="margin-left: 20px" <?php if ($processo['fl_tipo'] == 'A') echo 'checked'; ?>
                                                   type="radio" name="fl_tipo" value="A" />
                                        </div>
                                    </div>
                                    <div class="form-group col-sm-3">
                                        <label class="control-label" for="ds_processo">
                                            Numero do processo:
                                        </label>
                                        <input type="text" class="form-control" id="ds_processo" name="ds_processo"
                                               value="<?= $processo['ds_processo'] ?>"/>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12" style="white-space: nowrap; min-width: 200px;">
                                    <div class="form-group col-sm-3">
                                        <label class="control-label" for="dt_notificacao">
                                            Data notificao:<span class="require" style="color: red">*</span>
                                        </label>
                                        <input type="text" class="form-control data datepicker-input"
                                               id="dt_notificacao"
                                               name="dt_notificacao" required
                                               value="<?= isset($processo['dt_notificacao']) ? Helper::getDate($processo['dt_notificacao']) : date('d/m/Y'); ?>"/>
                                    </div>
                                    <div class="form-group col-sm-3">
                                        <label class="control-label" for="dt_audiencia">
                                            Data audincia:
                                        </label>
                                        <input type="text" class="form-control data datepicker-input" id="dt_audiencia"
                                               name="dt_audiencia"
                                               value="<?= isset($processo['dt_audiencia']) ? Helper::getDate($processo['dt_audiencia']) : '' ?>"/>
                                    </div>
                                    <div class="form-group col-sm-6">
                                        <label class="control-label" for="ds_local">
                                            Local:
                                        </label>
                                        <input type="text" class="form-control" id="ds_local" name="ds_local"
                                               value="<?= $processo['ds_local'] ?>"/>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-12">
                                        <label class="control-label" for="ds_resumo">
                                            Resumo:
                                        </label>
                                        <textarea class="form-control" id="ds_resumo" name="ds_resumo" cols="50"
                                                  rows="5"><?= $processo['ds_resumo'] ?></textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-6">
                                        <input type="file" id="ds_path_arquivo" class="fileinput" name="ds_path_arquivo"
                                               title="Escolher Arquivo"/>
                                    </div>
                                    <?php if ($_GET['a'] == 'editar' && $processo['ds_path_arquivo'] != ''): ?>
                                        <div class="form-group col-sm-6" id="downloadFile">
                                            <a class="btn btn-default" target="_blank" download
                                               href="<?= $processo['ds_path_arquivo'] ?>">Baixar Arquivo</a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </fieldset>

                        <fieldset>
                            <legend>Operaes</legend>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-2">
                                        <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Salvar">
                                    </div>
                                    <div class="form-group col-sm-2">
                                        <a href="?m=<?= $_GET['m'] ?>&c=<?= $_GET['c'] ?>&a=listar"
                                           class="btn btn-danger col-sm-12">Cancelar </a>
                                    </div>
                                </div>
                            </div>
                        </fieldset>
                    </form>

                </div>
        </div>
    </div>
<div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg ">
        <div class="modal-content">

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"
                        aria-hidden="true">&times;</button>
                <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                    Tutorial</h2>
            </div>

            <div class="modal-body tableFix" style="max-height:600px;">
                <fieldset >
                    <legend>Jurdico - Visualizar, editar excluir agendamentos de processos jurdicos</legend>
                    <div class="row" style="margin-right: 0px;margin-left: 0px;">
                        <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/GLdVkIax1QQ?si=TqXmqJ39x4ma7MkB" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>                        
                    </div>
                    <div></div>
                </fieldset>
            </div>
        </div>
    </div>
</div>
<?php require_once 'layout/includes/footer.php'; ?>