<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';

$distrato = $this->get("distrato");
$empreendimentos = $this->get('empreendimentos');
$motivos = $this->get('motivoDistrato');
$listaLote = $this->get('contratos');
$bancos = $this->get('bancos');
$valorPago = $this->get('valorPago');
$valorDevolucao = $this->get('valorDevolucao');
$quantidadeSinal = $this->get('quantidadeSinal');

?>
    <div class="content">
            <div class="page-heading">
                <?= $this->getHeader(); ?>
            </div>
            <div class="widget">
                <div class="widget-content padding">
                    <!-- MENSAGENS -->
                    <?php if (count($this->_helper->getMensagens()) > 0): ?>
                        <div class="alert alert-danger alert-dismissable">
                            <?php foreach ($this->_helper->getMensagens() as $message): ?>
                                <?= $message ?><br>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                    <input type="text" hidden id="vlTotalHidden" name="vlTotalHidden" value=""/>
                    <input type="text" hidden id="vlRestanteHidden" name="vlRestanteHidden" value=""/>
                    <input type="text" hidden id="quantSinal" name="quantSinal" value="<?= $quantidadeSinal['nr_parcela_sinal']?>"/>
                    <form action="" method="POST" id="form">
                        <input type="hidden" id="flConstrucao" name="flConstrucao"
                               value="<?= $distrato['fl_construcao'] ?>">
                        <input type="hidden" id="flCaucionado" name="flCaucionado"  value="<?= $distrato['fl_caucionado'] ?>">
                               <fieldset>
                                    <legend>
                                        <div class="col-sm-6">
                                            Informaes do Distrato <span style=" font-size: 12pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                                            <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                                                <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                                                    <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                                                </svg>
                                            </span>
                                        </div>
                                        <div class="col-sm-6">
                                            <span class="hidden-construcao" style=" color: red; font-weight: bold; font-size: 12pt;" hidden>ATENO, este lote possui construo ativa</span><br/>
                                            <span class="hidden-caucionado" style=" color: red; font-weight: bold; font-size: 12pt;" hidden>ATENO, este lote possui cauo ativo</span>
                                            <span class="hidden-juridico" style=" color: red; font-weight:bold; font-size: 12pt;" hidden>ATENO, este lote possui pendncia jurdica</span>
                                        </div>
                                    </legend>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-6">
                                        <label class="control-label" for="id_empreendimento">
                                            Empreendimento:<span class="require" style="color: red">*</span>
                                        </label>
                                        <select class="form-control select2 empreendimento_distrato"
                                                id="id_empreendimento" name="id_empreendimento" required="required"
                                                data-placeholder="Selecione o empreendimento"
                                            <?= $distrato['idEmpreendimento'] ? 'disabled' : '' ?> >
                                            <option value=""></option>
                                            <?php foreach ($empreendimentos as $k => $empreendimento) : ?>
                                                <option value="<?= $empreendimento['id']; ?>" <?php if ($distrato['idEmpreendimento'] == $empreendimento['id']): ?> selected<?php endif; ?>>
                                                    <?= $empreendimento['nm_empreendimento']; ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-sm-6">
                                        <label class="control-label" for="id_contrato">
                                            Contrato:<span class="require" style="color: red">*</span>
                                        </label>
                                        <select class="form-control select2 contrato_distrato" name="id_contrato"
                                                id="id_contrato" required="required"
                                                data-placeholder="Selecione o contrato"
                                            <?= ($distrato['id_contrato'] && $_GET['a']=='editar') ? 'disabled' : '' ?> >
                                            <option value=""></option>
                                            <?php foreach ($listaLote as $lote): ?>
                                                <option
                                                        value="<?= $lote['id']; ?>" <?php if ($lote['id'] == $distrato['id_contrato']): ?> selected<?php endif; ?>>
                                                    <?= $lote['nm_pessoa'] . ' - Quadra ' . $lote['quadra'] . ' - Lote ' . $lote['lote']; ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12" style="display: flex; flex-wrap: wrap;">
                                    <div class="form-group col-sm-2" style="white-space: nowrap; min-width: 110px;">
                                        <label class="control-label" for="dt_distrato">
                                            Data do distrato:
                                        </label>
                                        <input type="text" class="form-control data datepicker-input" id="dt_distrato"
                                               name="dt_distrato" style="min-width: 90px;"
                                               value="<?= isset($distrato['dt_distrato']) ? Helper::getDate($distrato['dt_distrato']) : date('d/m/Y'); ?>"/>
                                    </div>
                                    <div class="form-group col-sm-4" <?= ($_GET['a'] != 'editar')? 'hidden' : '' ?>>
                                        <label class="control-label">Recalcular valores de devoluo?</label>
                                        <br>
                                        <input type="hidden" name="recalcValor" id="recalcValor"
                                               value="<?= Helper::getMoney($valorPago) ?>">                                        
                                        <div class="checkbox">
                                            <label>  <input type="radio" name="recalc" id="recalcN"
                                                            class="form-control icheck recalc" checked
                                                            value="N">No</label>
                                            <label>  <input type="radio" name="recalc" id="recalcS"
                                                            class="form-control icheck recalc"
                                                            value="S">Sim</label>
                                        </div>
                                    </div>
                                    <div class="form-group col-sm-4">
                                        <label class="control-label">Incluir sinal: </label>
                                        <br>
                                        <input type="hidden" name="SinalValor" id="SinalValor"
                                               value="<?= $distrato['valorSinal'] ?>">
                                        <div class="checkbox">
                                            <label id="radioSinalNLabel">  <input type="radio" name="radioSinal" id="radioSinalN"
                                                            class="form-control icheck radioSinal" <?= ($distrato['fl_incluir_sinal'] != '1') ? 'checked' : '' ?>
                                                            value="N">No</label>
                                            <label>  <input type="radio" name="radioSinal" id="radioSinalS"
                                                            class="form-control icheck radioSinal" <?= ($distrato['fl_incluir_sinal'] == '1') ? 'checked' : '' ?>
                                                            value="S">Sim</label>
                                        </div>
                                    </div>                                    
                                    <div class="col-sm-3 form-group" style="white-space: nowrap;" <?= ($_GET['a'] == 'editar')? 'hidden' : '' ?>>
                                        <label class="control-label">Total pago:</label>
                                        <input type="text" id="vlTotalPago" name="vlTotalPago"
                                               class="money  form-control" disabled
                                               value="<?= 'R$ ' . Helper::getMoney($valorPago) . ' (' . $distrato['qtParcelas'] . ' parcelas)';?>"/>
                                    </div>
                                    <div class="col-sm-3 form-group" style="white-space: nowrap;" <?= ($_GET['a'] == 'editar')? 'hidden' : '' ?>>
                                        <label class="control-label">Total  devolver:</label>
                                        <input type="text" id="vlDistrato" name="vlDistrato"
                                               class="money  form-control" disabled
                                               value="<?= 'R$ ' . Helper::getMoney($distrato['vlParcela']*$distrato['qtParcelas']) . ' (' . $distrato['qtParcelas'] . ' parcelas)';?>"/>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12" style="display: flex; flex-wrap: wrap;">
                                    <div class="form-group col-sm-2" style="white-space: nowrap; min-width: 170px;">
                                        <label class="control-label">Taxa Reteno <span class="require" style="color: red">(Empresa)</span>: </label>
                                        <input type="text" id="taxaAdm" name="taxaAdm" style="min-width:160px;"
                                               class="form-control" size="1" disabled
                                               value="<?= $distrato['txAdmin']; ?>" placeholder="Taxa Administrao do Empreendimento"/>
                                    </div>
                                    <div class="form-group col-sm-2" style="white-space: nowrap; min-width: 170px;">
                                        <label class="control-label">Valor da Reteno: </label>
                                        <input type="text" id="vlTxAdm" name="vlTxAdm" style="min-width: 160px;"
                                               class="form-control" size="1" disabled
                                               value="<?= $distrato['vlTxAdmin']; ?>" placeholder="Valor Total do Contrato"/>
                                    </div>
                                    <div class="form-group col-sm-2" style="white-space: nowrap; min-width: 170px;">
                                        <label class="control-label">Taxa Fruio: </label>
                                        <input type="text" id="taxaFruicao" name="taxaFruicao" style="min-width: 160px;"
                                               class="form-control" size="1" disabled
                                               value="<?= $distrato['txFruicao']; ?>" placeholder="Taxa Fruio do Empreendimento"/>
                                    </div>
                                    <div class="form-group col-sm-2" style="white-space: nowrap; min-width: 170px;">
                                        <label class="control-label">Meses de Fuio: </label>
                                        <input type="text" id="mesesFruicao" name="mesesFruicao" style="min-width: 160px;"
                                               class="form-control" size="1" disabled
                                               value="<?= $distrato['mFruicao']?>" placeholder="Quantidade Meses da Fruico"/>
                                    </div>
                                    <div class="form-group col-sm-2" style="white-space: nowrap; min-width: 170px;">
                                        <label class="control-label">Valor Fruio: </label>
                                        <input type="text" id="fruicaoDistrato" name="fruicaoDistrato" style="min-width: 160px;" 
                                               class="form-control" size="1" disabled
                                               value="<?= $distrato['fruicao']; ?>" placeholder="Valor da Fuio"/>
                                    </div>
                                    <div class="form-group col-sm-2" style="white-space: nowrap; min-width: 170px;">
                                        <label class="control-label">Valor Total do Contrato: </label>
                                        <input type="text" id="vlTotalContrato" name="vlTotalContrato" style="min-width: 160px;"
                                               class="form-control" size="1" disabled
                                               value="<?= $distrato['vlTotalContrato']; ?>" placeholder="Valor Total do Contrato"/>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12" style="display: flex; flex-wrap: wrap;">
                                    <div class="form-group col-sm-2" style="white-space: nowrap; min-width: 150px;">
                                        <label class="control-label">Parc  devolver: </label>
                                        <input type="text" id="qtdeParcelaDistrato" name="qtdeParcelaDistrato"
                                               class=" form-control" style="min-width: 140px;"
                                               size="1"
                                               value="<?= $distrato['qtParcelas']; ?>" placeholder="Qntde. parcelas, ex: 5"/>
                                    </div>
                                    <div class="form-group col-sm-2" style="white-space: nowrap; min-width: 150px;">
                                        <label class="control-label">Valor: </label>
                                        <input type="text" id="vlParcelaDistrato"
                                               name="vlParcelaDistrato" style="min-width: 140px;"
                                               class="money  form-control" size="10" placeholder="Valor parcela, ex: 500,00"
                                               value="<?= ($distrato['vlParcela'])?Helper::getMoney($distrato['vlParcela']):''?>"/>
                                    </div>
                                    <div class="form-group col-sm-2" style="white-space: nowrap; min-width: 150px;">
                                        <label class="control-label">Total: </label>
                                        <input type="text" id="vlTotalDistrato"
                                               name="vlTotalDistrato" style="min-width: 140px;"
                                               class="money  form-control" size="10" placeholder="Total, ex: 2500,00"
                                               value="<?= ($distrato['vlTotalParcelas'])?Helper::getMoney($distrato['vlTotalParcelas']):'' ?>"/>
                                    </div>
                                    <input type="hidden" id="vlPorcDev" name="vlPorcDev" style="min-width: 140px;" size="10"
                                           value="<?= $distrato['porcDev'] ?>"/>
                                    <input type="hidden" id="vlParcelaDistratoH" name="vlParcelaDistratoH" style="min-width: 140px;"
                                           value="<?= ($distrato['vlParcela'])?Helper::getMoney($distrato['vlParcela']):''?>"/>
                                    <input type="hidden" id="vlTotalDistratoH" name="vlTotalDistratoH" style="min-width: 140px;"
                                           value="<?= ($distrato['vlTotalParcelas'])?Helper::getMoney($distrato['vlTotalParcelas']):''?>"/>

                                    <div class="col-sm-3 form-group" style="white-space: nowrap; min-width: 150px;">
                                        <label class="control-label">Data da 1 parcela:<span class="require" style="color: red">*</span></label>
                                        <input type="text" id="dtPrimeiraParcela" name="dtPrimeiraParcela" style="min-width: 140px;" required="required"
                                               class="data datepicker-input  form-control"
                                               value="<?= isset($distrato['dtParcela']) ? Helper::getDate($distrato['dtParcela']) : date('d/m/Y'); ?>"/>
                                    </div>
                                    <?php if ($_GET['a'] == 'adicionar'): ?>
                                        <div class="col-sm-3 form-group" style="white-space: nowrap; min-width: 150px;">
                                            <label class="control-label">Valor restante:</label>
                                            <input type="text" id="vlDiferenca" name="vlDiferenca" style="min-width: 140px;"
                                                   class="money  form-control" disabled
                                                   value="<?= Helper::getMoney($valorDevolucao)?>"/>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="col-sm-4 form-group" style="white-space: nowrap; min-width: 150px;">
                                        <label class="control-label" for="local_assinatura">
                                            Local da assinatura:<span class="require" style="color: red">*</span>
                                        </label>
                                        <input name="local_assinatura" id="local_assinatura" type="text"
                                               class=" form-control" required="required"
                                               placeholder="Cidade do local"
                                               value="<?= $distrato['local_assinatura']; ?>"/>
                                    </div>
                                    <div class="col-sm-4 form-group">
                                        <label class="control-label" for="tpDistrato">
                                            Tipo de distrato: <span class="require" style="color: red">*</span>
                                        </label>
                                        <select name="tipoDistrato" id="tpDistrato" required="required"
                                                class="tipoDistrato  form-control select2" data-placeholder="Selecione o tipo de distrato">
                                            <option value=""></option>
                                            <option <?= ($distrato['tp_distrato'] == 'I') ? 'selected' : ''; ?>
                                                    value="I">Inadimplncia
                                            </option>
                                            <option <?= ($distrato['tp_distrato'] == 'V') ? 'selected' : ''; ?>
                                                    value="V">Voluntrio
                                            </option>
                                            <option <?= ($distrato['tp_distrato'] == 'J') ? 'selected' : ''; ?>
                                                    value="J">Judicial
                                            </option>
                                            <option <?= ($distrato['tp_distrato'] == 'T') ? 'selected' : ''; ?>
                                                    value="T">Tcnica
                                            </option>
                                            <option <?= ($distrato['tp_distrato'] == 'O') ? 'selected' : ''; ?>
                                                    value="O">Outros
                                            </option>
                                        </select>
                                    </div>
                                    <div class="col-sm-4 form-group" <?= $distrato['tp_distrato'] != 'V' ? 'hidden' : '' ?>
                                         id="motivoDistrato">
                                        <label class="control-label" for="dsMotivoDistrato">
                                            Motivo do distrato:<span class="require" style="color: red">*</span>
                                        </label><br>
                                        <select name="dsMotivoDistrato" id="dsMotivoDistrato"
                                                class="form-control select2" style="width: 100%">
                                            <option <?= ($distrato['id_motivo'] == '') ? 'selected' : ''; ?>
                                                    value="">Selecione...
                                            </option>
                                            <?php foreach ($motivos as $k => $motivo) : ?>
                                                <option value="<?= $motivo['idCampo']; ?>" <?php if ($distrato['id_motivo'] == $motivo['idCampo']): ?> selected<?php endif; ?>>
                                                    <?= $motivo['descricao']; ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="col-sm-6 form-group">
                                        <label class="control-label" for="dsObs">
                                            Observaes:
                                        </label>
                                        <textarea name="obs" cols="50" class=" form-control" id="dsObs"
                                                 placeholder="Digite a observao" rows="5"><?= $distrato['obs']; ?></textarea>
                                    </div>
                                    <div class="col-sm-6 form-group">
                                        <label class="control-label" for="dsFormaDevolucao">
                                            Observaes adicionais:
                                        </label>
                                        <textarea name="forma_devolucao" cols="50" class=" form-control"
                                                  id="dsFormaDevolucao" placeholder="Digite a observao adicional" rows="5"><?= $distrato['forma_devolucao']; ?></textarea>
                                    </div>
                                </div>
                            </div>
                        </fieldset>
                        <fieldset>
                            <legend>Dados para Reembolso:</legend>
                            <div class="row">
                                <div class="col-sm-12" style="white-space: nowrap; min-width: 150px;">
                                    <div class="form-group col-sm-3">
                                        <label class="control-label">Favorecido: </label>
                                        <br>
                                        <div class="checkbox">
                                            <label style="font-weight: 600 !important;">
                                                <input type="radio" name="favorecido" checked id="favorecido0"
                                                          class="form-control icheck radioFavorecido favorecidoOpcao" <?= ($distrato['fl_proprio_favorecido'] != '0') ? 'checked' : '' ?>
                                                          value="0"> O mesmo
                                            </label>
                                            <label style="font-weight: 600 !important;">
                                                <input type="radio" name="favorecido" id="favorecido1"
                                                          class="form-control icheck radioFavorecido favorecidoOpcao" <?= ($distrato['fl_proprio_favorecido'] == '0') ? 'checked' : '' ?>
                                                          value="1"> Outro
                                            </label>
                                        </div>
                                    </div>

                                    <div class="form-group col-sm-3 tipoPessoaDistrato" hidden>
                                        <label class="control-label">Tipo de pessoa: </label>
                                        <br>
                                        <div class="checkbox distratoTipoPessoa">
                                            <label style="font-weight: 600 !important;">
                                                <input type="radio" name="tpPessoa" checked id="pessoaFisica"
                                                          class="form-control icheck radioTipoPessoa"
                                                          value="F"> Fsica
                                            </label>
                                            <label style="font-weight: 600 !important;">
                                                <input type="radio" name="tpPessoa" id="pessoaJuridica"
                                                          class="form-control icheck radioTipoPessoa"
                                                          value="J"> Jurdica
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-4">
                                        <!-- CPF FAVORECIDO -->
                                        <label class="control-label labelTipoPessoa" for="CPFFavorecido">CPF favorecido:</label>
                                        <input name="CPFFavorecido" id="CPFFavorecido" type="text"
                                               class="cpf  form-control" <?= ($distrato['fl_proprio_favorecido'] == '0') ? '' : 'disabled' ?>
                                               value="<?= $distrato['nr_cpf_favorecido'] ?>"/>
                                        <!-- CNPJ FAVORECIDO -->
                                        <input name="CNPJFavorecido" id="CNPJFavorecido" type="text"
                                            class="cnpj  form-control"/>

                                        <input name="CPFFavorecidoH" id="CPFFavorecidoH" type="hidden"
                                               value="<?= $distrato['nr_cpf_favorecido'] ?>"/>
                                        <input name="CPFFavorecidoM" id="CPFFavorecidoM" type="hidden"
                                               value="<?= $distrato['nr_cpf_mesmo'] ?>"/>
                                    </div>
                                    <div class="form-group col-sm-6">
                                        <label class="control-label" for="nomeFavorecido">Nome completo:</label>
                                        <input name="nomeFavorecido" id="nomeFavorecido" type="text" size="79"
                                               class=" form-control" <?= ($distrato['fl_proprio_favorecido'] == '0') ? '' : 'disabled' ?>
                                               value="<?= $distrato['nm_favorecido'] ?>"/>
                                        <input name="nomeFavorecidoH" id="nomeFavorecidoH" type="hidden"
                                               value="<?= $distrato['nm_favorecido'] ?>"/>
                                        <input name="nomeFavorecidoM" id="nomeFavorecidoM" type="hidden"
                                               value="<?= $distrato['nm_mesmo'] ?>"/>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-4 <?= ($distrato['tp_conta'] != 'X') ? 'hidden' : '' ?>" id="pixDiv">
                                        <label class="control-label" for="chavePix"> 
                                            Chave Pix:
                                        </label>
                                        <input name="chavePix" id="chavePix" type="text" maxlength="40" size="5px"
                                               class=" form-control"
                                               value="<?= $distrato['chave_pix'] ?>"/>
                                    </div>     
                                    <div class="form-group col-sm-4 <?= ($distrato['tp_conta'] == 'X') ? 'hidden' : '' ?>" id="bancoDiv">
                                        <label class="control-label" for="banco">
                                            Banco:
                                        </label>
                                        <select name="banco" id="banco"
                                                data-placeholder="Selecione o banco"
                                                class=" bancoDistrato form-control select2">
                                            <option value="">Selecione ...</option>
                                            <?php foreach ($bancos as $banco): ?>
                                                <option
                                                        id="<?= $banco['idCampo']; ?>" <?= (($distrato['id_banco'] == $banco['idCampo']) ? 'selected' : '') ?>
                                                        value="<?= $banco['idCampo']; ?>"><?= $banco['descricao']; ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-sm-2 <?= ($distrato['tp_conta'] == 'X') ? 'hidden' : '' ?>" id="opDiv">
                                        <label class="control-label" for="operacao">
                                            Operao:
                                        </label>
                                        <span class="textoOperacao" style="color:red; font-size: 12px" hidden><b>(Obrigatrio p/ CEF)</b></span>
                                        <input name="operacao" id="operacao" type="text" maxlength="4" size="5px"
                                               class=" form-control"
                                               value="<?= $distrato['nr_operacao_banco'] ?>"/>
                                    </div>
                                    <div class="col-sm-6 <?= ($distrato['tp_conta'] == 'X') ? 'hidden' : '' ?>" id="dadosBancoDiv">
                                        <div class="col-sm-4 form-group">
                                            <label for="nrAgencia" class="control-label">
                                                Agncia:
                                            </label>
                                            <input name="agencia" type="text"
                                                   class="soNumero form-control "
                                                   value="<?= $distrato['nr_agencia_banco']; ?>"/>
                                        </div>
                                        <div class="form-group col-sm-2">
                                            <label for="nrAgenciaDv" class="control-label">D.v.: </label>
                                            <input name="agencia_dv" type="text" class="form-control "
                                                   value="<?= $distrato['nr_dv_agencia_banco']; ?>"/>
                                        </div>
                                        <div class="col-sm-4 form-group">
                                            <label for="nrConta" class="control-label col-sm-12" style="padding: initial;">
                                                Conta:
                                            </label><br>
                                            <input name="conta_corrente" type="text" maxlength="10"
                                                   class="soNumero  form-control"
                                                   value="<?= $distrato['nr_conta_corrente_banco']; ?>"/>
                                        </div>
                                        <div class="form-group col-sm-2">
                                            <label for="nrContaDv" class="control-label">
                                                D.v.:
                                            </label>
                                            <input name="conta_corrente_dv" class="form-control "
                                                   type="text"
                                                   value="<?= $distrato['nr_dv_conta_corrente_banco']; ?>"/>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group col-sm-6">
                                            <label class="control-label">Tipo de conta: </label>
                                            <br>
                                            <div class="checkbox">
                                                <label style="font-weight: 600 !important;">
                                                    <input type="radio" name="tp_conta" checked id="contaCorrente" class="form-control icheck radioFavorecido control-label"
                                                        <?= ($distrato['tp_conta'] == 'C') ? 'checked' : '' ?> value="C" > Conta Bancria
                                                </label>
                                                <label style="font-weight: 600 !important;">
                                                    <input type="radio" name="tp_conta" id="pix" class="form-control icheck radioFavorecido control-label"
                                                        <?= ($distrato['tp_conta'] == 'X') ? 'checked' : '' ?> value="X"> Pix
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group col-sm-4 <?= ($distrato['tp_conta'] != 'X') ? 'hidden' : '' ?>" id="pixTipo">
                                            <label class="control-label" for="tipoPix">Tipo de chave PIX: </label>
                                            <br>
                                            <div class="checkbox">
                                                <label style="font-weight: 600 !important;">
                                                    <input type="radio" name="tipo_pix" checked id="chaveCPF" class="form-control icheck radioFavorecido control-label"
                                                        <?= ($distrato['tipo_pix'] == 'C') ? 'checked' : '' ?> value="C" > CPF/CNPJ
                                                </label>
                                                <label style="font-weight: 600 !important;">
                                                    <input type="radio" name="tipo_pix" id="chaveEmail" class="form-control icheck radioFavorecido control-label"
                                                        <?= ($distrato['tipo_pix'] == 'E') ? 'checked' : '' ?> value="E"> E-mail
                                                </label>
                                                <label style="font-weight: 600 !important;">
                                                    <input type="radio" name="tipo_pix" id="chaveTelefone" class="form-control icheck radioFavorecido control-label"
                                                        <?= ($distrato['tipo_pix'] == 'T') ? 'checked' : '' ?> value="T"> Telefone
                                                </label>
                                                <label style="font-weight: 600 !important;">
                                                    <input type="radio" name="tipo_pix" id="chaveAleatoria" class="form-control icheck radioFavorecido control-label"
                                                        <?= ($distrato['tipo_pix'] == 'A') ? 'checked' : '' ?> value="A"> Aleatria
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-12 tipoConta">
                                        <div class="form-group col-sm-5" id="contaTipo">
                                            <label class="control-label" for="tipoConta">Tipo de Conta Bancria: </label>
                                            <br>
                                            <div class="checkbox" style="min-width: 50px;">
                                                <label style="font-weight: 600 !important; white-space: nowrap;">
                                                    <input type="radio" name="tipo_conta" checked id="contaCorrente" class="form-control icheck radioFavorecido control-label"
                                                        <?= ($distrato['tipo_conta'] == 'C') ? 'checked' : '' ?> value="C" > Conta Corrente
                                                </label>
                                                <label style="font-weight: 600 !important; white-space: nowrap;">
                                                    <input type="radio" name="tipo_conta" id="contaPoupana" class="form-control icheck radioFavorecido control-label"
                                                        <?= ($distrato['tipo_conta'] == 'P') ? 'checked' : '' ?> value="P"> Conta Poupana
                                                </label>
                                                <label style="font-weight: 600 !important; white-space: nowrap;">
                                                    <input type="radio" name="tipo_conta" id="contaJuridica" class="form-control icheck radioFavorecido control-label"
                                                        <?= ($distrato['tipo_conta'] == 'J') ? 'checked' : '' ?> value="J"> Conta Judicial
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            </div>
                        </fieldset>

                        <fieldset>
                            <legend>Operaes</legend>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-2">
                                        <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Salvar">
                                    </div>
                                    <div class="form-group col-sm-2">
                                        <a href="?m=adm&c=distrato&a=listar"
                                           class="btn btn-danger col-sm-12">Cancelar </a>
                                    </div>
                                </div>
                            </div>
                        </fieldset>

                    </form>

                </div>
        </div>
    </div>
<div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg ">
        <div class="modal-content">

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"
                        aria-hidden="true">&times;</button>
                <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                    Tutorial</h2>
            </div>

            <div class="modal-body tableFix" style="max-height:600px;">
                <fieldset >
                    <legend>Distrato - Cadastro, Edio, e desfazer distrato e seus termos</legend>
                    <div class="row" style="margin-right: 0px;margin-left: 0px;">
                        <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/3MYp3vNgQow?si=4gNRvkLFX-F5paof" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>                        
                    </div>
                    <div></div>
                </fieldset>
            </div>
        </div>
    </div>
</div>
<?php require_once 'layout/includes/footer.php'; ?>
