<?php
$empreendimento = $this->get('empreendimento');
$empresa = $this->get('clienteAcade');
$lote = $this->get('lote');
$cliente = $this->get('cliente');
$contrato = $this->get('contrato');
$outrosCompradores = $this->get('pessoas_envolvidas');
$sinal = $this->get('sinal');
$banco = $this->get('banco');

if ($contrato['fl_itens_contrato'] == 1)
    $adicionais = $this->get('adicionais');

$assinaturas = $this->get('assinatura');
foreach ($assinaturas as $assinatura) {
    $vendedores[] = Pessoa::findById($assinatura['id_pessoa']);
}
$cidadeEmpreedimento = array();
if ($cidadeEmpreedimento = Db_Cidade::find($empreendimento['cd_cidade']))
    $cidadeEmpreedimento = $cidadeEmpreedimento->toArray();
$itensContrato = $this->get('itensContrato');

$vlsinal = ($contrato['vl_sinal'] > 0 && $contrato['inclui_sinal_contrato']) ? $contrato['vl_sinal'] : 0;
$total = 0;
$total += ($contrato['vl_total'] > 0) ? $contrato['vl_total'] : 0;
$total += $vlsinal;
$total += ($contrato['vl_parcela'] > 0) ? $contrato['nr_parcela'] * $contrato['vl_parcela'] : 0;
$total += ($contrato['vl_intercalada'] > 0) ? $contrato['vl_intercalada'] * $contrato['nr_intercalada'] : 0;
$total += ($contrato['vl_parcela_entrega'] > 0) ? $contrato['vl_parcela_entrega'] * $contrato['nr_parcela_entrega'] : 0;
if (isset($adicionais))
    foreach ($adicionais as $item)
        $total += $item['valor'] * $item['qtd'];

$primeiroDia = date_parse_from_format('Y-m-d', $contrato['dt_primeira_parcela'])['day'];
$ultimaParcela = date('Y-m-d', strtotime("+" . $contrato['nr_parcela'] . " month", strtotime($contrato['dt_primeira_parcela'])));

$arrData = explode("-", $contrato['dt_contrato']);
$dia = $arrData[2];
$mes = $arrData[1];
$ano = $arrData[0];
?>
<style type="text/css">

    .conteudoPdf {
        font-size: 12px; 
        display: inline-block;
    }

    #titulo1 {
        width: 700px;
        font-size: 13pt; 
    }

    #titulo2 {
        width: 700px;
        font-size: 12pt; 
    }

    .texto {
        font-size: 12px; 
        border-collapse: collapse;
        width:500px
    }

    .texto table, th, td {
        border: 1px solid black;
        padding: 5px;
    }

</style>


<page backtop="0mm" backbottom="0mm" backleft="0mm" backright="0mm">
    <div class="conteudoPdf" width="640px">
        <div id="titulo1" align="center">
            CONTRATO PARTICULAR DE COMPROMISSO DE COMPRA E VENDA
            DO <?= strtoupper($empreendimento['nm_empreendimento']) ?>
        </div>
        <br/>
        <br/>
        <br/>
        <div id="titulo2">
            ATRVES DESTE CONTRATO PARTICULAR, AS PARTES TM CERTA E AJUSTADA A NEGOCIAO DO A SEGUIR IDENTIFICADO, DE
            ACORDO COM AS CLUSULAS E CONDIES ADIANTE ESTABELECIDAS:
        </div>
        <br>

        <div>
            <p class="texto">
                <strong>I - DAS PARTES CONTRATANTES: </strong>
                <br>
                <br>
                <strong style="margin-left: 40px">A) DO(S) VENDEDOR(ES):</strong>
                <?= Helper::str2Upper($this->get('citacaoDados')); ?>
                <?= Helper::str2Upper($empreendimento['ds_procuracao']); ?>
                <br>
                <br>
                <strong style="margin-left: 40px">B) DO(S) COMPRADOR(ES):</strong>
                DORAVANTE DENOMINADO(A)(S), INDEPENDENTE DO NMERO OU GNERO, COMO COMPRADOR:<br>
            </p>
        </div>
        <div>
            <table class="texto">
                <tr>
                    <td colspan="3" style="width: 600px">NOME:
                        <strong><?= Helper::str2Upper($cliente['nm_pessoa']) ?></strong></td>
                </tr>
                <tr>
                    <td colspan="2">NACIONALIDADE:
                        <strong><?= Helper::str2Upper($cliente['nm_nacionalidade']) ?></strong></td>
                    <td>CPF: <strong><?= $cliente['nr_cpf'] ?></strong></td>
                </tr>
                <tr>
                    <td colspan="2">PROFISSO: <strong><?= Helper::str2Upper($cliente['nm_profissao']) ?></strong></td>
                    <td>ESTADO CIVIL: <strong><?= Helper::str2Upper($cliente['est_civil_nome']) ?></strong></td>
                </tr>
                <tr>
                    <td colspan="2">EMAIL: <strong><?= $cliente['email'] ?></strong></td>
                    <td>R.G.: <strong><?= $cliente['nr_rg'] ?></strong></td>
                </tr>
                <tr>
                    <td colspan="3">END.RES.:
                        <strong><?= Helper::str2Upper($cliente['endereco']) ?><?= ($cliente['nr_endereco']) ? ', ' . $cliente['nr_endereco'] : '' ?></strong>
                    </td>
                </tr>
                <tr>
                    <td>BAIRRO: <strong><?= Helper::str2Upper($cliente['nm_bairro']) ?></strong></td>
                    <td>CEP: <strong><?= $cliente['nr_cep'] ?></strong></td>
                    <td>TELEFONE: <strong><?= $cliente['nr_telefone'] ?></strong></td>
                </tr>
                <?php if (($cliente['est_civil'] == 'CAS' || $cliente['est_civil'] == 'UNE') && $cliente['conjugeP']) : ?>
                    <tr>
                        <td colspan="3" style="width: 670px">CONJUGE:
                            <strong><?= Helper::str2Upper($cliente['conjugeP']['nm_pessoa']) ?></strong></td>
                    </tr>
                    <tr>
                        <td colspan="2">NACIONALIDADE:
                            <strong><?= Helper::str2Upper($cliente['conjugePF']['nm_nacionalidade']) ?></strong></td>
                        <td>PROFISSO: <strong><?= Helper::str2Upper($cliente['conjugePF']['nm_profissao']) ?></strong>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2">CPF: <strong><?= $cliente['conjugePF']['nr_cpf'] ?></strong></td>
                        <td>R.G.: <strong><?= $cliente['conjugePF']['nr_rg'] ?></strong></td>
                    </tr>
                <?php endif; ?>
            </table>
            <br/>
            <?php if (count($outrosCompradores)) : ?>
                <?php foreach ($outrosCompradores as $comprador) : ?>
                    <table class="texto">
                        <tr>
                            <td colspan="3" style="width: 670px">NOME:
                                <strong><?= Helper::str2Upper($comprador['nm_pessoa']) ?></strong></td>
                        </tr>
                        <tr>
                            <td colspan="2">NACIONALIDADE:
                                <strong><?= Helper::str2Upper($comprador['nm_nacionalidade']) ?></strong></td>
                            <td>CPF: <strong><?= $comprador['nr_cpf'] ?></strong></td>
                        </tr>
                        <tr>
                            <td colspan="2">PROFISSO:
                                <strong><?= Helper::str2Upper($comprador['nm_profissao']) ?></strong></td>
                            <td>ESTADO CIVIL: <strong><?= Helper::str2Upper($comprador['est_civil_nome']) ?></strong>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">EMAIL: <strong><?= $comprador['email'] ?></strong></td>
                            <td>R.G.: <strong><?= $comprador['nr_rg'] ?></strong></td>
                        </tr>
                        <tr>
                            <td colspan="3">END.RES.:
                                <strong><?= Helper::str2Upper($comprador['endereco']) ?><?= ($comprador['nr_endereco']) ? ', ' . $comprador['nr_endereco'] : '' ?></strong>
                            </td>
                        </tr>
                        <tr>
                            <td>BAIRRO: <strong><?= Helper::str2Upper($comprador['nm_bairro']) ?></strong></td>
                            <td>CEP: <strong><?= $comprador['nr_cep'] ?></strong></td>
                            <td>TELEFONE: <strong><?= $comprador['nr_telefone'] ?></strong></td>
                        </tr>
                    </table>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>

        <div>
            <p class="texto">
                <strong>II - DO OBJETO DA TRANSAO: </strong><br>
                LOTE NO <?= Helper::str2Upper($empreendimento['tipo']) ?>
                <?= Helper::str2Upper($empreendimento['nm_empreendimento']) ?>
                APROVADO PELO MUNICPIO E REGISTRADO SOB
                <strong><?= Helper::str2Upper($lote['rgi']) ?></strong>.
                <br>
                <br>
                DESCRIO E MEDIDAS
            </p>
            <table class="texto" style="margin-left: 55px;">
                <tr>
                    <td style="width: 160px" align="center">QUADRA N</td>
                    <td style="width: 160px" align="center">LOTE N</td>
                    <td style="width: 160px" align="center">REA M</td>
                </tr>
                <tr>
                    <td style="width: 160px" align="center"><strong><?= $lote['quadra'] ?></strong></td>
                    <td style="width: 160px" align="center"><strong><?= $lote['lote'] ?></strong></td>
                    <td style="width: 160px" align="center"><strong><?= Helper::getMoney($lote['area']) ?></strong></td>
                </tr>
                <tr>
                    <td colspan="3">
                        LOGRADOURO: <strong><?= Helper::str2Upper($lote['conf_frente']) ?></strong>
                    </td>
                </tr>
            </table>
            <br>
            <p class="texto">
                PARA TODOS OS EFEITOS, A METRAGEM QUADRADA, CHANFRADOS, VARIANTES, CONFRONTAES, MEDIDAS FRONTAIS,
                LATERAIS E DE FUNDO DO LOTE SO AS CONSTANTES DO PROJETO APROVADO PELO MUNICPIO.
            </p>
        </div>

        <div>
            <p class="texto">
                <strong>III - DA VENDA, DO PREO E DAS CONDIES DE PAGAMENTO DO LOTE <br></strong>
                <br>
                <strong>A) DA VENDA A VISTA - PREO:</strong> R$ <?= Helper::getMoney($lote['valor']) ?>
                <br>
                <br>
                <span style="font-size: 12px "><strong>B) DA VENDA A PRAZO (COM PARCELA REAJUSTADA, COM CORREO MONETRIA E COM JUROS)</strong><br><br>
                CASO AS PARTES ESCOLHAM A NEGOCIAO A PRAZO, <strong><u>COM PARCELAS DO TIPO REAJUSTVEIS (COM CORREO
                            MONETRIA E COM JUROS)</u></strong>, O VALOR TOTAL E FINAL DO LOTE SER PS-FIXADO E SER A SOMA DO SINAL DE
                NEGCIO, DA ENTRADA (QUANDO HOUVER) E DO SALDO A PARCELAR REAJUSTADOO PELO VARIAO DO NCIDE DE
                CORREO MONETRIA E POR JUROS COMPENSATRIOS.</span>
            </p>
        </div>

        <?php if (count($sinal)) : ?>
            <div>
                <p class="texto" style="font-size: 12px ">
                    <strong>B.1) DA VENDA A PRAZO - SINAL DE NEGCIO:
                        R$<?= Helper::getMoney($contrato['vl_sinal']) ?></strong>
                </p>
                <table class="texto" style="margin-left: 50px;">
                    <tr>
                        <td style="width: 100px" align="center">N PARCELAS</td>
                        <td style="width: 100px" align="center">VALOR PARCELA</td>
                        <td style="width: 100px" align="center">VENC. PARCELA</td>
                        <td style="width: 100px" align="center">PERIODICIDADE</td>
                        <td style="width: 100px" align="center">TIPO</td>
                    </tr>
                    <?php foreach ($sinal as $s) : ?>
                        <tr>
                            <td align="center"><strong><?= $s['parcela'] . '/' . count($sinal) ?></strong></td>
                            <td align="center"><strong><?= Helper::getMoney($s['valor']) ?></strong></td>
                            <td align="center"><strong><?= Helper::getDate($s['dtVencimento']) ?></strong></td>
                            <td align="center"><strong>MENSAL</strong></td>
                            <td align="center"><strong>FIXO</strong></td>
                        </tr>
                    <?php endforeach; ?>
                </table>
            </div>
        <?php endif; ?>
        <div>
            <p class="texto" style="font-size: 12px ">
                <strong>B.2) DA VENDA A PRAZO - <?= $contrato['fl_itens_contrato'] == 0 ? '' : 'ENTRADA' ?>
                    R$<?= Helper::getMoney($contrato['vl_parcela'] * $contrato['nr_parcela']) ?>
                    (<?= $contrato['nr_parcela'] ?> PRIMEIRAS PARCELAS)</strong>
            </p>
            <table class="texto" style="margin-left: 50px;">
                <tr>
                    <td style="width: 100px" align="center">N PARCELAS</td>
                    <td style="width: 100px" align="center">VALOR PARCELA</td>
                    <td style="width: 100px" align="center">VENC. 1 PARCELA</td>
                    <td style="width: 100px" align="center">PERIODICIDADE</td>
                    <td style="width: 100px" align="center">TIPO</td>
                </tr>
                <tr>
                    <td align="center"><strong><?= $contrato['nr_parcela'] ?></strong></td>
                    <td align="center"><strong><?= Helper::getMoney($contrato['vl_parcela']) ?></strong></td>
                    <td align="center"><strong><?= Helper::getDate($contrato['dt_primeira_parcela']) ?></strong></td>
                    <td align="center"><strong>MENSAL</strong></td>
                    <td align="center">
                        <strong><?= ($contrato['fl_reajustavel_mensais'] == 0) ? 'FIXO' : 'REAJUSTVEL' ?></strong>
                    </td>
                </tr>
            </table>
        </div>
        <?php if ($itensContrato['N'] && count($itensContrato['N'])) : ?>
            <?php foreach ($itensContrato['N'] as $k => $normal) : ?>
                <div>
                    <p class="texto" style="font-size: 12px ">
                        <strong>B.<?= 3 + $k ?>) DA VENDA A PRAZO - SALDO A PARCELAR DE
                            R$<?= Helper::getMoney($normal['vl_parcela'] * $normal['qt_parcelas']) ?>
                            (<?= $normal['qt_parcelas'] ?> PARCELAS)</strong>
                    </p>
                    <?php
                    $primeira = date('Y-m-d', strtotime("+" . ($contrato['nr_parcela'] + 1) . " month", strtotime($contrato['dt_primeira_parcela'])));
                    ?>
                    <table class="texto" style="margin-left: 50px;">
                        <tr>
                            <td style="width: 100px" align="center">N PARCELAS</td>
                            <td style="width: 100px" align="center">VALOR PARCELA</td>
                            <td style="width: 100px" align="center">VENC. 1 PARCELA</td>
                            <td style="width: 100px" align="center">PERIODICIDADE</td>
                            <td style="width: 100px" align="center">TIPO</td>
                        </tr>
                        <tr>
                            <td align="center"><strong><?= $normal['qt_parcelas'] ?></strong></td>
                            <td align="center"><strong><?= Helper::getMoney($normal['vl_parcela']) ?></strong></td>
                            <td align="center"><strong><?= Helper::getDate($primeira) ?></strong>
                            </td>
                            <td align="center"><strong>MENSAL</strong></td>
                            <td align="center">
                                <strong><?= ($normal['fl_reajustavel'] == 0) ? 'FIXO' : 'REAJUSTVEL' ?></strong>
                            </td>
                        </tr>
                    </table>
                    <br>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
        <div style="text-align: justify">
            <p class="texto" style="text-align: justify">
                B.4) DA VENDA A PRAZO DO LOTE - PREO INICIAL <strong>R$ <?= Helper::getMoney($total) ?> </strong> <br>
                <br>
                <u style="text-align: justify"><strong style="text-align: justify">TERMO DE CINCIA DE CONDIO
                        SUSPENSIVA: SE, TRANSCORRIDO O PRAZO DE 60 (SESSENTA) DIAS DE
                        ATRASO NO PAGAMENTO DE QUALQUER PARCELA DO SINAL DO NEGCIO (ITEM II, LETRA B.1),
                        ESTE CONTRATO NO PRODUZIR OS EFEITOS PRETENDIDOS PELAS PARTES,
                        TORNANDO-SE AUTOMATICAMENTE DESFEITO, DE PLENO DIREITO, INDEPENDENTEMENTE DE AVISO OU
                        NOTIFICAO,
                        HIPTESE EM QUE O COMPRADOR PERDER O VALOR EVENTUALMENTE PAGO, LIMITADO A 10% (DEZ POR CENTO)
                        DO VALOR TOTAL DESTE CONTRATO, A TTULO DE SINAL DE NEGCIO (ARRAS PENITENCIAIS,
                        CONFORME PREVISTO NO ART. 418 DO CDIGO CIVIL),
                        E EVENTUAL VALOR EXCEDENTE SER DEVOLVIDO AO COMPRADOR NO PRAZO MXIMO DE 30 (TRINTA)
                        DIAS EM CASO DE PAGAMENTO SOMENTE DO SINAL DE NEGCIO, E NA MESMA QUANTIDADE PARCELAS PAGAS,
                        EM CASO DE J TER INICIADO O PAGAMENTO DAS PARCELAS.
                    </strong></u>
            </p>
        </div>
        <div style="text-align: justify">
            <p class="texto" style="text-align: justify">
                <u style="text-align: justify"><strong style="text-align: justify">B.5) O COMPRADOR, NESTE ATO,
                        SE CONFESSA DEVEDOR E RECONHECE COMO DVIDA LQUIDA E CERTA,
                        O MONTANTE CORRESPONDENTE AO SALDO DO PREO ACIMA, OBRIGANDO-SE A EFETUAR SEU PAGAMENTO
                        INTEGRAL NA FORMA POR ELE ESCOLHIDA E EMITE EM FAVOR DOS VENDORES, COM CLUSULAS DE ORDEM E EM
                        CARTER PR-SOLVENDO, NOTAS PROMISSRIAS REPRESENTATIVAS DAS PRESTAES DE AMORTIZAO DO PREO
                        SUPRA REFERIDO POR SEUS VALORES NESTA DATA, COM REFERNCIA NO VERSO DA NOTA PROMISSRIA
                        DA CORREO MONETRIA, PELO IGPM-FGV (NDICE GERAL DE PREOS DE MERCADO DA FUNDAO
                        GETLIO VARGAS), CONFORME PREVISTO NA CLUSULA SEGUNDA.
                    </strong></u>
            </p>
        </div>

        <div>
            <p class="texto">
                <strong>IV - DAS INFORMAES CADASTRAIS</strong><br>
                <br>
                O COMPRADOR DECLARA QUE AS INFORMAES CADASTRAIS FORNECIDAS AOS VENDEDORES SO VERDADEIRAS, SOB PENA DE
                RESPONSABILIDADE CIVIL E CRIMINAL.
            </p>
        </div>

        <div>
            <p class="texto">
                <strong>V - DAS CONSIDERAES INICIAIS</strong><br>
                <br>
                <strong><u>1) DO PRVIO CONHECIMENTO DO CONTEDO DESTE CONTRATO:</u></strong><br><br>
                AO COMPRADOR FOI DADA A OPORTUNIDADE DE TOMAR CONHECIMENTO PRVIO DE TODO O CONTEDO DESTE CONTRATO,
                SENDO DEVIDAMENTE ESCLARECIDAS TODAS AS CLUSULAS E CONDIES NELE CONSTANTES, EM CONFORMIDADE COM O QUE
                DETERMINA OS ARTIGOS 6, INCISO III E 46 DO CDIGO DE DEFESA DO CONSUMIDOR.
                <br>
                <br>
                <strong><u>2) DAS CLSULAS EM DESTAQUE:</u></strong><br><br>
                <strong><u>EM CONFORMIDADE AO QUE DETERMINA O CDIGO DE DEFESA DO CONSUMIDOR E O SISTEMA DE PROTEO AO
                        CONSUMIDOR, ESTE CONTRATO EST TODO EM LETRA MAISCULA NO FORMATO 12 E CONTM DESTAQUES EM
                        NEGRITO E SUBLINHADO NAS CLSULAS E PONTO DE MAIOR RELEVNCIA.
                    </u></strong>
                <br>
                <br>
                <br>
                <strong><u>3) DO EQUILBRIO ECONMICO FINANCEIRO E DO REAJUSTE DO SALDO A PARCELAR:</u></strong>
                <br><br>
                <strong><u>NESTE ATO, POR SE TRATAR DE CONTRATO LONGO PRAZO, OS VENDEDORES E O COMPRADOR PACTUAM, NA
                        CLSULA 2 DESTE CONTRATO, AS REGRAS DE REAJUSTE DO SALDO A PARCELAR, COM MAIS DE 12 MESES,
                        (APLICAO DE CORREO MONETRIA - I.G.P.M/F.G.V. - E JUROS COMPENSATRIOS - 0,94 % A.M (ZERO
                        VGULA NOVENTA E QUATRO POR CENTO AO MS) OU SEJA, 11,28% A.A. (ONZE VIRGULA VINTE E OITO POR
                        CENTO AO ANO) - SOBRE O VALOR. PORTANTO, RECONHECEM EXPRESSAMENTE QUE O REAJUSTE DO SALDO A
                        PARCELAR  CONDIO ESSENCIAL E IRREVOGVEL DESTE NEGCIO, VISANDO PROTEGER O EQUILBRIO
                        ECONMICO-FINANCEIRO ENTRE AS PARTES, EM CONFORMIDADE COM O QUE PERMITE O PARGRAFO 3 DO ARTIGO
                        1, DO DECRETO-LEI N 22.626/33.
                    </u></strong><br>
                <br>
                <strong><u>4) DA EVENTUAL ANTECIPAO DE PARCELA DE PARCELAS A VENCER:</u></strong>
                <br>
                <br>CASO O COMPRADOR QUEIRA, NO TRANSCORRER DESTE NEGCIO, ANTECIPAR O PAGAMENTO TOTAL OU PARCIAL DE
                QUALQUER PARCELA A VENCER, FICA DESDE J CIENTE DE QUE O SALDO DEVEDOR SER SEMPRE ATUALIZADO,
                PRO RATA DIE, COM A CORREO MONETRIA PACTUADOS NESTE CONTRATO, SOMENTE AT A DATA DA EVENTUAL
                ANTECIPAO. SENDO ASSIM, A CORREO MONETRIA AINDA NO ESTARO APLICADOS. O COMPRADOR NO
                PODER EXIGIR DOS VENDEDORES A REDUO PROPORCIONAL OU O DESCONTO CONFORME NO PARGRAFO 2, DO
                ARTIGO 52 DO CDIGO DE DEFESA DO CONSUMIDOR.<br><br>
                J OS JUROS COMPENSATRIOS NO VALOR DE 0,94% A.M. (ZERO PONTO NOVENTA E QUATRO POR CENTO AO MS)
                OU SEJA, 11,28% A.A. (ONZE VIRGULA VINTE E OITO POR CENTO AO ANO) EM CASO DE ANTECIPAO DOS
                VALORES SERO OBJETO DE NEGOCIAO EM FORMA DE REDUO PROPORCIONAL OU O DESCONTO DE JUROS
                CONFORME NO PARGRAFO 2, DO ARTIGO 52 DO CDIGO DE DEFESA DO CONSUMIDOR.
                <br>
                <br>
                <strong><u>5) DAS LIBERDADES:</u></strong>
                <br><br>
                <strong><u>QUALQUER TOLERNCIA OU CONCESSO DOS VENDEDORES, RELATIVA A OBRIGAES DO COMPRADOR
                        DECORRENTE DESTE CONTRATO, SER CONSIDERADA MERA LIBERALIDADE, NO IMPORTANDO EM NOVAO OU
                        RENNCIA DE DIREITOS.
                    </u></strong>
                <br>
                <br>
                <strong><u>6) DO PRAZO DE ENTREGA DAS OBRAS E TERMO DE AJUSTAMENTO DE CONDUTA - TAC:</u></strong>
                <br><br>
                AS OBRAS DE INFRAESTRUTURA E PRAZO DE ENTREGAS ESTO PREVISTAS NA CLAUSULA 10 DESTE
                CONTRATO. SENDO QUE O <strong><u>PROMITENTE COMPRADOR DECLARA TER CINCIA QUE ESSE LOTEAMENTO FOI OBJETO
                        DE TERMO DE AJUSTAMENTO DE CONDUTA - TAC, ASSINADO JUNTO AO MINISTRIO PBLICO ESTADUAL,
                        PREFEITURA MUNICIPAL DE RIO BRANCO E LOTEADORES, EM 24/02/2015, ONDE CONSTA AS OBRIGAES DOS
                        LOTEADORES E QUEM VAI EXECUTAR AS OBRAS DE INFRAESTRUTURA NO RESIDENCIAL ROSA LINDA, CUJA CPIA
                        ESTA DISPONVEL NA IMOBILIRIA FORTALEZA PARA CONFERNCIA.
                    </u></strong>
            </p>
            <br>
        </div>
    </div>
</page>

<page backtop="10mm" backbottom="10mm" backleft="10mm" backright="10mm">
    <div class="conteudoPdf">
        <div>
            <p class="texto">
                <strong>VII - DAS CLUSULAS E CONDIES CONTRATUAIS</strong><br>
                <br>
                <strong>CLUSULA 1: DA VENDA  VISTA DO LOTE - DO PAGAMENTO <br><br>
                    <u>NAS VENDAS  VISTA, O COMPRADOR DEVER OBRIGATORIAMENTE EFETUAR O PAGAMENTO DO PREO DO LOTE
                        DIRETAMENTE NO ESCRITRIO DA IMOBILIRIA FORTALEZA LTDA, QUE  A ADMINSTRADORA DO LOTEAMENTO,
                        ATRAVS DE CHEQUE NOMINAL/DEPSITO BANCRIO/BOLETO BANCRIO, QUE DEVER SER PAGO EM QUALQUER
                        AGNCIA DA REDE INTEGRADA DE COBRANA. <br><br>
                         1 - SE O COMPRADOR NO EFETUAR O PAGAMENTO CONFORME PREVISTO NESTA CLUSULA, NO PODER
                        EXIGIR DOS VENDEDORES TERMO DE QUITAO E AUTORIZAO PARA ESCRITURA, ISENTANDO AOS VENDEDORES
                        DE QUALQUER RESPONSABILIDADE DECORRENTE DESTE ATO.</u></strong><br><br>
                 2- APS A COMPROVAO DE LIQUIDAO DO CHEQUE OU BOLETO BANCRIO OU INDETIFICAO DA TRANSFERENCIA
                BANCRIA, OS VENDEDORES EMITIRO TERMO DE QUITAO E AUTORIZAO PARA OUTORGA DE ESCRITURA DE
                TRANSFERNCIA DO LOTE EM NOME DO COMPRADOR OU DE QUEM ELE INDICAR, CONFORME CLUSULA 21 DESTE CONTRATO.<br><br><br><br>
            </p>
            <p class="texto">
                <strong>CLUSULA 2: DA VENDA A PRAZO DO LOTE - DA FORMA DE REAJUSTE DAS PARCELAS <br><br>
                    <u>CASO O COMPRADOR TENHA OPTADO PELO PAGAMENTO DO PREO DO LOTE A PRAZO, ESTABELECIDO QUE 
                        CONDIO ESSENCIAL E IRREVOGVEL DESTE CONTRATO A APLICAO DAS REGRAS DE CORREO MONETRIA E
                        JUROS COMPENSATRIOS, CONFORME ESTABELECIDO NESTA CLUSULA.<br><br>
                        DATA BASE DO CONTRATO PARA EFEITO DE REAJUSTE DAS
                        PARCELAS: <?= Helper::getDate($contrato['dt_contrato']) ?><br><br>
                        - PARA APLICAO DO NDICE DE CORREO MONETRIA:</u></strong>
                DIA <?= $dia ?> DO MS DE ASSINATURA DESTE CONTRATO.<br/><br>
                A DATA DE REFERNCIA PARA O CLCULO DA VARIAO MENSAL ACUMULADA DO NDICE DE CORREO MONETRIA SER O
                MS IMEDIATAMENTE ANTERIOR  DATA DE ASSINATURA DESTE CONTRATO.<br><br>
                <strong><u>- PARA APLICAO DOS JUROS COMPENSATRIOS:</u></strong> DATA DA ASSINATURA DESTE
                CONTRATO.<br><br>
                <strong><u>- NDICE PACTUADO PARA CORREO MONETRIA:</u></strong> I.G.P.M./F.G.V. (NDICE GERAL DE
                PREOS DO MERCADO), DIVULGADO MENSALMENTE PELA FUNDAO GETLIO VARGAS.<br><br>
                <strong><u>NDICE SUBSTITUTIVO PARA CORREO MONETRIA:</u></strong> NO CASO DE EXTINO, REVOGADO
                LEGAL, PROIBIO, CONGELAMENTO OU NO PUBLICAO DO I.G.P.M/F.G.V., SER UTILIZADO AUTOMATICAMENTE O
                NOVO NDICE OFICIAL INDICADO PARA SUBSTITU-LO. EM CASO DE NO INDICAO DE NDICE SUBSTITUTIVO, SER
                ADOTADO NESTE CONTRATO O I.N.C.C/F.G.V. (NDICE NACIONAL DO CUSTO DE CONSTRUO), DIVULGADO MENSALMENTE
                PELA FUNDAO GETLIO VARGAS.<br><br>
                <strong><u>JUROS COMPENSATRIOS PACTUADOS: 0,94% A.M. (ZERO VRGULA NOVENTA E QUATRO POR CENTO AO MS)
                        OU SEJA 11,28% A.A. (ONZE VIRGULA VINTE E OITO POR CENTO AO ANO).<br><br>
                        FORMA DE APLICAO DOS JUROS COMPENSATRIOS:<br><br>
                        OS JUROS COMPENSATRIOS MENSAL ("JCM") PACTUADOS J SERO APLICADOS SOBRE AS PARCELAS FUTURAS,
                        LOGO AS PARCELAS CONTRATADAS S SERO ATUALIZADAS MONETARIAMENTE, CONFORME PREVISTO
                        ABAIXO.<br><br>
                        FORMA DE APLICAO DA VARIAO DO NDICE DE CORREO MONETRIA (I.G.P.M/F.G.V.):<br><br>
                        A VARIAO MENSAL ACUMULADA DO NDICE DE CORREO MONETRIA ("VMAICM") SER APLICADA SOBRE O
                        VALOR ANTERIOR DA PARCELA ("VAP") UMA VEZ AO ANO, SUCESSIVAMENTE, AT O FIM DESTE CONTRATO E O
                        PAGAMENTO TOTAL DO SALDO A PARCELAR, OBEDECENDO AOS SEGUINTES PASSOS:<br><br>
                        1 PASSO: A CADA PERODO DE 12 (DOZE) MESES, SER APURADA A AVALIAO MENSAL ACUMULADA DOS
                        LTIMOS 12 MESES DO NDICE DE CORREO MONETRIA ("VMAICM"), TENDO COMO REFERNCIA O MS
                        IMEDIATAMENTE ANTERIOR A DATA DE ASSINATURA DESTE CONTRATO.<br><br>
                        2 PASSO: A VARIAO MENSAL ACUMULADA DOS LTIMOS 12 MESES DO NDICE DE CORREO MONETRIA
                        ("VMAICM") SER APLICADA SOBRE O VALOR ANTERIOR DA PARCELA ("VAP"), RESULTADO NO VALOR DA
                        PARCELA CORRIGIDO MONETARIAMENTE ("VPCM"), QUE SER NAS 12 (DOZE) PARCELAS SUBSEGUENTES.<br>
                    </u></strong>
            </p>
            <p class="texto" align="center">
                <strong>REPRESENTAO DA EQUAO: VAP + (VAPxVMAICM)= VPCM</strong>
            </p>
            <p class="texto">
                 1 - O NDICE DE CORREO MONETRIA E OS JUROS COMPENSATRIOS SERO CALCULADOS PRORATA-DIA, AT O
                PAGAMENTO TOTAL DOS VALORES DEVIDOS.<br><br>
                 2 - HAVENDO MODIFICAO DA PERIODICIDADE MNIMA LEGAL PARA REAJUSTE DAS PARCELAS, AS PARTES DESDE J
                ACORDAM QUE ELA SER AUTOMATICAMENTE APLICADA A ESTE CONTRATO.<br><br>
                <strong><u> 3 - POR SE TRATAR DE PACTO DE LONGO PRAZO, CUJA VARIAO DO NDICE DE CORREO MONETRIA
                        (I.G.P.M./F.G.V.) A SER APLICADA DEPENDE DE UMA DIVULGAO FUTURA, SEU SALDO DEVEDOR S PODER
                        SER ATUALIZADO APS A DIVULGAO OFICIAL DO INDEXADOR, E, PORTANTO, SER PS-FIXADO SENDO ASSIM,
                        AS PARTES ACORDAM QUE, EM NENHUMA HIPTESE, O SALDO DEVEDOR E O VALOR DAS PARCELAS FICARO
                        SUJEITOS A DESCONTO, DEFLAO, DESINDEXAO OU CONGELAMENTO.</u></strong><br><br>
                 4 - PARA GARANTIR O EQUILBRIO ECONMICO-FINANCEIRO, NOS CONTRATOS COM PRAZO A PARTIR DE 36 (TRINTA E
                SEIS) MESES, OS VENDEDORES PODERO REAJUSTAR AS PARCELAS MENSALMENTE, APLICANDO A VARIAO DO NDICE DE
                CORREO MONETRIA (I.G.P.M./F.G.V.) PACTUADO, NA FORMA DO ART. 46 DA LEI N 10.931/2004. <br><br>
                <strong><u> 5 - TODAS AS PARCELAS DO SALDO A PARCELAR VENCERO SEMPRE NO DIA 05, 15 OU 25 DE CADA MS,
                        DE ACORDO COM A ESCOLHA DO CLIENTE.</u></strong><br><br>
                 6 - AS PARCELAS SERO REPRESENTADAS POR BOLETOS BANCRIOS, OU CARN DE PAGAMENTO, QUE O COMPRADOR
                DEVER RETIRAR NO ESCRITRIO DOS VENDEDORES NO ENDEREO INFORMADO NA CLUSULA 19,  2, DESTE CONTRATO.<br><br>
                <strong><u> 7 - O EXTRAVIO, A NO RETIRADA OU NO RECEBIMENTO DOS BOLETOS BANCRIOS, OU CARNS DE
                        PAGAMENTO, POR QUAISQUER MOTIVOS, NO EXIMEM O COMPRADOR DA RESPONSABILIDADE DE EFETUAR OS
                        PAGAMENTOS PREVISTOS NESTE CONTRATO, NEM CONSTITUEM JUSTIFICATIVA PARA ATRASO, CABENDO AO
                        COMPRADOR, NESSAS HIPTESES, ENTRAR EM CONTATO COM A IMOBILIRIA FORTALEZA LTDA PARA OBTER O
                        BOLETO BANCRIO OU CARN DE PAGAMENTO.</u></strong> <br><br>
                 8 - COM O PAGAMENTO DE QUALQUER PARCELA, NO SE PRESUMEM QUITADAS AS PARCELAS VENCIDAS
                ANTERIORMENTE.<br><br>
                <strong><u> 9 - SE AS PARCELAS NO FOREM PAGAS AT A DATA DO VENCIMENTO, SERO COBRADOS JUROS DE MORA
                        E MULTA MORATRIA LEGAIS, ASSIM COMO A VARIAO DO NDICE DE CORREO MONETRIA
                        (I.G.P.M./F.G.V.), CONFORME PREVISTO NESTA CLUSULA.</u></strong><br><br>
                 10 - O COMPRADOR AUTORIZA AOS VENDEDORES A INCLUIR SEU NOME EM BANCOS DE DADOS DE
                INADIMPLENTES 15 (QUINZE) DIAS APS VENCIDA E NO PAGA QUALQUER OBRIGAO FINANCEIRA DECORRENTE DESTE
                CONTRATO.<br><br>
                <strong><u> 11 - COM O ATRASO DE QUALQUER PAGAMENTO, O COMPRADOR DESDE J FICA CIENTE DE QUE OS
                        VENDEDORES PODERO PROTESTAR OS TTULOS VENCIDOS E NO PAGOS HIPTESE EM QUE CORRERO POR SUA
                        CONTA OS EMOLUMENTOS CARTORRIOS (TAXAS, CUSTAS, DILIGNCIAS, EDITAIS, HONORRIOS, ETC). SE DE
                        ALGUMA FORMA DESPESAS FOREM PAGAS PELOS VENDEDORES, ELES PODERO EXIGIR O REEMBOLSO DOS VALORES
                        PAGOS, ACRESCIDOS DE JUROS E MULTA MORATRIA LEGAIS, ASSIM COMO A VARIAO DO NDICE DE CORREO
                        MONETRIA (I.G.P.M./F.G.V.), CONFORME PREVISTO NESTA CLUSULA, A SEREM PAGOS ATRAVS DE BOLETO
                        BANCRIO.</u></strong><br><br>
            </p>
            <p class="texto">
                <strong>CLUSULA 3: DA TRANSMISSO DA POSSE PROVISRIA <br><br>
                    <u>APS A SUPERAO DA CONDIO SUSPENSIVA (PAGAMENTO INTEGRAL DO SINAL DE NEGCIO) PREVISTA NO ITEM
                        II, B.1 DESTE CONTRATO, SER TRANSFERIDA AUTOMATICAMENTE AO COMPRADOR A POSSE PROVISRIA DO LOTE<br><br>
                         1 - NESTE ATO, O COMPRADOR DECLARA TER VISTORIADO E CONFERIDO O LOTE E SUA RESPECTIVA
                        LOCALIZAO GEOGRFICA NO LOTEAMENTO (LOGRADOURO, QUADRA, MARCOS DIVISRIAS E TOPOGRAFIA) E
                        TAMBM NO GERAL DO EMPREENDIMENTO, NO TENDO NADA A RECLAMAR.</u></strong><br><br>
                 2 - OS VENDEDORES NO SO OBRIGADOS A FAZER ATERROS, ESCAVAES, COMPACTAES, MOVIMENTAES DE TERRA
                NO LOTE, NEM SE RESPONSABILIZA PELA EXISTENCIA E REMOO DE LAJES, PEDRAS, ARVORES E TOCOS,  MOSTRA OU
                ENTERRADOS, QUE POSSAM DE ALGUMA FORMA, DIFICULTAR A CONSTRUO.<br><br>
                 3 - OS VENDEDORES NO SE RESPONSABILIZAM PELA EXISTNCIA OU NO DE GUA NO SOLO OU SUBSOLO DO
                LOTE.<br><br>
                 4 - DESDE J, O COMPRADOR AUTORIZA AOS VENDEDORES OU AS CONCESSIONRIAS DE SERVIOS PBLICOS A, SE
                NECESSRIO E/OU POR EXIGNCIA TCNICA, UTILIZAR O SUBSOLO DO LOTE PARA EVENTUAIS OBRAS DE INTERESSE
                COLETIVO, DESDE QUE TAL FATO NO VENHA A TRAZER CONSEQUNCIAS OU PREJUJO AO COMPRADOR.<br><br>
                 5 - SERO TOLERADAS DIFERENAS, A MAIOR OU A MENOR, NO TAMANHO DO LOTE, DE AT 05% (CINCO POR CENTO)
                DA REA TOTAL, NO PODENDO AS PARTES EXIGIR INDENIZAO OU RESSARCIMENTO FINANCEIRO.<br><br>
                 6 - AS DIFERENAS DE REA SUPERIORES A 05% (CINCO POR CENTO) SERO ACERTADAS PELAS PARTES, TENDO POR
                BASE O PREO DO METRO QUADRADO APURADO NA DIVISO DO PREO TOTAL DESTE CONTRATO PELA REA DO
                LOTE.<br><br>
                 7 - SE A DIREFENA DE REA SUPERIOR A 5% (CINCO POR CENTO) FOR MAIOR, O VALOR DA DIFERENA, A QUAL
                SER INCLUDA NO SALDO DEVEDOR DESTE CONTRATO E COBRADA UMA FRAO EM CADA PARCELA A VENCER, NOS MESMOS
                TERMOS DA CLUSULA 2 DESTE CONTRATO.<br><br>
                 8 - SE A DIFERENA DE REA SUPERIOR A 5% (CINCO POR CENTO) FOR A MENOR, O VALOR DA DIFERENA SER
                EXCLUDO DO SALDO DEVEDOR E DESCONTADA UMA FRAO EM CADA PARCELA A VENCER.<br><br>
                 9 - EVENTUAL INDENIZAO POR DIFERENAS DE REA SUPERIORES A 05% (CINCO POR CENTO), A MAIOR OU MENOR,
                S SER DEVIDA SE A PARTE INTERESSADA APRESENTAR  OUTRA RECLAMAO POR ESCRITO NO PRAZO MXIMO DE 60
                (SESSENTA) DIAS CONTADO DA DATA DE TRANSFERNCIA DA POSSE PROVISRIA.<br><br>
                <strong><u>  10 - PARA INICIAR EDIFICAO NO LOTE, O COMPRADOR DEVER ESTAR EM DIA COM TODAS AS SUAS
                        OBRIGAES FINANCEIRAS DECORRENTES DESTE CONTRATO E AINDA SOLICITAR, AUTORIZAO PARA
                        CONSTRUO, S PODENDO INICIAR A OBRA APS A EMISSO DO TERMO QUE TER VALIDADE DE 60 (SESSENTA
                        DIAS) QUE CASO NO INICIE A CONSTRUO DEVER SOLICITAR NOVA AUTORIZAO.<br><br>
                         11 - OS COMPRADORES DEVERO VERIFICAR A LOCALIZAO DOS MARCOS DOS LOTES ANTES DE INICIAR A
                        CONSTRUO, CASO NO SEJA POSSIVEL, PODERO SOLICITAR, POR ESCRITO, UMA NOVA DEMARCAO JUNTO
                        AOS VENDEDORES QUE, A SEU CRITRIO, PODERO FAZ-LA MEDIANTE PAGAMENTO DE HONORRIOS PELA
                        PRESTAO DE SERVIOS.<br><br>
                         12 - EM CASO DE IMPOSSIBILIDADE OU RECUSA DOS VENDEDORES EM FAZER A NOVA DEMARCAO, O
                        COMPRADOR DEVER SOLICIT-LA  PREFEITURA MUNICIPAL, ARCANDO COM OS CUSTOS.<br><br>
                         13 - OS VENDEDORES, CASO ACEITEM FAZER NOVA DEMARCAO, TERO O PRAZO DE AT 30 (TRINTA) DIAS
                        PARA REALIZAR O SERVIO, A CONTAR DA DATA DA CONFIRMAO DO RECEBIMENTOS DOS HONARRIOS.<br><br>
                         14 - O COMPRADOR  RESPONSVEL POR QUALQUER DANO MATERIAL E/OU AMBIENTAL PRATICADO NO LOTE,
                        SUJEITANDO-SE S PENALIDADES CRIMINAIS, CIVIS E ADMINISTRATIVAS, OBRIGANDO-SE AINDA A REPARAR
                        INTEGRALMENTE OS DANOS AOS VENDEDORES E/OU A TERCEIROS, A PARTIR DA ASSINATURA DO
                        CONTRATO.<br><br>
                         15 - O COMPRADOR  RESPONSVEL POR QUALQUER DANO MATERIAL E/OU AMBIENTAL NO LOTEAMENTO, DESDE
                        QUE PRATICADO POR ELE, SEUS CONTRATADOS OU TERCEIROS SUA RESPONSABILIDADE, SUJEITANDO-SE S
                        PENALIDADES CRIMINAIS, CIVIS E ADMINISTRATIVAS, OBRIGANDO-SE AINDA A REPARAR INTEGRALMENTE OS
                        DANOS AOS VENDEDORES E/OU A TERCEIROS, A PARTIR DA ASSINATURA DO CONTRATO.</u></strong><br><br>
                 16 - EVENTUAIS TRABALHOS OU SERVIOS PRESTADOS POR TERCEIROS AO COMPRADOR NO LOTE NO GERARO
                QUALQUER VNCULO EMPREGATCIO OU RELAO COM OS VENDEDORES.<br><br>
            </p>
            <p class="texto">
                <strong>CLUSULA 4: DA TRANSMISSO DA POSSE DEFINITIVA<br><br></strong>
                APS A QUITAO INTEGRAL DO PREO DO LOTE E DESDE QUE O COMPRADOR TENHA CUMPRIDO TODAS AS SUAS
                OBRIGAES PREVISTAS NESTE CONTRATO, SER TRANSFERIDA AUTOMATICAMENTE AO COMPRADOR A POSSE
                DEFINITIVA.<br><br>
            </p>
            <p class="texto">
                <strong>CLUSULA 5: DA LIMPEZA E MANUTENO DO LOTE E DO LOTEAMENTO<br><br>
                    <u>APS A ASSINATURA DESTE CONTRATO,  DE RESPONSABILIDADE DO COMPRADOR MANTER O LOTE, AS CALADAS E
                        O LEITO DAS RUAS EM BOAS CONDIES DE LIMPEZA, FAZENDO MANUTENO SEMPRE QUE NECESSRIO OU
                        PERIODICAMENTE.</u><br><br>
                </strong>
                PARGRAFO NICO - O COMPRADOR, DESDE J, AUTORIZA OS VENDEDORES A FAZER, A SEU CRITRIO, OS SERVIOS DE
                MANUTENO NO LOTE E NO LOTEAMENTO SEMPRE QUE JULGAR NECESSRIO E CONVENIENTE, PARA MANTER O PADRO E A
                QUALIDADE DO EMPREENDIMENTO.<br><br>
            </p>
            <p class="texto">
                <strong>CLUSULA 6: DA PROIBIO DE CESSO OU TRANSFERNCIA DA POSSE PROVISRIA<br><br>
                    <u>FICA EXPRESSAMENTE PROIBIDA A CESSO OU TRANSFERNCIA DA POSSE PROVISRIA DO LOTE A TERCEIROS
                        ANTES DA QUITAO INTEGRAL DESTE CONTRATO, SEM A CONCORDNCIA DOS VENDEDORES.<br><br>
                        PARGRAFO NICO - SE O COMPRADOR CEDER OU TRANSFERIR A POSSE PROVISRIA DO LOTE A TERCEIROS, SEM
                        A CONCORDNCIA DOS VENDEDORES, ANTES DA QUITAO DESTE CONTRATO, TODA A DVIDA E OBRIGAES
                        CONTRATUAIS DO COMPRADOR VENCERO ANTECIPADAMENTE, DE PLENO DIREITO, NOS TERMOS DA CLUSULA 15
                        DESTE CONTRATO.
                    </u></strong><br><br>
            </p>
            <p class="texto">
                <strong>CLUSULA 7: DA CESSO, TRANSFERNCIA OU ONERAO DOS DIREITOS AQUISITIVOS - DO DIREITO DE
                    PREFERNCIA.<br><br>
                    <u>DESDE J, FICA ASSEGURADO AOS VENDEDORES O DIREITO DE PREFERNCIA, EM IGUALDADE DE CONDIES, NO
                        EVENTUAL INTERESSE DO COMPRADOR EM CEDER, TRANSFERIR OU ONERAR OS DIREITOS AQUISITIVOS DO
                        LOTE.<br><br>
                         1 - O COMPRADOR CONCORDA EXPRESSAMENTE QUE A CESSO, TRANSFERNCIA OU ONERAO DOS DIREITOS
                        AQUISITIVOS DESTE CONTRATO, A QUAISQUER TERCEIROS, NO PODER SER REALIZADA SEM A PRVIA E
                        EXPRESSA ANUNCIA DOS VENDEDORES, OBSERVADAS AINDA AS SEGUINTES CONDIES:
                    </u></strong><br><br>
                A) O CEDENTE ESTEJA EM DIA COM TODAS AS SUAS OBRIGAES CONTRATUAIS;<br>
                B) AS OBRAS EM EXECUO OU EXECUTADAS NO LOTE TIVEREM RESPEITADO INTEGRALMENTE AS RESTRIES
                URBANSTICAS CONVENCIONAIS E LEGAIS ESTABELECIDAS NESTE CONTRATO;<br>
                C) O CESSIONRIO FORNEA CPIA DOS DOCUMENTOS PESSOAIS (RG, CPF, CERTIDO DE NASCIMENTO OU CASAMENTO),
                COMPROVANTE DE ENDEREO (CONTA, DE GUA, LUZ OU TELEFONE FIXO COM MXIMO 3 MESES DE EMISSO) OU OUTROS
                QUE OS VENDEDORES SOLICITAREM E TENHA SEU CADASTRO APROVADO.<br><br>
                <strong><u>D) PAGUE AOS VENDEDORES A IMPORTNCIA EQUIVALENTE A 1% (UM POR CENTO) DO VALOR ATUALIZADO
                        DESTE CONTRATO OU UMA PARCELA ATUALIZADA (PREVALECENDO SEMPRE O MENOR VALOR), A TTULO DE
                        DESPESAS ADMINISTRATIVAS, CUJO PAGAMENTO DEVER SER EFETUADO ATRAVS DE BOLETO
                        BANCRIO.<br><br>
                         2 - SE O COMPRADOR CEDER, TRANSFERIR OU ONERAR OS DIREITOS AQUISITIVOS DESTE CONTRATO SEM O
                        EXPRESSO CONSENTIMENTO DOS VENDEDORES, OU AINDA, NO CONCEDER AOS VENDEDORES O DIREITO DE
                        PREFERNCIA, EM IGUALDADE DE CONDIES, TODA A DVIDA E OBRIGAES CONTRATUAIS DO COMPRADOR
                        VECERO ANTECIPADAMENTE, DE PLENO DIREITO, NOS TERMOS DA CLUSULA 15 DESTE
                        CONTRATO.</u></strong><br><br>
            </p>
            <p class="texto">
                <strong> CLUSULA 8: DAS CONSTRUES E DAS RESTRIES URBANSTICAS<br><br>
                    <u>ANTES DE INICIAR CONSTRUO OU ATIVIDADE DE QUALQUER NATUREZA NO LOTE, O COMPRADOR
                        DEVER:<br><br>
                        A) TER SUPERADO A CONDIO SUSPENSIVA REFERENTE AO PAGAMENTO INTEGRAL DO SINAL DE NEGCIO
                        ESTABELECIDA NO ITEM II, B.1, DESTE CONTRATO;<br><br>
                        B) OBTER TODAS AS CERTIDES, ALVARS E APROVAES NECESSRIAS PERANTE A PREFEITURA MUNICIPAL E
                        DEMAIS ORGOS PBLICOS COMPETENTES;<br><br>
                         1 -  PROIBIDA A CONSTRUO NO LOTE DE CASAS DE TAIPAS, BARRACO DE LONA, ADOBES, FOLHAS DE
                        ZINCO, PLSTICO, PAPELO, COMPENSADO, PALHA, PAU-A-PIQUE, PLACAS, TAPUMES, SOBRAS, ENTULHOS OU
                        QUALQUER MATERIAL IMPRPRIO PARA A CONSTRUO CIVIL.<br><br>
                         2 -  PROIBIDA A CONSTRUO DE CERCAS DIVISRIAS DE SOBRAS DE MATERIAL, COMPENSADO, TAPUMES,
                        OU QUALQUER OUTRO TIPO DE MATERIAL IMPRPRIO PARA CONSTRUO CIVIL.<br><br>
                         3 -  EXPRESSAMENTE PROIBIDO UTILIZAR O LOTE, AS CALADAS, O LEITO DAS RUAS, AS REAS
                        PBLICAS, REAS VERDES E DE PRESERVAO PERMANENTE PARA FINALIDADES CONSIDERADAS NOCIVAS  SADE
                        E AO INTERESSE SOCIAL E AINDA COMO DEPSITO DE LIXO, PAPEL, LATAS, PLSTICO, FERRO VELHO,
                        ENTULHOS, PNEUS, GARRAFAS, EXPLOSIVOS OU COMBUSTVEIS ARMAZENADOS DE FORMA INADEQUADA, OU
                        QUALQUER ATIVIDADE QUE POSSA GERAR ALGUM PREJUZO SANITRIO OU AMBIENTAL  COMUNIDADE, SOB PENA
                        DE O COMPRADOR RESPONDER CRIMINAL, CIVIL E ADMINISTRATIVAMENTE PERANTE AOS VENDEDORES E/OU
                        TERCEIROS.<br><br>
                         4 -  EXPRESSANTE PROIBIDO UTILIZAR AS CALADAS, O LEITO DAS RUAS, REAS PBLICAS, REAS
                        VERDES E DE PRESERVAO PERMANETE, COMO DEPSITO DE MATERIAIS DE CONSTRUO, CANTEIRO DE OBRAS,
                        MADEIRAS OU RESDUOS DE QUALQUER NATUREZA, SOB PENA DE O COMPRADOR RESPONDER CRIMINAL, CIVIL E
                        ADMINISTRATIVAMENTE PERANTE AOS VENDEDORES E/OU TERCEIROS.<br><br>
                         5 -  EXPRESSAMENTE PROIBIDO UTILIZAR OUTROS LOTES QUE NO SEJAM DE PROPRIEDADE DO COMPRADOR
                        COMO DEPSITO DE MATERIAIS DE CONSTRUO, CANTEIRO DE OBRAS, MADEIRAS OU RESDUOS DE QUALQUER
                        NATUREZA SEM A ANUNCIA EXPRESSA DE SEU PROPRIETRIO. EM CASO DE DESCUMPRIMENTO DESTA NORMA, OS
                        VENDEDORES FICARO ISENTOS DE QUALQUER RESPONSABILIDADE DECORRENTE DESTE ATO, DEVENDO AS PARTES
                        ENVOLVIDAS RESOLVEREM A QUESTO ENTRE SI.<br><br>
                    </u></strong>
                 6 - ENQUANTO OS IMVEIS VIZINHOS AO LOTE PERTENCEREM AOS VENDEDORES, NO PODER SER-LHE EXIGIDA A
                CONSTRUO DE MUROS DIVISRIOS, GRADES, PORTES, ETC. SE O COMPRADOR OS FIZER, ARCAR COM A TOTALIDADE
                DOS CUSTOS RELATIVOS  CONSTRUO.<br><br>
                <strong>
                    <u> 7 - O COMPRADOR NO PODER, EM HIPTESE ALGUMA, DESPEJAR RESDUOS DE ESGOTO E/OU GUA SERVIDA
                        NO LEITO DAS VIAS PBLICAS, NO LEITO DOS CRREGOS, NO SISTEMA DE DRENAGEM OU NOS LOTES VIZINHOS
                        E SE O FIZER, ESTAR SUJEITO A PENALIDADES DECORRENTES DESTE ATO, RESPONDENDO CRIMINAL, CIVIL E
                        ADMINISTRATIVAMENTE PERANTE AOS VENDEDORES E/OU TERCEIROS.<br><br>
                    </u>
                </strong>
                 8 - ENQUANTO NO HOUVER INICIADO A CONSTRUO, O COMPRADOR AUTORIZA AOS VENDEDORES A INSTALAR
                QUALQUER MATERIAL PUBLICITRIO NO LOTE.<br><br>
            </p>
            <p class="texto">
                <strong>CLUSULA 9: DO EMBARGO DE OBRAS<br><br>
                    <u>OS VENDEDORES PODERO TOMAR AS MEDIDAS CABVEIS AO EMBARGO DAS OBRAS NO LOTE EM QUALQUER DAS
                        SEGUINTES SITUAES:</u></strong><br><br>
                <strong><u>1 SITUAO:</u></strong> SE O COMPRADOR ESTIVER EM ATRASO COM O PAGAMENTO DE QUALQUER
                PARCELA OU OBRIGAO FINANCEIRA DECORRENTE DESTE CONTRATO;<br><br>
                <strong><u>2 SITUAO:</u></strong> SE HOUVER O DESRESPEITO S RESTRIES CONVENCIONAIS E LEGAIS
                CONTIDAS NA CLUSULA 8 DESTE CONTRATO, NO PLANO DIRETOR OU NO CDIGO DE OBRAS DO MUNICPIO;<br><br>
                <strong><u>3 SITUAO:</u></strong> SE HOUVER O VENCIMENTO ANTECIPADO DO SALDO DEVEDOR DESTE CONTRATO,
                CONFORME CLUSULA 15;<br><br>
                <strong><u>4 SITUAO:</u></strong> SE, POR QUALQUER MOTIVO, HOUVER A RESCISO DESTE CONTRATO.<br><br>
            </p>
            <p class="texto"> <!-- TODO: TRECHO ESPECFICO PARA LOTEAMENTO ROSA LINDA -->
                <strong>CLAUSULA 10: DAS OBRAS DE INFRARESTUTURA E SERVIOS A SEREM IMPLANTADOS PELOS VENDEDORES/
                    PREFEITURA MUNCIPAL DE <?= Helper::str2Upper($cidadeEmpreedimento['nome']) ?>
                    - <?= $cidadeEmpreedimento['uf'] ?> / DEPASA.<br><br>
                    <u>OS VENDEDORES ASSINARAM, EM 24/02/2015 UM TERMO DE AJUSTAMENTO DE CONDUTA ? TAC, COM O MINISTRIO
                        PBLICO DO ESTADO DO ACRE - MPAC E PREFEITURA MUNICIPAL DE RIO BRANCO - PMRB, ONDE FICOU
                        ACORDADO:<br><br>
                        1- QUE AS OBRAS DE INFRA-ESTRUTURAS, OU SEJA, REDE DE ABASTECIMENTO DE GUA, ESGOTAMENTO
                        SANITRIO, REDE DE DRENAGEM, E PAVIMENTAO EM TSD, SERO EXECUTADAS PELA PREFEITURA MUNCIPAL DE
                        <?= Helper::str2Upper($cidadeEmpreedimento['nome']) ?> - <?= $cidadeEmpreedimento['uf'] ?> /
                        DEPASA;<br><br>
                        2- QUE AS OBRAS DA PMRB / DEPASA NO CONTEMPLAVAM 100% (CEM PORCENTO) DAS RUAS DO LOTEAMENTO,
                        FICANDO ACORDADO QUE OS VENDEDORES IRO EXECUTAR 04 (QUATRO) TRECHOS DE RUAS, ABAIXO
                        LISTADOS:<br><br>
                    </u>a. <u>RUA ARAAGI - 285,00M;<br><br>
                    </u>b. <u>RUA GILBERTO CORREA - 160,00M;<br><br>
                    </u>c. <u>RUA AAR - 300,00M;<br><br>
                    </u>d. <u>RUA PONTENEL - 40,00M.<br><br>
                    </u></strong>
                 1 - NO REFERIDO TAC PREV QUE OS VENDEDORES TERO 12 (DOZE) MESES, A CONTAR DA EXPEDIO DO ALVAR DE
                EXECUO DE OBRA PELA PREFEITURA MUNICIPAL DE RIO BRANCO, PARA EXECUTAR AS OBRAS DE INFRAESTRUTURAS NOS
                04 (QUATRO) TRECHOS DE RUAS ACIMA CITADAS.<br><br>
                 2 - OS VENDEDORES PODERO, A SEU CRITRIO, PRIORIZAR ETAPAS DO LOTEAMENTO, ONDE ANTECIPAR O
                CRONOGRAMA DE ENTREGA DAS OBRAS E/OU SERVIOS.<br><br>
                 3 - NO  OBRIGAO DOS VENDEDORES A EXECUO DE QUALQUER OBRA E/OU SERVIO QUE NO ESTEJAM
                RELACIONADOS NESTA CLUSULA.<br><br>
                <strong><u> 4 - AS OBRAS DO LOTEAMENTO DEVERO SER CONCLUDAS NOS PRAZOS ESTABELECIDOS NO CRONOGRAMA
                        DE ENTREGA, SENDO ADMITIDA UMA TOLERNCIA DE AT 180 (CENTO E OITENTA) DIAS PARA CONCLUSO.</u></strong><br><br>
            </p>
            <p class="texto">
                <strong>CLUSULA 11: DOS EQUIPAMENTOS PBLICOS DO LOTEAMENTO<br><br>
                    <u>A PARTIR DA ASSINATURA DO TERMO DE AJUSTAMENTO DE CONDUTA - TAC E DO REGISTRO DO LOTEAMENTO, OS
                        EQUIPAMENTOS PBLICOS DO EMPREENDIMENTO, TAIS COMO O SISTEMA DE CAPTAO E DE DITRIBUIO DE
                        GUA, REDE ELTRICA, ILUMINAO PBLICA, REDE COLETORA DE ESGOTO SANITRIO, DRENAGEM DE GUAS
                        PLUVIAIS, SISTEMA VIRIO, REAS VERDES, REAS DE PRESERVAO PERMANENTE E REAS INSTITUCIONAIS,
                        SERO AUTOMATICAMENTE DE DOMNIO PBLICO.<br><br>
                         1 - APS A CONCLUSO DAS OBRAS DE INFRAESTRUTURA PELOS VENDEDORES, CASO O PODER PBLICO DEIXE
                        DE FORNECER GUA POR QUALQUER MOTIVO, O COMPRADOR PODER EXECUTAR, POR CONTA PRPRIA E
                        OBSERVADAS AS NORMAS LEGAIS VIGENTES, A CONSTRUO E INSTALAO DE SISTEMA DE CAPTAO DE GUA
                        INDIVIDUAL (POO SEMI-ARTESIANO OU CISTERNA), ISENTANDO OS VENDEDORES DE QUALQUER
                        RESPONSABILIDADE.<br><br>
                         2 - NO  DE RESPONSABILIDADE DOS VENDEDORES A LIGAO, MANUTENO E FORNECIMENTO DE GUA E
                        ENERGIA ELTRICA, NEM A MANUTENO, COLETA E TRATAMENTO DE ESGOTO SANITRIO AOS COMPRADORES,
                        POIS TAIS SERVIOS SO DE RESPONSABILIDADES DAS CONCESSIONRIAS AUTORIZADAS OU DOS ORGOS
                        COMPETENTES.<br><br>
                         3 - TODAS AS SOLICITAES DE LIGAO, REPARO OU MANUTENO DO SISTEMA DE CAPTAO E DE
                        DISTRIBUIO DE GUA, REDE ELTRICA E REDE COLETORA DE ESGOTO SANITRIO DO LOTEAMENTO, DEVERO
                        SER DIRIGIDAS DIRETAMENTE S CONCESSIONRIAS AUTORIZADAS OU AOS ORGOS COMPETENTES.</u></strong><br><br>
                 4 - NO  DE RESPONSABILIDADE DOS VENDEDORES A CONSTRUO E INTERLIGAO DAS REDES DE GUA, DE
                ENERGIA ELTRICA E DE COLETA DE ESGOTO QUE NO ESTEJAM DENTRO DOS LIMITES DO LOTEAMENTO.<br><br>
            </p>
            <p class="texto">
                <strong>CLUSULA 12: DA POSSVEL INVASO OU DESRESPEITO AOS MARCOS DIVISRIOS<br><br>
                    <u>APS A TRANSMISSO DA POSSE PROVISRIA,  DE RESPONSABILIDADE DO COMPRADOR GUARDAR VIGIAR, ZELAR,
                        PROTEGER E DEFENDER O / TERRENO DE POSSVEL INVASO.</u></strong><br><br>
                1 - SE APS A TRANSMISSO DA POSSE PROVISRIA, PORVENTURA OUTRO CLIENTE DOS VENDEDORES, VIZINHO OU
                TERCEIRO CONSTRUIR, POR ENGANO OU DESRESPEITANDO OS MARCOS DIVISRIOS DO LOTE OBJETO DESTE CONTRATO, OS
                VENDEDORES FICARO ISENTOS DE QUALQUER RESPONSABILIDADE DECORRENTE DESTE ATO, DEVENDO AS PARTES
                ENVOLVIDAS RESOLVER A QUESTO ENTRE SI.<br><br>
                2 - <strong><u>SE OCORRER INVASO DO LOTE, O COMPRADOR DEVER TOMAR TODAS AS PROVIDNCIAS NECESSRIAS
                        PARA SUA TOTAL DESOCUPAO EM AT 30 (TRINTA) DIAS, ARCANDO COM OS CUSTOS.</u></strong><br><br>
                 3 - OS VENDEDORES PODERO, A QUALQUER TEMPO, EM NOME PRPRIO, ADOTAR AS MEDIDAS LEGAIS E CABVEIS
                PARA A REINTEGRAO DE POSSE, INCLUSIVE COM PEDIDO LIMINAR.<br><br>
                <strong><u> 4 - TODAS AS DESPESAS, HONORRIOS OU CUSTAS RELACIONADAS S PROVIDNCIAS CITADAS
                        ANTERIORMENTE SERO DE TOTAL RESPONSABILIDADE DO COMPRADOR, O QUAL DEVER RESSARCIR AOS
                        VENDEDORES DE IMEDIATO, CUJO PAGAMENTO DEVER SER EFETUADO ATRAVS DE BOLETO BANCRIO.<br><br>
                         5 - SE O LOTE FOR INVADIDO E O COMPRADOR NO TOMAR AS PROVIDNCIAS PREVISTAS NO PARGRAFO
                        SEGUNDO DESTA CLUSULA, OS VENDEDORES PODERO, CASO QUEIRA, CONSIDERAR O SALDO DEVEDOR DESTE
                        CONTRATO VENCIDO ANTECIPADAMENTE DE PLENO DIREITO, APLICANDO-SE O DISPOSTO NA CLUSULA 15.</u></strong><br><br>
            </p>
            <p class="texto">
                <strong>CLUSULA 13: DA EVENTUAL DESAPROPRIAO<br><br>
                    <u>SE POR ALGUM MOTIVO O LOTE FOR DESAPROPRIADO PELO PODER PBLICO, AS PARTES ACORDAM O
                        SEGUINTE:<br><br>
                        A) CONTRATOS NO QUITADOS:</u></strong> O VALOR DA INDENIZAO SER DIVIDIDO ENTRE AS PARTES,
                CABENDO AO COMPRADOR VALOR PROPORCIONAL AO PERCENTUAL POR ELE J PAGO, ENCERRANDO-SE ESTE
                CONTRATO;<br><br>
                <strong><u>B) CONTRATOS QUITADOS:</u></strong> SE O LOTE AINDA ESTIVER EM NOME DOS VENDEDORES, O VALOR
                DA INDENIZAO SER REPASSADO INTEGRALMENTE AO COMPRADOR.<br><br>
                PARGRAFO NICO - SE HOUVER DESAPROPRIAO, AS PARTES FICARO ISENTAS DO PAGAMENTO DE MULTAS
                CONTRATUAIS, INDENIZAO OU PENALIDADES DE QUALQUER NATUREZA.<br><br>
            </p>
            <p class="texto">
                <strong>CLUSULA 14 - DO PAGAMENTO DOS TRIBUSTOS<br><br>
                    <u>APS A DATA DE ASSINATURA DESTE CONTRATO, QUAISQUER TRIBUTOS QUE INCIDIREM SOBRE O LOTE DEVERO
                        SER PAGOS PELO COMPRADOR.<br><br>
                         1 - SE APS A DATA DA ASSINATURA DESTE CONTRATO, ALGUM TRIBUTO FOR EMITIDO EM NOME DOS
                        VENDEDORES E SE POR QUALQUER MOTIVO, NO FOR PAGO PELO COMPRADOR, OS VENDEDORES PODERO PAG-LO,
                        EXIGINDO O REEMBOLSO ACRESCIDO DE JUROS E MULTA MORATRIA LEGAIS E CORREO MONETRIA PELO
                        I.G.P.M./F.G.V., CONFORME PREVISTO NA CLUSULA 2 DESTE CONTRATO, A SER COBRADO ATRAVS DE
                        BOLETO BANCRIO.</u></strong><br><br>
                 2 - O COMPRADOR DEVER PROVIDENCIAR, NO PRAZO MXIMO DE AT 30 (TRINTA) DIAS APS A ASSINATURA DESTE
                CONTRATO, A TRANSFERNCIA PARA SEU NOME DOS LANAMENTOS DOS TRIBUTOS, SERVIOS, TAXAS E OUTROS
                INCIDENTES SOBRE O LOTE PERANTE AS REPARTIES PBLICAS (MUNICIPAL, ESTADUAL E/OU FEDERAL), SEM QUE ISSO
                CARACTERIZE A TRANSFERNCIA DE PROPRIEDADE DO LOTE.<br><br>
                 3 - SUPERADO O PRAZO DESCRITO NO PARGRAFO ANTERIOR SEM QUE TINHA SIDO REALIZADA A TRANSFERNCIA, O
                COMPRADOR AUTORIZA AOS VENDEDORES A FAZ-LA, POR SI OU POR TERCEIROS, CABENDO AO COMPRADOR REEMBOLSAR
                AOS VENDEDORES TODOS OS CUSTOS E DESPESAS DECORRENTES DESTE ATO, ACRESCIDO DE JUROS E MULTA MORATRIA
                LEGAIS E CORREO MONETRIA PELO I.G.P.M./F.G.V. CUJO PAGAMENTO DEVER SER EFETUADO ATRAVS DE BOLETO
                BANCRIO.<br><br>
            </p>
            <p class="texto">
                <strong>CLUSULA 15: DO VENCIMENTO ANTECIPADO<br><br>
                    <u>FICA CONVENCIONADO ENTRE AS PARTES QUE OS VENDEDORES PODERO CONSIDERAR TODAS AS PARCELAS DO
                        PREO VENCIDAS ANTECIPADAMENTE, DE PLENO DIREITO, QUANDO:<br><br>
                        A) HOUVER ATRASO NO PAGAMENTO DE 03 (TRS) PARCELAS, OU TRANSCORRIDOS 60 (SESSENTA) DIAS APS O
                        VENCIMENTO DE QUALQUER PARCELA OU OUTRA OBRIGAO FINANCEIRA DECORRENTE DESTE CONTRATO;<br><br>
                        B) O LOTE FOR INVADIDO E O COMPRADOR DEIXAR DE CUMPRIR AS OBRIGAES DESTE CONTRATO, CONFORME
                        CLUSULA 12;<br><br>
                        C) HOUVER CEDIDO OU TRANSFERIDO A POSSE PROVISRIA DO LOTE A TERCEIROS ANTES DA QUITAO DESTE
                        CONTRATO, SEM ANUENCIA DOS VENDEDORES CONFORME CLUSULA 6<br><br>
                        D) DEIXAR DE CUMPRIR AS RESTRIES CONVENCIONAIS E/OU LEGAIS PREVISTA NA CLUSULA 8 DESTE
                        CONTRATO<br><br>
                        E) DEIXAR DE CUMPRIR A QUALQUER OUTRA CLSULA OU OBRIGAO DO COMPRADOR PREVISTA NESTE CONTRATO.<br><br>
                         1 - NAS HIPTESES ANTERIORES, O COMPRADOR SER NOTIFICADO JUDICIALMENTE OU
                        EXTRAJUDICIALMENTE, PARA QUE NO PRAZO MXIMO DE 15 (QUINZE) DIAS, A CONTAR DA DATA DO
                        RECEBIMENTO DA NOTIFICAO COMPAREA AO ESCRITRIO
                        DA <?= Helper::str2Upper($empresa['nm_razao_social']) ?> E COMPROVE A REGULARIZAO DAS
                        OBRIGAES CONTRATUAIS E/OU PAGUE TODO O DBITO ENCONTRADO.<br><br>
                        2 - SE O COMPRADOR NO REGULARIZAR AS OBRIGAES CONTRATUAIS E/OU NO FIZER
                        O PAGAMENTO NO PRAZO MXIMO DE 15 (QUINZE) DIAS, OS VENDEDORES PODERO ALTERNATIVAMENTE:<br><br>
                        A) CONSIDERAR RESCINDIDO ESTE CONTRATO, DE PLENO, DIREITO, NOS TERMOS DA CLUSULA 16, APLICANDO
                        AS PENALIDADES ALI PREVISTA;<br><br>
                        B) OU EXECUTAR O SALDO DEVEDOR ATUALIZADO DESTE CONTRATO, ACRESCIDO DE B.1) VARIAO DO NDICE
                        DE CORREO MONETRIA (I.G.P.M/F.G.V); B.2) MULTA DE <?= Helper::getMoney($banco['multa']) ?> %
                        (<?= Helper::valorPorExtenso($banco['multa'], true, true) ?>) POR CENTO E JUROS MORATRIOS DE
                        <?= Helper::getMoney($banco['juros']) ?>% A.M., COBRADO PRO-RATA DIE; B.3) MULTA CONTRATUAL
                        COMPENSATRIA DE 10% (DEZ POR CENTO) DO
                        VALOR ATUALIZADO DESTE CONTRATO.</u></strong><br><br>
            </p>
            <p class="texto">
                <strong>CLUSULA 16: DA RESCIO CONTRATUAL, DAS PENALIDADES, NA CONDIO E DA FORMA DE RESTITUIO DO
                    SALDO.<br><br>
                    <u>SE O COMPRADOR DEIXAR DE CUMPRIR QUALQUER OBRIGAO ASSUMIDA NESTE CONTRATO ELE SER NOTIFICADO
                        PELOS VENDEDORES PARA CUMPRIR TAIS OBRIGAES, SOB PENA DE RESCISO CONTRATUAL.<br><br>
                         1 - INDEPENDENTEMENTE DA NOTIFICAO ACIMA, SE O COMPRADOR PRETENDER PURGAR A MORA PELO
                        ATRASO NO PAGAMENTO DE QUAISQUER OBRIGAES FINANCEIRAS DECORRENTES DESTE CONTRATO, DEVER
                        FAZ-LA PAGAMENTO DO PRINCIPAL, ACRESCIDO DE MULTA E JUROS MORATRIOS LEGAIS.<br><br>
                         2 - UMA VEZ CONSTITUDO EM MORA ATRAVS DE NOTIFICAO, E O COMPRADOR NO PURG-LA DENTRO DO
                        PRAZO DE 15 (QUINZE) DIAS, OS VENDEDORES PODERO CONSIDERAR ESTE CONTRATO RESCINDIDO DE PLENO
                        DIRIETO.<br><br>
                         3 - EM QUALQUER CASO DE DESFAZIMENTO DESTE CONTRATO, A POSSE PROVISRIA DO LOTE SER
                        AUTOMATICAMENTE DEVOLVIDA AOS VENDEDORES.<br><br>
                         4 - SE O COMPRADOR CRIAR QUALQUER EMBARAO  RESTITUIO DA POSSE PROVISRIA DO LOTE AOS
                        VENDEDORES, SER CONFIGURADO O ESBULHO POSSESSRIO, HIPTESE EM QUE OS MESMOS PODERO REQUERER
                        JUDICIALMENTE A REINTEGRAO DE POSSE, COM PEDIDO LIMINAR, SEM PREJUZO DO PAGAMENTO DAS
                        PENALIDADES LEGAIS E CONTRATUTAIS AQUI ESTABELECIDA.<br><br>
                         5 - A POSSE DEVER SER RESTITUDA LIVRE DE PESSOAS E COISA E SEM DBITOS DE QUALQUER
                        NATUREZA, SITUAO NA QUAL OS VENDEDORES PODERO, DESDE A DATA DE RESCISO DO CONTRATO, DISPOR,
                        VENDER OU TRANSFERI O LOTE A TERCEIROS.<br><br>
                         6 - DAS PENALIDADES PELA RESCISO - HAVENDO A RESCISO CONTRATUAL, POR VONTADE OU CULPA
                        EXCLUSIVA DO COMPRADOR, SERO APLICADAS AO MESMO, CUMULATIVAMENTE, AS SEGUINTES PENALIDADES:<br><br>
                        A) PERDA DA POSSE PROVISRIA DO LOTE, NA FORMA ESTABELICIDA NOS PARGRAFOS 3, 4, 5 DESTA
                        CLUSULA;<br><br>
                        B) PERDA INTEGRAL DA QUANTIA PAGA A TTULO DE SINAL DE NEGCIO (ITEM II, E B.1, DESTE CONTRATO);<br><br>
                        C) PERDA DE 20% (VINTE POR CENTO) DO VALOR DAS PARCELAS PAGAS,  TTULO DE INDENIZAO DE
                        NATUREZA COMPENSATRIA;<br><br>
                        D) PAGAMENTO MENSAL DE FRUIO EM VALOR CORRESPONDENTE A 0,25% (ZERO VRGULA VINTE E CINCO POR
                        CENTO) DO VALOR ATUALIZADO DESTE CONTRATO, CONTADO A PARTIR DA TRANSMISSO DA POSSE PROVISRIA
                        DO LOTE AT A RESCISO DESTE CONTRATO OU DEVOLUO DA POSSE AOS VENDEDORES (CONSIDERANDO O QUE
                        OCORRER POR LTIMO), PERODO EM QUE O COMPRADOR USUFRUIU LIVREMENTE O LOTE.<br><br>
                         7 - DO CLCULO PARA RESTITUIO - NO SERO RESTITUDOS AO COMPRADOR OS PAGAMENTOS DE
                        HONORRIOS, TARIFAS, EMOLUMENTOS CARTORIAIS E EVENTUAIS JUROS E MULTAS MORATRIAS COBRADOS PELO
                        ATRASO NO PAGAMENTO DE QUALQUER OBRIGAO FINANCEIRA.<br><br>
                         8 - SER DESCONTADO DO SALDO TODO DBITO PELO NO PAGAMENTO DE TRIBUTOS OU QUAISQUER OUTROS
                        DBITOS GERADOS NO TRANSCORRER DESTE CONTRATO.<br><br>
                         9 - A RESTITUIO DO SALDO SER REALIZADA APS A EFETIVA DEVOLUO DE POSSE PROVISRIA DO
                        LOTE NA FORMA ESTABELECIDA NESTE CONTARTO E QUANDO DO COMPARECIMENTO DO COMPRADOR E SEU CNJUGUE
                        NO ESCRITRIO DOS VENDEDORES, OBSERVADOS OS SEGUINTES CRITRIOS PARA A RESTITUIO;<br><br>
                        A) O SALDO A RESTITUIR SER PAGO EM PARCELAS MENSAIS E SUCESSIVAS, CUJO NMERO SER O MESMO DAS
                        PARCELAS J PAGAS PELO COMPRADOR NO TRANSCORRER DESTE CONTRATO, NO PODENDO EXCEDER A 36 (TRINTA
                        E SEIS) MESES;<br><br>
                        B) A PRIMEIRA PARCELA VENCER 30 (TRINTA) DIAS APS O COMPARECIMENTO DO COMPRADOR E SEU CNJUGUE
                        NO ESCRITRIO DOS VENDEDORES, E AS DEMAIS NO MESMO DIA DOS MESES SUBSEQUENTES;<br><br>
                        C) AS PARCELAS SERO PAGAS MEDIANTE CRDITO EM CONTA BANCRIA INDICADA POR ESCRITO PELO
                        COMPRADOR E POR SEU CNJUGUE.</u></strong><br><br>
            </p>
            <p class="texto">
                <strong>CLUSULA 17: DA RESCISO CONTRATUAL DE LOTE COM BENFEITORIAS<br><br>
                    <u>SE ESTE CONTATO FOR RESCINDIDO, POR QUALQUER MOTIVO, E HOUVER BENFEITORIAS NO LOTE, OS VENDEDORES
                        PODERO OPTAR PELA RETOMADA DO LOTE, HIPTESE EM QUE SERO APLICADAS AO COMPRADOR AS MESMAS
                        PENALIDADES PREVISTAS NA CLUSULA 16 DESTE CONTRATO.</u></strong><br><br>
                 1 - O COMPRADOR RECEBER INDENIZAO SOMENTE DAS BENFEITORIAS TEIS E NECESSRIAS, LEVANTADAS DE
                ACORDO COM AS NORMAS LEGAIS E CONVENCIONAIS PREVISTAS NESTE CONTRATO, DA PREFEITURA MUNICIPAL E DEMAIS
                ORGOS PBLICOS COMPETENTES.<br><br>
                 2 - O VALOR DA INDENIZAO PELAS BENFEITORIAS SER NEGOCIADO ENTRE AS PARTES. NO HAVENDO CONSENSO,
                SER DEFINIDO DE ACORDO COM O PREO MDIO DE LAUDOS TCNICOS DE AVALIAO ELABORADOS POR, NO MNIMO, 03
                (TRS) PROFISSIONAIS DA REA (CORRETORES DE IMVEIS DEVIDAMENTE CREDENCIADOS OU ENGENHEIROS CIVIS),
                ESCOLHIDOS DE COMUM ACORDO PELAS PARTES.<br><br>
                <strong><u> 3 - QUEM DER CAUSA A RESCISO ARCAR COM OS CUSTOS DOS LAUDOS TCNICOS E DE AVALIAO.</u></strong><br><br>
                 4 - O COMPRADOR S RECEBER O VALOR DA INDENIZAO APS A VENDA DO LOTE E DAS BENFEITORIAS, NAS
                MESMAS CONDIOES E PRAZOS DA NOVA VENDA.<br><br>
                 5 - O RECEBIMENTO DA INDENIZAO FICAR CONDICIONADO  APRESENTAO PELO COMPRADOR DE: A) ALVAR DE
                CONSTRUO; B) CARTA DE "HABITE-SE"; C) COMPROVANTE DE QUITAO DOS SERVIOS PRESTADOS PELAS
                CONCESSIONRIAS DE GUA, LUZ E ESGOTO; D) COMPROVANTE DE QUITAO DOS TRIBUTOS MUNICIPAIS, ESTADUAIS,
                FEDERAIS, PREVIDENCIRIOS E TRABALHISTAS DO LOTE E DA CONSTRUO.<br><br>
                <strong><u> 6 - EM NENHUMA HIPTESE SERO INDENIZADAS AS BENFEITORIAS VOLUPTURIAS, NO ENTANTO, O
                        COMPRADOR PODER RETIR-LAS.</u></strong><br><br>
            </p>
            <p class="texto">
                <strong>CLUSULA 18: DOS EVENTUAIS ROUBOS E FURTOS</strong><br><br>
                OS VENDEDORES NO SE RESPONSABILIZAM POR EVENTUAIS ROUBOS E FURTOS NA REDE DE DISTRIBUIO DE ENERGIA
                ELTRICA, ILUMINAO PBLICA, SISTEMA DE DISTRIBUIO DE GUA, SISTEMA DE ESGOTO, OU OUTROS BENS DE
                QUALQUER NATUREZA, DENTRO DO LOTEAMENTO, DEVENDO AS RECLAMAES SER FEITAS DIRETAMENTE AOS ORGOS
                COMPETENTES.<br><br>
            </p>
            <p class="texto">
                <strong>CLUSULA 19: DOS ENDEREOS<br><br>
                    <u>TODAS AS COMUNICAES, NOTIFICAES, INTIMAES, CITAES E CINCIA DE TODO E QUALQUER
                        PROCEDIMENTO DECORRENTE DESTE CONTRATO, DEVERO SER FEITAS POR ESCRITO E ENVIADAS S PARTES NOS
                        ENDEREOS CONSTANTES DESTE CONTRATO.<br><br>
                         1 - AS PARTES OBRIGAM-SE A COMUNICAR UMA A OUTRA, POR ESCRITO, QUALQUER MUDANA DE ENDEREO,
                        NO PRAZO DE AT 15 (QUINZE) DIAS DA OCORRNCIA DO FATO, SOB PENA DE SER CONSIDERADA COMO
                        EFETUADA, VLIDA E EFICAZ QUALQUER COMUNICAO, NOTIFICAO, INTIMAO, CITAO E CINCIA DE
                        TODO E QUALQUER PROCEDIMENTO DECORRENTE DESTE CONTRATO ENVIADAS AOS ENDEREOS INFORMADOS, AINDA
                        QUE ENTREGUE A TERCEIROS.<br><br>
                         2 - A ADMINISTRADORA DO LOTEAMENTO, REPRESENTANTE DOS VENDEDORES, TEM SEU ESCRITRIO DE
                        ATENDIMENTO LOCALIZADO
                        NA <?= Helper::str2Upper($empresa['ds_endereco'] . ', ' . $empresa['nm_bairro']) ?>
                        , <?= Helper::str2Upper($empresa['cidade']['nome'] . ' - ' . $empresa['cidade']['uf']) ?>,
                        CEP: <?= $empresa['nr_cep'] ?> ONDE DEVERO SER TRATADOS TODOS OS ASSUNTOS RELATIVOS A ESTE
                        CONTRATO.</u></strong><br><br>
            </p>
            <p class="texto">
                <strong>CLUSULA 20: DA SUB-ROGAO, CAUO, ONERAO, CESSO DE DIREITOS E/OU DEVERES DOS
                    VENDEDORES<br><br>
                    <u>OS VENDEDORES PODERO, A SEU CRITRIO, SUB-ROGAR, CAUCIONAR, ONERAR, CEDER OS DIREITOS E/OU
                        DEVERES DESTE CONTRATO A TERCEIROS, INCLUSIVE NEGOCIAR O SALDO DEVEDOR, ATRAVS DE ANTECIPAO
                        DE RECEBVEIS, HIPTESES EM QUE PODER OFERECER O LOTE OBJETO DESTE CONTRATO EM GARANTIA, COM O
                        QUE O COMPRADOR DESDE J ANUI EXPRESSAMENTE.<br><br>
                         1 - NESTE ATO, O COMPRADOR AUTORIZA EXPRESSAMENTE AOS VENDEDORES, EM CARTER IRREVOGVEL E
                        IRRETRATVEL, A ONERAR E CEDER OS CRDITOS E/OU DIREITOS DECORRENTES DESTE CONTRATO, A FIM DE
                        QUE SEJAM UTILIZADOS EM OPERAO DE ANTECIPAO DE RECEBVEIS, POR MEIO DE EMISSO DE CCI
                        (CDULA DE CRDITO IMOBILIRIO), LCI (LETRA DE CRDITO IMOBILIRIO), LIG (LETRA IMOBILIRIA
                        GARANTIDA), CCB (CDULA DE CRDITO BANCRIO), BEM COMO UTILIZADOS COMO LASTRO NA EMISSO DE CRI
                        (CERTIFICADO DE RECEBVEIS IMOBILIRIOS), NOS TERMOS DA LEI N 9.514/97.</u></strong><br><br>
                 2 - CASO OS VENDEDORES ONEREM OU CEDAM OS CRDITOS E/OU DIREITOS DECORRENTES DESTE CONTRATO, PASSAR
                -A SER VEDADO S PARTES ALTERAR OU MODIFICAR SEUS TERMOS E CONDIES, INCLUSIVE AQUELES RELATIVOS AO
                PREO, FORMA DE PAGAMENTO E DE REAJUSTES DAS PARCELAS, SALVO MEDIANTE EXPRESSA ANUNCIA ESCRITA DA
                CESSIONRIA.<br><br>
                 3 - CASO OS VENDEDORES ONEREM OU CEDAM OS CRDITOS E/OU DIREITOS DECORRENTES DESTE CONTRATO, A
                CESSIONRIA SE SUB-ROGAR EM TODOS OS SEUS DIREITOS.<br><br>
                 4 - FICA A CESSIONRIA DESDE J AUTORIZADA A TOMAR TODAS AS PROVIDNCIAS PARA A REALIZAO DE TAL
                OPERAO, INCLUINDO AS DIVULGAES QUE FOREM NECESSRIAS PARA A COMISSO DE VALORES MOBILIRIOS E
                TERCEIROS.<br><br>
                 5 - DESDE J, AS PARTES SE COMPROMETEM A FORNECER TODA DOCUMENTAO E/OU INFORMAO NECESSRIA 
                OPERAO.<br><br>
                 6 - CASO HAJA A ONERAO OU CESSO DOS CRDITOS E/OU DIREITOS DECORRENTES DESTE CONTRATO, SER VEDADA
                S PARTES QUALQUER FORMA DE COMPENSAO DE CRDITOS RECPROCOS ESTRANHOS A ESTE CONTRATO.<br><br>
                 7 - EM CASO DE OS VENDEDORES CONSTITUIREM ALIENAO FIDUCIRIA OU HIPOTECA SOBRE O LOTE, A GARANTIA
                ABRANGER O LOTE, SUAS ACESSES, MELHORAMENTOS, INSTALAES E CONSTRUES QUE LHE FOREM
                ACRESCIDAS.<br><br>
                <strong><u> 8 - CASO SEJA EXIGIDO PELO AGENTE FINANCEIRO OU PELO CESSIONRIO, O COMPRADOR CONCORDAR
                        COM A CONTRATAO DE SEGURO DE MORTE E INVALIDEZ PERMANENTE (MIP) E DE DANOS FSICOS AO LOTE
                        (DFI).</u></strong><br><br>
            </p>
            <p class="texto">
                <strong>CLUSULA 21: DA TRANSFERNCIA DA PROPRIEDADE DO LOTE<br><br>
                    <u>APS A COMPROVAO DA QUITAO DO CONTRATO, O COMPRADOR DEVER TRANSFERIR A PROPRIEDADE DO LOTE
                        (ESCRITURAO E REGISTRO) NO PRAZO MXIMO DE 90 (NOVENTA) DIAS.<br><br>
                         1 - APS A COMPROVAO DA QUITAO DESTE CONTRATO, FICAR  DISPOSIO DO COMPRADOR, NO
                        ESCRITRIO DOS VENDEDORES, SEM NENHUM CUSTO, TERMO DE QUITAO E AUTORIZAO PARA OUTORGA DA
                        ESCRITURA DE TRANSFERNCIA DO LOTE, EM NOME DO COMPRADOR OU DE QUEM ELE INDICAR, COM VALIDADE DE
                        90 (NOVENTA) DIAS, A CONTAR DA DATA DE QUITAO DESTE CONTRATO.<br><br>
                         2 - COM O VENCIMENTO, PERDA OU EXTRAVIO DA AUTORIZAO, O COMPRADOR PAGAR A IMPORTNCIA
                        CORRESPONDENTE A 0,5% (MEIO POR CENTO) DO VALOR ATUALIZADO DESTE CONTRATO OU A UMA PARCELA
                        ATUALIZADA DESTE CONTRATO (PREVALECENDO O MENOR PREO) CADA VEZ QUE SOLICITAR NOVA EMISSO, E
                        ESTA TER VALIDADE DE 90 (NOVENTA) DIAS.<br><br>
                         3 - OS VENDEDORES PODERO, A SEU CRITRIO, OPTAR PELA TRANSFERNCIA DE PROPRIEDADE DO LOTE
                        ANTES DO RECEBIMENTO INTEGRAL DO PREO, HIPTESE EM QUE FAR A ALIENAO FIDUCIRIA, NOS TERMOS
                        DA LEI N 9.514/97. PARA TANTO, OS VENDEDORES NOTIFICARO O COMPRADOR, QUE DEVER COMPARECER
                        PARA A ASSINATURA DOS CONTRATOS NO PRAZO DE AT 15 (QUINZE) DIAS.<br><br>
                         4 - CASO O COMPRADOR NO CUMPRA QUAISQUER DAS OBRIGAES PREVISTAS NESTA CLUSULA, OS
                        VENDEDORES COBRARO MENSALMENTE O VALOR EQUIVALENTE A 0,10% (ZERO VRGULA DEZ POR CENTO) DO
                        VALOR ATUALIZADO DESTE CONTRATO, A TTULO DE MULTA MORATRIA PELO NO CUMPRIMENTO DA
                        OBRIGAO.<br><br>
                         5 - APS A COMPROVAO DA QUITAO DESTE CONTRATO, CASO O LOTE TENHA SIDO SUB-ROGADO,
                        CAUCIONADO, ONERADO, OU CEDIDO A TERCEIROS, CONFORME CLUSULA 20 DESTE CONTRATO, FICAR A CARGO
                        DOS VENDEDORES TOMAR TODAS AS PROVIDNCIAS NECESSRIAS PARA SUA LIBERAO, GARANTIDO AO
                        COMPRADOR A TRANSFERNCIA DA PROPRIEDADE DO LOTE LIVRE DE QUAISQUER NUS DECORRENTES DESTE
                        ATO.<br><br>
                         6 - TODAS AS DESPESAS NECESSRIAS PARA OUTORGA, REGISTRO E AVERBAES PARA TRANSFERNCIA DE
                        LOTE SERO DE RESPONSABILIDADE DO COMPRADOR, INCLUSIVE COM CERTIDES, ABERTURAS DE MATRCULAS,
                        CUSTAS EXTRAJUDICIAIS, TRIBUTOS E OUTRAS.</u></strong><br><br>
            </p>
            <p class="texto">
                <strong>CLUSULA 22: DA REPRESENTAO E DA SOLIDARIEDADE<br><br>
                    <u>CASO O COMPRADOR SEJA CASADO, NESTE ATO, UM CNJUGUE NOMEIA O OUTRO COMO SEU BASTANTE PROCURADOR,
                        COM PODERES ESPECIAIS E IRREVOGVEIS PARA, UM EM NOME DO OUTRO, REPRESENTAR E FAZER-SE
                        REPRESENTAR, HABILITANDO-SE A RECEBER NOTIFICAES, CARTAS, AVISOS, INTIMAES, CITAES,
                        EFETUAR ACORDOS, RECEBER QUANTIAS EM DEVOLUO, DAR QUITAO, ASSINAR TERMOS ADITIVOS OU DE
                        RESCISO CONTRATUAL E ESCRITURAS.<br><br>
                         1 - O COMPRADOR, NESTE ATO, NOMEIA E CONSTITUI OS VENDEDORES COMO SEUS PROCURADORES, EM
                        CARTER IRREVOGVEL E IRRETRATVEL, NOS TERMOS DO ART. 684 E PARGRAFO NICO DO ART. 686, DO
                        CDIGO CIVIL OUTORGANDO-LHE OS SEGUINTES PODERES: A) REPRESENT-LO PERANTE A PREFEITURA
                        MUNICIPAL, OBJETIVANDO A ATUALIZAO CADASTRAL IMOBILIRIA FISCAL E/OU ALTERAO DO PROJETO DE
                        LOTEAMENTO; B) REPRESENT-LO PERANTE O CARTRIO DE REGISTRO DE IMVEIS; C) REPRESENT-LO EM
                        ESCRITURA PBLICA OU PARTICULAR QUE TENHA O OBJETIVO DE TRANSFERIR LOTE PARA O NOME DO
                        COMPRADOR, FICANDO AO EXCLUSIVO CRITRIO DOS VENDEDORES GRAV-LO COM NUS DE ALIENAO
                        FIDUCIRIA, NOS TERMOS DA LEI N 9,514/97; D) SUBSTABELECER, COM OU SEM RESERVA, NO TODO OU EM
                        PARTE, OS PODERES OUTORGADOS.<br><br>
                         2 - O COMPRADOR E SEU CNJUGUE SE DECLARAM SOLIDARIAMENTE RESPONSVEIS PELO CUMPRIMENTO DE
                        TODAS AS OBRIGAES ASSUMIDAS NESTE CONTRATO.</u></strong><br><br>
            </p>
            <p class="texto">
                <strong>CLUSULA 23: DO FORO<br><br>
                    <u>ELEGEM O FORO DA COMARCA
                        DE <?= Helper::str2Upper($empresa['cidade']['nome'] . ' - ' . $empresa['cidade']['uf']) ?>, PARA
                        DIRIMIREM QUAISQUER CONTROVRSIAS DECORRENTES DESTE CONTRATO.</u></strong><br><br>
                POR ESTAREM JUSTOS E CONTRATADOS, ASSINAM O PRESENTE, EM 02 (DUAS) VIAS DE IGUAL TEOR E FORMA, EM
                CARTER IRREVOGVEL E IRRETRATVEL, OBRIGANDO SEUS HERDEIROS E SUCESSORES AO FIEL CUMPRIMENTO DESTE, NA
                PRESENA DE DUAS TESTEMUNHAS, QUE A TUDO LERAM E ACHARAM CONFORME.<br><br>
            </p>
        </div>
        <div align="right">
            <p class="texto" align="right">
                <?= $cidadeEmpreedimento['nome'] . ", $dia de " . strtolower(Helper::getMes(str_pad($mes, 2, '0', STR_PAD_LEFT))) . " de $ano."; ?>
            </p>
        </div>

        <div style="margin-top:20px;" align="center">
            <!-- CLIENTES -->
            <?php if ($cliente): ?>
                ____________________________________________________________
                <p align="center">
                    <strong>
                        <?= $cliente['nm_pessoa'] ?><br>
                        <?= $cliente['nr_cpf'] . $cliente['nr_cnpj'] ?>
                    </strong>
                </p>
                <br>
                <?php if (($cliente['est_civil'] == 'CAS' || $cliente['est_civil'] == 'UNE') && $cliente['conjugeP']) : ?>
                    ____________________________________________________________
                    <p align="center">
                        <strong>Cnjuge</strong>
                    </p>
                <?php endif; ?>
                <br>
                <br>
            <?php endif; ?>
        </div>
        <div align="center">

            <!--OUTROS COMPRADORES-->
            <?php if ($outrosCompradores): ?>
                <?php foreach ($outrosCompradores as $comprador): ?>
                    ____________________________________________________________
                    <p align="center">
                        <strong><?= $comprador['nm_pessoa'] ?><br>
                            <?= $comprador['nr_cpf'] . $comprador['nr_cnpj'] ?>
                        </strong>
                    </p>
                    <br>
                    <?php if (($comprador['est_civil'] == 'CAS' || $comprador['est_civil'] == 'UNE') && $comprador['conjuge']) : ?>
                        ____________________________________________________________
                        <p align="center">
                            <strong>Cnjuge</strong>
                        </p>
                    <?php endif; ?>
                    <br>
                    <br>
                <?php endforeach ?>
            <?php endif ?>
        </div>
        <div align="center">

            <!-- VENDEDOR -->
            <?php if ($vendedores): ?>
                <?php foreach ($vendedores as $vendedor): ?>
                    ____________________________________________________________
                    <p align="center">
                        <strong><?= $vendedor['nm_pessoa'] ?><br>
                            <?= $vendedor['nr_cpf'] . $vendedor['nr_cnpj'] ?>
                        </strong>
                    </p>
                    <br>
                    <br>
                <?php endforeach ?>
            <?php endif ?>
        </div>
        <div align="center">
            <!-- TESTEMUNHAS -->
            ________________________________________ &emsp;&emsp;&emsp;
            ________________________________________
            <p align="center">
                <strong>
                    TESTEMUNHA 1 &emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp;
                    &emsp;&emsp;&emsp;&emsp;&emsp;&emsp;&emsp; TESTEMUNHA 2
                </strong>
            </p>
            <br>
        </div>
    </div>
</page>


