<?php
$empreendimento = $this->get('empreendimento');
$lote = $this->get('lote');
$cliente = $this->get('cliente');
$contrato = $this->get('contrato');
$outrosCompradores = $this->get('pessoas_envolvidas');
$sinal = $this->get('sinal');

if ($contrato['fl_itens_contrato'] == 1)
    $adicionais = $this->get('adicionais');

$parcerias = $this->get('parceria');
foreach ($parcerias as $parceiro) {
    $vendedores[] = Pessoa::findById($parceiro['id_pessoa']);
}

$cidadeEmpreedimento = array();
if ($cidadeEmpreedimento = Db_Cidade::find($empreendimento['cd_cidade']))
    $cidadeEmpreedimento = $cidadeEmpreedimento->toArray();

$vlsinal = ($contrato['vl_sinal'] > 0 && $contrato['inclui_sinal_contrato']) ? $contrato['vl_sinal'] : 0;
$total = 0;
$total += ($contrato['vl_total'] > 0) ? $contrato['vl_total'] : 0;
$total += $vlsinal;
$total += ($contrato['vl_parcela'] > 0) ? $contrato['nr_parcela'] * $contrato['vl_parcela'] : 0;
$total += ($contrato['vl_intercalada'] > 0) ? $contrato['vl_intercalada'] * $contrato['nr_intercalada'] : 0;
$total += ($contrato['vl_parcela_entrega'] > 0) ? $contrato['vl_parcela_entrega'] * $contrato['nr_parcela_entrega'] : 0;
if (isset($adicionais))
    foreach ($adicionais as $item)
        $total += $item['valor'] * $item['qtd'];

$primeiroDia = date_parse_from_format('Y-m-d', $contrato['dt_primeira_parcela'])['day'];
$ultimaParcela = date('Y-m-d', strtotime("+" . ($contrato['nr_parcela'] - 1) . " month", strtotime($contrato['dt_primeira_parcela'])));

$arrData = explode("-", $contrato['dt_contrato']);
$dia = $arrData[2];
$mes = $arrData[1];
$ano = $arrData[0];
?>
<style type="text/css">

    .conteudoPdf {
        font-size: 12px;
        display: inline-block;
    }

    #titulo1 {
        width: 700px;
        font-size: 12pt;
        font-weight: bold;
    }

    #titulo2 {
        width: 700px;
        font-size: 12pt;
        font-weight: bold;
    }

    .texto {
        width: 750px;
        font-size: 12pt;
    }

</style>


<page backtop="0mm" backbottom="0mm" backleft="0mm" backright="0mm">
    <div class="conteudoPdf" width="640px">
        <div id="titulo1" align="center">
            QUADRO-RESUMO VINCULADO AO CONTRATO PARTICULAR DE COMPRA E VENDA COM PACTO DE ALIENAO FIDUCIRIA
            <br>
            ANEXO I
        </div>

        <br/>
        <div id="titulo2" align="center">
            CONTRATO N <strong><?= $contrato['id'] ?></strong><br>
            EMPREENDIMENTO: <strong><?= Helper::str2Upper($empreendimento['nm_empreendimento']) ?></strong>
        </div>
        <br>

        <div style="width: 700px">
            <p class="texto">
                <strong>01 - DAS PARTES: <br><br>
                    COMPRADOR(A)(ES): </strong>
                <?= $this->gerarCitacaoDados($cliente); ?>
                <?php if (count($outrosCompradores)) : ?>
                    <?php foreach ($outrosCompradores as $comprador) : ?>
                        <?= $this->gerarCitacaoDados($comprador); ?>
                    <?php endforeach; ?>
                <?php endif; ?>
                <br>
                <br>
                <strong>ALIENANTE(S):</strong> Adiante designado(a)(s)
                "VENDEDORA(A)(ES)", <?= $this->get('citacaoDados') ?>
            </p>
        </div>

        <div style="width: 700px">
            <p class="texto">
                <strong>02 - IMVEL(IS) OBJETO DO CONTRATO: </strong><br>
                <br>
                Quadra - <strong><?= $lote['quadra']; ?></strong>,	Lote - <strong><?= $lote['lote']; ?></strong>
                do Empreendimento <?= $empreendimento['nm_empreendimento'] ?>, <?= $empreendimento['tipo'] ?> situado em
                <?= $cidadeEmpreedimento['nome'] ?> - <?= $cidadeEmpreedimento['uf'] ?>
                com <?= Helper::getMoney($lote['area']) ?>m de rea total.
                <br>
                <br>
                <strong><?= Helper::getMoney($lote['frente']) ?> metros de frente,<br>
                    <?= Helper::getMoney($lote['fundo']) ?> metros de fundo,<br>
                    <?= Helper::getMoney($lote['direita']) ?> metros de lateral direita,<br>
                    <?= Helper::getMoney($lote['esquerda']) ?> metros de lateral esquerda.
                </strong>
            </p>
        </div>

        <div style="width: 700px">
            <p class="texto">
                <strong>03 - PREO E FORMA DE PAGAMENTO: <br></strong>
                <br>
                O preo do lote ser pago pelo (a)(s) COMPRADOR(A)(ES), da seguinte forma:<br>
                <br>
                <?php if ($contrato['inclui_sinal_contrato'] == 1): ?>
                    <b>a)</b> Neste ato, a ttulo de <strong>sinal</strong> e princpio de pagamento e que,
                    assinando o presente instrumento, a ALIENANTE declara haver recebido neste ato do ADQUIRENTE, a importncia de R$
                    <?= Helper::getMoney($sinal[0]['valor']) ?>
                    (<?= Helper::valorPorExtenso($sinal[0]['valor']) ?>)
                    , em cheque/dinheiro, no momento da assinatura da proposta
                    <?php if (count($sinal) > 1) : ?>
                        e mais <?= count($sinal) - 1 ?> parcelas
                        de R$ <?= Helper::getMoney($sinal[1]['valor']) ?>
                        (<?= Helper::valorPorExtenso($sinal[1]['valor']) ?>)
                        em cheque/dinheiro, totalizando o valor de R$
                        <?= Helper::getMoney($contrato['vl_sinal']) ?>
                        (<?= Helper::valorPorExtenso($contrato['vl_sinal']) ?>)
                        , com vencimentos em
                        <?php foreach ($sinal as $k => $s) : ?>
                            <?= ($k > 0) ? Helper::getDate($s['dtVencimento']) : '' ?>
                            <?= ($k > 0 && $k < count($sinal) - 1) ? ', ' : '' ?>
                        <?php endforeach; ?>
                    <?php endif; ?>.
                    <br/><br/>
                <?php endif; ?>

                <b><?= ($contrato['inclui_sinal_contrato'] == 1) ? 'b' : 'a' ?>)</b> O valor de R$
                <?= Helper::getMoney($total - $vlsinal) ?>
                (<?= Helper::valorPorExtenso($total - $vlsinal) ?>),
                referente ao saldo restante que ser dividido em
                <?= $contrato['nr_parcela']; ?>
                (<?= Helper::valorPorExtenso($contrato['nr_parcela'], false, true) ?>)
                parcelas mensais no valor de R$ <?= Helper::getMoney($contrato['vl_parcela']) ?>
                (<?= Helper::valorPorExtenso($contrato['vl_parcela']) ?>) cada, com reajustes e
                atualizao monetria anual calculada pela variao do
                ndice Geral de Preos do Mercado (IGP-M), apurado pela Fundao Getlio Vargas (FGV),
                previsto no pagamento do lote determinado no item 02,
                representadas por cheques nominais, boletos e/ou transferncia eletrnica - TED,
                em carter pr-solvendo, com vencimento para o
                dia <?= $primeiroDia ?> (<?= Helper::valorPorExtenso($primeiroDia, false, true) ?>)
                de cada ms, sendo a primeira parcela com vencimento no
                dia <?= Helper::getDate($contrato['dt_primeira_parcela']) ?> e a ltima com vencimento
                no dia <?= Helper::getDate($ultimaParcela) ?>.
            </p>
        </div>

        <div style="width: 700px">
            <p class="texto">
                <strong>04 - </strong>O(A,s) <strong>COMPRADOR(A,ES)</strong> declara(m) para os devidos fins, ter(em)
                plena cincia dos
                valores e condies de pagamento do presente contrato.<br>
                <br>
                <strong>O valor Total do Contrato: R$ <?= Helper::getMoney($total) ?></strong><br>
                <br>
                O preo certo e total ajustado para a presente promessa de compra e venda  R$
                <?= Helper::getMoney($total) ?>
                (<?= Helper::valorPorExtenso($total) ?>) o qual ser pago pelo
                <strong>ADQUIRENTE</strong>  <strong>ALIENANTE</strong> da maneira estipulada acima.
                <br>
            </p>
        </div>

        <div style="width: 700px">
            <p class="texto">
                <strong>05 - LOCAL E DATA DE ASSINATURA DO CONTRATO:</strong><br>
                <br>
                <br>
                <?= $cidadeEmpreedimento['nome'] . ", $dia de " . strtolower(Helper::getMes(str_pad($mes, 2, '0', STR_PAD_LEFT))) . " de $ano."; ?>
            </p>
        </div>


        <div style="margin-top:20px; width: 700px" align="center">
            <!-- CLIENTES -->
            <?php if ($cliente): ?>
                ____________________________________________________________
                <p align="center" style="font-size: 12pt;">
                    <?= Helper::str2Upper($cliente['nm_pessoa']) ?><br>
                    <?= $cliente['nr_cpf'] . $cliente['nr_cnpj'] ?>
                </p>
                <br>
                <br>
            <?php endif; ?>

            <!--OUTROS COMPRADORES-->
            <?php if ($outrosCompradores): ?>
                <?php foreach ($outrosCompradores as $comprador): ?>
                    ____________________________________________________________
                    <p align="center" style="font-size: 12pt;">
                        <?= Helper::str2Upper($comprador['nm_pessoa']) ?><br>
                        <?= $comprador['nr_cpf'] . $comprador['nr_cnpj'] ?>
                    </p>
                    <br>
                    <br>
                <?php endforeach ?>
            <?php endif ?>

            <!-- VENDEDOR -->
            <?php if ($vendedores): ?>
                <?php foreach ($vendedores as $vendedor): ?>
                    ____________________________________________________________
                    <p align="center" style="font-size: 12pt;">
                        <?= Helper::str2Upper($vendedor['nm_pessoa']) ?><br>
                        <?= $vendedor['nr_cpf'] . $vendedor['nr_cnpj'] ?>
                    </p>
                    <br>
                    <br>
                <?php endforeach ?>
            <?php endif ?>
        </div>
        <div style="margin-top:20px; width: 700px; float: left" align="center">
            <!-- CLIENTES -->
            ________________________________________ <span style="margin: 30px"></span>
            ________________________________________
            <p align="center" style="font-size: 12pt;">
                		TESTEMUNHA 1																										TESTEMUNHA
                2
            </p>
        </div>
    </div>
</page>


