<?php
$pagInicial = $this->get('pagInicial');
$pagFinal = $this->get('pagFinal');
$empreendimento = $this->get('empreendimento');
$lote = $this->get('lote');
$cliente = $this->get('cliente');
$contrato = $this->get('contrato');
$indiceReajuste = $this->get('indiceReajuste');
//outros compradores
$outrosCompradores = $this->get('pessoas_envolvidas');
//contador de registros de pagamento para quebra de pgina
$assinaturas = count($outrosCompradores);
if ($cliente['est_civil'] == 'CAS' || $cliente['est_civil'] == 'UNE') {
    $assinaturas++;
}

if ($contrato['fl_itens_contrato'] == 1) {
    $adicionais = $this->get('adicionais');
    $itensContrato = $this->get('itensContrato');
}

$pessoaEnvolvida = $this->get('pessoaEnvolvida');
$pessoaResponsavel = $this->get('pessoaResponsavel');

$cidadeEmpreedimento = array();
if ($cidadeEmpreedimento = Db_Cidade::find($empreendimento['cd_cidade']))
    $cidadeEmpreedimento = $cidadeEmpreedimento->toArray();
$parcelaMensal = '';
if ($contrato['vl_parcela'] > 0)
    $parcelaMensal = $contrato['nr_parcela'] . ' (' . Helper::valorPorExtenso($contrato['nr_parcela'], false, true, false, true) . ')' . ' parcela(s) mensal(s) de ' . Helper::getMoney($contrato['vl_parcela']) . ' (' . Helper::valorPorExtenso($contrato['vl_parcela']) . ')';
$parcelaIntercalada = '';
if ($contrato['vl_intercalada'] > 0)
    $parcelaIntercalada = ', ' . $contrato['nr_intercalada'] . ' (' . Helper::valorPorExtenso($contrato['nr_intercalada'], false, true, false, true) . ')' . ' parcela(s) intercalada(s) de ' . Helper::getMoney($contrato['vl_intercalada']) . ' (' . Helper::valorPorExtenso($contrato['vl_intercalada']) . ')';
$parcelaChave = '';
if ($contrato['vl_parcela_entrega'] > 0)
    $parcelaChave = ', ' . $contrato['nr_intercalada'] . ' (' . Helper::valorPorExtenso($contrato['nr_intercalada'], false, true, false, true) . ')' . ' parcela(s) chave(s) de ' . Helper::getMoney($contrato['vl_parcela_entrega']) . ' (' . Helper::valorPorExtenso($contrato['vl_parcela_entrega']) . ')';

if (count($itensContrato)) {
    foreach ($adicionais as $item) {
        switch ($item['tipo']) {
            case 'N':
                $parcelaMensal .= ', ' . $item['qtd'] . ' (' . Helper::valorPorExtenso($item['qtd'], false, true, false, true) . ')' . ' parcela(s) mensal(s) de ' . Helper::getMoney($item['valor']) . ' (' . Helper::valorPorExtenso($item['valor']) . ')';
                break;
            case 'I':
                $parcelaIntercalada .= ', ' . $item['qtd'] . ' (' . Helper::valorPorExtenso($item['qtd'], false, true, false, true) . ')' . ' parcela(s) intercalada(s) de ' . Helper::getMoney($item['valor']) . ' (' . Helper::valorPorExtenso($item['valor']) . ')';
                break;
            case 'C':
                $parcelaChave .= ', ' . $item['qtd'] . ' (' . Helper::valorPorExtenso($item['qtd'], false, true, false, true) . ')' . ' parcela(s) chave(s) de ' . Helper::getMoney($item['valor']) . ' (' . Helper::valorPorExtenso($item['valor']) . ')';
                break;
        }
    }
}
$parcelaMensal .= ', vencendo a primeira em ' . Helper::getDate($contrato['dt_primeira_parcela']) . ', e as demais nos mesmo dias dos meses subsequentes at a ltima';

?>
<style type="text/css">

    .conteudoPdf {
        width: 100%;
        font-size: 12px;
        text-align: justify;
        content: "";
        display: inline-block;
    }

    #titulo1 {
        text-decoration: underline;
    }

    #titulo2 {
        margin-left: 60px;
        margin-top: 30px;;
    }

</style>


<page backtop="10mm" backbottom="10mm" backleft="10mm" backright="10mm">
    <div class="conteudoPdf">
        <strong id="titulo1">Anexo 01 - QUADRO RESUMO</strong>

        <p id="titulo2">OBJETO DA VENDA E COMPRA: <strong>Lote <?= $lote['lote'] ?> Quadra <?= $lote['quadra'] ?>
                Medindo <?= $lote['area'] ?>m</strong></p><br/>

        <!-- Informaes do Empreendimento -->
        <table>
            <tr>
                <td style="width:400px;">Empreendimento: <strong><?= $empreendimento['nm_empreendimento'] ?></strong>
                </td>
                <td>Cidade: <strong><?= $cidadeEmpreedimento['nome'] . '/' . $cidadeEmpreedimento['uf'] ?></strong></td>
            </tr>
            <tr>
                <td colspan="2">Registro do Loteamento:
                    <strong><?= $empreendimento['rgi'] ?></strong></td>
            </tr>
        </table>
        <br>
        <table>
            <tr>
                <td style="width:714px;">Matrcula do Lote: <strong><?= $lote['rgi'] ?></strong></td>
            </tr>
            <tr>
                <td style="width:714px;">Descrio do Lote:
                    <strong>Frente: <?php echo $lote['conf_frente']; ?> (<?php echo $lote['frente']; ?> m) -
                        LD.: <?php echo $lote['conf_direita']; ?> (<?php echo $lote['direita']; ?> m) -
                        LE.: <?php echo $lote['conf_esquerda']; ?> (<?php echo $lote['esquerda']; ?> m) e fundos
                        com <?php echo $lote['conf_fundo']; ?> (<?php echo $lote['fundo']; ?> m).</strong></td>
            </tr>
        </table>
        <br>
        <!-- VENDEDORA -->
        <table>
            <tr>
                <td>
                    <p style="text-align:justify">
                        <strong>VENDEDORA:</strong><br/><br/>

                        <!-- Pessoa Envolvida -->
                        <strong><?= $pessoaEnvolvida['nm_pessoa'] ?></strong>, empresa devidamente inscrita no CNPJ sob
                        n <?= $pessoaEnvolvida['nr_cnpj'] ?>, com sede na <?= $pessoaEnvolvida['endereco'] ?>
                        <?= ($pessoaEnvolvida['nr_endereco']) ? ', ' . $pessoaEnvolvida['nr_endereco'] : '' ?><?= ($pessoaEnvolvida['ds_complemento']) ? ', ' . $pessoaEnvolvida['ds_complemento'] : '' ?>
                        , <?= $pessoaEnvolvida['nm_bairro'] ?>, <?= $pessoaEnvolvida['nmCidade'] ?>
                        , <?= $pessoaEnvolvida['ufCidade'] ?>, CEP <?= $pessoaEnvolvida['nr_cep'] ?>,

                        <!-- Pessoa Responsavel -->
                        neste ato representada por seu(s) administrador(es),
                        <?php foreach ($pessoaResponsavel as $pr): ?>
                            <strong><?= $pr['nm_pessoa'] ?></strong>, <?= $pr['nm_nacionalidade'] ?>
                            , <?= ($pr['est_civil'] == 'CAS' || $pr['est_civil'] == 'UNE') ? $pr['est_civil_nome'] . ' sob regime comunho parcial de bens' : $pr['est_civil_nome'] ?>
                            , <?= $pr['nm_profissao'] ?>, portador do RG <?= $pr['nr_rg'] ?> e
                            do CPF <?= $pr['nr_cpf'] ?>, residente e domiciliado
                             <?= $pr['endereco'] ?><?= ($pr['nr_endereco']) ? ', ' . $pr['nr_endereco'] : '' ?><?= ($pr['ds_complemento']) ? ', ' . $pr['ds_complemento'] : '' ?>, <?= $pr['nm_bairro'] ?>, no municpio
                            de <?= $pr['nmCidade'] ?> estado de <?= $pr['uf_nome'] ?>,
                            CEP <?= $pr['nr_cep'] ?>.
                        <?php endforeach; ?>
                    </p>
                </td>
            </tr>
        </table>

        <br>
        <!-- COMPRADOR -->
        <table>
            <tr>
                <td colspan="3" width="714px;"><strong>COMPRADOR(ES):</strong><br/><br/></td>
            </tr>
            <tr>
                <td style="width:450px;" width="450px;" colspan="2">Nome: <strong><?= $cliente['nm_pessoa'] ?></strong></td>
                <td>Data Nasc.:
                    <strong><?= ($cliente['dt_nascimento']) ? Helper::getDate($cliente['dt_nascimento']) : '' ?></strong>
                </td>
            </tr>
            <tr>
                <td>RG: <strong><?= $cliente['nr_rg'] ?></strong></td>
                <td>CPF: <strong><?= $cliente['nr_cpf'] ?></strong></td>
                <td>Nacionalidade: <strong><?= $cliente['nm_nacionalidade'] ?></strong></td>
            </tr>
            <tr>
                <td style="width:450px;" width="450px;" colspan="2">Estado Cvil: <strong><?= $cliente['est_civil_nome'] ?></strong>
                </td>
                <td>Profisso: <strong><?= $cliente['nm_profissao'] ?></strong></td>
            </tr>
            <tr>
                <td style="width:450px;" width="450px;" colspan="2">Endereo:
                    <strong><?= $cliente['endereco'] ?><?= ($cliente['nr_endereco']) ? ', ' . $cliente['nr_endereco'] : '' ?><?= ($cliente['ds_complemento']) ? ', ' . $cliente['ds_complemento'] : '' ?></strong>
                </td>
                <td>Bairro: <strong><?= $cliente['nm_bairro'] ?></strong></td>
            </tr>
            <tr>
                <td>Cidade: <strong><?= $cliente['cidade']['nome'] ?></strong></td>
                <td>Estado: <strong><?= $cliente['cidade']['uf'] ?></strong></td>
                <td>CEP: <strong><?= $cliente['nr_cep'] ?></strong></td>
            </tr>
            <tr>
                <td colspan="3">Telefone: <strong><?= $cliente['nr_telefone'] ?></strong></td>
            </tr>

            <?php if (($cliente['est_civil'] == 'CAS' || $cliente['est_civil'] == 'UNE') && $cliente['conjugeP']) { ?>
                <tr>
                    <td colspan="3"><br>Cnjuge: <strong><?= $cliente['conjugeP']['nm_pessoa'] ?></strong></td>
                </tr>
                <tr>
                    <td>RG: <strong><?= $cliente['conjugePF']['nr_rg'] ?></strong></td>
                    <td>CPF: <strong><?= $cliente['conjugePF']['nr_cpf'] ?></strong></td>
                    <td>Data Nasc.:
                        <strong><?= ($cliente['conjugePF']['dt_nascimento']) ? Helper::getDate($cliente['conjugePF']['dt_nascimento']) : '' ?></strong>
                    </td>
                </tr>
                <tr>
                    <td>Profisso: <strong><?= $cliente['conjugePF']['nm_profissao'] ?></strong></td>
                    <td>Telefone: <strong><?= $cliente['conjugeP']['nr_telefone'] ?></strong></td>
                    <td>Nacionalidade: <strong><?= $cliente['conjugePF']['nm_nacionalidade'] ?></strong></td>
                </tr>
            <?php } ?>

            <?php if ($outrosCompradores): ?>
                <?php foreach ($outrosCompradores as $comprador): ?>
                    <tr>
                        <td style="padding-top: 15px; width:450px;" width="450px;" colspan="2">Nome:
                            <strong><?= $comprador['nm_pessoa'] ?></strong></td>
                        <td style="padding-top: 15px;">Data Nasc.:
                            <strong><?= ($comprador['dt_nascimento']) ? Helper::getDate($comprador['dt_nascimento']) : '' ?></strong>
                        </td>
                    </tr>
                    <tr>
                        <td>RG: <strong><?= $comprador['nr_rg'] ?></strong></td>
                        <td>CPF: <strong><?= $comprador['nr_cpf'] ?></strong></td>
                        <td>Nacionalidade: <strong><?= $comprador['nm_nacionalidade'] ?></strong></td>
                    </tr>
                    <tr>
                        <td style="width:450px;" width="450px;" colspan="2">Estado Cvil:
                            <strong><?= $comprador['est_civil_nome'] ?></strong>
                        </td>
                        <td>Profisso: <strong><?= $comprador['nm_profissao'] ?></strong></td>
                    </tr>
                    <tr>
                        <td style="width:450px;" width="450px;" colspan="2">Endereo:
                            <strong><?= $comprador['endereco'] ?><?= ($comprador['nr_endereco']) ? ', ' . $comprador['nr_endereco'] : '' ?><?= ($comprador['ds_complemento']) ? ', ' . $comprador['ds_complemento'] : '' ?></strong>
                        </td>
                        <td>Bairro: <strong><?= $comprador['nm_bairro'] ?></strong></td>
                    </tr>
                    <tr>
                        <td>Cidade: <strong><?= $comprador['nmcidade'] ?></strong></td>
                        <td>Estado: <strong><?= $comprador['ufcidade'] ?></strong></td>
                        <td>CEP: <strong><?= $comprador['nr_cep'] ?></strong></td>
                    </tr>
                    <tr>
                        <td colspan="3">Telefone: <strong><?= $comprador['nr_telefone'] ?></strong></td>
                    </tr>
                <?php endforeach ?>
            <?php endif ?>

            <tr>
                <td colspan="3"><br>Dados para Cobrana:</td>
            </tr>
            <tr>
                <td colspan="3">Endereo:
                    <strong><?= $cliente['endereco'] ?><?= ($cliente['nr_endereco']) ? ', ' . $cliente['nr_endereco'] : '' ?><?= ($cliente['ds_complemento']) ? ', ' . $cliente['ds_complemento'] : '' ?></strong>
                </td>
            </tr>
            <tr>
                <td>Cidade: <strong><?= $cliente['cidade']['nome'] ?></strong></td>
                <td>Estado: <strong><?= $cliente['cidade']['uf'] ?></strong></td>
                <td>Bairro: <strong><?= $cliente['nm_bairro'] ?></strong></td>
            </tr>
            <tr>
                <td colspan="3">CEP: <strong><?= $cliente['nr_cep'] ?></strong></td>
            </tr>
        </table>

        <br>
        <?php
        $sinal = ($contrato['vl_sinal'] > 0 && $contrato['inclui_sinal_contrato']) ? $contrato['vl_sinal'] : 0;
        $total = 0;
        $total += ($contrato['vl_total'] > 0) ? $contrato['vl_total'] : 0;
        $total += $sinal;
        $total += ($contrato['vl_parcela'] > 0) ? $contrato['nr_parcela'] * $contrato['vl_parcela'] : 0;
        $total += ($contrato['vl_intercalada'] > 0) ? $contrato['vl_intercalada'] * $contrato['nr_intercalada'] : 0;
        $total += ($contrato['vl_parcela_entrega'] > 0) ? $contrato['vl_parcela_entrega'] * $contrato['nr_parcela_entrega'] : 0;
        if (isset($adicionais))
            foreach ($adicionais as $item)
                $total += $item['valor'] * $item['qtd'];
        ?>

        <?php if ($assinaturas >= 3): ?>
    </div>
    <page_footer>
        <div align="right">Pgina <strong><?php echo($pagInicial . '</strong> de <strong>' . $pagFinal) ?></strong>
        </div>
    </page_footer>

</page>

<page backtop="10mm" backbottom="10mm" backleft="10mm" backright="10mm">
    <div class="conteudoPdf">
        <?php endif ?>
        <!-- PREO E CONDIES DO PAGAMENTO -->
        <table>
            <tr>
                <td><strong>PREO E CONDIES DO PAGAMENTO:</strong><br/><br/></td>
            </tr>
            <tr>
                <td>1 - Preo total ajustado:<br/><br/></td>
            </tr>
            <tr>
                <td style="padding-left: 20px;">O preo certo e ajustado pela venda  de R$ <strong
                        style="float:left;"><?= Helper::getMoney($total) ?></strong> <strong
                        style="float:left;font-weight: normal;">(<?= utf8_decode(Helper::valorPorExtenso($total))?>)</strong>.
                    <br><br>
                </td>
            </tr>

            <tr>
                <td>2 - Condies de Pagamento:</td>
            </tr>
            <?php
            $letra = 'a';
            if ($contrato['inclui_sinal_contrato'] == 1):
                $letra = 'b'; ?>
                <tr>
                    <td style="padding-left: 20px;">
                        a) Como entrada, sinal e princpio de pagamento, a importncia de R$ <strong
                            style="float:left;"><?= Helper::getMoney($contrato['vl_sinal']) ?></strong> <strong
                            style="float:left;font-weight: normal;">(<?= utf8_decode(Helper::valorPorExtenso($contrato['vl_sinal']))?>)</strong>, pagos neste ato, dando-se quitao aps compensao da forma de pagamento eleita
                        pelo <strong>COMPRADOR</strong>.<br/><br/>
                    </td>
                </tr>
            <?php endif; ?>
            <tr>
                <td style="padding-left: 20px;">
                    <?= $letra ?>) O saldo de R$ <strong
                        style="float:left;"><?= utf8_decode(Helper::getMoney($total - $sinal)) ?></strong>
                    <strong style="float:left;font-weight: normal;">(<?= Helper::valorPorExtenso($total - $sinal) ?>)</strong> a serem pagos
                    em <?= $parcelaMensal . $parcelaIntercalada . $parcelaChave; ?>, acrescidas de
                    correo monetria conforme contrato
                    <br>
                </td>
            </tr>
            <?php if ($contrato['obs']): ?>
                <tr>
                    <td><br><br><strong>OBSERVAO:</strong></td>
                </tr>
                <tr>
                    <td style="padding-left: 20px;">
                        <?php echo $contrato['obs']; ?>
                    </td>
                </tr>
            <?php endif; ?>
        </table>
        <?php if ($assinaturas < 3): ?>
    </div>
    <page_footer>
        <div align="right">Pgina <strong><?php echo($pagInicial . '</strong> de <strong>' . $pagFinal) ?></strong>
        </div>
    </page_footer>
</page>

<page backtop="10mm" backbottom="10mm" backleft="10mm" backright="10mm">
    <div class="conteudoPdf">
        <?php endif ?>

        <!-- ENCARGOS FINANCEIROS SOBRE A PARCELA -->
        <table>
            <tr>
                <td><p><strong><u>Encargos Financeiros sobre a Parcela:</u></strong></p></td>
            </tr>
            <?php if ($contrato['dt_reajuste'] == null) : ?>
                <tr>
                    <td style="padding-left: 20px;">a) Este contrato no est sujeito a reajuste.
                    </td>
                </tr>

            <?php else: ?>
                <tr>
                    <td style="padding-left: 20px;">
                        <p>a) ndice <?= $indiceReajuste?>, conforme Clusula Primeira.</p>
                    </td>
                </tr>
            <?php endif; ?>
        </table>

        <!-- DE ACORDO -->
        <table style="margin-top:30px;">
            <tr>
                <td>DE ACORDO:</td>
            </tr>
        </table>


        <table style="margin-top:10px;">
            <!-- PESSOA RESPONSAVEL (ASSINATURAS) -->
            <?php if (count($pessoaResponsavel) > 0): ?>
                <tr>
                <?php for ($i = 1;
                           $i <= count($pessoaResponsavel);): ?>
                    <?php if (($i % 2) != 0) : ?>
                        </tr>
                        <tr>
                    <?php endif; ?>
                    <td style="padding-top: 20px; width:340px;">
                        __________________________________________________
                        <p>
                            <strong>Promitente Vendedora</strong>
                            <?php
                            $i++; ?>
                        </p>
                    </td>
                <?php endfor; ?>
                </tr>
            <?php endif; ?>

            <!-- CLIENTES -->
            <?php if ($cliente): ?>
                <tr>
                    <td style="padding-top: 20px; width:340px;">__________________________________________________
                        <p>
                            <strong><?php echo $cliente['nm_pessoa'] ?></strong>
                        </p>
                    </td>
                    <?php if (($cliente['est_civil'] == 'CAS' || $cliente['est_civil'] == 'UNE') && $cliente['conjugeP']) { ?>
                        <td style="padding-top: 20px; width:340px;">__________________________________________________
                            <p>
                                <strong>Cnjuge</strong>
                            </p>
                        </td>
                    <?php } ?>
                </tr>
            <?php endif; ?>

            <!--OUTROS COMPRADORES-->
            <?php if ($outrosCompradores): $i = 1; ?>
                <tr>
                <?php foreach ($outrosCompradores as $comprador): ?>
                    <?php if (($i % 2) != 0) : ?>
                        </tr>
                        <tr>
                    <?php endif; ?>
                    <td style="padding-top: 20px; width:340px;">
                        __________________________________________________
                        <p>
                            <strong><?php echo $comprador['nm_pessoa'] ?></strong>
                        </p>
                    </td>
                    <?php if (($comprador['est_civil'] == 'CAS' || $comprador['est_civil'] == 'UNE') && $comprador['conjuge']) { ?>
                        <td style="padding-top: 20px; width:340px;">
                            __________________________________________________
                            <p>
                                <strong>Cnjuge</strong>
                            </p>
                        </td>
                    <?php } ?>
                <?php endforeach ?>
                </tr>
            <?php endif ?>
        </table>
    </div>

    <page_footer>
        <div align="right">Pgina <strong><?php if ($pagI + 1 == $pagFinal) {
                    echo($pagFinal . '</strong> de <strong>' . $pagFinal);
                } else {
                    echo($pagInicial + 1 . '</strong> de <strong>' . $pagFinal);
                } ?></strong></div>
    </page_footer>
</page>


