<?php
/**
 * Created by PhpStorm.
 * User: Maik
 * Date: 02/12/19
 * Time: 08:43
 */

$sinal = $this->get('sinal');
$empreendimento = $this->get('empreendimento');
$lote = $this->get('lote');
$cliente = $this->get('cliente');
$parceria = $this->get('parceria');
$contrato = $this->get('contrato');
$isVista = ($contrato['fl_avista'] == 'S');
$citacao = $this->get('citacao');
$empreendimentoInfo = $this->get('empreendimentoInfo');
$corretor = $this->get('corretor');

if ($_SESSION['tipoDoc'] == 'word') {
    //Salva Log de download do arquivo word.
    $log = new Relacionamento();
    $log->saveContato('13', date('Y-m-d'), $contrato['id'], 'Log: download de arquivo tipo word. LotearUrb - Quadro Resumo (Solteiro)');
}

//pessoas envolvidas, outros compradores
$outros_compradores = $this->get('pessoas_envolvidas');

//partes interessadas!
$partesInteressadas = $this->get('pessoaEnvolvida');

//contador de registros de pagamento para quebra de pgina
$contador = count($outros_compradores);
if ($cliente['est_civil'] == 'CAS' || $cliente['est_civil'] == 'UNE') {
    $contador++;
}

if ($contrato['fl_itens_contrato'] == 1)
    $itensContrato = $this->get('itensContrato');

$cidadeEmpreedimento = array();
if ($cidadeEmpreedimento = Db_Cidade::find($empreendimento['cd_cidade']))
    $cidadeEmpreedimento = $cidadeEmpreedimento->toArray();

$vlTotalLote = ($contrato['nr_parcela'] * $contrato['vl_parcela']) + $contrato['vl_sinal'] +
    ($contrato['nr_intercalada'] * $contrato['vl_intercalada']) +
    ($contrato['nr_parcela_entrega'] * $contrato['vl_parcela_entrega']);

foreach($itensContrato['N'] as $k => $item){
    $vlTotalLote +=($item['qt_parcelas']*$item['vl_parcela']); 
}

$dia = explode(' ', $this->_helper->dataExtenso($contrato['dt_primeira_parcela']));
$data = $dia[0] .' ('. trim(str_replace('reais', '', $this->_helper->valorPorExtenso($dia[0]))). ') '. $dia[1] .' '.$dia[2].' '.$dia[3].' '.$dia[4];
?>
<page backtop="0mm" backbottom="0mm" backleft="0mm" backright="0mm">
    <page_header></page_header>
    <style type="text/css">
        div.espaco {
            margin-top: 0px;
        }

        body {
            font-family: arial;
            font-size: 12px;
        }

        div {
            font-size: 12px;
        }

        h2 {
            text-align: center;
            font-size: 13px;
        }

        table tr td.h3 {
            font-size: 12px;
        }

        h4 {
            font-size: 12px;
        }

        table {
            width: 100%;
            font-size: 12px;
        }

        .grid {
            border-collapse: collapse;
            width: 700px;
        }

        .grid tr td {
            border: 2px solid #000000;
        }

        table.parcelas {
            border-collapse: collapse;
            width: 700px;
            margin-top: 10px;
        }

        table.parcelas tr td {
            border: 2px solid #000000;
            width: 80px;
            font-size: 12px;
            text-align: center;
        }

        table.parcelas2 {
            border-collapse: collapse;
            width: 700px;
        }

        table.parcelas2 tr td {
            border: 2px solid #000000;
            width: 100px;
            font-size: 12px;
            text-align: center;
        }

        table.vista {
            border-collapse: collapse;
        }

        table.vista tr td {
            border: 2px solid #000000;
            width: 175px;
            font-size: 12px;
            text-align: center;
        }

        .table_bordas {
            border-collapse: collapse;
            width: 700px;

        }

        .table_bordas tr td {
            border: 1px solid #000000;
            font-size: 12px;

        }
    </style>
    <div class="espaco"> </div>
    <p align="justify">
        <strong style="font-size:13px;margin-left: 30px;">
            INSTRUMENTO PARTICULAR DE PROMESSA DE COMPRA E VENDA DO LOTE DE TERRENO DE N
            <?= $lote['lote']; ?> DA QUADRA <?= $lote['quadra']; ?> DO <?= Helper::str2Upper($empreendimento['nm_empreendimento']); ?>, QUE ENTRE
            SI FAZEM AS PARTES, NA FORMA ABAIXO.
        </strong>
    </p>
    <div></div>
    <p align="justify" style="font-size:13px;">
        Por este <strong>Instrumento Particular de Promessa de Compra e Venda de Lote de Terreno</strong>,
        compareceram as partes entre si, justas e contratadas, a saber, de um lado, como:
        <strong>Promitente Vendedora</strong>, doravante neste instrumento abreviadamente denominada de <strong>Promitente</strong>,
        <strong><u><?= Helper::str2Upper($empreendimento['nm_empreendimento']); ?></u></strong>, com sede na Rua Treze de Maio, 55,
        Santo Amaro, Recife/PE, CEP 50100-160, CNPJ n 32.386.032/0001-63, representada por
        seu diretor VTOR AZEVEDO PAES BARRETO, brasileiro, casado, empresrio, RG n 7.331.225 SDS/PE,
        CPF n 067.406.584-04, com endereo na sede da empresa que ora representa, do outro lado,
        como <strong>Promissrio Comprador</strong>, doravante neste instrumento simplesmente denominado de
        <strong>Promissrio, <?= $cliente['nm_pessoa'] ?></strong>, nacionalidade <?= $cliente['nm_nacionalidade'] ?><?= $cliente['sexo'] == 'M' ? ', solteiro' : ', solteira' ?>,
        <?= ($cliente['nm_profissao'] ? $cliente['nm_profissao'].',' : ''); ?> RG n <?= $cliente['nr_rg'] ?>, CPF n <?= $cliente['nr_cpf'] ?>, residente e domiciliado na Cidade de
        <?= $cliente['cidade']['nome']; ?>/<?= Db_Cidade::getEstados($cliente['cidade']['uf']) ?>, na <?= $cliente['endereco']; ?><?= ($cliente['nr_endereco']) ? ', ' . $cliente['nr_endereco'] : '' ?><?= ($cliente['ds_complemento']) ? ', ' . $cliente['ds_complemento'] : '' ?>, <?= $cliente['nm_bairro']; ?> CEP: <?= $cliente['nr_cep'] ?>.
    </p>
    <p align="justify" style="font-size:13px;">
        As partes ajustaram a celebrao do presente negcio jurdico, nos termos das clusulas e condies seguintes:
    </p>
    <p align="justify" style="font-size:13px;">
        <strong>1) <u>QUADRO-RESUMO</u></strong> - Em observncia ao art. 26-A da Lei Federal n 6.766/79, inicia-se o contrato atravs do
        quadro-resumo adiante, no se exaurindo as disposies amplas das clusulas:
    </p>
    <table class="table_bordas" style="margin-top: 10px; margin-left: 15px;">
    <tr>
            <td width="350px" style="font-size:13px;width:350px;">Preo total do lote</td>
            <td width="350px" style="font-size:13px;width:350px;"><strong>R$ <?= Helper::getMoney($vlTotalLote); ?></strong></td>
        </tr>
        <tr>
            <td width="350px" style="font-size:13px;width:350px;">Forma de pagamento, valores e vencimentos</td>
            <td width="350px" style="font-size:13px;width:350px;" align="justify">
                <strong>R$ <?= Helper::getMoney($contrato['vl_sinal']); ?></strong>
                (<?= $this->_helper->valorPorExtenso($contrato['vl_sinal']); ?>) a ttulo de sinal, mais <?= $contrato['nr_parcela'] ?> (<?= trim(str_replace($contrato['nr_parcela'] > 1 ? 'reais' : 'real', null, $this->_helper->valorPorExtenso($contrato['nr_parcela']))); ?>)
                <?= $contrato['nr_parcela'] > 1 ? 'parcelas mensais e sucessivas, sendo a primeira no valor de' : 'parcela mensal e sucessiva, sendo a primeira no valor de' ?> <strong>R$ <?= Helper::getMoney($contrato['vl_parcela']); ?></strong>
                (<?= $this->_helper->valorPorExtenso($contrato['vl_parcela']); ?>), com vencimento em <?= $data; ?><?= $contrato['nr_parcela'] > 1 ? ', e as seguintes com vencimento no mesmo dia dos meses subsequentes' : ''?> 
                <?php if ($contrato['fl_itens_contrato'] == 1) : ?><?php
                    if (count($itensContrato['N']) > 0)
                    foreach ($itensContrato['N'] as $k => $item) : ?>
                        <?= $contrato['fl_itens_contrato'] == 1 ? ', mais ' : '.' ?>
                            <?= $item['qt_parcelas'] ?> (<?= trim(str_replace($item['qt_parcelas'] > 1 ? 'reais' : 'real', null, $this->_helper->valorPorExtenso($item['qt_parcelas']))); ?>)
                            <?= $item['qt_parcelas'] > 1 ? 'parcelas mensais e sucessivas, no valor de' : 'parcela mensal e sucessiva, no valor de' ?> <strong>R$ <?= Helper::getMoney($item['vl_parcela']); ?></strong>
                            (<?= $this->_helper->valorPorExtenso($item['vl_parcela']); ?>) 
                        <?php endforeach; ?>
                <?php endif; ?>

            </td>
        </tr>
        <tr>
            <td width="350px" style="font-size:13px;width:350px;" align="justify">Valor da corretagem, beneficirio e forma de pagamento.</td>
            <td width="350px" style="font-size:13px;width:350px;" align="justify">
                <?= ($corretor['tp_comissao'] == 'F') ? 'R$ '.Helper::getMoney($corretor['pc_comissao']) : floatval($corretor['pc_comissao']).'%'; ?> do valor do contrato, pagos a <?= (!$corretor['cnpj'])? $corretor['nm_pessoa'] : $corretor['nm_fantasia']; ?>, CNPJ: <?= $corretor['cnpj']; ?>, 30 dias aps a
                assinatura pela Promitente, integrando este valor o preo do lote.
            </td>
        </tr>
        <tr>
            <td width="350px" style="font-size:13px;width:350px;">ndice de correo do contrato</td>
            <td width="350px" style="font-size:13px;width:350px;">IGPM</td>
        </tr>
        <tr>
            <td width="350px" style="font-size:13px;width:350px;" align="justify">Consequncias de Desfazimento do Contrato por inadimplemento do <strong>Promissrio</strong></td>
            <td width="350px" style="font-size:13px;width:350px;" align="justify">
                Devoluo do valor pago corrigido monetariamente pelo IGPM ao <strong>Promitente, <u>deduzido:</u> Multa
                    de 10% do valor atualizado do contrato; despesa mensal de fruio de 0,75% do valor atualizado do contrato;
                    encargos das prestaes pagas em atraso; comisso de corretagem;  dbitos sobre o imvel em aberto
                    (ex. IPTU, Taxa de Bombeiros, Taxa Associativa e etc.); custas, emolumentos e despesas necessrias a
                    resoluo do contrato e restituio do imvel, bem como honorrios advocatcios de 20% sobre o valor
                    atualizado do contrato.
                </strong>
            </td>
        </tr>
        <tr>
            <td width="350px" style="font-size:13px;width:350px;" align="justify">
                Prazo para devoluo de eventual valor remanescente ao <strong>Promissrio</strong> quando ocorrer o desfazimento do
                contrato por seus inadimplementos
            </td>
            <td width="350px" style="font-size:13px;width:350px;" align="justify">
                Durante o andamento das obras do loteamento:<strong> no prazo mximo de 180 (cento e oitenta) dias aps
                    o prazo previsto em contrato para concluso das obras;</strong>Aps a concluso das obras do loteamento:
                <strong>no prazo mximo de 12 (doze) meses aps a formalizao da resciso contratual.</strong>
            </td>
        </tr>
        <tr>
            <td width="350px" style="font-size:13px;width:350px;" align="justify">
                Consequncias de Desfazimento do Contrato por inadimplemento do <strong>Promitente</strong> com o prazo
                de concluso das obras
            </td>
            <td width="350px" style="font-size:13px;width:350px;" align="justify"><strong>Devoluo pelo Promitente do valor pago pelo corrigido monetariamente.</strong></td>
        </tr>
        <tr>
            <td width="350px" style="font-size:13px;width:350px;" align="justify">
                Prazo para devoluo de eventual valor pelo <strong>Promitente</strong> ao <strong>Promissrio</strong> em
                razo do desfazimento do contrato por inadimplemento do <strong>Promitente</strong>
            </td>
            <td width="350px" style="font-size:13px;width:350px;"><strong>180 dias</strong></td>
        </tr>
        <tr>
            <td width="350px" style="font-size:13px;width:350px;">Taxa de juros</td>
            <td width="350px" style="font-size:13px;width:350px;" align="justify">No incide juros remuneratrios no contrato, mas apenas moratrios de 1% a.m., em caso de atraso nos pagamentos.</td>
        </tr>
        <tr>
            <td width="350px" style="font-size:13px;width:350px;" align="justify">Prazo para o <strong>Promissrio</strong> exercerer o direito de arrependimento</td>
            <td width="350px" style="font-size:13px;width:350px;">7 dias da assinatura deste instrumento</td>
        </tr>
        <tr>
            <td width="350px" style="font-size:13px;width:350px;">Prazo para quitao das obrigaes do <strong>Promissrio</strong> aps obteno do TVO</td>
            <td width="350px" style="font-size:13px;width:350px;" align="justify">No h modificao no prazo de pagamento aps obteno do TVO</td>
        </tr>
        <tr>
            <td width="350px" style="font-size:13px;width:350px;">nus incidente sobre o lote</td>
            <td width="350px" style="font-size:13px;width:350px;">No incide nus no lote objeto desta promessa</td>
        </tr>
        <tr>
            <td width="350px" style="font-size:13px;width:350px;">Registro, Matrcula e Cartrio</td>
            <td width="350px" style="font-size:13px;width:350px;" align="justify">R-2 da Matricula n 3.124 do RGI Tamandar, em 23/05/2019</td>
        </tr>
        <tr>
            <td width="350px" style="font-size:13px;width:350px;">Prazo para execuo da Obras</td>
            <td width="350px" style="font-size:13px;width:350px;" align="justify">96 meses, sendo dividido em 4 etapas de 24 meses cada, contados da data do registro do Loteamento</td>
        </tr>
        <tr>
            <td width="350px" style="font-size:13px;width:350px;" align="justify">Data do protocolo do pedido de emisso do termo de vistoria de obras</td>
            <td width="350px" style="font-size:13px;width:350px;">30 dias aps a concluso de todas as obras</td>
        </tr>
    </table>
</page>

<p align="justify" style="font-size:13px;">
    <strong>2) IMVEL OBJETO DA PROMESSA DE COMPRA E VENDA - LOTE <?= $lote['lote'] ?>, da QUADRA <?= $lote['quadra']; ?>,
        do LOTEAMENTO NOVA TAMANDAR,</strong> situado em Tamandar/PE, com <?= $lote['frente'] ?> metros de frente, que
    confronta com <?= $lote['conf_frente'] ?>; <?= $lote['fundo'] ?> metros de fundo, que confronta com <?= $lote['conf_fundo'] ?>;
    <?= $lote['direita'] ?> metros do lado direito, que confronta com <?= $lote['conf_direita'] ?>; e, <?= $lote['esquerda'] ?> metros do lado
    esquerdo, que confronta com <?= $lote['conf_esquerda'] ?>, perfazendo a rea total de <?= $lote['area'] ?> metros quadrados, com
    suas demais caractersticas e ttulos aquisitivos constantes na<strong> Matrcula n 3.124,</strong> do RGI de
    Tamandar/PE, registrado sob o R-2, em 23/05/2019.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo nico</strong>- O<strong>Promissrio</strong>declara para todos os finster pleno
    conhecimento da geografia do citado lote no momento de sua aquisio, no havendo nada a reclamar em juzo ou
    fora dele em razo dessa matria.
</p>

<p align="justify" style="font-size:13px;">
    <strong>3) <u>DISPONIBILIDADE SOBRE O IMVEL</u></strong> - A <strong>Promitente</strong> declara que  legtima
    proprietria e titular do domnio til e direitos de uso, ocupao e posse sobre o imvel objeto do presente
    negcio jurdico, encontrando-se o mesmo inteiramente livre e desembaraado de quaisquer nus reais, hipotecas,
    usufrutos, arrestos, sequestros, penhoras, citaes de aes reais ou pessoais reipersecutrias, de condies ou
    de fatos outros que limitem a titularidade ou o poder dela dispor.
</p>

<p align="justify" style="font-size:13px;">
    <strong>4) <u>POSSE</u></strong> - A posse direta exercida pelo <strong>Promitente</strong> sobre o lote , neste
    ato, transferida ao <strong>Promissrio</strong>, ficando ento, a partir desta, incumbido no pagamento de
    todas as obrigaes relativas a impostos, taxas,tarifas, contribuies de melhoria ou quaisquer outros tributos
    que incidem ou que venham a incidir sobre o imvel, mesmo que seus lanamentos sejam feitos em nome da <strong>Promitente</strong>
    ou de terceiros.
</p>

<p align="justify" style="font-size:13px;">
    <strong>5) <u>PREO, ATUALIZAO E CONDIES DE PAGAMENTO</u></strong> - A <strong>Promitente</strong> promete
    vender ao <strong>Promissrio</strong> o bem imvel descrito neste instrumento pelo preo certo e determinado
    de <strong>R$ <?= Helper::getMoney($vlTotalLote); ?></strong> (<?= $this->_helper->valorPorExtenso($vlTotalLote); ?>), que ser pago, satisfeito e liquidado,
    na forma e condies seguintes:
</p>

<p align="justify" style="font-size:13px;">
    <strong>a) R$ <?= Helper::getMoney($contrato['vl_sinal']); ?></strong> (<?= $this->_helper->valorPorExtenso($contrato['vl_sinal']); ?>) pago neste ato,
    a ttulo de sinal e arras, em moeda legal e corrente no pas, razo pela qual a <strong>Promitente</strong> d plena, geral e irrevogvel quitao;
</p>

<p align="justify" style="font-size:13px;">
    <strong>b)</strong> o saldo remanescente, no montante de <strong>R$ <?= Helper::getMoney($contrato['vl_parcela'] * $contrato['nr_parcela']); ?></strong> (<?= $this->_helper->valorPorExtenso($contrato['vl_parcela'] * $contrato['nr_parcela']); ?>)
    ser pago em <?= $contrato['nr_parcela']; ?> (<?= trim(str_replace($contrato['nr_parcela'] > 1 ? 'reais' : 'real', null, $this->_helper->valorPorExtenso($contrato['nr_parcela']))); ?>) parcelas mensais e sucessivas, sendo a primeira
    no valor de <strong>R$ <?= Helper::getMoney($contrato['vl_parcela']); ?></strong> (<?= $this->_helper->valorPorExtenso($contrato['vl_parcela']); ?>), com vencimento em <?= $this->_helper->dataExtenso($contrato['dt_primeira_parcela']); ?>,
    e as seguintes com vencimento no mesmo dia dos meses subsequentes, corrigidas mensalmente atravs da variao do
    IGPM - FGV, nos termos desta Clusula.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo primeiro</strong> - No caso de no ser divulgado o IGPM - FGV at a data do vencimento ou do efetivo pagamento
    de qualquer parcela, ser usado para tal fim o ltimo ndice disponvel e procedendo-se ao correspondente acerto,
    para mais ou para menos, quando o mesmo for conhecido, cobrvel imediatamente a diferena pela <strong>Promitente</strong>, como
    dvida liquida, certa e exigvel.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo segundo</strong> - A diferena apurada entre o valor nominal de cada prestao e o valor resultante da correo
    monetria incidente sobre as prestaes na data do seu pagamento, acrescida dos juros e multa que houverem incidido,
    sero quitadas contra recibos, constituindo essa diferena decorrente da correo monetria, juntamente com o
    valor nominal de prestao e demais encargos, obrigao indivisvel, insuscetvel, portanto, de pagamento por
    parte ou separadamente, de tal sorte que a <strong>Promitente</strong> somente dar quitao da prestao, com o concomitante
    pagamento da referida diferena, que constitui tambm obrigao lquida e certa, incontestvel, prontamente
    exigvel a partir do respectivo vencimento.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo terceiro</strong> - Os valores das prestaes mensais sero atualizados e lanados a cada 12 (doze) meses
    contados da data deste contrato, mediante aplicao, mensal, da variao do IGPM - FGV sobre o saldo devedor,
    vigorando o novo valor automaticamente, independente de aviso ou notificao ao <strong>Promissrio.</strong>
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo quarto</strong> - Em caso de medidas ou atos praticados pelo Poder Pblico que modifiquem a poltica econmica,
    implicando a extino do ndice de atualizao monetria eleito neste instrumento, sem que haja a indicao do
    atualizador monetrio substituto, ser aplicado em substituio ao IPC (ndice de Preos ao Consumidor).
</p>

<p align="justify" style="font-size:13px;">
    <strong>6) <u>SALDO DEVEDOR RESIDUAL</u></strong> - Como a correo monetria tem periodicidade mensal e as parcelas tem seus valores
    atualizados anualmente, fica ajustado que ser cobrado o resduo da correo monetria a cada prestao vencida
    no decurso de cada 12 (doze) meses no primeiro dia til imediatamente subsequente ao trmino desse prazo, sendo,
    nessa ocasio pago todo o valor correspondente  soma dos resduos de cada uma das 12 (doze) prestaes,
    devidamente corrigido monetariamente, de acordo com o ndice e nas condies previstas neste contrato.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo nico</strong> - Poder, tambm, ser o resduo da correo monetria de cada parcela vencida no decorrer de cada
    12 (doze) meses cobrado de forma diluda, acrescido de correo monetria, de acordo com o ndice e nas condies
    previstas neste contrato, nas parcelas imediatamente seguintes, ento vincendas, o mesmo ocorrendo quanto aos
    saldos remanescentes de valor principal de prestaes parcialmente pagas, aos encargos contratualmente estabelecidos,
    correspondentes aos juros de mora,  multa e  correo monetria, por atraso no pagamento de qualquer prestao
    do preo no respectivo vencimento, bem como a qualquer outro encargo previsto no presente contrato, com o que
    desde j concorda o <strong>Promissrio</strong>.
</p>

<p align="justify" style="font-size:13px;">
    <strong>7) <u>FORMA E LOCAL PARA PAGAMENTO</u></strong> - A parcelas mensais sero quitadas pelo <strong>Promissrio</strong>
    at a data de seu vencimento, mediante o pagamento de boleto bancrio ou nota promissria, emitidas em seu favor.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo primeiro</strong> -  Caso no seja possvel a quitao da parcela mensal mediante o pagamento de algum boleto,
    desde j fica estipulado como local de pagamento o endereo da <strong>Promitente</strong>, podendo, ainda, indicar outro local
    para pagamento ou fazer a cobrana por meio de procurador especial ou de estabelecimento de crdito de sua livre
    escolha, inclusive por meio de cobrana do tipo escritural.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo segundo</strong> - O <strong>Promissrio</strong> declara que recebe neste ato 12 (doze) boletos representando as 12 (doze)
    primeiras prestaes mensais, ficando os demais a serem enviados ao endereo do <strong>Promissrio</strong>, anualmente.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo terceiro</strong> - Caso o <strong>Promissrio</strong> no receba, qualquer dos boletos,
    por qualquer motivo que seja, dever comunicar de imediato a <strong>Promitente</strong>. No havendo tempo hbil
    para entrega, o <strong>Promissrio</strong>, independentemente de aviso, notificao ou interpelao, judicial
    ou extrajudicial, dever efetuar os pagamentos diretamente na sede da <strong>Promitente</strong>, nas respectivas datas, sob
    penas das sanes moratrias prevista na Clusula 8.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo quarto</strong> - O <strong>Promissrio</strong> fica obrigado a comunicar, em tempo no
    inferior a 30 (trinta) dias que antecederem o prximo vencimento, qualquer alterao no seu endereo de
    correspondncia, bem como informar de eventual extravio dos boletos em sua posse, para a devida regularizao,
    por meio de carta com protocolo de entrega.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo quinto</strong> - Na hiptese de o vencimento da parcela coincidir com sbado, domingo ou feriado, o pagamento
    dever ser realizado no primeiro dia til subsequente ao vencimento, sem qualquer acrscimo.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo sexto</strong> - Sempre que o pagamento for efetuado por cheque, a dvida somente estar quitada aps a efetiva
    compensao do aludido cheque. Ser considerado como atraso o perodo decorrido entre o vencimento da dvida e a
    data em que o cheque for efetivamente compensado, implicando automaticamente na incidncia das cominaes para os
    casos de mora, nos termos da Clusula 8, assim como no reembolso  <strong>Promitente</strong> de eventuais despesas decorrentes
    de tal fato.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo stimo</strong> - O recibo e/ou comprovante de pagamento da ltima parcela vencida no significa quitao do
    contrato ou das parcelas anteriores que dever ser comprovada sempre que exigido.
</p>

<p align="justify" style="font-size:13px;">
    <strong>8) <u>IMPONTUALIDADE NO PAGAMENTO DAS OBRIGAES</u></strong> - Ocorrendo impontualidade na satisfao, integral ou parcial, de
    qualquer obrigao de pagamento constante neste contrato, a quantia a ser paga ser atualizada monetariamente
    incidindo os juros e penalidades aqui previstas, desde a data do vencimento at a data do efetivo pagamento pelo
    critrio <i>"pro rata die"</i>, independentemente de notificao ou de interpelao judicial ou extrajudicial, acrescido
    das despesas a que a mora der causa, assim tambm consideradas as despesas para cobrana (judicial ou extrajudicial)
    e os honorrios advocatcios, sendo certo o recebimento de parcelas em atraso, pela <strong>Promitente</strong>, banco ou procurador,
    no constituir novao ou renncia s estipulaes e garantias previstas neste contrato.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo primeiro - Multa moratria sobre obrigaes em Atraso</strong>- Sobre o valor das obrigaes em
    atraso, incidir multa moratria de 2% (dois por cento).
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo segundo - Juros de Mora sobre obrigaes em Atraso</strong> - Sobre o valor apurado de acordo com o disposto no
    caput desta Clusula, aplicados o pargrafo anterior, incidir juros moratrio  razo de 1% (um por cento) ao ms.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo terceiro - Atualizao Monetria</strong> - Sobre o valor apurado de acordo com o disposto no caput desta Clusula,
    aplicada a multa e juros de mora que trata os pargrafos antecedentes, incidir o IGPM como ndice para sua correo
    monetria e, subsidiariamente, o IPC.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo quarto - Despesas de Cobrana</strong> - Sobre a cobrana do valor das obrigaes em atraso, incidir despesas
    de honorrios de 10% sobre o valor do dbito pela via extrajudicial e 20% sobre o valor do dbito pela via judicial,
    caso a cobrana seja realizada por procurador especial.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo quinto</strong> - O no pagamento do encargo/parcela na data do seu vencimento implicar na inscrio do
    <strong>Promissrio</strong> nos rgos de proteo ao crdito, assim considerados o SPC e SERASA.
</p>

<p align="justify" style="font-size:13px;">
    <strong>9) <u>LIQUIDAO ANTECIPADA</u></strong> -  facultada ao <strong>Promissrio</strong> a liquidao antecipada das parcelas vincendas, sendo a
    apurao do valor para liquidao composta pelo saldo devedor atualizado monetariamente conforme Clusula 5,
    acrescido de eventuais dbitos e penalidades que tratam a Clusula 8.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo nico</strong> - No ser permitido tal adiantamento nos perodos de congelamento de preos ou anomalias
    econmicas, ou quando for iminente o aumento extraordinrio da correo das parcelas em decorrncia de fato previsvel.
</p>

<p align="justify" style="font-size:13px;">
    <strong>10) <u>RESOLUO DO CONTRATO POR INADIMPLEMENTO DO POMISSRIO - A falta de pagamento de 03 (trs) parcelas de
            vencimentos mensais e consecutivos, ou o atraso no pagamento de qualquer delas por prazo superior a 90 (noventa)
            dias, determinar a resoluo do presente contrato, decorridos 30 (trinta) dias da constituio em mora do Promissrio.</u></strong>
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo primeiro</strong> - A constituio em mora estar caracterizada com a notificao feita pela <strong>Promitente</strong> ao
    <strong>Promissrio</strong>, por meio do Cartrio de Registro de Ttulos e Documentos ou de Oficial do Registro Geral de Imveis
    competente, para satisfazer as prestaes vencidas e as que se venceram at a data do pagamento, alm dos encargos
    , cominaes contratualmente previstas e despesas com a notificao.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo segundo</strong> - Em se tratando de contrato no registrado pelo <strong>Promissrio</strong> no Cartrio de Registro de
    Imveis competente, a notificao dever ser realizada atravs de carta registrada (com aviso de recebimento) ou
    telegrama ou por meio do Cartrio de Registro de Ttulos e Documentos.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo terceiro</strong> - Purgada a mora e satisfeitas, pelo <strong>Promissrio</strong>, convalescer o contrato de promessa de
    compra e venda. <strong><u>No purgada a mora, pelo Promissrio, o contrato estar plenamente resolvido.</u></strong>
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo quatro</strong> - Na hiptese de ter sido registrado em cartrio, a <strong>Promitente</strong> poder requerer ao Oficial do
    Registro Geral de Imveis o cancelamento do registro do presente contrato de promessa de compra e venda, observada
    as disposies do art. 35 da Lei Federal n 6.766/79, se for o caso.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo quinto</strong> - Incorre em multa contratual de 20% do valor atualizado do contrato a apresentao para registro
    deste instrumento aps a sua resciso, por qualquer meio.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo sexto</strong> - Em virtude da resoluo contratual, a <strong>Promitente</strong> devolver ao <strong>Promissrio</strong> o valor recebido
    corrigido monetariamente, <strong><u>aps as dedues dos seguintes valores devidamente corrigidos</u></strong>:
</p>

<p align="justify" style="font-size:13px;">
    <strong>a)</strong> o valor referente ao pagamento da comisso de corretagem pela intermediao do presente negcio;
</p>

<p align="justify" style="font-size:13px;">
    <strong>b)</strong> multa de 10% (dez por cento) do valor do contrato atualizado, acrescido das despesas decorrentes da mora,
    penalidades e demais encargos contratuais;
</p>

<p align="justify" style="font-size:13px;">
    <strong>c)</strong> o valor relativo s despesas necessrias  decretao da resoluo, nelas entendidas as despesas, emolumentos
    e custas com procedimentos extrajudiciais e/ou judiciais, inclusive para eventual cancelamento do registro do
    contrato, assim como honorrios advocatcios na base de 20% (vinte por cento) do valor atualizado do contrato;
</p>

<p align="justify" style="font-size:13px;">
    <strong>d)</strong> todos os dbitos incidentes sobre o imvel, cujo fato gerador ocorrer desde a entrada do <strong>Promissrio</strong> na
    posse direta do lote at o momento que dela sair, assim entendidos o IPTU, foro, contribuies eventualmente
    incidentes, condomnio, taxa devida  associao de moradores, despesas de gua, luz, gs, entre outros;
</p>

<p align="justify" style="font-size:13px;">
    <strong>e)</strong> eventuais despesas custeadas pela <strong>Promitente</strong> para fins de registros deste instrumento no Cartrio de Registro
    de Imveis, inclusive ITBI, e eventual cancelamento;
</p>

<p align="justify" style="font-size:13px;">
    <strong>f)</strong> o valor correspondente a 0,75% (zero vrgula setenta e cinco por cento) calculado sobre o valor corrigido do
    presente contrato por cada ms ou frao de ms referente a disponibilizao do lote em favor do <strong>Promissrio</strong>
    pela fruio e pelo perodo de resistncia na devoluo do lote quando desfazimento do presente negcio jurdico
    de promessa de compra e venda mediante o disposto no caput desta Clusula;
</p>

<p align="justify" style="font-size:13px;">
    <strong>h)</strong> as despesas para trazer o imvel a situao em que foi alienado, na hiptese de serem inseridas benfeitorias
    em desconformidade com a Clusula 13, assim como a multa prevista no seu pargrafo nono;
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo stimo</strong> - O pagamento da restituio ocorrer em at 12 (doze) parcelas mensais, com incio aps o
    seguinte prazo de carncia:
</p>

<p align="justify" style="font-size:13px;">
    <strong>a)</strong> se a resciso ocorrer durante o andamento das obras do loteamento: no prazo mximo de 180 (cento e oitenta)
    dias aps o prazo para concluso das obras, nos termos da Clusula 12;
</p>

<p align="justify" style="font-size:13px;">
    <strong>b)</strong> se a resciso ocorrer aps a concluso das obras do loteamento: no prazo mximo de 12 (doze) meses aps a
    formalizao da resciso contratual.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo oitavo</strong> - Faculta as partes a formalizao de distrato com clusulas e condies de comum acordo,
    regido assim por termo prprio.
</p>

<p align="justify" style="font-size:13px;">
    <strong>11) <u>RESOLUO DO CONTRATO EM FACE DA INADIMPLNCIA DO PROMITENTE</u></strong> - A no realizao das obras de infraestrutura
    do loteamento, que beneficie diretamente o lote prometido em venda ao <strong>Promissrio</strong>, aps transcorridos 180 dias
    do previsto na Clusula 12, determinar a resoluo do presente contrato, decorridos 90 (noventa) dias da
    constituio em mora do <strong>Promitente</strong> e desde que adimplente o <strong>Promissrio</strong>, onde dever ser indicado com preciso
    a obra no levada a efeito que beneficie diretamente o lote objeto desta promessa, observando-se ainda o
    cronograma e os projetos aprovados anexados ao processo de registro do loteamento perante o RGI.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo primeiro</strong> - A constituio em mora estar caracterizada com a notificao feita pelo <strong>Promissrio</strong> ao
    <strong>Promitente</strong>, por meio do Cartrio de Registro de Ttulos e Documentos ou de Oficial do Registro Geral de Imveis
    competente, para satisfazer as obrigaes.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo segundo</strong> - Purgada a mora e satisfeitas, pelo <strong>Promitente</strong>, convalescer o contrato de promessa de compra
    e venda. No purgada a mora, o contrato estar plenamente resolvido, devendo o <strong>Promitente</strong> devolver o valor pago
    pelo <strong>Promissrio</strong> devidamente corrigido, deduzido os encargos moratrios relativos s prestaes pagas em
    atraso pelo <strong>Promissrio</strong>, no prazo de 180 dias.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo terceiro</strong> - A concluso das obras ser auferida mediante a verificao no local da construo ou na
    data do protocolo do pedido de emisso do termo de vistoria de obras da Prefeitura ou na emisso do termo de
    vistoria de obras da Prefeitura, razo pela qual, aps o cumprimento integral dessas obrigaes, fica o
    <strong>Promissrio</strong> impedido de promover a resoluo em face da inadimplncia do <strong>Promitente</strong>, uma vez ainda que a
    manuteno das respectivas obras ficam a cargo do municpio.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo quarto</strong> - Decai o direito de reclamar a resoluo do contrato em face da inadimplncia do <strong>Promitente <u>se
            no exercido no prazo 1 (um)</u></strong> ano previsto para concluso de obra.
</p>

<p align="justify" style="font-size:13px;">
    <strong>12) <u>OBRAS DE INFRAESTRUTURA</u></strong> - A infraestrutura bsica e extra do Loteamento compreende os servios realizados
    pela <strong>Promitente</strong>, conforme descrio a seguir definida, a ser implementada no prazo total de 96 meses, sendo
    dividido em 4 etapas de 24 meses cada, este contados a partir do registro do loteamento, de acordo com as
    especificaes constantes no projeto aprovado pela Prefeitura Municipal e nos termos da Lei Municipal n 540/2019,
    que instituiu a Operao Consorciada Nova Tamandar:
</p>

<p align="justify" style="font-size:13px;">
    <strong>a)</strong> Infraestrutura, compreendendo: terraplanagem; abertura de vias; execuo das estruturas para escoamento das
    guas pluviais; calamento em paraleleppedo; urbanizao das praas; rede interna de abastecimento de gua;
    iluminao pblica; instalao da rede eltrica; meio-fio ao longo da trajetria das vias; demarcao de lotes.
</p>

<p align="justify" style="font-size:13px;">
    <strong>b)</strong> Esgotamento realizado atravs de fossa sptica individualizada, construda pelo <strong>Promissrio</strong> com prvia
    aprovao dos rgos competentes.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo Primeiro</strong> - A rede de iluminao das vias e seus respectivos postes, bem como a rede de distribuio de
    gua sero doadas s concessionrias de servio pblico, que, em consequncia, realizaro, s suas nicas expensas
    e diligncias, as correspondentes e necessrias manuteno e conservao das mesmas.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo Segundo</strong> - Compreende a 1 Etapa as quadras 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45,
    46, 47, 48, 49 (parte norte) e 50 (parte norte); compreende a 2 Etapa as quadras 49 (parte sul), 50 (parte sul),
    51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61 e 62; compreende a 3 Etapa as quadras 16 (parte norte), 17
    (parte norte), 18, 19, 20, 21, 22, 23, 24, 25, 26, 27 28, 29 e 30; e, compreende a 4 Etapa as quadras 01, 02,
    03, 04, 05, 06, 07, 08, 09, 10, 11, 12, 13, 14, 15, 16 (parte sul) e 17 (parte sul).
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo Terceiro</strong> - Poder o <strong>Promitente</strong> alterar a ordem de execuo das 2, 3 e 4 etapas mediante sua
    convenincia, desde que respeitado o prazo total estabelecido no <i>caput</i> desta clusula.
</p>

<p align="justify" style="font-size:13px;">
    <strong>13) <u>DISPOSIES SOBRE DIREITO DE CONSTRUO / BENFEITORIAS</u></strong> - O <strong>Promissrio</strong>,
    at a emisso pela <strong>Promitente</strong> do termo de quitao do contrato, somente poder realizar construes/benfeitorias regulares, assim entendidas as
    executadas <strong><u>mediante anuncia prvia</u></strong> da <strong>Promitente</strong>, com a obteno das licenas administrativas necessrias,
    observando, rigorosamente, as posturas e normas exigidas e previstas neste contrato, na legislao especfica do
    Municpio, inclusive do condomnio ou associao, se for o caso, e, bem assim, atendidas as normas supletivas
    convencionais, sendo necessria a obteno da CND/INSS e averbaes perante o Registro Imobilirio.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo primeiro</strong> - Em razo da resoluo por inadimplemento do <strong>Promissrio</strong>, as benfeitorias necessrias ou
    teis por ele levadas a efeito no imvel sero indenizadas, por outro lado, <strong><u>no sero indenizadas as benfeitorias
            feitas em desconformidade com o contrato ou com a lei</u></strong>.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo segundo</strong> - O imvel objeto deste contrato em que se encontre benfeitorias indenizveis sero objeto de
    leilo judicial ou extrajudicial, no prazo de 60 (sessenta) dias da constituio em mora do <strong>Promissrio</strong>, nos
    termos e trmites da Lei Federal n 9.514/97.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo terceiro</strong> - O <strong>Promissrio</strong> tambm declara e reconhece que
    <strong><u>no poder</u></strong> habitar o lote antes da concesso e averbao do certificado de concluso da
    construo da unidade ("Habite-se"), a ser emitido pela Prefeitura Municipal.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo quarto</strong> - O <strong>Promissrio</strong> declara que tomou conhecimento do perfil topogrfico do lote, inclusive da
    existncia de espcie arbrea, conhecendo seus limites e confrontaes, que esto sendo entregues devidamente
    demarcados. No caso de desaparecimento dos marcos, o <strong>Promissrio</strong> deve se dirigir ao escritrio local da
    <strong>Promitente</strong>, ou em seu endereo, relatando o ocorrido, para que seja providenciada a remarcao, ficando
    expressamente proibidas quaisquer construes sem que os lotes estejam demarcados.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo quinto</strong> - O sistema de lazer e outras reas <strong><u>no podero</u></strong> ser utilizados como acesso para os lotes que
    fazem frente ou divisas para tais locais.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo sexto</strong> - O <strong>Promissrio <u>no poder</u></strong> fazer instalaes prejudiciais aos lotes vizinhos,
    responsabilizando-se exclusiva e inteiramente por eventuais infraes s leis, regulamentos e posturas que devam ser observadas.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo stimo</strong> - <strong><u>No ser permitida</u></strong> a ocupao de lotes vizinhos ou arruamentos para fins de canteiro de
    obras, depsito de materiais ou quaisquer outras finalidades.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo oitavo</strong> - Nos lotes com divisas de fundo confrontantes com rea Verde e/ou Sistema de
    Lazer, <strong><u>no ser permitido</u></strong> qualquer avano de construes sobre as referidas reas.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo nono</strong> - O <strong>Promissrio</strong>, desde j, concorda expressamente, em carter irrevogvel e irretratvel,
    que para aprovao do projeto de construo de residncia nos lotes de terreno do Loteamento, junto  Prefeitura
    Municipal,  necessrio e indispensvel adotar o modelo padro de fosse sptica aprovada pela Agncia do Meio
    Ambiente competente e a no adoo deste modelo pelo <strong>Promissrio</strong> implicar em autuao pelos rgo fiscalizadores.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo dcimo</strong> - O <strong>Promissrio <u>no poder</u></strong> dificultar ou criar quaisquer obstculos ao prosseguimento das
    obras do empreendimento de Loteamento, at que se ultime a sua integral concluso.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo dcimo primeiro</strong> - O <strong>Promissrio</strong> s poder realizar obras no seu lote aps concluso das obras de
    infraestrutura do loteamento integrante da etapa onde se insere o lote objeto deste negcio jurdico.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo dcimo segundo</strong> - A implementao de benfeitorias no imvel, sem observncia das regras aqui contidas
    culminam em multa compensatria de 20% (vinte por cento) do valor deste contrato, alm das despesas necessrias
    para reposio do imvel em idntico estado de quando foi entregue ao <strong>Promissrio</strong>.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo dcimo terceiro - <u> expressamente vedado a supresso de vegetao de espcie arbrea inserida no lote
            sem autorizao da Agncia do Meio Ambiente competente, se responsabilizando e respondendo o Promissrio nas
            esferas civil, administrativo e penal em caso de descumprimento.</u></strong>
</p>

<p align="justify" style="font-size:13px;">
    <strong>14) <u>DESAPROPRIAO</u></strong> - No caso de desapropriao do imvel, a <strong>Promitente</strong> receber do poder expropriante a
    indenizao correspondente, imputando-a na soluo do saldo devedor do pagamento e liberando o que sobejar, se
    houver, ao <strong>Promissrio</strong>.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo nico</strong> - Se a indenizao for inferior ao saldo devedor, o <strong>Promissrio</strong>
    suportar a diferena apurada, sob pena da cobrana judicial da importncia remanescente.
</p>

<p align="justify" style="font-size:13px;">
    <strong>15) <u>CESSO E TRANSFERNCIA</u></strong> -  lcito ao <strong>Promissrio</strong> ceder e transferir
    o presente contrato e o direito e obrigaes dele decorrente, sendo <strong><u>necessria anuncia expressa</u></strong>
    da <strong>Promitente</strong>, para cumprimento das formalidades legais, exigindo, ainda, a adimplncia do
    <strong>Promissrio</strong> e a quitao total do objeto deste contrato, na data da cesso e transferncia.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo primeiro</strong> - Para fins de efetivao da cesso do contrato, solicitada pelo <strong>Promissrio</strong>, em favor de
    terceiro,  necessrio apresentar  <strong>Promitente</strong> cpias autenticadas da Cdula de Identidade (RG), do CPF, da
    Certido de Registro Civil vigente e do comprovante de endereo do cedente, ora <strong>Promissrio</strong>, do cessionrio e
    cnjuges, se houverem, devendo o cedente, alm de estar em dia com suas obrigaes financeiras perante 
    <strong>Promitente</strong>, apresentar  certido negativa de tributos municipais (IPTU) referente ao lote porventura cedido.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo segundo</strong> - A <strong>Promitente</strong> tem a faculdade de no aceitar a cesso em
    razo de restrio de crdito do eventual cessionrio.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo terceiro</strong> - Ser cobrada pela ora <strong>Promitente</strong>, taxa de anuncia no
    valor de 5% (cinco por cento) do valor do contrato, em razo dos custos administrativos e contbeis despendidos.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo quarto</strong> - A falta de anuncia ou cincia, por escrito, da <strong>Promitente</strong>, tem como consequncia, a
    <u>SOLIDARIEDADE</u> do cedente, ora <strong>Promissrio</strong>, e do cessionrio nas obrigaes contratuais, ou seja, caso o
    <strong>Promissrio</strong> faa a cesso deste contrato a outrem, sem anuncia da <strong>Promitente</strong>, este permanecer como devedor
    das obrigaes contratuais, assim como o terceiro cessionrio.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo quinto</strong> -  terminantemente vedado ao <strong>Promissrio</strong> transferir parte do lote compromissado, sob pena
    de resoluo deste contrato. Fica ainda pactuado que a <strong>Promitente</strong> no outorgar a escritura de compra e venda do
    lote compromissado em partes certas de rea, mas, unicamente, em sua totalidade.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo sexto</strong> - Todas e quaisquer despesas decorrentes de cesso e de transferncia de direitos e obrigaes
    do presente contrato correro por conta nica e exclusiva do cedente e cessionrio, no podendo ser imputados 
    <strong>Promitente</strong> qualquer tipo de responsabilidade quanto ao pagamento destas.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo stimo</strong> - A <strong>Promitente</strong> poder, a qualquer momento, a seu exclusivo critrio, ceder e transferir os
    direitos e obrigaes que lhe digam respeito, decorrentes deste instrumento, independentemente de qualquer
    anuncia, interferncia ou participao do <strong>Promissrio</strong>, que manter a obrigao de respeitar todas as
    Clusulas aqui ajustadas.
</p>

<p align="justify" style="font-size:13px;">
    <strong>16) <u>OUTORGA DA ESCRITURA DEFINITIVA DE COMPRA E VENDA</u></strong> - A escritura pblica definitiva de compra e venda,
    ressalvadas as hipteses de condio resolutiva, antes enunciadas neste contrato, ser outorgada pela <strong>Promitente</strong>
    em favor do <strong>Promissrio</strong> quando este solicitar, aps o pagamento integral do preo e de eventuais saldos
    residuais da presente promessa de compra e venda.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo primeiro</strong> - O <strong>Promissrio</strong> fica obrigado a lavrar escritura definitiva
    em no mximo 90 (noventa) dias aps o pagamento da ltima prestao.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo segundo</strong> - As partes concordam, como condio essencial do presente negcio, que a <strong>Promitente</strong> poder,
    a qualquer tempo e durante o prazo de vigncia deste contrato, proceder a outorga ao <strong>Promissrio</strong> de escritura
    particular ou pblica definitiva de compra e venda, mantendo-se a forma e as condies de pagamento das prestaes
    vincendas estipuladas para pagamento do saldo e em garantia do saldo a pagar, o <strong>Promissrio</strong> dar 
    <strong>Promitente</strong> a alienao fiduciria do prprio lote.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo terceiro</strong> - Ocorrendo o previsto no pargrafo antecedente, o <strong>Promissrio</strong> assumir a condio de
    proprietrio e devedor FIDUCIANTE, em garantia do pagamento integral do saldo a pagar, transferindo 
    <strong>Promitente</strong>, esta ento na qualidade de credora FIDUCIRIA, ou  entidade autorizada a operar no SFI, a
    propriedade resolvel do imvel objeto deste instrumento, nos termos da Lei n 9.514/1997.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo quarto</strong> - O <strong>Promissrio</strong> se obriga, sob pena de inadimplemento contratual, a assinar quaisquer
    instrumentos pblicos ou particulares necessrios  consecuo da alienao fiduciria aqui tratada.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo quinto</strong> - O <strong>Promissrio</strong> fica, desde j, ciente de que sero de sua responsabilidades as
    despesas inerentes  lavratura e aos registros da escritura pblica ou particular de compra e venda com alienao
    fiduciria, bem como ao pagamento do ITBI e eventual laudmio incidente nesta transao.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo sexto</strong> - Competir  <strong>Promitente</strong> a escolha do Tabelionato para a outorgada
    escritura, se for a forma escolhida por escritura pblica.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo stimo</strong> - Em caso de substituio da forma do contrato, fica reservado  <strong>Promitente</strong> o direito de
    emitir Cdula de Crdito Imobilirio - CCI, integral ou fracionria, representativa dos crditos oriundos deste
    contrato, garantidos ou no por Clusula de Alienao Fiduciria, independente de autorizao do <strong>Promissrio</strong>.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo oitavo</strong> - Os direitos creditrios decorrentes deste instrumento podero ser cedidos a terceiro,
    no todo ou em parte, por qualquer meio, inclusive de Cdula de Crdito Imobiliria - CCI, independente de aviso
    ou concordncia do <strong>Promissrio</strong>, subsistindo, se for o caso, em favor do cessionrio todos os direitos
    decorrentes deste instrumento, ficando investido na eventual propriedade fiduciria.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo nono</strong> - Os direitos creditrios, representados por Cdulas de Crdito Imobilirio ? CCI, podem ser
    securitizados, servindo de lastro para emisso de Certificados de Recebveis Imobilirios - CRI, consoante
    disposto nas Leis ns 9.514/1997 e 10.931/2004.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo dcimo</strong> - Em razo da cesso de crditos, a <strong>Promitente</strong> fica autorizada a transferir os seus direitos
    creditrios e a posse indireta que exerce sobre o imvel, bem como todos os eventuais direitos inerentes a
    Alienao Fiduciria, para garantia do negcio e eventual investidor, no caso de securitizao de crditos,
    mantidas todas as demais condies previstas neste instrumento.
</p>

<p align="justify" style="font-size:13px;">
    <strong>17) <u>NOVAO</u></strong> - No configurar novao a simples tolerncia, por parte da <strong>Promitente</strong>,
    da inobservncia pelo <strong>Promissrio</strong> de obrigaes legais e/ou contratuais, assim como as eventuais
    transigncias, sendo certo que a no aplicao imediata das sanes no significar renncia da <strong>Promitente</strong>
    a este direito, podendo vir a exerc-lo em qualquer momento.
</p>

<p aling="justify" style="font-size:13px;">
    <strong>18) <u>ARREPENDIMENTO E CONVOLAO DO CONTRATO</u></strong> - <strong><u>Cabe ao presente contrato o exerccio do direito de
            arrependimento pelo Promissrio, desde que exercido no prazo improrrogvel de 7 (sete) dias da
            assinatura deste</u></strong>, com a devoluo de todos os valores eventualmente antecipados, inclusive a comisso de corretagem.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo primeiro</strong> - O <strong>Promissrio</strong> dever demonstrar o exerccio tempestivo
    do direito de arrependimento atravs de carta registrada (com aviso de recebimento) ou telegrama ou por meio do
    Cartrio de Registro de Ttulos e Documentos, considerada a data da postagem como data inicial da contagem do prazo
    a que se refere o <i>caput</i> deste artigo.
</p>

<p align="justify" style="font-size:13px;">
    <strong>Pargrafo segundo</strong> - Ultrapassado o prazo do caput desta clusula e no exercido o direito de arrependimento,
    a presente promessa de compra e venda passa a ser observada a <strong><u>irretratabilidade do contrato de compra e venda de
            lotes</u></strong>, nos termos do art. 463 do Cdigo Civil e art. 25 da Lei Federal n 6.766/79, sendo, no entanto, passvel
    de resoluo, em caso de descumprimento dos termos pactuados.
</p>

<p align="justify" style="font-size:13px;">
    <strong>19) <u>CORRETAGEM</u></strong> - A comisso de corretagem pela intermediao do presente negcio integra o preo do lote para
    todos os fins.
</p>

<p align="justify" style="font-size:13px;">
    <strong>20) <u>DECLARAES ESPECIAIS</u></strong> - A <strong>Promitente</strong>, por seu representante legal, declara que o bem imvel objeto
    desta alienao  prprio da sua atividade empresarial, no integrando e jamais havendo integrado o seu ativo
    permanente, declarando, ainda, que tem como atividade exclusiva a comercializao de imveis, estando desobrigada
    , portanto, da apresentao da Certido Negativa de Dbitos Relativos s Contribuies Previdencirias
    e s de Terceiros e bem assim da Certido Conjunta Negativa de Dbitos Relativos aos Tributos Federais e 
    Dvida Ativa da Unio; O <strong>Promissrio</strong> declara, por sua vez, que aceita este Instrumento nos termos em
    que se encontra redigido; Finalmente as partes requerem e autorizam, desde logo, ao Sr. Oficial Registrador
    proceder com todos os atos de averbao e/ou registros necessrios a efetivao do registro deste Contrato Particular.
</p>

<p aling="justify" style="font-size:13px;">
    <strong>21) <u>FORO</u></strong> - Fica eleito o foro da Comarca da situao do imvel objeto deste contrato, com renncia expressa
    a qualquer outro foro, por mais especial que seja ou venha a ser e independentemente do domiclio atual ou
    futuro das partes contratantes, para dirimir todas e quaisquer dvidas ou questes, porventura oriundas do presente contrato.
</p>

<p align="justify" style="font-size:13px;">
    <i>E, por estarem, assim, justos e contratados, firmam o presente instrumento em 03 (trs) vias, de igual teor e
        forma, o que se fazem juntamente com 02 (duas) testemunhas, a tudo presentes, para que se produzam os seus jurdicos
        e legais efeitos.</i>
</p>

<p style="font-size:13px;">
    Recife/PE, <?= $this->_helper->dataExtenso($contrato['dt_contrato']); ?>.
</p>

<p align="center" style="font-size:13px;">
    ____________________________________________________________________<br>
    <strong>NOVA TAMANDAR EMPREENDIMENTOS IMOBILIRIOS SPE S/A</strong><br>
    Promitente Vendedora<br>
    VTOR AZEVEDO PAES BARRETO<br>
    Diretor
</p>

<p align="center" style="font-size:13px;">
    _________________________________________________<br>
    <strong><?= $cliente['nm_pessoa']; ?></strong><br>
    Promissrio Comprador<br>
</p>

<p style="font-size:13px;">
    Testemunhas:
</p>
