<?php require_once 'layout/includes/header.php'; ?>
<?php require_once 'layout/includes/menu.php'; ?>
<?php
$listaEmpreendimento = $this->get('empreendimentos');
$listaLote = $this->get('lotes');
$listaTipoContrato = $this->get('listaTipoContrato');
$listaModelos = $this->get('listaModelos');
$listaArquivoWord = $this->get('listaArquivoWord');
$cliente = $this->get('cliente');
?>
    <div class="content">
            <div class="page-heading">
                <?= $this->getHeader('Emitir'); ?>
            </div>
            <div class="widget">
                <div class="widget-content padding">
                    <!-- MENSAGENS -->
                    <div class="alert alert-danger alert-dismissable msgErros" hidden></div>
                    <div class="alert alert-success alert-dismissable msgSucess" hidden>Operao realizada com sucesso.</div>
                    <form action="" method="POST" id="form" target="_blank">
                        <fieldset>
                            <legend>Emitir Contrato:</legend>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-6">
                                        <label class="control-label" for="id_empreendimento">
                                            Empreendimento:<span class="require" style="color: red">*</span>
                                        </label>
                                        <select class="form-control select2 empreendimento_contrato"
                                                data-placeholder="Selecione o empreendimento"
                                                id="id_empreendimento" name="empreendimento" required="required">
                                            <option value=""></option>
                                            <?php foreach ($listaEmpreendimento as $k => $empreendimento) : ?>
                                                <option value="<?= $empreendimento['id']; ?>"<?php if ($contrato['id_empreendimento'] == $empreendimento['id']): ?> selected<?php endif; ?>>
                                                    <?= $empreendimento['nm_empreendimento']; ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-sm-6">
                                        <label class="control-label" for="id_contrato">
                                            Contrato:<span class="require" style="color: red">*</span>
                                        </label>
                                        <br>    
                                        <select class="form-control select2 lotes" name="contrato"
                                                id="id_contrato" data-placeholder="Escolha o contrato" required="required">
                                            <option value=""></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-6">
                                        <label class="control-label" for="tp_contrato">
                                            Tipo de contrato:<span class="require" style="color: red">*</span>
                                        </label>
                                        <select name="tp_contrato" id="tp_contrato" class="form-control select2">
                                            <?php if ($listaTipoContrato) : ?>
                                                <?php foreach ($listaTipoContrato as $tipoContrato) : ?>
                                                    <option value="<?= $tipoContrato['idCampo'] ?>">
                                                        <?= $tipoContrato['descricao'] ?>
                                                    </option>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-sm-6" id="divModelos" hidden>
                                        <label class="control-label" for="tp_contrato">
                                            Modelo:<span class="require" style="color: red">*</span>
                                        </label>
                                        <select name="cdModelo" id="cdModelo" class="form-control select2">
                                            <?php if ($listaModelos) : ?>
                                                <?php foreach ($listaModelos as $modelo) : ?>
                                                    <option value="<?= $modelo['cd_modelo'] ?>">
                                                        <?= $modelo['nm_titulo'] ?>
                                                    </option>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-sm-6">
                                        <label for="tpLote" class="control-label" style="padding-bottom: 10px;">Tipo de impresso:</label>

                                        <br>
                                        <div class="form-group col-sm-12" style="display: flex; flex-wrap: wrap;">
                                            <div class="col-sm-4" style="min-width: 150px; flex-shrink: 0;">
                                                <label for="tipoImpressaoPadrao" class="control-label" style="white-space: nowrap;">
                                                    <input class="form-control icheck autorizacao" id="tipoImpressaoPadrao" type="radio"
                                                        name="tipoImpressao" value="P" checked/>
                                                    Padro do sistema
                                                </label>
                                            </div>
                                            <div class="col-sm-3" style="min-width: 150px; flex-shrink: 0;">
                                                <label for="tipoImpressaoArquivo" class="control-label" style="white-space: nowrap;">
                                                    <input class="form-control icheck autorizacao" id="tipoImpressaoArquivo" type="radio"
                                                        name="tipoImpressao" value="A"/>
                                                    Modelo Word
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row" id="divLoteLogo">
                                <div class="col-sm-12" style="display: flex; flex-wrap: wrap; gap: 20px;">
                                    <div class="form-group col-sm-3" style="min-width: 250px; margin-bottom:15px;">
                                        <label for="tpLote" class="control-label">Tipo do lote:</label>
                                        <br>
                                        <div class="form-group col-sm-12" style="display: flex; flex-wrap: nowrap;">
                                            <div class="col-sm-2" style="min-width: 150px; flex-shrink: 0;">
                                                <label for="tpLoteN" class="control-label" style="white-space: nowrap;">
                                                    Residencial
                                                    <input class="form-control icheck autorizacao" id="tpLoteN" type="radio"
                                                        name="tipo" value="r" checked/>
                                                </label>
                                            </div>
                                            <div class="col-sm-2" style="min-width: 150px; flex-shrink: 0;">
                                                <label for="tpLoteS" class="control-label" style="white-space: nowrap;">
                                                    Comercial
                                                    <input class="form-control icheck autorizacao" id="tpLoteS" type="radio"
                                                        name="tipo" value="c"/>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div id="opcaoLogo" class="form-group col-sm-3" style="min-width: 250px; margin-bottom:15px;">
                                        <label for="opLogo" class="control-label">Incluir logo:</label>
                                        <br>
                                        <div class="form-group col-sm-12" style="display: flex; flex-wrap: wrap;">
                                            <div class="col-sm-6" style="min-width: 100px; flex-shrink: 0;">
                                                <label for="opLogoS" class="control-label" style="white-space: nowrap;">
                                                    Sim
                                                    <input class="form-control icheck autorizacao" id="opLogoS" type="radio"
                                                        for="logoS" name="logo" value="s"/>
                                                </label>
                                            </div>
                                            <div class="col-sm-6" style="min-width: 100px; flex-shrink: 0;">
                                                <label for="opLogoN" class="control-label" style="white-space: nowrap;">
                                                    No
                                                    <input class="form-control icheck autorizacao" id="opLogoN" type="radio"
                                                        for="logoN" name="logo" value="n" checked/>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <div hidden="" id="paginacao" class="form-group col-sm-6">
                                        <label class="control-label">Paginao:</label>
                                        <br>

                                        <div class="col-sm-2">
                                            <input type="text" id="de" name="de" value="9"
                                                   class="soNumero form-control">
                                        </div>
                                        <div class="col-sm-1">
                                            -
                                        </div>
                                        <div class="col-sm-2">
                                            <input type="text" id="ate" name="ate" value="10"
                                                   class="soNumero form-control">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row" id="divArquivoWord" hidden>
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-3" id="divArquivoWord">
                                        <label class="control-label" for="tpArquivo">
                                            Modelo Word:<span class="require" style="color: red">*</span>
                                        </label>
                                        <select name="cdArquivo" id="cdArquivo" class="form-control select2">
                                            <?php if ($listaArquivoWord) : ?>
                                                <?php foreach ($listaArquivoWord as $arquivo) : ?>
                                                    <option value="<?= $arquivo['ds_path_modelo'] ?>">
                                                        <?= $arquivo['nm_titulo'] ?>
                                                    </option>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </select>
                                    </div>                                    
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-3" style="min-width: 250px; margin-bottom:15px;">
                                        <label for="tpEmissao" class="control-label" style="padding-bottom: 10px;">Tipo de emisso:</label>
                                        <br>
                                        <div class="col-sm-2">
                                            <label for="tpEmissao" class="control-label">
                                                PDF
                                                <input class="form-control icheck autorizacao" id="tipoEmissaoPDF" type="radio"
                                                       name="tipoEmissao" value="P" checked/>
                                            </label>
                                        </div>
                                        <div class="col-sm-2">
                                            <label for="tipoEmissao" class="control-label">
                                                Word
                                                <input class="form-control icheck autorizacao" id="tipoEmissaoWord" type="radio"
                                                       name="tipoEmissao" value="W" />
                                            </label>
                                        </div>
                                        <div class="col-sm-2">
                                            <label for="tipoEmissao" class="control-label">
                                                Digital
                                                <input class="form-control icheck autorizacao" id="tipoEmissaoDocusign" type="radio"
                                                       name="tipoEmissao" value="D" <?= ($cliente['fl_contrato_digital'] == '0') ? 'disabled' : '' ?>/>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <table>
                            </table>
                        </fieldset>
                        <fieldset id="assinaturasComplementares" style="display:none;">
                            <input type="hidden" name="idDocusign" id="idDocusign">     
                            <legend>Assinaturas complementares:</legend>
                            <div class="row" style="margin:2px">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-5">
                                        <label class="control-label" for="nomeA">Nome:</label>
                                        <input type="text" class="form-control" id="nomeA"
                                            name="nomeA" placeholder="Nome do usurio da assinatura adicional"
                                            />
                                    </div>
                                    <div class="form-group col-sm-5">
                                        <label class="control-label" for="emailA"> E-mail:</label>
                                        <input type="text" class="form-control " id="emailA"
                                            name="emailA" placeholder="E-mail do usurio da assinatura adicional">
                                    </div>
                                    <div class="form-group col-sm-2" style="display: flex;align-items: flex-end;height: 50px;justify-content: center;">
                                            <button class="btn btn-default btn-xs" type="button" onClick="adicionarAssinatura()" title="Adicionar">
                                                <i class="fa fa-plus"></i>
                                            </button>
                                    </div>
                                </div>
                            </div>
                            <div class="row" id="divTabelaAssinaturas">
                            <div class="col-sm-12">
                                    <div class="col-sm-12 form-group">
                                        <div class="table-responsive">
                                            <table class="table  table-hover table-condensed order-column"
                                                cellspacing="0" width="100%">
                                                <thead>
                                                <tr>
                                                    <th>Nome</th>
                                                    <th>E-mail</th>
                                                    <th>Aes</th>
                                                </tr>
                                                </thead>
                                                <tbody id="tabelaAssinaturas">
                                                
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </fieldset>
                        <fieldset>
                            <legend>Operaes</legend>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-2" id="btnPdf">
                                        <input type="button" id="gerar" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Emitir">
                                    </div>
                                    <div class="form-group col-sm-2" id="btnWord">
                                        <input type="submit" id="word" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Emitir">
                                    </div>                                  
                                    <div class="form-group col-sm-2">
                                        <a href="?m=adm&c=contrato&a=listar"
                                           class="btn btn-danger col-sm-12">Cancelar </a>
                                    </div>
                                    <div class="form-group col-sm-2" id="divArquivoWord2" hidden>
                                        <input type="submit" id="visualizarVariaveis" class="btn btn-success col-sm-12" value="Visualizar Valores">
                                    </div>
                                </div>
                            </div>
                        </fieldset>
                    </form>
                </div>
            </div>
    </div>
<?php require_once 'layout/includes/footer.php'; ?>