<?php
//Setando objetos para para realizar as condies
$empreendimento = $this->get('empreendimento');
$empresa = $this->get('clienteAcade');
$lote = $this->get('lote');
$cliente = $this->get('cliente');
$contrato = $this->get('contrato');
$outrosCompradores = $this->get('pessoas_envolvidas');
$sinal = $this->get('sinal');
$banco = $this->get('banco');
//Instncia da tabela contrato itens.
if ($contrato['fl_itens_contrato'] == 1)
    $adicionais = $this->get('adicionais');

$parcerias = $this->get('parceria');
foreach ($parcerias as $parceiro) {
    $vendedores[] = Pessoa::findById($parceiro['id_pessoa']);
}
$cidadeEmpreedimento = array();
if ($cidadeEmpreedimento = Db_Cidade::find($empreendimento['cd_cidade']))
    $cidadeEmpreedimento = $cidadeEmpreedimento->toArray();
$itensContrato = $this->get('itensContrato');

$vlsinal = ($contrato['vl_sinal'] > 0 && $contrato['inclui_sinal_contrato']) ? $contrato['vl_sinal'] : 0;
$total = 0;
$total += ($contrato['vl_total'] > 0) ? $contrato['vl_total'] : 0;
$total += $vlsinal;
$total += ($contrato['vl_parcela'] > 0) ? $contrato['nr_parcela'] * $contrato['vl_parcela'] : 0;
$total += ($contrato['vl_intercalada'] > 0) ? $contrato['vl_intercalada'] * $contrato['nr_intercalada'] : 0;
$total += ($contrato['vl_parcela_entrega'] > 0) ? $contrato['vl_parcela_entrega'] * $contrato['nr_parcela_entrega'] : 0;
if (isset($adicionais))
    foreach ($adicionais as $item)
        $total += $item['valor'] * $item['qtd'];

$primeiroDia = date_parse_from_format('Y-m-d', $contrato['dt_primeira_parcela'])['day'];
$ultimaParcela = date('Y-m-d', strtotime("+" . $contrato['nr_parcela'] . " month", strtotime($contrato['dt_primeira_parcela'])));

$arrData = explode("-", $contrato['dt_contrato']);
$dia = $arrData[2];
$mes = $arrData[1];
$ano = $arrData[0];
?>
<style type="text/css">

    .conteudoPdf {
        font-size: 12px;
        display: inline-block;
    }

    #titulo1 {
        width: 700px;
        font-size: 13pt;
    }

    #titulo2 {
        width: 700px;
        font-size: 12pt;
    }

    .texto {
        font-size: 12px;
        border-collapse: collapse;
    }

    .texto table, th, td {
        border: 1px solid black;
        padding: 5px;
    }

</style>
<page backtop="0mm" backbottom="0mm" backleft="0mm" backright="0mm">
    <?php
    //Funo dinamica de logomarca
    $clienteAcade = $this->get("clienteAcade");
    $dsEndLogomarca = $clienteAcade['ds_end_logomarca'];
    if ($dsEndLogomarca && file_exists($dsEndLogomarca)) {
        //Centralizada como texto, metodos da funo style, como align no fizeram mudanas na posio da imagem.
        echo '<p align="center" style="align:center"><img src="'.$dsEndLogomarca.'" alt="'.$clienteAcade['nm_fantasia'].'" height="120"></p>';
    } else {
        echo '<p align="center"  style="align:center"><img src="'.LOGOMARCA_DEFAULT.'" alt="LogoPadrao" height="80"></p>';
    }
    ?>
    <br>
    <br>
    <br>
    <div class="conteudoPdf" style="width:700px" width="700px">
        <div id="titulo1" align="center">
            CONTRATO PARTICULAR DE PROMESSA DE COMPRA E VENDA
            DO <?= strtoupper($empreendimento['nm_empreendimento']) ?>
        </div>
        <br/>
        <br/>
        <br/>
        <div id="titulo2">
            <p align="Right">
                <strong>Quadra <?= $lote['quadra']; ?> / Lote <?= $lote['lote']; ?></strong>
            </p>
        </div>
        <br>
        <div>
            <p class="texto" >
                <strong>QUALIFICAO DAS PARTES:</strong>
                <br>
                <br>
                <strong>1) F MOTA CONSTRUES E EMPREENDIMENTOS IMOBILIRIOS LTDA </strong>
                <span style="font-size: 12px;"> sociedade inscrita no <strong>CNPJ/MF sob o n 03.712.709/0001-08</strong>,
                    com sede no Ed. Loteamento Ayres, S/N, Centro, Barra de So Miguel, Alagoas, CEP 57.180-000,
                    neste ato sendo representado pelo scio <strong>FLVIO RUI GUERRA MOTA FILHO</strong>, brasileiro,
                    alagoano, solteiro, Engenheiro Civil, inscrito no CPF/MF sob o n 986.240.914-20, RG n 2002004498,
                    residente e domiciliado a Rua Padre Cicero, n 33, Ouro Preto, Macei/AL,
                    doravante designada <strong>PROMITENTE VENDEDOR.</strong>
                </span>
            </p>
            <p class="texto">
                <strong>2) <?= Helper::str2Upper($cliente['nm_pessoa']) ?>, </strong>
                <span style="font-size: 12px"> <strong><?= Helper::str2Upper($cliente['nm_nacionalidade']) ?></strong>,
                    <strong><?= Helper::str2Upper($cliente['est_civil_nome']) ?></strong><?= ($cliente['est_civil'] != 'SOL')? ', com ' : ','; ?><strong><?= Helper::str2Upper($cliente['conjugeP']['nm_pessoa'])?></strong><?= ($cliente['est_civil'] != 'SOL')? ', portador(a) do CPF <strong>'.Helper::str2Upper($cliente['conjugePF']['nr_cpf']).'</strong>,' : ''; ?>
                    <strong><?= Helper::str2Upper($cliente['nm_profissao']) ?></strong>, portador(a) da RG <strong><?= $cliente['nr_rg'] ?></strong>
                        e inscrito(a) no CPF/MF sob o n <strong><?= $cliente['nr_cpf'] ?></strong> residente e domiciliado na
                        <strong><?= Helper::str2Upper($cliente['endereco']) ?><?= ($cliente['nr_endereco']) ? ', ' . $cliente['nr_endereco'] : '' ?></strong>,
                         ,<strong><?= Helper::str2Upper($cliente['nm_bairro']) ?></strong>, <?= $cliente['cidade']['nome']; ?>
                    / <?= Db_Cidade::getEstados($cliente['cidade']['uf']); ?>, <strong>CEP <?= $cliente['nr_cep'] ?></strong>, doravante designado
                    <strong>PROMISSRIO COMPRADOR<?= ($outrosCompradores) ? ' e' : '.'; ?></strong>
                </span>
                <?php
                $len = count($outrosCompradores);
                if ($outrosCompradores) :
                    foreach($outrosCompradores as $value => $outros):?>
                        <strong> <?= Helper::str2Upper($outros['nm_pessoa'])?></strong>,
                        <span style="font-size: 12px"> <strong><?= Helper::str2Upper($outros['nm_nacionalidade']) ?></strong>,
                    <strong><?= Helper::str2Upper($outros['est_civil_nome']) ?></strong><?= ($outros['est_civil'] != 'SOL')? ', com ' : ','; ?><strong><?= Helper::str2Upper($outros['conjuge']['nm_pessoa'])?></strong><?= ($outros['est_civil'] != 'SOL')? ', portador(a) do CPF <strong>'.Helper::str2Upper($outros['conjuge']['nr_cpf']).'</strong>,' : ''; ?>
                    <strong><?= Helper::str2Upper($outros['nm_profissao']) ?></strong>, portador(a) da RG <strong><?= $outros['nr_rg'] ?></strong>
                        e inscrito(a) no CPF/MF sob o n <strong><?= $outros['nr_cpf'] ?></strong> residente e domiciliado na
                        <strong><?= Helper::str2Upper($outros['endereco']) ?><?= ($outros['nr_endereco']) ? ', ' . $outros['nr_endereco'] : '' ?></strong>,
                         ,<strong><?= Helper::str2Upper($outros['nm_bairro']) ?></strong>, <?= $outros['cidade']['nome']; ?>
                            / <?= Db_Cidade::getEstados($outros['cidade']['uf']); ?>, <strong>CEP <?= $outros['nr_cep'] ?></strong>, doravante designado
                    <strong>PROMISSRIO COMPRADOR<?= ($value == $len - 1) ? '.' : ' e'; ?></strong>
                </span>
                    <?php endforeach;?>
                <?php endif;?>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> Por este instrumento particular, as partes mencionadas e qualificadas tm, entre si,
                    ajustada e contratada a presente promessa de compra e venda, de forma irrevogvel e irretratvel,
                    conforme abaixo se consigna, mediante as clusulas, termos e condies seguintes.
                </span>
            </p>
        </div>
        <div>
            <p class="texto">
                <strong><u>CLUSULA PRIMEIRA - EMPREENDIMENTO</u></strong>
                <br>
                <br>
                <span style="font-size: 12px"> <strong>O PROMITENTE VENDEDOR</strong>  legtimo proprietrio,
                    do imvel, descritos e caracterizados como:
                    <?= $empreendimento['nm_empreendimento'] ?>,
                    Quadra <?= $lote['quadra']; ?>,
                    Lote <?= $lote['lote']; ?>,
                     Frente <?= $lote['conf_frente']; ?>
                    (<?= $lote['frente']; ?> m) - LD. <?= $lote['conf_direita']; ?>
                    (<?= $lote['direita']; ?> m) - LE.<?= $lote['conf_esquerda']; ?>
                    (<?= $lote['esquerda']; ?> m) e fundos com
                    <?= $lote['conf_fundo']; ?>(<?= $lote['fundo']; ?> m)
                </span>
            </p>
            <p class="texto">
                O <strong>PROMITENTE VENDEDOR</strong> aprovou a implantao do <?= $empreendimento['nm_empreendimento'] ?>,
                nos termos da Lei Federal n 6.766/1979, e consoante legislao Municipal de Marechal Deodoro, Alagoas.
            </p>
        </div>
        <div>
            <p class="texto">
                <strong><u>CLUSULA SEGUNDA - IMVEL OBJETO DESTE CONTRATO</u></strong>
                <br>
                <br>
                <span style="font-size: 12px"><strong>2.1</strong> Pelo presente instrumento e na melhor forma de direito,
                    o <strong>PROMITENTE VENDEDOR</strong> promete vender ao <strong>PROMISSRIO COMPRADOR</strong> e promete comprar,
                    nas condies estabelecidas neste instrumento o imvel descrito e caracterizado a seguir: Quadra <?= $lote['quadra']; ?>, Lote <?= $lote['lote']; ?>,
                    com as seguintes caractersticas:  medindo (<?= $lote['frente']; ?> m) de frente por  LD (<?= $lote['direita']; ?> m) e
                    LE (<?= $lote['esquerda']; ?> m) e (<?= $lote['fundo']; ?> m) fundos,
                    totalizando <?= $lote['area']; ?> m .
                </span>
            </p>
        </div>
        <div>
            <p class="texto">
                <strong><u>CLUSULA TERCEIRA - PREO E FORMA DE PAGAMENTO</u></strong>
                <br>
                <br>
                <span style="font-size: 12px"><strong>3.1</strong> Pelo lote <?= $lote['lote']; ?> da Quadra <?= $lote['quadra']; ?> do <?= $empreendimento['nm_empreendimento'] ?>,
                    localizado no Municpio de Marechal Deodoro, Estado de Alagoas, negociadas neste contrato,
                    o <strong>PROMISSRIO COMPRADOR</strong> pagar o valor de Total do Contrato R$ <?= Helper::getMoney($total) ?>
                </span>
            </p>
            <?php if($contrato['inclui_sinal_contrato'] == '1'){ ?>
                <p class="texto" style="margin-left: 5%">
                <span style="font-size: 12px"> <strong>a)</strong> Um sinal de R$ <?= Helper::getMoney($contrato['vl_sinal']); ?>(<?= Helper::valorPorExtenso($contrato['vl_sinal'], false, false) ?>)
                </span>
                </p>
            <?php } ?>
            <p class="texto" style="margin-left: 5%">
                <span style="font-size: 12px"> <strong><?= ($contrato['inclui_sinal_contrato']==1)?'b)':'a)' ?></strong> <?= $contrato['nr_parcela']; ?> (<?= Helper::valorPorExtenso($contrato['nr_parcela'], false, true) ?>)
                    parcelas no valor de R$ <?= Helper::getMoney($contrato['vl_parcela']); ?> (<?= Helper::valorPorExtenso($contrato['vl_parcela'], false, true) ?> reais)
                    subsequentes na data da assinatura deste contrato,<?php if ($contrato['fl_itens_contrato'] == 1): ?>
                        <?php foreach($adicionais as $item): ?>
                            mais  <?= $item['qtd']; ?> (<?= Helper::valorPorExtenso($item['qtd'], false, true) ?>)
                            parcelas no valor de R$ <?=  Helper::getMoney($item['valor']); ?> (<?= Helper::valorPorExtenso($item['valor'], false, true) ?> reais),
                        <?php endforeach; ?>
                    <?php endif; ?>
                    <strong>totalizando em R$ <?= Helper::getMoney($total);?>
                        (<?= Helper::valorPorExtenso($total)?>)</strong>,
                    iniciando a primeira parcela no dia <?= Helper::getDate($contrato['dt_primeira_parcela']);?> de R$ <?= Helper::getMoney($contrato['vl_parcela']); ?>,
                    a serem corrigidos pelo <?= $empreendimento["nomeIndice"]?> ao ano at a quitao deste contrato.
                </span>
            </p>
            <?php if ($contrato['nr_intercalada'] > 0){ ?>
                <p class="texto" style="margin-left: 5%">
                    <span style="font-size: 12px">
                        <strong>c)</strong> <?= $contrato['nr_intercalada'] ?> intercaladas no valor de R$ <?= Helper::getMoney($contrato['vl_intercalada'])?> com a primeira para o dia <?= Helper::getDate($contrato['dt_primeira_parcela'])?>
                    </span>
                </p>
            <?php } ?>
            <p class="texto">
                <span style="font-size: 12px"> <strong>3.2</strong> Sempre que qualquer pagamento relacionado com o presente compromisso
                    for efetuado pelo <strong>PROMISSRIO COMPRADOR</strong> com o uso de cheque,a sua quitao apenas ser considerada aps a respectiva compensao.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>3.3</strong> Caso haja, por qualquer motivo, dificuldade na compensao do cheque apresentado para pagamento,
                    s consequncias sero suportadas exclusivamente pelo <strong>PROMISSRIO COMPRADOR</strong>,
                    considerando-se como atraso o pagamento verificado entre o vencimento da dvida e a data em que o cheque for efetivamente compensado,
                    sujeitando-se o <strong>PROMISSRIO COMPRADOR</strong> ao pagamento de juros, multa e demais penalidades previstas neste contrato,
                    assim como o reembolso de eventuais despesas decorrentes de tal fato.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>3.4</strong> As parcelas descritas na <strong>Clusula 3.1</strong> sero atualizadas,
                    a partir do ms subsequente  assinatura deste instrumento, anualmente,
                    pela variao positiva do ndice Geral de Preos do Mercado - IGP-M, publicado pela Fundao Getlio Vargas.
                    Fica a critrio de o <strong>PROMITENTE VENDEDOR</strong> efetuar a cobrana dos valores devidos a ttulo de atualizao,
                    mensalmente ou anualmente (neste ltimo caso, em uma nica parcela). Caso o <strong>PROMITENTE VENDEDOR</strong> no efetue a cobrana da atualizao,
                    esta ser uma deciso de mera liberalidade e no significar novao ou repactuao,
                    sendo que o <strong>PROMISSRIO COMPRADOR</strong>, desde j, se declara concorde.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>3.5</strong> Em caso de medidas ou atos praticados pelo Poder Pblico que modifiquem a poltica econmica,
                    implicando a extino do ndice de atualizao monetria eleito neste instrumento, sem que haja a indicao do atualizador monetrio substituto,
                    O PROMISSRIO COMPRADOR, desde j, aceita, em substituio, um dos seguintes ndices, pela ordem:
                    INCC (ndice Nacional da Construo Civil) ou IPC (ndice de Preos ao Consumidor).
                </span>
            </p>
            <p class="texto" style="margin-left: 5%">
                <span style="font-size: 12px"> <strong>3.5.1</strong> As partes reconhecem que a atualizao monetria prevista neste contrato no caracteriza qualquer pena ou remunerao,
                    mas significa apenas o restabelecimento do poder de compra da moeda diante dos efeitos da inflao, tendo em vista preservar o equilbrio econmico-financeiro deste contrato.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>3.6</strong> Em face do ajustado quanto ao preo, parcelas, reajustes, resduos, dentre outros, o pagamento de qualquer parcela,
                    corrigida de maneira diversa da estabelecida neste contrato, inclusive perante terceiros autorizados a receb-los, no implicar a quitao do respectivo dbito.
                </span>
            </p>
            <p class="texto" style="margin-left: 5%">
                <span style="font-size: 12px"> <strong>3.6.1</strong> Qualquer diferena verificada entre os pagamentos efetuados pelo <strong>PROMISSRIO COMPRADOR</strong> e
                    a sistemtica de clculo dos valores estabelecida neste instrumento, dever ser imediatamente quitada, no prazo mximo de 36 (trinta e seis) horas,
                    contado do aviso que o <strong>PROMITENTE VENDEDOR</strong> lhe dirigir nesse sentido.
                </span>
            </p>
            <p class="texto" style="margin-left: 5%">
                <span style="font-size: 12px"> <strong>3.6.2</strong> O recibo de pagamento da ltima parcela vencida no significa quitao do contrato ou da parcela anterior,
                    que dever ser sempre comprovada, quando exigido.
                </span>
            </p>
            <p class="texto" style="margin-left: 5%">
                <span style="font-size: 12px"> <strong>3.6.3</strong> O <strong>PROMISSRIO COMPRADOR</strong> no poder pagar qualquer prestao do saldo do preo,
                    enquanto no tiverem sido pagas e quitadas aquelas que estiverem vencidas anteriormente.
                    Nos meses em que se verificarem vencimentos simultneos de prestaes do saldo do preo,
                    fica assegurado ao <strong>PROMITENTE VENDEDOR</strong> o direito de recusar o recebimento de qualquer delas sem que se verifique,
                    concomitantemente, o pagamento da outra.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>3.7</strong> A tolerncia do <strong>PROMITENTE VENDEDOR</strong> ou qualquer de seus prepostos,
                    quanto ao recebimento de qualquer prestao ou encargo, de maneira diversa da estabelecida neste contrato,
                    no poder ser invocada como novao, consistindo em mera liberalidade.
                    A no aplicao imediata das sanes decorrentes do pagamento irregular no significar renncia do <strong>PROMITENTE VENDEDOR</strong> a este direito,
                    podendo vir a exerc-lo em qualquer tempo.
                </span>
            </p>
            <p class="texto" style="margin-left: 5%">
                <span style="font-size: 12px"> <strong>3.7.1</strong> O pagamento de prestaes efetuado em desconformidade com as condies estabelecidas neste Capitulo,
                        no ser considerado pelo <strong>PROMITENTE VENDEDOR</strong> para quitao das mesmas.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>3.8</strong> Facultar-se- o <strong>PROMISSRIO COMPRADOR</strong> pagar antecipadamente qualquer parcela do preo,
                    desde que o faa com valor devidamente atualizado e corrigido pela variao acumulada do ndice adotado para este contrato,
                    desde a data de assinatura deste instrumento at a data do efetivo pagamento;
                    no sendo permitido tal adiantamento nos perodos de congelamento de preos ou anomalias econmicas,
                    ou quando for iminente o aumento extraordinrio da correo das parcelas em decorrncia de fato previsvel.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>3.9</strong> Havendo impossibilidade de efetivao dos reajustes previstos nessa Clusula Terceira em virtude de medidas legais ou judiciais,
                    as partes signatrias definem e aceitam, sem qualquer ressalva, que os valores resultantes da aplicao desses reajustes, na forma prevista neste contrato,
                    sero incorporados na primeira parcela a ser paga, que se vencer aps a cessao ou revogao do ato que ensejou tal impedimento,
                    ou quando do pagamento integral do saldo devedor com sua consequente quitao.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>3.10</strong> No final de cada periodicidade admitida para a aplicao das correes ser apurada a perda inflacionria que eventualmente possa
                    ter ocorrido naquele perodo.
                </span>
            </p>
            <p class="texto" style="margin-left: 5%">
                <span style="font-size: 12px"> <strong>3.10.1</strong> O Para fins de clculo do resduo em destaque,
                    calcular-se  diferena entre o valor da parcela integralmente reajustada/corrigida na forma prevista neste contrato e o valor lquido efetivamente pago.
                </span>
            </p>
            <p class="texto" style="margin-left: 5%">
                <span style="font-size: 12px"> <strong>3.10.2</strong> A reposio da perda inflacionria, correspondente  somatria dos resduos apurados no perodo,
                    corrigidos pelo ndice contratual at a data de seu efetivo pagamento, ser paga,  vista, pelo <strong>PROMISSRIO COMPRADOR</strong>,
                    juntamente com o vencimento da primeira parcela referente ao perodo subsequente.
                </span>
            </p>
            <p class="texto" style="margin-left: 5%">
                <span style="font-size: 12px"> <strong>3.10.3</strong> Ter o <strong>PROMISSRIO COMPRADOR</strong> que pagar, juntamente com a parcela mensal,
                    o correspondente resduo, caso este venha a existir. O pagamento das parcelas, juntamente com o respectivo resduo,
                    dar-lhes-  quitao total, eximindo assim o <strong>PROMISSRIO COMPRADOR</strong> da apurao contratual e do pagamento da correspondente reposio inflacionria.
                </span>
            </p>
            <p class="texto" style="margin-left: 5%">
                <span style="font-size: 12px"> <strong>3.10.4</strong> Excepcionalmente, para que se mantenha o equilbrio financeiro do contrato e evitar o acmulo de dispndios que
                    dificultem a continuidade e adimplemento das prestaes, caso o resduo apurado de acordo com o pactuado neste contrato venha a atingir ou superar o equivalente a 15% (quinze por cento)
                    do valor da parcela que esteja, reajustando-se, incontinente, as parcelas subsequentes.
                </span>
            </p>
            <p class="texto" style="margin-left: 5%">
                <span style="font-size: 12px"> <strong>3.10.5</strong> No caso de impossibilidade de aplicao do disposto nesta clusula, por motivo superveniente e independente da vontade do
                    <strong>PROMITENTE VENDEDOR</strong>,fica pactuado que o reajuste/correo fica automaticamente transferido para o dia primeiro do ms em que esteja autorizada a aplicao do reajuste/correo,
                    de tal maneira que o pagamento das parcelas vincadas incorpore sempre a inflao integral do perodo decorrido, na medida pelo ndice contratual.
                </span>
            </p>
            <p class="texto" style="margin-left: 5%">
                <span style="font-size: 12px"> <strong>3.10.6</strong> As partes, desde j, convencionam como condio do presente negcio, que,
                    em face do princpio constitucional do respeito ao direito adquirido e ao ato jurdico perfeito, no se aplicar a este contrato qualquer norma superveniente de congelamento ou deflao,
                    bem como restrio ou alterao da forma de correo monetria, total ou parcial, do saldo devedor e/ou do valor de casa parcela.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>3.11</strong> O <strong>PROMISSRIO COMPRADOR</strong>, de acordo com a sua convenincia, poder antecipar o pagamento das parcelas vincendas, que, nesta hiptese,
                    sero atualizadas pela correo mensal do IGP-M (ndice Geral de Preos de Mercado) entre a data do ltimo reajuste e a do efetivo pagamento.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>3.12</strong> O Na hiptese de atraso no pagamento das parcelas convencionadas na <strong>Clusula 3.1</strong>,
                    o <strong>PROMISSRIO COMPRADOR</strong> incorrer em multa a ser paga  razo de 2% (dois por cento) sobre o valor da dita parcela e juros de mora 1% (um por cento) ao ms, pro rata die,
                    sobre o referido montante, independentemente de notificao judicial ou extrajudicial e sem prejuzo da atualizao monetria convencionada nas clusulas anteriores.
                </span>
            </p>
        </div>
        <div>
            <p class="texto">
                <strong><u>CLUSULA QUARTA - POSSE E PRAZO DE ENTREGA</u></strong>
                <br>
                <br>
                <span style="font-size: 12px"><strong>4.1</strong> O prazo de entrega da unidade objeto deste contrato ser contado aps <strong>a liberao do Alvar do projeto do referido lote</strong>,
                    sendo vedada a realizao de qualquer construo ou benfeitoria sem previamente ser aprovado pela Prefeitura Municipal.
                </span>
            </p>
            <p class="texto" style="margin-left: 5%">
                <span style="font-size: 12px"> <strong>4.1.1</strong> Caso aprovada pela Prefeitura Municipal e aps expressa autorizao, nos moldes da clusula acima,
                    O <strong>PROMISSRIO COMPRADOR</strong> realizar a construo ou benfeitoria por sua prpria conta e risco. Caso O <strong>PROMISSRIO COMPRADOR</strong> venha a perder o terreno por falta de pagamento,
                    as benfeitorias e construes, ainda que no autorizadas, sero revertidas em favor do <strong>PROMITENTE VENDEDOR</strong>, observados os termos da Clusula Nona deste contrato,
                    respeitado o disposto no artigo 34, da Lei Federal n 6.766/1979.
                </span>
            </p>
            <p class="texto" style="margin-left: 5%">
                <span style="font-size: 12px"> <strong>4.1.2</strong> Ao conceder autorizao para construes,
                    o <strong>PROMITENTE VENDEDOR</strong> expedir orientaes e recomendaes que devero ser observadas e cumpridas pelo <strong>PROMISSRIO COMPRADOR</strong>,
                    como condio indispensvel para obteno dos benefcios e direitos ali preconizados.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>4.2</strong> Todas as obras de implantao e infraestrutura do Lote sero realizados de acordo
                    com o projeto aprovado pela Prefeitura Municipal e nos termos da Lei Federal n 6.766/1979.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>4.3</strong> Decorrido o prazo previsto na Clusula 4.1 acima,
                    o PROMITENTE VENDEDOR automaticamente cede e transfere ao <strong>PROMISSRIO COMPRADOR</strong> a posse direta dos imvel objeto deste contrato,reservando para si a posse indireta.
                    A posse, entretanto,  exercida pelo <strong>PROMISSRIO COMPRADOR</strong> em carter precrio at que seja plenamente cumprido este contrato.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>4.4</strong> A partir desta data, o <strong>PROMISSRIO COMPRADOR</strong> assume todas as obrigaes relativas a impostos,
                    taxas, tarifas, contribuies de melhoria ou quaisquer outros tributos que incidem ou que venham a incidir sobre o imvel ora transacionado,
                    mesmo que seus lanamentos sejam feitos em nome do <strong>PROMITENTE VENDEDOR</strong> ou de terceiros.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>4.5</strong> O <strong>PROMISSRIO COMPRADOR</strong> obriga-se a providenciar, dentro do prazo mximo de 90 (noventa) dias,
                    contados do recebimento de sua via deste instrumento, a inscrio do imvel objeto do presente em seu nome junto  Prefeitura Municipal.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>4.6</strong> Fica facultado ao <strong>PROMITENTE VENDEDOR</strong> providenciar a inscrio imobiliria prevista no item anterior,
                    caso o <strong>PROMISSRIO COMPRADOR</strong> no o faa, a qual ficar obrigada a ressarci-la das causas pagas, atualizadas monetariamente,
                    bem como ao pagamento de uma taxa relativa aos servios praticados pelo <strong>PROMITENTE VENDEDOR</strong> para tal finalidade.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>4.7</strong> Independente do estipulado nos itens anteriores,
                    caso o <strong>PROMITENTE VENDEDOR</strong> venha a sofrer qualquer tipo de ao relativa a tributos incidentes sobre o imvel ora prometido  venda,
                    correro por conta do <strong>PROMISSRIO COMPRADOR</strong> todas as despesas que forem despendidas pelo <strong>PROMITENTE VENDEDOR</strong> para resguardo de seus direitos,
                    inclusive honorrios advocatcios, desde j estabelecidos em 10% (dez por cento) do valor do dbito, devidamente atualizado monetariamente.
                </span>
            </p>
        </div>
        <div>
            <p class="texto">
                <strong><u>CLUSULA QUINTA- DESTINAO E OCUPAO DO LOTE NEGOCIADO</u></strong>
                <br>
                <br>
                <span style="font-size: 12px"><strong>5.1</strong> O lote ora prometido destina-se a fins exclusivamente residenciais.
                </span>
            </p>
            <p class="texto" style="margin-left: 5%">
                <span style="font-size: 12px"> <strong>5.1.1</strong> No ser permitida, nos lotes com <u>destinao residencial</u>,
                    a construo de prdios comerciais e industriais que causem perturbao de vizinhos.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>5.2</strong> O <strong>PROMISSRIO COMPRADOR</strong> promete proceder  ocupao do lote em questo,
                    observando integralmente, no s o que estipulado no presente instrumento,
                    mas tambm todas as exigncias impostas pela lei e pelos rgos pblicos.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>5.3</strong> O <strong>PROMITENTE COMPRADOR</strong> tambm declara e reconhece que no poder habitar
                        o lote antes da concesso e averbao do auto de concluso (?Habita-se?), a ser emitido pela Prefeitura Municipal.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>5.4</strong> Na hiptese de ocorrer a desapropriao do dito lote pelo Poder Pblico, o <strong>PROMITENTE VENDEDOR</strong>,
                    estar isento de qualquer responsabilidade.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>5.5</strong> O <strong>PROMISSRIO COMPRADOR</strong> declara que tomou conhecimento do perfil topogrfico do lote,
                    percorrendo pessoalmente suas divisas, e achando-as conforme as especificaes e confrontaes constantes do presente e que o terreno  (so) entregue devidamente demarcado.
                    No caso de desaparecimento dos marcos, O <strong>PROMISSRIO COMPRADOR</strong> deve se dirigir ao escritrio local da marcao,
                    ficando expressamente proibidas quaisquer construes sem que o lote esteja  demarcado.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>5.6</strong> O Qualquer diferena a maior ou a menor, superior  admitida em lei
                    (artigo 500, Pargrafo Primeiro, do Cdigo Civil Brasileiro), isto , 1/20 da extenso total enunciada na metragem do imvel ora compromissado,
                    dever ser acusada pelas partes no prazo mximo de 12 (doze) meses a contar da assinatura do presente,
                    devendo ser compensada tanto em relao ao <strong>PROMITENTE VENDEDOR</strong> com em relao ao <strong>PROMISSRIO COMPRADOR</strong>,
                    na base do preo por metro quadrado pelo qual  celebrado o presente negcio, sendo que esta compensao se dar em favor do <strong>PROMISSRIO COMPRADOR</strong> mediante abatimento do preo.
                    Aps o prazo estipulado de 12 (doze) meses, no caber s partes ora contratantes qualquer direito  compensao por diferena de rea.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>5.7</strong> O <strong>PROMISSRIO COMPRADOR</strong> obriga-se expressamente a permitir gratuitamente a passagem,
                    pelo lote, de canalizaes de gua servida, potvel e/ou pluvial e de esgotos que eventualmente sejam realizadas pelos Poderes Pblicos ou por terceiros,
                    as quais podero atravessar o lote em uma faixa de 1,50 metros das suas divisas laterais ou aos fundos, desde que devidamente canalizados.
                    Correr por conta do beneficirio da servido toda e qualquer despesa inerente a este servio, bem como sua manuteno.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>5.8</strong> Com relao  canalizao de guas pluviais dentro da rea do lote,
                    fica a critrio do <strong>PROMISSRIO COMPRADOR</strong> a sua execuo, sendo que todas as despesas inerentes a este servio,
                    bem como sua manuteno, correro por conta do <strong>PROMISSRIO COMPRADOR</strong>.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>5.9</strong> O sistema de lazer e outra rea no podero ser utilizados
                    como acesso para os lotes que fazem frente ou divisas para tais locais.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>5.10</strong> O <strong>PROMISSRIO COMPRADOR</strong> est ciente de que est obrigada a efetuar as devidas
                    interligaes para abastecimento de gua potvel e coleta de esgotos sanitrios ou execuo de poo fretico e/ou fossa sptica, conforme o caso,
                    e de acordo com as regulamentaes dos rgos pblicos, especialmente da Prefeitura Municipal.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>5.11</strong> O <strong>PROMISSRIO COMPRADOR</strong> dever obedecer rigorosamente s determinaes da Prefeitura Municipal
                    e demais rgos pblicos competentes referentes  utilizao e aproveitamento do lote, no podendo, outrossim, fazer instalaes prejudiciais aos lotes vizinhos,
                    responsabilizando-se exclusiva e inteiramente por eventuais infraes s leis, regulamentos e posturas que devam ser observadas
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>5.12</strong> O <strong>PROMISSRIO COMPRADOR</strong> deve observar as restries que regulam o direito de utilizao e aproveitamento do lote,
                    impostas pela Municipalidade e por este instrumento, tanto quanto ao uso do solo, como quanto  aprovao de projetos.
                    Tais restries devero ser cumpridas pelo <strong>PROMISSRIO COMPRADOR</strong> e seus sucessores, sendo que as partes, desde j autorizam o Sr. Oficial de Registro de Imveis
                    a proceder  averbao destas obrigaes. As restries de uso e de aproveitamento do lote tm a finalidade precpua de assegurar o uso indevido e danoso dos imveis,
                    que poder vir a desvalorizar a propriedade, assegurar um adequado e razovel uso da propriedade e estimular construes de residncias e outros prdios de arquitetura
                    compatvel com as caractersticas do empreendimento.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>5.13</strong> Fica terminantemente proibido o desmembramento deste lote , mesmo que a legislao assim o permita,
                    a no ser dos lotes resultantes da unificao de dois ou mais lotes. Da mesma forma, no  permitida a construo de mais de uma residncia por lote.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>5.14</strong> So proibidos letreiros e anncios nos terrenos e nas edificaes sobre empreendimentos semelhantes
                    e concorrentes com o empreendimento objeto deste instrumento.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>5.15</strong>  Enquanto no construir, O <strong>PROMISSRIO COMPRADOR</strong> dever manter o lote limpo e roado.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>5.16</strong>  No ser permitida a ocupao de lote vizinho para fins de canteiro de obras, depsito de materiais
                    ou quaisquer outras finalidades sem prvia autorizao, por escrito, do proprietrio/possuidor do lote que se pretende ocupar.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>5.17</strong>  Nos lotes com divisas de fundo confortantes com rea Verde, Sistema de Lazer e/ou Vielas,
                    no ser permitido qualquer avano de construes sobre as referidas reas
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>5.18</strong>  Todo e qualquer comprador ser obrigado a dar servido para passagens de tubulao de guas pluviais e esgotos,
                    na faixa de recuo lateral ou recuo de fundos, desde que devidamente canalizadas. Correr por conta do usurio da servido toda e qualquer despesa inerente a este servio,
                    bem como a sua manuteno.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>5.19</strong>  Podero ser unidos ou recompostos dois ou mais lotes contguos, de modo a formar um ou mais lotes, observado o disposto na <strong>Clusula 5.13</strong>.
                    Todas as obrigaes contidas neste instrumento continuaro a ser aplicadas a esses novos lotes resultantes de unificao e/ou desmembramento.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> <strong>5.20</strong>  O descumprimento das obrigaes previstas nesta Clusula Quinta sujeita o <strong>PROMISSRIO COMPRADOR</strong> e/ou seus sucessores  cominao da multa mensal,
                    enquanto no for restabelecida a situao contratual, multa esta a ser fixada e cobrada pelo <strong>PROMITENTE VENDEDOR</strong>,
                    independente das sanes e penalidades que possam ser impostas pelos rgos pblicos competentes.
                </span>
            </p>
        </div>
        <div>
            <p class="texto">
                <strong><u>CLUSULA SEXTA - OBRAS INFRAESTRUTURA</u></strong>
                <br>
                <br>
                <span style="font-size: 12px"><strong>6.1</strong> A infra-estrutura bsica e extra do lote descrito na Clusula Primeira deste instrumento,
                    parte do <strong>RESIDENCIAL ALTO DA LAGOA</strong>, compreende os servios realizados pelo <strong>PROMITENTE VENDEDOR</strong>, conforme descries e prazos, estes contados a partir do ms de (ms/ano,
                    a seguir definidos, de acordo com as especificaes constantes no projeto aprovado pela Prefeitura Municipal:
                </span>
            </p>
            <p class="texto" style="margin-left: 5%">
                <span style="font-size: 12px">a) <u>Com prazo de aproximadamente 48 meses:</u> <strong>Infra-estrutura compreendendo:</strong> execuo de rede de abastecimento de gua;
                    [execuo de rede eltrica; meio-fio ao longo da trajetria das vias
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>6.2</strong> Seguindo normas da companhia energtica local, a energia eltrica ser ligada, no que for de competncia do PROMITENTE VENDEDOR,
                    em aes a serem implementadas de acordo com o padro exigido pela concessionria e  medida que forem construdas e efetivamente ocupadas as respectivas unidades consumidoras.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>6.3</strong> O <strong>PROMISSRIO COMPRADOR</strong> ter,  sua disposio, no escritrio local do <strong>PROMITENTE VENDEDOR</strong>,
                    o arquivo eletrnico do projeto de sistema sanitrio, que obedece a todas as exigncias legais e que poder ser repassado via e-mail.
                </span>
            </p>
        </div>
        <div>
            <p class="texto">
                <strong><u>CLUSULA STIMA - TOLERNCIA</u></strong>
                <br>
                <br>
                <span style="font-size: 12px"><strong>7.1</strong> Haver, em caso de atraso na entrega da unidade,
                    um prazo de tolerncia de 180 (cento e oitenta) dias, sem que o <strong>PROMITENTE VENDEDOR</strong> incorra em qualquer penalidade.
                </span>
            </p>
            <p class="texto" style="margin-left: 5%">
                <span style="font-size: 12px"><strong>7.1.1</strong> Ressalvam-se, tambm a favor do <strong>PROMITENTE VENDEDOR</strong>, atrasos decorrentes de:
                </span>
            </p>
            <p class="texto" style="margin-left: 10%">
                <span style="font-size: 12px">a) Caso fortuito e/ou de fora maior, devidamente comprovados, nos termos do Cdigo Civil Brasileiro, que suspendero o prazo previsto;
                </span>
            </p>
            <p class="texto" style="margin-left: 10%">
                <span style="font-size: 12px">b)Chuvas, dias inoperantes, greves em geral, racionamentos, embargos de qualquer causa ou natureza, falta ou escassez de materiais,
                    de energia eltrica e/ou de iluminao, mudanas na poltica econmica, atos de guerra, subverso generalizada, revolues, epidemias, radiaes atmicas,
                    contaminaes qumicas, fogo, graves inundaes, ciclones, fortes tremores de terra, cataclismos naturais,
                    resolues ou outros fatos que independam da vontade da parte <strong>PROMITENTE VENDEDOR</strong> e impeam o normal andamento das obras.
                </span>
            </p>
            <p class="texto" style="margin-left: 5%">
                <span style="font-size: 12px"><strong>7.1.2</strong> O PROMISSRIO COMPRADOR tem pleno conhecimento de que responde civil e criminalmente pelos danos que:
                </span>
            </p>
            <p class="texto" style="margin-left: 10%">
                <span style="font-size: 12px">a) Causar a terceiros por fato a que lhe possa ser imputado, ou a terceiros que vier a contratar,
                    em razo de eventos relacionados ao lote adquirido ou  execuo de obras que nele vierem a ser edificadas;
                </span>
            </p>
            <p class="texto" style="margin-left: 10%">
                <span style="font-size: 12px">b) Qualquer ato que implique em dano ou degradao ambiental,
                    decorrente de ao de terceiros que vier a contratar para a execuo de servios e obras no lote adquirido,
                    tais como, mas sem se limitar a: movimento de terra que implique em eroso ou assoreamento
                </span>
            </p>
        </div>
        <div>
            <p class="texto">
                <strong><u>CLUSULA OITAVA - CESSO E TRANSFERNCIA</u></strong>
                <br>
                <br>
                <span style="font-size: 12px"><strong>8.1</strong> Para fins de efetivao da transferncia do contrato,
                    solicitada pelo <strong>PROMISSRIO COMPRADOR</strong>, em favor de terceiro,  necessrio, ao <strong>PROMITENTE VENDEDOR</strong>,
                    03 (trs) cpias autenticadas da Cdula de Identidade (RG), do CPF/MF, da Certido de registro Civil e do comprovante de endereo do cedente e do seu cnjuge,
                    se houver, devendo o cedente estar em dia com suas obrigaes financeiras perante ao <strong>PROMITENTE VENDEDOR</strong>
                    e apresentar certido negativa de tributos municipais (IPTU) referente ao lote porventura cedido.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>8.2</strong> Pagar ao <strong>PROMITENTE VENDEDOR</strong> o valor equivalente a 2% do valor do contrato para cobrir despesas administrativas.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>8.3</strong> Fica assegurado ao <strong>PROMITENTE VENDEDOR</strong> o direito de preferncia, sem igualdade de condies com terceiros,
                    para o caso de o PROMISSRIO COMPRADOR pretender ceder ou transferir seus direitos oriundos deste instrumento.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>8.4</strong> Fica terminantemente vedado ao <strong>PROMISSRIO COMPRADOR</strong> transferir parte do lote compromissado, sob pena de resciso deste presente contrato.
                    Fica ainda pactuado que o <strong>PROMITENTE VENDEDOR</strong> no autografo a escritura de venda e compra do lote compromissado em partes certas de reas, mas, unicamente, em sua totalidade.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>8.5</strong> Todas as disposies estabelecidas neste contrato obrigam no apenas ao primeiro e atual <strong>PROMISSRIO COMPRADOR</strong>,
                    mas tambm a todos que venham suced-la a qualquer ttulo ou como resultado de qualquer transao, sendo obrigatria a transcrio de todas as restries especificas e gerais aqui mencionadas.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>8.6</strong> Todas e quaisquer despesas decorrentes de cesso e de transferncia de direitos e obrigaes do presente contrato correro por conta nica e exclusiva das partes que a celebrarem,
                    no podendo ser imputado ao PROMITENTE VENDEDOR qualquer tipo de responsabilidade quanto ao pagamento destas.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>8.7</strong> O cessionrio dos direitos aquisitivo fica igualmente obrigado a respeitar todas as regras pertinentes ao loteamento, inclusive suas restries e normas,
                    mesmo que tais disposies no estejam transcritas no contrato de cesso, devido ao carter pblico de tais regras e disposies.
                </span>
            </p>
        </div>
        <div>
            <p class="texto">
                <strong><u>CLUSULA NONA - RESCISO POR INADIMPLNCIA</u></strong>
                <br>
                <br>
                <span style="font-size: 12px"><strong>9.1</strong> O atraso no pagamento de 03(trs) das parcelas indicadas na Clusula Terceira, consecutivas ou alternadas, ser motivo de resciso deste contrato,
                    independentemente de interpelao judicial ou extrajudicial, caso em que o <strong>PROMITENTE VENDEDOR</strong> far jus  integralidade do sinal recebido, nos termos do artigo 418 do Cdigo Civil,
                    perdendo, ainda, o <strong>PROMISSRIO COMPRADOR</strong> em benefcio do <strong>PROMITENTE VENDEDOR</strong>, 50% (cinquenta por cento) do total das parcelas pagas, a ttulo de indenizao por perdas e danos,
                    corretagem e publicidade, sem prejuzo de indenizao suplementar porventura devida.
                </span>
            </p>
            <p class="texto" style="margin-left: 5%">
                <span style="font-size: 12px"><strong>9.1.1</strong> O inadimplemento de 03 (trs) parcelas, nos termos desta clusula, facultar ao PROMITENTE VENDEDOR o cancelamento do presente compromisso,
                    nos termos do artigo 32 e seguintes, da Lei Federal n 6.766/1979.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>9.2</strong> No caso da devoluo dos 50% (cinquenta por cento), nos termos da <strong>Clusula 9.1</strong>,
                    o <strong>PROMITENTE VENDEDOR</strong> realizar tal restituio em tantas parcelas quantas tenham sido pagas pelo <strong>PROMISSRIO COMPRADOR</strong>,
                    at a data da resciso, bem como somente iniciar tais pagamentos aps revender o referido lote,
                    ou em 90 (noventa) dias aps a resciso, o que ocorrer primeiro.
                </span>
            </p>
            <p class="texto" style="margin-left: 5%">
                <span style="font-size: 12px"><strong>9.2.1</strong> Na hiptese desta clusula,caso o PROMISSRIO COMPRADOR no fornea, imediatamente e por escrito,
                    os dados bancrios para realizao do depsito em comento, o pagamento, ficar suspenso at que fornea tais informaes.
                </span>
            </p>
            <p class="texto" style="margin-left: 5%">
                <span style="font-size: 12px"><strong>9.2.2</strong> Do valor a ser restitudo, sero descontados os valores referentes aos tributos e s taxas irrecuperveis,
                    devidos, vencidos e no pagos pelo <strong>PROMISSRIO COMPRADOR</strong> exemplificativamente, mas sem se limitar, IPTU (Imposto Predial Territorial Urbano),
                    taxas devidas  Associao, tarifas de gua, energia eltrica, multas de qualquer ordem, custas cartorrias, notificaes, editais e baixas de registro.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>9.3</strong> Rescindido o contrato, ao <strong>PROMITENTE VENDEDOR</strong> se reintegrar na posse direta do imvel.
                    Assim, eventual permanncia do <strong>PROMISSRIO COMPRADOR</strong> no imvel, nesta hiptese, ser considerada esbulho, pelo que, desde j,
                    reconhece ao <strong>PROMISSRIO COMPRADOR</strong> o direito do <strong>PROMITENTE VENDEDOR</strong> em ser reintegrada na posse do imvel,
                    pelo meio processual estabelecido no artigo 926, do Cdigo Civil, sendo vlido e legtimo, outrossim, o mandado reintegratria liminar,
                    sem a audincia do <strong>PROMISSRIO COMPRADOR</strong>.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>9.4</strong> Por fora do disposto no artigo 34, da Lei Federal n 6.766/1979,
                    somente sero indenizadas as benfeitorias necessrias e teis que tiverem sido levadas a efeito no lote com a prvia e
                    expressa autorizao dos Poderes Pblicos competentes e em conformidade com as disposies contratuais e legais.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>9.5</strong> O <strong>PROMISSRIO COMPRADOR</strong> no ter direito a qualquer indenizao ou reteno por benfeitorias voluntrias realizadas no imvel,
                    bem como por benfeitorias realizadas em desconformidade com este contrato e/ou com as exigncias e/ou restries urbansticas impostas pelo Poder Pblico.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>9.6</strong> Sem prejuzo das demais penalidades estipuladas neste contrato,
                    o <strong>PROMITENTE VENDEDOR</strong> poder optar por considerar rescindido o presente negcio ou, alternativamente,
                    vencido antecipadamente todo o preo de aquisio do imvel objeto deste contrato,
                    caso em que o <strong>PROMISSRIO COMPRADOR</strong> dever quitar o saldo do preo,
                    devidamente corrigido monetariamente e acrescido dos juros contratuais, em at 15 (quinze) dias, na seguintes hipteses:
                </span>
            </p>
            <p class="texto" style="margin-left: 5%">
                <span style="font-size: 12px">a) Se o <strong>PROMISSRIO COMPRADOR</strong> no pagar 03(trs) parcelas do preo de aquisio do lote objeto deste contrato,
                    consecutivas ou no, e deixar de purgar a mora;
                </span>
            </p>
            <p class="texto" style="margin-left: 5%">
                <span style="font-size: 12px">b) Se o <strong>PROMISSRIO COMPRADOR</strong> construir quaisquer nus sobre os direitos aquisitivos objeto deste contrato.
                </span>
            </p>
            <p class="texto" style="margin-left: 5%">
                <span style="font-size: 12px">c) Insolvncia ou decretao de falncia do <strong>PROMISSRIO COMPRADOR.</strong>
                </span>
            </p>
            <p class="texto" style="margin-left: 5%">
                <span style="font-size: 12px">d) Descumprimento, pelo <strong>PROMISSRIO COMPRADOR</strong>, de qualquer obrigao prevista neste contrato,
                    salvo aquelas que tenham penalidade especialmente previstas.
                </span>
            </p>
        </div>
        <div>
            <p class="texto">
                <strong><u>CLUSULA DCIMA - OUTORGA DA ESCRITURA DEFINITIVA</u></strong>
                <br>
                <br>
                <span style="font-size: 12px"><strong>10.1</strong>  Verificada a quitao da totalidade do preo do imvel objeto deste contrato,
                    obriga-se, no prazo, mximo de 120 (cento e vinte) dias, o <strong>PROMITENTE VENDEDOR</strong> a assinar em nome do <strong>PROMISSRIO COMPRADOR</strong> ou de terceiro por este indicado,
                    a competente escritura definitiva de compra e venda do imvel, totalmente desembaraado e sem quaisquer nus ou gravames de qualquer natureza.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>10.2</strong> SA inadimplncia do <strong>PROMITENTE VENDEDOR</strong>,
                    consiste na recusa  outorga da escritura definitiva de que trata esta Clusula do imvel, na forma de lei.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>10.3</strong> Sero de exclusiva responsabilidade do <strong>PROMISSRIO COMPRADOR</strong> as despesas com o pagamento de taxas,
                    laudmio, ITIV, ITBI, custas e emolumentos devidos para a lavratura e registro, no Cartrio de Imveis,
                    da escritura pblica de compra e venda do imvel objeto deste contrato, bem como IPTU a partir da assinatura deste instrumento.
                </span>
            </p>
            <p class="texto" style="margin-left: 10%">
                <span style="font-size: 12px"><strong>10.3.1</strong> Correro, ainda, por conta do <strong>PROMISSRIO COMPRADOR</strong>,
                    todas as despesas necessrias  obteno de documentos e certides pessoais e outras decorrentes da assinatura da escritura pblica de compra e venda.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>10.4</strong> O <strong>PROMISSRIO COMPRADOR</strong> se compromete em providenciar a
                    escritura definitiva no mesmo prazo indicado na <strong>Clusula 10.1 acima</strong>.
                    E, decorrido o referido prazo, poder o <strong>PROMITENTE VENDEDOR</strong> notificar o <strong>PROMISSRIO COMPRADOR</strong>,
                    atravs de carta com entrega comprovada, para receber a escritura definitiva de venda e compra no prazo de 30 (trinta) dias.
                    No sendo atendida neste prazo, o lote compromissado poder ser depositado judicialmente por conta e risco do <strong>PROMISSRIO COMPRADOR</strong>.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>10.5</strong> Competir ao <strong>PROMITENTE VENDEDOR</strong> a escolha do Tabelionato para a outorga da escritura.
                </span>
            </p>
        </div>
        <div>
            <p class="texto">
                <strong><u>CLUSULA DCIMA PRIMEIRA - CESSO DOS CRDITOS E CERTIFICADOS DE RECEBVEIS IMOBILIRIOS</u></strong>
                <br>
                <br>
                <span style="font-size: 12px"> 11.1 Nos termos do artigo 21 e 22, da Lei Federal n 10.931/2004,
                    fica reservado ao <strong>PROMITENTE VENDEDOR</strong> o direito de ceder a terceiros, no todo ou em parte,
                    os direitos creditrios decorrentes deste instrumento, independentemente de aviso ou concordncia do <strong>PROMISSRIO COMPRADOR</strong>,
                    substituindo todas as clusulas e condies deste instrumento em favor do cessionrio.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>11.2</strong> Nos termos do artigo 18 e seguintes, da Lei Federal n 10.931/2004,
                    os crditos ora constitudos podero ser securitizados, podendo tambm servir de lastro para a emisso de Cdula de Crdito Imobilirio (CCI) e Certificados de Recebveis (CRI),
                    consoante o disposto nas Leis n 9.514/1997 e n 10.931/2004.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>11.3</strong> De acordo com a previso contida no Pargrafo Terceiro,
                    do artigo 18, da Lei n 10.931/2004, em razo da cesso de crditos acima tratada, o <strong>PROMISSRIO COMPRADOR</strong>,
                    neste ato, autoriza expressamente que o <strong>PROMITENTE VENDEDOR</strong> transfira os seus direitos creditrios e a posse indireta que exercem sobre o imvel,
                    bem como o direito de retomada destes no caso de inadimplemento contratual do <strong>PROMISSRIO COMPRADOR</strong>, para garantia ao investidor,
                    no caso de securitizao de crditos, mantidas todas as demais condies previstas neste instrumento.
                </span>
            </p>
        </div>
        <div>
            <p class="texto">
                <strong><u>CLUSULA DCIMA SEGUNDA - MANDATO</u></strong>
                <br>
                <br>
                <span style="font-size: 12px"><strong>12.1</strong> O <strong>PROMISSRIO COMPRADOR</strong>, desde j, nomeia e constitui o <strong>PROMITENTE VENDEDOR</strong> sua bastante procuradora,
                    para fim especial de, se e quando necessrio, represent-la perante quaisquer Reparties Pblicas Federais, Estaduais e Municipais,
                    Autarquias e Sociedades de Economia Mista ou Paraestatais, Oficial de Registro de Imveis, e, enfim, perante todos os rgos pertinentes,
                    para tratar de assuntos relacionados ao lote onde se situa(m) o ora prometido, podendo, para tal fim, assinar quaisquer requerimentos,
                    documentos e tudo o mais que se faa necessrio, inclusive requerendo, perante o Oficial de Registros de Imveis competente,
                    o registro de eventuais alteraes no Memorial de Loteamento.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>12.2</strong> Nomeia-se procuradora, tambm, para estabelecer servides que reputem necessrias, sobre o <strong>RESIDENCIAL ALTO DA LAGOA</strong>.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>12.3</strong> Ainda pelo presente contrato, caso haja mais de um adquirente,
                    ficam eles solidariamente responsveis pelo cumprimento de todas as obrigaes decorrentes deste negcio,
                    bem como se nomeiam e se constituem procuradores um do outro com poderes para receber citaes inicial, confessar,
                    reconhecer a procedncia do pedido, transigir, desistir, renunciar, ao direito sobre o qual se funda a ao, receber,
                    dar quitao e firmar compromisso.
                </span>
            </p>
        </div>
        <div>
            <p class="texto">
                <strong><u>CLUSULA DCIMA TERCEIRA - DISPOSIES GERAIS</u></strong>
                <br>
                <br>
                <span style="font-size: 12px"><strong>13.1</strong> O <strong>PROMISSRIO COMPRADOR</strong> concorda com a contratao do seguro de vida e invalidez permanente (MIP),
                    sendo que o referido seguro (MIP) somente ter validade aps o incio do respectivo pagamento, este a exclusivo critrio do <strong>PROMITENTE VENDEDOR</strong>.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>13.2</strong> O pagamento pelos servios de intermediao do presente negcio (corretagem) no integra o preo do lote mencionado neste instrumento.
                    O valor para o pagamento dos referidos servios ser destinado diretamente  empresa responsvel pela intermediao imobiliria e/ou seus corretores autnomos,
                    partes legitimas para discusso de qualquer servio de corretagem.
                </span>
            </p>
            <p class="texto" style="margin-left: 10%">
                <span style="font-size: 12px"><strong>13.2.1</strong> O valor de tais servios no integra o preo em nenhuma hiptese,
                    no sendo objeto de devoluo, mesmo na hiptese de resciso contratual, independentemente do motivo.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>13.3</strong> A localizao dos equipamentos urbanos,
                    comunitrios e dos servios pblicos ou de utilidade pblica, descritas no material de divulgao,
                     meramente ilustrativa, podendo ser alterada de acordo com as necessidades do projeto e/ou determinaes dos rgos governamentais competentes,
                    independentemente de autorizao do <strong>PROMISSRIO COMPRADOR</strong>,  que se declara, neste ato, ciente e concorde com as possveis alteraes.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>13.4</strong> O <strong>PROMISSRIO COMPRADOR</strong> declara, sob as penas e na forma da lei, que as usas informaes cadastrais so verdicas,
                    bem como se compromete a informar toda e qualquer mudana de endereo, sob pena d incorrer nas sanes previstas neste instrumento.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>13.5</strong>  obrigao do <strong>PROMISSRIO COMPRADOR</strong> obter, diretamente na sede da imobiliria administradora ou, na falta desta,
                    no escritrio do PROMITENTE VENDEDOR, at as datas aprazadas para vencimento das prestaes, os respectivos boletos bancrios,
                    no podendo, por conseguinte, alegar o no recebimento destes ou de qualquer outra comunicao como justificativa para atraso nos pagamentos devidos
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>13.6</strong> O <strong>PROMITENTE VENDEDOR</strong> poder, a qualquer tempo e a seu exclusivo critrio, ceder e transferir os direitos e obrigaes que lhe digam respeito,
                    decorrentes deste instrumento, independentemente de qualquer anuncia, interferncia ou participao do <strong>PROMISSRIO COMPRADOR</strong>,  mantendo,
                    o <strong>PROMISSRIO COMPRADOR</strong> a obrigao a respeitar todas as condies aqui ajustadas.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>13.7</strong> O No caso de registro deste Compromisso,
                        o <strong>PROMISSRIO COMPRADOR</strong> arcar com todos os custos decorrentes do referido ato.
                        As partes autorizam o Sr. Oficial do Cartrio de registro de Imveis da Comarca de situao do lote objeto deste contrato,
                        a proceder ao registro do presente, podendo fazer todas as averbaes e anotaes legais.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>13.8</strong> O presente contrato  celebrado em carter irretratvel e irrevogvel,
                    obrigando-se as partes por si, seus herdeiros e sucessores,
                    vedado o arrependimento e admitida a sua resciso apenas nos casos previstos em lei e neste instrumento.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>13.9</strong> As partes declaram, sob as penas da lei, que esto celebrando o presente negcio jurdico sem qualquer induzimento ou coao,
                    inexistindo, tambm quanto a elas contratantes, qualquer fato que possa ser configurado como estado de perigo ou necessidade, ou ainda,
                    inexperincia na administrao de seus negcios ou na assuno de obrigaes, civis, declarando igualmente as partes,
                    terem conhecimento das caractersticas do imvel objeto deste contrato, notadamente aquelas necessrias  sua avaliao e valor de mercado.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>13.10</strong> A tolerncia para com eventuais infraes cometidas pelo <strong>PROMISSRIO COMPRADOR</strong> ao presente contrato no constituir,
                    em hiptese alguma, renncia a quaisquer dos direitos ora conferidos s partes contratantes, nem modificao de qualquer dos direitos e obrigaes estipulados nesta avena ou novao,
                    devendo ser entendida como mera liberalidade.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>13.11</strong> O presente contrato torna sem efeito quaisquer outros impressos ou documentos eventualmente assinados,
                    destitudos assim, de fora probante ou efeito jurdico, no podendo ser invocados para eventual alterao do ora pactuado pelas partes.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>13.12</strong> O presente contrato  pactuado de livre e comum acordo entre as partes,
                    obrigando-se a cumpri-lo at o final, por si, seus herdeiros e sucessores.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>13.13</strong> Sempre que o <strong>PROMITENTE VENDEDOR</strong> tiver que adotar medidas judiciais provocadas pelo inadimplemento do <strong>PROMISSRIO COMPRADOR</strong>,
                    ou para fazer valer quaisquer dos direitos decorrentes deste contrato, ficar o <strong>PROMISSRIO COMPRADOR</strong> responsvel pelo pagamento de custas processuais,
                    despesas administrativas, multas especificadas neste contrato para cada caso e ainda honorrios advocatcios fixados em 10% (dez por cento) sobre o valor da causa.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>13.14</strong> O <strong>PROMISSRIO COMPRADOR</strong> obriga-se a comunicar a mudana de domiclio e informar o novo endereo no prazo de 05 (cinco) dias,
                    atravs de carta com protocolo de entrega enviada para o endereo do <strong>PROMITENTE VENDEDOR</strong>, que consta no incio deste contrato, sob pena de, em no o fazendo,
                    ser considerada como estando em local incerto e no sabido, sofrendo as consequncias judiciais de tal caracterizao.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>13.15</strong> O <strong>PROMITENTE VENDEDOR</strong> apresenta Certido Negativa de Dbitos do INSS e Certido Negativa de Dbitos Conjunta da Secretaria da Receita Federal
                    e da Procuradoria Geral da Fazenda Nacional, autorizadoras da presente alienao. Para fins de registro do presente instrumento,
                    ficam dispensadas pelas partes as demais certides forenses e de distribuidores judiciais, bem como a certido negativa de dbitos e impostos sobre o imvel.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"><strong>13.16</strong> O presente contrato  um ttulo extrajudicial, nos termos do disposto no artigo 585, inciso II do Cdigo do Processo Civil.
                </span>
            </p>
        </div>
        <div>
            <p class="texto">
                <strong><u>CLUSULA DCIMA QUARTA - FORO</u></strong>
                <br>
                <br>
                <span style="font-size: 12px"><strong>14.1</strong> Para dirimir quaisquer questes que direta ou indiretamente decorram deste contrato,
                    as partes elegem o foro da Comarca do Imvel, com renncia expressa a qualquer outro, por mais privilegiado que seja.
                </span>
            </p>
            <p class="texto">
                <span style="font-size: 12px"> E, por estarem assim justas e contratadas,
                    as partes assinam o presente contrato em 03(trs) vias de igual teor e forma,
                    mediante as testemunhas abaixo assinadas.
                </span>
            </p>
        </div>
        <div align="right">
            <p class="texto" align="right">
                <?= $cidadeEmpreedimento['nome'] . ", $dia de " . strtolower(Helper::getMes(str_pad($mes, 2, '0', STR_PAD_LEFT))) . " de $ano."; ?>
            </p>
        </div>

        <div style="margin-top:20px;" align="center">
            <!-- CLIENTES -->
            <?php if ($cliente): ?>
                ____________________________________________________________
                <p align="center">
                    <strong>
                        <?= $cliente['nm_pessoa'] ?><br>
                        <?= $cliente['nr_cpf'] . $cliente['nr_cnpj'] ?>
                    </strong>
                </p>
                <br>
                <?php if (($cliente['est_civil'] == 'CAS' || $cliente['est_civil'] == 'UNE') && $cliente['conjugeP']) : ?>
                    ____________________________________________________________
                    <p align="center">
                        <strong><?= $cliente['conjugeP']['nm_pessoa']?><br>Cnjuge</strong>
                    </p>
                <?php endif; ?>
                <br>
                <br>
            <?php endif; ?>
        </div>
        <div align="center">

            <!--OUTROS COMPRADORES-->
            <?php if ($outrosCompradores): ?>
                <?php foreach ($outrosCompradores as $comprador): ?>
                    ____________________________________________________________
                    <p align="center">
                        <strong><?= $comprador['nm_pessoa'] ?><br>
                            <?= $comprador['nr_cpf'] . $comprador['nr_cnpj'] ?>
                        </strong>
                    </p>
                    <br>
                    <?php if (($comprador['est_civil'] == 'CAS' || $cliente['est_civil'] == 'UNE') && $comprador['conjuge']) : ?>
                        ____________________________________________________________
                        <p align="center">
                            <strong>Cnjuge</strong>
                        </p>
                    <?php endif; ?>
                    <br>
                    <br>
                <?php endforeach ?>
            <?php endif ?>
        </div>
        <div align="center">

            <!-- VENDEDOR -->
            <?php if ($vendedores): ?>
                <?php foreach ($vendedores as $vendedor): ?>
                    ____________________________________________________________
                    <p align="center">
                        <strong><?= $vendedor['nm_pessoa'] ?><br>
                            <?= $vendedor['nr_cpf'] . $vendedor['nr_cnpj'] ?>
                        </strong>
                    </p>
                    <br>
                    <br>
                <?php endforeach ?>
            <?php endif ?>
        </div>  
        <div align="center">
            <!-- TESTEMUNHAS -->
            ________________________________________ 			
            ________________________________________
            <p align="center">
                <strong>
                    TESTEMUNHA 1 							
                    							 TESTEMUNHA 2
                </strong>
            </p>
            <br>
        </div>
    </div>
</page>



