<?php require_once 'layout/includes/header.php'; ?>
<?php require_once 'layout/includes/menu.php'; ?>
<?php
$listaEmpreendimento = $this->get('empreendimentos');
$listaCorretor = $this->get('corretores');
$listaLote = $this->get('lotes');
$listaBancos = $this->get('bancos');
$pessoa = $this->get('pessoa');
$pessoas_envolvidas = $this->get('pessoas_envolvidas');
$contrato = $this->get('contrato');
$itensContrato = $this->get('itensContrato');
$corretor = $this->get('corretor');
$banco = $this->get('banco');
$lista_assinaturas = $this->get('lista_assinaturas');
$dsIntermediacaoImobiliaria = 'A ttulo de intermediao imobiliria, o PROMITENTE VENDEDOR repassar ao INTERMEDIADOR acima descrito e qualificado a importncia correspondente a 5% (cinco por cento) do valor total deste contrato, referente s 6 (seis) primeiras parcelas mensais a serem pagas pelo PROMISSRIO COMPRADOR.';
if ($contrato['fl_gerado'] == '1'){
    $gerado = 'disabled';
    $nrProposta = 'enabled';
} 
else
    $gerado = '';
    $nrProposta = 'enabled';
?>
    <div class="content">
        <div class="page-heading">
            <?= $this->getHeader(); ?>
        </div>
        <div class="widget">
            <div class="widget-content padding">
                <!-- MENSAGENS -->
                <?= ($_GET["msg"] == "success") ? '<div class="alert alert-success alert-dismissable">Operao realizada com sucesso.</div>'
                    : (($_GET['exception'] != '') ? '<div class="alert alert-danger alert-dismissable">' . $_GET['exception'] . '</div>' : '');
                ?>
                <?php if (count($this->_helper->getMensagens()) > 0): ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?php foreach ($this->_helper->getMensagens() as $message): ?>
                            <?= $message ?><br>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                <form action="" method="POST" id="form">
                    <input type="hidden" id="contrato" value="<?= $_GET['id'] ?>">
                    <fieldset>
                        <legend>
                        Informaes do Contrato <?= $contrato['fl_aprovar_contrato'] == '0' ? '<span class="naoAprovado" style="color: red">(N&atilde;o Aprovado)</span>' : '' ?><span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                            <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                                <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                                    <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                                </svg>
                            </span>
                        </legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="id_empreendimento">
                                        Empreendimento:<span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2 empreendimento_contrato" <?= $gerado ?>
                                            required="required"
                                            id="id_empreendimento" name="empreendimento"
                                            data-placeholder="Escolha o empreendimento">
                                        <option value=""></option>
                                        <?php foreach ($listaEmpreendimento as $e): ?>
                                            <option maxParcelas="<?= $e['max_parcela']; ?>"  value="<?= $e['id']; ?>" <?= ($contrato['id_empreendimento'] == $e['id'])?'selected':''?>>
                                                <?= $e['nm_empreendimento']; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                    <input id="maxParcelas" type="hidden" value="0">
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="idIndice">
                                    ndice:<span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2" required="required" id="idIndice"
                                            name="idIndice" data-placeholder="Escolha o ndice">
                                        <option value=""></option>
                                        <?php foreach ($this->get('listaIndiceEmpreendimento') as $indiceEmpreendimento) :?>
                                            <option value="<?= $indiceEmpreendimento['id_indice_empreendimento']; ?>"
                                                <?= ($contrato['id_indice'] == $indiceEmpreendimento['id_indice_empreendimento'])?'selected':''?>>
                                                <?php $residuo = ($indiceEmpreendimento['fl_residuo'] == '1')?' - Com Resduo':' - Sem Resduo'; ?>
                                                <?php $caracterSoma = Helper::getNomePeriodo($indiceEmpreendimento['fl_periodo']) != ''?' +':'' ?>
                                                <?php $indiceAdc = ($indiceEmpreendimento['indice_adicional'] != '0')?$caracterSoma . str_replace('.',',',number_format($indiceEmpreendimento['indice_adicional'], 2)).'%':''?>
                                                <?= $indiceEmpreendimento['descricao'] . ' ' . Helper::getNomePeriodo($indiceEmpreendimento['fl_periodo']) . ' ' . $indiceAdc . ' ' . Helper::getNomePeriodo($indiceEmpreendimento['fl_periodo_adc']) . $residuo ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="id_contrato">
                                        Lote:<span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2 lotes" name="lote"
                                            id="id_contrato" <?= $gerado ?> data-placeholder="Escolha o lote"
                                            required="required">
                                        <option value=""></option>
                                        <?php foreach ($listaLote as $lote): ?>
                                            <option
                                                    value="<?= $lote['id']; ?>" <?php if ($lote['id'] == $contrato['id_lote']): ?> selected<?php endif; ?>><?= 'Quadra ' . $lote['quadra'] . ' - Lote ' . $lote['lote']; ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="id_banco">
                                        Banco:<span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2 bancos" name="banco" id="id_banco"
                                            data-placeholder="Escolha o banco" required="required">
                                        <option value=""></option>
                                        <?php
                                        if ($listaBancos) {
                                            foreach ($listaBancos as $banco) {
                                                //Realizado condi??o para listar apenas Bancos Ativos!!!!
                                                if (($banco['id'] != $contrato['id_banco']) && $banco['fl_ativo'] == 0) {
                                                    continue;
                                                }
                                                ?>
                                                <option
                                                        value="<?= $banco['id']; ?>" <?php if ($banco['id'] == $contrato['id_banco']): ?> selected<?php endif; ?>>
                                                    <?= $banco['nmBanco'] . ' Ag.: ' . $banco['agencia'] . '-' . $banco['agencia_dv'] . ' - Cc.: ' . $banco['conta_corrente'] . '-' . $banco['conta_corrente_dv']; ?>
                                                </option>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label for="idCliente" class="control-label">
                                        Comprador responsvel pagamento: <span class="text-danger" title="Este campo  obrigatrio.">*</span>
                                    </label>
                                    <select class="form-control select2BigData clientesContrato"
                                            data-placeholder="Nome do cliente" name="cliente"
                                            id="idCliente" <?= $gerado ?> required="required">
                                        <option value=""></option>
                                        <?php if (isset($pessoa)): ?>
                                            <option selected
                                                    value="<?= $pessoa['id'] ?>"><?= $pessoa['nm_pessoa'] ?></option>
                                        <?php endif; ?>
                                    </select>
                                </div>
                                <div class="form-group col-sm-3" id="participacaocomprador" <?= (!$pessoas_envolvidas)?'hidden':''?>>
                                    <label class="control-label" for="valor_participacao"> % de participao:<span class="require" style="color: red">*</span></label>
                                    <input type="text" class="form-control money participacao" id="participacao" <?= $gerado ?> 
                                    <?php if($pessoas_envolvidas):?>required="required" <?php endif;?>
                                           name="participacao" value="<?= $contrato['porcentagem_participacao_contrato']?>"
                                           placeholder="Digite o valor da participacao">
                                </div>
                            </div>
                        </div>

                        <!-- Outros compradores -->
                        <div class="row" id="rowOutrosPadrao"> 
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label for="outrosCompradores" class="control-label">Outros Compradores:
                                        <span class="text-danger" title="O cliente j? foi selecionado." id="msgCompradores" hidden="hidden">O cliente s pode ser selecionado uma vez.</span>
                                    </label>
                                    <select class="form-control clientesContrato" name="pessoas_envolvidas[]"
                                            id="outrosCompradores" <?= $gerado ?>>
                                        <option value=""></option>
                                        <?php if (isset($pessoas_envolvidas)): ?>
                                        <option selected
                                                value="<?= $pessoas_envolvidas['id'] ?>"><?= $pessoas_envolvidas['nm_pessoa'] ?></option>
                                        <?php endif; ?>
                                    </select>
                                </div>
                                <div class="form-group col-sm-3" >
                                    <label class="control-label" for="valor_participacaoOutros"> % de participao:</label>
                                    <input type="text" class="form-control money participacaoOutros" id="participacaoOutros" 
                                        name="participacaoOutros" value="<?= $pessoas_envolvidas['porcentagem_participacao_contrato']?>"
                                        placeholder="Digite o valor da participacao">
                                </div>
                                <div class="form-group col-sm-3">
                                    <br>
                                    <label class="control-label"></label>
                                    <span class="input-group-btn">
                                            <button class="btn btn-primary tipo_parcela_add" type="button" id="adicionarOutros"
                                                    data-toggle="tooltip" <?= $gerado ?> title="ADICIONAR">
                                        <span class="glyphicon glyphicon-plus-sign" aria-hidden="true">
                                            </button>
                                        </span>
                                </div>
                            </div>
                        </div>
                        <!-- Tabela de outros compradores -->
                        <div class="row" id="divTabelaIndices" <?= (!$pessoas_envolvidas)?'hidden':''?>>
                            <div class="col-sm-12">
                                <div class="col-sm-7 form-group">
                                    <div class="table-responsive">
                                        <table class="table  table-hover table-condensed order-column"
                                               cellspacing="0" width="100%">
                                            <thead>
                                            <tr>
                                                <th>Comprador</th>
                                                <th>% de participao</th>
                                                <th>Aes</th>
                                            </tr>
                                            </thead>
                                            <tbody id="tableIndices">
                                            <?php
                                            $contador = 1;
                                            foreach($pessoas_envolvidas as $pessoas):
                                                ?>
                                                <tr id="indice<?= $contador?>">
                                                    <td><?= $pessoas['nm_pessoa']?></td>
                                                    <td class="money"> <?= ($pessoas['porcentagem_participacao_contrato'])?$pessoas['porcentagem_participacao_contrato']:'0,00'?></td>
                                                    <td>
                                                        <div align="center" style="width: 100%;">
                                                            <button data-toggle="tooltip" title="REMOVER" class="btn btn-default btn-xs remIndice"  type="button" id="btnPessoa_<?= $pessoas['id']; ?>" value="<?= ($contrato['fl_gerado'] != 1)?$contador:''?>">
                                                                <i class="fa fa-times"></i>
                                                            </button>
                                                        </div>
                                                    </td>
                                                    <input type="hidden" name="listaIndices[]" class="listaIndices" value="<?= $contador . '_' .
                                                    $pessoas['nm_pessoa'] . '_' . str_replace('.',',',$pessoas['porcentagem_participacao_contrato']) . '_' .
                                                    $pessoas['id']?>" />
                                                </tr>
                                                <?php $contador++; endforeach; ?>
                                            <input type="hidden" name="contador" id="contador" value="<?= $contador ?>"/>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Corretor -->
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label for="idCorretor" class="control-label">Corretor: <span
                                                class="text-danger"
                                                title="Este campo  obrigatrio.">*</span></label>
                                    <select class="form-control select2 corretores" required="required"
                                            data-placeholder="Escolha o corretor" name="corretor" id="idCorretor">
                                        <?php foreach ($listaCorretor as $corretor) : ?>
                                            <option
                                                    value="<?= $corretor['id']; ?>"<?php if ($contrato['id_corretor'] == $corretor['id']): ?> selected<?php endif; ?>>
                                                <?= $corretor['nm_pessoa']; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label for="nrProposta" class="control-label">Nmero de proposta:</label>
                                    <input type="text" class="form-control" id="nrProposta"
                                           name="nrProposta" <?= $nrProposta ?>
                                           placeholder="Nmero da proposta."
                                           value="<?= $contrato['nr_proposta'] ?>">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label for="dsIntermediacaoImobiliaria" class="control-label">
                                    Intermediao imobiliria:
                                    </label>
                                    <textarea class="form-control" rows="4"
                                              placeholder="Descreva a intermediao" name="dsIntermediacaoImobiliaria"
                                              id="dsIntermediacaoImobiliaria"><?= isset($contrato['ds_intermediacao_imobiliaria']) ? $contrato['ds_intermediacao_imobiliaria'] : '' ?></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="data">Data:</label>
                                    <input type="text" class="form-control data datepicker-input" id="data"
                                           name="data"
                                           value="<?= isset($contrato['dt_contrato']) ? Helper::getDate($contrato['dt_contrato']) : date('d/m/Y'); ?>"/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="valor_desconto"> Desconto Por Parcela:</label>
                                    <input type="text" class="form-control money desconto_contrato" id="desconto"
                                           name="desconto" value="<?= $contrato['desconto']?>"
                                           placeholder="Digite o valor do desconto">
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                <label class="control-label">Forma de pagamento:</label><br>
                                <div class="checkbox">
                                    <?php
                                    $checkAV = ($contrato['fl_fm_pagamento'] == 'AV')?true:false;
                                    $checkPM = ($contrato['fl_fm_pagamento'] == 'PM')?true:false;
                                    $checkPC = (!$checkAV && !$checkPM)?true:false;
                                    ?>
                                    <label><input type="radio" name="tp_pagamento" id="tpParcelado" class="icheck" value="PC" <?= ($checkPC)?'checked':'' ?>/> Parcelado</label>
                                    <label><input type="radio" name="tp_pagamento" id="tpAVista" class="icheck" value="AV" <?= ($checkAV)?'checked':'' ?>/> A vista</label>
                                    <label><input type="radio" name="tp_pagamento" id="tpPermuta" class="icheck" value="PM" <?= ($checkPM)?'checked':'' ?>/> Permuta</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                <label class="control-label">Tipos de tabela de parcelamento:</label><br>
                                <div class="checkbox">
                                    <?php
                                    $checkPrice = ($contrato['vl_divida'] && $contrato['nr_meses_financiamento'] && $contrato['tx_juros'])?true:false;
                                    $checkSacoc = ($contrato['vl_divida_sacoc'] && $contrato['nr_meses_financiamento_sacoc'] && $contrato['tx_juros_sacoc'])?true:false;
                                    $checkNormal = (!$checkPrice && !$checkSacoc)?true:false;
                                    ?>
                                    <label><input type="radio" name="tp_parcelamento" id="tbNormal" class="icheck" value="N" <?= ($checkNormal)?'checked':'' ?>/> Tabela normal <strong>(SACOC)</strong></label>
                                    <label><input type="radio" name="tp_parcelamento" id="tbPrice" class="icheck" value="P" <?= ($checkPrice)?'checked':'' ?>/> Tabela Price</label>
                                    <!-- A Tabela Normal virou a SACOC, A Tabela SACOC N?o foi deletada porque no lugar dela vai vir a nova Tabela SAC -->
                                    <!-- <label><input type="radio" name="tp_parcelamento" id="tbSacoc" class="icheck"  value="S" <?= ($checkSacoc)?'checked':'' ?>/> Tabela SACOC</label><br> -->
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row hidden" id="tabelaDePreco">
                        <div class="col-sm-6">
                            <table class="table  table-hover table-condensed order-column" cellspacing="0" style="width:100%; vertical-align: middle;">
                                <thead id="TabelaVisualizarTabelaPrecos" class="tb-center">
                                <tr>
                                    <th colspan="10" id="TabelaVisualizarTabelaPrecosTitulo">-</th>
                                </tr>
                                <tr class="TabelaNormal">
                                    <th>Valor lote</th>
                                    <th>Valor sinal</th>
                                    <th>Valor parcela</th>
                                    <th>Valor intercalada</th>
                                    <th>Quant. intercaladas</th>
                                    <th>Data atualizao</th>                                    
                                </tr>
                                <tr class="TabelaPriceSacoc hidden">
                                    <th>Valor dvida</th>
                                    <th>Taxa juros</th>
                                    <th>Qtde meses</th>
                                    <th>Data atualizao</th>
                                </tr>                                
                                </thead>
                            </table>
                        </div>
                    </div>
                    <fieldset>
                        <div  id="tabPrice" <?= (!$checkPrice)?'hidden':'' ?>>
                            <legend>Tabela Price <span style="font-size: 10pt; color: red">(Ao preencher os trs campos o programa calcular o valor da parcela utilizando a formula Price)</span></legend>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-4">
                                        <label for="vlDivida" class="control-label">Valor da dvida: </label>
                                        <input type="text" class="form-control money calculaPrice"
                                               id="vlDivida" name="vlDivida" <?= $gerado ?>
                                               placeholder="Valor da dvida"
                                               value="<?= ($contrato['vl_divida'] > 0) ? (Helper::getMoney($contrato['vl_divida'])) : '' ?>">
                                    </div>
                                    <div class="form-group col-sm-2">
                                        <label for="qtMeses" class="control-label">Qtde. meses: </label>
                                        <input type="text" <?= $gerado ?>
                                               class="form-control soNumero calculaPrice"
                                               id="qtMeses" name="qtMeses"
                                               placeholder="Quantidade de meses"
                                               value="<?= $contrato['nr_meses_financiamento'] ?>">
                                    </div>
                                    <div class="form-group col-sm-2">
                                        <label for="txJuros" class="control-label">Taxa de juros: </label>
                                        <input type="text" <?= $gerado ?>
                                               class="form-control porcentagemPrice calculaPrice"
                                               id="txJuros" name="txJuros"
                                               placeholder="Taxa de juros"
                                               value="<?= ($contrato['tx_juros'] > 0) ? (Helper::getMoney($contrato['tx_juros'], 6)) : '' ?>">
                                    </div>
                                    <div class="form-group col-sm-12" style="margin-top: -15px">
                                        <small style="color: #a94442;" id="erroPrice"></small>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div  id="tabSacoc"  <?= (!$checkSacoc)?'hidden':'' ?>>
                            <legend>Tabela SACOC <span style="font-size: 10pt; color: red">(Ao preencher os trs campos o programa calcular o valor da parcela)</span></legend>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-4">
                                        <label for="vlrDivida" class="control-label">Valor da dvida: </label>
                                        <input type="text" class="form-control money calculaSacoc"
                                               id="vlrDivida" name="vlrDivida" <?= $gerado ?>
                                               placeholder="Valor da Dvida"
                                               value="<?= ($contrato['vl_divida_sacoc'] > 0) ? (Helper::getMoney($contrato['vl_divida_sacoc'])) : '' ?>">
                                    </div>
                                    <div class="form-group col-sm-2">
                                        <label for="qtdMeses" class="control-label">Qtde. meses: </label>
                                        <input type="text" <?= $gerado ?>
                                               class="form-control soNumero calculaSacoc"
                                               id="qtdMeses" name="qtdMeses"
                                               placeholder="Quantidade de meses"
                                               value="<?= $contrato['nr_meses_financiamento_sacoc'] ?>">
                                    </div>
                                    <div class="form-group col-sm-2">
                                        <label for="txsJuros" class="control-label">Taxa de juros: </label>
                                        <input type="text" <?= $gerado ?>
                                               class="form-control porcentagem calculaSacoc"
                                               id="txsJuros" name="txsJuros"
                                               placeholder="Taxa de juros"
                                               value="<?= ($contrato['tx_juros_sacoc'] > 0) ? (Helper::getMoney($contrato['tx_juros_sacoc'], 4)) : '' ?>">
                                    </div>
                                    <div class="form-group col-sm-12" style="margin-top: -15px">
                                        <small style="color: #a94442;" id="erroSacoc"></small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset id="parcelasNormais">
                        <div class="alert alert-danger alert-dismissable" style="display: none;">
                            Se for preenchido valores de parcelas normais o campo qtde.  obrigatrio.<br>
                        </div>
                        <legend>Parcelas Normais (Mensais)</legend>
                        <input type="hidden" id="nrNormalAdicional" value="<?= ($itensContrato['N'])?count($itensContrato['N']):'1' ?>">
                        <div class="row" id="rowNormalPadrao">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <label for="vlParcelaNormal" class="control-label">Valor: </label>
                                    <input type="text" class="form-control money calculaValores"
                                           id="vlParcelaNormal"
                                           name="vl_parcela" placeholder="Valor da parcela." <?= $gerado ?>
                                           value="<?= ($contrato['vl_parcela'] > 0) ? ($contrato['vl_parcela']) : '' ?>">
                                </div>
                                <div class="form-group col-sm-2">
                                    <label for="qtdParcelaNormal" class="control-label">Quantidade: </label>
                                    <input type="text"
                                           class="form-control soNumero quantidadeParcela calculaValores"
                                           id="qtdParcelaNormal" name="qtd_parcela"
                                           placeholder="Quantidade de parcelas." <?= $gerado ?>
                                           value="<?= $contrato['nr_parcela'] ?>">
                                </div>
                                <div class="form-group col-sm-2">
                                    <label for="dtParcelaNormal" class="control-label">Data: </label>
                                    <input type="text" class="form-control data datepicker-input"
                                           id="dtParcelaNormal"
                                           name="dt_primeira" placeholder="Data da parcela." <?= $gerado ?>
                                           value="<?= Helper::getDate($contrato['dt_primeira_parcela']) ?>">
                                    <small id="dtParcelaNormalMsg" style="display:none;" class="help-block">A data
                                        da 1 Parc. Normal tem que ser maior ou igual a data de contrato.
                                    </small>
                                </div>
                                <div class="form-group col-sm-2" style="display: inline-block">
                                    <br>
                                    <input style="vertical-align: middle" class="checkbox icheck" type="checkbox"
                                           id="fl_reajustavel_mensais" name="fl_reajustavel_mensais" <?= $gerado ?>
                                           value="1" <?= ($contrato['fl_reajustavel_mensais'] == '0') ? '' : 'checked' ?>>
                                    <label style="vertical-align: middle" for="fl_reajustavel_mensais"
                                           class="control-label">Reajustvel</label>
                                </div>
                                <div class="form-group col-sm-2">
                                    <label class="control-label" for="dt_reajuste_mensal">
                                        Data de Reajuste:
                                    </label>
                                    <input type="text" class="form-control data datepicker-input" id="dt_reajuste_mensal" placeholder="Data do reajuste."
                                        name="dt_reajuste_mensal"
                                        <?php if ($_GET['a'] == 'adicionar'): ?>
                                            value = ""
                                        <?php elseif(isset($contrato['dt_reajuste_mensal'])) : ?>
                                            value = "<?= Helper::getDate($contrato['dt_reajuste_mensal']); ?>"
                                        <?php else : ?>
                                            value = ""
                                        <?php endif;?> />
                                </div>
                                <div class="form-group col-sm-2">
                                    <label class="control-label"></label>
                                    <span class="input-group-btn">
                                            <button class="btn btn-primary tipo_parcela_add" type="button" id="adicionarNormal"
                                                    data-toggle="tooltip" <?= $gerado ?> title="ADICIONAR">
                                        <span class="glyphicon glyphicon-plus-sign" aria-hidden="true">
                                            </button>
                                            <button class="btn btn-danger" type="button" id="removerNormal"
                                                    data-toggle="tooltip" <?= $gerado ?> title="REMOVER">
                                                <span class="glyphicon glyphicon-remove-circle" aria-hidden="true">
                                            </button>
                                        </span>
                                </div>
                            </div>
                        </div>
                        <!--Campo Novo-->
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label">Utilizar desconto at vencimento?</label><br>
                                    <div class="checkbox">
                                        <label><input type="radio" name="desconto_tp_normal" id="normal_sem_desconto" class="icheck" value='S' <?= ($contrato['fl_desc_normal'] == 'S' || $contrato['fl_desc_normal'] != 'P' || $contrato['fl_desc_normal'] != 'V') ? 'checked' : '' ?>/> Sem desconto</label>
                                        <label><input type="radio" name="desconto_tp_normal" id="normal_em_porcentagem" class="icheck" value='P' <?= ($contrato['fl_desc_normal'] == 'P') ? 'checked' : '' ?>/> Em porcentagem (%)</label>
                                        <label><input type="radio" name="desconto_tp_normal" id="normal_em_valor" class="icheck"  value='V' <?= ($contrato['fl_desc_normal'] == 'V') ? 'checked' : '' ?>/> Em valor (R$)</label><br>
                                        <input type="hidden" id="flNormalCheckbox" value="<?= $contrato['fl_desc_normal']; ?>">
                                    </div>
                                </div>
                                <div class="form-group col-sm-3" <?= ($contrato['fl_desc_normal'] == 'S') ? 'hidden' : '' ?> id="divDescNormal">
                                    <label class="control-label" for="valor_desconto_normal"  id="spanDescNormal">
                                        Desconto <?= ($contrato['fl_desc_normal'] == 'V' || $contrato['fl_desc_normal'] == '') ? '(R$)' : '(%)' ?>
                                    </label>
                                    <input type="text" id="inputNormal" class="form-control money"
                                           name="valor_desconto_normal"
                                           placeholder="Valor do desconto"
                                           value="<?= $contrato['vl_desc_normal'] ?>">
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label">Frequncia:</label><br>
                                    <div class="checkbox">
                                        <label><input <?= $gerado ?> type="radio" name="fl_frequencia" id="fl_frequencia" class="icheck" value='M' <?= ($contrato['fl_frequencia'] == 'M' || !$contrato['fl_frequencia']) ? 'checked' : '' ?> /> Mensal</label>
                                        <label><input <?= $gerado ?> type="radio" name="fl_frequencia" id="fl_frequencia" class="icheck" value='S' <?= ($contrato['fl_frequencia'] == 'S') ? 'checked' : '' ?>/> Semanal</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--Campo Novo-->
                        <?php if (is_array($itensContrato['N'])) : ?>
                            <?php foreach ($itensContrato['N'] as $k => $adicionalNormal) : ?>
                                <div class="row" id="lineNormal_<?= $k + 1 ?>">
                                    <div class="col-sm-12">
                                        <div class="form-group col-sm-4">
                                            <label for="vlNormalAdicional" class="control-label">Valor: </label>
                                            <input type="text" class="form-control money adicionais calculaValores"
                                                   id="vlNormalAdicional_<?= $k + 1 ?>" <?= $gerado ?>
                                                   name="vl_parcela_adicional[]" placeholder="Valor da parcela."
                                                   value="<?= Helper::getMoney($adicionalNormal['vl_parcela']) ?>">
                                            <small data-bv-validator-for="vlNormalAdicional_<?= $k + 1 ?>"
                                                   class="help-block"
                                                   style="display: none;">
                                            </small>
                                        </div>
                                        <div class="form-group col-sm-3">
                                            <label for="qtNormalAdicional" class="control-label">Quantidade: </label>
                                            <input type="text"
                                                   class="form-control soNumero quantidadeParcela calculaValores"
                                                   id="qtNormalAdicional_<?= $k + 1 ?>" <?= $gerado ?>
                                                   name="qtd_parcela_adicional[]"
                                                   placeholder="Quantidade de parcelas."
                                                   value="<?= ($adicionalNormal['qt_parcelas']) ?>">
                                            <small data-bv-validator-for="qtNormalAdicional_<?= $k + 1 ?>"
                                                   class="help-block"
                                                   style="display: none;">
                                            </small>
                                        </div>
                                        <div class="form-group col-sm-2" style="display: inline-block">
                                            <br>
                                            <input type="checkbox" style="vertical-align: middle"
                                                   class="checkbox icheck"
                                                   id="reajustavelNormalAdicional_<?= $k + 1 ?>" <?= $gerado ?>
                                                   name="reajustavel_parcela[]" <?= ($adicionalNormal['fl_reajustavel'] == '1') ? 'checked' : '' ?>>
                                            <label for="reajustavelNormalAdicional_<?= $k + 1 ?>"
                                                   class="control-label">Reajustvel</label>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        <div class="row hide" id="rowNormal">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-4">
                                    <label for="vlNormalAdicional" class="control-label">Valor: </label>
                                    <input type="text" class="form-control money" id="vlNormalAdicional_0"
                                           name="vl_parcela_adicional[]" placeholder="Valor da parcela.">
                                    <small data-bv-validator-for="vlNormalAdicional_0" class="help-block"
                                           style="display: none;">
                                    </small>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label for="qtNormalAdicional" class="control-label">Quantidade: </label>
                                    <input type="text" class="form-control quantidadeParcela soNumero"
                                           id="qtNormalAdicional_0"
                                           name="qtd_parcela_adicional[]" placeholder="Quantidade de parcelas.">
                                    <small data-bv-validator-for="qtNormalAdicional_0" class="help-block"
                                           style="display: none;">b
                                    </small>
                                </div>
                                <div class="form-group col-sm-2" style="display: inline-block">
                                    <br>
                                    <input type="checkbox" style="vertical-align: middle" class="checkbox icheck"
                                           id="reajustavelNormalAdicional_0" <?= $gerado ?>
                                           name="reajustavel_parcela[]">
                                    <label for="reajustavelNormalAdicional_0"
                                           class="control-label">Reajustvel</label>
                                </div>
                            </div>
                        </div>
                    </fieldset>

                    <fieldset>
                        <legend>Parcelas Sinais</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-4">
                                    <label for="vlSinal" class="control-label">Valor: </label>
                                    <input type="text" class="form-control money calculaValores" id="vlSinal"
                                           name="vlSinal" placeholder="Valor da parc. sinal." <?= $gerado ?>
                                           value="<?= ($contrato['vl_sinal'] > 0) ? ($contrato['vl_sinal']) : '' ?>">
                                </div>
                                <div class="form-group col-sm-4">
                                    <label for="qtdSinal" class="control-label">Quantidade: </label>
                                    <select class="form-control select2 calculaValores" name="qtdSinal"
                                            id="qtdSinal" data-placeholder="Escolha a qtde. das parc. sinais" <?= $gerado ?>>
                                        <option value=""></option>
                                        <?php for ($i = 1; $i <= 100; $i++): ?>
                                            <option value="<?= $i; ?>" <?= ($contrato['nr_parcela_sinal'] == $i) ? 'selected' : '' ?>>
                                                <?= $i; ?>
                                            </option>
                                        <?php endfor; ?>
                                    </select>
                                </div>
                                <div class="form-group col-sm-4">
                                    <label for="flIncluirContratoSinal" class="control-label">Incluir no contrato a
                                        Parc. sinal?</label><br>
                                    <label for="flIncluirContratoSinalSim" class="control-label"
                                           style="padding-top: 8px;">
                                        Sim: <input type="radio" id="flIncluirContratoSinalSim"
                                                    name="incluiSinalContrato" value="1"
                                            <?= ($contrato['inclui_sinal_contrato'] == 1) ? 'checked' : '' ?>
                                    </label>
                                    <label for="flIncluirContratoSinalNao" class="control-label">
                                    No: <input type="radio" id="flIncluirContratoSinalNao"
                                                    name="incluiSinalContrato" value="0"
                                            <?= ($contrato['inclui_sinal_contrato']  != 1) ? 'checked' : '' ?>
                                    </label>
                                </div>
                                <!--Novo Campo-->
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group col-sm-6">
                                            <label class="control-label">Utilizar desconto at vencimento?</label><br>
                                            <div class="checkbox">
                                                <label><input type="radio" name="desconto_tp_sinal" id="sinal_sem_desconto" class="icheck" value='S' <?= ($contrato['fl_desc_sinal'] == 'S' || $contrato['fl_desc_sinal'] != 'P' || $contrato['fl_desc_sinal'] != 'V') ? 'checked' : '' ?>/> Sem Desconto</label>
                                                <label><input type="radio" name="desconto_tp_sinal" id="sinal_em_porcentagem" class="icheck" value='P' <?= ($contrato['fl_desc_sinal'] == 'P') ? 'checked' : '' ?>/> Em porcentagem (%)</label>
                                                <label><input type="radio" name="desconto_tp_sinal" id="sinal_em_valor" class="icheck"  value='V' <?= ($contrato['fl_desc_sinal'] == 'V') ? 'checked' : '' ?>/> Em valor(R$)</label><br>
                                                <input type="hidden" id="flSinalCheckbox" value="<?= $contrato['fl_desc_sinal']; ?>">
                                            </div>
                                        </div>
                                        <div class="form-group col-sm-3" <?= ($contrato['fl_desc_sinal'] == 'S') ? 'hidden' : '' ?>  id="divDescSinal">
                                            <label class="control-label" for="valor_desconto_sinal" id="spanDescSinal">
                                                Desconto <?= ($contrato['fl_desc_sinal'] == 'V' || $contrato['fl_desc_sinal'] == '') ? '(R$)' : '(%)' ?>
                                            </label>
                                            <input type="text" id="inputSinal" class="form-control money"
                                                   name="valor_desconto_sinal"
                                                   placeholder="Valor do desconto"
                                                   value="<?= $contrato['vl_desc_sinal'] ?>">
                                        </div>
                                    </div>
                                </div>
                                <!--Novo Campo-->
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-12" id="TabelaParcSinalDiv">
                                    <div class="table-responsive">
                                        <small id="TabelaParcSinalMsg" style="display:none;" class="help-block">A soma dos
                                            valores de todas parcelas difere do valor total das parcelas sinais.
                                            <label id="valorTotalSinal"></label>
                                        </small>
                                        <small id="TabelaParcSinalMsg2" style="display:none;" class="help-block">As datas de
                                            todas parcelas devem ser preenchidas.
                                        </small>
                                        <table data-sortable class="table  table-hover
                                            table-condensed" id="tabelaParcSinais" <?= ($contrato['nr_parcela_sinal'] == 0) ? 'style="display:none;"' : '' ?>>
                                            <thead>
                                            <tr>
                                                <th>Parcela</th>
                                                <th data-sortable="false">Valor</th>
                                                <th data-sortable="false">Vencimento</th>
                                            </tr>
                                            </thead>

                                            <tbody>
                                            <?php if (isset($contrato['sinal'])) : ?>
                                                <?php foreach ($contrato['sinal'] as $sinal): ?>
                                                    <tr style="width: 100%">
                                                        <td align="center"><?= $sinal['parcela'] ?></td>
                                                        <td width="70%">
                                                            <div class="input-group" style="width: 100%">
                                                                <input type="text"
                                                                       class="form-control money camposValorParcSinal"
                                                                       name="vl_sinal[]" <?= $gerado ?>
                                                                       id="valor_<?= $sinal['parcela'] ?>"
                                                                       onBlur="verificaValor();"
                                                                       value="<?= Helper::getMoney($sinal['valor']); ?>"/>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <input type="text"
                                                                   class="form-control data datepicker-input camposDataParcSinal"
                                                                   style="width:200px;"
                                                                   name="dt_sinal[]" <?= $gerado ?>
                                                                   id="dt_<?= $sinal['parcela'] ?>"
                                                                   value="<?= Helper::getDate($sinal['dtVencimento']) ?>"
                                                            />
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </fieldset>

                    <fieldset>
                        <legend>Parcelas Intercaladas</legend>
                        <input type="hidden" id="nrIntercaladaAdicional" value="<?= ($itensContrato['I'])?count($itensContrato['I']):'1' ?>">

                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <label for="vlIntercalada" class="control-label">Valor: </label>
                                    <input type="text" class="form-control money calculaValores" id="vlIntercalada"
                                           name="intercalada"
                                           placeholder="Valor da parc. intercalada." <?= $gerado ?>
                                           value="<?= ($contrato['vl_intercalada'] > 0) ? ($contrato['vl_intercalada']) : '' ?>">
                                </div>
                                <div class="form-group col-sm-2">
                                    <label for="qtdIntercalada" class="control-label">Quantidade: </label>
                                    <input type="text" class="form-control soNumero calculaValores"
                                           id="qtdIntercalada"
                                           name="qtd_parcela_intercalada" <?= $gerado ?>
                                           placeholder="Quantidade de parc. intercalada."
                                           value="<?= ($contrato['nr_intercalada'] > 0) ? $contrato['nr_intercalada'] : '' ?>">
                                </div>
                                <div class="form-group col-sm-2">
                                    <label for="nrFrequencia" class="control-label">Frequncia: </label>
                                    <input type="text" class="form-control soNumero" id="nrFrequencia"
                                           name="frequencia"
                                           placeholder="Frequncia." <?= $gerado ?>
                                           value="<?= ($contrato['fr_intercalada'] > 0) ? $contrato['fr_intercalada'] : '' ?>">
                                </div>
                                <div class="form-group col-sm-2" style="display: inline-block">
                                    <br>
                                    <input type="checkbox" style="vertical-align: middle" class="checkbox icheck"
                                           id="fl_reajustavel_intercaladas"
                                           name="fl_reajustavel_intercaladas" <?= $gerado ?>
                                        <?= (isset($contrato['fl_reajustavel_intercaladas']) && $contrato['fl_reajustavel_intercaladas'] == 0) ? '' : 'checked' ?>/>
                                    <label for="fl_reajustavel_intercaladas"
                                           class="control-label">Reajustvel</label>
                                </div>
                                <div class="form-group col-sm-2">
                                    <label class="control-label" for="dt_reajuste_intercalada">
                                        Data de Reajuste:
                                    </label>
                                    <input type="text" class="form-control data datepicker-input" id="dt_reajuste_intercalada" placeholder="Data do reajuste."
                                        name="dt_reajuste_intercalada"
                                        <?php if ($_GET['a'] == 'adicionar'): ?>
                                            value = ""
                                        <?php elseif(isset($contrato['dt_reajuste_intercalada'])) : ?>
                                            value = "<?= Helper::getDate($contrato['dt_reajuste_intercalada']); ?>"
                                        <?php else : ?>
                                            value = ""
                                        <?php endif;?> />
                                </div>
                                <div class="form-group col-sm-2">
                                    <label class="control-label"></label>
                                    <span class="input-group-btn">
                                            <button class="btn btn-primary" type="button" id="adicionarIntercalada" data-toggle="tooltip"
                                                    title="ADICIONAR" <?= $gerado ?>>
                                                <span class="glyphicon glyphicon-plus-sign" aria-hidden="true"></span>
                                            </button>
                                        <button class="btn btn-danger" type="button" id="removerIntercalada" data-toggle="tooltip"
                                                title="REMOVER" <?= $gerado ?>>
                                            <span class="glyphicon glyphicon-remove-circle" aria-hidden="true"></span>
                                        </button>
                                        </span>
                                </div>
                                <!--Campo Novo-->
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group col-sm-6">
                                            <label class="control-label">Utilizar desconto at vencimento?</label><br>
                                            <div class="checkbox">
                                                <label><input type="radio" name="desconto_tp_intercalada" id="intercalada_sem_desconto" class="icheck" value='S' <?= ($contrato['fl_desc_intercalada'] == 'S' || $contrato['fl_desc_intercalada'] != 'P'|| $contrato['fl_desc_intercalada'] != 'V') ? 'checked' : '' ?>/> Sem Desconto</label>
                                                <label><input type="radio" name="desconto_tp_intercalada" id="intercalada_em_porcentagem" class="icheck" value='P' <?= ($contrato['fl_desc_intercalada'] == 'P') ? 'checked' : '' ?>/> Em porcentagem (%)</label>
                                                <label><input type="radio" name="desconto_tp_intercalada" id="intercalada_em_valor" class="icheck"  value='V' <?= ($contrato['fl_desc_intercalada'] == 'V') ? 'checked' : '' ?>/> Em valor(R$)</label><br>
                                                <input type="hidden" id="flIntercaladaCheckbox" value="<?= $contrato['fl_desc_intercalada']; ?>">
                                            </div>
                                        </div>
                                        <div class="form-group col-sm-3" <?= ($contrato['fl_desc_intercalada'] == 'S') ? 'hidden' : '' ?> id="divDescIntercalada">
                                            <label class="control-label" for="valor_desconto_intercalada" id="spanDescIntercalada">
                                                Desconto <?= ($contrato['fl_desc_intercalada'] == 'V' || $contrato['fl_desc_intercalada'] == '') ? '(R$)' : '(%)' ?>
                                            </label>
                                            <input type="text"  id="inputIntercalada" class="form-control money"
                                                   name="valor_desconto_intercalada"
                                                   placeholder="Valor do desconto"
                                                   value="<?= $contrato['vl_desc_intercalada'] ?>">
                                        </div>
                                    </div>
                                </div>
                                <!--Campo Novo-->
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-4">
                                    <label for="dtIntercalada" class="control-label">Data: </label>
                                    <input type="text" class="form-control data datepicker-input" id="dtIntercalada"
                                           name="data_intercalada"
                                           placeholder="Data da 1 parc. intercalada." <?= $gerado ?>
                                           value="<?= ($contrato['dt_intercalada'] > 0) ? Helper::getDate($contrato['dt_intercalada']) : '' ?>">
                                    <small id="dtIntercaladaMsg" style="display:none;" class="help-block"></small>
                                </div>
                                <div class="form-group col-sm-4">
                                    <label for="flCoincidirIntercaladas" class="control-label">Coincidir
                                        intercaladas
                                        com parc. mensais?</label><br>
                                    <label for="flCoincidirIntercaladasSim" class="control-label"
                                           style="padding-top: 8px;">
                                        Sim: <input type="radio" id="flCoincidirIntercaladasSim"
                                                    name="coincidir" <?= $gerado ?>
                                                    value="1" <?= (isset($contrato['fl_coinc_intercalada']) && $contrato['fl_coinc_intercalada'] == 0) ? '' : 'checked' ?>/>
                                    </label>
                                    <label for="flCoincidirIntercaladasNao" class="control-label">
                                    N&atilde;o: <input type="radio" id="flCoincidirIntercaladasNao"
                                                    name="coincidir" <?= $gerado ?>
                                                    value="0" <?= (isset($contrato['fl_coinc_intercalada']) && $contrato['fl_coinc_intercalada'] == 0) ? 'checked' : '' ?>/>
                                    </label>
                                </div>
                            </div>
                        </div>
                        <?php if (is_array($itensContrato['I'])) : ?>
                            <?php foreach ($itensContrato['I'] as $k => $adicional) : ?>
                                <div class="row" id="lineIntercalada_<?= $k + 1 ?>">
                                    <div class="col-sm-12">
                                        <div class="form-group col-sm-3">
                                            <label for="vlIntercaladaAdicional" class="control-label">Valor: </label>
                                            <input type="text" class="form-control money adicionais calculaValores"
                                                   id="vlIntercaladaAdicional_<?= $k + 1 ?>" <?= $gerado ?>
                                                   name="vl_intercalada_adicional[]" placeholder="Valor da parcela."
                                                   value="<?= Helper::getMoney($adicional['vl_parcela']) ?>">
                                            <small data-bv-validator-for="vlIntercaladaAdicional_<?= $k + 1 ?>"
                                                   class="help-block"
                                                   style="display: none;"></small>
                                        </div>
                                        <div class="form-group col-sm-2">
                                            <label for="qtIntercaladaAdicional" class="control-label">Quantidade: </label>
                                            <input type="text" class="form-control soNumero calculaValores"
                                                   id="qtIntercaladaAdicional_<?= $k + 1 ?>" <?= $gerado ?>
                                                   name="qtd_intercalada_adicional[]"
                                                   placeholder="Quantidade de parcelas."
                                                   value="<?= $adicional['qt_parcelas'] ?>">
                                            <small data-bv-validator-for="qtIntercaladaAdicional_<?= $k + 1 ?>"
                                                   class="help-block"
                                                   style="display: none;"></small>
                                        </div>
                                        <div class="form-group col-sm-2">
                                            <label for="nrIntercaladaAdicional" class="control-label">Frequncia: </label>
                                            <input type="text" class="form-control soNumero"
                                                   id="nrIntercaladaAdicional_<?= $k + 1 ?>"
                                                   name="fr_intercalada_adicional[]"
                                                   placeholder="Frequncia." <?= $gerado ?>
                                                   value="<?= $adicional['nr_frequencia'] ?>">
                                            <small data-bv-validator-for="nrIntercaladaAdicional_<?= $k + 1 ?>"
                                                   class="help-block"
                                                   style="display: none;"></small>
                                        </div>
                                        <div class="form-group col-sm-2">
                                            <label for="dtIntercaladaAdicional" class="control-label">Data: </label>
                                            <input type="text" class="form-control data datepicker-input"
                                                   id="dtIntercaladaAdicional_<?= $k + 1 ?>" <?= $gerado ?>
                                                   name="dt_intercalada_adicional[]"
                                                   placeholder="Data da 1 parc. intercalada."
                                                   value="<?= Helper::getDate($adicional['dt_parcela']) ?>">
                                            <small data-bv-validator-for="dtIntercaladaAdicional_<?= $k + 1 ?>"
                                                   class="help-block"
                                                   style="display: none;"></small>
                                        </div>
                                        <div class="form-group col-sm-2" style="display: inline-block">
                                            <br>
                                            <input type="checkbox" style="vertical-align: middle"
                                                   class="checkbox icheck"
                                                   id="reajustavelIntercaladaAdicional_<?= $k + 1 ?>" <?= $gerado ?>
                                                   name="reajustavel_intercalada[]" <?= ($adicional['fl_reajustavel'] == '0') ? '' : 'checked' ?>>
                                            <label for="reajustavelIntercaladaAdicional_<?= $k + 1 ?>"
                                                   class="control-label">Reajustvel</label>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        <div class="row hide" id="rowIntercalada">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label for="vlIntercaladaAdicional" class="control-label">Valor: </label>
                                    <input type="text" class="form-control money" id="vlIntercaladaAdicional_0"
                                           name="vl_intercalada_adicional[]" placeholder="Valor da parcela.">
                                    <small data-bv-validator-for="vlIntercaladaAdicional_0" class="help-block"
                                           style="display: none;"></small>
                                </div>
                                <div class="form-group col-sm-2">
                                    <label for="qtIntercaladaAdicional" class="control-label">Quantidade: </label>
                                    <input type="text" class="form-control soNumero" id="qtIntercaladaAdicional_0"
                                           name="qtd_intercalada_adicional[]" placeholder="Quantidade de parcelas.">
                                    <small data-bv-validator-for="qtIntercaladaAdicional_0" class="help-block"
                                           style="display: none;"></small>
                                </div>
                                <div class="form-group col-sm-2">
                                    <label for="nrIntercaladaAdicional" class="control-label">Frequncia: </label>
                                    <input type="text" class="form-control soNumero" id="nrIntercaladaAdicional_0"
                                           name="fr_intercalada_adicional[]"
                                           placeholder="Frequncia.">
                                    <small data-bv-validator-for="nrIntercaladaAdicional_0" class="help-block"
                                           style="display: none;"></small>
                                </div>
                                <div class="form-group col-sm-2">
                                    <label for="dtIntercaladaAdicional" class="control-label">Data: </label>
                                    <input type="text" class="form-control data datepicker-input"
                                           id="dtIntercaladaAdicional_0"
                                           name="dt_intercalada_adicional[]"
                                           placeholder="Data da 1 parc. intercalada.">
                                    <small data-bv-validator-for="dtIntercaladaAdicional_0" class="help-block"
                                           style="display: none;"></small>
                                </div>
                                <div class="form-group col-sm-2" style="display: inline-block">
                                    <br>
                                    <input type="checkbox" style="vertical-align: middle" class="checkbox icheck"
                                           id="reajustavelIntercaladaAdicional_0"
                                           name="repajustavel_intercalada[]"> <?= $gerado ?>
                                    <label for="reajustavelIntercaladaAdicional_0"
                                           class="control-label">Reajustvel</label>
                                </div>
                            </div>
                        </div>
                    </fieldset>

                    <fieldset>
                        <legend>Parcelas Chaves</legend>
                        <input type="hidden" id="nrChaveAdicional" value="<?= ($itensContrato['C'])?count($itensContrato['C']):'1' ?>">

                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <label for="vlChave" class="control-label">Valor: </label>
                                    <input type="text" class="form-control money calculaValores" id="vlChave"
                                           name="vl_chaves"
                                           placeholder="Valor da chave." <?= $gerado ?>
                                           value="<?= ($contrato['vl_parcela_entrega'] > 0) ? ($contrato['vl_parcela_entrega']) : '' ?>">
                                </div>
                                <div class="form-group col-sm-2">
                                    <label for="qtdParcChave" class="control-label">Quantidade: </label>
                                    <input type="text" class="form-control soNumero calculaValores"
                                           id="qtdParcChave"
                                           name="qtd_parcela_chaves" <?= $gerado ?>
                                           placeholder="Quantidade de parc. da chave."
                                           value="<?= ($contrato['nr_parcela_entrega'] > 0) ? ($contrato['nr_parcela_entrega']) : '' ?>">
                                    <small id="qtdParcChaveMsg" style="display:none;" class="help-block">A
                                        quantidade de
                                        parcela de chaves tem que ser menor ou igual a quantidade de parcela do
                                        valor
                                        normal.
                                    </small>
                                </div>
                                <div class="form-group col-sm-2">
                                    <label for="dtParcChave" class="control-label">Data: </label>
                                    <input type="text" class="form-control data datepicker-input" id="dtParcChave"
                                           name="dt_chaves"
                                           placeholder="Data da 1 parc. chave." <?= $gerado ?>
                                           value="<?= Helper::getDate($contrato['dt_parcela_entrega']) ?>">
                                </div>
                                <div class="form-group col-sm-2" style="display: inline-block">
                                    <br>
                                    <input type="checkbox" style="vertical-align: middle" class="checkbox icheck"
                                           id="fl_reajustavel_chaves" <?= $gerado ?>
                                           name="fl_reajustavel_chaves" <?= (isset($contrato['fl_reajustavel_chaves']) && $contrato['fl_reajustavel_chaves'] == 0) ? '' : 'checked' ?>/>
                                    <label for="fl_reajustavel_chaves" class="control-label">Reajustvel</label>
                                </div>
                                <div class="form-group col-sm-2">
                                    <label class="control-label" for="dt_reajuste_chave">
                                        Data de Reajuste:
                                    </label>
                                    <input type="text" class="form-control data datepicker-input" id="dt_reajuste_chave" placeholder="Data do reajuste."
                                        name="dt_reajuste_chave"
                                        <?php if ($_GET['a'] == 'adicionar'): ?>
                                            value = ""
                                        <?php elseif(isset($contrato['dt_reajuste_chave'])) : ?>
                                            value = "<?= Helper::getDate($contrato['dt_reajuste_chave']); ?>"
                                        <?php else : ?>
                                            value = ""
                                        <?php endif;?> />
                                </div>
                                <div class="form-group col-sm-2">
                                    <label class="control-label"></label>
                                    <span class="input-group-btn">
                                            <button class="btn btn-primary" type="button" id="adicionarChave" data-toggle="tooltip"
                                                    title="ADICIONAR" <?= $gerado ?>>
                                                <span class="glyphicon glyphicon-plus-sign" aria-hidden="true">
                                            </button>
                                            <button class="btn btn-danger" type="button" id="removerChave" data-toggle="tooltip"
                                                    title="REMOVER" <?= $gerado ?>>
                                            <span class="glyphicon glyphicon-remove-circle" aria-hidden="true">
                                            </button>
                                        </span>
                                </div>
                                <!--Campo novo-->
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group col-sm-6">
                                            <label class="control-label">Utilizar desconto at vencimento?</label><br>
                                            <div class="checkbox">
                                                <label><input type="radio" name="desconto_tp_chave" id="chave_sem_desconto" class="icheck" value='S' <?= ($contrato['fl_desc_chave'] == 'S' || $contrato['fl_desc_chave'] != 'P' || $contrato['fl_desc_chave'] != 'V') ? 'checked' : '' ?>/> Sem Desconto</label>
                                                <label><input type="radio" name="desconto_tp_chave" id="chave_em_porcentagem" class="icheck" value='P' <?= ($contrato['fl_desc_chave'] == 'P') ? 'checked' : '' ?>/> Em porcentagem (%)</label>
                                                <label><input type="radio" name="desconto_tp_chave" id="chave_em_valor" class="icheck"  value='V' <?= ($contrato['fl_desc_chave'] == 'V') ? 'checked' : '' ?>/> Em valor(R$)</label><br>
                                                <input type="hidden" id="flChaveCheckbox" value="<?= $contrato['fl_desc_chave']; ?>">
                                            </div>
                                        </div>
                                        <div class="form-group col-sm-3" <?= ($contrato['fl_desc_chave'] == 'S') ? 'hidden' : '' ?> id="divDescChave">
                                            <label class="control-label" for="valor_desconto_chave" id="spanDescChave">
                                                Desconto <?= ($contrato['fl_desc_chave'] == 'V' || $contrato['fl_desc_chave'] == '') ? '(R$)' : '(%)' ?>
                                            </label>
                                            <input type="text" id="inputChave" class="form-control money"
                                                   name="valor_desconto_chave"
                                                   placeholder="Valor do desconto"
                                                   value="<?= $contrato['vl_desc_chave'] ?>"
                                        </div>
                                    </div>
                                </div>
                                <!--Campo novo-->
                            </div>
                        </div>
                        <?php if (is_array($itensContrato['C'])) : ?>
                            <?php foreach ($itensContrato['C'] as $k => $adicional) : ?>
                                <div class="row" id="lineChave_<?= $k + 1 ?>">
                                    <div class="col-sm-12">
                                        <div class="form-group col-sm-4">
                                            <label for="vlChaveAdicional" class="control-label">Valor: </label>
                                            <input type="text" class="form-control money adicionais calculaValores"
                                                   id="vlChaveAdicional_<?= $k + 1 ?>" <?= $gerado ?>
                                                   name="vl_chave_adicional[]" placeholder="Valor da parcela."
                                                   value="<?= ($adicional['vl_parcela'] > 0) ? Helper::getMoney($adicional['vl_parcela']) : '' ?>">
                                            <small data-bv-validator-for="vlChaveAdicional_<?= $k + 1 ?>"
                                                   class="help-block"
                                                   style="display: none;">a
                                            </small>
                                        </div>
                                        <div class="form-group col-sm-3">
                                            <label for="qtChaveAdicional" class="control-label">Quantidade: </label>
                                            <input type="text" class="form-control soNumero calculaValores"
                                                   id="qtChaveAdicional_<?= $k + 1 ?>" <?= $gerado ?>
                                                   name="qtd_chave_adicional[]"
                                                   placeholder="Quantidade de parcelas."
                                                   value="<?= ($adicional['qt_parcelas'] > 0) ? ($adicional['qt_parcelas']) : '' ?>">
                                            <small data-bv-validator-for="qtChaveAdicional_<?= $k + 1 ?>"
                                                   class="help-block"
                                                   style="display: none;">
                                            </small>
                                        </div>
                                        <div class="form-group col-sm-2" style="display: inline-block">
                                            <br>
                                            <input type="checkbox" style="vertical-align: middle"
                                                   class="checkbox icheck"
                                                   id="reajustavelChaveAdicional_<?= $k + 1 ?>" <?= $gerado ?>
                                                   name="reajustavel_chave[]" <?= ($adicional['fl_reajustavel'] == '0') ? '' : 'checked' ?>>
                                            <label for="reajustavelChaveAdicional_<?= $k + 1 ?>"
                                                   class="control-label">Reajustvel</label>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        <div class="row hide" id="rowChave">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-4">
                                    <label for="vlChaveAdicional" class="control-label">Valor: </label>
                                    <input type="text" class="form-control money" id="vlChaveAdicional_0"
                                           name="vl_chave_adicional[]" placeholder="Valor da parcela.">
                                    <small data-bv-validator-for="vlChaveAdicional_0" class="help-block"
                                           style="display: none;">a
                                    </small>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label for="qtChaveAdicional" class="control-label">Quantidade: </label>
                                    <input type="text" class="form-control soNumero" id="qtChaveAdicional_0"
                                           name="qtd_chave_adicional[]" placeholder="Quantidade de parcelas.">
                                    <small data-bv-validator-for="qtChaveAdicional_0" class="help-block"
                                           style="display: none;">b
                                    </small>
                                </div>
                                <div class="form-group col-sm-2" style="display: inline-block">
                                    <br>
                                    <input type="checkbox" style="vertical-align: middle" class="checkbox icheck"
                                           id="reajustavelChaveAdicional_0"
                                           name="reajustavel_chave[]"> <?= $gerado ?>
                                    <label for="reajustavelChaveAdicional_0"
                                           class="control-label">Reajustvel</label>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend style="font-size: 21px; color: red">
                            Valor Total do Lote:
                            <strong style="font-size: 21px; color: red">R$ <label
                                        style="font-size: 21px; color: red"
                                        id="vlTotalLote"> <?= $this->get('total') ? $this->get('total') : '0,00'; ?></label></strong>
                        </legend>
                        <div class="row" id="reajusteGeral">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-4">
                                    <label class="control-label" for="dt_reajuste">
                                        Data de reajuste: <span style="color: red; font-size: smaller">(data de incio do clculo do reajuste.)</span>
                                    </label>
                                    <input type="text" class="form-control data datepicker-input" id="dt_reajuste"
                                           name="dt_reajuste"
                                        <?php if ($_GET['a'] == 'adicionar'): ?>
                                            value = "<?= date("d/m/Y"); ?>"
                                        <?php elseif(isset($contrato['dt_reajuste'])) : ?>
                                            value = "<?= Helper::getDate($contrato['dt_reajuste']); ?>"
                                        <?php else : ?>
                                            value = ""
                                        <?php endif;?> />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-8">
                                    <label class="control-label" for="dsObservacao">
                                    Observao:
                                    </label>
                                    <textarea class="form-control" id="dsObservacao" name="obs" cols="50"
                                              rows="5"><?= $contrato['obs']; ?></textarea>
                                </div>
                            </div>
                        </div>
                    </fieldset>

                   <?php if($lista_assinaturas):?>
                    <fieldset>
                        <legend>Assinaturas</legend>
                        
                        <?php foreach($lista_assinaturas as $assinatura):?>
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                Nome: <?=$assinatura['destinatarioNome'];?>
                            </div>
                            <div class="form-group col-sm-6">
                                E-mail: <?=$assinatura['destinatarioEmail'];?>
                            </div>
                        </div>
                        <?php endforeach;?>
                    </fieldset>
                    <?php endif;?>
                    <fieldset>
                        <legend>Operaes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <input type="submit" id="btnSalvar" class="btn btn-primary col-sm-12 fDesabilitaBtn"
                                           value="Salvar">
                                </div>
                                <?php
                                $idAction = Db_Action::findByNome('aprovarContrato');
                                if ($idAction && ACL::hasPermission(Login::getUsuario(), $idAction->getId())) : ?>
                                    <?php if ($contrato['fl_aprovar_contrato'] == '0') : ?>
                                        <div class="form-group col-sm-2 naoAprovado">
                                            <a href="#" onclick="aprovarContrato()"
                                               class="btn btn-primary col-sm-12">Aprovar</a>
                                        </div>
                                    <?php endif; ?>
                                <?php endif; ?>
                                <div class="form-group col-sm-2">
                                    <a href="?m=<?= $_GET['m'] ?>&c=<?= $_GET['c'] ?>&a=listar"
                                       class="btn btn-danger col-sm-12">Cancelar </a>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                </form>

            </div>
        </div>
    </div>
<div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg ">
        <div class="modal-content">

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"
                        aria-hidden="true">&times;</button>
                <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                    Tutorial</h2>
            </div>

            <div class="modal-body tableFix" style="max-height:600px;">
                <fieldset >
                    <legend>Contrato - Cadastro, Edio e Excluso de Contrato</legend>
                    <div class="row" style="margin-right: 0px;margin-left: 0px;">
                        <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/vRhNP1JOZm4?si=3Oc0oEB0i1z2WnqJ" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>                        
                    </div>
                    <div></div>
                </fieldset>
            </div>
        </div>
    </div>
</div>
<?php require_once 'layout/includes/footer.php'; ?>