<?php

class TransferenciaLotesController extends Controller
{
    private $empreendimento;
    private $tb_transferencia;
    private $tb_lote;
    private $pessoasEnvolvidas;
    private $pessoa;
    private $pessoaFisica;
    private $remessa_itens;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->empreendimento = new Empreendimento();
        $this->tb_transferencia = new TransferenciaLote();
        $this->pessoasEnvolvidas = new ContratoPessoa();
        $this->tb_lote = new Lote();
        $this->pessoa = new Pessoa();
        $this->pessoaFisica = new Pessoa_Fisica();
        $this->remessa_itens = new RemessaItens();
        $this->tipoLoteamento = new TipoLoteamento();
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "adm", "controller" => "transferenciaLotes", "action" => "listar"));
    }

    public function listarAction()
    {
        if ($this->isAjax()) {
            $listaItem = $this->tb_transferencia->getAdapter()->select()
                ->from(array('c' => TB_CONTRATO), null)
                ->join(array('t' => TB_TRANSFERENCIA_LOTE), 't.id_contrato = c.id', array('dt_transferencia', 'id_contrato', 'id_transferencia_lote'))
                ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa'))
                ->join(array('lo' => TB_LOTES), 'lo.id = t.id_lote_origem', array('loteOrigem' => 'lote', 'quadraOrigem' => 'quadra'))
                ->join(array('ld' => TB_LOTES), 'ld.id = t.id_lote_destino', array('loteDestino' => 'lote', 'quadraDestino' => 'quadra'))
                ->join(array('e' => TB_EMPREENDIMENTO), 'lo.id_empreendimento = e.id', 'e.nm_empreendimento');

            //Exibe apenas os empreendimentos os quais o usurio tem acesso
            if ($_SESSION['usuario']) {
                try {
                    $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                    $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                    if (count($ids)) {
                        $id = implode(',', $ids);
                        $listaItem->where("e.id IN({$id})");
                    } else {
                        $listaItem->where("1");
                    }
                } catch (Exception $e) {
                }
            }
            $listaItem = $listaItem->order(array('t.id_transferencia_lote DESC'))
                ->query()->fetchAll();

            $lista = array();
            foreach ($listaItem as $item) {
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<a target="_blank" href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=imprime&id=' . $item['id_transferencia_lote'] . '" data-toggle="tooltip" title="GERAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-file-text"></i></a>';
                $title = "return confirm('Tem certeza que deseja cancelar a transferncia " . $item['id_transferencia_lote'] . " ?')";
                $acoes .= '<a onclick="' . $title . '" href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=cancelar&id=' . $item['id_transferencia_lote'] . '" data-toggle="tooltip" title="CANCELAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                $acoes .= '</div></div>';

                //Para ordenar por data
                $data = '<div hidden>' . $item['dt_transferencia'] . '</div>' . Helper::getDate($item['dt_transferencia']);

                $lista[] = array(
                    'data' => '<div align="center">' . $data . '</div>',
                    'empreendimento' => utf8_encode($item['nm_empreendimento']),
                    'contrato' => $item['id_contrato'],
                    'loteOrigem' => 'QD: '.utf8_encode($item['quadraOrigem']).' - '.'LT: '.utf8_encode($item['loteOrigem']),
                    'loteDestino' => 'QD: '.utf8_encode($item['quadraDestino']).' - '.'LT: '.utf8_encode($item['loteDestino']),
                    'cedente' => utf8_encode($item['nm_pessoa']),
                    'acoes' => utf8_encode($acoes)
                );
            }
            echo json_encode(array(
                'draw' => 1,
                'recordsTotal' => count($lista),
                'recordsFiltered' => count($lista),
                'data' => $lista
            ));
        } else {
            $this->display('listar');
        }
    }

    public function adicionarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'adicionarTransferenciaLote')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'transferenciaLotes', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $this->set("subtitulo", "Transferncias de Lote");
        $empreendimentos = $this->empreendimento->getDefaultAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO));
        if ($this->_isPost) {
            if ($this->validar()) {
                try {
                    $tb_contrato = new Contrato();
                    $tb_transferencia = new TransferenciaLote();

                    //recupera o contrato para que seja transferido
                    $contrato = $tb_contrato->fetchRow('id = ' . $_POST['lote_origem']);
                    //cria a linha da transferncia
                    $transf = $tb_transferencia->createRow();

                    $transf->id_lote_origem = $contrato->id_lote;
                    $transf->id_lote_destino = $_POST['lote_destino'];
                    $transf->id_contrato = $contrato->id;
                    $transf->obs = $_POST['obs'];
                    $transf->dt_transferencia = Helper::getInputDate($_POST['data']);
                    $transf->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');

                    $remessa_itens = $this->remessa_itens->fetchAll('id_contrato = ' . $contrato->id);

                    if ($remessa_itens) {
                        foreach ($remessa_itens as $remessa_item) {
                            $remessa_item_update = $this->remessa_itens->fetchRow('id_remessa_itens = ' . $remessa_item->id_remessa_itens);
                            $remessa_item_update->id_lote = $_POST['lote_destino'];
                            $remessa_item_update->save();
                        }
                    }

                    if ($transf->save()) {
                        $contrato->id_lote = $_POST['lote_destino'];
                        $contrato->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');

                        $contrato->save();

                        //Antes de redirecionar grava o resultado no log dos contatos realizados como Transferencia de Lotes.
                        (new Relacionamento())->saveContato(31, date('Y-m-d'), $contrato->id, 'Log: Transferncia de Lotes Adicionada');

                        $this->redir(array("modulo" => "adm", "controller" => "transferenciaLotes", "action" => "listar"), array("msg" => "success"));
                    } else {
                        $this->redir(array("modulo" => "adm", "controller" => "transferenciaLotes", "action" => "listar"), array("msg" => "fail"));
                    }


                } catch (Exception $e) {
                    $this->_helper->addMensagem('fail', 'No foi possivel realizar a operao! Erro: ' . $e->getMessage());
                }
            }
        }

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        $this->set('empreendimentos', $empreendimentos);
        $this->display("form");
    }

    public function imprimeAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'imprimeTransferenciaLote')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'transferenciaLotes', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $contratos = new Contrato();
        $parcerias = new Parceria();
        $pessoas = new Pessoa();
        $empreendimentos = new Empreendimento();
        $transferencias = new TransferenciaLote();
        $assinaturas = new Assinatura();
        $lotes = new Lote();

        $transferencia = $transferencias->fetchRow('id_transferencia_lote = ' . $_GET['id'])->toArray();
        $contrato = $contratos->fetchRow('id = ' . $transferencia['id_contrato'])->toArray();
        $loteDestino = $lotes->fetchRow('id = ' . $transferencia['id_lote_destino'])->toArray();
        $loteOrigem = $lotes->fetchRow('id = ' . $transferencia['id_lote_origem'])->toArray();
        $assinatura = $assinaturas->fetchAll($assinaturas->select()->where('id_empreendimento = ?', $loteDestino['id_empreendimento']))->toArray();
        $empreendimento = $empreendimentos->fetchRow('id = ' . $loteDestino['id_empreendimento'])->toArray();

        //cliente
        $cedente = $pessoas->getAdapter()->select()->from(array('p' => TB_PESSOA), array('*'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', '*')
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'p.id = pj.id_pessoa', '*')
            ->joinLeft(array('c' => TB_CIDADE), 'c.id = p.cd_cidade', '*')
            ->where('p.id = ' . $contrato['id_pessoa'])->query()->fetch();

        if ($cedente['cd_conjuge']) {
            $cedenteConjuge = $pessoas->getAdapter()->select()->from(array('p' => TB_PESSOA), array('*'))
                ->join(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', array('id_pessoa', 'nr_cpf', 'dt_nascimento', 'nm_profissao', 'nm_nacionalidade', 'nm_pai', 'nm_mae', 'cd_cidade_nasc', 'sexo', 'est_civil', 'nr_rg', 'cd_conjuge', 'cd_documento', 'tp_nacionalidade'))
                ->joinLeft(array('c' => TB_CIDADE), 'c.id = p.cd_cidade', '*')
                ->where('p.id = ' . $cedente['cd_conjuge'])->query()->fetch();
            $this->set("cedenteConjuge", $cedenteConjuge);
        }

        $outrosCompradores = [];
        $outrosCompradoresConjuge = [];
        //pessoas envolvidas
        $pessoas_envolvidas = $this->pessoasEnvolvidas->findByContrato($contrato['id']);
        if ($pessoas_envolvidas) {
            foreach ($pessoas_envolvidas as $key => $pessoa_envolvida) {
                $outrosCompradores[$key] = $this->pessoa->findFisicaById($pessoa_envolvida['id_pessoa']);
                if ($outrosCompradores[$key]['cd_conjuge']) {
                    $outrosCompradoresConjuge[$key] = $pessoas->getAdapter()->select()->from(array('p' => TB_PESSOA), array('*'))
                    ->join(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', array('id_pessoa', 'nr_cpf', 'dt_nascimento', 'nm_profissao', 'nm_nacionalidade', 'nm_pai', 'nm_mae', 'cd_cidade_nasc', 'sexo', 'est_civil', 'nr_rg', 'cd_conjuge', 'cd_documento', 'tp_nacionalidade'))
                    ->joinLeft(array('c' => TB_CIDADE), 'c.id = p.cd_cidade', '*')
                    ->where('p.id = ' . $outrosCompradores[$key]['cd_conjuge'])->query()->fetch();
                }
            }
            $this->set("outrosCompradores", $outrosCompradores);
            $this->set("outrosCompradoresConjuge", $outrosCompradoresConjuge);
        }

        $tipoLoteamento = $this->tipoLoteamento->fetchRow("id_tipo_loteamento = '{$empreendimento['id_tipo_loteamento']}'")->toArray();
        $this->set('tipoLoteamento', $tipoLoteamento);

        $empreendimentoInfo = $this->empreendimento->getAdapter()->select()->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento'))
            ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
            ->where('id = ' . $loteDestino['id_empreendimento'])
            ->query()->fetch();
        $this->set("empreendimentoInfo", $empreendimentoInfo);

        $parceria = $parcerias->fetchAll($parcerias->select()->where('id_empreendimento = ?', $loteDestino['id_empreendimento']))->toArray();
        $this->set('loteOrigem', $loteOrigem);
        $this->set('loteDestino', $loteDestino);
        $this->set('cedente', $cedente);
        $this->set('contrato', $contrato);
        $this->set('parceria', $parceria);
        $this->set('empreendimento', $empreendimento);
        $this->set('transferencia', $transferencia);
        $this->set('assinatura', $assinatura);
        $this->displayPDF("transferencia" . time() . ".pdf");
    }

    public function cancelarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'excluirTransferenciaLote')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'transferenciaLotes', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
            exit;
        }

        $tb_contrato = new Contrato();
        $transferencia = $this->tb_transferencia->fetchRow('id_transferencia_lote = ' . $_GET['id']);
        $contrato = $tb_contrato->fetchRow('id = ' . $transferencia['id_contrato'])->toArray();

        $db = Zend_Db_Table::getDefaultAdapter();
        $db->beginTransaction();

        $saveLote = array(
            'id_lote' => $transferencia['id_lote_origem']
        );

        $db->update(TB_CONTRATO, $saveLote, 'id = ' . $contrato['id']);
        $db->commit();
        $this->tb_transferencia->delete('id_transferencia_lote = ' . $_GET['id']);

        $remessa_itens = $this->remessa_itens->fetchAll('id_contrato = ' . $contrato['id']);

        if ($remessa_itens) {
            foreach ($remessa_itens as $remessa_item) {
                $remessa_item_update = $this->remessa_itens->fetchRow('id_remessa_itens = ' . $remessa_item->id_remessa_itens);
                $remessa_item_update->id_lote = $transferencia['id_lote_origem'];
                $remessa_item_update->save();
            }
        }

        //Antes de redirecionar grava o resultado no log dos contatos realizados como Transferencia de Lotes.
        (new Relacionamento())->saveContato(66, date('Y-m-d'), $contrato['id'], 'Log: Transferncia Lotes Cancelada');
        $this->redir(array("modulo" => "adm", "controller" => "transferenciaLotes", "action" => "listar"), array("msg" => "success"));
    }

    private function validar()
    {
        $campos = array("lote_origem", "lote_destino", "id_empreendimento", "data");
        $validar = explode('/', $_POST['data']);
        if($validar[2] < 1900){
            $this->_helper->addMensagem('erro', 'A data no pode ser inferior a 1900.');
        }
        foreach ($campos as $cp) {
            if ($_POST[$cp] == "") {
                $this->_helper->addMensagem('erro', 'Todos os campos so obrigatrios.');
            }
        }
        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function loteClienteByEmpreendimentoAction()
    {
        $contratos = Contrato::byEmpreendimento($_POST['id_empreendimento'], Contrato::CONTRATO_TODOS, 2, array("nm_pessoa", "lote", "quadra", "id"), true);

        $lista = array();
        foreach ($contratos as $contrato) {
            $lista[] = array('id' => $contrato['id'], 'text' => utf8_encode($contrato['nm_pessoa']) . ' - Quadra: ' . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']) . ' - Contrato: ' . utf8_encode($contrato['id']));
        }

        echo json_encode($lista);
    }

    public function loteByEmpreendimentoAction()
    {
        $lotes = $this->tb_lote->findLotesDisponiveis($_POST['id_empreendimento'], null,null,'1');

        $lista = array();
        foreach ($lotes as $lote) {
            $lista[] = array('id' => $lote['id'], 'text' => 'Quadra: ' . utf8_encode($lote['quadra']) . ' - Lote: ' . utf8_encode($lote['lote']));
        }

        echo json_encode($lista);
    }
}