<?php

class TransferenciaController extends Controller
{
    public function indexAction()
    {
        $this->redir(array("modulo" => "adm", "controller" => "transferencia", "action" => "listar"));
    }

    public function listarAction()
    {
        $modeloArquivo = new ModeloArquivo();
        $listaArquivo = $modeloArquivo->fetchAll($modeloArquivo->select()->order('nm_titulo')->where('tp_modelo = "T" and fl_status = "1"'));
        $this->set('listaArquivoWord', $listaArquivo);

        if ($this->isAjax()) {
            $tbTransferencia = new Transferencia();
            $tbTransferenciaCedentes = new TransferenciaCedentes();
            $tbTransferenciaCedentes2 = new ContratoPessoa();
            $tbTransferenciaCessionarios = new ContratoPessoa();
            $tb_cessionarios = new TransferenciaCessionarios();

            $listaItem = $tbTransferencia->getAdapter()->select()
                ->from(array('c' => TB_CONTRATO), null)
                ->join(array('t' => TB_TRANSFERENCIA), 't.idContrato = c.id', array('data', 'idContrato', 'id', 'dt_recebimento_termo'))
                ->join(array('p' => TB_PESSOA), 't.idCedente = p.id', array('cedente' => 'nm_pessoa'))
                ->join(array('p2' => TB_PESSOA), 't.idReceptor = p2.id', array('receptor' => 'nm_pessoa'))
                ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('lote', 'quadra'))
                ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', array('nm_empreendimento'));
            //Exibe apenas os empreendimentos os quais o usurio tem acesso
            if ($_SESSION['usuario']) {
                try {
                    $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                    $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                    if (count($ids)) {
                        $id = implode(',', $ids);
                        $listaItem->where("e.id IN({$id})");
                    } else {
                        $listaItem->where("1");
                    }
                } catch (Exception $e) {
                }
            }
            $listaItem = $listaItem->order(array('t.id DESC'))
                ->query()->fetchAll();

            $lista = array();
            foreach ($listaItem as $item) {
                $msgConfirm ="Voc realmente deseja confirmar o recebimento do termo assinado?";
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<button type="button" onClick="gerarPago(' . $item['id'] . ')" value="' . $item['id'] . '" data-target=".modalGerarPago" data-toggle="modal" title="GERAR" class="btn btn-default btn-sm btn-gerar-pago" style="margin-right:5px"><i data-toggle="tooltip" title="GERAR" class="fa fa-file-o"></i>
                </button></span>';
                
                
                $title = ($item['dt_recebimento_termo'])?"DESFAZER CONFIRMAO TERMO ASSINADO":"CONFIRMAR RECEBIMENTO TERMO ASSINADO";
                if(!$item['dt_recebimento_termo']){
                    $alert = "if(confirm('".$msgConfirm."')){confirmarRecebimento(this,". $item['id'] .")}";
                    $acoes .= '<a onclick="' . $alert . '" data-toggle="tooltip" title="'.$title.'" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-download"></i></a>';
                    $acoes .= '<a onclick="' . $title . '" href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=cancelar&id=' . $item['id'] . '" data-toggle="tooltip" title="CANCELAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                }
                else{
                    $title = "return confirm('Tem certeza que deseja cancelar a transferncia " . $item['id'] . " ?')";
                    $acoes .= '<a onclick="' . $title . '" href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=cancelar&id=' . $item['id'] . '" data-toggle="tooltip" title="CANCELAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                }
                
                $acoes .= '</div></div>';
                if($item['dt_recebimento_termo']){
                    $tbTransferenciaCed = $tbTransferenciaCedentes->getAdapter()->select()
                        ->from(array('tc' => TB_TRANSFERENCIA_CEDENTES), array('id_transferencia', 'id_pessoa'))
                        ->join(array('p' => TB_PESSOA), 'tc.id_pessoa = p.id', array('id', 'nm_pessoa'))
                        ->where("tc.id_transferencia = ?", $item['id'])->query()->fetchAll();
                }else{
                    $tbTransferenciaCed = $tbTransferenciaCedentes2->getAdapter()->select()
                        ->from(array('tc' => TB_CONTRATO_PESSOA), array('id_contrato', 'id_pessoa'))
                        ->join(array('p' => TB_PESSOA), 'tc.id_pessoa = p.id', array('id', 'nm_pessoa'))
                        ->where("tc.id_contrato = ?", $item['idContrato'])->query()->fetchAll();
                }
                $cessionarios = null; 
                if($item['dt_recebimento_termo']){
                    $tbContratoP = $tbTransferenciaCessionarios->getAdapter()->select()
                        ->from(array('tc' => TB_TRANSFERENCIA_CESSIONARIOS), array('id_transferencia', 'id_pessoa' => 'id_cessionario'))
                        ->join(array('p' => TB_PESSOA), 'tc.id_cessionario = p.id', array('id', 'nm_pessoa'))
                        ->where("tc.id_transferencia = ?", $item['id'])->query()->fetchAll();
        
                    if ($tbContratoP) {
                        $cessionarios = [];
                        foreach ($tbContratoP as $cessionario) {
                            $cessionarios[] = $cessionario['nm_pessoa'];
                        }
                        $cessionarios = ' / ' . implode(' / ', $cessionarios);
                    }
                    
                }else{
                    $transf = $tbTransferencia->fetchRow('id = ' . $item['id']);
                    $listaIndices = $tb_cessionarios->getAdapter()->select()
                        ->from(array('tc' => TB_TRANSFERENCIA_CESSIONARIOS), array('id_cessionario'))
                        ->join(array('p' => TB_PESSOA), 'tc.id_cessionario = p.id', array('id', 'nm_pessoa'))
                        ->where("tc.id_transferencia = ?", $item['id'])->query()->fetchAll();
    
                    if ($listaIndices) {
                        $cessionarios = [];
                        foreach ($listaIndices as $cessionario) {
                            $cessionarios[] = $cessionario['nm_pessoa'];
                        }
                        $cessionarios = ' / ' . implode(' / ', $cessionarios);
                    }

                }
                
                $cedentes = null;
                    if ($tbTransferenciaCed) {
                        $cedentes = [];             
                        foreach ($tbTransferenciaCed as $cedente) {
                            $cedentes[] = $cedente['nm_pessoa'];
                        }
                        $cedentes = ' / ' . implode(' / ', $cedentes);
                    }


                //Exibir Status de transferncia
                if ($item['dt_recebimento_termo']) {
                    $status = '<div style="width: 100%; display: flex; align-items: center; justify-content: center;" id="status_'.$item['id'].'" class="label label-info">Confirmado</div>';
                } else {
                    $status = '<div style="width: 100%; display: flex; align-items: center; justify-content: center;" id="status_'.$item['id'].'" class="label label-warning">Pendente</div>';
                }

                //Para ordenar por data
                $data = '<div hidden>' . $item['data'] . '</div>' . Helper::getDate($item['data']);

                $lista[] = array(
                    'data' => '<div align="center">' . $data . '</div>',
                    'empreendimento' => utf8_encode($item['nm_empreendimento']),
                    'contrato' => $item['idContrato'],
                    'quadra' => utf8_encode($item['quadra']),
                    'lote' => utf8_encode($item['lote']),
                    'cedente' => utf8_encode($item['cedente'] . $cedentes),
                    'cessionario' => utf8_encode($item['receptor'] . $cessionarios),
                    'status' => $status,
                    'acoes' => utf8_encode($acoes),                    
                );
            }
            echo json_encode(array(
                'draw' => 1,
                'recordsTotal' => count($lista),
                'recordsFiltered' => count($lista),
                'data' => $lista
            ));
        } else {
            $this->display('listar');
        }


    }

    public function adicionarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'adicionarTransferenciaTitularidade')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'transferencia', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $somaParticipacao = $_POST['participacao']? $_POST['participacao']: 0;
            foreach ($_POST['listaIndices'] as $dados) {
                $indice = explode('_', $dados);
                $somaParticipacao += $this->_helper->filters($indice[2], 'money');
            }
            if($somaParticipacao>100){
                $this->redir(array("modulo" => "adm", "controller" => "transferencia", "action" => "adicionar"),array("exception"=> 'A soma das participaes no pode ser superior a 100'));exit();
                
            }

        $tb_remessas_itens = new RemessaItens();
        $this->set("subtitulo", "Transferncia");
        $tbEmpreendimento = new Empreendimento();
        $empreendimentos = $tbEmpreendimento->getDefaultAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO));
        if ($this->_isPost) {
            if ($this->validar()) {
                $tb_contrato = new Contrato();
                $tb_transferencia = new Transferencia();
                $tb_parcelas = new Parcela();
                $tb_cessionarios = new TransferenciaCessionarios();
                $data = Helper::getInputDate($_POST['data']);

                $parcelas = $tb_parcelas->select()
                    ->distinct()
                    ->from(TB_PARCELA, array(
                        'tp_parcela',
                        'valor' => 'sum(vl_parcela)',
                        'total' => 'count(tp_parcela)',
                        'data' => 'min(dt_parcela)'
                    ))
                    ->where("pago = '0'")
                    ->where("dt_parcela > '{$data}' and id_contrato = {$_POST['id_contrato']}")
                    ->group('tp_parcela')
                    ->query()->fetchAll();

                $auxParcelas = array();
                foreach($parcelas as &$tipo){
                    $tipo['valor'] = (float)$tipo['valor'] / (int)$tipo['total'];
                    $auxParcelas[$tipo['tp_parcela']] = $tipo;
                }

                //recupera o contrato para que seja transferido
                $contrato = $tb_contrato->fetchRow('id = ' . $_POST['id_contrato']);
                //cria a linha da transferncia
                $transf = $tb_transferencia->createRow();

                $transf->idCedente = $contrato->id_pessoa;
                $transf->idReceptor = $_POST['idReceptor'];
                $transf->idContrato = $_POST['id_contrato'];
                $transf->obs = $_POST['obs']?$_POST['obs']:null;

                $transf->totalSinal = $auxParcelas['S']['total'];
                $transf->vlSinal = $auxParcelas['S']['valor'];
                $transf->dtSinal = Helper::getInputDate($auxParcelas['S']['data']);

                $transf->totalNormal = $auxParcelas['N']['total'];
                $transf->vlNormal = $auxParcelas['N']['valor'];
                $transf->dtNormal = Helper::getInputDate($auxParcelas['N']['data']);

                $transf->totalIntercalada = $auxParcelas['I']['total'];
                $transf->vlIntercalada = $auxParcelas['I']['valor'];
                $transf->dtIntercalada = Helper::getInputDate($auxParcelas['I']['data']);

                $transf->totalEntrega = $auxParcelas['C']['total'];
                $transf->vlEntrega = $auxParcelas['C']['valor'];
                $transf->dtEntrega = Helper::getInputDate($auxParcelas['C']['data']);

                $transf->totalNegociada = $auxParcelas['G']['total'];
                $transf->vlNegociada = $auxParcelas['G']['valor'];
                $transf->dtNegociada = Helper::getInputDate($auxParcelas['G']['data']);

                $transf->data = $data;
                if($_POST['listaIndices']){
                    $transf->listaIndices = json_encode(Helper::removeCaracteresEspeciaisSped($_POST['listaIndices']));
                }
                else{
                    $transf->listaIndices = json_encode([]);
                }
                $transf->participacao =floatval(number_format($_POST['participacao'],2,".","")) ;
                $transf->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                $idTrans = $transf->save();
                if($_POST['listaIndices']){
                    foreach($_POST['listaIndices'] as $cessionario) {
                        $dadosCessionario = explode('_', $cessionario);
                        $cessionarios = $tb_cessionarios->createRow();
                        $cessionarios->id_transferencia = $transf->id;
                        $cessionarios->id_cessionario = $dadosCessionario['3'];
                        $cessionarios->porcentagem_participacao_contrato = ($dadosCessionario['2'] == '')? null : Helper::getInputMoney($dadosCessionario['2']);
                        
                        $cessionarios->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                        $cessionarios->save();
                    }
                }
                if ($idTrans) {
                    $this->redir(array("modulo" => "adm", "controller" => "transferencia", "action" => "listar"), array("msg" => "success"));
                }
            }
        }

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        $this->set('empreendimentos', $empreendimentos);
        $this->display("form");
    }

    public function imprimeAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'imprimeTransferenciaTitularidade')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'transferencia', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $contratos = new Contrato();
        $parcerias = new Parceria();
        $parcelas = new Parcela();
        $pessoas = new Pessoa();
        $empreendimentos = new Empreendimento();
        $transferencias = new Transferencia();
        $contratoPessoa = new ContratoPessoa();
        $assinaturas = new Assinatura();
        $lotes = new Lote();
        $parcelas = new Parcela();
        $transferenciaCedentes = new TransferenciaCedentes();
        $tbTransferenciaCessionarios = new TransferenciaCessionarios();
        $transferencia = $transferencias->fetchRow('id = ' . $_GET['id'])->toArray();
        $contrato = $contratos->fetchRow('id = ' . $transferencia['idContrato'])->toArray();
        $contratoItens = new ContratoItens();
        $contratoItens = $contratoItens->fetchAll('id_contrato = ' . $transferencia['idContrato']);
        $contratoItens = is_object($contratoItens) ? $contratoItens->toArray() : [];
        $lote = $lotes->fetchRow('id = ' . $contrato['id_lote'])->toArray();
        $assinaturas = $assinaturas->fetchAll($assinaturas->select()->where('id_empreendimento = ?', $lote['id_empreendimento']))->toArray();
        $empreendimento = $empreendimentos->fetchRow('id = ' . $lote['id_empreendimento'])->toArray();
        $listaAssinaturas = array();

        $tbIndiceEmpreendimento = new IndiceEmpreendimento();
        $indiceEmpreendimento = $tbIndiceEmpreendimento->fetchRow('id_indice_empreendimento = '.$contrato['id_indice']);
        $reajusteTipos = array(
            'M' => 'Mensal',
            'B' => 'Bimestral',
            'T' => 'Timestral',
            'S' => 'Semestral',
            'A' => 'Anual',
            'AM' => 'Anual + Mensal (' . $indiceEmpreendimento['indice_pos_entrega'] . '% a.m.)',
            'SP' => 'Sem Periodo'
        );
        $indicePosEntrega = ($contrato['fl_periodo'] == 'AM')?'(IPE: '.str_replace('.',',',$contrato['indice_pos_entrega']).'%)':'';
        $comSemResiduo = ($contrato['fl_residuo'] == '1')?'Com':'Sem';
        $indiceAdicional = $indiceEmpreendimento['indice_adicional'] != '0'?' +' . str_replace('.',',',number_format($indiceEmpreendimento['indice_adicional'], 2)) . '%':'';
        if ($indiceEmpreendimento['id_indice']) {
            $indiceEmp = AgrupadaGeral::buscar(Db_TabelaAgrupada::TABLE_INDICE, $indiceEmpreendimento['id_indice']);
            $indiceEmp = $indiceEmp['descricao'];
        } else {
            $indiceEmp = '';
        }
        $indiceReajuste = $indiceEmp . " " . $reajusteTipos[$indiceEmpreendimento['fl_periodo']] . " " . $indiceAdicional . ' ' . $reajusteTipos[$indiceEmpreendimento['fl_periodo_adc']] . ' - ' . $comSemResiduo . ' Resduo';

        $this->set("indiceReajuste", $indiceReajuste);
        //CEDENTE
        $cedente = $pessoas->getAdapter()->select()
            ->from(array('p' => TB_PESSOA), array('*'))
            ->joinLeft(array('c' => TB_CIDADE), 'c.id = p.cd_cidade', '*')
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', array('id_pessoa', 'nr_cpf', 'dt_nascimento', 'nm_profissao', 'nm_nacionalidade', 'nm_pai', 'nm_mae', 'cd_cidade_nasc', 'sexo', 'est_civil', 'nr_rg', 'cd_conjuge', 'cd_documento', 'tp_nacionalidade', 'reg_casamento'))
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'p.id = pj.id_pessoa', '*')
            ->where('p.id = ' . $transferencia['idCedente'])->query()->fetch();
        $listaAssinaturas[] = array('tipo'=>'CEDENTE','nome'=>$cedente['nm_pessoa']);
        //CEDENTE CONJUGE
        if ($cedente['cd_conjuge']) {
            $cedenteConjuge = $pessoas->getAdapter()->select()->from(array('p' => TB_PESSOA), array('*'))
                ->join(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', array('id_pessoa', 'nr_cpf', 'dt_nascimento', 'nm_profissao', 'nm_nacionalidade', 'nm_pai', 'nm_mae', 'cd_cidade_nasc', 'sexo', 'est_civil', 'nr_rg', 'cd_conjuge', 'cd_documento', 'tp_nacionalidade', 'reg_casamento'))
                ->joinLeft(array('c' => TB_CIDADE), 'c.id = p.cd_cidade', '*')
                ->where('p.id = ' . $cedente['cd_conjuge'])->query()->fetch();
            $listaAssinaturas[] = array('tipo'=>'CEDENTE CNJUGE','nome'=>$cedenteConjuge['nm_pessoa']);
        }
        //OUTROS CEDENTES
        if($transferencia['dt_recebimento_termo']){
            $cedentes = $transferenciaCedentes->fetchAll('id_transferencia = ' . $_GET['id'])->toArray();
        }else{
            $cedentes = $contratoPessoa-> fetchAll('id_contrato = ' .$transferencia['idContrato'])->toArray();
        }
        if (count($cedentes) > 0) {
            $relacionados = array();
            foreach ($cedentes as $c) {
                $ced = Pessoa_Fisica::findDadosPessoaFisica($c['id_pessoa']);
                if(!$ced){

                    $ced = Pessoa_Juridica::findDadosPessoaJuridica($c['id_pessoa']);
                }
                $relacionados[] = $ced;
                $listaAssinaturas[] = array('tipo'=>'CEDENTE','nome'=>$ced['nm_pessoa']);
                //Caso seja casado(a), adiciona tambm o nome do(a) conjuge
                if ($cedente['est_civil'] == 'CAS' && $ced['cd_conjuge']) {
                    $conjuge = Pessoa_Fisica::findDadosPessoaFisica($ced['cd_conjuge']);
                    $listaAssinaturas[] = array('tipo'=>'CEDENTE CNJUGE','nome'=>$conjuge['nm_pessoa']);
                    $relacionados[] = $conjuge;
                }
            }
            $this->set('relacionados', $relacionados);
        }
        //CESSIONARIO
        $receptor = $pessoas->getAdapter()->select()
            ->from(array('p' => TB_PESSOA), '*')
            ->where('p.id = ' . $transferencia['idReceptor'])->query()->fetch();
        $receptorQuery = $pessoas->getAdapter()->select()
            ->from(array('p' => TB_PESSOA), array('*'))
            ->joinLeft(array('c' => TB_CIDADE), 'c.id = p.cd_cidade', '*')
            ->where('p.id = ' . $transferencia['idReceptor']);
        if ($receptor['tp_pessoa'] == 'F') {
            $receptorQuery->join(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', array('id_pessoa', 'nr_cpf', 'dt_nascimento', 'nm_profissao', 'nm_nacionalidade', 'nm_pai', 'nm_mae', 'cd_cidade_nasc', 'sexo', 'est_civil', 'nr_rg', 'cd_conjuge', 'cd_documento', 'tp_nacionalidade', 'reg_casamento'));
        } elseif ($receptor['tp_pessoa'] == 'J') {
            $receptorQuery->join(array('j' => TB_PESSOA_JURIDICA), 'p.id = j.id_pessoa', '*');
        }
        $receptor = $receptorQuery->query()->fetch();
        $listaAssinaturas[] = array('tipo'=>'CESSIONRIO','nome'=>$receptor['nm_pessoa']);
        //CESSIONARIO CONJUGE
        if ($receptor['cd_conjuge']) {
            $receptorConjuge = $pessoas->getAdapter()->select()
                ->from(array('p' => TB_PESSOA), array('*'))
                ->joinLeft(array('c' => TB_CIDADE), 'c.id = p.cd_cidade', '*')
                ->where('p.id = ' . $receptor['cd_conjuge'])
                ->join(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', array('id_pessoa', 'nr_cpf', 'dt_nascimento', 'nm_profissao', 'nm_nacionalidade', 'nm_pai', 'nm_mae', 'cd_cidade_nasc', 'sexo', 'est_civil', 'nr_rg', 'cd_conjuge', 'cd_documento', 'tp_nacionalidade', 'reg_casamento'))
                ->query()->fetch();
            $listaAssinaturas[] = array('tipo'=>'CESSIONRIO CNJUGE','nome'=>$receptorConjuge['nm_pessoa']);
        }

        $empreendimentoInfo = $empreendimentos->getAdapter()->select()->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento'))
            ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
            ->where('id = ' . $lote['id_empreendimento'])
            ->query()->fetch();
        $this->set("empreendimentoInfo", $empreendimentoInfo);

        $assinatura = new Assinatura();
        $socioInfo = $assinatura ->getAdapter()->select()
            ->from(array('a' => TB_ASSINATURA), array('*'))
            ->join(array('p' => TB_PESSOA), 'a.id_pessoa = p.id', '*')
            ->joinLeft(array('c' => TB_CIDADE), 'c.id = p.cd_cidade', '*')
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', array('id_pessoa', 'nr_cpf', 'dt_nascimento', 'nm_profissao', 'nm_nacionalidade', 'nm_pai', 'nm_mae', 'cd_cidade_nasc', 'sexo', 'est_civil', 'nr_rg', 'cd_conjuge', 'cd_documento', 'tp_nacionalidade', 'reg_casamento'))
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'p.id = pj.id_pessoa', '*')
            ->where('a.id_empreendimento = ' . $empreendimento['id'])
            ->query()->fetchAll();
        $this->set("socioInfo", $socioInfo);

        //OUTROS CESSIONARIOS
        if($transferencia['dt_recebimento_termo']){
            $tbCessionarios = new TransferenciaCessionarios();
            $cessionarios = $tbCessionarios->fetchAll('id_transferencia = ' . $_GET['id'])->toArray();
        }else{
            $transf = $transferencias->fetchRow('id = ' . $_GET['id']);
            $listaIndices = json_decode($transf->listaIndices, true);
            if ($listaIndices) {
                $cessionarios = [];
                foreach ($listaIndices as $cessionario) {
                    foreach ($listaIndices as $s =>$cessionario) {
                        $dadosCessionario = explode('_', $cessionario);
                        $cessionarios[$s]['id_cessionario'] = $dadosCessionario[3];
                    }
                }
            }
        }
        
        if (count($cessionarios) > 0) {
            $outros = array();
            foreach ($cessionarios as $c) {
                $outro = $pessoas->getAdapter()->select()->from(array('p' => TB_PESSOA), '*')
                    ->where('p.id = ' . $c['id_cessionario'])->query()->fetch();
                //outro receptores dados
                $receptorQuery = $pessoas->getAdapter()->select()->from(array('p' => TB_PESSOA), array('*'))
                    ->joinLeft(array('c' => TB_CIDADE), 'c.id = p.cd_cidade', '*')
                    ->where('p.id = ' . $c['id_cessionario']);
                if ($outro['tp_pessoa'] == 'F') {
                    $receptorQuery->join(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', array('id_pessoa', 'nr_cpf', 'dt_nascimento', 'nm_profissao', 'nm_nacionalidade', 'nm_pai', 'nm_mae', 'cd_cidade_nasc', 'sexo', 'est_civil', 'nr_rg', 'cd_conjuge', 'cd_documento', 'tp_nacionalidade', 'reg_casamento'));
                } elseif ($receptor['tp_pessoa'] == 'J') {
                    $receptorQuery->join(array('j' => TB_PESSOA_JURIDICA), 'p.id = j.id_pessoa', '*');
                }
                $receptorQuery = $receptorQuery->query()->fetch();
                $outros[] = $receptorQuery;
                $listaAssinaturas[] = array('tipo'=>'CESSIONRIO','nome'=>$receptorQuery['nm_pessoa']);
                //Caso seja casado(a), adiciona tambm o nome do(a) conjuge
                if ($receptorQuery['est_civil'] == 'CAS' && $receptorQuery['cd_conjuge']) {
                    $conjuge = $pessoas->getAdapter()->select()
                        ->from(array('p' => TB_PESSOA), array('*'))
                        ->join(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', array('id_pessoa', 'nr_cpf', 'dt_nascimento', 'nm_profissao', 'nm_nacionalidade', 'nm_pai', 'nm_mae', 'cd_cidade_nasc', 'sexo', 'est_civil', 'nr_rg', 'cd_conjuge', 'cd_documento', 'tp_nacionalidade', 'reg_casamento'))
                        ->joinLeft(array('c' => TB_CIDADE), 'c.id = p.cd_cidade', '*')
                        ->where('p.id = ' . $receptorQuery['cd_conjuge'])
                        ->query()->fetch();
                    $listaAssinaturas[] = array('tipo'=>'CESSIONRIO C�NJUGE','nome'=>$conjuge['nm_pessoa']);
                    $outros[] = $conjuge;
                }
            }
            
            $this->set('outros', $outros);
        }
        $parcelas = $parcelas->getAdapter()->select()->from(array('pc' => TB_PARCELA), array('*'))
            ->where('pc.id_contrato = ' . $transferencia['idContrato'] . '&& pc.pago = "1"')
            ->query()->fetchAll();

        $parceria = $parcerias->fetchAll($parcerias->select()->where('id_empreendimento = ?', $lote['id_empreendimento']))->toArray();
        $tbClienteAcade = (new Db_Cliente())->fetchRow()->toArray();
        $tbClienteAcade['incluirPago'] = $_GET['incluirPago'];
        $this->set('clienteAcade', $tbClienteAcade);
        $this->set('lote', $lote);
        $this->set('cedente', $cedente);
        $this->set('cedenteConjuge', $cedenteConjuge);
        $this->set('receptor', $receptor);
        $this->set('receptorConjuge', $receptorConjuge);
        $this->set('contrato', $contrato);
        $this->set('contratoItens', $contratoItens);
        $this->set('parceria', $parceria);
        $this->set('parcelas', $parcelas);
        $this->set('empreendimento', $empreendimento);
        $this->set('transferencia', $transferencia);
        $this->set('assinatura', $assinaturas);
        $this->set('listaAssinaturas', $listaAssinaturas);
        $this->set('parcelas', $parcelas);
        $this->display();
        $this->displayPDF("transferencia" . time() . ".pdf",true, 'P', "A4", array(5, -5, 0, 0));
    }

    //Gera modelo word
    public function imprimeWordAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'imprimeTransferenciaTitularidade')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'transferencia', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $transferencias = new Transferencia();
        $contratos = new Contrato();
        $transferencia = $transferencias->fetchRow('id = ' . $_GET['id'])->toArray();
        $contrato = $contratos->fetchRow('id = ' . $transferencia['idContrato'])->toArray();
        
        $templateProcessor = new \PhpOffice\PhpWord\TemplateProcessor(__ROOT__ . '/' . $_GET['modelo']);
        
        $variaveis = $this->adicionarValoresTemplate($contrato['id'], $templateProcessor, $_GET['id']);
        
        $filename = 'emissaoTransferencia' . $contrato . '.docx';
        
        $variaveis['templateProcessor']->saveAs($filename);

        //gera o download automatico
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename='.$filename);
        header('Content-Transfer-Encoding: binary');
        header('Expires: 0');
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header('Pragma: public');
        header('Content-Length: ' . filesize($filename));
        flush();
        //remove os arquivos temporarios
        readfile($filename);
        unlink($filename);
    }

    private function validar()
    {

        $campos = array("idReceptor", "id_contrato", "id_empreendimento");

        $validar = explode('/', $_POST['data']);
        if($validar[2] < 1900){
            $this->_helper->addMensagem('erro', 'O ano no pode ser inferior a 1900.');
        }
        foreach ($campos as $cp) {
            if ($_POST [$cp] == "") {
                $this->_helper->addMensagem('erro', 'Todos os campos s�o obrigat�rios.');
            }
        }
        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function confirmaRecebimentoAction() {
        
        if ($this->_isPost) {
            $tb_contrato = new Contrato();
            $tb_transferencia = new Transferencia();

            //cria a linha da transferncia
            $transf = $tb_transferencia->fetchRow('id = ' . $_POST['id']);

            //recupera o contrato para que seja transferido
            $contrato = $tb_contrato->fetchRow('id = ' . $transf->idContrato);
        
            if ($transf) {
                if( $_POST['desfazer']){
                    $transf->dt_recebimento_termo = null;
                    $transf->save();
                    echo json_encode(array("msg" => "success","id"=>$transf->id,"obs"=>"removido data de recebimento termos"));
                    die;
                }
                //Salva os outros cedentes
                $cedentes = ContratoPessoa::findByContrato($contrato->id);
                if (count($cedentes) > 0) {
                    $tb_transferenciaCedente = new TransferenciaCedentes();
                    foreach ($cedentes as $cedente) {
                        $transCedente = $tb_transferenciaCedente->createRow();
                        $transCedente->id_transferencia = $transf->id;
                        $transCedente->id_pessoa = $cedente['id_pessoa'];
                        $transCedente->porcentagem_participacao_contrato = $cedente['porcentagem_participacao_contrato'];
                        $transCedente->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                        $transCedente->save();
                    }
                }
                
                //Salva o cessionario
                $tb_cessionarios = new TransferenciaCessionarios();
                $tb_contratoPessoas = new ContratoPessoa();
                $contrato->id_pessoa = $transf->idReceptor;
                $contrato->porcentagem_participacao_contrato = $this->_helper->filters($transf->participacao, 'money');
                $contrato->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                
                $contrato->save();
                
                if (count($cedentes) > 0) {
                    $tb_contratoPessoas->deleteByContrato($contrato->id);
                }
                //Salva os outros CESSIONRIO
                $listaIndices = json_decode($transf->listaIndices, true);
                if (count($listaIndices) > 0) {
                    foreach ($listaIndices as $cessionario) {
                        $dadosCessionario = explode('_', $cessionario);
        
                        $contratoPessoa = $tb_contratoPessoas->createRow();
                        $contratoPessoa->id_contrato = $contrato->id;
                        if($dadosCessionario['3']){
                            $contratoPessoa->id_pessoa = $dadosCessionario['3'];
                            $contratoPessoa->porcentagem_participacao_contrato = $this->_helper->filters($dadosCessionario['2'], 'money');
                        }
                        else{
                            $contratoPessoa->id_pessoa = $dadosCessionario['2'];
                            $contratoPessoa->porcentagem_participacao_contrato = null;
                        }
                        $contratoPessoa->save();
                    }
                }
        
                $tb_remessas_itens = new RemessaItens();
                $remessas_itens = $tb_remessas_itens->fetchAll('id_contrato = ' . $transf->idContrato);
                if ($remessas_itens) {
                    foreach ($remessas_itens as $remessa_item) {
                        $remessa_item_update = $tb_remessas_itens->fetchRow('id_remessa_itens = ' . $remessa_item->id_remessa_itens);
                        $remessa_item_update->id_pessoa = $transf->idReceptor;
                        $remessa_item_update->save();
                    }
                }
                $transf->dt_recebimento_termo = date('Y-m-d');
                $transf->save();
                //Antes de redirecionar grava o resultado no log dos contatos realizados como Autorizao
                (new Relacionamento())->saveContato(31, date('Y-m-d'), $transf->idContrato, 'Log: Transferncia Adicionada');
        
                echo json_encode(array("msg" => "success","id"=>$transf->id));
            } else {
                echo json_encode(array("msg" => "exception","id"=>$transf->id));
            }
        }
    }

    public function findPessoasAssociadasAction()
    {
        $response = '';
        $pessoasRelacionadas = ContratoPessoa::findByContrato($_POST['contrato']);
        $contrato = Contrato::findById($_POST['contrato']);
        $response['cedente'] = $contrato['id_pessoa'];

        if (is_array($pessoasRelacionadas) && count($pessoasRelacionadas)) {
            foreach ($pessoasRelacionadas as $pessoa) {
                $response['pessoas'] .= '<li>' . utf8_encode(Pessoa::findNomeById($pessoa['id_pessoa'])) . '</li>';
            }
        }

        echo json_encode($response);
    }

    public function findPessoaAction() 
    {
        $pessoaEnvolvida = new ContratoPessoa();
        $pessoas_envolvidas = $pessoaEnvolvida->getDefaultAdapter()->select()
            ->from(array('p' => TB_PESSOA), array('nm_pessoa'))
            ->where('p.id =' . $_POST['pessoa'])
            ->query()->fetchAll();

        echo json_encode(array('pessoa' => utf8_encode($pessoas_envolvidas[0]['nm_pessoa'])));
    }

    public function findDadosParcelasAction()
    {
        $tb_parcelas = new Parcela();
        $data = Helper::getInputDate($_POST['data']);
        //busca as parcelas restantes
        $parcelas = $tb_parcelas->select()
            ->distinct()
            ->from(TB_PARCELA, array('tp_parcela','total' => '(count(tp_parcela))'))
            ->where("pago = '0'")
            ->where("tp_parcela IN ('N','S','I','C','G')")
            ->where("dt_parcela > '{$data}' and id_contrato = {$_POST['contrato']}")
            ->group('tp_parcela')
            ->query()->fetchAll();

        $auxParcelas = array();
        foreach($parcelas as $tipo){
            $auxParcelas[$tipo['tp_parcela']] = $tipo['total'];
        }

        echo json_encode($auxParcelas);
    }

    public function loteClienteByEmpreendimentoAction()
    {
        $contratos = Contrato::byEmpreendimento($_POST['id_empreendimento'], Contrato::CONTRATO_TODOS, 0, array("nm_pessoa", "lote", "quadra", "id"), true);

        $lista = array();
        foreach ($contratos as $contrato) {
            $lista[] = array('id' => $contrato['id'], 'text' => utf8_encode($contrato['nm_pessoa']) . ' - Quadra: ' . utf8_encode($contrato['quadra']) . ' Lote: ' . utf8_encode($contrato['lote']) . ' - Contrato: '.$contrato['id']);
        }

        echo json_encode($lista);
    }

    public function cancelarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'cancelarTransferenciaTitularidade')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'transferencia', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
            exit;
        }

        $tbTransferencia = new Transferencia();
        $tbCessionario = new TransferenciaCessionarios();
        $tbContratoPessoa = new ContratoPessoa();
        $tbCedentes = new TransferenciaCedentes();
        $tbRemessasItens = new RemessaItens();

        $transferencia = $tbTransferencia->fetchRow('id = ' . $_GET['id'])->toArray();
        $cedentesContrato = $tbCedentes->fetchAll('id_transferencia = ' . $transferencia['id'])->toArray();

        if($cedentesContrato){
            $cedParticipacao = 0;
            foreach($cedentesContrato as $key => $cedente){
                $cedParticipacao =+  $cedente['porcentagem_participacao_contrato'];
            }
            $participacao = 100 - $cedParticipacao;
        }else{
            $participacao = 100;
        }
        $tbContratoPessoa->delete('id_contrato = ' . $transferencia['idContrato']);
        
        $db = Zend_Db_Table::getDefaultAdapter();
        $db->beginTransaction();

        $saveLote = array(
            'id_pessoa' => $transferencia['idCedente']
        );
        $saveParticipacao = array(
            'porcentagem_participacao_contrato' => $participacao
        );
        
        $db->update(TB_CONTRATO, $saveLote, 'id = ' . $transferencia['idContrato']);
        $db->update(TB_CONTRATO, $saveParticipacao, 'id = ' . $transferencia['idContrato']);
        $db->commit();

        $remessas_itens = $tbRemessasItens->fetchAll('id_contrato = ' . $transferencia['idContrato']);

        if ($remessas_itens) {
            foreach ($remessas_itens as $remessa_item) {
                $remessa_item_update = $tbRemessasItens->fetchRow('id_remessa_itens = ' . $remessa_item->id_remessa_itens);
                $remessa_item_update->id_pessoa = $transferencia['idCedente'];
                $remessa_item_update->save();
            }
        }
        
        try {
            foreach ($cedentesContrato as $key => $cedente) {
                $ced[$key] = $tbContratoPessoa->createRow();
                $ced[$key]->id_contrato = $transferencia['idContrato'];
                $ced[$key]->id_pessoa = $cedente['id_pessoa'];
                $ced[$key]->porcentagem_participacao_contrato = $cedente['porcentagem_participacao_contrato'];
                $ced[$key]->save();
            }
        } catch (Exception $e) {
            $this->redir(array("modulo" => "adm", "controller" => "transferencia", "action" => "listar"), array("msg" => "exception"));
        }
        $transfer = $tbTransferencia->fetchRow('id = ' . $_GET['id']);
        $tbCessionario->delete('id_transferencia = ' . $_GET['id']);
        $tbTransferencia->delete('id = ' . $_GET['id']);
        $tbCedentes->delete('id_transferencia = ' . $transferencia['id']);
        if($transfer['dt_recebimento_termo']){
            //Antes de redirecionar grava o resultado no log dos contatos realizados como Transferencia de Lotes.
            (new Relacionamento())->saveContato(65, date('Y-m-d'), $transferencia['idContrato'], 'Log: Transferncia Cancelada');
        }
        $this->redir(array("modulo" => "adm", "controller" => "transferencia", "action" => "listar"), array("msg" => "success"));
    }
}