<?php

class RelacionamentoLoteController extends Controller
{
    public function __construct($request)
    {
        parent::__construct($request);
        $this->tbRelacionamento = new Relacionamento();

    }

    public function indexAction()
    {
        $this->redirect(array('modulo' => 'adm', 'controller' => 'relacionamentoLote', 'action' => 'listar'));
    }
    
    public function listarAction()
    {
        $lotes = $this->tbRelacionamento->getDefaultAdapter()->select()
        ->from(['r' => TB_RELACIONAMENTO], ['assunto'])
        ->join(['c' => TB_CONTRATO], 'c.id = r.idContrato', '')
        ->join(['l' => TB_LOTES], 'c.id_lote = l.id', ['id', 'quadra', 'lote'])
        ->join(['e' => TB_EMPREENDIMENTO], 'l.id_empreendimento = e.id', ['nm_empreendimento'])
        ->where("r.agr_idStatus IN ('19', '66', '31', '26', '44', '40', '70', '49', '54')")
        ->group('l.id')
        ->query()->fetchAll();

        $lotesR = $this->tbRelacionamento->getDefaultAdapter()->select()
        ->from(['r' => TB_RELACIONAMENTO], ['assunto', 'idContrato'])
        ->join(['l' => TB_LOTES], 'r.idContrato = l.id', ['id', 'quadra', 'lote'])
        ->join(['e' => TB_EMPREENDIMENTO], 'l.id_empreendimento = e.id', ['nm_empreendimento'])
        ->where("r.agr_idStatus IN ('250', '251', '252', '253')")
        ->group('l.id')
        ->query()->fetchAll();

        $this->set('lotes', $lotes);
        $this->set('lotesR', $lotesR);
        $this->display('listar');
    }

    public function formAction()
    {
        $lotes = $this->tbRelacionamento->getDefaultAdapter()->select()
        ->from(['r' => TB_RELACIONAMENTO], ['assunto', 'data', 'log', 'idContrato'])
        ->join(['c' => TB_CONTRATO], 'c.id = r.idContrato', '')
        ->join(['l' => TB_LOTES], 'c.id_lote = l.id', ['id', 'quadra', 'lote'])
        ->join(['e' => TB_EMPREENDIMENTO], 'l.id_empreendimento = e.id', ['nm_empreendimento'])
        ->join(['p' => TB_PESSOA], 'p.id = r.usuario', ['nm_pessoa'])
        ->where("r.agr_idStatus IN ('19', '66', '31', '26', '44', '40', '70', '49', '54')")
        ->where("l.id = {$_GET['id']}")
        ->order('data DESC')
        ->query()->fetchAll();

        $lotesR = $this->tbRelacionamento->getDefaultAdapter()->select()
        ->from(['r' => TB_RELACIONAMENTO], ['assunto', 'data', 'log', 'idContrato'])
        ->join(['l' => TB_LOTES], 'r.idContrato = l.id', ['id', 'quadra', 'lote'])
        ->join(['e' => TB_EMPREENDIMENTO], 'l.id_empreendimento = e.id', ['nm_empreendimento'])
        ->join(['p' => TB_PESSOA], 'p.id = r.usuario', ['nm_pessoa'])
        ->where("r.agr_idStatus IN ('250', '251', '252', '253')")
        ->where("l.id = {$_GET['id']}")
        ->order('data DESC')
        ->query()->fetchAll();

        foreach ($lotes as &$lote) {
            preg_match('(\d{2}:\d{2}:\d{2})', $lote['log'], $horaContato); //Retira a hora do log
            $lote['hora'] = $horaContato[0]; //Incrementa hora no array
        }
        foreach ($lotesR as &$loteR) {
            preg_match('(\d{2}:\d{2}:\d{2})', $loteR['log'], $horaContato); //Retira a hora do log
            $loteR['hora'] = $horaContato[0]; //Incrementa hora no array
        }

        $this->set('lotes', $lotes);
        $this->set('lotesR', $lotesR);
        $this->display('form');
    }
}
