<?php

class RelacionamentoController extends Controller
{
    private $TB_RELACIONAMENTO;

    public function __construct($request)
    {

        parent::__construct($request);

        $this->empreendimento = new Empreendimento();
        $this->TB_RELACIONAMENTO = new Relacionamento();
    }

    public function indexAction()
    {
        $this->redirect(array('modulo' => 'adm', 'controller' => 'relacionamento', 'action' => 'listar'));
    }

    public function listarAction()
    {

        if ($this->isAjax()) {

            $listaContato = Relacionamento::findListaContatos($_POST);
            
            if (count($listaContato) > 0) {
                foreach ($listaContato as $contato) {
                    $cor = '';
                    if ($contato['fl_aprovar_contrato'] == 0) {
                        $cor = 'style="color:red;"';
                    }

                    $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                    $acoes .= '<a href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=editar&id=' . $contato['id'] . '" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
                    $acoes .= '</div>';

                    $lista[] = array(
                        'empreendimento' => '<div ' . $cor . ' >' . utf8_encode($contato['nm_empreendimento']) . '</div>',
                        'quadra' => '<div align="center" ' . $cor . ' >' . utf8_encode($contato['quadra']) . '</div>',
                        'lote' => '<div align="center" ' . $cor . ' >' . utf8_encode($contato['lote']) . '</div>',
                        'contrato' => '<div align="center" ' . $cor . ' >' . $contato['id'] . '</div>',
                        'pessoa' => '<div ' . $cor . ' >' . utf8_encode($contato['nm_pessoa']) . '</div>',
                        'cpfCnpj' => '<div ' . $cor . ' >' . $contato['nr_cpf'] . $contato['nr_cnpj'] . '</div>',
                        'acoes' => '<div ' . $cor . ' >' . utf8_encode($acoes) . '</div>'
                    );
                }

                echo json_encode(array(
                    'draw' => $_POST['draw'],
                    'data' => $lista
                ));
            } else {
                echo json_encode(array('draw' => 0,
                    'recordsTotal' => 0,
                    'recordsFiltered' => 0,
                    'data' => array()));
            }

        } else {
            $this->display('listar');
        }

    }

    public function adicionarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'adicionarRelacionamento')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'relacionamento', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $this->set("subtitulo", "Relacionamento");
        $this->set('back', $this->_helper->getLink(array('m' => 'adm', 'c' => 'relacionamento', 'a' => 'index')));
        $this->set("status", Db_TabelaAgrupada::findByField("idTabela", Db_TabelaAgrupada::TABLE_STATUS_CONTATO, "descricao"));
        $empreendimentos = $this->empreendimento->getDefaultAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO));
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {
            }
        }

        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();
        $this->set('empreendimentos', $empreendimentos);

        if ($this->_isPost) {
            if ($this->validar()) {
                $TB_RELACIONAMENTO = new Relacionamento();
                if ($_POST["tipoContato"] == "I") { // insere individual
                    $contato = $TB_RELACIONAMENTO->createRow();
                    $contato->idContrato = $_POST['idContrato'][0];
                    $contato->data = Helper::getInputDate($_POST['data']);
                    $contato->agr_idStatus = $_POST['agr_idStatus'];
                    $contato->assunto = $_POST['assunto'];
                    $contato->usuario = Login::getUsuario()->getId();
                    $contato->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                    if ($_POST['dt_retorno']) {
                        $contato->fl_encerrado = 0;
                        $contato->dt_retorno = Helper::getInputDate($_POST['dt_retorno']);
                    } else {
                        $contato->fl_encerrado = 1;
                        $contato->dt_retorno = null;
                    }
                    $contato->save();
                }
                elseif ($_POST["tipoContato"] == "G") {
                    // insere o mesmo contato pra vrias pessoas
                    if ($_POST["idContrato"][0] == '*') {
                        $contratos = Contrato::byEmpreendimento($_POST['idEmpreendimento'], Contrato::CONTRATO_GERADO, 0, array("nm_pessoa", "lote", "quadra", "id"));
                        foreach ($contratos as $cliente) {
                            $contato = $TB_RELACIONAMENTO->createRow();
                            $contato->idContrato = $cliente['id'];
                            $contato->data = Helper::getInputDate($_POST['data']);
                            $contato->agr_idStatus = $_POST['agr_idStatus'];
                            $contato->assunto = $_POST['assunto'];
                            $contato->usuario = Login::getUsuario()->getId();
                            $contato->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');

                            if ($_POST['dt_retorno']) {
                                $contato->fl_encerrado = 0;
                                $contato->dt_retorno = Helper::getInputDate($_POST['dt_retorno']);
                            } else {
                                $contato->fl_encerrado = 1;
                                $contato->dt_retorno = null;
                            }
                            $contato->save();
                        }
                    } else {
                        foreach ($_POST["idContrato"] as $cliente) {
                            $contato = $TB_RELACIONAMENTO->createRow();
                            $contato->idContrato = $cliente;
                            $contato->data = Helper::getInputDate($_POST['data']);
                            $contato->agr_idStatus = $_POST['agr_idStatus'];
                            $contato->assunto = $_POST['assunto'];
                            $contato->usuario = Login::getUsuario()->getId();
                            $contato->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');

                            if ($_POST['dt_retorno']) {
                                $contato->fl_encerrado = 0;
                                $contato->dt_retorno = Helper::getInputDate($_POST['dt_retorno']);
                            } else {
                                $contato->fl_encerrado = 1;
                                $contato->dt_retorno = null;
                            }
                            $contato->save();
                        }
                    }
                }
                $this->redir(array("modulo" => "adm", "controller" => "relacionamento", "action" => "listar"), array("msg" => "success"));
            }
        }
        $this->display('form');
    }

    public function editarAction()
    {
        //instancia as classes necessrias
        $TB_RELACIONAMENTO = new Relacionamento();
        $adapter = $TB_RELACIONAMENTO->getAdapter();

        $contatos = $TB_RELACIONAMENTO->fetchAll("idContrato = {$_GET["id"]}", array("data DESC", "id DESC"))->toArray();

        foreach ($contatos as $value => $contato) {
            preg_match('(\d{2}:\d{2}:\d{2})', $contato['log'], $horaContato); //Retira a hora do log
            $contatos[$value]['hora'] = $horaContato[0]; //Incrementa hora no array
        }

        if (!$contatos)
            $this->redir(array("modulo" => "adm", "controller" => "relacionamento", 'action' => 'listar'), array("exception" => "O contrato no possui nenhum Relacionamento cadastrado"));

        $this->set("subtitulo", "Relacionamento");
        $this->set('back', $this->_helper->getLink(array('m' => 'adm', 'c' => 'relacionamento', 'a' => 'index')));
        $this->set("status", Db_TabelaAgrupada::findByField("idTabela", Db_TabelaAgrupada::TABLE_STATUS_CONTATO, "descricao"));


        $empreendimentos = $this->empreendimento->getDefaultAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario'] && $_SESSION['usuario']->getPerfilId() == 6) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        $contrato = $adapter->select()
            ->from(array("c" => TB_CONTRATO), "id")
            ->join(array("l" => TB_LOTES), "c.id_lote = l.id", array('id_empreendimento','quadra','lote'))
            ->join(array("p" => TB_PESSOA), "c.id_pessoa = p.id", "nm_pessoa")
            ->where("c.id = {$_GET["id"]}")
            ->query()->fetch();

        $contratosOptions = $this->contrato_by_empreendimentoAction($contrato['id_empreendimento'], $_GET["id"]);

        $this->set("contratos", $contratosOptions);

        $this->set('contrato', $contrato);

        $this->set('empreendimentos', $empreendimentos);

        $this->set("historicos", $contatos);

        if ($this->_isPost) {
            if ($this->validar()) {
                $contato = $TB_RELACIONAMENTO->fetchRow("id = {$contatos[0]["id"]}");
                $contato->agr_idStatus = $_POST['agr_idStatus'];
                $contato->data = $this->_helper->filters($_POST['data'], 'date');
                if ($_POST['dt_retorno']) {
                    $contato->fl_encerrado = 0;
                    $contato->dt_retorno = Helper::getInputDate($_POST['dt_retorno']);
                } else {
                    $contato->fl_encerrado = 1;
                    $contato->dt_retorno = null;
                }
                $contato->usuario = Login::getUsuario()->getId();
                $contato->assunto = $this->_helper->filters($_POST['assunto']);
                $contato->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                $contato->save();
                $this->redir(array("modulo" => "adm", "controller" => "relacionamento", "action" => "listar"), array("msg" => "success"));
            } else {
                if ($_POST['idContrato']) {
                    $contrato = $adapter->select()->from(array("c" => TB_CONTRATO), "id")
                        ->join(array("l" => TB_LOTES), "c.id_lote = l.id", "id_empreendimento")
                        ->join(array("p" => TB_PESSOA), "c.id_pessoa = p.id", array("cliente" => "nm_pessoa"))
                        ->where("c.id = {$_POST['idContrato']}")->query()->fetch();

                    //utiliza o metodo post para chamar a rotina ajax de contratos por empreendimento
                    $_POST['id_empreendimento'] = $contrato['id_empreendimento'];
                    $_POST['id_contrato'] = $contato['idContrato'];
                    $contratosOptions = $this->contrato_by_empreendimentoAction();
                    $this->set("contratos", $contratosOptions);
                }
                $this->set("contato", $_POST);
            }
        }

        $this->display('form');
    }

    public function pesquisarAction($filtro = false)
    {

        $termo = "'%" . Helper::getInputDate(strtoupper($_GET['termo'])) . "%'";

        $where = 'CONCAT(UPPER(c.data)," ",UPPER(idContrato)," ",UPPER(p.nm_pessoa)," ",UPPER(agr.descricao)) LIKE ' . $termo . ' OR DAY(c.data) = ' . $termo . ' OR MONTH(c.data) = ' . $termo . ' OR YEAR(c.data) = ' . $termo;

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $where .= " AND e.id IN({$id})";
                }
            } catch (Exception $e) {
            }
        }

        $contatos = Relacionamento::getListaContatos($where);

        $this->set("botoes", array("Adicionar" => array("m" => "adm", "c" => "relacionamento", "a" => "adicionar")));

        /* Seta as opes do paginador */
        $pager_options = array(
            'mode' => 'Sliding', // Sliding or Jumping mode. See below.
            'perPage' => 10, // Total rows to show per page
            'delta' => 4, // See below
            'totalItems' => count($contatos),
        );

        /* Instancia o paginador */
        $pager = Pager::factory($pager_options);
        /* The following code will retreive the result using the pager options */

        /* Seta o offset para colocar na query */
        list($from, $to) = $pager->getOffsetByPageId();

        /* Ajuste para MySQL que comea o offset com 0 */
        $from = $from - 1;

        /* A quanditade de linhas por query */
        $perPage = $pager_options['perPage'];

        $contatos = Relacionamento::getListaContatos($where, $perPage, $from);

        $this->set("action", array("m" => "adm", "c" => "relacionamento", "a" => "pesquisar"));
        $this->set("subtitulo", "Relacionamento");
        $this->set("contatos", $contatos);
        $this->set('paginacao', $pager->links);
        $this->display("listar");
    }


    /**
     * funo para equisio ajax, popula o combo de contratos por empreendimento
     */
    public function contrato_by_empreendimentoAction($idEmpreendimento = false, $idContrato = false)
    {
        $empreedimento = ($idEmpreendimento) ? $idEmpreendimento : $_POST['id_empreendimento'];
        $idContrato = ($idContrato) ? $idContrato : $_POST["id_contrato"];

        $contratos = Contrato::byEmpreendimento($empreedimento, Contrato::CONTRATO_TODOS, 2, array("nm_pessoa", "lote", "quadra", "id"));

        $lote = new Lote();
        $saida = '';
        if (count($contratos) > 0) {
            foreach ($contratos as $contrato) {
                $lot = $lote->find($contrato['id_lote'])->current();
                $selected = "";
                if ($idContrato == $contrato['id']) {
                    $selected = "selected";
                }
                $cor = '';
                if ($contrato['fl_distrato'] == '1') {
                    $cor = "style='color: red'";
                }
                $saida .= "<option " . $cor . " value='{$contrato['id']}' $selected >" . utf8_encode($contrato['nm_pessoa']) . ' - Quadra: ' . utf8_encode($lot['quadra']) . ' - Lote: ' . utf8_encode($lot['lote']) . ' - Contrato: ' . $contrato['id']."</option>";
            }
        }
        if ($idContrato) {
            return $saida;
        }
        echo $saida;
    }


    public function contratoEmpreendimentoAction()
    {
        $contratos = Contrato::byEmpreendimento($_POST['id_empreendimento'], Contrato::CONTRATO_TODOS, 2, array("nm_pessoa", "lote", "quadra", "id"));

        $lista = array();
        $lista[] = array('id' => '', 'text' => '');

        if ($_POST['tipoContato'] == 'G')
            $lista[] = array('id' => '*', 'text' => 'Todos');

        foreach ($contratos as $contrato) {
            if ($contrato['fl_distrato'] == '1')
                $color = 'color: red;';
            else
                $color = null;

            $lista[] = array(
                'id' => $contrato['id'],
                'text' => utf8_encode($contrato['nm_pessoa']) . ' - Quadra: ' . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']) . ' - Contrato: ' . $contrato['id'],
                'estilo' => $color
            );

        }

        echo json_encode(($lista));
    }

    /**
     * funo para equisio ajax, exibe o cliente do contrato
     */
    public function cliente_by_contratoAction()
    {

        $tb_contrato = new Contrato();
        $contrato = $tb_contrato->fetchRow("id = {$_POST["id_contrato"]}")->toArray();
        $pessoa = Db_Pessoa::find($contrato['id_pessoa']);
        if ($pessoa) {
            echo utf8_encode($pessoa->getNome());
        }
    }

    /**
     * funo para equisio ajax, uma lista de historico de contatos com o cliente
     */
    public function lista_historicoAction()
    {
        $TB_RELACIONAMENTO = new Relacionamento();
        $tb_pessoa = new Pessoa();
        $contatos = $TB_RELACIONAMENTO->fetchAll("idContrato = {$_POST["id_contrato"]}", array("data DESC", "id DESC"))->toArray();
        if (is_array($contatos)) {
            foreach ($contatos as $contato) {
                $data = Helper::getDate($contato['data']);
                $assunto = $contato['assunto'];
                if ($contato['usuario'])
                    $user = $tb_pessoa->fetchRow('id = '. $contato['usuario']);
                $usuario = $user['nm_pessoa'];
                echo ("<div class='historico'>
                        Data: $data<br />
                        Assunto: $assunto<br />
                        Usurio: $usuario<br />
                      </div>
                      <br />");
            }
        }
    }

    public function validar()
    {
        // valida o formulrio de contato Individual(I) ou de edio de contato ($_GET["id"])
        if ($_POST["tipoContato"] == "I" || isset($_GET["id"])) {
            $campos['agr_idStatus'] = 'Selecione a situao';
            if ($_GET['a'] != 'editar') {
                $campos['idContrato'] = 'Selecione o contrato!';
            } else {
                if (!stristr($_POST['assunto'], 'Log')) {
                    $campos['data'] = 'O campo data  obrigatrio.';
                    $campos['assunto'] = 'O campo assunto  obrigatrio.';
                }
            }
        } elseif ($_POST["tipoContato"] == "G") {
            if ($_GET['a'] != 'editar') {
                $campos['idContrato'] = 'Selecione pelo menos um contrato!';
            } else {
                if (!stristr($_POST['assunto'], 'Log')) {
                    $campos['data'] = 'O campo data  obrigatrio.';
                    $campos['agr_idStatus'] = 'Selecione a situao';
                    $campos['assunto'] = 'O campo assunto  obrigatrio.';
                }
            }
        } else {
            $campos['tipoContato'] = 'Selecione o tipo de Contrato!';
        }

        foreach ($campos as $campo => $msg) {
            if ($_POST[$campo] == '') {
                $this->_helper->addMensagem($campo, $msg);
            }
        }
        return !(count($this->_helper->getMensagens()) > 0);
    }

}

?>
