<?php

class RelacionamentoAgendamentoController extends Controller
{
    private $tb_contrato;
    private $tb_empreendimento;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->tb_contrato = new Contrato();
        $this->tb_empreendimento = new Empreendimento();
        $this->dataHora = date("d/m/Y H:i:s", strtotime("now"));
        $this->usuario = Login::getUsuario()->getLogin();
        $this->set("subtitulo", "Relacionamento Agendamento");
        $this->set('nomeTela', "Relacionamento Agendamento");
        $this->tb_relacionamento = new Relacionamento();
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "adm", "controller" => "relacionamentoAgendamento", "action" => "listar"));
    }

    public function listarAction()
    {
        $listaEmpreendimento = $this->tb_empreendimento->getAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('*'));

        //Exibe apenas os empreendimentos os quais o usurio tem acesso
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $listaEmpreendimento->where("e.id IN({$id})");
                } else {
                    $listaEmpreendimento->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $listaEmpreendimento = $listaEmpreendimento->order('e.nm_empreendimento ASC')
            ->query()
            ->fetchAll();

        $this->set('empreendimentos', $listaEmpreendimento);

        $usuarios = Db_Usuario::findLista();
        $listaUsuarios = array();
        foreach ($usuarios as $k => $user) {
            $listaUsuarios[] = Pessoa_Fisica::findDadosPessoaFisica($user->getId());
        }
        $this->set('usuarios', $listaUsuarios);


        if ($this->isAjax()) {

            $lista = array();
            if (isset($_POST['keepIdEmpreendimento'])) {
                $listaCrm = Relacionamento::getRetornoByEmpreendimentoUsuario($_POST['keepIdEmpreendimento'], Login::getUsuario()->getId());

                foreach ($listaCrm as $item) {
                    $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                // Reagendar
                $acoes .=" <a data-target='.modalreagendar' id='link_" . $item['id_contrato'] . "' onClick='reagendar( " . $item['id'] . " )' data-toggle='tooltip' title='REAGENDAR' style='margin-right:5px' class='btn btn-default btn-sm'><i class='fa fa-calendar'></i></a></span>";
                // Encerrar
                $title = "return confirm('Tem certeza que deseja encerrar o Relacionamento Agendamento referente ao contrato "
                    . $item['id_contrato'] . " do Lote " . $item['lote'] . "?')";
                $acoes .= '<a onclick="' . $title . '"  href="index.php?m=' . $this->modulo . '&c=' . $this->controller .
                    '&a=encerrar&id=' . $item['id'] . '&idEmpreendimento=' . $_POST['empreendimento']
                    . '" data-toggle="tooltip" title="ENCERRAR" class="btn btn-default btn-sm" style="margin-right:5px">'
                    . '<i class="fa fa-times"></i></a>';
                $acoes .= '</div></div>';

                    //Para ordenar por data
                    $data = '<div hidden>' . $item['dt_retorno'] . '</div>' . Helper::getDate($item['dt_retorno']);
                    if (Helper::date_diff($item['dt_retorno'], date('Y-m-d')) > 0) {
                        $cor = 'style="color:red"';
                    } else
                        $cor = '';

                    $lista[] = array(
                        'data' => '<div align="center" ' . $cor . '>' . $data . '</div>',
                        'quadra' => '<div align="center" ' . $cor . '>' . utf8_encode($item['quadra']) . '</div>',
                        'lote' => '<div align="center" ' . $cor . '>' . utf8_encode($item['lote']) . '</div>',
                        'contrato' => '<div align="center" ' . $cor . '>' . $item['id_contrato'] . '</div>',
                        'pessoa' => '<div ' . $cor . '>' . utf8_encode($item['nm_pessoa']) . '</div>',
                        'assunto' => '<div ' . $cor . '>' . utf8_encode($item['assunto']) . '</div>',
                        'acoes' => $acoes
                    );
                }
            }

            echo json_encode(array(
                'draw' => 1,
                'recordsTotal' => count($lista),
                'recordsFiltered' => count($lista),
                'data' => $lista
            ));

        } else {
            $this->display('listar');
        }
    }

    public function encerrarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'encerrarAgendamento')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'relacionamentoAgendamento', 'action' => 'listar'), array('msg' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
            exit;
        }

        if ($this->_isGet) {
            $id = (int)$_GET["id"];

            try {
                //altera a flag de distrato na tabela de contrato
                $TB_RELACIONAMENTO = new Relacionamento();
                $contato = $TB_RELACIONAMENTO->fetchRow('id = ' . $id);
                $contato->fl_encerrado = '1';
                $contato->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - e');
                $contato->save();

                //Antes de redirecionar grava o resultado no log dos contatos realizados como contato encerrado.
                (new Relacionamento())->saveContato(52, date('Y-m-d'), $contato->idContrato, 'Log: Contato Encerrado.');

                $this->redir(array("modulo" => "adm", "controller" => "relacionamentoAgendamento", 'action' => 'listar'), array("msg" => "success", 'idEmpreendimento' => $_GET['idEmpreendimento']));
            } catch (Exception $e) {
                $this->redir(array("modulo" => "adm", "controller" => "relacionamentoAgendamento", 'action' => 'listar'), array("exception" => $e->getMessage()));
            }
        }
    }

    public function reagendamentosalvarAction()
    {

        if ($this->_isGet) {
            $id = (int)$_GET["id"];
            $dt_reagendar = Helper::getInputDate($_GET["novaData"]);
            try {
                $TB_RELACIONAMENTO = new Relacionamento();
                $contato = $TB_RELACIONAMENTO->fetchRow('id = ' . $id);
                
                (new Relacionamento())->saveContato(52, date('Y-m-d'), $contato->idContrato, 'Log: Alterado retorno do contato de ' . Helper::getDate($contato->dt_retorno) . ' para ' . Helper::getDate($dt_reagendar)) . '.';
                $contato->dt_retorno = $dt_reagendar;
                $contato->save();
                $this->redir(array("modulo" => "adm", "controller" => "relacionamentoAgendamento", 'action' => 'listar'), array("msg" => "success", 'idEmpreendimento' => $_GET['idEmpreendimento']));
            } catch (Exception $e) {
                $this->redir(array("modulo" => "adm", "controller" => "relacionamentoAgendamento", 'action' => 'listar'), array("exception" => $e->getMessage()));
            }
        }
    }
    public function reagendarAction()
    {
        $dadosAgendamento = $this -> tb_relacionamento->getDefaultAdapter()->select()
            ->from(['r'=> TB_RELACIONAMENTO],'*')
            ->join(['co' =>  TB_CONTRATO], 'co.id = r.idContrato', ['id_contrato'=>'id'])
            ->join(['pe'=>TB_PESSOA], 'co.id_pessoa = pe.id', 'nm_pessoa')
            ->join(['lo' =>  TB_LOTES], 'lo.id = co.id_lote', ['quadra','lote'])
            ->where('r.id ='. $_GET['id'])
            ->query()->fetch();

        $dadosAgendamento['dt_retorno'] = Helper::getDate($dadosAgendamento['dt_retorno']);
        echo json_encode([
            'data' => $dadosAgendamento
        ]);
    }

    public function crmByEmpreendimentoAction()
    {
        $listaCrm = Relacionamento::getRetornoByEmpreendimentoUsuario($_POST['empreendimento'], $_POST['usuario']);

        $lista = array();
        if (count($listaCrm) > 0) {
            foreach ($listaCrm as $item) {
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                // Reagendar
                $acoes .=" <a data-target='.modalreagendar' id='link_" . $item['id_contrato'] . "' onClick='reagendar( " . $item['id'] . " )' data-toggle='tooltip' title='REAGENDAR' style='margin-right:5px' class='btn btn-default btn-sm'><i class='fa fa-calendar'></i></a></span>";
            
                $title = "return confirm('Tem certeza que deseja encerrar o Relacionamento Agendamento referente ao contrato "
                    . $item['id_contrato'] . " do Lote " . $item['lote'] . "?')";
                // Encerrar
                $acoes .= '<a onclick="' . $title . '"  href="index.php?m=' . $this->modulo . '&c=' . $this->controller .
                    '&a=encerrar&id=' . $item['id'] . '&idEmpreendimento=' . $_POST['empreendimento']
                    . '" data-toggle="tooltip" title="ENCERRAR" class="btn btn-default btn-sm" style="margin-right:5px">'
                    . '<i class="fa fa-times"></i></a>';
                $acoes .= '</div></div>';

                //Para ordenar por data
                $data = '<div hidden>' . $item['dt_retorno'] . '</div>' . Helper::getDate($item['dt_retorno']);
                if (Helper::date_diff($item['dt_retorno'], date('Y-m-d')) > 0) {
                    $cor = 'style="color:red"';
                } else
                    $cor = '';

                $lista[] = array(
                    'data' => '<div align="center" ' . $cor . '>' . $data . '</div>',
                    'quadra' => '<div align="center" ' . $cor . '>' . utf8_encode($item['quadra']) . '</div>',
                    'lote' => '<div align="center" ' . $cor . '>' . utf8_encode($item['lote']) . '</div>',
                    'contrato' => '<div align="center" ' . $cor . '>' . $item['id_contrato'] . '</div>',
                    'pessoa' => '<div ' . $cor . '>' . utf8_encode($item['nm_pessoa']) . '</div>',
                    'assunto' => '<div ' . $cor . '>' . utf8_encode($item['assunto']) . '</div>',
                    'acoes' => $acoes
                );
            }
            echo json_encode(array('draw' => 1,
                'recordsTotal' => count($lista),
                'recordsFiltered' => count($lista),
                'data' => $lista));
        } else {
            echo json_encode(array('draw' => 0,
                'recordsTotal' => 0,
                'recordsFiltered' => 0,
                'data' => array()));
        }
    }

}
