<?php

class RelEmpreendimentoController extends Controller
{
    private $TB_RELACIONAMENTO;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->empreendimento = new Empreendimento();
        $this->TB_RELACIONAMENTO = new RelEmpreendimento();
    }
    public function indexAction()
    {
        $this->redirect(array('modulo' => 'adm', 'controller' => 'relEmpreendimento', 'action' => 'listar'));
    }
    public function listarAction() 
    {
        $lista = [];
        if ($this->isAjax()) {
            $listaContato = RelEmpreendimento::findListaContatos($_POST);
            
            if (count($listaContato) > 0) {
                foreach ($listaContato as $key => $contato) {
                    $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                    $acoes .= '<a href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=editar&id=' . $contato['id'] . '" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
                    $acoes .= '</div>';
                    $lista[] = array(
                        'empreendimento' => '<div>' . utf8_encode($contato['nm_empreendimento']) . '</div>',
                        'acoes' => '<div>' . utf8_encode($acoes) . '</div>'
                    );                 
                }
            }
            echo json_encode(array(
                'draw' => $_POST['draw'],            
                'data' => $lista
            ));
        }
        else {
            $this->display('listar');
        }

    }
    
    public function adicionarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'adicionarRelEmpreendimento')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'relEmpreendimento', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $this->set("subtitulo", "Relacionamento Empreendimento");
        $this->set('back', $this->_helper->getLink(array('m' => 'adm', 'c' => 'relEmpreendimento', 'a' => 'index')));
        $this->set("status", Db_TabelaAgrupada::findByField("idTabela", Db_TabelaAgrupada::TABLE_STATUS_CONTATO_EMP, "descricao"));
        
        $empreendimentos = $this->empreendimento->getDefaultAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO));
        
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {
            }
        }

        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        $this->set('empreendimentos', $empreendimentos);
        
        if ($this->_isPost) {
            
            $TB_RELACIONAMENTO = new RelEmpreendimento();
            

            // insere o mesmo contato pra vrias pessoas
            if ($_POST["idEmpreendimento"][0] == '*') {
                $contratos = Contrato::byEmpreendimento($_POST['idEmpreendimento'], Contrato::CONTRATO_GERADO, 0, array("nm_pessoa", "lote", "quadra", "id"));
                foreach ($contratos as $cliente) {
                    $contato = $TB_RELACIONAMENTO->createRow();
                    $contato->id_empreendimento = $_POST['idEmpreendimento'][0];
                    $contato->data = Helper::getInputDate($_POST['data']);
                    $contato->agr_idStatus = $_POST['agr_idStatus'];
                    $contato->assunto = $_POST['assunto'];
                    $contato->usuario = Login::getUsuario()->getId();
                    $contato->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');

                    if ($_POST['dt_retorno']) {
                        $contato->fl_encerrado = 0;
                        $contato->dt_retorno = Helper::getInputDate($_POST['dt_retorno']);
                    } else {
                        $contato->fl_encerrado = 1;
                        $contato->dt_retorno = null;
                    }
                    $contato->save();
                }
            }           
            else {                
                foreach ($_POST["idEmpreendimento"] as $cliente) {
                    $contato = $TB_RELACIONAMENTO->createRow();
                    $contato->id_empreendimento = $cliente;
                    $contato->data = Helper::getInputDate($_POST['data']);
                    $contato->agr_idStatus = $_POST['agr_idStatus'];
                    $contato->assunto = $_POST['assunto'];
                    $contato->usuario = Login::getUsuario()->getId();
                    $contato->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');

                    if ($_POST['dt_retorno']) {
                        $contato->fl_encerrado = 0;
                        $contato->dt_retorno = Helper::getInputDate($_POST['dt_retorno']);
                    } else {
                        $contato->fl_encerrado = 1;
                        $contato->dt_retorno = null;
                    }
                    $contato->save();
                }
            }
            
            $this->redir(array("modulo" => "adm", "controller" => "relEmpreendimento", "action" => "listar"), array("msg" => "success"));
        
        }

        $this->display('form');

    }

    public function lista_historicoAction()
    {
        $TB_RELACIONAMENTO = new RelEmpreendimento();
        $tb_pessoa = new Pessoa();
        $contatos = $TB_RELACIONAMENTO->fetchAll("id_empreendimento = {$_POST["idEmpreendimento"]}", array("data DESC", "id DESC"))->toArray();
        if (is_array($contatos)) {
            foreach ($contatos as $contato) {
                $data = Helper::getDate($contato['data']);
                $assunto = $contato['assunto'];
                if ($contato['usuario'])
                    $user = $tb_pessoa->fetchRow('id = '. $contato['usuario']);
                $usuario = $user['nm_pessoa'];
                echo utf8_encode("<div class='historico'>
                        Data: $data<br />
                        Assunto: $assunto<br />
                        Usu�rio: $usuario<br />
                      </div>
                      <br />");
            }
        }
    }

    public function editarAction()
    {
        //instancia as classes necessrias
        $TB_RELACIONAMENTO = new RelEmpreendimento();
        $TB_EMPREENDIMENTO = new Empreendimento();
        $adapter = $TB_RELACIONAMENTO->getAdapter();

        $contatos = $TB_RELACIONAMENTO->fetchAll("id_empreendimento = {$_GET["id"]}", array("data DESC", "id DESC"))->toArray();

        foreach ($contatos as $value => $contato) {
            preg_match('(\d{2}:\d{2}:\d{2})', $contato['log'], $horaContato); //Retira a hora do log
            $contatos[$value]['hora'] = $horaContato[0]; //Incrementa hora no array
        }

        if (!$contatos)
            $this->redir(array("modulo" => "adm", "controller" => "relEmpreendimento", 'action' => 'listar'), array("exception" => "O empreendimento no possui nenhum Relacionamento cadastrado"));

        $this->set("subtitulo", "Relacionamento Empreendimento");
        $this->set('back', $this->_helper->getLink(array('m' => 'adm', 'c' => 'relEmpreendimento', 'a' => 'index')));
        $this->set("status", Db_TabelaAgrupada::findByField("idTabela", Db_TabelaAgrupada::TABLE_STATUS_CONTATO_EMP, "descricao"));

        $empreendimentos = $this->empreendimento->getDefaultAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario'] && $_SESSION['usuario']->getPerfilId() == 6) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();
        $emp = $TB_EMPREENDIMENTO->fetchRow('id = ' . $_GET["id"] )->toArray();

        $this->set('empreendimentos', $empreendimentos);
        $this->set('empreendimento', $emp);
        $this->set("historicos", $contatos);

        if ($this->_isPost) {
                $contato = $TB_RELACIONAMENTO->fetchRow("id = {$contatos[0]["id"]}");
                $contato->agr_idStatus = $_POST['agr_idStatus'];
                $contato->data = $this->_helper->filters($_POST['data'], 'date');
                if ($_POST['dt_retorno']) {
                    $contato->fl_encerrado = 0;
                    $contato->dt_retorno = Helper::getInputDate($_POST['dt_retorno']);
                } else {
                    $contato->fl_encerrado = 1;
                    $contato->dt_retorno = null;
                }
                $contato->usuario = Login::getUsuario()->getId();
                $contato->assunto = $this->_helper->filters($_POST['assunto']);
                $contato->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                $contato->save();
                $this->redir(array("modulo" => "adm", "controller" => "relEmpreendimento", "action" => "listar"), array("msg" => "success"));
                $this->set("contato", $_POST);
        }

        $this->display('form');
    }

    

}