<?php

class JuridicoController extends Controller
{
    private $tb_contrato;
    private $tb_juridico;
    private $tb_empreendimento;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->tb_contrato = new Contrato();
        $this->tb_juridico = new Juridico();
        $this->tb_empreendimento = new Empreendimento();
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "adm", "controller" => "juridico", "action" => "listar"));
    }

    public function listarAction()
    {
        $listaEmpreendimento = $this->tb_empreendimento->getAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('*'));
        //Exibe apenas os empreendimentos os quais o usurio tem acesso
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $listaEmpreendimento->where("e.id IN({$id})");
                } else {
                    $listaEmpreendimento->where("1");
                }
            } catch (Exception $e) {
            }
        }
        $listaEmpreendimento = $listaEmpreendimento->order('e.nm_empreendimento ASC')
            ->query()
            ->fetchAll();
        $this->set('empreendimentos', $listaEmpreendimento);

        $this->display('listar');
    }

    public function adicionarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'adicionarJuridico')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'juridico', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $listaEmpreendimento = $this->tb_empreendimento->getAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('*'));

        //Exibe apenas os empreendimentos os quais o usurio tem acesso
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $listaEmpreendimento->where("e.id IN({$id})");
                } else {
                    $listaEmpreendimento->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $listaEmpreendimento = $listaEmpreendimento->order('e.nm_empreendimento ASC')
            ->query()
            ->fetchAll();

        $this->set('listaEmpreendimento', $listaEmpreendimento);
        $this->set('tpAudiencia', Db_TabelaAgrupada::findByTabelaId(18));

        if ($this->_isPost && $this->validar()) {
            try {
                $transacaojuridico = $this->tb_juridico->getAdapter()->beginTransaction();
                $tb_juridico = $this->tb_juridico->createRow();

                if ($_FILES['ds_path_arquivo']) {
                    //Cria os diretorios para onde o arquivo vai ser gravado
                    $up = new Filesystem();
                    $path = explode('.', $_SERVER['HTTP_HOST']);
                    if ($path[0] == 'www') {
                        $path = $path[1];
                    } else {
                        $path = $path[0];
                    }
                    $filepathController = DIRETORIO_DOWNLOAD . $this->controller;
                    $filepath = DIRETORIO_DOWNLOAD . $this->controller . "/" . $path;
                    //Cria as pastas necessarias se nao existirem
                    if (is_dir($filepathController)) {
                        if (!is_dir($filepath)) mkdir($filepath);
                    } else {
                        mkdir($filepathController);
                        mkdir($filepath);
                    }
                    $nomeArquivo = explode('.',$_FILES['ds_path_arquivo']['name']);
                    $nome = $nomeArquivo[0];
                    $ext = end($nomeArquivo);


                    //Move o arquivo para a pasta criada
                    $filename = Helper::removeAcentos($nome) . '_' . date('dHis').'.'.$ext;
                    $up->upload($_FILES['ds_path_arquivo']['tmp_name'], $filepath . '/' . $filename);
                    $tb_juridico->ds_path_arquivo = $filepath . '/' . $filename;
                }

                // Insero em juridico
                $tb_juridico->id_contrato = $this->_helper->filters($_POST['id_contrato']);
                $tb_juridico->id_tipo_audiencia = $this->_helper->filters($_POST["id_tipo_audiencia"]);
                $tb_juridico->fl_tipo = $this->_helper->filters($_POST["fl_tipo"]);
                $tb_juridico->ds_processo = $this->_helper->filters($_POST["ds_processo"]);
                $tb_juridico->ds_local = $this->_helper->filters($_POST["ds_local"]);
                $tb_juridico->dt_notificacao = $this->_helper->filters($this->_helper->getInputDate($_POST["dt_notificacao"]), 'date');
                $tb_juridico->dt_audiencia = $_POST["dt_audiencia"]?$this->_helper->filters($this->_helper->getInputDate(str_replace('_', '', $_POST["dt_audiencia"])), 'date'):NULL;
                $tb_juridico->ds_resumo = $this->_helper->filters($_POST["ds_resumo"]);

                $idJuridico = $tb_juridico->save();

                //Antes de redirecionar grava o resultado no log dos contatos realizados como juridico contratual.
                (new Relacionamento())->saveContato(46, date('Y-m-d'), $_POST['id_contrato'], 'Log: Processo '.$idJuridico.' Cadastrado');

                $transacaojuridico->commit();
                $this->redir(array('modulo' => 'adm', 'controller' => 'juridico', 'action' => 'listar'), array('msg' => 'ok'));

            } catch (Exception $e) {
                $transacaojuridico->rollBack();
                $this->redir(array('modulo' => 'adm', 'controller' => 'juridico', 'action' => 'listar'), array('msg' => 'fail', 'exception' => $e->getMessage()));
            }
        }
        $this->display('form');
    }

    public function editarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'editarJuridico')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'juridico', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $listaEmpreendimento = $this->tb_empreendimento->getAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('*'));

        //Exibe apenas os empreendimentos os quais o usurio tem acesso
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $listaEmpreendimento->where("e.id IN({$id})");
                } else {
                    $listaEmpreendimento->where("1");
                }
            } catch (Exception $e) {
            }
        }
        $listaEmpreendimento = $listaEmpreendimento->order('e.nm_empreendimento ASC')
            ->query()
            ->fetchAll();

        $processo = $this->tb_juridico->getDados($_GET['id']);
        $contratos = Contrato::byEmpreendimento($processo['id_empreendimento'], Contrato::CONTRATO_TODOS, 2, array("nm_pessoa", "lote", "quadra", "id"), true);

        $this->set('listaEmpreendimento', $listaEmpreendimento);
        $this->set('listaLote', $contratos);
        $this->set('tpAudiencia', Db_TabelaAgrupada::findByTabelaId(18));
        $this->set('processo', $processo);


        if ($this->_isPost && $this->validar()) {
            try {
                $transacaojuridico = $this->tb_juridico->getAdapter()->beginTransaction();
                $tb_juridico = $this->tb_juridico->fetchRow('id_juridico = ' . $_GET['id']);

                //Cria os diretorios para onde o arquivo vai ser gravado
                if ($_FILES['ds_path_arquivo']) {
                    $up = new Filesystem();
                    $up->delete($tb_juridico->ds_path_arquivo);
                    $path = explode('.', $_SERVER['HTTP_HOST']);
                    if ($path[0] == 'www') {
                        $path = $path[1];
                    } else {
                        $path = $path[0];
                    }
                    $filepathController = DIRETORIO_DOWNLOAD . "cliente/" . $path;
                    $filepath = DIRETORIO_DOWNLOAD . "cliente/" . $path . "/juridico";
                    

                    //Cria as pastas necessarias se nao existirem
                    if (is_dir($filepathController)) {
                        if (!is_dir($filepath)) mkdir($filepath);
                    } else {
                        mkdir($filepathController);
                        mkdir($filepath);
                    }
                    $arquivo = explode('.' , $_FILES['ds_path_arquivo']['name']);
                    //Move o arquivo para a pasta criada
                    $filename = Helper::removeAcentos($arquivo[0]) . '_' . date('dHis') . '.' .$arquivo[1];
                    $up->upload($_FILES['ds_path_arquivo']['tmp_name'], $filepath . '/' . $filename);
                    $tb_juridico->ds_path_arquivo = $filepath . '/' . $filename;
                }

                // Edio em juridico
                $tb_juridico->id_contrato = $_POST['id_contrato'];
                $tb_juridico->id_tipo_audiencia = $_POST["id_tipo_audiencia"];
                $tb_juridico->fl_tipo = $_POST["fl_tipo"];
                $tb_juridico->ds_processo = $_POST["ds_processo"];
                $tb_juridico->ds_local = $_POST["ds_local"];
                $tb_juridico->dt_notificacao = $this->_helper->getInputDate($_POST["dt_notificacao"]);
                $tb_juridico->dt_audiencia =$_POST["dt_audiencia"]?$this->_helper->getInputDate(str_replace('_', '', $_POST["dt_audiencia"])):NULL;
                $tb_juridico->ds_resumo = $_POST["ds_resumo"];

                $tb_juridico->save();

                $transacaojuridico->commit();
                $this->redir(array('modulo' => 'adm', 'controller' => 'juridico', 'action' => 'listar'), array('msg' => 'ok'));
            } catch (Exception $e) {
                $transacaojuridico->rollBack();
                $this->redir(array('modulo' => 'adm', 'controller' => 'juridico', 'action' => 'editar'), array('id' => $_GET['id'], 'msg' => 'fail', 'exception' => $e->getMessage()));
            }
        }
        $this->display('form');
    }

    public function excluirAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'excluirJuridico')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'juridico', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
            exit;
        }

        if ($this->_isGet) {
            try {
                $this->tb_juridico->delete('id_juridico = ' . $this->_helper->filters($_GET['id']));

                //Antes de redirecionar grava o resultado no log dos contatos realizados como juridico contratual.
                (new Relacionamento())->saveContato(46, date('Y-m-d'), $_GET['contrato'], 'Log: Processo '.$_GET['id'].' Encerrado');

                $this->redir(array('modulo' => 'adm', 'controller' => 'juridico', 'action' => 'listar'), array('msg' => 'ok','idEmpreendimento'=>$_GET['idEmpreendimento']));
            } catch (Exception $e) {
                $this->redir(array('modulo' => 'adm', 'controller' => 'juridico', 'action' => 'editar'), array('id' => $_GET['id'], 'msg' => 'fail', 'exception' => $e->getMessage()));
            }
        }
    }

    private function validar()
    {
        $campos = array("id_empreendimento", "id_contrato", "id_tipo_audiencia", "fl_tipo", "dt_notificacao");

        foreach ($campos as $cp) {
            if ($_POST [$cp] == '') {
                switch ($cp) {
                    case "id_empreendimento" :
                        $msg = "O Empreedimento  obrigatrio.";
                        break;
                    case "id_contrato" :
                        $msg = "O Lote  obrigatrio.";
                        break;
                    case "id_tipo_audiencia" :
                        $msg = "O campo Tipo de Audincia  obrigatrio.";
                        break;
                    case "fl_tipo" :
                        $msg = "O campo Processo  obrigatrio.";
                        break;
                    case "dt_notificacao" :
                        $msg = "O campo Data de Notificao  obrigatrio.";
                        break;
                }

                if (!empty($msg))
                    $this->_helper->addMensagem($cp, $msg);
                $msg = '';
            }
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function visualizarAction()
    {
        if ($this->isAjax()) {
            $processo = $this->tb_juridico->getDados($_POST['cdItem']);
            foreach ($processo as $rotulo => &$attr)
                $attr = utf8_encode($attr);
            echo json_encode($processo);
        }
    }

    public function contratoByEmpreendimentoAction()
    {
        $contratos = Contrato::byEmpreendimento($_POST['id_empreendimento'], Contrato::CONTRATO_TODOS, 2, array("nm_pessoa", "lote", "quadra", "id"), true);

        $lista = array();
        foreach ($contratos as $contrato) {
            $lista[] = array('id' => $contrato['id'], 'text' => utf8_encode($contrato['nm_pessoa']) . ' - Quadra: ' . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']) . ' - Contrato: ' . utf8_encode($contrato['id']));
        }

        echo json_encode($lista);
    }

    public function processosByEmpreendimentoAction()
    {
        $lista = array();
        if (isset($_POST['empreendimento']) && $_POST['empreendimento'] != '') {
            $listaJuridico = Juridico::getLista($_POST['empreendimento'], $_POST['tipoContrato']);

            foreach ($listaJuridico as $item) {
                $title = "return confirm('Tem certeza que deseja encerrar o Processo referente ao contrato " . $item['id_contrato'] . "?')";

                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<span data-toggle="modal" data-target=".mVisualizar"><button type="button" value="' . $item['id_juridico'] . '" id="btnVisualizar" data-toggle="tooltip" title="VISUALIZAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-eye"></i> </button></span>';
                $acoes .= '<a href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=editar&id=' . $item['id_juridico'] . '" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
                $acoes .= '<a onclick="' . $title . '"  href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=excluir&id=' . $item['id_juridico'] . '&contrato='.$item['id_contrato'].'&idEmpreendimento='.$_POST['empreendimento'].'" data-toggle="tooltip" title="ENCERRAR PROCESSO" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                if ($item['ds_path_arquivo'])
                    $acoes .= '<a href="' . utf8_encode($item['ds_path_arquivo']) . '" download target="_blank" data-toggle="tooltip" title="DOCUMENTO" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-clipboard"></i></a>';
                else
                    $acoes .= '<a data-toggle="tooltip" title="DOCUMENTO" class="btn btn-default btn-sm disabled" style="margin-right:5px"><i class="fa fa-clipboard"></i></a>';
                $acoes .= '</div></div>';

                //Para ordenar por data e marcar quando a data de audiencia estiver atrasada
                if (!in_array($item['dt_audiencia'], array('0000-00-00', '')))
                    $audiencia = '<div hidden>' . $item['dt_audiencia'] . '</div>' . Helper::getDate($item['dt_audiencia']);
                else
                    $audiencia = '-';
                $notificacao = '<div hidden>' . $item['dt_notificacao'] . '</div>' . Helper::getDate($item['dt_notificacao']);
                if (!in_array($item['dt_audiencia'], array('0000-00-00', '')) && Helper::date_diff($item['dt_audiencia'], date('Y-m-d')) >= 0) {
                    $cor = 'style="color:red"';
                } else
                    $cor = '';

                $lista[] = array(
                    'pessoa' => '<div ' . $cor . '>' . utf8_encode($item['nm_pessoa']) . '</div>',
                    'quadra' => '<div align="center" ' . $cor . '>' . utf8_encode($item['quadra']) . '</div>',
                    'lote' => '<div align="center" ' . $cor . '>' . utf8_encode($item['lote']) . '</div>',
                    'contrato' => '<div align="center" ' . $cor . '>' . $item['id_contrato'] . '</div>',
                    'notificacao' => '<div align="center" ' . $cor . '>' . $notificacao . '</div>',
                    'audiencia' => '<div align="center" ' . $cor . '>' . $audiencia . '</div>',
                    'dsLocal' => '<div ' . $cor . '>' . utf8_encode($item['ds_local']) . '</div>',
                    'acoes' => $acoes
                );
            }
        }

        echo json_encode(array(
            'draw' => 1,
            'recordsTotal' => count($lista),
            'recordsFiltered' => count($lista),
            'data' => $lista
        ));
    }

}
