<?php

class DistratoController extends Controller
{

    protected $distrato;
    private $tb_pessoa;
    private $pessoa;
    private $pessoasEnvolvidas;
    private $tb_pessoaFisica;
    private $tb_pessoaJuridica;
    private $tb_lote;
    private $tb_empreendimento;
    private $tb_parcela;
    private $tb_parcelaHistorico;
    private $tb_parcelaDistrato;
    private $tb_contrato;
    private $tb_carta;

    public function __construct($request)
    {
        parent::__construct($request);

        $this->tb_pessoa = new Pessoa();
        $this->pessoa = new Pessoa();
        $this->pessoasEnvolvidas = new ContratoPessoa();
        $this->tb_pessoaFisica = new Pessoa_Fisica();
        $this->tb_pessoaJuridica = new Pessoa_Juridica();
        $this->distrato = new Distrato();
        $this->tb_lote = new Lote();
        $this->tb_empreendimento = new Empreendimento();
        $this->tb_parcela = new Parcela();
        $this->tb_parcelaHistorico = new ParcelaHistorico();
        $this->tb_parcelaDistrato = new ParcelaDistrato();
        $this->tb_contrato = new Contrato();
        $this->tb_carta = new Modelo();
        $this->tb_modeloArquivo = new ModeloArquivo();
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "adm", "controller" => "distrato", "action" => "listar"));
    }

    public function listarAction()
    {
        if ($this->isAjax()) {
            $listaItem = Distrato::findLista($_POST);
            $totalItens = Distrato::findLista($_POST, true);

            $listarPessoasEnvolvidas = array();
            foreach ($listaItem as $k => $pessoa) {
                $pessoas_envolvidas = $this->pessoasEnvolvidas->getDefaultAdapter()->select()
                    ->from(array('c' => TB_CONTRATO), array('c.id', 'c.id_pessoa', 'c.nr_proposta', 'c.porcentagem_participacao_contrato'))
                    ->joinLeft(array('cp' => TB_CONTRATO_PESSOA), 'c.id = cp.id_contrato', array('id_pessoa', 'porcentagem_participacao_contrato'))
                    ->joinLeft(array('p' => TB_PESSOA), 'cp.id_pessoa = p.id', array('nm_pessoa'))
                    ->where('c.id =' . $pessoa['id'])
                    ->query()->fetchAll();

                foreach ($pessoas_envolvidas as $p_envolvidas) {
                    if ($pessoa['id'] == $p_envolvidas['id']) {
                        $listarPessoasEnvolvidas[] = $p_envolvidas['nm_pessoa'];
                    }
                }
                $listaItem[$k]['pessoasEnvolvidas'] = $listarPessoasEnvolvidas;
                $listarPessoasEnvolvidas = array();
            }

            //Busca os tipos de cartas cadastrados
            $loCartaCobranca = new Modelo();
            $cartas = $loCartaCobranca->getAdapter()->select()
                ->from(array('co' => TB_MODELO))
                ->where('co.tp_modelo = "CD"')
                ->order('co.cd_modelo')
                ->query()->fetchAll();

            $lista = array();
            foreach ($listaItem as $item) {
                $msgConfirm = ($item['dt_recebimento_termo'])?"Voc� realmente deseja desfazer?":"Voc� realmente deseja confirmar o recebimento do termo assinado?";
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<a href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=editar&id=' . $item['id'] . '" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
                $title = "return confirm('Tem certeza que deseja excluir o contrato " . $item['id'] . " em nome de " . $item['nm_empreendimento'] . " do Lote " . $item['lote'] . "?')";
                $acoes .= '<a onclick="' . $title . '"  href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=deletar&id=' . $item['id'] . '" data-toggle="tooltip" title="DELETAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';

                $title = ($item['dt_recebimento_termo'])?"DESFAZER CONFIRMA��O TERMO ASSINADO":"CONFIRMAR RECEBIMENTO TERMO ASSINADO";
                $alert = "return confirm('".$msgConfirm."')";
                $acoes .= '<a onclick="' . $alert . '" href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=confirmaRecebimento&id=' . $item['id'] . '" data-toggle="tooltip" title="'.$title.'" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-download"></i></a>';

                $acoes .= '</div>';
                $termos = '<div style="display: flex;" class="input-group">';
                $termos .= '<select id="termo_' . $item['id'] . '" class="tipoCarta" > ';
                $termos .= '<option value="">Selecione...</option>';
                foreach ($cartas as $carta) {
                    $termos .= '<option value="' . $carta['cd_modelo'] . '" fileType="' . $carta['tp_carta_distrato'] . '">' . utf8_encode($carta['nm_titulo']) . '</option>';
                }
                $termos .= '</select><span class="input-group-btn">';
                $termos .= '<a target="_blank" id="link_' . $item['id_contrato'] . '" onClick="imprimeWord( ' . $item['id'] . ' )" data-toggle="tooltip" title="IMPRIMIR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-file-o"></i></a></span></div>';
                //Para ordenar por data
                $data = '<div hidden>' . $item['dt_distrato'] . '</div>' . Helper::getDate($item['dt_distrato']);

                $cor = '';
                if ($item['fl_aprovar_contrato'] == 0) {
                    $cor = 'style="color:blue;"';
                }

                if ($item['dt_recebimento_termo']) {
                    $status = '<div style="width: 100%; display: flex; align-items: center; justify-content: center;" id="status_'.$item['id'].'" class="label label-info">Confirmado</div>';
                } else {
                    $status = '<div style="width: 100%; display: flex; align-items: center; justify-content: center;" id="status_'.$item['id'].'" class="label label-warning">Pendente</div>';
                }

                if ($item['pessoasEnvolvidas'][0] == null) {
                    $outros = '';
                } else {
                    $outros = ' / ' . utf8_encode(implode(' / ', $item['pessoasEnvolvidas']));
                }

                if ($item['pessoasEnvolvidas'] == null) {
                    explode(' / ');
                }


                $lista[] = array(
                    'contrato' => '<div style="width: 100%;" align="center" ' . $cor . '  >' . $item['id_contrato'] . '</div>',
                    'empreendimento' => '<div style="width:" 100%; ' . $cor . ' >' . utf8_encode($item['nm_empreendimento']) . '</div>',
                    'quadra' => '<div style="width: 100%;" align="center" ' . $cor . ' >' . utf8_encode($item['quadra']) . '</div>',
                    'lote' => '<div style="width: 100%;" align="center" ' . $cor . ' >' . utf8_encode($item['lote']) . '</div>',
                    'pessoa' => '<div style="width: 100%;" ' . $cor . ' >' . utf8_encode($item['nm_pessoa']) . $outros . '</div>',
                    'data' => '<div style="width: 100%;" align="center" align="center">' . $data . '</div>',
                    'termos' => $termos,
                    'status' => $status,
                    'acoes' => utf8_encode($acoes)
                );
            }

            echo json_encode(array(
                'draw' => $_POST['draw'],
                'recordsTotal' => count($totalItens),
                'recordsFiltered' => count($totalItens),
                'data' => $lista
            ));

        } else {
            $this->display('listar');
        }
    }

    //adicionar o distrato e calcular parcelas para devolucao caso necessario
    public function adicionarAction()
    {
        $empreendimentos = $this->tb_empreendimento->getAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {
            }
        }

        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        $this->set('empreendimentos', $empreendimentos);

        $banco = new Banco();
        $bancos = $banco->getAdapter()->select()->from(TB_AGRUPADA)->where('idTabela = ' . Db_TabelaAgrupada::TABLE_BANCO)->order('descricao ASC')->query()->fetchAll();

        $this->set('bancos', $bancos);

        $motivos = Db_TabelaAgrupada::findByTabelaId(20);
        $this->set('motivoDistrato', $motivos);

        //validacao de acesso
        if ($this->_isPost && $this->validar()) {
            $idContrato = $_POST['id_contrato'];
            // Vamos iniciar uma transacao com o banco dados, ou seja, tudo ou nada.
            $db = Zend_Db_Table::getDefaultAdapter();
            $db->beginTransaction();
            try {
                $contrato = $this->tb_contrato->getAdapter()->select()
                    ->from(array("p" => TB_PARCELA), array("pagas" => "SUM(vl_parcela)", "desconto" => "SUM(desconto)"))
                    ->where("id_contrato = $idContrato")
                    ->where("tp_parcela != 'A'")
                    ->where("pago = '1'");
                //verifica se vai incluir as parcelas do tipo sinal ou nao
                if ($_POST['radioSinal'] == 'N') {
                    $contrato = $contrato->where("tp_parcela NOT IN ('S', 'SE')");
                }
                $contrato = $contrato->query()->fetch();

                //Subtrai o valor distrato menos o desconto
                $parcDesconto = $contrato['pagas'] - $contrato['desconto'];

                $empreendimento = Empreendimento::findEmpreendimento($_POST['id_empreendimento']);

                //dados do distrato
                $distrato = $this->distrato->createRow();
                $distrato->id_contrato = $idContrato;
                $distrato->dt_distrato = $this->_helper->filters($_POST["dt_distrato"], 'date');
                $distrato->vl_distrato = $this->_helper->filters($parcDesconto);
                $distrato->tp_distrato = $this->_helper->filters($_POST['tipoDistrato']);
                $distrato->local_assinatura = $this->_helper->filters($_POST["local_assinatura"]);
                $distrato->fl_proprio_favorecido = ($_POST['favorecido'] == '0') ? 1 : 0;
                $distrato->porcAdmin = $empreendimento->porcAdmin;
                $distrato->porcDev = $empreendimento->porcDev;
                $distrato->porcFru = $empreendimento->porcFru;

                //Dados Bancarios
                $cpfCnpjPessoa = $_POST["CPFFavorecido"];

                if ($_POST['tpPessoa'] == 'J')
                    $cpfCnpjPessoa = $_POST['CNPJFavorecido'];

                $distrato->id_banco = $this->_helper->filters($_POST["banco"]);
                $distrato->nm_favorecido = $this->_helper->filters($_POST["nomeFavorecido"]);
                $distrato->nr_cpf_favorecido = $this->_helper->filters($cpfCnpjPessoa);
                $distrato->nr_operacao_banco = $this->_helper->filters($_POST["operacao"]);
                $distrato->nr_agencia_banco = $this->_helper->filters($_POST["agencia"]);
                $distrato->nr_dv_agencia_banco =$this->_helper->filters($_POST["agencia_dv"]);
                $distrato->nr_conta_corrente_banco = $this->_helper->filters($_POST["conta_corrente"]);
                $distrato->nr_dv_conta_corrente_banco = $this->_helper->filters($_POST["conta_corrente_dv"]);
                if ($_POST['banco'] && $_POST['operacao'] && $_POST['tp_conta'] == 'X') {
                    $distrato->tp_conta = ($_POST['tipo_conta']) ? $_POST['tipo_conta'] : null;
                } elseif (!$_POST['banco'] && !$_POST['operacao'] && $_POST['tp_conta'] == 'X') {
                    $distrato->tp_conta = ($_POST['tp_conta']) ? $_POST['tp_conta'] : null;
                } else {
                    $distrato->tp_conta = ($_POST['tipo_conta']) ? $_POST['tipo_conta'] : null;
                }
                $distrato->chave_pix = ($_POST['chavePix']) ? $_POST['chavePix'] : null;
                if ($_POST['chavePix']) {
                    $distrato->tipo_pix = ($_POST['tipo_pix']) ? $_POST['tipo_pix'] : null;
                } else {
                    $distrato->tipo_pix = null;
                }

                $distrato->obs = $this->_helper->filters($_POST["obs"]);
                $distrato->forma_devolucao = $this->_helper->filters($_POST["forma_devolucao"]);
                $distrato->fl_incluir_sinal = ($_POST['radioSinal'] == 'S') ? 1 : 0;
                $distrato->id_motivo = ($_POST['tipoDistrato'] == 'V')?$this->_helper->filters($_POST['dsMotivoDistrato']):null;
                //salva o distrato
                $distrato->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i');
                $distrato->save();

                //seta o contrato com flag de distrato
                $contrato = $this->tb_contrato->fetchRow($this->tb_contrato->select()->where('id = ?', $idContrato));
                $contrato->fl_distrato = 1;
                $listaContrato = $this->tb_contrato->fetchAll("id =" . addslashes($idContrato))->toArray();
                $table = Zend_Db_Table::getDefaultAdapter();

                $tbContratoHistorico = new ContratoHistorico();
                $contratoHistorico = $tbContratoHistorico->fetchRow('id = '.$idContrato);
                if(!$contratoHistorico)
                    foreach ($listaContrato as $c) {
                        // Pegamos o contrato e jogamos no historico.
                        $c["fl_distrato"] = 1;
                        $c["log"] = Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i';
                        $table->insert(TB_CONTRATO_HISTORICO, $c);
                    }

                //Apaga as parcelas existentes no caso de alguma insercao fora do padrao ou invalida.
                $this->tb_parcelaDistrato->delete($this->tb_parcelaDistrato->getAdapter()->quoteInto('id_contrato = ?', $id));

                $valorRestante = Helper::getInputMoney($_POST['vlTotalDistrato']);
                $valorParcela = Helper::getInputMoney($_POST['vlParcelaDistrato']);

                //Adicionando as parcelas do distrato na tabela de PARCELA_DISTRATO
                for ($i = 1; $i <= $_POST['qtdeParcelaDistrato']; $i++) {
                    //Vai diminuindo o valor da parcela do total para setar o restante na ultima parcela
                    if ($i == $_POST['qtdeParcelaDistrato']) {
                        $valorParcela = $valorRestante;
                    } else {
                        $valorRestante -= $valorParcela;
                    }
                    $tb_parcelaDistrato = $this->tb_parcelaDistrato->createRow();
                    $tb_parcelaDistrato->id_parcela = $i;
                    $tb_parcelaDistrato->id_contrato = $idContrato;
                    $tb_parcelaDistrato->acrescimo = $contrato->acrescimo;
                    $tb_parcelaDistrato->desconto = $contrato->desconto;
                    $tb_parcelaDistrato->dt_parcela = $this->_helper->filters($_POST['dtPrimeiraParcela'], 'date');
                    $tb_parcelaDistrato->vl_parcela = $this->_helper->filters($valorParcela);
                    $tb_parcelaDistrato->tp_parcela = 'D';
                    $tb_parcelaDistrato->pago = '0';
                    $tb_parcelaDistrato->obs = 'Parcela Normal';
                    $tb_parcelaDistrato->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - I');
                    $tb_parcelaDistrato->save();
                }
                //salva o contrato
                $contrato->save();
                // Pega todas as parcelas deste contrato
                $tb_parcelas = new Parcela();
                $parcelasHistorico = $tb_parcelas->fetchAll("id_contrato = " . addslashes($idContrato))->toArray();
                // Salvamos as parcelas no historico.
                foreach ($parcelasHistorico as $parc) {
                    // Setando o log das parcelas para quem de fato esta excluindo.
                    $parc["log"] = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                    // Inserindo.
                    $table->insert(TB_PARCELA_HISTORICO, $parc);
                }

                //exclui as parcelas
                $parcelas = new Parcela();
                $parcelas->delete($parcelas->getAdapter()->quoteInto('id_contrato = ?', $idContrato));

                //Altera o status do lote para disponvel("D")
                $contratoStatusLote = (new Contrato())->getDefaultAdapter()->select()
                ->from(['c' => TB_CONTRATO], 'id_lote')
                ->where('c.id = "' . $_POST['id_contrato'] . '"')
                ->query()->fetch();
                
                $statusLote = new Lote();
                $statusLote = $statusLote->fetchRow('id = ' . $contratoStatusLote['id_lote']);
                $statusLote->status = 'D';
                $statusLote->save();

                // Se chegou ate aqui, entao deu tudo certo pode dar commit.
                $db->commit();

                //Antes de redirecionar grava o resultado no log dos contatos realizados como distrato.
                (new Relacionamento())->saveContato(19, date('Y-m-d'), $idContrato, 'Log: Distrato Adicionado');

                $this->redir(array("modulo" => "adm", "controller" => "distrato", 'action' => 'listar'), array("msg" => "success"));
            } catch (Exception $e) {
                $db->rollBack();
                $this->redir(array('modulo' => 'adm', 'controller' => 'distrato', 'action' => 'adicionar'), array('msg' => 'fail', 'exception' => $e->getMessage(), "id" => $_GET['id']));
            }
        } else {
            $distrato = array_merge($_POST);
            $this->set('distrato', $distrato);
        }
        $this->display("form");
    }

    public function editarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'editarDistrato')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'distrato', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $empreendimentos = $this->tb_empreendimento->getAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO));
        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {
            }
        }
        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        $banco = new Banco();
        $bancos = $banco->getAdapter()->select()
            ->from(TB_AGRUPADA)
            ->where('idTabela = ' . Db_TabelaAgrupada::TABLE_BANCO)
            ->order('descricao ASC')
            ->query()->fetchAll();

        $motivos = Db_TabelaAgrupada::findByTabelaId(20);
        $this->set('motivoDistrato', $motivos);

        $id = $_GET["id"];
        $distrato = $this->distrato->find($id)->current();
        if ($distrato)
            $distrato = $distrato->toArray();
        else
            $this->redir(array("modulo" => "adm", "controller" => "distrato", "action" => "listar"), array("msg" => "fail"));

        $contrato = ContratoHistorico::findContratoHistorico($id);
        $distrato['idEmpreendimento'] = $contrato['idEmpreendimento'];
        $distrato['nm_empreendimento'] = $contrato['nm_empreendimento'];
        $distrato['porcDev'] = $contrato['porcDev'];

        $contratos = array('0' => $contrato);

        $dados = $this->distrato->getAdapter()->select()
            ->from(array("d" => TB_DISTRATO), array('porcAdmin', 'porcDev', 'porcFru'))
            ->where('id_contrato = ?', $id)
            ->query()->fetchAll();

        $retencao = 100 - $dados[0]['porcDev'];

        $distrato['txAdmin'] = $retencao . '%';
        $distrato['txFruicao'] = $dados[0]['porcFru'] . '%';

        $contratoEdit = Contrato::findContratoById($id);

        if ($contratoEdit['inclui_sinal_contrato'] == 1) {
            $valorTotalContrato = $contratoEdit['nr_parcela_sinal'] * $contratoEdit['vl_sinal'] +
                                $contratoEdit['nr_parcela'] * $contratoEdit['vl_parcela'] +
                                $contratoEdit['qt_parcelas'] * $contratoEdit['vl_parcela_adicional'] +
                                $contratoEdit['nr_intercalada'] * $contratoEdit['vl_intercalada'] +
                                $contratoEdit['nr_parcela_entrega'] * $contratoEdit['vl_parcela_entrega'];                                
        }
        if ($contratoEdit['inclui_sinal_contrato'] == 0) {
            $valorTotalContrato = $contratoEdit['nr_parcela'] * $contratoEdit['vl_parcela'] +
                                $contratoEdit['nr_intercalada'] * $contratoEdit['vl_intercalada'] +
                                $contratoEdit['qt_parcelas'] * $contratoEdit['vl_parcela_adicional'] +
                                $contratoEdit['nr_parcela_entrega'] * $contratoEdit['vl_parcela_entrega'];
        }

        $firstDate = new DateTime(Helper::dataParaAmericano($contratoEdit['dt_contrato']));
        $secondDate = new DateTime(Helper::dataParaAmericano($_POST['dt_distrato']));
        $intvl = $firstDate->diff($secondDate);
        $nrdias = $intvl->days/30;
        $nrMes = intval(round($nrdias));
        $fruicao = ($valorTotalContrato * $dados[0]['porcFru'] * 0.01) * $nrMes;

        $distrato['mFruicao'] = $nrMes;
        $distrato['fruicao'] = Helper::getMoney($fruicao);
        $distrato['vlTotalContrato'] = Helper::getMoney($valorTotalContrato);

        //Valores das parcelas do distrato ainda nao pagas
        $parcelas = $this->tb_parcelaDistrato->getAdapter()->select()
            ->from(array("pd" => TB_PARCELA_DISTRATO), array('id_parcela_contrato', 'dt_parcela', 'vl_parcela'))
            ->where('id_contrato = ?', $id)
            ->where('tp_parcela = ?', 'D')
            ->where('pago = ?', '0')
            ->query()->fetchAll();

        $distrato['qtParcelas'] = count($parcelas);
        $distrato['vlTotalParcelas'] = 0;
        $distrato['vlParcela'] = $parcelas[0]['vl_parcela'];
        $distrato['dtParcela'] = $parcelas[0]['dt_parcela'];

        foreach ($parcelas as $parcela) {
            $distrato['vlTotalParcelas'] += $parcela['vl_parcela'];
        }
        //Valores das parcelas pagas
        $parcelaPagaHistorico = Parcela::findParcelasPagasHistoricoById($id);
        $empreendimento = Empreendimento::findEmpreendimento($_POST['empreendimento_distrato']);
        $valorPago = 0;
        $valorSinal = 0;
        $qtd = count($parcelas);
        $qtdParcelaPagas = 0;
        $desconto = 0;

        foreach ($parcelaPagaHistorico as $parcela) {
            if ($parcela['tp_parcela'] != 'S' && $parcela['tp_parcela'] != 'SE') {
                $valorPago += $parcela['vl_parcela'];
                $desconto += $parcela['desconto'];
                $qtdParcelaPagas ++;
            } elseif ($parcela['tp_parcela'] == 'S') {
                $qtd --;
                $valorSinal += $parcela['vl_parcela'];
                $desconto += $parcela['desconto'];
            }
        }
        $valorDevolucao = $valorPago * $empreendimento->porcDev * 0.01;
        $totalPagoMenosAdm = ($valorPago - $desconto) * (1 - $dados[0]['porcDev'] * 0.01);
        $valorADM = (($valorPago - $desconto) - $totalPagoMenosAdm);

        $distrato['vlTxAdmin'] = Helper::getMoney($totalPagoMenosAdm); 

        $this->set('valorPago', $valorPago);
        $this->set('valorDevolucao', $valorDevolucao);

        //Calcula o valor total do sinal para caso de remocao posterior
        $sinalParcelas = $this->tb_parcela->getAdapter()->select()
            ->from(array("pd" => TB_PARCELA_HISTORICO), array('id_parcela_contrato', 'dt_parcela', 'vl_parcela'))
            ->where('id_contrato = ?', $id)
            ->where('tp_parcela = ?', 'S')
            ->where('pago = ?', '1')
            ->query()->fetchAll();

        $distrato['valorSinal'] = 0;
        foreach ($sinalParcelas as $sinal) {
            $distrato['valorSinal'] += $sinal['vl_parcela'];
        }
        if (!$distrato['nm_favorecido'] && $distrato['fl_proprio_favorecido'] == '1') {
            $distrato['nm_favorecido'] = $contrato['nm_pessoa'];
            $distrato['nr_cpf_favorecido'] = $contrato['nr_cpf'];
        }

        $distrato['nm_mesmo'] = $contrato['nm_pessoa'];
        $distrato['nr_cpf_mesmo'] = $contrato['nr_cpf'];
        $distrato['qtdParcelaPagas'] = $qtdParcelaPagas;

        $quantidadeSinal = Contrato::findContratoById($_GET['id']);
        $this->set("quantidadeSinal", $quantidadeSinal);
        //Seta os dados para o form
        $this->set("distrato", $distrato);
        $this->set('empreendimentos', $empreendimentos);
        $this->set('bancos', $bancos);
        $this->set('contratos', $contratos);

        if ($this->_isPost && $this->validar()) {
            // Vamos iniciar uma transacao com o banco dados, ou seja, tudo ou nada.
            $db = Zend_Db_Table::getDefaultAdapter();
            $db->beginTransaction();

            //Cond. caso valor total seja alterado salva na vari�vel para log
            //preg_replace retira todo . ou , que esteja nos numeros
            $vlTotalParcelasLog = preg_replace('#[^\pL\pN/-]+#', '', Helper::getMoney($distrato['vlTotalParcelas']));
            $vlTotalDistratoLog = preg_replace('#[^\pL\pN/-]+#', '', $_POST["vlTotalDistrato"]);
            $vlParcelasLog = preg_replace('#[^\pL\pN/-]+#', '', Helper::getMoney($distrato['vlParcela']));                
            $vlParcDistratoLog = preg_replace('#[^\pL\pN/-]+#', '', $_POST["vlParcelaDistrato"]);
            $logReg = "";
            //Cria o log detalhado para altera��o dos valores
            if ($vlTotalParcelasLog != $vlTotalDistratoLog){
                $logReg .= " / Valor total alterado de " . Helper::getMoney($distrato['vlTotalParcelas']) . " para " . $_POST['vlTotalDistrato'];   
            } 
            if ($vlParcDistratoLog != $vlParcelasLog) {
                $logReg .= " / Valor alterado de " . Helper::getMoney($distrato['vlParcela']) . " para " . $_POST['vlParcelaDistrato'] . " / Parcelas de " . $distrato['qtParcelas'] . " para " . $_POST['qtdeParcelaDistrato'];   
            }

            try {
                $id = (int)$id;
                $contrato = $this->tb_contrato->getAdapter()->select()->from(array("p" => TB_PARCELA_HISTORICO), array("pagas" => "SUM(vl_parcela)", "multas" => "SUM(vl_multa)", "juros" => "SUM(vl_juros)", "descontos" => "SUM(desconto)", "acrescimo" => "SUM(acrescimo)", "vlTotalPago" => "SUM(vl_total_pago)"))->where("id_contrato = $id")->where("tp_parcela not in ('S','SE')")->where("pago = '1'")->query()->fetch();

                if ($_POST['recalc'] == 'S')
                {
                    $valorTotalDistrato = ($contrato['vlTotalPago'] - $contrato['multas'] - $contrato['juros']);
                }

                if ($_POST['radioSinal'] == 'S') {
                    $valorTotalDistrato += $_POST["SinalValor"];
                }              

                //Dados do distrato
                $distrato = $this->distrato->find($id)->current();
                $distrato->dt_distrato = $this->_helper->filters($_POST["dt_distrato"], 'date');
                if ($valorTotalDistrato)
                {
                    $distrato->vl_distrato = $valorTotalDistrato;
                }
                $distrato->local_assinatura = $this->_helper->filters($_POST["local_assinatura"]);
                $distrato->fl_incluir_sinal = ($_POST['radioSinal'] == 'S') ? 1 : 0;
                $distrato->fl_proprio_favorecido = ($_POST['favorecido'] == '0') ? 1 : 0;
                $distrato->tp_distrato = $this->_helper->filters($_POST['tipoDistrato']);
                $distrato->id_motivo = ($_POST['tipoDistrato'] == 'V')?$_POST['dsMotivoDistrato']:null;
                $distrato->obs = $this->_helper->filters($_POST["obs"]);
                $distrato->forma_devolucao = $this->_helper->filters($_POST["forma_devolucao"]);


                //Dados Bancarios
                $cpfCnpjPessoa = $_POST["CPFFavorecido"];

                if ($_POST['tpPessoa'] == 'J')
                    $cpfCnpjPessoa = $_POST['CNPJFavorecido'];

                $distrato->id_banco = $this->_helper->filters($_POST["banco"]);
                $distrato->nm_favorecido = $this->_helper->filters($_POST["nomeFavorecido"]);
                $distrato->nr_cpf_favorecido = $this->_helper->filters($cpfCnpjPessoa);
                $distrato->nr_operacao_banco = $this->_helper->filters($_POST["operacao"]);
                $distrato->nr_agencia_banco = $this->_helper->filters($_POST["agencia"]);
                $distrato->nr_dv_agencia_banco = $this->_helper->filters($_POST["agencia_dv"]);
                $distrato->nr_conta_corrente_banco = $this->_helper->filters($_POST["conta_corrente"]);
                $distrato->nr_dv_conta_corrente_banco = $this->_helper->filters($_POST["conta_corrente_dv"]);
                if ($_POST['banco'] && $_POST['operacao'] && $_POST['tp_conta'] == 'X') {
                    $distrato->tp_conta = ($_POST['tipo_conta']) ? $_POST['tipo_conta'] : null;
                } elseif (!$_POST['banco'] && !$_POST['operacao'] && $_POST['tp_conta'] == 'X') {
                    $distrato->tp_conta = ($_POST['tp_conta']) ? $_POST['tp_conta'] : null;
                } else {
                    $distrato->tp_conta = ($_POST['tipo_conta']) ? $_POST['tipo_conta'] : null;
                }
                $distrato->chave_pix = ($_POST['chavePix']) ? $_POST['chavePix'] : null;
                if ($_POST['chavePix']) {
                    $distrato->tipo_pix = ($_POST['tipo_pix']) ? $_POST['tipo_pix'] : null;
                } else {
                    $distrato->tipo_pix = null;
                }

                //salva o distrato
                $distrato->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i');              
                
                $distrato->save();
                //Grava o log
                (new Relacionamento())->saveContato(19, date('Y-m-d'), $_GET['id'], 'Log: Distrato Editado' . $logReg);

                //Apaga as parcelas existentes e recria as mesmas com valores alterados, caso tenha alterado.
                $this->tb_parcelaDistrato->delete($this->tb_parcelaDistrato->getAdapter()->quoteInto('id_contrato = ?', $id));

                //Adicionando as parcelas do distrato na tabela de PARCELA_DISTRATO
                for ($i = 0; $i < $_POST['qtdeParcelaDistrato']; $i++) {

                    $tb_parcelaDistrato = $this->tb_parcelaDistrato->createRow();
                    $tb_parcelaDistrato->id_parcela = $i + 1;
                    $tb_parcelaDistrato->id_contrato = $_GET['id'];
                    $tb_parcelaDistrato->acrescimo = $contrato->acrescimo;
                    $tb_parcelaDistrato->desconto = $contrato->desconto;
                    $tb_parcelaDistrato->dt_parcela = $this->_helper->filters($_POST['dtPrimeiraParcela'],'date');
                    $tb_parcelaDistrato->vl_parcela = $this->_helper->filters($_POST['vlParcelaDistrato'], 'money');
                    $tb_parcelaDistrato->tp_parcela = 'D';
                    $tb_parcelaDistrato->pago = '0';
                    $tb_parcelaDistrato->obs = 'Parcela Normal';
                    $tb_parcelaDistrato->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - I');
                    $tb_parcelaDistrato->save();
                }
                $db->commit();

                $this->redir(array("modulo" => "adm", "controller" => "distrato", "action" => "listar"), array("msg" => "success"));
            } catch (Exception $e) {
                $db->rollBack();
                $this->redir(array("modulo" => "adm", "controller" => "distrato", "action" => "listar"), array("msg" => "fail"));
            }
        }

        $this->display("form");

    }

    public function deletarAction()
    {
        if ($this->_isGet) {
            $id = $_GET["id"];
            $db = Zend_Db_Table::getDefaultAdapter();
            $db->beginTransaction();
            $tb_contrato = new Contrato();
            $tb_distrato = new Distrato();
            $tb_parcelaDistrato = new ParcelaDistrato();
            $tb_parcelaHistorico = new ParcelaHistorico();
            $tb_contratoHistorico = new ContratoHistorico();
            $tb_parcelaNegociada = new ParcelaNegociada();

            try {
                //altera a flag de distrato na tabela de contrato
                $contratoInativo = $tb_contrato->fetchRow('id = '. $_GET["id"]);
                $contratoAtivo = $tb_contrato->fetchRow('id_lote = '. $contratoInativo["id_lote"].' AND fl_distrato = "0"');
                $reservaLote = (new ReservaLote())->fetchRow('cod_lote = '. $contratoInativo["id_lote"].' AND reservado = "1"');
                $lote = (new Lote())->fetchRow('id = '. $contratoInativo["id_lote"].' AND reservado = "1"');

                if ($reservaLote) {
                    $this->redir(array("modulo" => "adm", "controller" => "distrato", 'action' => 'listar'), array("exception" => 'O lote possui uma reserva ativa'));
                } elseif ($lote) {
                    $this->redir(array("modulo" => "adm", "controller" => "distrato", 'action' => 'listar'), array("exception" => 'O lote possui uma reserva t�cnica ativa'));
                } elseif ($contratoAtivo) {
                    $this->redir(array("modulo" => "adm", "controller" => "distrato", 'action' => 'listar'), array("exception" => 'J� existe um contrato ativo para este lote.'));
                } else {
                    $contratoInativo->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - a');
                    $contratoInativo->fl_distrato = 0;
                    $contratoInativo->save();

                    // Pega todas as parcelas deste contrato
                    $listaParcelaHistorico = $tb_parcelaHistorico->fetchAll('id_contrato = ' . $id)->toArray();
                    $table = Zend_Db_Table::getDefaultAdapter();
                    // Salvamos as parcelas no historico.
                    $temOutrasParcela = false;
                    
                    foreach ($listaParcelaHistorico as $parcelaHistorico) {
                        // Setando o log das parcelas para quem de fato esta excluindo.
                        $parcelaHistorico["log"] = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                        $parcelaNegociada = false;
                        //Verifica se a parcela e de renegociacao ou quitada para poder nao excluir
                        if ($parcelaHistorico['id_renegociacao']) {
                            $parcelaNegociada = $tb_parcelaNegociada->fetchRow('id_parcela_contrato = '.$parcelaHistorico['id_parcela_contrato'].' AND id_negociacao = ' .$parcelaHistorico['id_renegociacao']);
                        }
                        if ($parcelaNegociada || $parcelaHistorico['fl_quitado'] == '1') {
                            $temOutrasParcela = true;
                            continue;
                        }
                        // Inserindo.
                        $table->insert(TB_PARCELA, $parcelaHistorico);
                    }
                    //Cria um array dos ids das parcelas para IN de parcela historico
                    $tb_parcelaHistorico->delete('id_contrato = ' . $id.' AND fl_quitado = "0" AND id_renegociacao is null');
                    //Excluindo os registros na parcela Historico de parcelas, Distrato, Parcela de Distrato e Historico de contrato
                    $tb_distrato->delete('id_contrato = '. $id);
                    $tb_parcelaDistrato->delete('id_contrato = '. $id);
                    //Condi��o criaca especialmente quando o cliente fez v�rias renegocia��es.
                    //O cliente que estava com esse problema � a CNE.
                    //http://191.252.102.37:8080/browse/ACL-2355
                    $verificaParcelaHistorico = $this->tb_parcelaHistorico->fetchAll('id_contrato = ' . $id)->toArray();
                    
                    if ($verificaParcelaHistorico) {
                    
                        foreach ($verificaParcelaHistorico as $parcelaHistorico) {
                            $lista[] = $parcelaHistorico['id_parcela_contrato'];
                        }   
                        $lista = implode('","', $lista);
                        
                        $parcelas = $this->tb_parcela->getAdapter()->select()
                            ->from(array('p' => TB_PARCELA, array('p.id_parcela_contrato')))
                            ->where('p.id_parcela_contrato IN ("'.$lista.'")')
                            ->query()->fetchAll();
                        
                        if ($parcelas) {

                            foreach ($parcelas as $parcela) { 
                                $this->tb_parcelaHistorico->delete("id_contrato = {$id} AND id_parcela_contrato = {$parcela['id_parcela_contrato']}");
                            }
                        }
                        //verifica novamente se ainda tem conte�do na tabela PARCELA_HISTORICO.
                        $verificaHistorico = $this->tb_parcelaHistorico->fetchRow("id_contrato = {$id}");

                        if ($verificaHistorico) {
                            $temOutrasParcela = true;
                        } else {
                            $temOutrasParcela = false;
                        }
                    }

                    if(!$temOutrasParcela) {
                        $tb_contratoHistorico->delete('id = '. $id);
                    }

                    //Altera o status do lote para vendido("V")
                    $contratoStatusLote = (new Contrato())->getDefaultAdapter()->select()
                    ->from(['c' => TB_CONTRATO], 'id_lote')
                    ->where('c.id = "' . $_GET["id"] . '"')
                    ->query()->fetch();
                    
                    $statusLote = new Lote();
                    $statusLote = $statusLote->fetchRow('id = ' . $contratoStatusLote['id_lote']);
                    $statusLote->status = 'V';
                    $statusLote->save();

                    $db->commit();
                    //Antes de redirecionar grava o resultado no log dos contatos realizados como distrato.
                    (new Relacionamento())->saveContato(19, date('Y-m-d'), $id, 'Log: Distrato Cancelado');
                    $this->redir(array("modulo" => "adm", "controller" => "distrato", 'action' => 'listar'), array("msg" => "success", "desfazer" => "true"));
                }
            } catch (Exception $e) {
                $db->rollBack();
                $this->redir(array("modulo" => "adm", "controller" => "distrato", 'action' => 'listar'), array("exception" => $e->getMessage()));
            }
        }
    }

    public function imprimeAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'imprimeDistrato')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'distrato', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        if ($_GET['tpcarta']) {
            $tbClienteAcade = new Db_Cliente();
            $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());
            $tipoCarta = [];
            if($this->tb_carta->find($_GET['tpcarta'])->current()){
                $tipoCarta = $this->tb_carta->find($_GET['tpcarta'])->current()->toArray();
            }
            else{
                $tipoCarta = $this->tb_carta->find("7")->current()->toArray();
            }
            $this->set('carta', $tipoCarta);

            //Busca parcelas pagas durante o contrato
            $parcelaDados = $this
                ->tb_parcela
                ->select()
                ->from(TB_PARCELA, '*')
                ->where("id_contrato = {$_GET['id']}")
                ->where("tp_parcela NOT IN ('A')")
                ->query()->fetchAll();

            $parcelaDadosHistorico = $this
                ->tb_parcelaHistorico
                ->select()
                ->from(TB_PARCELA_HISTORICO, '*')
                ->where("tp_parcela NOT IN ('A')")
                ->where("id_contrato = {$_GET['id']}")
                ->query()->fetchAll();

            $parcelaDados = array_merge($parcelaDados, $parcelaDadosHistorico);

            $dadosContrato = array('valor' => 0.00, 'qtd' => 0);

            $contrato = $this->tb_contrato->find($_GET['id'])->current();
            $distrato = $this->distrato->fetchRow('id_contrato = ' . $_GET['id']);

            if (!$distrato) {
                $this->redir(array("modulo" => "adm", "controller" => "distrato", 'action' => 'listar'), array("exception" => 'Distrato n�o encontrado.'));
                exit;
            }

            foreach ($parcelaDados as $parcela) {
                if ($parcela['vl_total_pago'] > 0 && $parcela['pago'] == '1') {
                    if ($distrato->fl_incluir_sinal == 0) {
                        if ($parcela['tp_parcela'] != 'S') {
                            $dadosContrato['valor'] += (float)$parcela['vl_parcela'];
                            $dadosContrato['qtd']++;
                        }
                    } else {
                        $dadosContrato['valor'] += (float)$parcela['vl_parcela'];
                        $dadosContrato['qtd']++;
                    }
                }
            }
            $valor = $distrato->vl_distrato;
            $lote = $this->tb_lote->fetchRow("id = {$contrato->id_lote}");
            $empreendimento = $this->tb_empreendimento->fetchRow("id = {$lote->id_empreendimento}")->toArray();
            $adapter = $this->tb_pessoaFisica->getAdapter();
            $cliente = $adapter
                ->select()
                ->from(array('p' => TB_PESSOA), "*")
                ->joinLeft(array('pf' => TB_PESSOA_FISICA), "p.id = pf.id_pessoa", "*")
                ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), "p.id = pj.id_pessoa", "*")
                ->where("id = {$contrato->id_pessoa}")
                ->query()->fetch();

            //CLIENTE CONJUGE
            if ($cliente['cd_conjuge']) {
                $clienteConjuge = $this->tb_pessoa->fetchRow('id = '.$cliente['cd_conjuge']);
            }
            $adapter = $this->tb_pessoaJuridica->getAdapter();
            $pessoaJuridica = $adapter
                ->select()
                ->from(array(TB_PESSOA_JURIDICA), array('*'))
                ->join(TB_PARCERIA, 'PESSOA_JURIDICA.id_pessoa = PARCERIA.id_pessoa', '*')
                ->join(TB_PESSOA, "id = PESSOA_JURIDICA.id_pessoa", "*")
                ->where('id_empreendimento = ?', "{$lote->id_empreendimento}")
                ->query()->fetchAll();

            //Valores das parcelas do distrato ainda n?o pagas
            $parcelas = $this
                ->tb_parcelaDistrato
                ->getAdapter()
                ->select()
                ->from(array("pd" => TB_PARCELA_DISTRATO), array('id_parcela_contrato', 'dt_parcela', 'vl_parcela'))
                ->where('id_contrato = ?', $_GET['id'])
                ->where('tp_parcela = ?', 'D')
                ->where('pago = ?', '0')->query()->fetchAll();
            $valorDevolucao = 0;
            foreach ($parcelas as $parcela) {
                $valorDevolucao += $parcela['vl_parcela'];
            }
            //Adicionado pessoas envolvidas para gerar assinatura de outros compradores!
            $pessoas_envolvidas = $this->pessoasEnvolvidas->findByContrato($_GET['id']);
            $outrosCompradores = array();
            $k = 0;
            if ($pessoas_envolvidas) {
                foreach ($pessoas_envolvidas as $pessoa) {
                    $outrosCompradores[$k] = $this->pessoa->findFisicaById($pessoa['id_pessoa']);
                    $cidade = Db_Cidade::find($outrosCompradores[$k]['cd_cidade']);
                    if ($cidade)
                        $cidade = $cidade->toArray();
                    else {
                        $cidade['nome'] = '';
                        $cidade['uf'] = '';
                    }
                    $outrosCompradores[$k]['nmcidade'] = $cidade['nome'];
                    $outrosCompradores[$k]['ufcidade'] = $cidade['uf'];
                    switch ($outrosCompradores[$k]['est_civil']) {
                        case 'SOL' :
                            $outrosCompradores[$k]['est_civil_nome'] = 'Solteiro(a)';
                            break;
                        case 'CAS' :
                            $outrosCompradores[$k]['est_civil_nome'] = 'Casado(a)';
                            if ($outrosCompradores[$k]['cd_conjuge'])
                                $outrosCompradores[$k]['conjuge'] = $this->pessoa->findFisicaById($outrosCompradores[$k]['cd_conjuge']);
                            break;
                        case 'SEP' :
                            $outrosCompradores[$k]['est_civil_nome'] = 'Separado(a)';
                            break;
                        case 'VIU' :
                            $outrosCompradores[$k]['est_civil_nome'] = 'Viuvo(a)';
                            break;
                        case 'DIV' :
                            $outrosCompradores[$k]['est_civil_nome'] = 'Divorciado(a)';
                            break;
                        case 'UNE' :
                            $outrosCompradores[$k]['est_civil_nome'] = 'Uni�o est�vel';
                            if ($outrosCompradores[$k]['cd_conjuge'])
                                $outrosCompradores[$k]['conjuge'] = $this->pessoa->findFisicaById($outrosCompradores[$k]['cd_conjuge']);
                            break;
                    }
                    $k++;
                }
                $this->set('pessoas_envolvidas', $outrosCompradores);
            }

            $empreendimentoInfo = $this->tb_empreendimento->getAdapter()->select()->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento', 'ds_path_logo'))
                ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
                ->where('id = ' . $empreendimento['id'])->query()->fetch();
            $this->set("empreendimentoInfo", $empreendimentoInfo);

            //Assinatura Partes Interessadas
            $parceria = new Parceria();
            $parceriaPI = $parceria->getDefaultAdapter()->select()
                ->from(array('pa' => TB_PARCERIA), array('*'))
                ->joinLeft(array('p' => TB_PESSOA), 'p.id = pa.id_pessoa', array('*'))
                ->joinLeft(array('c' => TB_CIDADE), 'c.id = p.cd_cidade', array('nmCidade' => 'nome', 'uf'))
                ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = p.id', array('*'))
                ->where('pa.id_empreendimento = ' . $empreendimento['id'])
                ->query()->fetchAll();

            if ($parceriaPI) {
                foreach ($parceriaPI as &$pr) {
                    if ($pr['est_civil'])
                        $pr['est_civil_nome'] = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $pr['est_civil'])->getDescricao();
                    if ($pr['uf'])
                        $pr['uf_nome'] = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_UF, $pr['uf'])->getDescricao();
                }
            }

            //Assinaturas Partes Envolvidas
            $assinaturas = new Assinatura();
            $assinaturaPE = $assinaturas->getDefaultAdapter()->select()
                ->from(array('a' => TB_ASSINATURA), array('*'))
                ->joinLeft(array('p' => TB_PESSOA), 'p.id = a.id_pessoa', array('*'))
                ->joinLeft(array('c' => TB_CIDADE), 'c.id = p.cd_cidade', array('nmCidade' => 'nome', 'uf'))
                ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = p.id', array('*'))
                ->where('a.id_empreendimento = ' . $empreendimento['id'])
                ->query()->fetchAll();

            if ($assinaturaPE) {
                foreach ($assinaturaPE as &$pr) {
                    if ($pr['est_civil'])
                        $pr['est_civil_nome'] = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $pr['est_civil'])->getDescricao();
                    if ($pr['uf'])
                        $pr['uf_nome'] = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_UF, $pr['uf'])->getDescricao();
                }
            }

            $dtParc = $this->tb_parcelaDistrato->getAdapter()->select()
            ->from(array("pd" => TB_PARCELA_DISTRATO), 'dt_parcela')
            ->where('id_contrato = ?', $_GET['id'])
            ->where('id_parcela = ?', '1')
            ->query()->fetchAll();

            $dist = $this->distrato->getAdapter()->select()
            ->from(array("d" => TB_DISTRATO), array('porcAdmin', 'porcDev', 'porcFru'))
            ->where('id_contrato = ?', $_GET['id'])
            ->query()->fetchAll();

            $contratoDistrato = Contrato::findContratoById($contrato['id']);

            if ($contrato['inclui_sinal_contrato'] == 1) {
                $valorTotalContrato = $contratoDistrato['nr_parcela_sinal'] * $contratoDistrato['vl_sinal'] +
                                    $contratoDistrato['nr_parcela'] * $contratoDistrato['vl_parcela'] +
                                    $contratoDistrato['qt_parcelas'] * $contratoDistrato['vl_parcela_adicional'] +
                                    $contratoDistrato['nr_intercalada'] * $contratoDistrato['vl_intercalada'] +
                                    $contratoDistrato['nr_parcela_entrega'] * $contratoDistrato['vl_parcela_entrega'];                                
            }
            if ($contrato['inclui_sinal_contrato'] == 0) {
                $valorTotalContrato = $contratoDistrato['nr_parcela'] * $contratoDistrato['vl_parcela'] +
                                    $contratoDistrato['qt_parcelas'] * $contratoDistrato['vl_parcela_adicional'] +
                                    $contratoDistrato['nr_intercalada'] * $contratoDistrato['vl_intercalada'] +
                                    $contratoDistrato['nr_parcela_entrega'] * $contratoDistrato['vl_parcela_entrega'];
            }

            $firstDate = new DateTime(Helper::dataParaAmericano($contrato['dt_contrato']));
            $secondDate = new DateTime(Helper::dataParaAmericano($_POST['dt_distrato']));
            $intvl = $firstDate->diff($secondDate);
            $nrdias = $intvl->days/30;
            $nrMes = intval(round($nrdias));
            $retencao = 100 - $dist[0]['porcDev'];
            $vlDevCli = $distrato['vl_distrato'] - ($distrato['vl_distrato'] * $dist[0]['porcDev'] * 0.01);
            $fruicao = ($valorTotalContrato * $dist[0]['porcFru'] * 0.01) * $nrMes;
            $txFruicao = $dist[0]['porcFru'];
            $txAdm = $retencao;
            $dtParcela = $dtParc[0]['dt_parcela'];

            $contrato = $contrato->toArray();
            $contrato['dadosParcela'] = $dadosContrato;
            $distrato = $distrato->toArray();
            $distrato['dadosParcela']['qtd'] = count($parcelas);
            //Seta as variaveis para a view
            $this->set("empresas", $pessoaJuridica);
            $this->set("empreendimento", $empreendimento);
            $this->set("cliente", $cliente);
            $this->set("clienteConjuge", $clienteConjuge);
            $this->set("contrato", $contrato);
            $this->set("distrato", $distrato);
            $this->set("lote", $lote);
            $this->set("valor", $valor);
            $this->set("valorDevolucao", $valorDevolucao);
            $this->set("parceria", $parceriaPI);
            $this->set("assinatura", $assinaturaPE);
            $this->set("nrMes", $nrMes);
            $this->set("txFruicao", $txFruicao);
            $this->set("txAdm", $txAdm);
            $this->set("fruicao", $fruicao);
            $this->set("vlAdm", $vlDevCli);
            $this->set("dtParcela", $dtParcela);
            if (!$_GET['w']) {
                $this->display();
                $this->displayMPDF("distrato.pdf");
            } else {
                try {
                    $path = $this->tb_modeloArquivo->getAdapter()->select()
                    ->from(['mw' => TB_MODELO_ARQUIVO], '*')
                    ->where('mw.cd_modelo = ?', $_GET['tpcarta'])
                    ->query()->fetch();

                    $templateProcessor = new \PhpOffice\PhpWord\TemplateProcessor(__ROOT__ . '/' . $path['ds_path_modelo']);
                    $variaveis = $this->adicionarValoresTemplate($_GET['id'], $templateProcessor);
                    $filename = 'distrato' . $_GET['id'] . '.docx';
                    $variaveis['templateProcessor']->saveAs($filename);

                    header('Content-Description: File Transfer');
                    header('Content-Type: application/octet-stream');
                    header('Content-Disposition: attachment; filename='.$filename);
                    header('Content-Transfer-Encoding: binary');
                    header('Expires: 0');
                    header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
                    header('Pragma: public');
                    header('Content-Length: ' . filesize($filename));
                    flush();

                    readfile($filename);
                    unlink($filename);
                } catch (Exception $e) {
                    $this->redir(array("modulo" => "adm", "controller" => "distrato", 'action' => 'listar'), array("exception" => 'Erro ao gerar o arquivo Word, contate o suporte.'));
                }
            }

        } else {
            $this->redir(array("modulo" => "adm", "controller" => "distrato", 'action' => 'listar'), array("exception" => 'Selecione o tipo de carta.'));
        }
    }

    public function imprimeWordAction()
    {
        if($this->isAjax()) {
            try {
                $modeloWord = $this->tb_modeloArquivo->getAdapter()->select()
                ->from(['mw' => TB_MODELO_ARQUIVO], ['cd_modelo', 'nm_titulo'])
                ->where('fl_status = "1"')
                ->where('tp_modelo = "CD"')
                ->query()->fetchAll();

                foreach($modeloWord as $modelo) {
                    $retorno['arquivos'][] = ['value' => $modelo['cd_modelo'], 'text' => utf8_encode($modelo['nm_titulo'])];
                }

                header('Content-Type: application/json');
        
                echo (json_encode($retorno));
            } catch (Exception $e) {
                die();
            }
        }
    }

    private function validar()
    {
        $campos = array("dt_distrato", "local_assinatura", "tipoDistrato", "empreendimento", "id_contrato");
        foreach ($campos as $cp) {
            if ($_POST [$cp] == "") {
                if (isset($_POST[$cp])) {
                    switch ($cp) {
                        case "empreendimento" :
                            $msg = "o campo Empreendimento � obrigat�rio.";
                            break;
                        case "id_contrato" :
                            $msg = "o campo Contrato � obrigat�rio.";
                            break;
                        case "dt_distrato" :
                            $msg = "o campo Data do distrato � obrigat�rio.";
                            break;
                        case "tipoDistrato" :
                            $msg = "o campo Tipo de distrato � obrigat�rio.";
                            break;
                        case "local_assinatura" :
                            $msg = "O campo Local da assinatura � obrigat�rio.";
                            break;
                    }
                    $this->_helper->addMensagem($cp, $msg);
                }
            }
        }

        //Se existir um valor para ser devolvido a data da primeira parcela e obrigatario
        if ($_POST['vlTotalDistrato'] != '' && $_POST['qtdeParcelaDistrato'] > 0) if ($_POST['dtPrimeiraParcela'] == '') $this->_helper->addMensagem('dtPrimeiraParcela', 'O campo Data da 1� Parcela deve ser preenchido.');

        //Se o banco selecionado for caixa economica a operacao e obrigatoria
        if ($_POST['banco'] == '104') if ($_POST['operacao'] == '') $this->_helper->addMensagem('operacao', 'O campo Opera��o deve ser preenchido.');


        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function dadosContratoAction()
    {
        $empreendimento = Empreendimento::findEmpreendimento($_POST['empreendimento_distrato']);
        $cidade = Cidade::byId($empreendimento->cd_cidade);
        $cidade = $cidade['nome'] . ' - ' . $cidade['uf'];
        $contrato = Contrato::findContratoById($_POST['contrato_id']);
        $parcelas = Parcela::findParcelasDistratoById($_POST['contrato_id']);
        $parcelasHistorico = Parcela::findParcelasPagasHistoricoById($_POST['contrato_id']);
        $sinal = 0;
        $valorPago = 0;
        $qtd = count($parcelas);
        $qtdParcelaPagas = 0;
        $qtdParcelaPagasSinal = 0;
        $desconto = 0;
        $descontoParc = 0;
        $qtdParcelaPagasHist = 0;
        $qtdParcelaPagasSinalHist = 0;
        $descontoHist = 0;
        $acrescimo = 0;
        $valorPagoHist = 0;
        $sinalHist = 0;
        $acrescimoHist = 0;
        $acrescimoS = 0;

        if ($contrato['inclui_sinal_contrato'] == 1) {
            $valorTotalContrato = $contrato['nr_parcela_sinal'] * $contrato['vl_sinal'] +
                                $contrato['qt_parcelas'] * $contrato['vl_parcela_adicional'] +
                                $contrato['nr_parcela'] * $contrato['vl_parcela'] +
                                $contrato['nr_intercalada'] * $contrato['vl_intercalada'] +
                                $contrato['nr_parcela_entrega'] * $contrato['vl_parcela_entrega'];                                
        }
        if ($contrato['inclui_sinal_contrato'] == 0) {
            $valorTotalContrato = $contrato['nr_parcela'] * $contrato['vl_parcela'] +
                                $contrato['qt_parcelas'] * $contrato['vl_parcela_adicional'] +
                                $contrato['nr_intercalada'] * $contrato['vl_intercalada'] +
                                $contrato['nr_parcela_entrega'] * $contrato['vl_parcela_entrega'];
        }

        foreach ($parcelas as $parcela) {
            if ($parcela['tp_parcela'] != 'S' && $parcela['tp_parcela'] != 'SE') {
                $valorPago += $parcela['vl_parcela'];
                $descontoParc += $parcela['desconto'];
                $acrescimo += $parcela['acrescimo'];
                $qtdParcelaPagas++;
            } elseif ($parcela['tp_parcela'] == 'S') {
                $qtdParcelaPagasSinal++;
                $qtd--;
                $sinal += $parcela['vl_parcela'];
                $desconto += $parcela['desconto'];
                $acrescimoS += $parcela['acrescimo'];
            }
        }        
        $sinal -= $desconto;
        $sinal += $acrescimoS;
        foreach ($parcelasHistorico as $parcela) {
            if ($parcela['tp_parcela'] != 'S' && $parcela['tp_parcela'] != 'SE') {
                $valorPagoHist += $parcela['vl_parcela'];
                $descontoHist += $parcela['desconto'];
                $acrescimoHist += $parcela['desconto'];
                $qtdParcelaPagasHist++;
            } elseif ($parcela['tp_parcela'] == 'S') {
                $qtdParcelaPagasSinalHist++;
                $sinalHist += $parcela['vl_parcela'];
                $descontoHist += $parcela['desconto'];
                $acrescimoHist += $parcela['desconto'];
            }
        }

        $firstDate  = new DateTime(Helper::dataParaAmericano($contrato['dt_contrato']));
        $secondDate = new DateTime(Helper::dataParaAmericano($_POST['dt_distrato']));
        $intvl = $firstDate->diff($secondDate);
        $nrdias = $intvl->days/30;
        $nrMes = intval(round($nrdias));
        //$porcDevCli
        $retencao = 100 - ($empreendimento->porcDev);
        
        $fruicao = ($valorTotalContrato * $empreendimento->porcFru * 0.01) * $nrMes;
        $valorADM = ($valorPago - $descontoParc + $acrescimo) * $empreendimento->porcDev * 0.01;
        $vlDevolucao = (($valorPago - $descontoParc + $acrescimo) - $valorADM);
        $valorDevolucao = ($valorPago - $descontoParc + $acrescimo) - $vlDevolucao - $fruicao;

        //Calculando o valor da parcela com desconto das parcelas
        $totalParcDesconto = $valorPago - $descontoParc + $acrescimo;

        $parcelasHistJSON['qtdParcelaPagasHist'] = $qtdParcelaPagasHist;
        $parcelasHistJSON['qtdParcelaPagasSinalHist'] = $qtdParcelaPagasSinalHist;
        $parcelasHistJSON['descontoHist'] = $descontoHist;
        $parcelasHistJSON['acrescimoHist'] = $acrescimoHist;

        if ($qtd > 0) $valorParcela = $valorDevolucao / $qtd;
        echo json_encode(array(
            'contrato_id' => $_POST['contrato_id'],
            'cidade' => utf8_encode($cidade),
            'sinal' => $sinal,
            'qtdparcelas' => $qtd,
            'valorParcela' => $valorParcela,
            'valor' => $valorDevolucao,
            'cpf' => $contrato['nr_cpf'],
            'nome' => utf8_encode($contrato['nm_pessoa']),
            'porcDev' => $empreendimento->porcDev,
            'qtdParcelaPagas' => $qtdParcelaPagas,
            'quantSinal' => $qtdParcelaPagasSinal,
            'vlTotalPaga' => $totalParcDesconto,   
            'parcelasHistoric' => $parcelasHistJSON,
            'descontoTodo' => $desconto,
            'txFruicao' => $empreendimento->porcFru,
            'fruicao' => $fruicao,
            'mFruicao' => $nrMes,
            'txAdmin' => $retencao,
            'vlTotalContrato' => $valorTotalContrato,
            'vlTxAdmin' => $vlDevolucao
        ));
    }

    public function contratoByEmpreendimentoAction()
    {
        $empreedimento = $_POST['id_empreendimento'];
        $contratos = Contrato::byEmpreendimento($empreedimento, Contrato::CONTRATO_GERADO, 0, array("nm_pessoa", "lote", "quadra", "id"));
        $lista[] = array('id'=>'','text'=>'');
        foreach ($contratos as $contrato) {
            $lista[] = array(
                'id' => $contrato['id'],
                'text' => utf8_encode($contrato['nm_pessoa']) . ' Quadra: ' . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']) . ' - Contrato: ' . $contrato['id'],
            );
        }
        echo json_encode($lista);

    }

    public function confirmaRecebimentoAction() {
        try {
            $db = Zend_Db_Table::getDefaultAdapter();
            $db->beginTransaction();

            $distrato = (new Distrato())->fetchRow('id_contrato = '. $_GET['id']);

            if (!$distrato['dt_recebimento_termo']) {
                $distrato->dt_recebimento_termo = date('Y-m-d');
            } else {
                $distrato->dt_recebimento_termo = null;
            }

            $status = $distrato['dt_recebimento_termo'] ? 'Confirmado' : 'Pendente';

            $contato = (new Relacionamento());
            $contato->saveContato(TabelaAgrupada::TIPO_CONTATO_DISTRATO, date('Y-m-d'), $_GET['id'], 'Log: Distrato '.$status);

            $distrato->save();

            $db->commit();
            $this->redir(array("modulo" => "adm", "controller" => "distrato", 'action' => 'listar'), array("msg" => "success"));
        } catch (Exception $e) {
            $db->rollBack();
            $this->redir(array("modulo" => "adm", "controller" => "distrato", 'action' => 'listar'), array("exception" => $e->getMessage()));
        }
    }

    public function validaLoteAction() {
        
        $lote = $this->tb_contrato->getAdapter()->select()
            ->from(array('c' => TB_CONTRATO), '')
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('fl_construcao', 'fl_caucionado'))
            ->joinLeft(array('j' => TB_JURIDICO), 'c.id = j.id_contrato', array('id_juridico'))
            ->where('c.id = ' . $_POST['idContrato'])
            ->query()->fetch();
        
        $construcao = '';
        $juridico = '';
        $caucionado = '';

        if ($lote['fl_construcao'] == '1') {
            
            $construcao = utf8_encode('Aten��o, este lote possui constru��o setada');
        }
        if ($lote['fl_caucionado'] == '1') {
            
            $caucionado = utf8_encode('Aten��o, este lote possui cau��o setada');
        }
        if ($lote['id_juridico'] != null) {
            $juridico = utf8_encode('Aten��o, este lote possui pend�ncia Jur�dica');
        }

        echo json_encode(array('fl_construcao' => $construcao, 'juridico' => $juridico, 'fl_caucionado' => $caucionado));
    }
}
