<?php

class ContratoController extends Controller
{
    private $sinal;
    private $contrato;
    private $contratoHistorico;
    private $parcelasHistorico;
    private $parcelas;
    private $corretor;
    private $empreendimento;
    private $pessoa;
    private $pessoasEnvolvidas;
    private $itensContrato;
    private $tb_cliente;
    private $tb_contrato;
    private $tb_docusign;
    private $tb_docusignVinculo;
    private $tb_docusignCadastro;

    public function __construct($request)
    {
        parent::__construct($request);

        $this->tb_cliente = new Db_Cliente();
        $this->tb_contrato = new Contrato();
        $this->contrato = new Contrato();
        $this->contratoHistorico = new ContratoHistorico();
        $this->parcelasHistorico = new ParcelaHistorico();
        $this->parcelas = new Parcela();
        $this->empreendimento = new Empreendimento();
        $this->corretor = new Corretor_Empreendimento();
        $this->sinal = new Sinal();
        $this->pessoa = new Pessoa();
        $this->pessoasEnvolvidas = new ContratoPessoa();
        $this->itensContrato = new ContratoItens();
        $this->reservaLote = new ReservaLote();
        $this->tb_docusign = new DocusignEventos();
        $this->tb_docusignVinculo = new DocusignVinculo();
        $this->tb_docusignCadastro = new DocusignCadastro();
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "listar"));
    }

    public function listarAction()
    {
        
        $this->set('cliente', Db_Cliente::getCliente());
        if ($this->isAjax()) {
            $_POST['aprovar'] = $_GET['aprovar'];
            $listaItem = Contrato::findLista($_POST,false,$_GET['length'],$_GET['start']);
            $totalItens = Contrato::findLista($_POST, true);

            //Faz uma consulta e trs os Outros Compradores envolvidos e atribui a um array.
            $listarPessoasEnvolvidas = array();
            foreach ($listaItem as $k => $pessoa) {
                $pessoas_envolvidas = $this->pessoasEnvolvidas->getDefaultAdapter()->select()
                    ->from(array('c' => TB_CONTRATO), array('c.id', 'c.id_pessoa', 'c.nr_proposta', 'c.porcentagem_participacao_contrato'))
                    ->joinLeft(array('cp' => TB_CONTRATO_PESSOA), 'c.id = cp.id_contrato', array('id_pessoa', 'porcentagem_participacao_contrato'))
                    ->joinLeft(array('p' => TB_PESSOA), 'cp.id_pessoa = p.id', array('nm_pessoa'))
                    ->where('c.id =' . $pessoa['id'])
                    ->query()->fetchAll();

                foreach ($pessoas_envolvidas as $p_envolvidas) {
                    if ($pessoa['id'] == $p_envolvidas['id']) {
                        $listarPessoasEnvolvidas[] = $p_envolvidas['nm_pessoa'];
                    }
                }
                $listaItem[$k]['pessoasEnvolvidas'] = $listarPessoasEnvolvidas;
                $listarPessoasEnvolvidas = array();
            }
            
            $lista = array();
            foreach ($listaItem as $item) {
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<a href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=editar&id=' . $item['id'] . '" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
                $title = "return confirm('Tem certeza que deseja excluir o contrato " . $item['id'] . " em nome de " . $item['nm_empreendimento'] . " do Lote " . $item['lote'] . "?')";
                $acoes .= '<a onclick="' . $title . '"  href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=deletar&id=' . $item['id'] . '" data-toggle="tooltip" title="EXCLUIR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                $acoes .= '</div>';
                $acoes .= '</div>';

                //Para ordenar por data
                $data = '<div hidden>' . $item['dt_contrato'] . '</div>' . Helper::getDate($item['dt_contrato']);

                $cor = '';
                if ($item['fl_aprovar_contrato'] == 0) {
                    $cor = 'style="color:blue;"';
                }
                //Criado variavel p, para realizar verificacao de nr_proposta.
                //Caso tenha vai o numero senao vai vazio
                $p = ''; 
                if ($item['nr_proposta'] == null) {
                    $p = '';
                } else {;
                    $p = utf8_encode($item['nr_proposta']);
                }

                // Tratando as informaes de Pessoas envolvidas ->
                if (isset($item['nm_pessoa'])) {
                    $cliente = utf8_encode($item['nm_pessoa']);
                }

                if ($item['pessoasEnvolvidas'][0] == null) {
                    $outros = '';
                } else {
                    $outros = ' / ' . utf8_encode(implode(' / ', $item['pessoasEnvolvidas']));
                }

                if ($item['pessoasEnvolvidas'] == null) {
                    explode(' / ');
                }

                $lista[] = array(
                    'contrato' => '<div align="center"' . $cor . ' >' . $item['id'] . '</div>',
                    'proposta' => '<div ' . $cor . ' >' . $p . '</div>',
                    'empreendimento' => '<div ' . $cor . ' >' . utf8_encode($item['nm_empreendimento']) . '</div>',
                    'quadra' => '<div align="center"' . $cor . ' >' . utf8_encode($item['quadra']) . '</div>',
                    'lote' => '<div align="center"' . $cor . ' >' . utf8_encode($item['lote']) . '</div>',
                    'pessoa' => '<div ' . $cor . ' >' . $cliente . $outros . '</div>',
                    'data' => '<div align="center">' . $data . '</div>',
                    'acoes' => utf8_encode($acoes)
                );
            }
            echo json_encode(array(
                'draw' => $_POST['draw'],
                'data' => $lista,
                'recordsFiltered' =>$totalItens[0]['contador'],
                'recordsTotal'=>$totalItens[0]['contador']
            ));
        } else {
            $this->display('listar');
        }
    }

    public function listarDocusignAction()
    {
        
        $this->set('cliente', Db_Cliente::getCliente());
        if ($this->isAjax()) {
            $_POST['docusign'] = $_GET['docusign'];
            $listaItem = Contrato::findLista($_POST);
            $totalItens = Contrato::findLista($_POST, true);

            //Faz uma consulta e trs os Outros Compradores envolvidos e atribui a um array.
            $listarPessoasEnvolvidas = array();
            foreach ($listaItem as $k => $pessoa) {
                $pessoas_envolvidas = $this->pessoasEnvolvidas->getDefaultAdapter()->select()
                    ->from(array('c' => TB_CONTRATO), array('c.id', 'c.id_pessoa', 'c.nr_proposta', 'c.porcentagem_participacao_contrato'))
                    ->joinLeft(array('cp' => TB_CONTRATO_PESSOA), 'c.id = cp.id_contrato', array('id_pessoa', 'porcentagem_participacao_contrato'))
                    ->joinLeft(array('p' => TB_PESSOA), 'cp.id_pessoa = p.id', array('nm_pessoa'))
                    ->where('c.id =' . $pessoa['id'])
                    ->query()->fetchAll();

                foreach ($pessoas_envolvidas as $p_envolvidas) {
                    if ($pessoa['id'] == $p_envolvidas['id']) {
                        $listarPessoasEnvolvidas[] = $p_envolvidas['nm_pessoa'];
                    }
                }
                $listaItem[$k]['pessoasEnvolvidas'] = $listarPessoasEnvolvidas;
                $listarPessoasEnvolvidas = array();
            }
            
            $lista = array();
            foreach ($listaItem as $item) {
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<a href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=logDocusign&id=' . $item['id'] . '" data-toggle="tooltip" title="Visualizar Log" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-eye"></i></a>';
                $acoes .= '</div>';
                $acoes .= '</div>';

                //Para ordenar por data
                $data = '<div hidden>' . $item['dt_contrato'] . '</div>' . Helper::getDate($item['dt_contrato']);

                $cor = '';
                if ($item['fl_aprovar_contrato'] == 0) {
                    $cor = 'style="color:blue;"';
                }
                //Criado variavel p, para realizar verificacao de nr_proposta.
                //Caso tenha vai o numero senao vai vazio
                $p = ''; 
                if ($item['nr_proposta'] == null) {
                    $p = '';
                } else {;
                    $p = utf8_encode($item['nr_proposta']);
                }

                // Tratando as informaes de Pessoas envolvidas ->
                if (isset($item['nm_pessoa'])) {
                    $cliente = utf8_encode($item['nm_pessoa']);
                }

                if ($item['pessoasEnvolvidas'][0] == null) {
                    $outros = '';
                } else {
                    $outros = ' / ' . utf8_encode(implode(' / ', $item['pessoasEnvolvidas']));
                }

                if ($item['pessoasEnvolvidas'] == null) {
                    explode(' / ');
                }

                $lista[] = array(
                    'contrato' => '<div align="center"' . $cor . ' >' . $item['id'] . '</div>',
                    'empreendimento' => '<div ' . $cor . ' >' . utf8_encode($item['nm_empreendimento']) . '</div>',
                    'quadra' => '<div align="center"' . $cor . ' >' . utf8_encode($item['quadra']) . '</div>',
                    'lote' => '<div align="center"' . $cor . ' >' . utf8_encode($item['lote']) . '</div>',
                    'pessoa' => '<div ' . $cor . ' >' . $cliente . $outros . '</div>',
                    'data' => '<div align="center">' . $data . '</div>',
                    'acoes' => utf8_encode($acoes)
                );
            }
            echo json_encode(array(
                'draw' => '1',
                'data' => $lista
            ));
        } else {
            $this->display('listarDocusign');
        }
    }
    /*
    * Exibe formulario de adicionar contrato e adiciona um novo contrato
    */
    public function adicionarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'adicionarContrato')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'contrato', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        if ($this->_isPost && !$this->validar()) {
            //recolhe os dados do POST para as variaveis
            $empreendimento = $_POST['empreendimento'];
            $banco = $_POST['banco'];
            $lote = $_POST['lote'];
            $cliente = $_POST['cliente'];
            $corretor = $_POST['corretor'];
            $pessoas_envolvidas = $_POST['pessoas_envolvidas'];
            $nr_proposta = $_POST['nrProposta'];
            $data_contrato = $_POST['data'];
            $dt_primeira = $_POST['dt_primeira'];
            $max_parcela = $_POST['max_parcela'];
            $qtd_parcela = (int)$_POST['qtd_parcela'];
            $valor = $_POST['vl_parcela'];
            $sinal = $_POST['vl_sinal'];
            $fl_sinal = ($_POST['sinal_agregado'] == '1') ? 1 : 0;
            $dt_sinal = $_POST['dt_sinal'];
            $desconto = Helper::getInputMoney($_POST['desconto']);
            $participacao = $_POST['participacao']; 
            $outrosCompradores = $_POST['listaIndices'];

            //Verifica se a % de participao  menor que 100
            $somaParticipacao = $_POST['participacao']? $_POST['participacao']: 0;
                foreach ($outrosCompradores as $dados) {
                    $indice = explode('_', $dados);
                    $somaParticipacao += $this->_helper->filters($indice[2], 'money');
                }
                if($somaParticipacao>100){
                    $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "adicionar"), array('exception'=> 'A soma das participaes no pode ser superior a 100'));exit();
                }elseif($outrosCompradores && $somaParticipacao<100){
                    $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "adicionar"), array('exception'=> 'A soma das participaes no pode ser inferior a 100'));exit();
                }

            //verifica se a data de reajuste esta em branco e insere null no banco se sim
            $dt_reajuste = $_POST['dt_reajuste'];
            if ($dt_reajuste == '')
                $dt_reajuste = null;

            //verifica se a data de reajuste mensal esta em branco e insere null no banco se sim
            $dt_reajuste_mensal = $_POST['dt_reajuste_mensal'];
            if ($dt_reajuste_mensal == '')
                $dt_reajuste_mensal = null;
            
            //verifica se a data de reajuste intercalada esta em branco e insere null no banco se sim
            $dt_reajuste_intercalada = $_POST['dt_reajuste_intercalada'];
            if ($dt_reajuste_intercalada == '')
                $dt_reajuste_intercalada = null;
            
            //verifica se a data de reajuste chave esta em branco e insere null no banco se sim
            $dt_reajuste_chave = $_POST['dt_reajuste_chave'];
            if ($dt_reajuste_chave == '')
                $dt_reajuste_chave = null;

            $qtd_parcela_intercalada = (int)$_POST['qtd_parcela_intercalada'];
            $intercalada = $this->_helper->getInputMoney($_POST['intercalada']);

            if ($intercalada && $qtd_parcela_intercalada && !empty($_POST['data_intercalada'])) {
                $dt_intercalada = $_POST['data_intercalada'];
            } elseif ($intercalada && $qtd_parcela_intercalada && empty($_POST['data_intercalada'])) {
                $dt_intercalada = $_POST['dt_primeira'];
            } else {
                $dt_intercalada = null;
            }

            $frequencia = $_POST['frequencia'];
            $nr_chave = ($_POST['qtd_parcela_chaves']) ? $_POST['qtd_parcela_chaves'] : null;
            $vl_chave = ($_POST['vl_chaves']) ? $_POST['vl_chaves'] : null;
            $dt_chave = ($_POST['dt_chaves']) ? $_POST['dt_chaves'] : null;
            $coincidir = $_POST['coincidir'];
            $obs = $_POST['obs'];

            $contrato = $this->contrato->createRow();
            $contrato->id_banco = $banco;
            $contrato->id_lote = $lote;
            $contrato->id_corretor = $corretor;
            $contrato->nr_proposta = $this->_helper->filters($nr_proposta);
            $contrato->dt_contrato = $this->_helper->getInputDate($data_contrato);
            $contrato->fl_fm_pagamento = $_POST['tp_pagamento'];
            $contrato->fl_aprovar_contrato = 1;
            $contrato->fl_frequencia = $_POST['fl_frequencia'];
            if ($_POST['desconto_tp_normal'] == 'S') {
                $contrato->vl_desc_normal = null;
            } else {
                $contrato->vl_desc_normal = $this->_helper->filters($_POST['valor_desconto_normal'], 'money');
            }
            if ($_POST['desconto_tp_intercalada'] == 'S') {
                $contrato->vl_desc_intercalada = null;
            } else {
                $contrato->vl_desc_intercalada = $this->_helper->filters($_POST['valor_desconto_intercalada'], 'money');
            }
            if ($_POST['desconto_tp_chave'] == 'S') {
                $contrato->vl_desc_chave = null;
            } else {
                $contrato->vl_desc_chave = $this->_helper->filters($_POST['valor_desconto_chave'], 'money');
            }
            if ($_POST['desconto_tp_sinal'] == 'S') {
                $contrato->vl_desc_sinal = null;
            } else {
                $contrato->vl_desc_sinal = $this->_helper->filters($_POST['valor_desconto_sinal'], 'money');
            }
            //salva as flags
            $contrato->fl_desc_normal = $this->_helper->filters($_POST['desconto_tp_normal']);
            $contrato->fl_desc_intercalada = $this->_helper->filters($_POST['desconto_tp_intercalada']);
            $contrato->fl_desc_chave = $this->_helper->filters($_POST['desconto_tp_chave']);
            $contrato->fl_desc_sinal = $this->_helper->filters($_POST['desconto_tp_sinal']);

            if ($intercalada == '' && $qtd_parcela_intercalada == '' && $frequencia == '' && $dt_intercalada == '') {
                $contrato->fl_coinc_intercalada = '0';
            } else {
                $contrato->fl_coinc_intercalada = $coincidir;
            }

            //Verifica as parcelas sinal com valor maior que zero
            $qtd_parcela_sinal = 0;
            $vl_sinal = 0;
            if (is_array($sinal))
                foreach ($sinal as $k => $parcela) {
                    if ((float)$parcela > 0)
                        $qtd_parcela_sinal++;
                    $vl_sinal += $this->_helper->filters($parcela, 'money');
                }

            $contrato->nr_parcela = $this->_helper->filters($qtd_parcela);
            $contrato->desconto = $this->_helper->filters($desconto);
            $contrato->vl_parcela = $this->_helper->filters($valor, 'money');
            $contrato->nr_parcela_sinal = $this->_helper->filters($qtd_parcela_sinal);
            $contrato->vl_sinal = $this->_helper->filters($vl_sinal);
            $contrato->inclui_sinal_contrato = $this->_helper->filters($_POST['incluiSinalContrato']);
            $contrato->fl_reajustavel_mensais = isset($_POST['fl_reajustavel_mensais']) ? 1 : 0;
            $contrato->fl_reajustavel_intercaladas = isset($_POST['fl_reajustavel_intercaladas']) ? 1 : 0;
            $contrato->fl_reajustavel_chaves = isset($_POST['fl_reajustavel_chaves']) ? 1 : 0;
            if ($dt_sinal[0])
                $contrato->dt_sinal = $this->_helper->filters($dt_sinal[0], 'date');
            $contrato->nr_intercalada = $this->_helper->filters($qtd_parcela_intercalada);
            $contrato->vl_intercalada = $this->_helper->filters($intercalada);
            $contrato->fr_intercalada = $this->_helper->filters($frequencia);
            $contrato->dt_primeira_parcela = $this->_helper->filters($dt_primeira, 'date');
            $contrato->dt_reajuste = $this->_helper->filters($dt_reajuste, 'date');
            $contrato->dt_reajuste_mensal = $this->_helper->filters($dt_reajuste_mensal, 'date');
            $contrato->dt_reajuste_intercalada = $this->_helper->filters($dt_reajuste_intercalada, 'date');
            $contrato->dt_reajuste_chave = $this->_helper->filters($dt_reajuste_chave, 'date');
            $contrato->dt_intercalada = $this->_helper->filters($dt_intercalada, 'date');

            //Valores da Tabela Price
            if ($_POST['tp_parcelamento'] == 'P') {
                $contrato->vl_divida = $this->_helper->filters($_POST['vlDivida'], 'money');
                $contrato->nr_meses_financiamento = $this->_helper->filters($_POST['qtMeses']);
                $contrato->tx_juros = $this->_helper->filters($_POST['txJuros'], 'money');
            }

            //Valores da Tabela Sacoc
            if ($_POST['tp_parcelamento'] == 'S') {
                $contrato->vl_divida_sacoc = $this->_helper->filters($_POST['vlrDivida'], 'money');
                $contrato->nr_meses_financiamento_sacoc = $this->_helper->filters($_POST['qtdMeses']);
                $contrato->tx_juros_sacoc = $this->_helper->filters($_POST['txsJuros'], 'money');
            }


            $contrato->obs = $obs;
            $contrato->id_pessoa = $cliente;
            $contrato->fl_sinal_agregado = $fl_sinal;
            $contrato->vl_parcela_entrega = $this->_helper->filters($vl_chave, 'money');
            $contrato->nr_parcela_entrega = $this->_helper->filters($nr_chave);
            $contrato->dt_parcela_entrega = $this->_helper->filters($dt_chave, 'date');
            $contrato->id_indice = $this->_helper->filters($_POST['idIndice']);
            $contrato->ds_intermediacao_imobiliaria = $this->_helper->filters($_POST['dsIntermediacaoImobiliaria']);
            $contrato->porcentagem_participacao_contrato = $this->_helper->filters($participacao, 'money'); 
            $contrato->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');

            //Verifica se existem parcelas de tipos adicionais para setar o flag de itens de contrato
            if (count($_POST['qtd_parcela_adicional']) > 0 || count($_POST['qtd_intercalada_adicional']) > 0 || count($_POST['qtd_chave_adicional']) > 0) {
                $contrato->fl_itens_contrato = 1;
            }

            //Muda o status do lote para vendido.
            $mudaStatusLote = (new Lote())->fetchRow('id = ' . $lote);
            $mudaStatusLote->status = 'V';
            $mudaStatusLote->save();

            //impede que usuario tente cadastar duas vezes o mesmo lote (com refresh na pagina)
            if ($this->validarAction(
                $qtd_parcela,
                $dt_primeira,
                $qtd_parcela_intercalada,
                $dt_intercalada,
                $frequencia,
                $coincidir
            )) {

                //bloco para testar se o lote ja possui contrato imediatamente antes de salvar
                $contratoCad = $this->contrato->fetchRow("id_lote = $lote and fl_distrato = '0'");

                if (!$contratoCad['id']) {

                    $idContrato = $contrato->save();
                    //PARCELAS SINAL
                    if ($qtd_parcela_sinal > 0)
                        foreach ($sinal as $k => $parcela) {
                            $rowSinal = $this->sinal->createRow();

                            $rowSinal->valor = $this->_helper->filters($parcela, 'money');
                            $rowSinal->dtVencimento = $this->_helper->filters($dt_sinal[$k], 'date');
                            $rowSinal->parcela = $k + 1;
                            $rowSinal->idContrato = $contrato->id;
                            $rowSinal->save();
                        }

                    /*
                     * Adiciona as pessoas envolvidas na tabela CONTRATO_PESSOA
                     * Precisar ser executado apos o save() pois necessita do Id do contrato
                    */
                    if (isset($outrosCompradores)) {

                        $pessoasEnvolvidas = new ContratoPessoa();
                        //Cadastra todos indices que no possuirem contratos associados
                        foreach ($outrosCompradores as $dados) {
                            $indice = explode('_', $dados);

                            $outroComprador = $pessoasEnvolvidas->createRow();
                                $outroComprador->id_contrato =  $idContrato;
                                $outroComprador->id_pessoa =  $indice[3];
                                $outroComprador->porcentagem_participacao_contrato =   $this->_helper->filters($indice[2], 'money');
                                $outroComprador->save();
                        }
                    } 

                    //Verifica se existem parcelas de tipos adicionais mensais
                    if (count($_POST['qtd_parcela_adicional']) > 0) {
                        foreach ($_POST['qtd_parcela_adicional'] as $k => $qtd_adicional) {
                            if ((float)$_POST['vl_parcela_adicional'][$k] > 0) {
                                $itemContrato = new ContratoItens();
                                $itemContrato = $itemContrato->createRow();
                                $itemContrato->id_contrato = $idContrato;
                                $itemContrato->tp_parcela = 'N';
                                $itemContrato->vl_parcela = $this->_helper->filters($_POST['vl_parcela_adicional'][$k], 'money');
                                $itemContrato->qt_parcelas = $qtd_adicional;
                                $itemContrato->fl_reajustavel = isset($_POST['reajustavel_parcela'][$k]) ? '1' : '0';
                                $itemContrato->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');

                                $itemContrato->save();
                            }
                        }
                    }

                    //Verifica se existem parcelas de tipos adicionais intercaladas
                    if (count($_POST['qtd_intercalada_adicional']) > 0) {
                        foreach ($_POST['qtd_intercalada_adicional'] as $k => $qtd_adicional) {
                            if ((float)$_POST['vl_intercalada_adicional'][$k] > 0) {
                                $itemContrato = new ContratoItens();
                                $itemContrato = $itemContrato->createRow();
                                $itemContrato->id_contrato = $idContrato;
                                $itemContrato->tp_parcela = 'I';
                                $itemContrato->vl_parcela = $this->_helper->filters($_POST['vl_intercalada_adicional'][$k], 'money');
                                $itemContrato->dt_parcela = $this->_helper->filters($_POST['dt_intercalada_adicional'][$k], 'date');
                                $itemContrato->nr_frequencia = $this->_helper->filters($_POST['fr_intercalada_adicional'][$k]);
                                $itemContrato->qt_parcelas = $qtd_adicional;
                                $itemContrato->fl_reajustavel = isset($_POST['reajustavel_intercalada'][$k]) ? '1' : '0';
                                $itemContrato->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');

                                $itemContrato->save();
                            }
                        }
                    }

                    //Verifica se existem parcelas de tipos adicionais chaves
                    if (count($_POST['qtd_chave_adicional']) > 0) {
                        foreach ($_POST['qtd_chave_adicional'] as $k => $qtd_adicional) {
                            if ((float)$_POST['vl_chave_adicional'][$k] > 0) {
                                $itemContrato = new ContratoItens();
                                $itemContrato = $itemContrato->createRow();
                                $itemContrato->id_contrato = $idContrato;
                                $itemContrato->tp_parcela = 'C';
                                $itemContrato->vl_parcela = $this->_helper->filters($_POST['vl_chave_adicional'][$k], 'money');
                                $itemContrato->qt_parcelas = $qtd_adicional;
                                $itemContrato->fl_reajustavel = isset($_POST['reajustavel_chave'][$k]) ? '1' : '0';
                                $itemContrato->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');

                                $itemContrato->save();
                            }
                        }
                    }

                    //Busca os dados de lote e pessoa para gravar no log
                    $loteDados = Lote::loteById($lote);
                    $pessoaDados = Pessoa::findById($cliente);

                    //Grava a operacao no log de contatos realizados com o lote e quadra do contrato
                    (new Relacionamento())->saveContato(54, date('Y-m-d'), $idContrato, 'Log: Contrato Cadastrado - Qd: ' .
                        $loteDados['quadra'] . ' Lt: ' . $loteDados['lote'] . ' Cliente: ' . $pessoaDados['nm_pessoa']);
                    //Verifica se existem reservas do lote para serem canceladas
                    $reserva = $this->reservaLote->fetchRow('cod_lote = ' . $this->_helper->filters($_POST['lote']) . ' AND reservado = 1');

                    if ($reserva) {
                        $reserva->reservado = 0;
                        $reserva->save();
                    }

                    $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "listar"), array("msg" => "success"));
                } else {
                    $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "listar"), array("msg" => "FAIL"));
                }
            } else {

                //mostra o formulario do mesma forma que estava anteriormente com as mensagens de erro
                $contrato->dt_contrato = $this->_helper->getDate($contrato->dt_contrato, false);
                $contrato->vl_parcela = $this->_helper->getMoney($contrato->vl_parcela);
                $contrato->desconto = $this->_helper->getMoney($contrato->desconto);
                $contrato->vl_sinal = $this->_helper->getMoney($contrato->vl_sinal);
                $contrato->vl_intercalada = $this->_helper->getMoney($contrato->vl_intercalada);
                $contrato->dt_primeira_parcela = $this->_helper->getDate($contrato->dt_primeira_parcela, false);
                $contrato->dt_reajuste = $this->_helper->getDate($contrato->dt_reajuste, false);
                $contrato->dt_reajuste_mensal = $this->_helper->getDate($contrato->dt_reajuste_mensal, false);
                $contrato->dt_reajuste_intercalada = $this->_helper->getDate($contrato->dt_reajuste_intercalada, false);
                $contrato->dt_reajuste_chave = $this->_helper->getDate($contrato->dt_reajuste_chave, false);
                $contrato->dt_fim_empreendimento = $this->_helper->getDate($contrato->dt_fim_empreendimento, false);
                $contrato->vl_parcela_entrega = $this->_helper->getMoney($contrato->vl_parcela_entrega);


                if ($empreendimento) {
                    $this->set('emp', $empreendimento);

                    $corretores = new Corretor_Empreendimento();
                    $corretores = $corretores->getAdapter()->select()
                        ->from(array('ce' => TB_CORRETOR_EMPREENDIMENTO), '')
                        ->join(array('p' => TB_PESSOA), 'ce.id_corretor = p.id', array('id', 'nm_pessoa'))
                        ->where('ce.id_empreendimento = ' . $empreendimento)
                        ->order('nm_pessoa')->query()->fetchAll();

                    $this->set('corretores', $corretores);

                    //Lote
                    $lotes = new Lote();
                    $tb_contratos = new Contrato();
                    $contratos = $tb_contratos->getAdapter()->select()->from(TB_CONTRATO, 'id_lote')->where("fl_distrato = '0'")->query()->fetchAll();

                    if ($contratos != null) {
                        $this->set('lotes', $lotes->fetchAll($lotes->select()->order(array('quadra ASC', 'lote ASC'))->where('id_empreendimento = ?', $empreendimento)->where('id NOT IN(?)', $contratos), array('id_empreendimento', 'id_lote')));
                    } else {
                        $this->set('lotes', $lotes->fetchAll($lotes->select()->order(array('quadra ASC', 'lote ASC'))->where('id_empreendimento = ?', $empreendimento), array('id_empreendimento', 'id_lote')));
                    }

                    //Banco
                    $banco = new Banco();
                    $this->set('bancos', $banco->fetchAll($banco->select()->where('id_empreendimento = ?', $empreendimento))->toArray());
                }

                //responsavel
                if ($contrato->id_pessoa)
                    $this->set('pessoa', $this->pessoa->find($contrato->id_pessoa)->current()->toArray());

                //pessoas envolvidas
                if ($pessoas_envolvidas) {
                    foreach ($pessoas_envolvidas as &$pessoa) {
                        $pessoa = $this->pessoa->findFisicaById($pessoa);
                    }
                    $this->set('pessoas_envolvidas', $pessoas_envolvidas);
                }

                unset($lotes, $contratos, $bancos, $corretores);

                //monta o sinal no retorno
                $sinal = array();
                for ($i = 1; $i <= $qtd_parcela_sinal; $i++) {
                    $sinal[$i]['valor'] = $this->_helper->filters($_POST["valor_$i"], 'money');
                    $sinal[$i]['dtVencimento'] = $this->_helper->filters($_POST["data_$i"], 'date');
                    $sinal[$i]['parcela'] = $i;
                    $sinal[$i]['idContrato'] = '';
                }
                $contrato = $contrato->toArray();
                $contrato['liberarSinal'] = true;
                $contrato['sinal'] = $sinal;

                $this->set('contrato', $contrato);
                $this->display('form');
            }
        } else {
            //Lista de empreendimento que o usuario possui acesso
            $tbEmpreendimento = new Empreendimento();
            $this->set('empreendimentos', $tbEmpreendimento->getEmpreendimentos());
            $this->display('form');
        }
    }

    /*
    * Exibe formulario de editar contrato e edita contrato
    */
    public function editarAction()
    { 
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'editarContrato')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'contrato', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $empreendimentos = $this->empreendimento->getDefaultAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {
            }
        }
        //Contrato
        $instanceContrato = new Contrato();
        $contrato = $instanceContrato->fetchRow('id = ' . $this->_helper->filters($_GET['id'], 'onlyNumber'));
        if($contrato['fl_distrato']=='1'){
            header("Location: ?m=adm&c=distrato&a=editar&id=".$this->_helper->filters($_GET['id'], 'onlyNumber'));
            die();
        }
        $idNomeCorretor = $contrato['id_corretor'];
        $contratoDesconto = $contrato['desconto'];
        $nomeBanco = $contrato['id_banco'];
        $contratoObs = $contrato['obs'];
        if (!$contrato) {
            $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "listar"), array("exception" => "O contrato no foi encontrado, tente novamente."));
        }
        $resultContrato = $instanceContrato->getContrato($_GET['id']);
        
        $this->set('lista_assinaturas',$this->tb_docusign->getById($resultContrato['docusign_envelope_id'],"recipient-completed"));

        $itensContrato = $this->itensContrato->fetchAll('id_contrato = ' . $this->_helper->filters($_GET['id'], 'onlyNumber'), 'id_contrato_itens ASC');
        $auxItens = array();
        $totalItemContrato = 0;
        foreach ($itensContrato as $item) {
            $auxItens[$item['tp_parcela']][] = $item->toArray();
            $totalItemContrato += ((float)$item['vl_parcela'] * (int)$item['qt_parcelas']);
        }
        $itensContrato = $auxItens;
        $this->set('itensContrato', $itensContrato);

        //Lote
        $instanceLote = new Lote();
        $resultLote = $instanceLote->getLote($resultContrato['id_lote']);

        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();
        $corretores = $this->corretor->getAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO), '')
            ->join(array('l' => TB_LOTES), 'e.id = l.id_empreendimento', '')
            ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', '')
            ->join(array('ce' => TB_CORRETOR_EMPREENDIMENTO), 'e.id = ce.id_empreendimento', '')
            ->join(array('p' => TB_PESSOA), 'ce.id_corretor = p.id', array('id', 'nm_pessoa'))
            ->where('e.id = ?', $resultLote['id_empreendimento'])
            ->group('p.id')
            ->query()->fetchAll();

        $this->set('empreendimentos', $empreendimentos);
        $this->set('clientes', $this->pessoa->fetchAll()->toArray());
        $this->set('corretores', $corretores);

        $tbIndiceEmprendimento = new IndiceEmpreendimento();
        $this->set('listaIndiceEmpreendimento', $tbIndiceEmprendimento->getIndiceEmpreendimento($resultLote['id_empreendimento']));
        if ($this->_isGet) {
            $total = ($resultContrato['vl_parcela'] * $resultContrato['nr_parcela']) +
                ($resultContrato['vl_intercalada'] * $resultContrato['nr_intercalada']) +
                ($resultContrato['vl_sinal']) +
                ($resultContrato['vl_parcela_entrega'] * $resultContrato['nr_parcela_entrega']) + $totalItemContrato;
            $total = Helper::getMoney($total);

            $this->set('total', $total);

            $resultContrato['dt_contrato'] = ($resultContrato['dt_contrato']) ? Helper::getDate($resultContrato['dt_contrato']) : '';
            $resultContrato['dt_sinal'] = ($resultContrato['dt_sinal']) ? Helper::getDate($resultContrato['dt_sinal']) : '';
            $resultContrato['dt_primeira_parcela'] = Helper::getDate($resultContrato['dt_primeira_parcela']);
            $resultContrato['dt_reajuste'] = Helper::getDate($resultContrato['dt_reajuste']);
            $resultContrato['dt_reajuste_mensal'] = Helper::getDate($resultContrato['dt_reajuste_mensal']);
            $resultContrato['dt_reajuste_intercalada'] = Helper::getDate($resultContrato['dt_reajuste_intercalada']);
            $resultContrato['dt_reajuste_chave'] = Helper::getDate($resultContrato['dt_reajuste_chave']);
            $resultContrato['vl_parcela'] = Helper::getMoney($resultContrato['vl_parcela']);
            $resultContrato['vl_sinal'] = Helper::getMoney($resultContrato['vl_sinal']);
            $resultContrato['vl_intercalada'] = Helper::getMoney($resultContrato['vl_intercalada']);
            $resultContrato['dt_fim_empreendimento'] =
                ($resultContrato['dt_fim_empreendimento'] && $resultContrato['dt_fim_empreendimento'] != '0000-00-00') ?
                Helper::getDate($resultContrato['dt_fim_empreendimento']) :
                '';
            $resultContrato['vl_parcela_entrega'] = Helper::getMoney($resultContrato['vl_parcela_entrega']);

            $resultContrato['id_empreendimento'] = $resultLote['id_empreendimento'];

            //Verifica os lotes disponiveis
            $tb_contratos = new Contrato();
            $reservaLote = new ReservaLote();
            $contratos = $tb_contratos->getAdapter()->select()->from(TB_CONTRATO, 'id_lote')->where("fl_distrato = '0' AND id != " . $this->_helper->filters($_GET['id'], 'onlyNumber'))->query()->fetchAll();
            $reservaLote = $reservaLote->getAdapter()->select()->from(array('rl' => TB_RESERVA_LOTE), array('cod_lote', 'reservado'))->where('rl.reservado = "1" AND cod_lote != ' . $resultContrato['id_lote'])->query()->fetchAll();
            if (!$contratos)
                $contratos = array('0');
            $sttm = $instanceLote->select()
                ->where('id_empreendimento = ?', $resultLote['id_empreendimento'])
                ->where('id NOT IN(?)', $contratos);
            if (count($reservaLote) > 0){
                if($resultContrato['fl_gerado']!= '1'){
                    $sttm = $sttm->where('reservado = "0"');
                    foreach($reservaLote as $reserv){
                        $sttm = $sttm->where('id NOT IN(?)', $reserv['cod_lote']);
                    }
                   
                }
            }
            $lotes = $instanceLote->fetchAll($sttm)->toArray();
            $this->set('lotes', $lotes);

            //Banco
            $instanceBanco = new Banco();
            $resultBanco = $instanceBanco->getBanco($resultContrato['id_banco']);
            $resultContrato['id_empreendimento'] = $resultBanco['id_empreendimento'];
            $bancos = $instanceBanco->fetchAll($instanceBanco->select()->where('id_empreendimento = ?', $resultBanco['id_empreendimento']))->toArray();

            foreach ($bancos as &$banco) {
                $banco['nmBanco'] = Banco::findBancoNome($banco['cd_banco']);
            }
            $this->set('bancos', $bancos);

            //busca as pacelas de sinais caso exista
            $sinal = $this->sinal->fetchAll('idContrato = ' . $this->_helper->filters($_GET['id'], 'onlyNumber'))->toArray();
            $resultContrato['sinal'] = array();
            if (count($sinal) > 0) {
                $resultContrato['sinal'] = $sinal;
            }

            //pessoa
            $this->set('pessoa', $this->pessoa->fetchRow('id = ' . $resultContrato['id_pessoa']));

            //pessoas envolvidas
            $pessoas_envolvidas = $this->pessoasEnvolvidas->findByContrato($this->_helper->filters($_GET['id'], 'onlyNumber'));
            $ctrt =  $this->_helper->filters($_GET['id'], 'onlyNumber');
            foreach ($pessoas_envolvidas as &$pessoa) {
                $pessoa = $this->pessoa->findFisicaById2($pessoa['id_pessoa'], $ctrt);
            }
            $this->set('pessoas_envolvidas', $pessoas_envolvidas);

            $this->set('contrato', $resultContrato);
            unset($instanceLote, $instanceContrato, $lotes, $resultContrato, $resultLote);

            $this->set('corretor', $this->contrato->fetchRow('id = ' . $this->_helper->filters($_GET['id'], 'onlyNumber'))->__get('id_corretor'));
            $this->display('form');
        } elseif ($this->_isPost) {
            $banco = $_POST['banco'];
            $lote = $_POST['lote'];
            $pessoas_envolvidas = $_POST['pessoas_envolvidas']; 
            $cliente = $_POST['cliente'];
            $corretor = $_POST['corretor'];
            $data_contrato = $_POST['data'];
            $valor = $_POST['vl_parcela'];
            $qtd_parcela = $_POST['qtd_parcela'];
            $sinal = $_POST['vl_sinal'];
            $fl_sinal = ($_POST['sinal_agregado'] == 'on') ? 1 : 0;
            $data_sinal = $_POST['dt_sinal'];
            $intercalada = $_POST['intercalada'];
            $qtd_parcela_intercalada = $_POST['qtd_parcela_intercalada'];
            $frequencia = $_POST['frequencia'];
            $nr_chave = ($_POST['qtd_parcela_chaves']) ? $_POST['qtd_parcela_chaves'] : null;
            $vl_chave = ($_POST['vl_chaves']) ? $_POST['vl_chaves'] : null;
            $data_chaves = ($_POST['dt_chaves']) ? $_POST['dt_chaves'] : null;
            $dt_primeira = $_POST['dt_primeira'];
            $dt_reajuste = $_POST['dt_reajuste'];
            $dt_reajuste_mensal = $_POST['dt_reajuste_mensal'];
            $dt_reajuste_intercalada = $_POST['dt_reajuste_intercalada'];
            $dt_reajuste_chave = $_POST['dt_reajuste_chave'];
            $dt_empreendimento = $_POST['dt_fim_empreendimento'];
            $coincidir = $_POST['coincidir'];
            $dt_intercalada = $_POST['data_intercalada'];
            $outrosCompradores = $_POST['listaIndices']; 
            $participacao = $_POST['participacao'];
            $participacao ? $participacao : $participacao = $contrato->porcentagem_participacao_contrato;
            //Verifica se a % de participao  menor que 100
            $somaParticipacao = $participacao ? $participacao: 0;
                foreach ($outrosCompradores as $dados) {
                    $indice = explode('_', $dados);
                    $somaParticipacao += $this->_helper->filters($indice[2], 'money');
                }
                if($somaParticipacao>100){
                    $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "editar"),array("id"=> $_GET['id'], "exception"=> 'A soma das participaes no pode ser superior a 100'));exit();
                    
                }elseif($outrosCompradores && $somaParticipacao<100){
                    $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "editar"),array("id"=> $_GET['id'], "exception"=> 'A soma das participaes no pode ser inferior a 100'));exit();
                }

            //Verifica as parcelas sinal com valor maior que zero
            $qtd_parcela_sinal = 0;
            if ($sinal)
                foreach ($sinal as $s) {
                    if ((float)$s > 0) {
                        $qtd_parcela_sinal++;
                    }
                }
            $contrato = $this->contrato->fetchRow($this->contrato->select()->where('id = ?', $this->_helper->filters($_GET['id'], 'onlyNumber')));
            //Verificando a Data Reajuste para gerar o log
            $dataAnterior =  $this->_helper->getDate($contrato['dt_reajuste']);
            $dataPosterior = $_POST['dt_reajuste'];
            if ($dataAnterior != $dataPosterior) {
                (new Relacionamento())->saveContato(56, date('Y-m-d'), $contrato['id'], 'Log: Data de Reajuste alterada de ' . $dataAnterior . ' para ' . $dataPosterior);
            }
            //Verificando a Data do Contrato para gerar o log
            $dataCtAnterior =  $this->_helper->getDate($contrato['dt_contrato']);
            $dataCtPosterior = $_POST['data'];
            if ($dataCtAnterior != $dataCtPosterior) {
                (new Relacionamento())->saveContato(56, date('Y-m-d'), $contrato['id'], 'Log: Data do Contrato alterada de ' . $dataCtAnterior . ' para ' . $dataCtPosterior);
            }

            // Log: Parcela Normal
            if($contrato->fl_desc_normal != $_POST['desconto_tp_normal']) {
                //Sem desconto para desconto em porcentagem
                if($contrato->fl_desc_normal == 'S' && $_POST['desconto_tp_normal'] == 'P') {
                    (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao de utilizao de desconto de parcela Normal de: ' . 
                    'SEM DESCONTO para DESCONTO EM PERCENTUAL'. '. Desconto alterado para: ' . $_POST['valor_desconto_normal'] . '%');                     
               
                //Sem desconto para desconto em R$
                }else if ($contrato->fl_desc_normal == 'S' && $_POST['desconto_tp_normal'] == 'V') {
                    (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao de utilizao de desconto de parcela Normal de: ' . 
                    'SEM DESCONTO para DESCONTO EM REAIS'. '. Desconto alterado para: '.$_SESSION['simboloMoeda'] . Helper::getMoney($_POST['valor_desconto_normal']));  
                
                //Desconto em porcentagem para R$
                }else if($contrato->fl_desc_normal == 'P' && $_POST['desconto_tp_normal'] == 'V')  {
                    (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao de utilizao de desconto de parcela Normal de: ' . 
                    'DESCONTO EM PERCENTUAL para DESCONTO EM REAIS'. '. Desconto alterado de: '. $contrato->vl_desc_normal . '% para: ' . $_SESSION['simboloMoeda']. Helper::getMoney($_POST['valor_desconto_normal']));  
                
                //Desconto em Reais para desconto em percentual
                }else if($contrato->fl_desc_normal == 'V' && $_POST['desconto_tp_normal'] == 'P') {
                    (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao de utilizao de desconto de parcela Normal de: ' . 
                    'DESCONTO EM PERCENTUAL para DESCONTO EM REAIS'. '. Desconto alterado de: '.$_SESSION['simboloMoeda']. $contrato->vl_desc_normal . ' para: ' . $_POST['valor_desconto_normal'].'%');                      

                //Desconto em percentual ou reais para sem desconto
                }else if($_POST['desconto_tp_normal'] == 'S') {
                    if($contrato->fl_desc_normal == 'P') {
                        (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao de utilizao de desconto de parcela Normal de: ' . 
                        $contrato->vl_desc_normal . '%' . ' para SEM DESCONTO');  
                    }else {
                        (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao de utilizao de desconto de parcela Normal de: R$' . 
                        Helper::getMoney($contrato->vl_desc_normal) . ' para SEM DESCONTO');  
                    }
                }
            }

            // Log: Parcela Sinal
            if($contrato->fl_desc_sinal != $_POST['desconto_tp_sinal']) {
                //Sem desconto para desconto em porcentagem
                if($contrato->fl_desc_sinal == 'S' && $_POST['desconto_tp_sinal'] == 'P') {
                    (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao de utilizao de desconto de parcela Sinal de: ' . 
                    'SEM DESCONTO para DESCONTO EM PERCENTUAL'. '. Desconto alterado para: ' . $_POST['valor_desconto_sinal'] . '%');                     
               
                //Sem desconto para desconto em R$
                }else if ($contrato->fl_desc_sinal == 'S' && $_POST['desconto_tp_sinal'] == 'V') {
                    (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao de utilizao de desconto de parcela Sinal de: ' . 
                    'SEM DESCONTO para DESCONTO EM REAIS'. '. Desconto alterado para: '.$_SESSION['simboloMoeda'] . Helper::getMoney($_POST['valor_desconto_sinal']));  
                
                //Desconto em porcentagem para R$
                }else if($contrato->fl_desc_sinal == 'P' && $_POST['desconto_tp_sinal'] == 'V')  {
                    (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao de utilizao de desconto de parcela Sinal de: ' . 
                    'DESCONTO EM PERCENTUAL para DESCONTO EM REAIS'. '. Desconto alterado de: '. $contrato->vl_desc_sinal . '% para: ' . 'R$'. Helper::getMoney($_POST['valor_desconto_sinal']));  
                
                //Desconto em Reais para desconto em percentual
                }else if($contrato->fl_desc_sinal == 'V' && $_POST['desconto_tp_sinal'] == 'P') {
                    (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao de utilizao de desconto de parcela Sinal de: ' . 
                    'DESCONTO EM PERCENTUAL para DESCONTO EM REAIS'. '. Desconto alterado de: '.$_SESSION['simboloMoeda']. $contrato->vl_desc_sinal . ' para: ' . $_POST['valor_desconto_sinal'].'%');                      

                //Desconto em percentual ou reais para sem desconto
                }else if($_POST['desconto_tp_sinal'] == 'S') {
                    if($contrato->fl_desc_sinal == 'P') {
                        (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao de utilizao de desconto de parcela Sinal de: ' . 
                        $contrato->vl_desc_sinal . '%' . ' para SEM DESCONTO');  
                    }else {
                        (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao de utilizao de desconto de parcela Sinal de: R$' . 
                        Helper::getMoney($contrato->vl_desc_sinal) . ' para SEM DESCONTO');  
                    }
                }
            }

            // Log: Parcela Intercalada
            if($contrato->fl_desc_intercalada != $_POST['desconto_tp_intercalada']) {
                //Sem desconto para desconto em porcentagem
                if($contrato->fl_desc_intercalada == 'S' && $_POST['desconto_tp_intercalada'] == 'P') {
                    (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao de utilizao de desconto de parcela Intercalada de: ' . 
                    'SEM DESCONTO para DESCONTO EM PERCENTUAL'. '. Desconto alterado para: ' . $_POST['valor_desconto_intercalada'] . '%');                     
               
                //Sem desconto para desconto em R$
                }else if ($contrato->fl_desc_intercalada == 'S' && $_POST['desconto_tp_intercalada'] == 'V') {
                    (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao de utilizao de desconto de parcela Intercalada de: ' . 
                    'SEM DESCONTO para DESCONTO EM REAIS'. '. Desconto alterado para: R$' . Helper::getMoney($_POST['valor_desconto_intercalada']));  
                
                //Desconto em porcentagem para R$
                }else if($contrato->fl_desc_intercalada == 'P' && $_POST['desconto_tp_intercalada'] == 'V')  {
                    (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao de utilizao de desconto de parcela Intercalada de: ' . 
                    'DESCONTO EM PERCENTUAL para DESCONTO EM REAIS'. '. Desconto alterado de: '. $contrato->vl_desc_intercalada . '% para: ' . 'R$'. Helper::getMoney($_POST['valor_desconto_intercalada']));  
                
                //Desconto em Reais para desconto em percentual
                }else if($contrato->fl_desc_intercalada == 'V' && $_POST['desconto_tp_intercalada'] == 'P') {
                    (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao de utilizao de desconto de parcela Intercalada de: ' . 
                    'DESCONTO EM PERCENTUAL para DESCONTO EM REAIS'. '. Desconto alterado de: R$'. $contrato->vl_desc_intercalada . ' para: ' . $_POST['valor_desconto_intercalada'].'%');                      

                //Desconto em percentual ou reais para sem desconto
                }else if($_POST['desconto_tp_intercalada'] == 'S') {
                    if($contrato->fl_desc_intercalada == 'P') {
                        (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao de utilizao de desconto de parcela Intercalada de: ' . 
                        $contrato->vl_desc_intercalada . '%' . ' para SEM DESCONTO');  
                    }else {
                        (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao de utilizao de desconto de parcela Intercalada de: R$' . 
                        Helper::getMoney($contrato->vl_desc_intercalada) . ' para SEM DESCONTO');  
                    }
                }
            }

            // Log: Parcela Chave
            if($contrato->fl_desc_chave != $_POST['desconto_tp_chave']) {
                //Sem desconto para desconto em porcentagem
                if($contrato->fl_desc_chave == 'S' && $_POST['desconto_tp_chave'] == 'P') {
                    (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao de utilizao de desconto de parcela Chave de: ' . 
                    'SEM DESCONTO para DESCONTO EM PERCENTUAL'. '. Desconto alterado para: ' . $_POST['valor_desconto_chave'] . '%');                     
               
                //Sem desconto para desconto em R$
                }else if ($contrato->fl_desc_chave == 'S' && $_POST['desconto_tp_chave'] == 'V') {
                    (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao de utilizao de desconto de parcela Chave de: ' . 
                    'SEM DESCONTO para DESCONTO EM REAIS'. '. Desconto alterado para: R$' . Helper::getMoney($_POST['valor_desconto_chave']));  
                
                //Desconto em porcentagem para R$
                }else if($contrato->fl_desc_chave == 'P' && $_POST['desconto_tp_chave'] == 'V')  {
                    (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao de utilizao de desconto de parcela Chave de: ' . 
                    'DESCONTO EM PERCENTUAL para DESCONTO EM REAIS'. '. Desconto alterado de: '. $contrato->vl_desc_chave . '% para: ' . 'R$'. Helper::getMoney($_POST['valor_desconto_chave']));  
                
                //Desconto em Reais para desconto em percentual
                }else if($contrato->fl_desc_chave == 'V' && $_POST['desconto_tp_chave'] == 'P') {
                    (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao de utilizao de desconto de parcela Chave de: ' . 
                    'DESCONTO EM PERCENTUAL para DESCONTO EM REAIS'. '. Desconto alterado de: R$'. $contrato->vl_desc_chave . ' para: ' . $_POST['valor_desconto_chave'].'%');                      

                //Desconto em percentual ou reais para sem desconto
                }else if($_POST['desconto_tp_chave'] == 'S') {
                    if($contrato->fl_desc_chave == 'P') {
                        (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao de utilizao de desconto de parcela Chave de: ' . 
                        $contrato->vl_desc_chave . '%' . ' para SEM DESCONTO');  
                    }else {
                        (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao de utilizao de desconto de parcela Chave de: R$' . 
                        Helper::getMoney($contrato->vl_desc_chave) . ' para SEM DESCONTO');  
                    }
                }
            }

            //Permite alterar apenas o banco, observacoes, corretor e Incluir sinal de contrato
            $contrato->id_corretor = $corretor;
            $contrato->id_banco = $banco;
            $contrato->desconto = $this->_helper->filters($_POST['desconto'], 'money');
            $contrato->obs = $this->_helper->filters($_POST['obs']);
            $contrato->inclui_sinal_contrato = $this->_helper->filters($_POST['incluiSinalContrato']);
            $contrato->porcentagem_participacao_contrato = $contrato->fl_gerado == '1' ? $participacao :  $this->_helper->filters($participacao, 'money');
            
            //salva as flags e valores
            $contrato->fl_desc_normal = $this->_helper->filters($_POST['desconto_tp_normal']);
            $contrato->fl_desc_sinal = $this->_helper->filters($_POST['desconto_tp_sinal']);
            $contrato->fl_desc_intercalada = $this->_helper->filters($_POST['desconto_tp_intercalada']);
            $contrato->fl_desc_chave = $this->_helper->filters($_POST['desconto_tp_chave']);
            //salva os valores dos descontos
            if ($_POST['desconto_tp_normal'] != 'S') {
                $contrato->vl_desc_normal = $this->_helper->filters($_POST['valor_desconto_normal'], 'money');
            } else {
                $contrato->vl_desc_normal = null;
            }
            if ($_POST['desconto_tp_sinal'] != 'S') {
                $contrato->vl_desc_sinal = $this->_helper->filters($_POST['valor_desconto_sinal'], 'money');
            } else {
                $contrato->vl_desc_sinal = null;
            }
            if ($_POST['desconto_tp_intercalada'] != 'S') {
                $contrato->vl_desc_intercalada = $this->_helper->filters($_POST['valor_desconto_intercalada'], 'money');
            } else {
                $contrato->vl_desc_intercalada = null;
            }
            if ($_POST['desconto_tp_chave'] != 'S') {
                $contrato->vl_desc_chave = $this->_helper->filters($_POST['valor_desconto_chave'], 'money');
            } else {
                $contrato->vl_desc_chave = null;
            }

            $contrato->dt_reajuste = $this->_helper->filters($dt_reajuste, 'date');
            $contrato->dt_reajuste_mensal = $this->_helper->filters($dt_reajuste_mensal, 'date');
            $contrato->dt_reajuste_intercalada = $this->_helper->filters($dt_reajuste_intercalada, 'date');
            $contrato->dt_reajuste_chave = $this->_helper->filters($dt_reajuste_chave, 'date');
            $contrato->dt_contrato = $this->_helper->filters($data_contrato, 'date');
            $contrato->fl_fm_pagamento = $_POST['tp_pagamento'];
            // Consultar Valor do ?ndice antigo no banco de dados
            $tb_Historicoreajuste = new HistoricoReajuste();
            $valIndiceAntigo = $tb_Historicoreajuste->getAdapter()->select()
                ->from(array('c' => TB_CONTRATO), array('id_indice'))
                ->join(array('ie' => TB_INDICE_EMPREENDIMENTO), 'c.id_indice = ie.id_indice_empreendimento', ['fl_periodo', 'fl_residuo', 'indice_adicional', 'fl_periodo_adc', 'id_indice as idIndice'])
                ->where('c.id = ' . $contrato['id'])
                ->query()->fetch();
            $tbAgrupada = AgrupadaGeral::buscar('12', $valIndiceAntigo['idIndice']);
            $valIndiceAntigo['descricao'] = $tbAgrupada['descricao'];

            // Consultar Valor do ?ndice Novo no banco de dados
            $indiceEmp = (new IndiceEmpreendimento())->fetchRow('id_indice_empreendimento = ' . $_POST['idIndice'])->toArray();

            if ($indiceEmp['id_indice']) {
                $tbAgrupada = AgrupadaGeral::buscar('12', $indiceEmp['id_indice']);
                $indiceEmp['descricao'] = $tbAgrupada['descricao'];
            }
            // Salvando no Log o indice se caso foi alterado
            if ($valIndiceAntigo['id_indice'] != $indiceEmp['id_indice_empreendimento']) {
                $caracterSomaAntigo = Helper::getNomePeriodo($valIndiceAntigo['fl_periodo']) != ''?' +':'';
                $indiceAdicionalAntigo = ($valIndiceAntigo['indice_adicional'] != '0') ? $caracterSomaAntigo . str_replace('.',',',number_format($valIndiceAntigo['indice_adicional'], 2)) . '%' : '';
                $logIndiceAntigo = $valIndiceAntigo['descricao'] . ' ' . Helper::getNomePeriodo($valIndiceAntigo['fl_periodo']) . ' ' . $indiceAdicionalAntigo . ' ' . Helper::getNomePeriodo($valIndiceAntigo['fl_periodo_adc']);
   
                $caracterSoma = Helper::getNomePeriodo($indiceEmp['fl_periodo']) != ''?' +':'';
                $indiceAdicional = ($indiceEmp['indice_adicional'] != '0') ? $caracterSoma . str_replace('.',',',number_format($indiceEmp['indice_adicional'], 2)) . '%' : '';
                $logIndiceAtual = $indiceEmp['descricao'] . ' ' . Helper::getNomePeriodo($indiceEmp['fl_periodo']) . ' ' . $indiceAdicional . ' ' . Helper::getNomePeriodo($indiceEmp['fl_periodo_adc']);
                
                (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao do ndice de:  ' .
                    $logIndiceAntigo . ' para: ' . $logIndiceAtual);
            }

            // Log -> Intermediacao Imobiliaria 
            if ($contrato['ds_intermediacao_imobiliaria'] != $_POST['dsIntermediacaoImobiliaria']) {
                (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao intermediao Imobilirias de: ' .
                    $contrato['ds_intermediacao_imobiliaria'] . ' Para: ' . $_POST['dsIntermediacaoImobiliaria']);
            }
            
            // Log -> Obs
            if ($contratoObs != $_POST['obs']) {
                (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao no campo Observao de: ' .
                    $contratoObs . ' Para: ' . $_POST['obs']);
            }
               
            // Log -> Desconto Por Parcela
            if ($_POST['desconto'] == '') $_POST['desconto'] = '0,00';
            if ( Helper::getMoney($contratoDesconto) != $_POST['desconto']){   
                if ( Helper::getMoney($contratoDesconto) != null || $_POST['desconto'] != '' ) {
                    (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao de desconto por parcela de: ' .
                    Helper::getMoney($contratoDesconto) . ' Para: ' . ($_POST['desconto'] == '0,00' ? '' : Helper::getMoney($_POST['desconto'])));
                }
            }

            // Consultar Corretor Antigo no banco de dados
            $tb_Corretor = new Corretor_Empreendimento();
            $nomeCorretor = $tb_Corretor->getAdapter()->select()
                ->from(array('ce' => TB_CORRETOR_EMPREENDIMENTO), '*')
                ->join(array('p' => TB_PESSOA), 'ce.id_corretor = p.id', 'nm_pessoa')
                ->where('ce.id_corretor = '. $idNomeCorretor)
                ->query()->fetch();
                
            // Consultar Corretor Novo no banco de dados
            $idCorretorNovo =  $_POST['corretor'];
            $tb_Corretor = new Corretor_Empreendimento();
            $nomeCorretorNovo = $tb_Corretor->getAdapter()->select()
                ->from(array('ce' => TB_CORRETOR_EMPREENDIMENTO), '*')
                ->join(array('p' => TB_PESSOA), 'ce.id_corretor = p.id', 'nm_pessoa')
                ->where('ce.id_corretor = ' . $idCorretorNovo)
                ->query()->fetch();

            // Log -> Corretor
            if ($idNomeCorretor != $_POST['corretor']) {
                (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao do Corretor : ' .
                $nomeCorretor['nm_pessoa'] . ' para: ' . $nomeCorretorNovo['nm_pessoa']);
            }

            //Consulta que traz o nome do banco Antigo
            $instanceNomeBanco = new banco();
            $buscarNomeBancoAntigo = $instanceNomeBanco->getAdapter()->select()
                ->from(array('b' => TB_BANCO), array('*'))
                ->join(array('ag' => TB_AGRUPADA),'b.cd_banco = ag.idCampo','descricao')
                ->where('b.id =' . $nomeBanco)
                ->where('ag.idTabela = "9"')
                ->query()->fetch();

            //Consulta que traz o nome do banco Novo 
            $novoNomeBanco = $_POST['banco'];
            $instanceNomeBanco = new banco();
            $buscarNomeBancoNovo = $instanceNomeBanco->getAdapter()->select()
                ->from(array('b' => TB_BANCO), array('*'))
                ->join(array('ag' => TB_AGRUPADA),'b.cd_banco = ag.idCampo','descricao')
                ->where('b.id =' . $novoNomeBanco)
                ->where('ag.idTabela = "9"')
                ->query()->fetch();   

            // Log -> Banco
            if ($nomeBanco != $novoNomeBanco) {
                (new Relacionamento())->saveContato(69, date('Y-m-d'), $contrato['id'], 'Log: Alterao Dados Contratos - Alterao do Banco de: ' .
                $buscarNomeBancoAntigo['descricao'].' - Ag.: '.$buscarNomeBancoAntigo['agencia'].'-'.$buscarNomeBancoAntigo['agencia_dv'] .' Cc.: '.$buscarNomeBancoAntigo['conta_corrente'] .'-'.$buscarNomeBancoAntigo['conta_corrente_dv'].
                ' para: '.$buscarNomeBancoNovo['descricao'].' - Ag.: '.$buscarNomeBancoNovo['agencia'].'-'.$buscarNomeBancoNovo['agencia_dv'] .' Cc.: '.$buscarNomeBancoNovo['conta_corrente'] .'-'.$buscarNomeBancoNovo['conta_corrente_dv']);                   
            }

            if (!$contrato['fl_gerado']) {
                $contrato->id_pessoa = $cliente;
                $contrato->id_lote = $lote;
                if ($intercalada == '' && $qtd_parcela_intercalada == '' && $frequencia == '' && $dt_intercalada == '') {
                    $contrato->fl_coinc_intercalada = '0';
                } else {
                    $contrato->fl_coinc_intercalada = $coincidir;
                }
                $contrato->dt_contrato = $this->_helper->filters($data_contrato, 'date');
                $contrato->nr_parcela = $this->_helper->filters($qtd_parcela);
                $contrato->vl_parcela = $this->_helper->filters($valor, 'money');
                if ($qtd_parcela_sinal > 0) {
                    $vl_sinal = 0;
                    foreach ($sinal as $k => $parcela) {
                        $vl_sinal += Helper::getInputMoney($parcela);
                    }
                    $contrato->nr_parcela_sinal = ($qtd_parcela_sinal) ? $qtd_parcela_sinal : null;
                    $contrato->vl_sinal = ($sinal) ? $vl_sinal : null;
                    $contrato->dt_sinal = $this->_helper->filters($data_sinal[0], 'date');
                } else {
                    $contrato->nr_parcela_sinal = null;
                    $contrato->vl_sinal = null;
                    $contrato->dt_sinal = null;
                }
                $contrato->fl_reajustavel_mensais = isset($_POST['fl_reajustavel_mensais']) ? 1 : 0;
                $contrato->fl_reajustavel_intercaladas = isset($_POST['fl_reajustavel_intercaladas']) ? 1 : 0;
                $contrato->fl_reajustavel_chaves = isset($_POST['fl_reajustavel_chaves']) ? 1 : 0;
                $contrato->dt_intercalada = $this->_helper->filters($dt_intercalada, 'date');
                $contrato->nr_intercalada = $this->_helper->filters($qtd_parcela_intercalada);
                $contrato->vl_intercalada = $this->_helper->filters($intercalada, 'money');
                $contrato->fr_intercalada = $this->_helper->filters($frequencia);
                $contrato->dt_primeira_parcela = $this->_helper->filters($dt_primeira, 'date');
                $contrato->fl_sinal_agregado = ($fl_sinal == 1) ? $fl_sinal : 0;
                $contrato->vl_parcela_entrega = $this->_helper->filters($vl_chave, 'money');
                $contrato->nr_parcela_entrega = $this->_helper->filters($nr_chave);
                $contrato->dt_parcela_entrega = $this->_helper->filters($data_chaves, 'date');
                $contrato->fl_fm_pagamento = $_POST['tp_pagamento'];
                //Valores da Tabela Price
                if ($_POST['tp_parcelamento'] == 'P') {
                    $contrato->vl_divida = $this->_helper->filters($_POST['vlDivida'], 'money');
                    $contrato->nr_meses_financiamento = $this->_helper->filters($_POST['qtMeses']);
                    $contrato->tx_juros = $this->_helper->filters($_POST['txJuros'], 'money');
                    
                    $contrato->vl_divida_sacoc = null;
                    $contrato->nr_meses_financiamento_sacoc = null;
                    $contrato->tx_juros_sacoc = null;
                } else {
                    $contrato->vl_divida_sacoc = $this->_helper->filters($_POST['vlrDivida'], 'money');
                    $contrato->nr_meses_financiamento_sacoc = $this->_helper->filters($_POST['qtdMeses']);
                    $contrato->tx_juros_sacoc = $this->_helper->filters($_POST['txsJuros'], 'money');

                    $contrato->vl_divida = null;
                    $contrato->nr_meses_financiamento = null;
                    $contrato->tx_juros = null;
                }
                //Verifica se existem parcelas de tipos adicionais para setar o flag de itens de contrato
                if (count($_POST['qtd_parcela_adicional']) > 0 || count($_POST['qtd_intercalada_adicional']) > 0 || count($_POST['qtd_chave_adicional']) > 0) {
                    $contrato->fl_itens_contrato = 1;
                } else {
                    $contrato->fl_itens_contrato = 0;
                }
                $contrato->dt_reajuste = $this->_helper->filters($dt_reajuste, 'date');
                $contrato->dt_reajuste_mensal = $this->_helper->filters($dt_reajuste_mensal, 'date');
                $contrato->dt_reajuste_intercalada = $this->_helper->filters($dt_reajuste_intercalada, 'date');
                $contrato->dt_reajuste_chave = $this->_helper->filters($dt_reajuste_chave, 'date');
 
                $contrato->dt_fim_empreendimento = $this->_helper->filters($dt_empreendimento, 'date');
            }
            $contrato->nr_proposta = $this->_helper->filters($_POST['nrProposta']);
            $contrato->id_indice = $this->_helper->filters($_POST['idIndice']);
            $contrato->ds_intermediacao_imobiliaria = $this->_helper->filters($_POST['dsIntermediacaoImobiliaria']);
            $contrato->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');

            if ($this->validarAction()) {
                $contrato->save();
                if ($contrato->id_indice != $_POST['idIndice']) {
                    //Grava a operacao no log de contatos realizados com o lote e quadra do contrato
                    (new Relacionamento())->saveContato(55, date('Y-m-d'), $contrato['id'], 'Log: Contrato Aprovado');
                }

                if (!$contrato['fl_gerado']) {
                    $itemContrato = new ContratoItens();
                    $itemContrato->delete('id_contrato = ' . $this->_helper->filters($_GET['id'], 'onlyNumber'));

                    $this->sinal->delete('idContrato = ' . $this->_helper->filters($_GET['id'], 'onlyNumber'));
                    if ($qtd_parcela_sinal > 0) {
                        foreach ($sinal as $k => $parcela) {
                            $rowSinal = $this->sinal->createRow();
                            $rowSinal->valor = $this->_helper->filters($parcela, 'money');
                            $rowSinal->dtVencimento = $this->_helper->filters($data_sinal[$k], 'date');
                            $rowSinal->parcela = $k + 1;
                            $rowSinal->idContrato = $contrato->id;
                            $rowSinal->save();
                        }
                    } else {
                        $this->sinal->delete('idContrato = ' . $this->_helper->filters($_GET['id'], 'onlyNumber'));
                    }
                    /**
                     * AJUSTA A TABELA DE CONTRATO ITENS CASO AS PARCELAS AINDA NAO TENHAM SIDO GERADAS
                     */
                    //Verifica se existem parcelas de tipos adicionais mensais
                    if (count($_POST['qtd_parcela_adicional']) > 0) {
                        foreach ($_POST['qtd_parcela_adicional'] as $k => $qtd_adicional) {
                            if ($qtd_adicional > 0) {
                                $itemContrato = new ContratoItens();
                                $itemContrato = $itemContrato->createRow();
                                $itemContrato->id_contrato = $this->_helper->filters($_GET['id'], 'onlyNumber');
                                $itemContrato->tp_parcela = 'N';
                                $itemContrato->vl_parcela = $this->_helper->filters($_POST['vl_parcela_adicional'][$k], 'money');
                                $itemContrato->qt_parcelas = $this->_helper->filters($qtd_adicional);
                                $itemContrato->fl_reajustavel = isset($_POST['reajustavel_parcela'][$k]) ? '1' : '0';
                                $itemContrato->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                                $itemContrato->save();
                            }
                        }
                    }
                    //Verifica se existem parcelas de tipos adicionais intercaladas
                    if (count($_POST['qtd_intercalada_adicional']) > 0) {
                        foreach ($_POST['qtd_intercalada_adicional'] as $k => $qtd_adicional) {
                            if ($qtd_adicional > 0) {
                                $itemContrato = new ContratoItens();
                                $itemContrato = $itemContrato->createRow();
                                $itemContrato->id_contrato = $this->_helper->filters($_GET['id'], 'onlyNumber');
                                $itemContrato->tp_parcela = 'I';
                                $itemContrato->vl_parcela = $this->_helper->filters($_POST['vl_intercalada_adicional'][$k], 'money');
                                $itemContrato->dt_parcela = $this->_helper->filters($_POST['dt_intercalada_adicional'][$k], 'date');
                                $itemContrato->nr_frequencia = $this->_helper->filters($_POST['fr_intercalada_adicional'][$k]);
                                $itemContrato->qt_parcelas = $this->_helper->filters($_POST['qtd_intercalada_adicional'][$k]);
                                $itemContrato->fl_reajustavel = isset($_POST['reajustavel_intercalada'][$k]) ? '1' : '0';
                                $itemContrato->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                                $itemContrato->save();
                            }
                        }
                    }
                    //Verifica se existem parcelas de tipos adicionais chaves
                    if (count($_POST['qtd_chave_adicional']) > 0) {
                        foreach ($_POST['qtd_chave_adicional'] as $k => $qtd_adicional) {
                            if ($qtd_adicional > 0) {
                                $itemContrato = new ContratoItens();
                                $itemContrato = $itemContrato->createRow();
                                $itemContrato->id_contrato = $this->_helper->filters($_GET['id'], 'onlyNumber');
                                $itemContrato->tp_parcela = 'C';
                                $itemContrato->vl_parcela = $this->_helper->filters($_POST['vl_chave_adicional'][$k], 'money');
                                $itemContrato->qt_parcelas = $this->_helper->filters($qtd_adicional);
                                $itemContrato->fl_reajustavel = isset($_POST['reajustavel_chave'][$k]) ? '1' : '0';
                                $itemContrato->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                                $itemContrato->save();
                            }
                        }
                    }
                /*
                 * Adiciona as pessoas envolvidas na tabela CONTRATO_PESSOA e remove os registros antigos
                 * Precisar ser executado apos o save() pois necessita do Id do contrato
                */
                
                    $this->pessoasEnvolvidas->deleteByContrato($this->_helper->filters($_GET['id'], 'onlyNumber'));
                    if (count($outrosCompradores)) {

                        foreach ($outrosCompradores as $pessoa) {
                            $indice = explode('_', $pessoa);
                            if ($pessoa && $pessoa != 0) {
                                $dados = array();
                                $dados['id_pessoa'] = $indice[3];
                                $dados['id_contrato'] = $this->_helper->filters($_GET['id'], 'onlyNumber');
                                $dados['porcentagem_participacao_contrato'] = $this->_helper->filters($indice[2], 'money');
                                $this->pessoasEnvolvidas->addContratoPessoa($dados);
                            }
                        }
                    }
                } 

                $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "listar"), array("msg" => "success"));
            } else {
                /** mostra o formulario do mesma forma que estava anteriormente
                 * so que agora com as mensagens de erro
                 */
                $contrato = $contrato->toArray();

                //monta o sinal no retorno
                $sinal = array();
                for ($i = 1; $i <= $qtd_parcela_sinal; $i++) {

                    $sinal[$i]['valor'] = $this->_helper->filters($_POST["valor_$i"], 'money');
                    $sinal[$i]['dtVencimento'] = $this->_helper->filters($_POST["data_$i"], 'date');
                    $sinal[$i]['parcela'] = $i;
                    $sinal[$i]['idContrato'] = $contrato['id'];
                }

                //Banco
                $instanceBanco = new Banco();
                $resultBanco = $instanceBanco->find($contrato['id_banco'])->current()->toArray();
                $contrato['id_empreendimento'] = $resultBanco['id_empreendimento'];
                $bancos = $instanceBanco->fetchAll($instanceBanco->select()->where('id_empreendimento = ?', $resultBanco['id_empreendimento']))->toArray();
                $this->set('bancos', $bancos);

                //Lote
                $instanceLote = new Lote();
                $resultLote = $instanceLote->find($contrato['id_lote'])->current()->toArray();
                $contrato['id_empreendimento'] = $resultLote['id_empreendimento'];
                $lotes = $instanceLote->fetchAll($instanceLote->select()->where('id_empreendimento = ?', $resultLote['id_empreendimento']))->toArray();
                $this->set('lotes', $lotes);

                //pessoa
                $this->set('pessoa', $this->pessoa->find($contrato['id_pessoa'])->current()->toArray());

                //pessoas envolvidas
                $pessoas_envolvidas = $this->pessoasEnvolvidas->findByContrato($contrato['id']);
                foreach ($pessoas_envolvidas as &$pessoa) {
                    $pessoa = $this->pessoa->findFisicaById($pessoa['id_pessoa']);
                }
                $this->set('pessoas_envolvidas', $pessoas_envolvidas);

                $resultContrato = $this->contrato->fetchRow('id = ' . $contrato['id']);
                // corretor
                $this->set('corretor', $resultContrato->__get('id_corretor'));

                $contrato['sinal'] = $sinal;
                $contrato['vl_parcela_entrega'] = Helper::getMoney($resultContrato['vl_parcela_entrega']);

                $this->set('contrato', $contrato);
            }
        }
        $this->display('form');
    }

    /**
     * Acao reponsavel por realizar a exclusao de um contrato
     */
    public function deletarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'deletarContrato')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'contrato', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
            exit;
        }
        // Nesse momento vamos apagar as parcelas de uma tabela e jogar no historico.
        $tb_parcelas = new Parcela();
        $parcelasBoleto = $tb_parcelas->fetchAll('id_contrato = ' . $this->_helper->filters($_GET['id'], 'onlyNumber') . ' AND fl_envio = "1"')->toArray();

        // Nesse momento vamos apagar as parcelas de uma tabela e jogar no historico.
        $tb_parcelas = new Parcela();
        $parcelas = $tb_parcelas->fetchAll('id_contrato = ' . $this->_helper->filters($_GET['id'], 'onlyNumber') . ' AND pago = "1"')->toArray();

        // Verifica se possui documentos cadastrados
        $tbGedDocumentoContrato = new GedDocumentoContrato();
        $gedDocumentoContrato = $tbGedDocumentoContrato->fetchAll('id_contrato = ' . $this->_helper->filters($_GET['id'], 'onlyNumber'))->toArray();
        if ($gedDocumentoContrato) {
            $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "listar"), array("exception" => 'No foi possvel realizar a operao. Este Contrato possui documentos no Acade Ged.'));
        } elseif ($parcelas) {
            $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "listar"), array("exception" => 'No foi possvel realizar a operao. Este Contrato possui parcelas pagas.'));
            exit;
        } else {
            if (count($parcelasBoleto) > 0) {
                $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "listar"), array("exception" => 'No foi possvel realizar a operao. Este Contrato possui parcelas enviadas.'));
                exit;
            } else {
                try {
                    //Altera o status do lote para disponvel("D")
                    $contratoStatusLote = (new Contrato())->getDefaultAdapter()->select()
                    ->from(['c' => TB_CONTRATO], 'id_lote')
                    ->where('c.id = "' . $_GET['id'] . '"')
                    ->query()->fetch();
                    
                    $statusLote = new Lote();
                    $statusLote = $statusLote->fetchRow('id = ' . $contratoStatusLote['id_lote']);
                    $statusLote->status = 'D';
                    $statusLote->save();
                    //Inicia a transacao com banco de dados
                    $db = Zend_Db_Table::getDefaultAdapter();
                    $db->beginTransaction();
                    //
                    $table = Zend_Db_Table::getDefaultAdapter();

                    //deleta cartas associados ao contrato
                    $tbRemessaItens = new RemessaItens();
                    if ($tbRemessaItens->fetchAll("id_contrato = {$this->_helper->filters($_GET['id'], 'onlyNumber')}"))
                        $tbRemessaItens->delete('id_contrato = ' . $this->_helper->filters($_GET['id'], 'onlyNumber'));

                    //deleta cartas associados ao contrato
                    $tbCartaHistorio = new CartaHistorico();
                    if ($tbCartaHistorio->fetchAll("id_contrato = {$this->_helper->filters($_GET['id'], 'onlyNumber')}"))
                        $tbCartaHistorio->delete('id_contrato = ' . $this->_helper->filters($_GET['id'], 'onlyNumber'));

                    //deleta relacionamentos associados ao contrato
                    $tbRelacionamento = new Relacionamento();
                    $listaRelacionamento = $tbRelacionamento->fetchAll("idContrato = {$this->_helper->filters($_GET['id'], 'onlyNumber')}");
                    if ($listaRelacionamento)
                        $tbRelacionamento->delete('idContrato = ' . $this->_helper->filters($_GET['id'], 'onlyNumber'));

                    //deleta parcelas do historico caso exista
                    $parcelasContratoHistorico = $this->parcelasHistorico->fetchAll("id_contrato = {$this->_helper->filters($_GET['id'], 'onlyNumber')}");
                    if ($parcelasContratoHistorico)
                        $this->parcelasHistorico->delete('id_contrato = ' . $this->_helper->filters($_GET['id'], 'onlyNumber'));

                    //deleta contrato do historico caso exista
                    $contratoHistorico = $this->contratoHistorico->fetchRow("id = {$this->_helper->filters($_GET['id'], 'onlyNumber')}");
                    if ($contratoHistorico)
                        $this->contratoHistorico->delete('id = ' . $this->_helper->filters($_GET['id'], 'onlyNumber'));

                    //adiciona o contrato atual no historico
                    $contrato = $this->contrato->fetchRow("id = {$this->_helper->filters($_GET['id'], 'onlyNumber')}")->toArray();
                    $contrato["log"] = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                    $table->insert(TB_CONTRATO_HISTORICO, $contrato);

                    //adiciona as parcelas atuais no historico
                    $parcelasContrato = $this->parcelas->fetchAll("id_contrato = {$this->_helper->filters($_GET['id'], 'onlyNumber')}")->toArray();
                    if ($parcelasContrato) {
                        foreach ($parcelasContrato as $parc) {
                            $parc["log"] = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                            $table->insert(TB_PARCELA_HISTORICO, $parc);
                        }
                    }

                    //deleta pessoas envolvidas
                    $pessoaEnvolvidas = $this->pessoasEnvolvidas->fetchAll('id_contrato = ' . $this->_helper->filters($_GET['id'], 'onlyNumber'));
                    if ($pessoaEnvolvidas)
                        $this->pessoasEnvolvidas->deleteByContrato($this->_helper->filters($_GET['id'], 'onlyNumber'));

                    //deleta parcelas sinais
                    $parcelasSinais = $this->sinal->fetchAll('idContrato = ' . $this->_helper->filters($_GET['id'], 'onlyNumber'));
                    if ($parcelasSinais)
                        $this->sinal->delete('idContrato = ' . $this->_helper->filters($_GET['id'], 'onlyNumber'));

                    //deleta itens de contrato
                    $itensContrato = $this->itensContrato->fetchAll('id_contrato = ' . $this->_helper->filters($_GET['id'], 'onlyNumber'));
                    if ($itensContrato)
                        $this->itensContrato->delete('id_contrato = ' . $this->_helper->filters($_GET['id'], 'onlyNumber'));

                    //deleta da tabela de parcela e o contrato
                    $this->parcelas->delete('id_contrato = ' . $this->_helper->filters($_GET['id'], 'onlyNumber'));
                    $this->contrato->delete("id = {$this->_helper->filters($_GET['id'], 'onlyNumber')}");

                    //Persiste as alteracoes
                    $db->commit();

                    $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "listar"), array("msg" => "success"));
                } catch (Exception $e) {
                    $db->rollBack();
                    $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "listar"), array("exception" => 'Houve algum erro, entre em contato com suporte. ' . $e->getMessage()));
                }
            }
        }
    }

    public function validarAction($qtdParcNormal = null, $dtParcNormal = null, $qtdParcInterc = null, $dtParcInterc = null, $qtdFrequencia = null, $coincidir = null)
    {
        //Verificando se as datas das parcelas estao corretas
        if ($qtdParcNormal && $dtParcNormal && $qtdParcInterc && $dtParcInterc && $qtdFrequencia == 1 && $coincidir == 0) {
            $listaParcNormal = Contrato::getParcelas($dtParcNormal, $qtdParcNormal);
            $listaParcInterc = Contrato::getParcelas($dtParcInterc, $qtdParcInterc);
            $primeiraParcNormal = strtotime(current($listaParcNormal));
            $ultimaParcNormal = strtotime(end($listaParcNormal));
            $primeiraParcInterc = strtotime(current($listaParcInterc));
            $ultimaParcInterc = strtotime(end($listaParcInterc));
            if ($primeiraParcInterc < $primeiraParcNormal && $primeiraParcNormal <= $ultimaParcInterc) {
                $this->_helper->addMensagem('dt_primeira', 'A primeira data das parcelas normais no pode ser menor ou igual a ultima data das parcelas intercaladas, quando a frequencia  1 e a opo de no coincidir parcelas estiver marcada.');
            } else if ($primeiraParcNormal < $primeiraParcInterc && $primeiraParcInterc <= $ultimaParcNormal) {
                $this->_helper->addMensagem('intercalada', 'A primeira data das parcelas intercaladas no pode ser menor ou igual a ultima data das parcelas normais, quando a frequencia  1 e a opo de no coincidir parcelas estiver marcada.');
            } else if ($primeiraParcNormal == $primeiraParcInterc) {
                $this->_helper->addMensagem('dt_primeira', 'As primeiras datas das parcelas intercaladas e normais no podem ser iguais, quando a frequencia  1 e a opo de no coincidir parcelas estiver marcada.');
            }
        }

        $validar = explode('/', $dtParcNormal);
        if($dtParcNormal && $validar[2] < 1900){
            $this->_helper->addMensagem('dt_primeira', 'A data da primeira parcela normal no pode ser inferior a 1900.');
        }
        $validar = explode('/', $dtParcInterc);
        if($dtParcInterc && $validar[2] < 1900){
            $this->_helper->addMensagem('dt_primeira', 'A data da primeira parcela intercalada no pode ser inferior a 1900.');
        }
        $validar = explode('/', $_POST['data']);
        if($validar[2] < 1900){
            $this->_helper->addMensagem('dt_contrato', 'A data do contrato no pode ser inferior a 1900.');
        }
        if ($this->isAjax()) {
            $_POST = $_POST['formData'];
        }

        if (count($_POST) && is_array($_POST)) {
            $campos = $_POST;

            foreach ($campos as $ind => $campo) {

                if ($_POST[$ind] == "") {
                    switch ($ind) {
                        case 'empreendimento':
                            $msg = "Selecione algum empreendimento.";
                            $this->_helper->addMensagem($ind, $msg);
                            break;
                        case 'banco':
                            $msg = "Selecione algum Banco.";
                            $this->_helper->addMensagem($ind, $msg);
                            break;
                        case 'lote':
                            $msg = "Selecione algum lote.";
                            $this->_helper->addMensagem($ind, $msg);
                            break;
                        case 'cliente':
                            $msg = "Digite o nome do comprador responsavel.";
                            $this->_helper->addMensagem($ind, $msg);
                            break;
                        case 'corretor':
                            $msg = "Selecione algum corretor.";
                            $this->_helper->addMensagem($ind, $msg);
                            break;
                    }
                }
                if ($_POST['desconto_tp_normal'] != 'S' && ($_POST['valor_desconto_normal'] == '' || $_POST['valor_desconto_normal'] <= 0)) {
                    $this->_helper->addMensagem('desconto_tp_normal', 'O campo <b>Desconto</b> das Parcelas Normais deve ser preenchido se selecionado Em Valor/Em Porcentagem');
                }
                if ($_POST['desconto_tp_sinal'] != 'S' && ($_POST['valor_desconto_sinal'] == '' || $_POST['valor_desconto_sinal'] <= 0)) {
                    $this->_helper->addMensagem('desconto_tp_sinal', 'O campo <b>Desconto</b> das Parcelas Sinais deve ser preenchido se selecionado Em Valor/Em Porcentagem');
                }
                if ($_POST['desconto_tp_intercalada'] != 'S' && ($_POST['valor_desconto_intercalada'] == '' || $_POST['valor_desconto_intercalada'] <= 0)) {
                    $this->_helper->addMensagem('desconto_tp_intercalada', 'O campo <b>Desconto</b> das Parcelas Intercaladas deve ser preenchido se selecionado Em Valor/Em Porcentagem');
                }
                if ($_POST['desconto_tp_chave'] != 'S' && ($_POST['valor_desconto_chave'] == '' || $_POST['valor_desconto_chave'] <= 0)) {
                    $this->_helper->addMensagem('desconto_tp_chave', 'O campo <b>Desconto</b> das Parcelas Chaves deve ser preenchido se selecionado Em Valor/Em Porcentagem');
                }

                if ($_POST['vl_parcela'] || $_POST['qtd_parcela'] || $_POST['dt_primeira']) {
                    if ($_POST['vl_parcela'] == '')
                        $this->_helper->addMensagem('vl_parcela', 'Se for preenchido valores de parcelas normais o campo Valor  obrigatrio.');
                    if ($_POST['qtd_parcela'] == '')
                        $this->_helper->addMensagem('qtd_parcela', 'Se for preenchido valores de parcelas normais o campo Qtde  obrigatrio.');
                    if ($_POST['dt_primeira'] == '')
                        $this->_helper->addMensagem('dt_primeira', 'Se for preenchido valores de parcelas normais o campo Data  obrigatrio.');
                }

                if ($_POST['vlSinal'] || $_POST['qtdSinal']) {
                    if ($_POST['vlSinal'] == '')
                        $this->_helper->addMensagem('vlSinal','Se for preenchido valores de parcela sinal o campo Valor  obrigatrio.');
                    if ($_POST['qtdSinal'] == '')
                        $this->_helper->addMensagem('qtdSinal', 'Se for preenchido valores de parcela sinal o campo Qtde  obrigatrio.');
                }

                if ($_POST[$ind]) {
                    switch ($ind) {
                        case 'intercalada':
                            $_POST['qtd_parcela_intercalada'] = (strlen(trim($_POST['qtd_parcela_intercalada'])) != 0 ? (int)$_POST['qtd_parcela_intercalada'] : NULL);
                            $_POST['frequencia'] = (strlen(trim($_POST['frequencia'])) != 0 ? (int)$_POST['frequencia'] : NULL);
                            $_POST['qtd_parcela'] = (int)$_POST['qtd_parcela'];
                            if ($_POST['qtd_parcela_intercalada'] === 0 || $_POST['frequencia'] === 0) {
                                $msg = "A quantidade de parcela e a frequencia tem que ser numrico e maior que 0 (zero).";
                                $this->_helper->addMensagem($ind, $msg);
                            }
                            break;

                        case 'sinal':
                            $_POST['qtd_parcela_sinal'] = (strlen(trim($_POST['qtd_parcela_sinal'])) != 0 ? (int)$_POST['qtd_parcela_sinal'] : NULL);
                            $_POST['qtd_parcela'] = (int)$_POST['qtd_parcela'];
                            if ($_POST['qtd_parcela_sinal'] === 0) {
                                $msg = "A quantidade de parcela tem que ser numrico e maior que 0 (zero).";
                                $this->_helper->addMensagem($ind, $msg);
                            }
                            if ($_POST['qtd_parcela_sinal'] && !$_POST['id']) {
                                //compara se a soma das parcelas bate com o total do sinal
                                $sinal = Helper::getInputMoney($_POST['sinal']);

                                $valor = 0;
                                for ($i = 1; $i <= $_POST['qtd_parcela_sinal']; $i++) {
                                    $valor += Helper::getInputMoney($_POST['valor_' . $i]);
                                }

                                if ((string)$valor != (string)$sinal) {
                                    $msg = "A soma dos valores parcelados do sinal no confere com o valor total do sinal.";
                                    $this->_helper->addMensagem($ind, $msg);
                                }
                                $msg = "Verifique as datas das parcelas de n: ";
                                for ($i = 1; $i <= $_POST['qtd_parcela_sinal']; $i++) {
                                    $data = explode("/", $_POST["data_$i"]);
                                    $d = $data[0];
                                    $m = $data[1];
                                    $y = $data[2];

                                    if (!checkdate($m, $d, $y)) {
                                        $msg = $msg . "$i,";
                                    }
                                }
                                $msg = rtrim($msg, ",");
                                if ($msg <> "Verifique as datas das parcelas de n: ")
                                    $this->_helper->addMensagem($ind, $msg);
                            }
                            break;

                        case 'vl_chaves':
                            $_POST['qtd_parcela_chaves'] = (strlen(trim($_POST['qtd_parcela_chaves'])) != 0 ? (int)$_POST['qtd_parcela_chaves'] : NULL);
                            $_POST['qtd_parcela'] = (int)$_POST['qtd_parcela'];
                            if ($_POST['vl_chaves'] && $_POST['qtd_parcela_chaves'] > 0 && $_POST['vl_parcela'] && $_POST['qtd_parcela'] > 0) {
                                $msg = 'A quantidade de parcela de chaves tem que ser menor ou igual a quantidade de parcela do valor normal.';
                                $_POST['qtd_parcela_chaves'] > $_POST['qtd_parcela'] ? $this->_helper->addMensagem($ind, $msg) : '';
                            } elseif ($_POST['qtd_parcela_chaves'] === 0) {
                                $msg = "A quantidade de parcela tem que ser numericos e maior que 0 (zero).";
                                $this->_helper->addMensagem($ind, $msg);
                            }
                            break;

                        case 'dt_primeira':
                            if ($_POST['dt_primeira'] && (strtotime(Helper::getInputDate($_POST['dt_primeira'])) < strtotime(Helper::getInputDate($_POST['data'])))) {

                                $msg = "A data da 1; parcela tem que ser maior ou igual a data de contrato.";

                                $this->_helper->addMensagem($ind, $msg);
                            }
                            break;
                    }
                }
            }
        }

        if ($this->isAjax()) {
            echo json_encode(array((!count($this->_helper->getMensagens()) > 0), $this->_helper->getMensagens()));
            return false;
        } else {
            return !(count($this->_helper->getMensagens()) > 0);
        }
    }

    public function gerarContratoAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'gerarContrato')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'contrato', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $empreendimentos = $this->empreendimento->getDefaultAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO));
        
        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {
            }
        }
        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();
        $this->set('empreendimentos', $empreendimentos);

        $listaTipoContrato = Db_TabelaAgrupada::findByTabelaId(4, null, 'descricao');
        $auxTipoContrato = array();
        foreach ($listaTipoContrato as $tipoContrato) {
            if ($tipoContrato['complemento'] == '1')
                $auxTipoContrato[] = $tipoContrato;
        }

        $modeloArquivo = new ModeloArquivo();
        $this->set('listaTipoContrato', $auxTipoContrato);
        $this->set('listaModelos', (new Modelo())->fetchAll('tp_modelo = "QR"'));
        $this->set('listaArquivoWord', $modeloArquivo->fetchAll($modeloArquivo->select()->order('nm_titulo')->where('tp_modelo = "QR" and fl_status = "1"')));
        $this->set('permissaoSuper', Login::isSuper());
        $this->set('get', $_GET);
        $this->set('cliente', Db_Cliente::getCliente());

        //Grava a operacao no log de contatos
        $tbAgrupada = new TabelaAgrupada();
        $tipoContrato = $tbAgrupada->fetchRow("idTabela = '4' AND idCampo = '{$_POST['tp_contrato']}'");
        (new Relacionamento())->saveContato(13, date('Y-m-d'), $_POST['contrato'], "Log: Impresso contrato quadro resumo tipo: {$tipoContrato->descricao}.");

        if ($this->_isGet) {
            if($_GET['quebrarPagina']){
                $_POST = $_GET;
                
                $this->gerarQuadroResumoAction();
            }
            $this->display('gerar');

        }
        if ($this->_isPost) {
            $this->gerarQuadroResumoAction();
        }
    }

    /**
     * Vai gerar o PDF do quadro resumo de acordo com o tipo escolhido no select
     */
    public function gerarQuadroResumoAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'gerarQuadroResumoContrato')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'contrato', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        if($_POST['tipoEmissao']== 'W'){
            $_SESSION['tipoDoc'] = 'word';
        }
        else{
            $_SESSION['tipoDoc'] = 'pdf';
        }
        $empresa = new Db_Cliente();
        $empreendimentos = new Empreendimento();
        $pessoas = new Pessoa();
        $pessoas_fisicas = new Pessoa_Fisica();
        $pessoas_juridicas = new Pessoa_Juridica();
        $lotes = new Lote();
        $contratos = new Contrato();
        $assinaturas = new Assinatura();
        $parcerias = new Parceria();
        $tb_sinal = new Sinal();
        $tb_banco = new Banco();

        $empreendimento = $empreendimentos->fetchRow('id = ' . $this->_helper->filters($_POST['empreendimento']))->toArray();
        $contrato = $contratos->fetchRow('id = ' . $this->_helper->filters($_POST['contrato']))->toArray();
        $lote = $lotes->fetchRow('id = ' . $contrato['id_lote']);
        $cliente = $pessoas->fetchRow('id = ' . $contrato['id_pessoa'])->toArray();
        $assinatura = $assinaturas->fetchAll('id_empreendimento = ' . $this->_helper->filters($_POST['empreendimento']))->toArray();
        $parceria = $parcerias->fetchAll('id_empreendimento = ' . $this->_helper->filters($_POST['empreendimento']))->toArray();
        $sinal = $tb_sinal->fetchAll('idContrato = ' . $this->_helper->filters($_POST['contrato']));
        $banco = $tb_banco->fetchRow('id = ' . $contrato['id_banco']);
        $empresa = $empresa->fetchAll()[0]->toArray();
        $empresa['cidade'] = Db_Cidade::find($empresa['cd_municipio'])->toArray();
        $paginaInicial = $this->_helper->filters($_POST['de']);
        $paginaFinal = $this->_helper->filters($_POST['ate']);

        if ($sinal)
            $sinal = $sinal->toArray();
        else
            $sinal = array();
        
        if ($cliente['tp_pessoa'] == 'F') {
            
            $pf = $pessoas_fisicas->fetchRow('id_pessoa = ' . $cliente['id']);
            
            if (is_object($pf)){
                $pf = $pessoas_fisicas->fetchRow('id_pessoa = ' . $cliente['id'])->toArray();
            } else {
                $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "listar"), array("exception" => 'Houve algum erro com o cadastro de pessoa fsica, entre em contato com suporte. '));
            }
            
            if ($pf['est_civil'])
                $cliente['est_civil_nome'] = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $pf['est_civil'])->getDescricao();
            
            if (($pf['est_civil'] == 'CAS' || $pf['est_civil']) == 'UNE' && $pf['cd_conjuge']) {

                $pessoaConjuge = $pessoas->fetchRow('id = ' . $pf['cd_conjuge']);
                $pessoaFisicaConjuge = $pessoas_fisicas->fetchRow('id_pessoa = ' . $pf['cd_conjuge']);

                if ($pessoaConjuge && $pessoaFisicaConjuge) {

                    $cliente['conjugeP'] = $pessoaConjuge;
                    $cliente['conjugePF'] = $pessoaFisicaConjuge;
                    
                    if ($pessoaConjuge['cd_cidade']) {
                        $cidadeConjuge = new Cidade();
                        $cidadeConjuge = $cidadeConjuge->fetchRow('id = ' . $pessoaConjuge['cd_cidade']);   
                        $cliente['conjuge']['nm_cidade'] = $cidadeConjuge['nome'];
                    }
                }
            }
            
            //Poderia ser pessoa fisica e corretor
            if ($pf['tp_pessoa']) {
                unset($pf['tp_pessoa']);
                $cliente = array_merge($cliente, $pf);
            }
        } elseif ($cliente['tp_pessoa'] == 'J') {
            $cliente = array_merge($cliente, $pessoas_juridicas->fetchRow('id_pessoa = ' . $cliente['id'])->toArray());
            $representante = new Representante();
            $cliente['representantes'] = $representante->listaRepresentantesDaPessoaJuridica($cliente['id']);
        }
        
        $cliente['cidade'] = ($cidade = Db_Cidade::find($cliente['cd_cidade'])) ? $cidade->toArray() : array();
        $reajuste = array(
            'M' => 'Mensal',
            'B' => 'Bimestral',
            'T' => 'Timestral',
            'S' => 'Semestral',
            'A' => 'Anual',
            'AM' => 'Anual + Mensal'
        );

        $citacao = '';
        foreach ($parceria as $parc)
            $citacao .= $this->gerarCitacao($pessoas->fetchRow('id = ' . $parc['id_pessoa'])->toArray());

        $citacaoDados = '';
        if ($_POST['tp_contrato'] == '3') {
            foreach ($parceria as $parc)
                $citacaoDados .= ' ' . $this->gerarCitacaoDadosAg($pessoas->fetchRow('id = ' . $parc['id_pessoa'])->toArray());
        } else {
            foreach ($parceria as $parc)
                $citacaoDados .= ' ' . $this->gerarCitacaoDados($pessoas->fetchRow('id = ' . $parc['id_pessoa'])->toArray());
        }

        $itensContrato = $this->itensContrato->fetchAll('id_contrato = ' . $contrato['id']);
        $auxItens = array();
        foreach ($itensContrato as $item)
            $auxItens[$item['tp_parcela']][] = $item->toArray();
        $itensContrato = $auxItens;

        $tbIndiceEmpreendimento = new IndiceEmpreendimento();
        $indiceEmpreendimento = $tbIndiceEmpreendimento->fetchRow('id_indice_empreendimento = ' . $contrato['id_indice']);
        $indiceAdicional = $indiceEmpreendimento['indice_adicional'] != '0'?' +' . str_replace('.',',',number_format($indiceEmpreendimento['indice_adicional'], 2)) . '%':'';
        if ($indiceEmpreendimento['id_indice']) {
            $indice = AgrupadaGeral::buscar(Db_TabelaAgrupada::TABLE_INDICE, $indiceEmpreendimento['id_indice']);
            $indice = $indice['descricao'];
        } else { 
            $indice = '';
        }
        $empreendimento['nomeIndice'] = $indice;
        $caracterSoma = Helper::getNomePeriodo($indiceEmpreendimento['fl_periodo']) != ''?' +':'';
        $indiceAdicional = ($indiceEmpreendimento['indice_adicional'] != '0')?$caracterSoma.str_replace('.',',',number_format($indiceEmpreendimento['indice_adicional'], 2)).'%':'';
        $residuo = ($indiceEmpreendimento['fl_residuo'] == '1') ? 'Com Resduo' : 'Sem Resduo';
        $indiceReajuste = $indice . " " . $reajuste[$indiceEmpreendimento['fl_periodo']] . " " . $indiceAdicional . ' ' . $reajuste[$indiceEmpreendimento['fl_periodo_adc']] . ' - ' . $residuo;

        //pessoas envolvidas
        $pessoas_envolvidas = $this->pessoasEnvolvidas->findByContrato($_POST['contrato']);
        $outrosCompradores = array();
        $k = 0;
        if ($pessoas_envolvidas) {
            foreach ($pessoas_envolvidas as $pessoa) {
                $outrosCompradores[$k] = $this->pessoa->findFisicaById($pessoa['id_pessoa']);
                $cidade = Db_Cidade::find($outrosCompradores[$k]['cd_cidade']);
                if ($cidade)
                    $cidade = $cidade->toArray();
                else {
                    $cidade['nome'] = '';
                    $cidade['uf'] = '';
                }
                $outrosCompradores[$k]['nmcidade'] = $cidade['nome'];
                $outrosCompradores[$k]['ufcidade'] = $cidade['uf'];
                switch ($outrosCompradores[$k]['est_civil']) {
                    case 'SOL':
                        $outrosCompradores[$k]['est_civil_nome'] = 'Solteiro(a)';
                        break;
                    case 'CAS':
                        $outrosCompradores[$k]['est_civil_nome'] = 'Casado(a)';
                        if ($outrosCompradores[$k]['cd_conjuge'])
                            $outrosCompradores[$k]['conjuge'] = $this->pessoa->findFisicaById($outrosCompradores[$k]['cd_conjuge']);
                        break;
                    case 'SEP':
                        $outrosCompradores[$k]['est_civil_nome'] = 'Separado(a)';
                        break;
                    case 'VIU':
                        $outrosCompradores[$k]['est_civil_nome'] = 'Viuvo(a)';
                        break;
                    case 'DIV':
                        $outrosCompradores[$k]['est_civil_nome'] = 'Divorciado(a)';
                        break;
                    case 'UNE':
                        $outrosCompradores[$k]['est_civil_nome'] = 'Unio estvel';
                        if ($outrosCompradores[$k]['cd_conjuge'])
                            $outrosCompradores[$k]['conjuge'] = $this->pessoa->findFisicaById($outrosCompradores[$k]['cd_conjuge']);
                        break;
                }
                $k++;
            }
        }
        $outrosCompradores2 = $outrosCompradores;

        //Pessoa envolvida para QuadroResumo2SP!
        $parceria = $parcerias->fetchAll('id_empreendimento = ' . $empreendimento['id'])->toArray();
        $pessoaEnvolvida = array();
        foreach ($parceria as $parc) {
            $id_pessoa = $parc['id_pessoa'];
            $pessoa = $pessoas->fetchRow('id =' . $id_pessoa)->toArray();
            if ($pessoa['tp_pessoa'] == 'J') {
                $pessoaEnvolvida = array_merge($pessoa, $pessoas_juridicas->fetchRow('id_pessoa = ' . $pessoa['id'])->toArray());
                if ($pessoa['cd_cidade']) {
                    $cidadePessoaEnvolvida = Db_Cidade::find($pessoa['cd_cidade'])->toArray();
                    $pessoaEnvolvida['nmCidade'] = $cidadePessoaEnvolvida['nome'];
                    $pessoaEnvolvida['ufCidade'] = $cidadePessoaEnvolvida['uf'];
                }
            }
        }


        $pessoaResponsavel = $assinaturas->getDefaultAdapter()->select()
            ->from(array('a' => TB_ASSINATURA), array('*'))
            ->join(array('p' => TB_PESSOA), 'p.id = a.id_pessoa', array('*'))
            ->join(array('c' => TB_CIDADE), 'c.id = p.cd_cidade', array('nmCidade' => 'nome', 'uf'))
            ->join(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = p.id', array('*'))
            ->where('a.id_empreendimento = ' . $empreendimento['id'])
            ->query()->fetchAll();

        if ($pessoaResponsavel) {
            foreach ($pessoaResponsavel as &$pr) {
                if ($pr['est_civil'])
                    $pr['est_civil_nome'] = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $pr['est_civil'])->getDescricao();
                if ($pr['uf'])
                    $pr['uf_nome'] = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_UF, $pr['uf'])->getDescricao();
            }
        }

        $adicionais = array();
        if (count($itensContrato)) {
            foreach ($itensContrato as $item) {
                foreach ($item as $i)
                    $adicionais[] = array('valor' => $i['vl_parcela'], 'qtd' => $i['qt_parcelas'], 'tipo' => $i['tp_parcela']);
            }
        }
        $modelo = (new Modelo())->fetchRow('cd_modelo = ' . $_POST['cdModelo']);
        $this->set('modelo', $modelo);
        $this->set('tp_modelo', $_POST['tp_contrato']);

        //Tras as informacoes do Tipo de Loteamento e da logo do empreendimento!
        $empreendimentoInfo = $empreendimentos->getAdapter()->select()
            ->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento', 'ds_path_logo'))
            ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
            ->where('id = ' . $empreendimento['id'])->query()->fetch();
        $this->set("empreendimentoInfo", $empreendimentoInfo);

        $this->set('corretor', (new Corretor_Empreendimento())->findCorretorDados($contrato['id_corretor'], $empreendimento['id']));
        $this->set('adicionais', $adicionais);
        $this->set('pessoaResponsavel', $pessoaResponsavel);
        $this->set('param', $_POST);
        $this->set('pagInicial', $paginaInicial);
        $this->set('pagFinal', $paginaFinal);
        $this->set('pessoas_envolvidas', $outrosCompradores);
        $this->set("indiceReajuste", $indiceReajuste);
        $this->set('empreendimento', $empreendimento);
        $this->set('lote', $lote);
        $this->set('cliente', $cliente);
        $this->set('parceria', $parceria);
        $this->set('contrato', $contrato);
        $this->set('sinal', $sinal);
        $this->set('assinatura', $assinatura);
        $this->set('banco', $banco);
        $this->set('clienteAcade', $empresa);
        $this->set('citacaoDados', $citacaoDados);
        $this->set('itensContrato', $itensContrato);
        $this->set("indice", $indice);
        $this->set('citacao', $citacao);
        $this->set('pessoaEnvolvida', $pessoaEnvolvida);

        switch ($_POST['tp_contrato']) {
            case '1':
                //Quadro Resumo
                $view = 'gerarQuadroResumo';
                break;
            case '2':
                //Unibras - Contrato
                $view = 'gerarQuadroResumo2SP';
                break;
            case '3':
                //AG - Contrato
                $view = 'gerarQuadroResumo3AG';
                break;
            case '4':
                //Fortaleza - Contrato
                $view = 'gerarQuadroResumo4CE';
                break;
            case '5':
                //FMOTA - Contrato
                $view = 'geraQuadroResumo5AL';
                break;
            case '6':
                //Quadro Resumo 2
                $view = 'gerarQuadroResumo2';
                break;
            case '7':
                //Quadro Resumo Price
               $view = 'gerarQuadroResumoPrice';
                break;
            case '8':
                //LPM - Quadro Resumo
                $view = 'gerarQuadroResumoLPM';
                break;
            case '9':
                //PR - Quadro Resumo
                $view = 'gerarQuadroResumo3';
                break;
            case '10':
                //Quadro Resumo Lei 13.786
                $view = 'gerarQuadroResumoLei';
                break;
            case '11':
                //Quadro Resumo ALCHEMAX
                $view = 'gerarQuadroResumo2ALC';
                break;
            case '12':
                //Quadro Resumo AG BAMBU
               $view = 'gerarQuadroResumo2AGB';
                break;
            case '13':
                //LotearUrb mais de um comprador
                $view = 'gerarQuadroResumoLotearUrb';
                break;
            case '14':
                //LotearUrb Solteiro
                $view = 'gerarQuadraResumoLotearUrbSolteiro';
                break;
            case '15':
                //LotearUrb Casado
                $view = 'gerarQuadroResumoLotearUrbCasado';
                break;
            case '16':
                //Quadro Resumo 3
                $view = 'gerarQuadroResumo03';
                break;
            case '17':
                //Quadro Resumo Lei 13.786
                $view = 'gerarQuadroResumoLei';
                break;
        }
        if ($_POST['tipoEmissao'] == 'D') {
            
            $docusign = $this->tb_docusignCadastro->getLista($_POST['idDocusign'])[0];
            $infoDocusign = $this->infoTokenDocusign($docusign['docusign_access_token'],"https://account.docusign.com");
            if(isset($infoDocusign->error)){
                $token = $this->refreshTokenDocusign($docusign['docusign_refresh_token'],$docusign['docusign_integration_key'],$docusign['docusign_secret_key'],"https://account.docusign.com");

                if(isset( $token->access_token)){
                        
                    $this->tb_docusignCadastro->atualizarToken($_POST['idDocusign'],$token->access_token,$token->refresh_token);
                    $docusign['docusign_access_token'] = $token->access_token;
        
                    $docusign['docusign_refresh_token'] = $token->refresh_token;

                    $infoDocusign = $this->infoTokenDocusign($token->access_token);
                }
                else{
                    if(isset($_POST['code'])){
                        $curl = curl_init();

                        curl_setopt_array($curl, array(
                        CURLOPT_URL => 'https://account.docusign.com/oauth/token',
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 100,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'POST',
                        CURLOPT_POSTFIELDS => 'grant_type=authorization_code&code='.$_POST['code'],
                        CURLOPT_HTTPHEADER => array(
                            'Authorization: Basic '.base64_encode($docusign['docusign_integration_key'].":".$docusign['docusign_secret_key']),
                            'Content-Type: application/x-www-form-urlencoded'
                        ),
                        ));
                        
                        $response = curl_exec($curl);
                        curl_close($curl);

                        $json = json_decode($response);

                        $this->tb_docusignCadastro->atualizarToken($_POST['idDocusign'],$json->access_token,$json->refresh_token);
                        $docusign['docusign_access_token']=$json->access_token;
                        $docusign['docusign_refresh_token']=$json->refresh_token;
                    }else{
                        $nmDominio = "";
                        $url = explode('.', $_SERVER['HTTP_HOST']);
                        if ($url[0] == 'www') {
                            $nmDominio = $url[1];
                        } else {
                            $nmDominio = $url[0];
                        }
                        $urlRedirecionamento ="https://account.docusign.com/oauth/auth?response_type=code&scope=signature&state=".json_encode($_POST)."&client_id=".$docusign['docusign_integration_key']."&redirect_uri=https://".$nmDominio.".acadeone.com.br/acadelotear/docusign.php";
                        header('Location: '.$urlRedirecionamento);
                        die;
                    }      
                }
                $infoDocusign = $this->infoTokenDocusign($docusign['docusign_access_token'],"https://account.docusign.com");
            
            }

            $base64=$this->displayPDF('Contrato_Resumo_' . time() . '.pdf', true, 'P', "A4", array(5, 5, 5, 8), $view,null,true);
            $listaContatos=[];
            if($cliente['email']){
                array_push($listaContatos,array("email"=>$cliente['email'],"name"=>utf8_encode($cliente['nm_pessoa']),"recipientId"=>count($listaContatos)+1));
                if(isset($cliente['representantes']) &&is_array($cliente['representantes'])){
                    foreach($cliente['representantes'] as $listaRepresentante){
                        if($listaRepresentante['email']){
                            array_push($listaContatos,array("email"=>$listaRepresentante['email'],"name"=>utf8_encode($listaRepresentante['nm_pessoa']),"recipientId"=>count($listaContatos)+1));
                        }
                    }
                }
                if(isset($_POST['assinaturas'])&&is_array($_POST['assinaturas'])){
                    foreach($_POST['assinaturas'] as $assinatura){
                        $assinatura = explode(";",$assinatura);
                        array_push($listaContatos,array("email"=>$assinatura[1],"name"=>utf8_encode($assinatura[0]),"recipientId"=>count($listaContatos)+1));
                    }
                }
                array_push($listaContatos,array("email"=>$docusign['docusign_email'],"name"=>utf8_encode($docusign['docusign_nome']),"recipientId"=>count($listaContatos)+1));
                $infoDocusign = $this->infoTokenDocusign($docusign['docusign_access_token']);
                
                if(isset($infoDocusign->error)){
                    $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "listar"), array("exception" => 'Houve algum erro, entre em contato com suporte. Falha ao atualizar token ' . json_encode($infoDocusign)));
                    return;
                }

                $envelope = $this->criarEnvelopeDocusign($docusign['docusign_access_token'], $docusign['docusign_id_cliente'], $infoDocusign->accounts[0]->base_uri, $base64, $listaContatos, 'Contrato_Resumo_' . time());
                
                if(!isset($envelope->envelopeId)){ 
                    $envelope = $this->criarEnvelopeDocusign($docusign['docusign_access_token'], $docusign['docusign_id_cliente'], $infoDocusign->accounts[0]->base_uri, $base64, $listaContatos, 'Contrato_Resumo_' . time());
                    if(isset($envelope->errorCode)){
                        $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "listar"), array("exception" => 'Houve algum erro, entre em contato com suporte. Falha ao criar documento 1 ' . json_encode($envelope)));
                    }
                }
                if(isset($envelope->envelopeId)){
                    $contrato = $this->tb_contrato->fetchRow("id = {$_POST['contrato']}");
                    $contrato->docusign_envelope_id = $envelope->envelopeId;
                    $contrato->save();
                    $this->tb_docusignVinculo->adicionar($envelope->envelopeId,$_POST['contrato'],$_POST['idDocusign']);
                    (new Relacionamento())->saveContato(350, date('Y-m-d'), $_POST['contrato'], "Log: Criado envelope no Docusign com id {$envelope->envelopeId} para o contrato: {$_POST['contrato']}");
                    $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "listar"), array("msg" => "success"));
                }
                else{
                    $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "listar"), array("exception" => 'Houve algum erro, entre em contato com suporte. Falha ao criar documento 2 ' . json_encode($envelope)));
                }
            }
            else{
                $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "listar"), array("exception" => 'Cliente sem e-mail cadastrado'));
            }
            return;
        }
        else{
            $this->displayPDF('Contrato_Resumo_' . time() . '.pdf', true, 'P', "A4", array(5, 5, 5, 8), $view,null);
        }
    }
    public function parcelasSinalAjaxAction()
    {
        $this->set('sinal', $_POST['sinal']);
        $this->set('parcelas', $_POST['parcelas']);
        $this->display('sinal');
    }

    public function validar()
    {
        $campos = array(
            'empreendimento' => 'O campo empreendimento  obrigatrio.',
            'cliente' => 'O campo cliente  obrigatrio.',
            'banco' => 'O campo banco  obrigatrio.',
            'corretor' => 'O campo corretor  obrigatrio.',
            'idIndice' => 'O campo ndice  obrigatrio.',
            'lote' => 'O campo lote  obrigatrio.'
        );

        if ($_POST['vl_parcela'] || $_POST['qtd_parcela'] || $_POST['dt_primeira']) {
            $campos = array_merge($campos, array(
                'vl_parcela' => 'Se for preenchido valores de parcelas normais o campo Valor  obrigatrio.',
                'qtd_parcela' => 'Se for preenchido valores de parcelas normais o campo Qtde  obrigatrio.',
                'dt_primeira' => 'Se for preenchido valores de parcelas normais o campo Data  obrigatrio.'
            ));
        }

        if ($_POST['vlSinal'] || $_POST['qtdSinal']) {
            $campos = array_merge($campos, array(
                'vlSinal' => 'Se for preenchido valores de parcela sinal o campo Valor  obrigatrio.',
                'qtdSinal' => 'Se for preenchido valores de parcela sinal o campo Qtde  obrigatrio.'
            ));
        }

        if ($_POST['intercalada'] || $_POST['qtd_parcela_intercalada'] || $_POST['frequencia'] || $_POST['data_intercalada']) {
            $campos = array_merge($campos, array(
                'intercalada' => 'Se for preenchido valores de parcelas intercaladas o campo Valor  obrigatrio.',
                'qtd_parcela_intercalada' => 'Se for preenchido valores de parcelas intercaladas o campo Qtde  obrigatrio.',
                'frequencia' => 'Se for preenchido valores de parcelas intercaladas o campo Frequencia  obrigatrio.',
                'data_intercalada' => 'Se for preenchido valores de parcelas intercaladas o campo Data  obrigatrio.'
            ));
        }

        if ($_POST['vl_chaves'] || $_POST['qtd_parcela_chaves'] || $_POST['dt_chaves']) {
            $campos = array_merge($campos, array(
                'vl_chaves' => 'Se for preenchido valores de parcelas chave o campo Valor  obrigatrio.',
                'qtd_parcela_chaves' => 'Se for preenchido valores de parcelas chave o campo Qtde  obrigatrio.',
                'dt_chaves' => 'Se for preenchido valores de parcelas chave o campo Data  obrigatrio.'
            ));
        }


        foreach ($campos as $campo => $msg)
            if ($_POST[$campo] == '')
                $this->_helper->addMensagem($campo, $msg);

        return (count($this->_helper->getMensagens()) > 0);
    }

    public function validarGerarAction()
    {
        $_SESSION['tipoDoc'] = $_GET['doc'];
        
        $campos = array(
            'empreendimento' => 'O campo empreendimento  obrigatrio.',
            'contrato' => 'O campo contrato  obrigatrio.'
        );

        foreach ($campos as $campo => $msg)
            if ($_POST[$campo] == '')
                $this->_helper->addMensagem($campo, $msg);

        //Mensagem de Erros
        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
        } else {
            echo json_encode('');
        }
    }

    /**
     * Cria a citacao do contrato
     * @param array $pessoa
     * @return string
     * @throws Zend_Db_Table_Exception
     */
    public function gerarCitacao(array $pessoa, $posterior = false)
    {
        if ($cidade = Db_Cidade::find($pessoa['cd_cidade']))
            $cidade = $cidade->toArray();

        $pessoas = new Pessoa();
        $str = '<b>' . $pessoa['nm_pessoa'] . '</b>, ';


        //Instancia de pessoa fisica usada tanto para pessoa fisica como juridica
        $pfs = new Pessoa_Fisica();
        if ($pessoa['tp_pessoa'] == 'F') {
            $pes = $pfs->fetchRow('id_pessoa = ' . $pessoa['id']);
            if ($pes['cd_documento']) {
                $doc = new TabelaAgrupada();
                $doc = $doc->fetchRow('idTabela = 7 AND idCampo = ' . $pes['cd_documento'])->toArray();
                $doc = $doc['descricao'] ? $doc['descricao'] : '';
            } else {
                $doc = '';
            }
            $str .= 'pessoa fsica de direito privado, portador(a) do(a) ' . $doc . ' n ' . $pes['nr_rg'] . ', inscrita no CPF/MF sob n <b>' . $pes['nr_cpf']
                . '</b>, reside e domicilia na ' . $pessoa['endereco'] .
                (($pessoa['nr_endereco']) ? ', ' . $pessoa['nr_endereco'] : '') .
                (($pessoa['ds_complemento']) ? ', ' . $pessoa['ds_complemento'] : '') . ' - ' . $pessoa['nm_bairro'] . ' - '
                . $cidade['nome'] . '/' . Db_Cidade::getEstados($cidade['uf']) . '. ';
        } elseif ($pessoa['tp_pessoa'] == 'J') {
            $pjs = new Pessoa_Juridica();
            $reps = new Representante();
            $pes = $pjs->fetchRow('id_pessoa = ' . $pessoa['id'])->toArray();
            $str .= 'pessoa jurdica de direito privado, inscrita no CNPJ/MF sob n <b>'
                . $pes['nr_cnpj'] . '</b>, com sede na ' . $pessoa['endereco'] .
                (($pessoa['nr_endereco']) ? ', ' . $pessoa['nr_endereco'] : '') .
                (($pessoa['ds_complemento']) ? ', ' . $pessoa['ds_complemento'] : '') . ' - '
                . $pessoa['nm_bairro'] . ' - ' . $cidade['nome'] . '/' . Db_Cidade::getEstados($cidade['uf'])
                . ', neste ato representado pelo(a) ';
            $responsaveis = $reps->fetchAll($reps->select()->where('id_pessoa_juridica = ?', $pessoa['id']))->toArray();
            foreach ($responsaveis as $resp) {
                //testa se e Fisica ou juridica
                $pessoa_ = $pessoas->fetchRow('id = ' . $resp['id_pessoa'])->toArray();
                if ($cidade = Db_Cidade::find($pessoa_['cd_cidade'])) {
                    $cidade = $cidade->toArray();
                }
                if ($pessoa_['tp_pessoa'] == 'F') {
                    $pf = $pfs->fetchRow('id_pessoa = ' . $resp['id_pessoa'])->toArray();
                    //busca o tipo de documento cadastrado pelo usurio.
                    if ($pf['cd_documento']) {
                        $doc = new TabelaAgrupada();
                        $doc = $doc->fetchRow('idTabela = 7 AND idCampo = ' . $pf['cd_documento'])->toArray();
                        $doc = $doc['descricao'] ? $doc['descricao'] : '';
                    } else {
                        $doc = '';
                    }
                    $pessoa = $pessoas->fetchRow('id = ' . $resp['id_pessoa'])->toArray();
                    $estCivis = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $pf['est_civil']);
                    $nomeEstCivis = ($estCivis) ? '<b>' . $estCivis->getDescricao() . '</b>,' : '';
                    $str .= 'Sr(a)  <b>' . $pessoa['nm_pessoa'] . '</b>, <b>' . $pf['nm_nacionalidade'] . '</b>, '
                        . $nomeEstCivis . ' <b>' . $pf['nm_profissao'] . '</b>,' .
                        ' portador(a) do(a) ' . $doc . ' n. <b>'
                        . $pf['nr_rg'] . '</b>, inscrito(a) com CPF sob o n. <b>' . $pf['nr_cpf']
                        . '</b>, residente e domiciliado no Estado de(a) <b>' . Db_Cidade::getEstados($cidade['uf']) . '</b>';
                } else {
                    $pj = $pjs->find($resp['id_pessoa'])->current()->toArray();
                    $pessoa = $pessoas->find($resp['id_pessoa'])->current()->toArray();
                    $str .= '<b>' . $pessoa['nm_pessoa'] . '</b>, CNPJ/MF sob n <b>' . $pj['nr_cnpj']
                        . '</b>, com sede na ' . $pessoa['endereco'] . (($pessoa['nr_endereco']) ? ', ' . $pessoa['nr_endereco'] : '') .
                        (($pessoa['ds_complemento']) ? ', ' . $pessoa['ds_complemento'] : '') . ' - ' . $pessoa['nm_bairro'] . ' - '
                        . $cidade['nome'] . '/' . Db_Cidade::getEstados($cidade['uf']);
                }
                $str .= (end($responsaveis) == $resp) ? "." : " e o(a) ";
            }
        }
        return $str;
    }

    public static function gerarCitacaoDadosAg(array $pessoa)
    {
        if ($cidade = Db_Cidade::find($pessoa['cd_cidade']))
            $cidade = $cidade->toArray();

        $pessoas = new Pessoa();
        $str = '';

        //Instancia de pessoa fisica usada tanto para pessoa fisica como juridica
        $pfs = new Pessoa_Fisica();
        if ($pessoa['tp_pessoa'] == 'F') {
            $pf = $pfs->find($pessoa['id'])->current()->toArray();
            $estCivis = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $pf['est_civil']);
            $nomeEstCivis = ($estCivis) ? $estCivis->getDescricao() . ',' : '';
            $str .= '<b>' . $pessoa['nm_pessoa'] . '</b>, ' . $pf['nm_nacionalidade'] . ', '
                . '' . $nomeEstCivis . ' ' . $pf['nm_profissao'] . ', CPF: ' . $pf['nr_cpf']
                . ', RG: ' . $pf['nr_rg']
                . ', residente no(a) ' . $pessoa['endereco'] .
                (($pessoa['nr_endereco']) ? ', ' . $pessoa['nr_endereco'] : '') .
                (($pessoa['ds_complemento']) ? ', ' . $pessoa['ds_complemento'] : '') . ' - '
                . $pessoa['nm_bairro'] . ' - ' . $cidade['nome'] . '/' . Db_Cidade::getEstados($cidade['uf'])
                . ', CEP: ' . $pessoa['nr_cep'] . '. ';
        } elseif ($pessoa['tp_pessoa'] == 'J') {
            $pjs = new Pessoa_Juridica();
            $reps = new Representante();
            $pes = $pjs->fetchRow('id_pessoa = ' . $pessoa['id'])->toArray();
            $str .= '<b>' . $pessoa['nm_pessoa'] . '</b>, pessoa jurdica de direito privado, inscrita no CNPJ/MF sob n '
                . $pes['nr_cnpj'] . ', com sede na ' . $pessoa['endereco'] .
                (($pessoa['nr_endereco']) ? ', ' . $pessoa['nr_endereco'] : '') .
                (($pessoa['ds_complemento']) ? ', ' . $pessoa['ds_complemento'] : '') . ' - '
                . $pessoa['nm_bairro'] . ' - ' . $cidade['nome'] . '/' . Db_Cidade::getEstados($cidade['uf'])
                . ', neste ato representado pelos scios ';
            $responsaveis = $reps->fetchAll($reps->select()->where('id_pessoa_juridica = ?', $pessoa['id']))->toArray();
            foreach ($responsaveis as $resp) {
                //testa se e Fisica ou juridica
                $pessoa_ = $pessoas->fetchRow('id = ' . $resp['id_pessoa'])->toArray();
                if ($cidade = Db_Cidade::find($pessoa_['cd_cidade'])) {
                    $cidade = $cidade->toArray();
                }
                if ($pessoa_['tp_pessoa'] == 'F') {
                    $pf = $pfs->fetchRow('id_pessoa = ' . $resp['id_pessoa'])->toArray();
                    if ($pf['cd_documento']) {
                        $doc = new TabelaAgrupada();
                        $doc = $doc->fetchRow('idTabela = 7 AND idCampo = ' . $pf['cd_documento'])->toArray();
                        $doc = $doc['descricao'] ? $doc['descricao'] : '';
                    } else {
                        $doc = '';
                    }
                    $pessoa = $pessoas->fetchRow('id = ' . $resp['id_pessoa'])->toArray();
                    $estCivis = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $pf['est_civil']);
                    $nomeEstCivis = ($estCivis) ? $estCivis->getDescricao() . ',' : '';
                    $str .= 'Sr(a)  <b>' . $pessoa['nm_pessoa'] . '</b>, ' . $pf['nm_nacionalidade'] . ', '
                        . $nomeEstCivis . ' ' . $pf['nm_profissao'] . ',' .
                        ' portador(a) do(a) ' . $doc . ' n. '
                        . $pf['nr_rg'] . ', inscrito(a) com CPF sob o n. ' . $pf['nr_cpf']
                        . ', residente e domiciliado no Estado de(a) ' . Db_Cidade::getEstados($cidade['uf']) . '.';
                } else {
                    $pj = $pjs->find($resp['id_pessoa'])->current()->toArray();
                    $pessoa = $pessoas->find($resp['id_pessoa'])->current()->toArray();
                    $str .= '<b>' . $pessoa['nm_pessoa'] . '</b>, CNPJ/MF sob n ' . $pj['nr_cnpj']
                        . ', com sede na ' . $pessoa['endereco'] . (($pessoa['nr_endereco']) ? ', ' . $pessoa['nr_endereco'] : '') .
                        (($pessoa['ds_complemento']) ? ', ' . $pessoa['ds_complemento'] : '') . ' - ' . $pessoa['nm_bairro'] . ' - '
                        . $cidade['nome'] . '/' . Db_Cidade::getEstados($cidade['uf']) . ', neste ato representado pelo(a) ';

                    //verifica novamente se a pessoa juridica possui responsaveis e acrescenta no texto
                    $responsaveis2 = $reps->fetchAll($reps->select()->where('id_pessoa_juridica = ?', $resp['id_pessoa']))->toArray();
                    foreach ($responsaveis2 as $resp2) {
                        //testa se e Fisica ou juridica
                        $pessoa_ = $pessoas->find($resp2['id_pessoa'])->current()->toArray();
                        if ($cidade = Db_Cidade::find($pessoa_['cd_cidade'])) {
                            $cidade = $cidade->toArray();
                        }
                        if ($pessoa_['tp_pessoa'] == 'F') {
                            $pf = $pfs->find($resp2['id_pessoa'])->current()->toArray();
                            if ($pf['cd_documento']) {
                                $doc = new TabelaAgrupada();
                                $doc = $doc->fetchRow('idTabela = 7 AND idCampo = ' . $pf['cd_documento'])->toArray();
                                $doc = $doc['descricao'] ? $doc['descricao'] : '';
                            } else {
                                $doc = '';
                            }
                            $pessoa = $pessoas->find($resp2['id_pessoa'])->current()->toArray();
                            $estCivis = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $pf['est_civil']);
                            $nomeEstCivis = ($estCivis) ? $estCivis->getDescricao() . ',' : '';
                            $str .= 'Sr(a)  <b>' . $pessoa['nm_pessoa'] . '</b>, ' . $pf['nm_nacionalidade'] . ', '
                                . $nomeEstCivis . ' ' . $pf['nm_profissao'] . ',' .
                                ' portador(a) do(a) ' . $doc . ' n. '
                                . $pf['nr_rg'] . ', inscrito(a) com CPF sob o n;. ' . $pf['nr_cpf']
                                . ', residente e domiciliado no Estado de(a) ' . Db_Cidade::getEstados($cidade['uf']) . '';
                        } else {
                            $pj = $pjs->find($resp2['id_pessoa'])->current()->toArray();
                            $pessoa = $pessoas->find($resp2['id_pessoa'])->current()->toArray();
                            $str .= '<b>' . $pessoa['nm_pessoa'] . '</b>, CNPJ/MF sob n ' . $pj['nr_cnpj']
                                . ', com sede na ' . $pessoa['endereco'] . (($pessoa['nr_endereco']) ? ', ' . $pessoa['nr_endereco'] : '') .
                                (($pessoa['ds_complemento']) ? ', ' . $pessoa['ds_complemento'] : '') . ' - ' . $pessoa['nm_bairro'] . ' - '
                                . $cidade['nome'] . '/' . Db_Cidade::getEstados($cidade['uf']);
                        }
                        $str .= (end($responsaveis2) == $resp2) ? "." : " e o(a) ";
                    }
                }
            }
        }
        return $str;
    }

    public static function gerarCitacaoDados(array $pessoa)
    {
        if ($cidade = Db_Cidade::find($pessoa['cd_cidade']))
            $cidade = $cidade->toArray();

        $pessoas = new Pessoa();
        $str = '';

        //Instancia de pessoa fisica usada tanto para pessoa fisica como juridica
        $pfs = new Pessoa_Fisica();
        if ($pessoa['tp_pessoa'] == 'F') {
            $pf = $pfs->fetchRow('id_pessoa = ' . $pessoa['id']);
            $estCivis = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $pf['est_civil']);
            $nomeEstCivis = ($estCivis) ? $estCivis->getDescricao() . ',' : '';
            $str .= '<b>' . $pessoa['nm_pessoa'] . '</b>, ' . $pf['nm_nacionalidade'] . ', '
                . '' . $nomeEstCivis . ' ' . $pf['nm_profissao'] . ', CPF: ' . $pf['nr_cpf']
                . ', RG: ' . $pf['nr_rg']
                . ', residente no(a) ' . $pessoa['endereco'] .
                (($pessoa['nr_endereco']) ? ', ' . $pessoa['nr_endereco'] : '') .
                (($pessoa['ds_complemento']) ? ', ' . $pessoa['ds_complemento'] : '') . ' - '
                . $pessoa['nm_bairro'] . ' - ' . $cidade['nome'] . '/' . Db_Cidade::getEstados($cidade['uf'])
                . ', CEP: ' . $pessoa['nr_cep'] . '. ';
        } elseif ($pessoa['tp_pessoa'] == 'J') {
            $pjs = new Pessoa_Juridica();
            $reps = new Representante();
            $pes = $pjs->fetchRow('id_pessoa = ' . $pessoa['id'])->toArray();
            $str .= '<b>' . $pessoa['nm_pessoa'] . '</b>, pessoa jurdica de direito privado, inscrita no CNPJ/MF sob n <b>'
                . $pes['nr_cnpj'] . '</b>, com sede na ' . $pessoa['endereco'] .
                (($pessoa['nr_endereco']) ? ', ' . $pessoa['nr_endereco'] : '') .
                (($pessoa['ds_complemento']) ? ', ' . $pessoa['ds_complemento'] : '') . ' - '
                . $pessoa['nm_bairro'] . ' - ' . $cidade['nome'] . '/' . Db_Cidade::getEstados($cidade['uf'])
                . ', neste ato representado pelo(a) ';
            $responsaveis = $reps->fetchAll($reps->select()->where('id_pessoa_juridica = ?', $pessoa['id']))->toArray();
            foreach ($responsaveis as $resp) {
                //testa se e Fisica ou juridica
                $pessoa_ = $pessoas->fetchRow('id = ' . $resp['id_pessoa'])->toArray();
                if ($cidade = Db_Cidade::find($pessoa_['cd_cidade'])) {
                    $cidade = $cidade->toArray();
                }
                if ($pessoa_['tp_pessoa'] == 'F') {
                    $pf = $pfs->fetchRow('id_pessoa =' . $resp['id_pessoa'])->toArray();
                    //busca o tipo de documento cadastrado pelo usurio.
                    if ($pf['cd_documento']) {
                        $doc = new TabelaAgrupada();
                        $doc = $doc->fetchRow('idTabela = 7 AND idCampo = ' . $pf['cd_documento'])->toArray();
                        $doc = $doc['descricao'] ? $doc['descricao'] : '';
                    } else {
                        $doc = '';
                    }
                    $pessoa = $pessoas->fetchRow('id = ' . $resp['id_pessoa'])->toArray();
                    $estCivis = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $pf['est_civil']);
                    $nomeEstCivis = ($estCivis) ? '<b>' . $estCivis->getDescricao() . '</b>,' : '';
                    $str .= 'Sr(a)  <b>' . $pessoa['nm_pessoa'] . '</b>, <b>' . $pf['nm_nacionalidade'] . '</b>, '
                        . $nomeEstCivis . ' <b>' . $pf['nm_profissao'] . '</b>,' .
                        ' portador(a) do(a) ' . $doc . ' n. <b>'
                        . $pf['nr_rg'] . '</b>, inscrito(a) com CPF sob o n. <b>' . $pf['nr_cpf']
                        . '</b>, residente e domiciliado no Estado de(a) <b>' . Db_Cidade::getEstados($cidade['uf']) . '</b>.';
                } else {
                    $pj = $pjs->find($resp['id_pessoa'])->current()->toArray();
                    $pessoa = $pessoas->find($resp['id_pessoa'])->current()->toArray();
                    $str .= '<b>' . $pessoa['nm_pessoa'] . '</b>, CNPJ/MF sob n <b>' . $pj['nr_cnpj']
                        . '</b>, com sede na ' . $pessoa['endereco'] . (($pessoa['nr_endereco']) ? ', ' . $pessoa['nr_endereco'] : '') .
                        (($pessoa['ds_complemento']) ? ', ' . $pessoa['ds_complemento'] : '') . ' - ' . $pessoa['nm_bairro'] . ' - '
                        . $cidade['nome'] . '/' . Db_Cidade::getEstados($cidade['uf']) . ', neste ato representado pelo(a) ';

                    //verifica novamente se a pessoa juridica possui responsaveis e acrescenta no texto
                    $responsaveis2 = $reps->fetchAll($reps->select()->where('id_pessoa_juridica = ?', $resp['id_pessoa']))->toArray();
                    foreach ($responsaveis2 as $resp2) {
                        //testa se e Fisica ou juridica
                        $pessoa_ = $pessoas->find($resp2['id_pessoa'])->current()->toArray();
                        if ($cidade = Db_Cidade::find($pessoa_['cd_cidade'])) {
                            $cidade = $cidade->toArray();
                        }
                        if ($pessoa_['tp_pessoa'] == 'F') {
                            $pf = $pfs->find($resp2['id_pessoa'])->current()->toArray();
                            //busca o tipo de documento cadastrado pelo usurio.
                            if ($pf['cd_documento']) {
                                $doc = new TabelaAgrupada();
                                $doc = $doc->fetchRow('idTabela = 7 AND idCampo = ' . $pf['cd_documento'])->toArray();
                                $doc = $doc['descricao'] ? $doc['descricao'] : '';
                            } else {
                                $doc = '';
                            }
                            $pessoa = $pessoas->find($resp2['id_pessoa'])->current()->toArray();
                            $estCivis = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $pf['est_civil']);
                            $nomeEstCivis = ($estCivis) ? '<b>' . $estCivis->getDescricao() . '</b>,' : '';
                            $str .= 'Sr(a)  <b>' . $pessoa['nm_pessoa'] . '</b>, <b>' . $pf['nm_nacionalidade'] . '</b>, '
                                . $nomeEstCivis . ' <b>' . $pf['nm_profissao'] . '</b>,' .
                                ' portador(a) do(a) ' . $doc . ' n. <b>'
                                . $pf['nr_rg'] . '</b>, inscrito(a) com CPF sob o n;. <b>' . $pf['nr_cpf']
                                . '</b>, residente e domiciliado no Estado de(a) <b>' . Db_Cidade::getEstados($cidade['uf']) . '</b>';
                        } else {
                            $pj = $pjs->find($resp2['id_pessoa'])->current()->toArray();
                            $pessoa = $pessoas->find($resp2['id_pessoa'])->current()->toArray();
                            $str .= '<b>' . $pessoa['nm_pessoa'] . '</b>, CNPJ/MF sob n; <b>' . $pj['nr_cnpj']
                                . '</b>, com sede na ' . $pessoa['endereco'] . (($pessoa['nr_endereco']) ? ', ' . $pessoa['nr_endereco'] : '') .
                                (($pessoa['ds_complemento']) ? ', ' . $pessoa['ds_complemento'] : '') . ' - ' . $pessoa['nm_bairro'] . ' - '
                                . $cidade['nome'] . '/' . Db_Cidade::getEstados($cidade['uf']);
                        }
                        $str .= (end($responsaveis2) == $resp2) ? "." : " e o(a) ";
                    }
                }
            }
        }
        return $str;
    }

    public function loteClienteByEmpreendimentoAction()
    {
        $reservaLotes = new ReservaLote();
        $lotes = new Lote();
        $tb_contratos = new Contrato();
        $contratos = $tb_contratos->getAdapter()->select()->from(TB_CONTRATO, 'id_lote')->where("fl_distrato = '0'")->query()->fetchAll();
        $reserva = $reservaLotes->getAdapter()->select()->from(TB_RESERVA_LOTE, 'cod_lote')->where('reservado = "1"')->query()->fetchAll();

        if ($contratos != null) {
            $lotes = $lotes->getAdapter()->select()
                ->from(array('l' => TB_LOTES), '*')
                ->joinLeft(array('rel' => TB_RESERVA_LOTE), 'rel.cod_lote = l.id', '')
                ->where('l.reservado = "0"')
                ->where('l.id_empreendimento = ?', $_POST['id_empreendimento'])
                ->where('l.id NOT IN(?)', $contratos);

            if ($reserva) {
                $lotes = $lotes->where('l.id NOT IN(?)', $reserva);
            }

            $lotes = $lotes->group(array("id"))->order(array('quadra ASC', 'lote ASC', 'rel.id DESC'))
                ->query()->fetchAll();
        } else {
            $lotes = $lotes->getAdapter()->select()
                ->from(array('l' => TB_LOTES), '*')
                ->joinLeft(array('rl' => TB_RESERVA_LOTE), 'rl.cod_lote = l.id', '')
                ->where('l.reservado = "0"')
                ->where('l.id_empreendimento = ?', $_POST['id_empreendimento']);

            if ($reserva) {
                $lotes = $lotes->where('l.id NOT IN(?)', $reserva);
            }

            $lotes = $lotes->order(array('quadra ASC', 'lote ASC'))
                ->query()->fetchAll();
        }

        $lista = array();
        foreach ($lotes as $lote) {
            $lista[] = array('id' => $lote['id'], 'text' => utf8_encode('Quadra: ' . $lote['quadra'] . ' - Lote: ' . $lote['lote']));
        }

        echo json_encode($lista);
    }

    public function bancoByEmpreendimentoAction()
    {
        $bancos = new Banco();
        $bancos = $bancos->getAdapter()->select()
            ->from(array('b' => TB_BANCO), '*')
            ->join(array('bc' => TB_BANCO_CONTA), 'b.id_banco_conta = bc.id_banco_conta', array(''))
            ->where('b.id_empreendimento = ' . $_POST['id_empreendimento'])
            ->where('bc.fl_ativo = 1')
            ->where('b.fl_ativo_banco = 1')
            ->query()->fetchAll();
        $lista = array();
        foreach ($bancos as &$banco) {
            $banco['nmBanco'] = Banco::findBancoNome($banco['cd_banco']);
            $lista[] = array('id' => $banco['id'], 'text' => utf8_encode($banco['nmBanco']) . ' - Ag.: ' . $banco['agencia'] . '-' . $banco['agencia_dv'] . '  Cc.: ' . $banco['conta_corrente'] . '-' . $banco['conta_corrente_dv']);
        }

        echo json_encode($lista);
    }

    public function corretorByEmpreendimentoAction()
    {
        $corretores = new Corretor_Empreendimento();
        $corretores = $corretores->getAdapter()->select()
            ->from(array('ce' => TB_CORRETOR_EMPREENDIMENTO), '')
            ->join(array('p' => TB_PESSOA), 'ce.id_corretor = p.id', array('id', 'nm_pessoa'))
            ->where('ce.id_empreendimento = ' . $_POST['id_empreendimento'])
            ->where("fl_ativo != '0'")
            ->order('nm_pessoa')->query()->fetchAll();

        $lista = array();
        foreach ($corretores as &$corretor) {
            $corretor['nm_pessoa'] = utf8_encode($corretor['nm_pessoa']);
            $lista[] = array('id' => $corretor['id'], 'text' => $corretor['nm_pessoa']);
        }
        echo json_encode($lista);
    }

    public function contratoByEmpreendimentoAction()
    {
        $contratos = Contrato::byEmpreendimento($_POST['id_empreendimento'], Contrato::CONTRATO_TODOS, 2, array("nm_pessoa", "lote", "quadra", "id"), true);

        $lista = array();
        foreach ($contratos as $contrato) {
            if ($contrato['fl_distrato'] == '1')
                $color = 'color: red;';
            else
                $color = null;

            $lista[] = array(
                'id' => $contrato['id'],
                'text' => utf8_encode($contrato['nm_pessoa']) . ' - Quadra: ' . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']) . ' - Contrato: ' . $contrato['id'],
                'estilo' => $color
            );
        }

        echo json_encode($lista);
    }

    public function aprovarContratoAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'aprovarContrato')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'contrato', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $response = '';
        try {
            $contrato = $this->contrato->fetchRow($this->contrato->select()->where('id = ?', $this->_helper->filters($_POST['contrato'])));
            $contrato->fl_aprovar_contrato = 1;
            if ($contrato->save())
                $response = 'aprovado';

            //Muda status do lote para vendido.
            $mudaStatusLote = (new Lote())->fetchRow('id = ' . $contrato->id_lote);
            $mudaStatusLote->status = 'V';
            $mudaStatusLote->save();

            //Grava a operacao no log de contatos realizados com o lote e quadra do contrato
            (new Relacionamento())->saveContato(55, date('Y-m-d'), $contrato['id'], 'Log: Contrato Aprovado');
        } catch (Exception $e) {
        }

        echo json_encode($response);
    }

    /**
     * Busca os dados de tabela de preco padrao pelo id do lote
     * @return mixed|TabelaPreco
     */
    public function dadosTabelaAction()
    {
        $empreendimento = new Empreendimento();
        $empreendimento = $empreendimento->getAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), 'id')
            ->join(array('l' => TB_LOTES), 'l.id_empreendimento = e.id')
            ->where('e.fl_tabela_preco = "1"')
            ->where('l.id = ?', $_POST['lote'])
            ->query()->fetch();

        if ($empreendimento) {
            $tabela = new TabelaPreco();
            $tabela = $tabela->getAdapter()->select()
                ->from(array('tbl' => TB_TABELA_PRECO_LOTES), '*')
                ->join(array('tb' => TB_TABELA_PRECO), 'tbl.id_tabela_preco = tb.id_tabela_preco AND tb.fl_padrao = "1"', array())
                ->where('tbl.id_lote = ' . $_POST['lote'])
                ->query()->fetch();

            echo json_encode($tabela);
        } else
            echo json_encode(false);
    }

    public function getIndiceEmpreendimentoAction()
    {
        $tbIndiceEmprendimento = new IndiceEmpreendimento();
        foreach ($tbIndiceEmprendimento->getIndiceEmpreendimento($_POST['idEmpreendimento'], true) as $indiceEmpreendimento) {
            $caracterSoma = Helper::getNomePeriodo($indiceEmpreendimento['fl_periodo']) != ''?' +':'';
            $indiceAdicional = ($indiceEmpreendimento['indice_adicional'] != '0')?$caracterSoma.str_replace('.',',',number_format($indiceEmpreendimento['indice_adicional'], 2)).'%':'';
            $residuo = ($indiceEmpreendimento['fl_residuo'] == '1')?' - Com Resduo ':' - Sem Resduo ';
            $lista[] = array(
                'id' => $indiceEmpreendimento['id_indice_empreendimento'],
                'text' => utf8_encode($indiceEmpreendimento['descricao'] . ' ' . Helper::getNomePeriodo($indiceEmpreendimento['fl_periodo']) . ' ' . $indiceAdicional . ' ' . Helper::getNomePeriodo($indiceEmpreendimento['fl_periodo_adc']) . $residuo)
            );
        }
        echo json_encode($lista);
    }

    public function dadosLoteTabelaAction()
    {
        $empreendimento = new Empreendimento();
        $empreendimento = $empreendimento->getAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), 'id')
            ->join(array('l' => TB_LOTES), 'l.id_empreendimento = e.id')
            ->where('e.fl_tabela_preco = "1"')
            ->where('l.id = ?', $_POST['lote'])
            ->query()->fetch();

        if ($empreendimento) {
            $tabelaPreco = new TabelaPreco();
            $tabelaPreco = $tabelaPreco->getAdapter()->select()
                ->from(array('tbl' => TB_TABELA_PRECO_LOTES), '*')
                ->join(array('tb' => TB_TABELA_PRECO), 'tbl.id_tabela_preco = tb.id_tabela_preco', '*')
                ->where('tb.fl_padrao = "1" AND tb.fl_ativo = "1"')
                ->where('tbl.id_lote = ?', $_POST['lote'])
                ->where('tb.id_empreendimento = ?', $_POST['idEmpreendimento'])
                ->query()->fetchAll();
            //Remove acentos para evitar erros ao encode json
            $tabelaPreco[0]['nm_tabela'] = Helper::removeAcentos($tabelaPreco[0]['nm_tabela'], false);
            $tabelaPreco[0]['dt_atualizacao'] = Helper::getDate($tabelaPreco[0]['dt_atualizacao'], false);
            
            echo json_encode($tabelaPreco);
        } else {
            echo json_encode(false);
        }
    }

    //Localiza pessoa pelo id
    public function findPessoaAction() 
    {
        $pessoas_envolvidas = $this->pessoasEnvolvidas->getDefaultAdapter()->select()
            ->from(array('p' => TB_PESSOA), array('nm_pessoa'))
            ->where('p.id =' . $_POST['pessoa'])
            ->query()->fetchAll();

        echo json_encode(array('pessoa' => utf8_encode($pessoas_envolvidas[0]['nm_pessoa'])));
    }


    public function getContatosDocusignAction(){
        
        $empresa = new Db_Cliente();
        $pessoas = new Pessoa();
        $pessoas_fisicas = new Pessoa_Fisica();
        $pessoas_juridicas = new Pessoa_Juridica();
        $contratos = new Contrato();

        $contrato = $contratos->fetchRow('id = ' . $this->_helper->filters($_GET['contrato']))->toArray();
        $cliente = $pessoas->fetchRow('id = ' . $contrato['id_pessoa'])->toArray();
        $empresa = $empresa->fetchAll()[0]->toArray();
        $docusign = $this->tb_docusignCadastro->getLista($_GET['idDocusign'])[0];                
        if ($cliente['tp_pessoa'] == 'F') {
            
            $pf = $pessoas_fisicas->fetchRow('id_pessoa = ' . $cliente['id']);
            
            if (is_object($pf)){
                $pf = $pessoas_fisicas->fetchRow('id_pessoa = ' . $cliente['id'])->toArray();
            } else {
                $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "listar"), array("exception" => 'Houve algum erro com o cadastro de pessoa fsica, entre em contato com suporte. '));
            }
            
            if ($pf['est_civil'])
                $cliente['est_civil_nome'] = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $pf['est_civil'])->getDescricao();
            
            if (($pf['est_civil'] == 'CAS' || $pf['est_civil']) == 'UNE' && $pf['cd_conjuge']) {

                $pessoaConjuge = $pessoas->fetchRow('id = ' . $pf['cd_conjuge']);
                $pessoaFisicaConjuge = $pessoas_fisicas->fetchRow('id_pessoa = ' . $pf['cd_conjuge']);

                if ($pessoaConjuge && $pessoaFisicaConjuge) {

                    $cliente['conjugeP'] = $pessoaConjuge;
                    
                    $cliente['conjugePF'] = $pessoaFisicaConjuge;
                    
                    if ($pessoaConjuge['cd_cidade']) {
                        $cidadeConjuge = new Cidade();
                        $cidadeConjuge = $cidadeConjuge->fetchRow('id = ' . $pessoaConjuge['cd_cidade']);   
                        $cliente['conjuge']['nm_cidade'] = $cidadeConjuge['nome'];
                    }
                }
            }
            
            //Poderia ser pessoa fisica e corretor
            if ($pf['tp_pessoa']) {
                unset($pf['tp_pessoa']);
                $cliente = array_merge($cliente, $pf);
            }
        } elseif ($cliente['tp_pessoa'] == 'J') {
            $cliente = array_merge($cliente, $pessoas_juridicas->fetchRow('id_pessoa = ' . $cliente['id'])->toArray());
            $representante = new Representante();
            $cliente['representantes'] = $representante->listaRepresentantesDaPessoaJuridica($cliente['id']);
        }
        $listaContatos=[];
        
        if($cliente['email']){
            array_push($listaContatos,array("email"=>$docusign['docusign_email'],"name"=>utf8_encode($docusign['docusign_nome']),"recipientId"=>count($listaContatos)+1));
            array_push($listaContatos,array("email"=>$cliente['email'],"name"=>utf8_encode($cliente['nm_pessoa']),"recipientId"=>count($listaContatos)+1));
            if(isset($cliente['representantes']) &&is_array($cliente['representantes'])){
                foreach($cliente['representantes'] as $listaRepresentante){
                    if($listaRepresentante['email']){
                        array_push($listaContatos,array("email"=>$listaRepresentante['email'],"name"=>utf8_encode($listaRepresentante['nm_pessoa']),"recipientId"=>count($listaContatos)+1));
                    }
                }
            }
            if(isset($cliente['conjugeP']['email'])&&$cliente['conjugeP']['email']){
                array_push($listaContatos,array("email"=>$cliente['conjugeP']['email'],"name"=>utf8_encode($cliente['conjugeP']['nm_pessoa']),"recipientId"=>0));
            }
        }
        echo json_encode($listaContatos);
    }
    /**
     * Gera o word recebendo o modelo
     */

    public function gerarWordAction()
    {
        //Grava a operacao no log de contatos
        $tbModeloArquivo = new ModeloArquivo();
        $tipoModelo = $tbModeloArquivo->fetchRow("ds_path_modelo = '{$_POST['cdArquivo']}'");
        (new Relacionamento())->saveContato(13, date('Y-m-d'), $_POST['contrato'], "Log: Impresso contrato Word modelo: {$tipoModelo->nm_titulo}.");
        
        $templateProcessor = new \PhpOffice\PhpWord\TemplateProcessor(__ROOT__ . '/' . $_POST['cdArquivo']);

        $variaveis = $this->adicionarValoresTemplate($_POST['contrato'], $templateProcessor);

        $filename = 'emissaoContrato' . $_POST['contrato'] . '.docx';

        $variaveis['templateProcessor']->saveAs($filename);
        //Gera em PDF
        if ($_POST['tipoEmissao'] == 'P' || $_POST['tipoEmissao'] == 'D') {
            \PhpOffice\PhpWord\Settings::setPdfRendererPath('vendor/dompdf');
            \PhpOffice\PhpWord\Settings::setPdfRendererName('DomPDF');
            
            $pdfWord = \PhpOffice\PhpWord\IOFactory::load($filename);
            $pdf = \PhpOffice\PhpWord\IOFactory::createWriter($pdfWord, 'PDF');     
            unlink($filename);
            $filename = 'emissaoContrato' . $_POST['contrato'] . '.pdf';
            $pdf->save($filename);
        }        
        if ($_POST['tipoEmissao'] == 'D') {
            $listaContatos=[];
            if($variaveis['dados']['comprador'][0]['comprador0email']){
                array_push($listaContatos,array("email"=>$variaveis['dados']['comprador'][0]['comprador0email'],"name"=>utf8_encode($variaveis['dados']['comprador'][0]['comprador0nm_pessoa']),"recipientId"=>count($listaContatos)+1));
                if(isset($variaveis['dados']['representante']) &&is_array($variaveis['dados']['representante'])){
                    foreach($variaveis['dados']['representante'] as $key=>$listaRepresentante){
                        if($listaRepresentante['representante'.$key.'email']){
                            array_push($listaContatos,array("email"=>$listaRepresentante['representante'.$key.'email'],"name"=>utf8_encode($listaRepresentante['representante'.$key.'nm_pessoa']),"recipientId"=>count($listaContatos)+1));
                        }
                    }
                }
                if(isset($_POST['assinaturas'])&&is_array($_POST['assinaturas'])){
                    foreach($_POST['assinaturas'] as $assinatura){
                        $assinatura = explode(";",$assinatura);
                        array_push($listaContatos,array("email"=>$assinatura[1],"name"=>utf8_encode($assinatura[0]),"recipientId"=>count($listaContatos)+1));
                    }
                }
                $docusign = $this->tb_docusignCadastro->getLista($_POST['idDocusign'])[0];
                array_push($listaContatos,array("email"=>$docusign['docusign_email'],"name"=>utf8_encode($docusign['docusign_nome']),"recipientId"=>count($listaContatos)+1));
                $infoDocusign = $this->infoTokenDocusign($docusign['docusign_access_token']);
                if(isset($infoDocusign->error)){
                    $token = $this->refreshTokenDocusign($docusign['docusign_refresh_token'],$docusign['docusign_integration_key'],$docusign['docusign_secret_key']);
                    if(isset( $token->access_token)){
                        
                        $this->tb_docusignCadastro->atualizarToken($_POST['idDocusign'],$token->access_token,$token->refresh_token);
                        $docusign['docusign_access_token'] = $token->access_token;
            
                        $docusign['docusign_refresh_token'] = $token->refresh_token;

                        $infoDocusign = $this->infoTokenDocusign($token->access_token);
                    }
                    else{
                        $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "listar"), array("exception" => 'Houve algum erro, entre em contato com suporte. Falha ao atualizar token ' . json_encode($token)));
                        return;
                    }
                }
                $data = file_get_contents($filename);
                $base64 = base64_encode($data);
                unlink($filename);
                $envelope = $this->criarEnvelopeDocusign($docusign['docusign_access_token'], $docusign['docusign_id_cliente'], $infoDocusign->accounts[0]->base_uri, $base64, $listaContatos, 'Contrato_Resumo_' . time());
                
                if(isset($envelope->errorCode)){
                    $envelope = $this->criarEnvelopeDocusign($docusign['docusign_access_token'], $docusign['docusign_id_cliente'], $infoDocusign->accounts[0]->base_uri, $base64, $listaContatos, 'Contrato_Resumo_' . time());
                
                    if(isset($envelope->errorCode)){
                        $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "listar"), array("exception" => 'Houve algum erro, entre em contato com suporte. Falha ao criar documento 1 ' . json_encode($envelope)));
                    }
                }
                if(isset($envelope->envelopeId)){
                    $contrato = $this->tb_contrato->fetchRow("id = {$_POST['contrato']}");
                    $contrato->docusign_envelope_id = $envelope->envelopeId;
                    $contrato->save();
                    $this->tb_docusignVinculo->adicionar($envelope->envelopeId,$_POST['contrato'],$_POST['idDocusign']);
                    (new Relacionamento())->saveContato(350, date('Y-m-d'), $_POST['contrato'], "Log: Criado envelope no Docusign com id {$envelope->envelopeId} para o contrato: {$_POST['contrato']} no modelo word");
                    $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "listar"), array("msg" => "success"));
                }
                else{
                    $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "listar"), array("exception" => 'Houve algum erro, entre em contato com suporte. Falha ao criar documento 2' . json_encode($envelope)));
                }
            }
            else{
                $this->redir(array("modulo" => "adm", "controller" => "contrato", "action" => "listar"), array("exception" => 'Cliente sem e-mail cadastrado'));
                return;
            }
        }
        //gera o download automatico
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename='.$filename);
        header('Content-Transfer-Encoding: binary');
        header('Expires: 0');
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header('Pragma: public');
        header('Content-Length: ' . filesize($filename));
        flush();
        //remove os arquivos temporarios
        readfile($filename);
        unlink($filename);
    }

    public function variaveisTemplateAction() {
        $variaveis = $this->adicionarValoresTemplate($_POST['contrato']);
        $this->set('dados', $variaveis['dados']);
        $this->display('variaveis');
    }
    public function utf8encode($mixed) {
        if (is_array($mixed)) {
            foreach ($mixed as $key => $value) {
                $mixed[$key] = $this->utf8encode($value);
            }
        } else if (is_string ($mixed)) {
            return utf8_encode($mixed);
        }
        return $mixed;
    }
    public function logDocusignAction()
    {
        $this->set('cliente', Db_Cliente::getCliente());
        if ($this->isAjax()) {
            $log = $this->tb_docusign->getLista($_GET['length'],$_GET['start'],$_GET['search']['value'],$_GET['idContrato']);
            echo json_encode($this->utf8encode($log));
            return;
        } else {
            $this->display('logDocusign');
        }
    }

    public function calculaValoresPorReajuste($vlParcela, $indiceEmpreendimento) {
        
        $periodoReajuste = null;
        $periodoReajuste = $indiceEmpreendimento['indice_adicional'] / 100;
        $vlParcela += $vlParcela * $periodoReajuste;
        $vlParcelaAdc = $vlParcela * 12;

        switch ($indiceEmpreendimento['fl_periodo']) {
            case 'A':
                $vlParcela = $vlParcelaAdc;
                break;
            case 'B':
                $vlParcela = $vlParcelaAdc / 6;
                break;
            case 'M':
                break;
            case 'S':
                $vlParcela = $vlParcelaAdc / 2;
                break;
            case 'T':
                $vlParcela = $vlParcelaAdc / 4;
                break;
            case 'SP':
                $vlParcela = null;
                break;
        }

        switch ($indiceEmpreendimento['fl_periodo_adc']) {
            case 'A':
                break;
            case 'B':
                $vlParcelaAdc = $vlParcela * 2;
                break;
            case 'M':
                $vlParcelaAdc = $vlParcelaAdc / 12;
                break;
            case 'S':
                $vlParcelaAdc = $vlParcelaAdc / 2;
                break;
            case 'T':
                $vlParcelaAdc = $vlParcela * 3;
                break;
        }

        return [
            'flPeriodo' => $indiceEmpreendimento['fl_periodo'],
            'vlParcela' => $vlParcela,
            'flPeriodoAdc' => $indiceEmpreendimento['fl_periodo_adc'],
            'vlParcelaAdc' => $vlParcelaAdc
        ];
    }
}
