<?php

class AutorizacaoController extends Controller
{
    private $pessoa;
    private $pessoasEnvolvidas;

    public function __construct($request)
    {
        parent::__construct($request);

        $this->pessoa = new Pessoa();
        $this->pessoasEnvolvidas = new ContratoPessoa();
        $this->itensContrato = new ContratoItens();

        $this->empreendimento = new Empreendimento();
        $this->set("subtitulo", "Autorizao");
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "adm", "controller" => "autorizacao", "action" => "gerar"));
    }

    public function gerarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'gerarAutorizacao')) {
            $this->redir(array('modulo' => 'sc', 'controller' => 'admin', 'action' => 'index'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }
        //nome da tela a ser exibida
        $this->set('nomeTela', "Autorizao");
        //nome da versao atual da tela a ser exibida
        $this->set('versao', " v1.01.8684");

        $empreendimentos = $this->empreendimento->getDefaultAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO));

        //Gera o campo de selecao do tipo modelo, apps optar pela opao "construir"
        $novo = new Modelo();
        $modelos = $novo->getAdapter()->select()->from(array('co' => TB_MODELO))->where('co.tp_modelo = "AU"')->order('co.nm_titulo')->query()->fetchAll();
        $this->set('modelos', $modelos);

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {
            }
        }
        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        if ($this->_isPost && $this->validar()) {
            $this->imprime();
            exit;
        } else {
            $this->set('dados', $_POST);
        }

        $modeloArquivo = new ModeloArquivo();
        $this->set('listaArquivoWord', $modeloArquivo->fetchAll($modeloArquivo->select()->order('nm_titulo')->where('tp_modelo = "AU" and fl_status = "1"')));
        $this->set('empreendimentos', $empreendimentos);
        $this->display('form');
    }
    public function gerarWordAction()
    {
        //Grava a operacao no log de contatos
        $tbModeloArquivo = new ModeloArquivo();
        $tipoModelo = $tbModeloArquivo->fetchRow("ds_path_modelo = '{$_POST['cdArquivo']}'");
        //(new Relacionamento())->saveContato(13, date('Y-m-d'), $_POST['contrato'], "Log: Impresso contrato Word modelo: {$tipoModelo->nm_titulo}.");
        
        $templateProcessor = new \PhpOffice\PhpWord\TemplateProcessor(__ROOT__ . '/' . $_POST['cdArquivo']);
        if(isset($_POST['origem'])){
            $templateProcessor->setValue('origem',$_POST['origem']);
        }
        if(isset($_POST['destino'])){
            $templateProcessor->setValue('destino',$_POST['destino']);
        }
        if(isset($_POST['data'])){
            $templateProcessor->setValue('data',$_POST['data']);
        }
        $variaveis = $this->adicionarValoresTemplate($_POST['id_contrato'], $templateProcessor);

        $filename = 'emissaoAutorizacao' . $_POST['id_contrato'] . '.docx';
        $variaveis['templateProcessor']->saveAs($filename);
        //Gera em PDF
        if ($_POST['tipoEmissao'] == 'P') {
            \PhpOffice\PhpWord\Settings::setPdfRendererPath('vendor/dompdf');
            \PhpOffice\PhpWord\Settings::setPdfRendererName('DomPDF');
            $pdfWord = \PhpOffice\PhpWord\IOFactory::load($filename);
            
            $pdf = \PhpOffice\PhpWord\IOFactory::createWriter($pdfWord, 'PDF');     
            unlink($filename);
            $filename = 'emissaoAutorizacao' . $_POST['id_contrato'] . '.pdf';
            $pdf->save($filename);
        }        

        //gera o download automatico
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename='.$filename);
        header('Content-Transfer-Encoding: binary');
        header('Expires: 0');
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header('Pragma: public');
        header('Content-Length: ' . filesize($filename));
        flush();
        //remove os arquivos temporarios
        readfile($filename);
        unlink($filename);
    }
    private function imprime()
    {
        if ($this->_isPost) {
            $modelos = new Modelo();
            $contratos = new Contrato();
            $parcerias = new Parceria();
            $pessoas = new Pessoa();
            $empreendimentos = new Empreendimento();
            $lote = new Lote();
            //Pessoa Envolvidas
            $assinaturas = new Assinatura();

            //Pega as informaao do modelo vindo do POST e manda para construir.php
            $modelo = $modelos->find($_POST['modelo'])->current()->toArray();

            $contratoId = $_POST['id_contrato'];
            $contrato = $contratos->fetchRow('id = ' . $contratoId)->toArray();

            $loteId = $contrato['id_lote'];
            $lote = $lote->fetchRow("id = $loteId")->toArray();

            $empreendimento = $empreendimentos->find($_POST['id_empreendimento'])->current()->toArray();
            $parceria = $parcerias->fetchAll($parcerias->select()->where('id_empreendimento = ?', $_POST['id_empreendimento']))->toArray();
            $pessoa = $pessoas->fetchRow('id = ' . $contrato['id_pessoa'])->toArray();
            $assinatura = $assinaturas->fetchAll($assinaturas->select()->where('id_empreendimento = ?', $_POST['id_empreendimento']))->toArray();

            //Pessoas Envolvidas
            $citacao = '';
            foreach ($parceria as $parc)
                $citacao .= $this->gerarCitacao($pessoas->find($parc['id_pessoa'])->current()->toArray());
            $this->set('citacao', $citacao);

            //Assinaturas
            $pessoaResponsavel = $assinaturas->getDefaultAdapter()->select()
                ->from(array('a' => TB_ASSINATURA), array('*'))
                ->join(array('p' => TB_PESSOA), 'p.id = a.id_pessoa', array('*'))
                ->join(array('c' => TB_CIDADE), 'c.id = p.cd_cidade', array('nmCidade' => 'nome', 'uf'))
                ->join(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = p.id', array('*'))
                ->where('a.id_empreendimento = ' . $empreendimento['id'])
                ->query()->fetchAll();

            if ($pessoaResponsavel) {
                foreach ($pessoaResponsavel as &$pr) {
                    if ($pr['est_civil'])
                        $pr['est_civil_nome'] = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $pr['est_civil'])->getDescricao();
                    if ($pr['uf'])
                        $pr['uf_nome'] = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_UF, $pr['uf'])->getDescricao();
                }
            }

            $this->set('pessoaResponsavel', $pessoaResponsavel);
            $this->set('contrato', $contrato);
            $this->set('empreendimento', $empreendimento);
            $this->set('lote', $lote);
            $this->set('parceria', $parceria);
            $this->set('cliente', $pessoa);
            $this->set('modelo', $modelo);
            $this->set('assinatura', $assinatura);
            $this->set('tipo', $_POST['tipo']);

            //Antes de redirecionar grava o resultado no log dos contatos realizados como Autorizaao.
            (new Relacionamento())->saveContato(35, date('Y-m-d'), $contratoId, 'Log: Autorizao Gerada');

            if ($_POST['tipo'] == 'c') {

                $this->display('construir');
                $this->displayPDF("consturir" . time() . ".pdf");
                exit;
            }
            $this->display('membramento');
            $this->displayPDF("membramento" . time() . ".pdf");
            exit;
        }
        $this->display('form');
    }
    public function gerarCitacao(array $pessoa, $posterior = false)
    {
        if ($cidade = Db_Cidade::find($pessoa['cd_cidade']))
            $cidade = $cidade->toArray();

        $pessoas = new Pessoa();
        $str = '<b>' . $pessoa['nm_pessoa'] . '</b>, ';
        if (!$posterior)
            $str .= 'doravante designada CONTRATANTE, ';

        //Instancia de pessoa fsica usada tanto para pessoa fsica como jurdica
        $pfs = new Pessoa_Fisica();
        if ($pessoa['tp_pessoa'] == 'F') {
            $pes = $pfs->find($pessoa['id'])->current()->toArray();
            $str .= 'pessoa fsica de direito privado, inscrita no CPF/MF sob n <b>' . $pes['nr_cpf']
                . '</b>, reside e domicilia na ' . $pessoa['endereco'] .
                (($pessoa['nr_endereco']) ? ', ' . $pessoa['nr_endereco'] : '') .
                (($pessoa['ds_complemento']) ? ', ' . $pessoa['ds_complemento'] : '') . ' - ' . $pessoa['nm_bairro'] . ' - '
                . $cidade['nome'] . '/' . Db_Cidade::getEstados($cidade['uf']) . ' ';
        } elseif ($pessoa['tp_pessoa'] == 'J') {
            $pjs = new Pessoa_Juridica();
            $reps = new Representante();
            $pes = $pjs->find($pessoa['id'])->current()->toArray();
            $str .= 'pessoa jurdica de direito privado, inscrita no CNPJ/MF sob n <b>'
                . $pes['nr_cnpj'] . '</b>, com sede na ' . $pessoa['endereco'] .
                (($pessoa['nr_endereco']) ? ', ' . $pessoa['nr_endereco'] : '') .
                (($pessoa['ds_complemento']) ? ', ' . $pessoa['ds_complemento'] : '') . ' - '
                . $pessoa['nm_bairro'] . ' - ' . $cidade['nome'] . '/' . Db_Cidade::getEstados($cidade['uf'])
                . ', neste ato representado pelo(a) ';
            $responsaveis = $reps->fetchAll($reps->select()->where('id_pessoa_juridica = ?', $pessoa['id']))->toArray();
            foreach ($responsaveis as $resp) {
                //testa se  Fsica ou jurdica
                $pessoa_ = $pessoas->find($resp['id_pessoa'])->current()->toArray();
                if ($cidade = Db_Cidade::find($pessoa_['cd_cidade'])) {
                    $cidade = $cidade->toArray();
                }
                if ($pessoa_['tp_pessoa'] == 'F') {
                    $pf = $pfs->find($resp['id_pessoa'])->current()->toArray();
                    $nasc = $pf['sexo'] == 'M' ? 'Brasileiro' : 'Brasileira';
                    $pessoa = $pessoas->find($resp['id_pessoa'])->current()->toArray();
                    $estCivis = Db_TabelaAgrupada::find( Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $pf['est_civil']);
                    $nomeEstCivis = ($estCivis) ? '<b>' . $estCivis->getDescricao() . '</b>,' : '';
                    $str .= 'Sr(a)  <b>' . $pessoa['nm_pessoa'] . '</b>, <b>' . $nasc . '</b>, '
                        . $nomeEstCivis . ' <b>' . $pf['nm_profissao'] . '</b>, portador(a) da carteira de identidade n. <b>'
                        . $pf['nr_rg'] . '</b>, inscrito(a) com CPF sob o n. <b>' . $pf['nr_cpf']
                        . '</b>, residente e domiciliado no Estado de(a) <b>' . Db_Cidade::getEstados($cidade['uf']) . '</b>';
                } else {
                    $pj = $pjs->find($resp['id_pessoa'])->current()->toArray();
                    $pessoa = $pessoas->find($resp['id_pessoa'])->current()->toArray();
                    $str .= '<b>' . $pessoa['nm_pessoa'] . '</b>, CNPJ/MF sob n <b>' . $pj['nr_cnpj']
                        . '</b>, com sede na ' . $pessoa['endereco'] . (($pessoa['nr_endereco']) ? ', ' . $pessoa['nr_endereco'] : '') .
                        (($pessoa['ds_complemento']) ? ', ' . $pessoa['ds_complemento'] : '') . ' - ' . $pessoa['nm_bairro'] . ' - '
                        . $cidade['nome'] . '/' . Db_Cidade::getEstados($cidade['uf']);
                }
                $str .= (end($responsaveis) == $resp) ? "." : " e o(a) ";
            }
        }
        return $str;
    }

    private function validar()
    {

        $campos = array('data' => 'O Campo data  obrigatrio',
            'origem' => 'O campo Lote(s) de origem  obrigatrio',
            'id_empreendimento' => 'Selecione o empreendimento',
            'id_contrato' => 'Selecione o lote');

        if ($_POST ['tipo'] == "c") {
            unset($campos['origem']);
        }
        foreach ($campos as $k => $v) {
            if ($_POST [$k] == "") {
                $this->_helper->addMensagem($k, $v);
            }
        }
        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function loteByEmpreendimentoAction()
    {
        $contratos = Contrato::byEmpreendimento($_POST['id_empreendimento'], Contrato::CONTRATO_TODOS, 2, array("nm_pessoa", "lote", "quadra", "id"), true);

        $lista = array();
        foreach ($contratos as $contrato) {
            //Alterado para para condio simples de exibio!
            $lista[] = array('id' => $contrato['id'], 'text' => utf8_encode($contrato['nm_pessoa'] . ' Quadra: ' . $contrato['quadra'] . ' - Lote: ' . $contrato['lote']));
        }

        echo json_encode($lista);
    }

}