<?php

class AjaxController extends Controller
{

    public function __construct($request)
    {
        parent::__construct($request);
    }

    public function calcula_totalAction()
    {
        $total = Helper::getInputMoney($_POST['vl_parcela']) * Helper::getInputMoney($_POST['qtd_parcela']);
        $total += Helper::getInputMoney($_POST['sinal']) * Helper::getInputMoney($_POST['qtd_parcela_sinal']);
        $total += Helper::getInputMoney($_POST['intercalada']) * Helper::getInputMoney($_POST['qtd_parcela_intercalada']);
        $total += Helper::getInputMoney($_POST['vl_chave']) * Helper::getInputMoney($_POST['qt_chave']);
        echo $_SESSION['simboloMoeda'].' ' . number_format($total, 2, ',', '.');
        return;
    }

    public function calculaTotalParcelaAction()
    {
        //dados das parcelas
        $tb_parcela = new Parcela();
        $tb_contrato = new Contrato();


        //busca todos as PARCELAS que possuem o id_contrato igual ao informado no formulario. Query principal.
        $rsItens = $tb_parcela->fetchAll("id_contrato = {$_POST['contrato']}", array("dt_parcela"))->toArray();

        //busca os nomes das pessoas e lotes relativo ao contrato selecionado
        $contrato = $tb_contrato->getAdapter()->select()->from(array("c" => TB_CONTRATO))
            ->join(array("p" => TB_PESSOA), "c.id_pessoa = p.id", 'nm_pessoa')
            ->join(array("l" => TB_LOTES), "c.id_lote = l.id", array('lote', 'quadra'))
            ->where("c.id = {$_POST['contrato']}")->query()->fetch();

        //valores a serem incrementados
        $total_a_pagar = 0;

        foreach ($rsItens as $item) {

            if ($item['tp_parcela'] == 'S' && $contrato['inclui_sinal_contrato'] == 0) {
                continue;
            }

            if (!$item["vl_parcela"])
                $item["vl_parcela"] = 0.00;

            $tipoParcela = array('E', 'NE', 'SE', 'CE', 'IE');
            if ($item['pago'] != 1 && (!in_array($item['tp_parcela'], $tipoParcela))) {
                $total_a_pagar += $item['vl_parcela'];
            }
        }

        $parcela["vl_parcela"] = $total_a_pagar;
        echo json_encode(array('valorParcela' => $parcela["vl_parcela"], 'valor' => number_format($total_a_pagar, 2, ',', '.')));

        return;
    }

    //Busca o nome da pessoa fsica pelo CPF via ajax
    public function pessoaNomeByCPFAction()
    {
        $nome = false;
        if (Helper::validaCPF($_POST['cpf'])) {
            $pessoa = new Pessoa();
            $pessoa = $pessoa->getDefaultAdapter()->select()
                ->from(array('p' => TB_PESSOA), 'p.nm_pessoa')
                ->join(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa')
                ->where('pf.nr_cpf = ?', $_POST['cpf'])
                ->query()->fetch();

            if ($pessoa['nm_pessoa']) {
                $nome = $pessoa['nm_pessoa'];
            } else {
                $nome = true;
            }
        }
        echo json_encode($nome);
    }

    /*
         * Busca e exibe em formato json os dados necessarios para o modal de informacoes de lotes
         */
    public function findPessoasFisicasByNmPessoaAction()
    {
        $dados = array();

        //Buscando a lista de lotes para exibir na tela
        $lista = Pessoa::findPessoaFisicaByNome($_GET['term']);

        if ($lista) foreach ($lista as $pessoaFisica) {
            $dados[] = array('text' => $pessoaFisica['nm_pessoa'] . ' (' . $pessoaFisica['nr_cpf'] . ')', 'value' => $pessoaFisica['idPessoa']);
        }

        echo json_encode($dados);
    }

    /*
     * Busca e exibe em formato json os dados necessarios para o modal de informacoes de lotes
     */
    public function findPessoasByNomeAction()
    {
        $dados = array();

        //Buscando a lista de lotes para exibir na tela
        $lista = Pessoa::findPessoaByNome(utf8_decode($_GET['term']));

        if ($lista) foreach ($lista as $pessoa) {
            $nrCpfCnpj = ($pessoa['nr_cnpj']) ? $pessoa['nr_cnpj'] : $pessoa['nr_cpf'];
            $dados[] = array('text' => utf8_encode($pessoa['nm_pessoa']) . ' (' . $nrCpfCnpj . ')', 'value' => $pessoa['idPessoa']);
        }
        echo json_encode($dados);
    }

    public function findPessoaJuridicaByNomeAction()
    {
        $dados = array();

        //Buscando a lista de lotes para exibir na tela
        $lista = Pessoa::findPessoaJuridicaByNome(utf8_decode($_GET['term']));
        if ($lista) foreach ($lista as $pessoa) {
            $dados[] = array('text' => utf8_encode($pessoa['nm_pessoa']) . ' (' . $pessoa['nr_cnpj'] . ')', 'value' => $pessoa['idPessoa']);
        }
        echo json_encode($dados);
    }

    public function buscaTodasAsPessoasJuridicasAction() {
        $lista = Pessoa::findAllPessoasJuridicas();
        if ($lista) foreach ($lista as $pessoa) {
            $dados[] = array('id' => $pessoa['idPessoa'], 'text' => utf8_encode($pessoa['nm_pessoa']) . ' (' . $pessoa['nr_cnpj'] . ')');
        }
        echo json_encode($dados);
    }
}
