<?php

class AditivoController extends Controller
{
    private $tb_aditivo;
    private $tb_contrato;
    private $tb_empreendimento;
    private $tb_lote;
    private $tb_assinatura;
    private $tb_parceria;
    private $tb_representante;
    private $tb_contratoPessoa;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->tb_aditivo = new Db_Aditivo();
        $this->tb_contrato = new Contrato();
        $this->tb_empreendimento = new Empreendimento();
        $this->tb_representante = new Representante();
        $this->tb_lote = new Lote();
        $this->tb_assinatura = new Assinatura();
        $this->tb_parceria = new Parceria();
        $this->tb_contratoPessoa = new ContratoPessoa();
        $this->dataHora = date("d/m/Y H:i:s", strtotime("now"));
        $this->usuario = Login::getUsuario()->getLogin();
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "adm", "controller" => "aditivo", "action" => "listar"));
    }

    public function listarAction()
    {
        if ($this->isAjax()) {
            $listaItem = $this->tb_aditivo->getAdapter()->select()
                ->from(array("a" => TB_ADITIVO), array('id_contrato', 'id_aditivo', 'dt_aditivo'))
                ->join(array('c' => TB_CONTRATO), 'a.id_contrato = c.id', null)
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('lote', 'quadra'))
                ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', array('nm_empreendimento'))
                ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa'))
                ->where('c.fl_distrato = ?', '0');

            //Exibe apenas os empreendimentos os quais o usurio tem acesso
            if ($_SESSION['usuario']) {
                try {
                    $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                    $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                    if (count($ids)) {
                        $id = implode(',', $ids);
                        $listaItem->where("e.id IN({$id})");
                    } else {
                        $listaItem->where("1");
                    }
                } catch (Exception $e) {

                }
            }

            $listaItem = $listaItem->order('e.nm_empreendimento')
                ->where('a.fl_ativo = ?', '1')
                ->query()->fetchAll();

            $lista = array();
            foreach ($listaItem as $item) {

                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<a href="index.php?m='
                    . $this->modulo
                    . '&c='
                    . $this->controller
                    . '&a=editar&id='
                    . $item['id_aditivo']
                    . '" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
                $acoes .= '<a target="_blank" href="index.php?m='
                    . $this->modulo
                    . '&c=' . $this->controller
                    . '&a=gerar&id='
                    . $item['id_aditivo']
                    . '" data-toggle="tooltip" title="GERAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-file-text"></i></a>';
                $title = "return confirm('Tem certeza que deseja desfazer o aditivo do contrato "
                    . $item['id_contrato']
                    . " em nome de "
                    . $item['nm_empreendimento']
                    . " do Lote "
                    . $item['lote'] . "?')";
                $acoes .= '<a onclick="'
                    . $title
                    . '"  href="index.php?m='
                    . $this->modulo
                    . '&c='
                    . $this->controller
                    . '&a=desfazer&id='
                    . $item['id_aditivo']
                    . '" data-toggle="tooltip" title="DESFAZER" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-undo"></i></a>';
                $acoes .= '</div>';
                $acoes .= '</div>';

                //Para ordenar por data
                $data = '<div hidden>'
                    . $item['dt_aditivo']
                    . '</div>'
                    . Helper::getDate($item['dt_aditivo']);

                $lista[] = array(
                    'codigo' => $item['id_aditivo'],
                    'empreendimento' => utf8_encode($item['nm_empreendimento']),
                    'quadra' => utf8_encode($item['quadra']),
                    'lote' => utf8_encode($item['lote']),
                    'data' => '<div align="center">' . $data . '</div>',
                    'contrato' => $item['id_contrato'],
                    'pessoa' => utf8_encode($item['nm_pessoa']),
                    'acoes' => utf8_encode($acoes)
                );
            }

            echo json_encode(array(
                'draw' => 1,
                'recordsTotal' => count($lista),
                'recordsFiltered' => count($lista),
                'data' => $lista
            ));

        } else {
            $this->display('listar');
        }
    }

    public function adicionarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'AdicionarAditivo')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'aditivo', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $tela = $this->get('nomeTela');
        $operacao = 'I';

        $listaEmpreendimento = $this->tb_empreendimento->getAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('*'));

        //Exibe apenas os empreendimentos os quais o usurio tem acesso
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $listaEmpreendimento->where("e.id IN({$id})");
                } else {
                    $listaEmpreendimento->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $listaEmpreendimento = $listaEmpreendimento->order('e.nm_empreendimento ASC')
            ->query()
            ->fetchAll();

        $this->set('listaEmpreendimento', $listaEmpreendimento);

        if ($this->_isPost && $this->validar()) {

            try {

                $transacaoAditivo = $this->tb_aditivo->getAdapter()->beginTransaction();

                // Insero em aditivo
                $tb_aditivo = $this->tb_aditivo->createRow();
                $tb_aditivo->id_contrato = $_POST['id_contrato'];
                $tb_aditivo->ds_ondelese = $_POST["dsOndelese"];
                $tb_aditivo->ds_agoraleiase = $_POST["dsAgoraleiase"];

                if ($_POST["dsObservacao"]) {

                    $tb_aditivo->ds_observacao = $_POST["dsObservacao"];

                } else {

                    $tb_aditivo->ds_observacao = null;

                }

                $tb_aditivo->dt_aditivo = $this->_helper->getInputDate($_POST["data"]);
                $tb_aditivo->fl_ativo = '1';
                $tb_aditivo->ds_log = $this->usuario . ' - ' . $this->dataHora . ' - ' . $operacao . ' - ' . $tela;
                $tb_aditivo->save();

                //Antes de redirecionar grava o resultado no log dos contatos realizados como aditivo contratual.
                (new Relacionamento())->saveContato(46, date('Y-m-d'), $_POST['id_contrato'], 'Log: Aditivo Adicionado');


                $transacaoAditivo->commit();
                $this->redir(array('modulo' => 'adm', 'controller' => 'aditivo', 'action' => 'listar'), array('msg' => 'ok'));

            } catch (Exception $e) {

                $transacaoAditivo->rollBack();
                $this->redir(array('modulo' => 'adm', 'controller' => 'aditivo', 'action' => 'adicionar'), array('msg' => 'fail', 'exception' => $e->getMessage()));

            }
        }

        $this->display('form');

    }

    public function editarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'EditarAditivo')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'aditivo', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }
        //nome da tela e a operao realizada A-alterao
        $tela = $this->get('nomeTela');
        $operacao = 'A';

        $listaEmpreendimento = $this->tb_empreendimento->getAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('*'));

        //Exibe apenas os empreendimentos os quais o usurio tem acesso
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $listaEmpreendimento->where("e.id IN({$id})");
                } else {
                    $listaEmpreendimento->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $listaEmpreendimento = $listaEmpreendimento->order('e.nm_empreendimento ASC')
            ->query()
            ->fetchAll();

        $this->set('listaEmpreendimento', $listaEmpreendimento);

        //Trazendo as informaes do aditivo, lotes, empreendimento e pessoa atravs do id passado na url
        $this->set("aditivo", $aditivo = $this->tb_aditivo->getAdapter()->select()
            ->from(array("a" => TB_ADITIVO), array('id_contrato', 'id_aditivo', 'ds_ondelese', 'ds_agoraleiase', 'dt_aditivo', 'ds_observacao', 'ds_log'))
            ->join(array('c' => TB_CONTRATO), 'a.id_contrato = c.id', null)
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('lote', 'quadra'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', array('nm_empreendimento', 'idEmpreendimento' => 'id'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa'))
            ->where('a.id_aditivo = ' . $_GET['id'])
            ->query()->fetch());

        //Trazendo uma lista dos lotes
        $this->set('listaLote', $this->tb_lote->getAdapter()->select()
            ->from(array("l" => TB_LOTES), array('lote', 'id_lote' => 'id', 'quadra'))
            ->join(array("c" => TB_CONTRATO), 'c.id_lote = l.id', array('id_contrato' => 'id'))
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', array('nm_pessoa'))
            ->where('c.fl_gerado = "1"')
            ->where('id_empreendimento = ' . $aditivo['idEmpreendimento'])
            ->where('fl_distrato = "0"')
            ->order('l.lote ASC')
            ->query()->fetchAll());

        if ($this->_isPost && $this->validar()) {
            try {
                $transacaoAditivo = $this->tb_aditivo->getAdapter()->beginTransaction();

                // Insero em aditivo
                $tb_aditivo = $this->tb_aditivo->fetchRow('id_aditivo = ' . $_GET['id']);
                $tb_aditivo->id_contrato = $_POST['id_contrato'];
                $tb_aditivo->ds_ondelese = $_POST["dsOndelese"];
                $tb_aditivo->ds_agoraleiase = $_POST["dsAgoraleiase"];

                if ($_POST["dsObservacao"]) {
                    $tb_aditivo->ds_observacao = $_POST["dsObservacao"];
                } else {
                    $tb_aditivo->ds_observacao = null;
                }

                $tb_aditivo->dt_aditivo = $this->_helper->getInputDate($_POST["data"]);
                $tb_aditivo->fl_ativo = '1';
                $tb_aditivo->ds_log = $this->usuario . ' - ' . $this->dataHora . ' - ' . $operacao . ' - ' . $tela;
                $tb_aditivo->save();

                $transacaoAditivo->commit();
                $this->redir(array('modulo' => 'adm', 'controller' => 'aditivo', 'action' => 'listar'), array('msg' => 'ok'));
            } catch (Exception $e) {
                $transacaoAditivo->rollBack();
                $this->redir(array('modulo' => 'adm', 'controller' => 'aditivo', 'action' => 'editar'), array('id' => $_GET['id'], 'msg' => 'fail', 'exception' => $e->getMessage()));
            }

        }

        $this->display('form');

    }

    public function gerarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'GerarAditivo')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'aditivo', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }
        //Trazendo as informaes do aditivo, lotes, empreendimento e pessoa atravs do id passado na url
        $aditivo = $this->tb_aditivo->getAdapter()->select()
            ->from(array("a" => TB_ADITIVO), array('id_contrato', 'ds_ondelese', 'ds_agoraleiase', 'dt_aditivo', 'ds_observacao'))
            ->join(array('c' => TB_CONTRATO), 'a.id_contrato = c.id', null)
            ->join(array('pC' => TB_PESSOA), 'pC.id = c.id_pessoa', array('nmPessoaCliente' => 'nm_pessoa',
                'nrCepCliente' => 'nr_cep', 'enderecoCliente' => 'endereco', 'nrEnderecoCliente' => 'nr_endereco', 'complementoCliente' => 'ds_complemento', 'id_pessoa' => 'id'))
            ->joinLeft(array('pfC' => TB_PESSOA_FISICA), 'pfC.id_pessoa = pC.id', array('nrCpfCliente' => 'nr_cpf',
                'nrRgCliente' => 'nr_rg', 'nmNacionalidadeCliente' => 'nm_nacionalidade', 'estCivilCliente' => 'est_civil', 'cd_conjuge'))
            ->joinLeft(['conP' => TB_PESSOA], 'pfC.cd_conjuge = conP.id', ['nmConjuge' => 'nm_pessoa'])
            ->joinLeft(['conPf' => TB_PESSOA_FISICA], 'pfC.cd_conjuge = conPf.id_pessoa', ['nrCpfConjuge' => 'nr_cpf'])
            ->joinLeft(array('pjC' => TB_PESSOA_JURIDICA), 'pjC.id_pessoa = pC.id', array('nrCnpjCliente' => 'nr_cnpj'))
            ->joinLeft(array('ci' => TB_CIDADE), 'pC.cd_cidade = ci.id', array('cidadeCliente' => 'nome', 'ufCliente' => 'uf'))
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('lote', 'quadra'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', array('idEmpreendimento' => 'id', 'nm_empreendimento', 'fl_assinatura'))
            ->joinLeft(array('par' => TB_PARCERIA), 'par.id_empreendimento = e.id', null)
            ->joinLeft(array('pE' => TB_PESSOA), 'pE.id = par.id_pessoa', array('nmPessoaParceiro' => 'nm_pessoa', 'idPessoaParceiro' => 'id'))
            ->joinLeft(array('pjE' => TB_PESSOA_JURIDICA), 'pjE.id_pessoa = pE.id', array('nrCnpjParceiro' => 'nr_cnpj'))
            ->join(array('cid' => TB_CIDADE), 'cid.id = e.cd_cidade', array('nmCidadeParceiro' => 'nome'))
            ->where('a.id_aditivo = ' . $_GET['id'])
            ->query()->fetch();
        
        $this->set("aditivo", $aditivo);

        $parcerias = new Parceria();
        $parcerias = $parcerias->fetchAll($parcerias->select()->where('id_empreendimento = ?', $aditivo['idEmpreendimento']))->toArray();
        $this->set('parcerias', $parcerias);

        $empreendimento = new Empreendimento();
        $empreendimentoInfo = $empreendimento->getAdapter()->select()->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento'))
            ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
            ->where('id = ?', $aditivo['idEmpreendimento'])->query()->fetch();

        $this->set("empreendimentoInfo", utf8_encode($empreendimentoInfo));

        $this->set("data", ", " . date("d") . " de " . strtolower(Helper::getMes(date("m"))) . " de " . date("Y"));

        if ($aditivo['idPessoaParceiro']) {
            //adiciona o nome e cpf das partes interessadas, no documento Aditivo
            if ($aditivo['fl_assinatura'] == 'PE') {
                $pessoaParceiro = $this->tb_assinatura->getAdapter()->select()
                    ->from(array("a" => TB_ASSINATURA), null)
                    ->join(array('p' => TB_PESSOA), 'p.id = a.id_pessoa', array('nmPessoaRepresentante' => 'nm_pessoa'))
                    ->join(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = p.id', array('nrCpfRepresentante' => 'nr_cpf'))
                    ->where('a.id_empreendimento = ' . $aditivo['idEmpreendimento'])
                    ->query()->fetchAll();
            } else {
                $pessoaParceiro = $this->tb_parceria->getAdapter()->select()
                    ->from(array("pa" => TB_PARCERIA), '')
                    ->join(array("pe" => TB_PESSOA), 'pa.id_pessoa = pe.id', array('id', 'nmPessoa' => 'nm_pessoa', 'tp_pessoa'))
                    ->joinLeft(array("pf" => TB_PESSOA_FISICA), 'pe.id = pf.id_pessoa', array('nr_cpf'))
                    ->joinLeft(array("pj" => TB_PESSOA_JURIDICA), 'pe.id = pj.id_pessoa', array('nr_cnpj'))
                    ->where('pa.id_empreendimento = ' .$aditivo['idEmpreendimento'])
                    ->query()->fetchAll();

                $parceiros = array();
                
                foreach ($pessoaParceiro as $parceiro) {
                    
                    if ($parceiro['tp_pessoa'] == 'J') {
                        $representante = $this->tb_representante->getAdapter()->select()
                            ->from(array('r' => TB_REPRESENTANTE), array('id_pessoa_juridica'))
                            ->join(array('p' => TB_PESSOA), 'r.id_pessoa = p.id', array('nmRepresentante' => 'nm_pessoa'))
                            ->join(array('pf' => TB_PESSOA_FISICA), 'r.id_pessoa = pf.id_pessoa', array('cpfRepresentante' => 'nr_cpf'))
                            ->where('r.id_pessoa_juridica = ' .$parceiro['id'])
                            ->query()->fetchAll();

                        $parceiros[] = $representante;
                    }
                }
            }

            $compradores = $this->tb_contratoPessoa->getAdapter()->select()
                ->from(array('cp' => TB_CONTRATO_PESSOA), '')
                ->join(array('p' => TB_PESSOA), 'cp.id_pessoa = p.id', array('nmComprador' => 'nm_pessoa','nrEnderecoComprador' => 'nr_endereco',
                    'enderecoComprador' => 'endereco', 'bairroComprador' => 'nm_bairro', 'complementoComprador' => 'ds_complemento', 'id_pessoa' => 'id'))
                ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', array('nrCpfCompradores' => 'nr_cpf',
                    'nmNacionalidadeCompradores' => 'nm_nacionalidade', 'sexoCompradores' => 'sexo', 'estCivilCompradores' => 'est_civil',
                    'nrRgCompradores' => 'nr_rg'))
                ->joinLeft(['conP' => TB_PESSOA], 'pf.cd_conjuge = conP.id', ['nmConjuge' => 'nm_pessoa'])
                ->joinLeft(['conPf' => TB_PESSOA_FISICA], 'pf.cd_conjuge = conPf.id_pessoa', ['nrCpfConjuge' => 'nr_cpf'])
                ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'p.id = pj.id_pessoa', array('nr_cnpj', 'nm_fantasia'))
                ->join(array('ci' => TB_CIDADE), 'p.cd_cidade = ci.id', array('cidadeComprador' => 'nome', 'ufComprador' => 'uf'))
                ->where('cp.id_contrato = ' . $aditivo['id_contrato'])
                ->query()->fetchAll();

            $assinaturas = new Assinatura();
            $assinatura = $assinaturas->fetchAll($assinaturas->select()->where('id_empreendimento = ?', $aditivo['idEmpreendimento']))->toArray();
            
            //merge de todos os responsveis, compradores e clientes, para facilitar o alinhamento dos campos de assinaturas.
            $todasAssinaturas = array_merge($assinatura, $compradores);
            $todasAssinaturas[count($todasAssinaturas)] = $aditivo;
            
            $this->set('assinaturas', $todasAssinaturas);
            $this->set('compradores', $compradores);
            $this->set('listaParceiros', $parceiros);
            $this->set("listaRepresentantes", $pessoaParceiro);
        }

        $this->displayPDF("aditivoContratual_" . date("d/m/y_His") . ".pdf");
    }

    public function desfazerAction()
    {

        if ($this->_isGet) {
            $id = (int)$_GET["id"];

            $db = Zend_Db_Table::getDefaultAdapter();
            $db->beginTransaction();

            try {
                //altera a flag de distrato na tabela de contrato
                $tb_aditivo = $this->tb_aditivo->fetchRow('id_aditivo = ' . $id);
                $tb_aditivo->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - A');
                $tb_aditivo->fl_ativo = '0';
                $tb_aditivo->save();

                $db->commit();

                //Antes de redirecionar grava o resultado no log dos contatos realizados como aditivo contratual.
                (new Relacionamento())->saveContato(46, date('Y-m-d'), $tb_aditivo->id_contrato, 'Log: Aditivo Desfeito');

                $this->redir(array("modulo" => "adm", "controller" => "aditivo", 'action' => 'listar'), array("msg" => "OK"));
            } catch (Exception $e) {
                $db->rollBack();
                $this->redir(array("modulo" => "adm", "controller" => "aditivo", 'action' => 'listar'), array("exception" => $e->getMessage()));
            }
        }
    }

    private function validar()
    {

        $campos = array("id_empreendimento", "id_contrato", "dsOndelese", "dsAgoraleiase", "data");

        foreach ($campos as $cp) {
            if ($_POST [$cp] == '') {
                switch ($cp) {
                    case "id_empreendimento" :
                        $msg = "O Empreedimento  obrigatrio.";
                        break;
                    case "id_contrato" :
                        $msg = "O Lote  obrigatrio.";
                        break;
                    case "dsOndelese" :
                        $msg = "O campo Onde se l  obrigatrio.";
                        break;
                    case "dsAgoraleiase" :
                        $msg = "O campo Agora leia-se  obrigatrio..";
                        break;
                    case "data" :
                        $msg = "O campo Data  obrigatrio.";
                        break;
                }

                if (!empty($msg))
                    $this->_helper->addMensagem($cp, $msg);
                $msg = '';
            }
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function loteClienteByEmpreendimentoAction()
    {
        $contratos = Contrato::byEmpreendimento($_POST['id_empreendimento'], Contrato::CONTRATO_TODOS, 2, array("nm_pessoa", "lote", "quadra", "id"), true);

        $lista = array();
        foreach ($contratos as $contrato) {
            $lista[] = array('id' => $contrato['id'], 'text' => utf8_encode($contrato['nm_pessoa']) . ' - Quadra: ' . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']).' - Contrato: '.$contrato['id']);
        }

        echo json_encode($lista);
    }

}
