<?php

class AcompanhamentoController extends Controller
{

    private $tb_empreendimento;
    private $tb_agrupada;
    private $tb_acompanhamento;
    private $tb_acompanhamento_itens;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->tb_empreendimento = new Empreendimento();
        $this->tb_agrupada = new TabelaAgrupada();
        $this->tb_acompanhamento = new Acompanhamento();
        $this->tb_acompanhamento_itens = new AcompanhamentoItens();
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "adm", "controller" => "acompanhamento", "action" => "listar"));
    }

    public function listarAction()
    {
        $this->display('listar');
    }

    public function editarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'editarAcompanhamento')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'acompanhamento', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }
        
        $contatos = $this->tb_agrupada->fetchAll('idTabela = 11');
        $this->set('contatos', $contatos);
        $this->display('form');
    }

    public function formularioAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'adicionarAcompanhamento')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'acompanhamento', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $contatos = $this->tb_agrupada->fetchAll('idTabela = 11');

        $this->set('contatos', $contatos);
        $this->display('form');
    }

    public function adicionarAction()
    {
        if ($this->_isPost && isset($_POST['tipoContato'])) {
            try {
                $acompanhamento = $this->tb_acompanhamento->createRow();
                $acompanhamento->nm_acompanhamento = $_POST['nomeAcompanhamento'];
                $acompanhamento->descricao = $_POST['descricaoAcompanhamento'];
                $acompanhamento->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - A');
                $acompanhamento->save();
            } catch (Exception $e) {
                $this->redir(array('modulo' => 'adm', 'controller' => 'acompanhamento', 'action' => 'listar'), array('msg' => 'fail', 'exception' => $e->getMessage()));
            }

            $idAcompanhamento = $acompanhamento->id;

            for ($i = 0; $i < sizeof($_POST['posicao']); $i++) {
                $acompanhamento_item = $this->tb_acompanhamento_itens->createRow();
                $acompanhamento_item->id_acompanhamento = $idAcompanhamento;
                $acompanhamento_item->id_situacao = $_POST['tipoContato'][$i];
                $acompanhamento_item->id_ordem_sequencial = $_POST['posicao'][$i];
                $acompanhamento_item->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - A');
                $acompanhamento_item->save();
            }

            $this->redir(array('modulo' => 'adm', 'controller' => 'acompanhamento', 'action' => 'listar'), array('msg' => 'success'));
        } else {
            $this->redir(array('modulo' => 'adm', 'controller' => 'acompanhamento', 'action' => 'formulario'), array('msg' => 'fail', 'exception' => 'Adicione ao menos um tipo de contato'));
        }
    }

    public function listaAcompanhamentosAction()
    {
        if ($this->isAjax()) {
            $acompanhamentos = $this->tb_acompanhamento->getAdapter()->select()
                ->from(array("a" => TB_ACOMPANHAMENTO), array('codigo' => 'id', 'nomeAcompanhamento' => 'nm_acompanhamento', 'descricao'));
            $acompanhamentos = $acompanhamentos->query()->fetchAll();

            foreach ($acompanhamentos as &$acompanhamento) {
                $acompanhamento['descricao'] = utf8_encode($acompanhamento['descricao']);
                $acompanhamento['nomeAcompanhamento'] = utf8_encode($acompanhamento['nomeAcompanhamento']);
                $codigoId = $acompanhamento['codigo'];
                $acompanhamento['acoes'] = "<a class='btn btn-default btn-sm' data-toggle='tooltip' title='EDITAR' href='?m=adm&c=acompanhamento&a=editar&id=$codigoId'><i class='fa fa-edit'></i></a>"
                    . " <a class='btn btn-default btn-sm' data-toggle='tooltip' title='APAGAR' value='$codigoId'"
                    . " onclick='deletar(this);return false;'><i class='fa fa-times'></i></a>";
            }

            echo json_encode([
                'data' => $acompanhamentos
            ]);
        }
    }

    public function getInfoAction()
    {
        //Funo para retirar caracteres
        function strReplaceAssoc(array $replace, $subject) {
            return str_replace(array_keys($replace), array_values($replace), $subject);   
        }

        if ($this->isAjax()) {
            $acompanhamentos = $this->tb_acompanhamento->getAdapter()->select()
                ->from(array("a" => TB_ACOMPANHAMENTO), '*')
                ->join(array("ai" => TB_ACOMPANHAMENTO_ITENS), 'a.id = ai.id_acompanhamento', '*')
                ->join(array('ag' => TB_AGRUPADA), 'ai.id_situacao = ag.idCampo', array('idTabela', 'descricao as agr_desc'))
                ->where("a.id = ?", $_POST['id'])
                ->where('ag.idTabela = 11')
                ->order('ai.id_ordem_sequencial ASC')
                ->query()->fetchAll();

            $replace = array(
                '' => '',
                '' => '',
            );
            
            //Retirado acentos para no haver erros de encode no JSON
            foreach ($acompanhamentos as $key => $acompanhamentoItem)
            {
                // $acompanhamentos = Helper::removeCaracteresEspeciaisSped($acompanhamentos);
                $acompanhamentos[$key]['agr_desc'] = strReplaceAssoc($replace, Helper::removeCaracteresEspeciaisSped($acompanhamentoItem['agr_desc']));
            }
// var_dump($acompanhamentos);exit;
            echo json_encode(array('data' => $acompanhamentos));
        }
    }

    public function apagarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'apagarAcompanhamento')) {
            $this->redir(array('modulo' => 'adm', 'controller' => 'acompanhamento', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
            exit;
        }
        
        if ($this->isAjax()) {
            try {
                $deleteRowsItens = $this->tb_acompanhamento_itens->delete('id_acompanhamento = ' . $_POST['id_acompanhamento']);
            } catch (Exception $ex) {
                echo json_encode(array('response' => 'false'));
                return;
            }
            try {
                $deleteRowAcomp = $this->tb_acompanhamento->delete('id = ' . $_POST['id_acompanhamento']);
            } catch (Exception $ex) {
                echo json_encode(array('response' => 'false'));
                return;
            }

            echo json_encode(array('response' => 'true'));
        }
    }

    public function salvarEdicaoAction()
    {
        if ($this->_isPost) {
            $idAcompanhamento = $_POST['idAcompanhamento'];

            try {
                $acompanhamento = $this->tb_acompanhamento->fetchRow('id = ' . $idAcompanhamento);
                $acompanhamento->nm_acompanhamento = $_POST['nomeAcompanhamento'];
                $acompanhamento->descricao = $_POST['descricaoAcompanhamento'];
                $acompanhamento->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - A');
                $acompanhamento->save();
            } catch (Exception $e) {
                $this->redir(array('modulo' => 'adm', 'controller' => 'acompanhamento', 'action' => 'listar'), array('msg' => 'fail', 'exception' => $e->getMessage()));
            }

            try {
                $this->tb_acompanhamento_itens->delete('id_acompanhamento = ' . $idAcompanhamento);
            } catch (Exception $e) {
                $this->redir(array('modulo' => 'adm', 'controller' => 'acompanhamento', 'action' => 'listar'), array('msg' => 'fail', 'exception' => $e->getMessage()));
            }

            if ($_POST['posicao'] != '') {
                for ($i = 0; $i < sizeof($_POST['posicao']); $i++) {
                    $acompanhamento_item = $this->tb_acompanhamento_itens->createRow();
                    $acompanhamento_item->id_acompanhamento = $idAcompanhamento;
                    $acompanhamento_item->id_situacao = $_POST['tipoContato'][$i];
                    $acompanhamento_item->id_ordem_sequencial = $_POST['posicao'][$i];
                    $acompanhamento_item->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - A');
                    $acompanhamento_item->save();
                }
            } else {
                try {
                    $this->tb_acompanhamento->delete('id = ' . $idAcompanhamento);
                } catch (Exception $e) {
                    $this->redir(array('modulo' => 'adm', 'controller' => 'acompanhamento', 'action' => 'listar'), array('msg' => 'fail', 'exception' => $e->getMessage()));
                }
            }

            $this->redir(array('modulo' => 'adm', 'controller' => 'acompanhamento', 'action' => 'listar'), array('msg' => 'success'));
        }
    }
}
