<?php

class Usuario_Empreendimento extends Zend_Db_Table_Abstract
{

    protected $_name = TB_USUARIO_EMPREENDIMENTO;

    /**
     *
     * @param Db_Usuario $usuario
     * @return Array $id_empreencimento
     */
    public function listaEmpreendimentosRepresentante(Db_Usuario $usuario)
    {
        $id = [];

        $repres[] = (INT)$usuario->getId();

        $bind = implode(',', $repres);

        $selectParceria = $this->getDefaultAdapter();
        $empreendimentos = $selectParceria->select()->distinct('id_empreendimento')->from(TB_USUARIO_EMPREENDIMENTO, 'id_empreendimento')->where("id_pessoa_fisica IN({$bind})")->query()->fetchAll();

        $empreendimentos = array_map(function ($empreendimento){
            return $empreendimento['id_empreendimento'];
        }, $empreendimentos);

        return $empreendimentos;
    }

    //Busca o id e o nome dos empreendimentos pelo id do usuario
    public static function findEmpreendimentosUsuario($id)
    {
        $empreendimentos = self::getDefaultAdapter()->select()
            ->from(TB_USUARIO_EMPREENDIMENTO, array('id' => 'id_empreendimento'))
            ->join(array('em' => TB_EMPREENDIMENTO), 'em.id = id_empreendimento', array('nm_empreendimento'))
            ->where("id_pessoa_fisica = ?", $id)
            ->query();

        return $empreendimentos;
    }

    public function getAllUsuariosEmpreendimento($where = null)
    {

        if (!empty($where)) {
            $where = addslashes($where);
            $consulta = " us.login like '%{$where}%' " .
                " or pe.nm_pessoa like '%{$where}%' " .
                " or em.nm_empreendimento like '%{$where}%' ";
        } else {
            $consulta = ' 1 = 1 ';
        }
        $query = $this->select()->from(TB_USUARIO_EMPREENDIMENTO, '')
            ->setIntegrityCheck(false)
            ->join(array('em' => TB_EMPREENDIMENTO), 'em.id = id_empreendimento', array('empreendimento' => 'nm_empreendimento'))
            ->join(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = id_pessoa_fisica', '')
            ->join(array('pe' => TB_PESSOA), 'pe.id = pf.id_pessoa', array('nome' => 'nm_pessoa'))
            ->join(array('us' => TB_USUARIO), 'us.id = pe.id', array('id', 'login'))->where($consulta);
        return $this->fetchAll($query)->toArray();
    }


}