<?php
class Transferencia extends Zend_Db_Table_Abstract {

    protected $_name = TB_TRANSFERENCIA;
    static $transferencia;

    /**
     * @return Contrato
     */
    public static function getInstance()
    {
        if (!self::$transferencia) {
            self::$transferencia = new Parcela();
        }
        return self::$transferencia;
    }

    public static function buscaDatasTransferencias($idPessoa, $idContrato, $ano)
    {
        $transferencias = self::getInstance();

        $datas = $transferencias->getAdapter()->select()
            ->from(array('t' => TB_TRANSFERENCIA), array('data', 'idCedente', 'idReceptor', 'idContrato'))
            ->where('t.idContrato = ' . $idContrato)
            ->where('t.idCedente = ' . $idPessoa . ' OR t.idReceptor = ' . $idPessoa)
            ->where('YEAR(data) = ' . $ano)
            ->order('t.data ASC')
            ->query()->fetchAll();

        return $datas;
    }
}