<?php

class TipoLoteamento extends Zend_Db_Table_Abstract
{
    protected $_name = TB_TIPO_LOTEAMENTO;

    public static function findTipo($post, $count = false)
    {
        $search = utf8_decode($_POST['search']['value']);

        $order = $_POST['order'];
        $array = array(
            0 => 't.id_tipo_loteamento',
            1 => 't.ds_tipo_loteamento',
            2 => 't.ds_grupo',
            3 => 't.ds_subgrupo',
        );

        if ($search) {
            $where = 't.id_tipo_loteamento LIKE "%' . $search . '%" ';
            $where .= 'or t.ds_tipo_loteamento LIKE "%' . $search . '%" ';
            $where .= 'or t.ds_grupo LIKE "%' . $search . '%" ';
            $where .= 'or t.ds_subgrupo LIKE "%' . $search . '%" ';
        }

        $tipo = self::getDefaultAdapter()->select()
            ->from(array('t' => TB_TIPO_LOTEAMENTO), '*');

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $tipo->where("t.id_tipo_loteamento IN({$id})");
                }
            } catch (Exception $e) {
            }
        }

        if (isset($where)) {
            $tipo = $tipo->where($where);
        }

        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $tipo = $tipo->limit($post['length'], $post['start']);
            }

        foreach ($order as $ord)
            $orderByQuery[] = $array[$ord['column']] . ' ' . $ord['dir'];

        $tipo = $tipo->order(implode(',', $orderByQuery))->query()->fetchAll();

        return $tipo;
    }

}



