<?php

class TaxaValor extends Zend_Db_Table_Abstract
{

    protected $_name = TB_TAXA_VALOR;

    /**
     *
     * @param string $termo
     * @return array
     */
    public static function fullSearch($termo, $count = false, $offset = false, $page = false, $where = false)
    {
        $termo = "'%" . strtoupper($termo) . "%'";
        $db = DB::getInstance();

        if ($count && $offset === false && $page === false) {
            $select = "SELECT count(t.id_empreendimento) AS count FROM " . TB_TAXA_VALOR . " t
                    JOIN " . TB_AGRUPADA . " agr  ON t.id_tipo_taxa = agr.idcampo AND agr.idtabela = 17
                    JOIN " . TB_EMPREENDIMENTO . " e  ON t.id_empreendimento = e.id
                  WHERE CONCAT(UPPER(e.nm_empreendimento),' ',UPPER(agr.descricao)) LIKE {$termo}
                  ";
            if ($where) {
                $select .= " AND $where";
            }
        } else {
            $select = "SELECT t.*, e.nm_empreendimento, agr.descricao AS ds_taxa FROM " . TB_TAXA_VALOR . " t
                    JOIN " . TB_AGRUPADA . " agr  ON t.id_tipo_taxa = agr.idcampo AND agr.idtabela = 17
                    JOIN " . TB_EMPREENDIMENTO . " e  ON t.id_empreendimento = e.id
                  WHERE CONCAT(UPPER(e.nm_empreendimento),' ',UPPER(agr.descricao)) LIKE {$termo}
                  ";
            if ($where) {
                $select .= " AND $where";
            }
            $select .= " ORDER BY e.id ASC, agr.descricao ASC";
            if ($offset !== false && $page !== false)
                $select .= " LIMIT {$offset}, {$page} ";
        }
        $stmt = $db->prepare($select);
        $stmt->execute();
        $ids = $stmt->fetchAll(PDO::FETCH_ASSOC);

        return $ids;
    }

    /**
     * Buscas as taxas pelo id do empreendimento
     * @param $idEmp
     * @return array
     */
    public static function findByEmpreendimento($idEmp)
    {
        $taxas = self::getDefaultAdapter()->select()
            ->from(array('t' => TB_TAXA_VALOR), array('*'))
            ->join(array('e' => TB_EMPREENDIMENTO), 't.id_empreendimento = e.id', array('e.nm_empreendimento'))
            ->join(array('agr' => TB_AGRUPADA), 'agr.idTabela = 17 AND agr.idCampo = t.id_tipo_taxa', array('agr.descricao', 'agr.idCampo'))
            ->where('e.id = ?', $idEmp)
            ->query()->fetchAll();

        return $taxas;
    }

    /**
     * Busca a taxa pelo id
     * @param $id
     * @return mixed
     */
    public static function findById($id)
    {
        $taxa = self::getDefaultAdapter()->select()
            ->from(array('t' => TB_TAXA_VALOR), array('*'))
            ->join(array('e' => TB_EMPREENDIMENTO), 't.id_empreendimento = e.id', array('e.nm_empreendimento'))
            ->join(array('agr' => TB_AGRUPADA), 'agr.idTabela = 17 AND agr.idCampo = t.id_tipo_taxa', array('agr.descricao', 'agr.idCampo'))
            ->where('t.id_taxas = ?', $id)
            ->query()->fetch();

        return $taxa;
    }

    public static function findLista($post, $count = false)
    {
        $search = utf8_decode($_POST['search']['value']);
        $order = $_POST['order'];

        $array = array(
            0 => 't.id_taxas',
            1 => 'e.nm_empreendimento',
            2 => 'agr.descricao',
            3 => 't.vl_taxa'
        );

        if ($search) {
            $where = 't.id_taxas LIKE "%' . $search . '%" ';
            $where .= 'or e.nm_empreendimento LIKE "%' . $search . '%" ';
            $where .= 'or agr.descricao LIKE "%' . $search . '%" ';
        }

        $itens = self::getDefaultAdapter()->select()
            ->from(array('t' => TB_TAXA_VALOR), array('id' => 't.id_taxas', 't.vl_taxa'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = t.id_empreendimento', array('e.nm_empreendimento'))
            ->join(array('agr' => TB_AGRUPADA), 'agr.idTabela = 17 AND t.id_tipo_taxa = agr.idCampo', array('descricao'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $itens->where("e.id IN({$id})");
                }
            } catch (Exception $e) {
            }
        }

        if (isset($where)) {
            $itens = $itens->where($where);
        }

        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $itens = $itens->limit($post['length'], $post['start']);
            }

        $orderByQuery = array();
        foreach ($order as $ord)
            $orderByQuery[] = $array[$ord['column']] . ' ' . $ord['dir'];

        $itens = $itens->order(implode(',', $orderByQuery))->query()->fetchAll();


        return $itens;
    }

}