<?php

class TabelaPrecoLotes extends Zend_Db_Table_Abstract {

    protected $_name = TB_TABELA_PRECO_LOTES;

    public function getLotesByIdTbPreco($id)
    {
        return $this->fetchAll('id_tabela_preco = ' . $id)->toArray();
    }
    public function getTbPrecoLoteById($id)
    {
        return $this->fetchRow('id_tabela_preco_lotes = ' . $id);
    }
    public function getDiferencaLotesByTbPrecoId($id, $quadra, $emp)
    {

        $lotes = $this->getDefaultAdapter()->select()
            ->from(array('l' => TB_LOTES), array('*'))            
            ->where('id NOT IN (
                SELECT id FROM LOTES as ll
                inner join TABELA_PRECO_LOTES as tpl ON tpl.id_lote = ll.id
                where tpl.id_tabela_preco = ' . $id . ')')
            ->where('l.id_empreendimento = ?', $emp);

        if ($quadra != "*")
            $lotes = $lotes->where('l.quadra IN (?)', $quadra);

        return $lotes->order('l.id')->query()->fetchAll();
    }
    public function getQuadrasByIdTbPreco($id, $idLote = null)
    {
        $dados = $this->getDefaultAdapter()->select()
                ->from(array('tpl' => TB_TABELA_PRECO_LOTES), array('*'))
                ->join(array('tp' => TB_TABELA_PRECO), 'tp.id_tabela_preco = tpl.id_tabela_preco', array('*'))
                ->join(array('l' => TB_LOTES), 'l.id = tpl.id_lote', array('*'))
                ->where('tpl.id_tabela_preco = ' . $id);

        if ($idLote)
            $dados = $dados->where('tpl.id_lote = ' . $idLote);

        $dados = $dados->group('l.quadra')
                ->order('l.quadra')
                ->query()->fetchAll();

        return $dados;
    }
    public function getQuadrasByIdLote($id)
    {
        return $this->getDefaultAdapter()->select()
                ->from(array('tpl' => TB_TABELA_PRECO_LOTES), array('*'))
                ->join(array('tp' => TB_TABELA_PRECO), 'tp.id_tabela_preco = tpl.id_tabela_preco', array('*'))
                ->join(array('l' => TB_LOTES), 'l.id = tpl.id_lote', array('*'))
                ->where('tpl.id_lote = ' . $id)
                ->group('l.quadra')
                ->order('l.quadra')
                ->query()->fetchAll();
    }
}
