<?php

class TabelaAgrupada extends Zend_Db_Table_Abstract
{
    protected $_name = TB_AGRUPADA;
    const TIPO_CONTATO_DISTRATO = '19';

    public static function findListaAgrupada($post, $count = false, $idCampo = false)
    {
        $search = utf8_decode($_POST['search']['value']);
        $order = $_POST['order'];

        $array = array(
            0 => 'a.idCampo',
            1 => 'a.descricao',
            2 => 'a.complemento',
            3 => 'a.fixo'
        );

        if ($search) {
            $where = 'a.idCampo LIKE "%' . $search . '%" ';
            $where .= 'or a.descricao LIKE "%' . $search . '%" ';
            $where .= 'or a.complemento LIKE "%' . $search . '%" ';
            $where .= 'or a.fixo LIKE "%' . $search . '%" ';
        }
        $agrupada = self::getDefaultAdapter()->select()
            ->from(array('a' => TB_AGRUPADA), '*')
            ->where('idTabela = ? ' , $idCampo);

        if (isset($where)) {
            $agrupada = $agrupada->where($where);
        }

        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $agrupada = $agrupada->limit($post['length'], $post['start']);
            }

        foreach ($order as $ord)
            $orderByQuery[] = $array[$ord['column']] . ' ' . $ord['dir'];

        $agrupada = $agrupada->query()->fetchAll();


        return $agrupada;
    }

    public function findTabelaById($idTabela) {

        $tabelaAgrupada = self::getDefaultAdapter()->select()
            ->from(array('a' => TB_AGRUPADA), '*')
            ->where('a.idTabela = ' . $idTabela)
            ->query()->fetchAll();

        return $tabelaAgrupada;
    }

    //busca o estado da cidade de acordo com a uf passada.
    public static function findEstado($uf) {

        $estado = self::getDefaultAdapter()->select()
            ->from(array('a' => TB_AGRUPADA), 'descricao')
            ->where('idTabela = "1"')
            ->where('idCampo = ? ', $uf)
            ->query()->fetch();

        return $estado;
    }
}

