<?php
class Sped extends Zend_Db_Table_Abstract
{
    protected $_name = TB_SPED;

    public static function findLista($post, $count = false)
    {
        $search = utf8_decode($_POST['search']['value']);
        $order = $_POST['order'];

        $array = array(
            0 => 's.id_sped',
            1 => 'e.nm_empreendimento',
            2 => 's.dt_geracao',
            3 => 's.ds_periodo',
            4 => 's.ds_arquivo',
        );

        if ($search) {
            $where = 's.id_sped LIKE "%' . $search . '%" ';
            $where .= 'or e.nm_empreendimento LIKE "%' . $search . '%" ';
            $where .= 'or s.ds_periodo LIKE "%' . $search . '%" ';
            $where .= 'or s.ds_arquivo LIKE "%' . $search . '%" ';
            $where .= 'or DAY(s.dt_geracao) = "' . $search . '" ';
            $where .= 'or MONTH(s.dt_geracao) = "' . $search . '" ';
            $where .= 'or YEAR(s.dt_geracao) = "' . $search . '" ';
        }

        $lista = self::getDefaultAdapter()->select()
            ->from(array('s' => TB_SPED), '*')
            ->joinLeft(array('e' => TB_EMPREENDIMENTO), 'e.id = s.id_empreendimento', 'nm_empreendimento');

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if (Login::getUsuario()->getSuper() == '0') {
            $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
            $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
            if (count($ids)) {
                $id = implode(',', $ids);
                $lista->where("e.id IN({$id})");
            }
        }

        if (isset($where)) {
            $lista = $lista->where($where);
        }

        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $lista = $lista->limit($post['length'], $post['start']);
            }
        foreach ($order as $ord)
            $orderByQuery[] = $array[$ord['column']] . ' ' . $ord['dir'];

        $lista = $lista->order(implode(',', $orderByQuery))->query()->fetchAll();

        return $lista;
    }

}