<?php

class Sinal extends Zend_Db_Table_Abstract {

    protected $_name = TB_SINAL;

    static $sinalInstancia;

    //retorna uma instancia do objeto para uso de SINGLETON
    public static function getInstance()
    {
        if (!self::$sinalInstancia) {
            self::$sinalInstancia = new ContratoPessoa();
        }
        return self::$sinalInstancia;
    }

    //Retorna as parcelas sinal pelo contrato
    public static function findByContrato($contrato)
    {
        $sinal = self::getInstance();
        $sinal = $sinal->getDefaultAdapter()->select()->from(array('s' => TB_SINAL), array('*'))
            ->where('s.idContrato = ?', $contrato)
            ->order('parcela')
            ->query()->fetchAll();

        return $sinal;
    }
}
