<?php

class RetornoRemessa {

    /**
     * @property string $arquivo  Caminho para o arquivo de retorno bancario
     */
    protected $arquivo;
    protected $header;
    protected $lines;
    protected $trailer;

    public function __construct($arquivo) {
        if (file_exists($arquivo)) {
            $this->arquivo = $arquivo;

            $lines = file($arquivo);

            $this->header = substr($lines[0], 0, -1);

            $this->trailer = substr(end($lines), 0, -1);

            $this->lines = array();
            for ($i = 1; $i < count($lines) - 1; $i++) {
                $this->lines[] = substr($lines[$i], 0, -1);
            }
        }
    }

    /**
     * Obtem os dados do arquivo de retorno bancario, colocando as parcelas obtidas
     * do arquivo, como pagas na base de dados.
     *
     * @param void
     * @author Pablo de Oliveira Lima.
     * @return array $resultado  Contem os registros alterados, como tambem os
     * erros encontrados no arquivo.
     */
    public function processar() {
        // processa o header;
        echo $this->header;
        $retorno['header']['idReg'] = substr($this->header, 0, 1);           //001 a 001   Identificao do Registro             001        0       X
        $retorno['header']['idRet'] = substr($this->header, 1, 1);           //002 a 002   Identificao do Arquivo Retorno      001        2       X
        $retorno['header']['cdEmp'] = substr($this->header, 26, 20);         //027 a 046   Cdigo da Empresa                     020  No Empresa    X
        $retorno['header']['nmEmp'] = substr($this->header, 46, 30);           //047 a 076   Nome da Empresa por Extenso           030 Razo Social X
        $dtGravacao = substr($this->header, 94, 2) . '/' . substr($this->header, 96, 2) . '/' . substr($this->header, 98, 2);
        $dtCredito = substr($this->header, 379, 2) . '/' . substr($this->header, 381, 2) . '/' . substr($this->header, 383, 2);

        $retorno['header']['dtGravacao'] = $dtGravacao;      //095 a 100   Data da Gravao do Arquivo           006    DDMMAA      X
        $retorno['header']['dtCredito'] = $dtCredito;      //380 a 385   Data do Crdito                       006     DDMMAA     X
        // processa registros
        $i = 1;
        foreach ($this->lines as $reg) {

            $registros[$i]['inscricao'] = substr($reg, 3, 14);          //004 a 017     No Inscrio da Empresa Filial             014                       
            $registros[$i]['idEmpresa'] = substr($reg, 20, 16);         //021 a 037     Identificao da Empresa Cedente no Banco  017                       
            $registros[$i]['nrParticipante'] = substr($reg, 37, 25);         //038 a 062     No Controle do Participante                025    Uso da Empresa     
            $registros[$i]['idTitulo'] = substr($reg, 70, 12);         //071 a 082     Identificao do Ttulo No Banco           012                       
            $registros[$i]['carteira'] = substr($reg, 107, 1);         //108 a 108     Carteira                                   001        Carteira       
            $registros[$i]['idOcorrencia'] = substr($reg, 108, 2);         //109 a 110     Identificao de Ocorrncia                002 Vide Obs. Pg. 46     
            $dtOcorrBanco = substr($reg, 110, 2) . '/' . substr($reg, 112, 2) . '/' . substr($reg, 114, 2);
            $registros[$i]['dtOcorrencia'] = $dtOcorrBanco;                //111 a 116     Data Ocorrncia no Banco                   006          DDMMAA       
            $registros[$i]['nrDocumento'] = substr($reg, 116, 10);        //117 a 126     Nmero do Documento                        010    No do Documento    
            $registros[$i]['idTitulo'] = substr($reg, 126, 20);        //127 a 146     Identificao do Ttulo no Banco           020                       
            $dtVencimento = substr($reg, 146, 2) . '/' . substr($reg, 148, 2) . '/' . substr($reg, 150, 2);
            $registros[$i]['dtVencimento'] = $dtVencimento;                //147 a 152     Data Vencimento do Ttulo                  006          DDMMAA         
            $registros[$i]['vlTitulo'] = substr($reg, 152, 13);        //153 a 165     Valor do Ttulo                            013      Valor Ttulo       
            $registros[$i]['cdBancoCobrador'] = substr($reg, 165, 3);         //166 a 168     Banco Cobrador                             003  Cdigo do Banco  Cm. de Comp.       
            $registros[$i]['agConbradora'] = substr($reg, 168, 5);         //169 a 173     Agncia Cobradora                          005  Agncia do Banco Cob.  
                                                           //              Despesas de cobrana para
                                                           //              os Cdigos de Ocorrncia                   013  Valor Despesa
            $registros[$i]['vlDespesa'] = substr($reg, 175, 13);        //176 a 188     02 - Entrada Confirmada                                                
                                                           //              28 - Dbito de Tarifas                          Vide Obs. Pg. 46
            $registros[$i]['sequencial'] = (int)substr($reg, 396);       //395 a  400    No Seqencial de Registro                  006  No Seqencial do reg.  
            
            $i++;
            
        }
        
        $retorno['registros'] = $registros;

        // processa trailer
        
        
        var_dump($retorno);

        //processa linhas  


        return $resultado;
    }

    /**
     * Carrega o arquivo de retorno bancario e processa as linhas obtidas.
     *
     * @param void
     * @author Pablo de Oliveira Lima.
     * @return void
     */
    protected function processarArquivo() {
        $linhas = file($this->arquivo, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        foreach ($linhas as $numLn => $linha) {
            $linhaProcessada = $this->processarLinha($numLn, $linha);
            if ($linhaProcessada && $this->tamanho_linha == 400) {
                if ($linhaProcessada['linha']['sequencial'] && $linhaProcessada['tipo'] == '1') {
                    $this->pagamentos[] = $linhaProcessada['linha'];
                }
            } elseif ($linhaProcessada && $this->tamanho_linha == 240) {
                // Verifica se eh registro de detalhe de pagamento
                if ($linhaProcessada['linha']['registro'] == '3') {
                    // Verifica se o tipo de linha tem segmento U,
                    // e caso tenha pega o segmento T anteriormente adicionado e concatena
                    if ($linhaProcessada['linha']['segmento'] == "U") {
                        $parte1 = array_pop($this->pagamentos); // retirando segmento T da lista
                        $parte2 = $linhaProcessada['linha'];
                        $this->pagamentos[] = array_merge($parte1, $parte2);
                    } else {
                        $this->pagamentos[] = $linhaProcessada['linha'];
                    }
                }
            }
        }
    }

    /**
     * Processa uma linha obtida do arquivo de retorno bancario.
     *
     * @param int $numLn  Numero da linha no arquivo.
     * @param string $linha  Linha obtida do arquivo.
     * @author Pablo de Oliveira Lima, Manoel Campos da Silva Filho
     * @return array $vlinha  Retorna os dados da linha como array
     */
    protected function processarLinha($numLn, $linha) {
        //total de caracteres das linhas do arquivo
        $tamLinha = $this->tamanho_linha;
        //total de caracteres das linhas do arquivo e o +2  utilizado para contar o \r\n no final da linha
        //$tamLinha2 = $tamLinha + 1;
        //if((strlen($linha)!= $tamLinha && strlen($linha)!=$tamLinha2) || (trim($linha)=="")) {
        if (strlen($linha) != $tamLinha || (trim($linha) == "")) {
            $this->linhasErradas[] = $linha;
            return false;
        }

        // adicionado um espao vazio no incio_linha para que
        //possamos trabalhar com ndices iniciando_1, no lugar_zero,
        //e assim, ter os valores_posio_campos exatamente
        //como no manual CNAB400 / CNAB240
        $linha = " $linha";
        if ($this->tamanho_linha == 400) {
            $tipoLn = substr($linha, 1, 1);

            if ($tipoLn == RetornoBoleto::HEADER_ARQUIVO) {
                $vlinha = array('tipo' => RetornoBoleto::HEADER_ARQUIVO,
                    'linha' => $this->processarLinhaHeader($linha));
                $this->header_arquivo = $vlinha['linha'];
            } else if ($tipoLn == RetornoBoleto::DETALHE_400) {
                $vlinha = array('tipo' => RetornoBoleto::DETALHE_400,
                    'linha' => $this->processarLinhaDetalhe($linha));
            } else if ($tipoLn == RetornoBoleto::TRAILER_ARQUIVO) {
                $vlinha = array('tipo' => RetornoBoleto::TRAILER_ARQUIVO,
                    'linha' => $this->processarLinhaTrailer($linha));
                $this->trailer_arquivo = $vlinha['linha'];
            }
        } elseif ($this->tamanho_linha == 240) {
            $tipoLn = substr($linha, 8, 1);

            if ($tipoLn == RetornoBoleto::HEADER_ARQUIVO) {
                $vlinha = array('tipo' => RetornoBoleto::HEADER_ARQUIVO,
                    'linha' => $this->processarLinhaHeader($linha));
                $this->header_arquivo = $vlinha['linha'];
            } else if ($tipoLn == RetornoBoleto::HEADER_LOTE) {
                $vlinha = array('tipo' => RetornoBoleto::HEADER_LOTE,
                    'linha' => $this->processarLinhaHeaderLote($linha));
                $this->header_lote = $vlinha['linha'];
            } else if ($tipoLn == RetornoBoleto::DETALHE_240) {
                $vlinha = array('tipo' => RetornoBoleto::DETALHE_240,
                    'linha' => $this->processarLinhaDetalhe($linha));
            } else if ($tipoLn == RetornoBoleto::TRAILER_ARQUIVO) {
                $vlinha = array('tipo' => RetornoBoleto::TRAILER_ARQUIVO,
                    'linha' => $this->processarLinhaTrailer($linha));
                $this->trailer_arquivo = $vlinha['linha'];
            } else if ($tipoLn == RetornoBoleto::TRAILER_LOTE) {
                $vlinha = array('tipo' => RetornoBoleto::TRAILER_LOTE,
                    'linha' => $this->processarLinhaTrailerLote($linha));
                $this->trailer_lote = $vlinha['linha'];
            }
        }

        return $vlinha;
    }

    protected function processarLinhaHeader($linha) {
        $vlinha = array();
        if ($this->tamanho_linha == 400) {
            //X = ALFANUMRICO 9 = NUMRICO V = VRGULA DECIMAL ASSUMIDA
            $vlinha["id_registro"] = substr($linha, 1, 1); //9 Identificao do Registro Header: ?0?
            $vlinha["tipo_operacao"] = substr($linha, 2, 1); //9 Tipo de Operao: ?2?
            $vlinha["id_tipo_operacao"] = substr($linha, 3, 7); //X Identificao Tipo de Operao ?RETORNO?
            $vlinha["id_tipo_servico"] = substr($linha, 10, 2); //9 Identificao do Tipo de Servio: ?01?
            $vlinha["tipo_servico"] = substr($linha, 12, 8); //X Identificao por Extenso do Tipo de Servio: ?COBRANCA?
            $vlinha["codigo_empresa"] = substr($linha, 27, 20);
            $vlinha["razao_social"] = substr($linha, 47, 30);
            $vlinha["cod_banco"] = substr($linha, 77, 3);
            $vlinha["nome_banco"] = substr($linha, 80, 15);
            $vlinha["data_gravacao"] = $this->formataData(substr($linha, 95, 6));
            $vlinha["densidade_gravacao"] = substr($linha, 101, 8);
            $vlinha["aviso_bancario"] = substr($linha, 109, 5);
            $vlinha["complemento2"] = substr($linha, 114, 266);
            $vlinha["data_credito"] = $this->formataData(substr($linha, 380, 6));
            $vlinha["complemento3"] = substr($linha, 386, 9);
            $vlinha["sequencial_reg"] = substr($linha, 395, 6);
        } elseif ($this->tamanho_linha == 240) {
            $vlinha["banco"] = substr($linha, 1, 3); //NUMERICO //Cdigo do Banco na Compensao
            $vlinha["lote"] = substr($linha, 4, 4); //num - default 0000 //Lote de Servio
            $vlinha["registro"] = substr($linha, 8, 1); //num - default 0 //Tipo de Registro
            $vlinha["cnab1"] = substr($linha, 9, 9); //BRANCOS //Uso Exclusivo FEBRABAN / CNAB
            $vlinha["tipo_inscricao_empresa"] = substr($linha, 18, 1); //num - 1-CPF, 2-CGC //Tipo de Inscrio da Empresa
            $vlinha["num_inscricao_empresa"] = substr($linha, 19, 14); //numerico  //Nmero de Inscrio da Empresa
            $vlinha["cod_convenio"] = substr($linha, 33, 20); //alfanumerico  //Cdigo do Convnio no Banco
            $vlinha["agencia"] = substr($linha, 53, 5); //numerico //Agncia Mantenedora da Conta
            $vlinha["dv_agencia"] = substr($linha, 58, 1); //alfanumerico //DV da Agncia
            $vlinha["conta_corrente"] = substr($linha, 59, 12); //numerico //Nmero da Conta Corrente
            $vlinha["dv_conta"] = substr($linha, 71, 1); //alfanumerico  //DV da Conta Corrent
            $vlinha["dv_ag_conta"] = substr($linha, 72, 1); //alfanumerico
            $vlinha["nome_empresa"] = substr($linha, 73, 30); //alfanumerico
            $vlinha["nome_banco"] = substr($linha, 103, 30); //alfanumerico
            $vlinha["uso_febraban_cnab2"] = substr($linha, 133, 10); //brancos //Uso Exclusivo FEBRABAN / CNAB
            $vlinha["cod_arq"] = substr($linha, 143, 1); //num - 1-REM E 2-RET ?? //Cdigo do arquivo de remessa/retorno
            $vlinha["data_geracao_arq"] = substr($linha, 144, 8); //num - formato ddmmaaaa
            $vlinha["hora_geracao_arq"] = substr($linha, 152, 6); //num - formato hhmmss
            $vlinha["sequencia"] = substr($linha, 158, 6); //numerico //Nmero Sequencial do Arquivo
            $vlinha["versao_layout_arq"] = substr($linha, 164, 3); //num 084 //Num da Verso do Layout do Arquivo
            $vlinha["densidade"] = substr($linha, 167, 5); //numerico //Densidade de Gravao do Arquivo
            $vlinha["reservado_banco"] = substr($linha, 172, 20); //alfanumerico //Para Uso Reservado do Banco
            $vlinha["reservado_empresa"] = substr($linha, 192, 20); //alfanumerico //Para Uso Reservado da Empresa
            $vlinha["uso_febraban_cnab3"] = substr($linha, 212, 29); //brancos //Uso Exclusivo FEBRABAN / CNAB
        }
        return $vlinha;
    }

    protected function processarLinhaHeaderLote($linha) {
        $vlinha = array();
        $vlinha["banco"] = substr($linha, 1, 3); //numerico //Cdigo do Banco na Compensao
        $vlinha["lote"] = substr($linha, 4, 4); //numerico //Lote de Servio
        $vlinha["registro"] = substr($linha, 8, 1); //num - default 1 //Tipo de Registro
        $vlinha["operacao"] = substr($linha, 9, 1); //alfanumerico - default C //Tipo da Operao
        $vlinha["servico"] = substr($linha, 10, 2); //num  //Tipo do Servio
        $vlinha["forma_lancamento"] = substr($linha, 12, 2); //num //Forma de Lanamento
        $vlinha["layout_lote"] = substr($linha, 14, 3); //num - default '030' //No da Verso do Layout do Lote
        $vlinha["cnab1"] = substr($linha, 17, 1); //alfa - default brancos  //Uso Exclusivo da FEBRABAN/CNAB

        $vlinha["tipo_inscricao_empresa"] = substr($linha, 18, 1); //num - 1-CPF, 2-CGC //Tipo de Inscrio da Empresa
        $vlinha["num_inscricao_empresa"] = substr($linha, 20, 14); //numerico //Nmero de Inscrio da Empresa
        $vlinha["cod_convenio"] = substr($linha, 34, 20); //alfanumerico //Cdigo do Convnio no Banco

        $vlinha["agencia"] = substr($linha, 54, 5); //numerico //Agncia Mantenedora da Conta
        $vlinha["dv_agencia"] = substr($linha, 59, 1); //alfanumerico //DV da Agncia Mantenedora da Conta
        $vlinha["conta_corrente"] = substr($linha, 60, 12); //numerico
        $vlinha["dv_conta"] = substr($linha, 72, 1); //alfanumerico
        $vlinha["dv_ag_conta"] = substr($linha, 73, 1); //alfanumerico //Dgito Verificador da Ag/Conta
        $vlinha["nome_empresa"] = substr($linha, 74, 30); //alfanumerico
        $vlinha["mensagem1"] = substr($linha, 104, 40); //alfanumerico

        $vlinha["logradouro_empresa"] = substr($linha, 144, 30); //alfa //Logradouro da Empresa - Nome da Rua, Av, Pa, Etc
        $vlinha["numero_empresa"] = substr($linha, 174, 5); //num //Nmero do endereo da empresa
        $vlinha["complemento_empresa"] = substr($linha, 179, 15); //alfa //Complemento - Casa, Apto, Sala, Etc
        $vlinha["cidade_empresa"] = substr($linha, 194, 20); //alfa //Cidade da Empresa
        $vlinha["cep_empresa"] = substr($linha, 214, 5); //num //5 primeiros dgitos do CEP da Empresa
        $vlinha["complemento_cep_empresa"] = substr($linha, 219, 3); //alfa //3 ltimos dgitos do CEP da empresa
        $vlinha["estado"] = substr($linha, 222, 2); //  alfa  //Sigla do Estado
        $vlinha["cnab"] = substr($linha, 224, 8); // alfa - default brancos //Uso Exclusivo da FEBRABAN/CNAB
        $vlinha["ocorrencias"] = substr($linha, 232, 10); //alfa //Cdigo das Ocorrncias p/ Retorno
        return $vlinha;
    }

    protected function processarLinhaDetalhe($linha) {
        $vlinha = array();
        if ($this->tamanho_linha == 400) {
            //X = ALFANUMRICO 9 = NUMRICO V = VRGULA DECIMAL ASSUMIDA
            $vlinha["id_registro"] = substr($linha, 1, 1); //9  Identificao do Registro Detalhe: 1 (um)
            $vlinha["tipo_insc_empresa"] = substr($linha, 2, 2);
            $vlinha["nr_insc_empresa"] = substr($linha, 4, 14);
            $vlinha["zeros1"] = substr($linha, 18, 3);
            $vlinha["cod_cedente"] = substr($linha, 21, 17);
            $vlinha["contr_participante"] = substr($linha, 38, 25);
            $vlinha["zeros2"] = substr($linha, 63, 8);
            $vlinha["titulo_banco"] = substr($linha, 71, 12);
            $vlinha["zeros3"] = substr($linha, 83, 10);
            $vlinha["zeros4"] = substr($linha, 93, 12);
            $vlinha["rateio_credito"] = substr($linha, 105, 1);
            $vlinha["zeros5"] = substr($linha, 106, 2);
            $vlinha["carteira"] = substr($linha, 108, 1);
            $vlinha["ocorrencia"] = substr($linha, 109, 2);
            $vlinha["data_ocorrencia"] = $this->formataData(substr($linha, 111, 6));
            $vlinha["numero_documento"] = substr($linha, 117, 10);
            $vlinha["titulo_banco2"] = substr($linha, 127, 20);
            $vlinha["data_vencimento"] = $this->formataData(substr($linha, 147, 6));
            $vlinha["valor_titulo"] = $this->formataNumero(substr($linha, 153, 13));
            $vlinha["codigo_banco_cobr"] = substr($linha, 166, 3);
            $vlinha["agencia_banco_cobr"] = substr($linha, 169, 5);
            $vlinha["especie_titulo"] = substr($linha, 174, 2);
            $vlinha["valor_tarifa"] = $this->formataNumero(substr($linha, 176, 13));
            $vlinha["outras_despesas"] = $this->formataNumero(substr($linha, 189, 13));
            $vlinha["juros_operacao"] = $this->formataNumero(substr($linha, 202, 13));
            $vlinha["iof_devido"] = $this->formataNumero(substr($linha, 215, 13));
            $vlinha["valor_abatimento"] = $this->formataNumero(substr($linha, 228, 13));
            $vlinha["desconto_concedido"] = $this->formataNumero(substr($linha, 241, 13));
            $vlinha["valor_pago"] = $this->formataNumero(substr($linha, 254, 13));
            $vlinha["juros_mora"] = $this->formataNumero(substr($linha, 267, 13));
            $vlinha["outros_creditos"] = $this->formataNumero(substr($linha, 280, 13));
            $vlinha["brancos1"] = substr($linha, 293, 2);
            $vlinha["motivo_ocorrencia"] = substr($linha, 295, 1);
            $vlinha["data_credito"] = $this->formataData(substr($linha, 296, 6));
            $vlinha["origem_pagamento"] = substr($linha, 302, 3);
            $vlinha["brancos2"] = substr($linha, 305, 10);
            $vlinha["cheque_bradesco"] = substr($linha, 315, 4);
            $vlinha["motivo_ocorrencia2"] = substr($linha, 319, 10);
            $vlinha["brancos3"] = substr($linha, 329, 40);
            $vlinha["cartorio"] = substr($linha, 369, 2);
            $vlinha["protocolo"] = substr($linha, 371, 10);
            $vlinha["brancos4"] = substr($linha, 381, 10);
            $vlinha["sequencial"] = substr($linha, 395, 6);
        } elseif ($this->tamanho_linha == 240) {
            $vlinha["banco"] = substr($linha, 1, 3); //   Num //Cdigo no Banco da Compensao
            $vlinha["lote"] = substr($linha, 4, 4); //   Num //Lote de Servio
            $vlinha["registro"] = substr($linha, 8, 1); //   Num  default '3' //Tipo de Registro
            $vlinha["num_registro_lote"] = substr($linha, 9, 5); //   Num  //No Sequencial do Registro no Lote
            $vlinha["segmento"] = substr($linha, 14, 1); //   Alfa  default 'J' //Cdigo de Segmento no Reg. Detalhe
            $vlinha["tipo_movimento"] = substr($linha, 15, 1); //   Num //Tipo de Movimento
            $vlinha["cod_movimento"] = substr($linha, 16, 2); //   Num  //Cdigo da Instruo p/ Movimento
            switch ($vlinha["segmento"]) {
                case 'J':
                    $vlinha["cod_barras"] = substr($linha, 18, 44); //   Num
                    $vlinha["nome_cedente"] = substr($linha, 62, 30); //   Alfa
                    $vlinha["data_vencimento"] = substr($linha, 92, 8); //   Num  //Data do Vencimento (Nominal)
                    $vlinha["valor_titulo"] = substr($linha, 100, 15); //   Num, 2 casas decimais //Valor do Ttulo (Nominal)
                    $vlinha["desconto"] = substr($linha, 115, 15); //   Num, 2 casas decimais //Valor do Desconto + Abatimento
                    $vlinha["acrescimos"] = substr($linha, 130, 15); //   Num, 2 casas decimais //Valor da Mora + Multa
                    $vlinha["data_pagamento"] = substr($linha, 145, 8); //   Num
                    $vlinha["valor_pagamento"] = substr($linha, 153, 15); //   Num, 2 casas decimais
                    $vlinha["quantidade_moeda"] = substr($linha, 168, 15); //   Num, 5 casas decimais
                    $vlinha["referencia_sacado"] = substr($linha, 183, 20); //   Alfa //Num. do Documento Atribudo pela Empresa
                    $vlinha["nosso_numero"] = substr($linha, 203, 20); //   Alfa //Num. do Documento Atribudo pelo Banco
                    $vlinha["cod_moeda"] = substr($linha, 223, 2); //   Num
                    $vlinha["cnab"] = substr($linha, 225, 6); //   Alfa - default Brancos //Uso Exclusivo FEBRABAN/CNAB
                    $vlinha["ocorrencias"] = substr($linha, 231, 10); //   Alfa //Cdigos das Ocorrncias p/ Retorno
                    break;
                case 'T':
                    $vlinha["agencia_conta"] = substr($linha, 18, 5); // Num
                    $vlinha["dv_agencia"] = substr($linha, 23, 1); // Num
                    $vlinha["numero_conta"] = substr($linha, 24, 12); // Num
                    $vlinha["dv_conta"] = substr($linha, 36, 1); // Num
                    $vlinha["dv_agencia_conta"] = substr($linha, 37, 1); // Num
                    $vlinha["nosso_numero"] = substr($linha, 38, 20); // Alfa
                    $vlinha["carteira"] = substr($linha, 58, 1); // Num
                    $vlinha["numero_documento"] = substr($linha, 59, 15); // Alfa
                    $vlinha["vencimento"] = substr($linha, 74, 8); // Num
                    $vlinha["valor_titulo"] = substr($linha, 82, 15); // Num
                    $vlinha["numero_banco"] = substr($linha, 97, 3); // Num
                    $vlinha["agencia_cobradora"] = substr($linha, 100, 5); // Num
                    $vlinha["dv_agencia_cobrad"] = substr($linha, 105, 1); // Num
                    $vlinha["titulo_empresa"] = substr($linha, 106, 25); // Alfa
                    $vlinha["cod_moeda"] = substr($linha, 131, 2); // Num
                    $vlinha["inscricao_sacado"] = substr($linha, 133, 16); // Num
                    $vlinha["sacado"] = substr($linha, 149, 40); // Alfa
                    $vlinha["numero_contrato"] = substr($linha, 189, 10); // Num
                    $vlinha["valor_tarifa"] = substr($linha, 199, 15); // Num
                    $vlinha["ocorrencias"] = substr($linha, 214, 10); // Alfa
                    $vlinha["cnab"] = substr($linha, 224, 17); // Alfa
                    break;
                case 'U':
                    $vlinha["acrescimos"] = substr($linha, 18, 15); // Num
                    $vlinha["desconto"] = substr($linha, 33, 15); // Num
                    $vlinha["abatimento"] = substr($linha, 48, 15); // Num
                    $vlinha["IOF"] = substr($linha, 63, 15); // Num
                    $vlinha["valor_pago"] = substr($linha, 78, 15); // Num
                    $vlinha["valor_liquido"] = substr($linha, 93, 15); // Num
                    $vlinha["outras_despesas"] = substr($linha, 108, 15); // Num
                    $vlinha["outros_creditos"] = substr($linha, 123, 15); // Num
                    $vlinha["data_ocorrencia"] = substr($linha, 138, 8); // Num
                    $vlinha["data_credito"] = substr($linha, 146, 8); // Num
                    $vlinha["ocorrencia_sacado"] = substr($linha, 154, 4); // Alfa
                    $vlinha["data_ocorrencia_sac"] = substr($linha, 158, 8); // Alfa
                    $vlinha["valor_ocorrencia_sac"] = substr($linha, 166, 15); // Num
                    $vlinha["compl_ocorrencia_sac"] = substr($linha, 181, 30); // Alfa
                    $vlinha["banco_compensacao"] = substr($linha, 211, 3); // Num
                    $vlinha["nosso_numero_comp"] = substr($linha, 214, 20); // Num
                    $vlinha["cnab"] = substr($linha, 234, 7); // Alfa
                    break;
            }
        }
        return $vlinha;
    }

    protected function processarLinhaTrailer($linha) {
        $vlinha = array();
        if ($this->tamanho_linha == 400) {
            //X = ALFANUMRICO 9 = NUMRICO V = VRGULA DECIMAL ASSUMIDA
            $vlinha["id_registro"] = substr($linha, 1, 1); //9  Identificao do Registro Trailer: ?9?
            $vlinha["2"] = substr($linha, 2, 1); //9  ?2?
            $vlinha["01"] = substr($linha, 3, 2); //9  ?01?
            $vlinha["001"] = substr($linha, 5, 3); //9  ?001?
            $vlinha["brancos"] = substr($linha, 8, 10); //X  Brancos
            $vlinha["cob_simples_qtd_titulos"] = substr($linha, 18, 8); //9  Cobrana Simples - quantidade de ttulos
            $vlinha["cob_simples_vlr_total"] = $this->formataNumero(substr($linha, 26, 14)); //9  v99 Cobrana Simples - valor total
            $vlinha["cob_simples_num_aviso"] = substr($linha, 40, 8); //9  Cobrana Simples - Nmero do aviso
            $vlinha["brancos2"] = substr($linha, 48, 10);
            $vlinha["cob_qtd_registros"] = substr($linha, 58, 5);
            $vlinha["cob_vlr_registros"] = $this->formataNumero(substr($linha, 63, 12));
            $vlinha["cob_vlr_registros2"] = $this->formataNumero(substr($linha, 75, 12));
            $vlinha["cob_qtd_registros2"] = substr($linha, 87, 5);
            $vlinha["cob_vlr_registros3"] = $this->formataNumero(substr($linha, 92, 12));
            $vlinha["cob_qtd_registros3"] = substr($linha, 104, 5);
            $vlinha["cob_vlr_registros4"] = $this->formataNumero(substr($linha, 109, 12));
            $vlinha["cob_qtd_registros4"] = substr($linha, 121, 5);
            $vlinha["cob_vlr_registros5"] = $this->formataNumero(substr($linha, 126, 12));
            $vlinha["cob_qtd_registros5"] = substr($linha, 138, 5);
            $vlinha["cob_vlr_registros6"] = $this->formataNumero(substr($linha, 143, 12));
            $vlinha["cob_qtd_registros6"] = substr($linha, 155, 5);
            $vlinha["cob_vlr_registros7"] = $this->formataNumero(substr($linha, 160, 12));
            $vlinha["cob_qtd_registros7"] = substr($linha, 172, 5);
            $vlinha["cob_vlr_registros8"] = $this->formataNumero(substr($linha, 177, 12));
            $vlinha["brancos3"] = substr($linha, 189, 174);
            $vlinha["valor_total_rateio"] = $this->formataNumero(substr($linha, 363, 15));
            $vlinha["qtd_rateios"] = $this->formataNumero(substr($linha, 378, 8));
            $vlinha["brancos4"] = substr($linha, 386, 9);
            $vlinha["sequencial"] = substr($linha, 395, 6); //9  Seqencial do registro
        } elseif ($this->tamanho_linha == 240) {
            $vlinha["banco"] = substr($linha, 1, 3); //numerico  //Cdigo do Banco na Compensao
            $vlinha["lote"] = substr($linha, 4, 4); // num - default 9999  //Lote de Servio
            $vlinha["registro"] = substr($linha, 8, 1); //num - default 9   //Tipo de Registro
            $vlinha["cnab1"] = substr($linha, 9, 9); //alpha - default brancos //Uso Exclusivo FEBRABAN/CNAB
            $vlinha["quant_lotes"] = substr($linha, 18, 6); //num. //Quantidade de Lotes do Arquivo
            $vlinha["quant_regs"] = substr($linha, 24, 6); //num. //Quantidade de Registros do Arquivo
            $vlinha["quant_contas_conc"] = substr($linha, 30, 6); //num. //Qtde de Contas p/ Conc. (Lotes)
            $vlinha["cnab2"] = substr($linha, 36, 205); //alpha - default brancos  //Uso Exclusivo FEBRABAN/CNAB
        }
        return $vlinha;
    }

    protected function processarLinhaTrailerLote($linha) {
        $vlinha = array();
        $vlinha["banco"] = substr($linha, 1, 3); //numerico  //Cdigo do Banco na Compensao
        $vlinha["lote"] = substr($linha, 4, 4); //numerico //Lote de Servio
        $vlinha["registro"] = substr($linha, 8, 1); //num - default 5 //Tipo de Registro
        $vlinha["cnab1"] = substr($linha, 9, 9); //alfa - default brancos Uso Exclusivo FEBRABAN/CNAB
        $vlinha["quant_regs"] = substr($linha, 18, 6); //numerico //Quantidade de Registros do Lote
        $vlinha["valor"] = substr($linha, 24, 16); //numerico, 2 casas decimais  //Somatria dos Valores
        $vlinha["quant_moedas"] = substr($linha, 42, 13); //numerico, 5 casas decimais  //Somatria de Quantidade de Moedas
        $vlinha["num_aviso_debito"] = substr($linha, 60, 6); //numerico //Nmero Aviso de Dbito
        $vlinha["cnab2"] = substr($linha, 66, 165); //alfa, default brancos //Uso Exclusivo FEBRABAN/CNAB
        $vlinha["ocorrencias"] = substr($linha, 231, 10); //alfa  //Cdigos das Ocorrncias para Retorno
        return $vlinha;
    }

    /**
     * Formata uma string, contendo um valor real (float) sem o separador de decimais,
     * para a sua correta representao real.
     * 
     * @param string $valor String contendo o valor na representao usada nos arquivos
     * de retorno do banco, sem o separador de decimais.
     * @param int $numCasasDecimais Total de casas decimais do nmero representado
     * em $valor.
     * @author Manoel Campos da Silva Filho.
     * @return float Retorna o nmero representado em $valor, no seu formato float,
     * contendo o separador de decimais.
     */
    protected function formataNumero($valor, $numCasasDecimais=2) {
        if ($valor == "")
            return 0;

        $casas = $numCasasDecimais;
        if ($casas > 0) {
            $valor = substr($valor, 0, strlen($valor) - $casas) . "." . substr($valor, strlen($valor) - $casas, $casas);
            $valor = (float) $valor;
        } else
            $valor = (int) $valor;

        return $valor;
    }

    /**
     * Formata uma string, contendo uma data sem o separador, no formato DDMMAA,
     * para o formato DD/MM/AAAA.
     * 
     * @param string $data String contendo a data no formato DDMMAA.
     * @author Manoel Campos da Silva Filho.
     * @return string Retorna a data non formato DD/MM/AAAA.
     */
    protected function formataData($data) {
        if ($data == "")
            return "";

        //formata a data par ao padro americano MM/DD/AA
        $data = substr($data, 2, 2) . "/" . substr($data, 0, 2) . "/" . substr($data, 4, 2);

        //formata a data, a partir do padro americano, para o padro DD/MM/AAAA
        return date("d/m/Y", strtotime($data));
    }

}

?>