<?php


/**
 * Classe responsvel por processar os retornos dos boletos bancarios seguindo o padrao CNAB400 ou CNAB240
 * e j executa a baixa das parcelas.
 * O padrao CNAB400 utilizado eh do Banco Bradesco. (Modificado em 03/12/2010)
 * Alguns metodos foram baseados no projeto retorno-boletophp de Manoel Campos da Silva Filho.
 *
 * @author Pablo de Oliveira Lima - 06/2010
 */
class RetornoBoletoTabela  extends Zend_Db_Table_Abstract
{
    protected $_name = TB_RETORNO_BOLETO;

    public static function findLista($post, $count = false)
    {
        $search = utf8_decode($_POST['search']['value']);

        $order = $_POST['order'];

        $array = array(
            0 => 'r.id_retorno_boleto',
            1 => 'r.nr_retorno',
            2 => 'r.dt_criacao',
            3 => 'r.dt_processamento',
            4 => 'r.nm_cliente',
            5 => 'r.ds_conta',
            6 => 'agr.descricao',
            7 => 'r.ds_arquivo'
        );

        if ($search) {
            $where = 'r.id_retorno_boleto LIKE "%' . $search . '%" ';
            $where .= 'or r.nr_retorno LIKE "%' . $search . '%" ';
            $where .= 'or DAY(r.dt_criacao) = "' . $search . '" ';
            $where .= 'or MONTH(r.dt_criacao) = "' . $search . '" ';
            $where .= 'or YEAR(r.dt_criacao) = "' . $search . '" ';
            $where .= 'or DAY(r.dt_processamento) = "' . $search . '" ';
            $where .= 'or MONTH(r.dt_processamento) = "' . $search . '" ';
            $where .= 'or YEAR(r.dt_processamento) = "' . $search . '" ';
            $where .= 'or r.nm_cliente LIKE "%' . $search . '%" ';
            $where .= 'or r.ds_conta LIKE "%' . $search . '%" ';
            $where .= 'or agr.descricao LIKE "%' . $search . '%" ';
            $where .= 'or r.ds_arquivo LIKE "%' . $search . '%" ';
        }

        $retorno = self::getDefaultAdapter()->select()
            ->from(array('r' => TB_RETORNO_BOLETO), '*')
            ->join(array('agr' => TB_AGRUPADA), 'agr.idCampo = r.cd_banco and agr.idTabela = "9"', array('descricao'));


        if (isset($where)) {
            $retorno = $retorno->where($where);
        }

        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $retorno = $retorno->limit($post['length'], $post['start']);
            }

        if($order){
            foreach ($order as $ord){
                $orderByQuery[] = $array[$ord['column']] . ' ' . $ord['dir'];
            }
            $retorno->order(implode(',', $orderByQuery));
        }
        $retorno = $retorno->query()->fetchAll();


        return $retorno;
    }

}

?>