<?php

class ReservaLote extends Zend_Db_Table_Abstract
{

    protected $_name = TB_RESERVA_LOTE;
    static $reservaLoteInstancia;

    //retorna uma instancia da classe
    public static function getInstance()
    {
        if (!self::$reservaLoteInstancia) {
            self::$reservaLoteInstancia = new ReservaLote();
        }
        return self::$reservaLoteInstancia;
    }

    //procura as reservas de lote por empreendimento
    public function findReservaEmpreendimento($id)
    {
        $reservasLote = $this::getInstance();
        $reservasLote = $reservasLote->getDefaultAdapter()->select()
            ->from(array('rl' => TB_RESERVA_LOTE))
            ->join(array('l' => TB_LOTES), 'rl.cod_lote = l.id AND rl.reservado = "1"', array('l.id', 'l.id_empreendimento'));
        if ($id) {
            $reservasLote->where('l.id_empreendimento = ?', $id);
        }
        $reservasLote = $reservasLote->query()->fetchAll();

        if ($reservasLote) {
            return $reservasLote;
        } else return null;
    }

    public static function findLista($post, $count = false)
    {
        $search = utf8_decode($_POST['search']['value']);
        $order = $_POST['order'];

        $array = array(
            0 => 'e.nm_empreendimento',
            1 => 'l.quadra',
            2 => 'l.lote',
            3 => 'rl.nome_pessoa',
            4 => 'crt.nm_pessoa'
        );

        if ($search) {
            $where = 'e.nm_empreendimento LIKE "%' . $search . '%" ';
            $where .= 'or l.quadra LIKE "%' . $search . '%" ';
            $where .= 'or l.lote LIKE "%' . $search . '%" ';
            $where .= 'or rl.nome_pessoa LIKE "%' . $search . '%" ';
            $where .= 'or crt.nm_pessoa LIKE "%' . $search . '%" ';
        }

        $itens = self::getDefaultAdapter()->select()
            ->from(array('l' => TB_LOTES), array('l.lote', 'l.quadra', 'l.id as id_lote'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', array('e.nm_empreendimento'))
            ->join(array('rl' => TB_RESERVA_LOTE), 'rl.cod_lote =  l.id', array('*'))
            ->join(array('crt' => TB_PESSOA), 'crt.id = rl.corretor', array('crt.nm_pessoa'));

        if ($post['aprovar'] == '1') {
            $itens = $itens->where('rl.reservado = 1');
        } elseif ($post['aprovar'] == '2') {
            $itens = $itens->where('rl.reservado = 0');
        }

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $itens->where("e.id IN({$id})");
                }
            } catch (Exception $e) {
            }
        }

        if (isset($where)) {
            $itens = $itens->where($where);
        }

        if(isset($post['empreendimento']) && $post['empreendimento'] != ''){
            $itens = $itens->where('e.id = ?',$post['empreendimento']);
        }

        if (isset($post['quadraLote']) && $post['quadraLote'] !='') {
            $itens = $itens->where('l.quadra = "' . $post['quadraLote'].'"');
        }

        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $itens = $itens->limit($post['length'], $post['start']);
            }

        foreach ($order as $ord) {
            $itens->order($array[$ord['column']] . ' ' . $ord['dir']);
        }

        $itens = $itens->query()->fetchAll();


        return $itens;
    }

    public static function findListaReservaTecnica($post, $count = false)
    {
        $search = utf8_decode($_POST['search']['value']);
        $order = $_POST['order'];

        $array = array(
            0 => 'e.nm_empreendimento',
            1 => 'l.quadra',
            2 => 'l.lote'
        );

        //Se for pesquisado pela palavra "reserva tecnica" retorna true
        $pesquisaPorReservaTecnica = preg_match('/' . str_replace('%', '.*?', '%'.strtoupper($search).'%') . '/', 'RESERVA TECNICA')>0;

        if ($search && !$pesquisaPorReservaTecnica) {
            $where = 'e.nm_empreendimento LIKE "%' . $search . '%" ';
            $where .= 'or l.quadra LIKE "%' . $search . '%" ';
            $where .= 'or l.lote LIKE "%' . $search . '%" ';
        }

        $itens = self::getDefaultAdapter()->select()
            ->from(array('l' => TB_LOTES), array('l.lote', 'l.quadra', 'l.reservado as reservaTecnica', 'l.id as id_lote', 'l.obs_reserva as obsReserva', 'l.data_reserva'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', array('e.nm_empreendimento'))
            ->where('e.id = '.$post['empreendimento']);
        
        if ($post['aprovar'] == '1') {
            $itens = $itens->where('l.reservado = "1"');
            $itens = $itens->where('l.obs_reserva is not null');
        } else if ($post['aprovar'] == '2') {
            $itens = $itens->where('l.reservado = "0"');
            $itens = $itens->where('l.obs_reserva is not null');
        } else {
            $itens = $itens->where('l.obs_reserva is not null');
        }
              
        if (isset($where)) {
            $itens = $itens->where($where);
        }

        if (isset($post['quadraLote']) && $post['quadraLote'] !='') {
            $itens = $itens->where('l.quadra = "' . $post['quadraLote'].'"');
        }

        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $itens = $itens->limit($post['length'], $post['start']);
            }

        foreach ($order as $ord) {
            if($array[$ord['column']])
                $itens->order($array[$ord['column']] . ' ' . $ord['dir']);
        }

        $itens = $itens->query()->fetchAll();

        return $itens;
    }

    public static function findListaReservaTecnicaFinal($post, $count = false)
    {
        $search = utf8_decode($_POST['search']['value']);
        $order = $_POST['order'];

        $array = array(
            0 => 'e.nm_empreendimento',
            1 => 'l.quadra',
            2 => 'l.lote'
        );

        //Se for pesquisado pela palavra "reserva tecnica" retorna true
        $pesquisaPorReservaTecnica = preg_match('/' . str_replace('%', '.*?', '%'.strtoupper($search).'%') . '/', 'RESERVA TECNICA')>0;

        if ($search && !$pesquisaPorReservaTecnica) {
            $where = 'e.nm_empreendimento LIKE "%' . $search . '%" ';
            $where .= 'or l.quadra LIKE "%' . $search . '%" ';
            $where .= 'or l.lote LIKE "%' . $search . '%" ';
        }

        $itens = self::getDefaultAdapter()->select()
            ->from(array('l' => TB_LOTES), array('l.lote', 'l.quadra', 'l.reservado as reservaTecnica', 'l.id as id_lote', 'l.obs_reserva as obsReserva', 'l.data_reserva'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', array('e.nm_empreendimento'))
            ->join(array('rl' => TB_RESERVA_LOTE), 'rl.cod_lote =  l.id', array('*'))
            ->where('rl.nome_pessoa IS NULL')
            ->where('e.id = '.$post['empreendimento']);
        
    
        if ($post['aprovar'] == '1') {
            $itens = $itens->where('rl.reservado = 1');
        } elseif ($post['aprovar'] == '2') {
            $itens = $itens->where('rl.reservado = 0');
        }
              
        if (isset($where)) {
            $itens = $itens->where($where);
        }

        if (isset($post['quadraLote']) && $post['quadraLote'] !='') {
            $itens = $itens->where('l.quadra = "' . $post['quadraLote'].'"');
        }

        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $itens = $itens->limit($post['length'], $post['start']);
            }

        foreach ($order as $ord) {
            if($array[$ord['column']])
                $itens->order($array[$ord['column']] . ' ' . $ord['dir']);
        }

        $itens = $itens->query()->fetchAll();

        return $itens;
    }
}

