<?php

class Representante extends Zend_Db_Table_Abstract
{

    protected $_name = TB_REPRESENTANTE;

    /**
     *
     * @param Db_Usuario $usuario
     * @return Array $id_empreencimento
     */
    public function listaEmpreendimentosRepresentante(Db_Usuario $usuario)
    {
        try {

            $selectRepresentantes = $this->getDefaultAdapter();
            $representantes = $selectRepresentantes->select()->from(array('r' => TB_REPRESENTANTE), array('r.id_pessoa_juridica'))
                ->where('id_pessoa = ?', $usuario->getId())
                ->query()->fetchAll();

            if (count($representantes)) {
                foreach ($representantes AS $representante) {
                    $repres[] = (INT)$representante['id_pessoa_juridica'];
                }
            }
            $repres[] = (INT)$usuario->getId();

            $bind = implode(',', $repres);
            $instanceParceria = new Parceria();
            $selectParceria = $instanceParceria->getDefaultAdapter();
            $ids_empreendimentos = $selectParceria->select()->distinct('id_empreendimento')->from(TB_PARCERIA, 'id_empreendimento')->where("id_pessoa IN({$bind})")->query()->fetchAll();

            if (count($ids_empreendimentos)) {
                foreach ($ids_empreendimentos AS $id_empreendimento) {
                    $id[] = (int)$id_empreendimento['id_empreendimento'];
                }
            }
        } catch (Exception $e) {

        }

        return $id;
    }

    public function listaRepresentantesDaPessoaJuridica($idPessoaJuridica)
    {

        $selectRepresentantes = $this->getDefaultAdapter();
        $idsRepresentantes = $selectRepresentantes->select()->from(array('r' => TB_REPRESENTANTE), array('r.id_pessoa'))
            ->where('id_pessoa_juridica = ?', $idPessoaJuridica)
            ->query()->fetchAll();

        $representantes = array();
        if (is_array($idsRepresentantes)) {
            $pessoaFisica = new Pessoa_Fisica();
            $pessoaJuridica = new Pessoa_Juridica();
            $pessoa = new Pessoa();
            foreach ($idsRepresentantes AS $idR) {
                $p = $pessoa->fetchRow('id = ' . $idR['id_pessoa']);
                if ($p->tp_pessoa == 'F') {
                    $pf = $pessoaFisica->findDadosPessoaFisica($idR['id_pessoa']);
                    switch ($pf['est_civil']) {
                        case 'CAS':
                            $pf['est_civil'] = 'Casado';
                            break;
                        case 'DIV':
                            $pf['est_civil'] = 'Divorciado';
                            break;
                        case 'SEP':
                            $pf['est_civil'] = 'Separado';
                            break;
                        case 'SOL':
                            $pf['est_civil'] = 'Solteiro';
                            break;
                        case 'VIU':
                            $pf['est_civil'] = 'Vivo';
                            break;
                    }
                    $pf['cidade'] = ($cidade = Db_Cidade::find($pf['cd_cidade'])) ? $cidade->toArray() : array();
                    $representantes[] = $pf;
                } else {
                    $pj = $pessoaJuridica->findPessoaJuridica($idR['id_pessoa']);
                    $pj['cidade'] = ($cidade = Db_Cidade::find($pj['cd_cidade'])) ? $cidade->toArray() : array();
                    $representantes[] = $pj;
                }
            }
        }

        return $representantes;
    }

    public static function findByJuridica($idPessoa)
    {
        $representantes = self::getDefaultAdapter()->select()
            ->from(array('r' => TB_REPRESENTANTE), array())
            ->join(array('p' => TB_PESSOA), 'p.id = r.id_pessoa', array('*'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', array('*'))
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'p.id = pj.id_pessoa', array('*'))
            ->where('id_pessoa_juridica = ?', $idPessoa)
            ->query()->fetchAll();

        return $representantes;
    }

}

