<?php
class Report {
    private $_header;
    private $_itens;
    private $_tableInit;

    const CSS_ITENS = 0;
    const CSS_HEADER = 1;

    public function  __construct(array $properties = array()) {
        $settings = array();
        foreach ($properties as $prop => $value) {
            $settings[] = $prop.'="'.$value.'"';
        }
        $settings = ' '.implode(' ', $settings);
        $this->_tableInit = "<table{$settings}>";
    }

    /**
     * As chaves do array deve ser o mesmo nome da coluna dos itens que sero
     * mostrados e como valor as formataes que devero ter no header do relatrio
     * existe tambm um propriedade especfica label ser o rtulo dos campos no
     * relatrio.
     * @param array $header
     * @return Report;
     */
    public function setHeader(array $header) {
        $this->_header = $header;
        return $this;
    }

    /**
     * @param array $itens
     * @return Report;
     */
    public function setItens(array $itens) {
        $this->_itens = $itens;
        return $this;
    }

    /**
     *
     * @param mixed $key
     * @param CSS_ITENS, CSS_HEADER
     * @return string
     */
    private function getCssProperties($key , $element) {
        $styles = array();
        $properties = $this->_header[$key];
        foreach ($properties as $prop => $value) {
            if($element == self::CSS_ITENS ) {
                if($prop[0] != '_') {
                    $styles[] = "{$prop}:{$value}";
                }
            }elseif($element == self::CSS_HEADER) {
                if($prop != '_label') {
                    $prop = str_replace('_', '', $prop);
                    $styles[] = "{$prop}:{$value}";
                }
            }

        }
        return implode(';', $styles);
    }

    /**
     * @return string
     */
    public function run() {
        $header = $this->_header;
        $itens  = $this->_itens;
        $html  = $this->_tableInit;
        $html .= '<tr>';
        foreach($header as $key => $value) {
            $style = $this->getCssProperties($key, self::CSS_HEADER);
            if(!empty($style))
                $style = ' style="'.$style;
            $style .= ';background-color:#B8B8B8"';
            $html .= '<td'.$style.'>' . $value['_label'] .'</td>';
        }
        $html .= '</tr>';
        foreach($itens as $k => $item) {
            $html .= '<tr>';
            foreach($header as $key => $value) {
                $style = $this->getCssProperties($key, self::CSS_ITENS);
                if(!empty($style))
                    $style = ' style="'.$style;
                if($k%2)
                    $style .= ';background-color:#CCCCCC';
                $style.= '"';
                $html .= '<td'.$style.'>' . $item[$key] .'</td>';
            }
            $html .= '</tr>';
        }
        $html .= '</table>';
        return $html;
    }

}