<?php

/*
 * @descr: Gera o arquivo de remessa para cobranca no padrao CNAB 240 vers. 1.0 - Santander
 * Autor : Magno Skywalker
 */

class RemessaSantanderPR extends Zend_Db_Table_Abstract
{

    protected $_name = TB_REMESSA_INSTRUCAO;

    /**
     * Limita e trata as palavras e numeros para o formato dos campos
     * @param $palavra
     * @param $limite
     * @param string $comp
     * @return string
     */
    private static function limit($palavra, $limite, $comp = 'brancos', $antecede = false)
    {
        $var = '';
        $palavra = strtoupper(self::retirar_caracteres_especiais($palavra, false));
        if (strlen($palavra) >= $limite) {
            $var = substr($palavra, 0, $limite);
        } else {
            $max = (int)($limite - strlen($palavra));
            if ($comp == 'brancos') {
                if ($antecede) {
                    $var = self::complementoRegistro($max, "brancos") . $palavra;
                } else {
                    $var = $palavra . self::complementoRegistro($max, "brancos");
                }
            } elseif ($comp == 'zeros') {
                $var = self::complementoRegistro($max, "zeros") . $palavra;
            }
        }
        return $var;
    }

    public static function modulo_10($num)
    {
        $numtotal10 = 0;
        $fator = 2;

        // Separacao dos numeros
        for ($i = strlen($num); $i > 0; $i--) {
            // pega cada numero isoladamente
            $numeros[$i] = substr($num, $i - 1, 1);
            // Efetua multiplicacao do numero pelo (falor 10)
            // 2002-07-07 01:33:34 Macete para adequar ao Mod10 do Ita?
            $temp = $numeros[$i] * $fator;
            $temp0 = 0;
            foreach (preg_split('//', $temp, -1, PREG_SPLIT_NO_EMPTY) as $k => $v) {
                $temp0 += $v;
            }
            $parcial10[$i] = $temp0; //$numeros[$i] * $fator;
            // monta sequencia para soma dos digitos no (modulo 10)
            $numtotal10 += $parcial10[$i];
            if ($fator == 2) {
                $fator = 1;
            } else {
                $fator = 2; // intercala fator de multiplicacao (modulo 10)
            }
        }

        // v?rias linhas removidas, vide fun??o original
        // Calculo do modulo 10
        $resto = $numtotal10 % 10;
        $digito = 10 - $resto;
        if ($resto == 0) {
            $digito = 0;
        }

        return $digito;

    }

    public static function modulo_11($num, $base = 9, $r = 0)
    {
        $soma = 0;
        $fator = 2;

        /* Separacao dos numeros */
        for ($i = strlen($num); $i > 0; $i--) {
            // pega cada numero isoladamente
            $numeros[$i] = substr($num, $i - 1, 1);
            // Efetua multiplicacao do numero pelo falor
            $parcial[$i] = $numeros[$i] * $fator;
            // Soma dos digitos
            $soma += $parcial[$i];
            if ($fator == $base) {
                // restaura fator de multiplicacao para 2
                $fator = 1;
            }
            $fator++;
        }

        /* Calculo do modulo 11 */
        if ($r == 0) {
            $soma *= 10;
            $digito = $soma % 11;
            if ($digito == 10) {
                $digito = 0;
            }
            return $digito;
        } elseif ($r == 1) {
            $resto = $soma % 11;
            return $resto;
        }
    }

    /**
     * Transforma o int do sequencial para o padrao febraban
     * @param $i
     * @param $length
     * @return string
     */
    private static function sequencial($i, $length)
    {
        return str_pad($i, $length, 0, STR_PAD_LEFT);
    }

    /**
     * Complementa os registros de acordo com as normas do febraban
     * @param $int
     * @param $tipo ('zeros','brancos')
     * @return string
     */
    private static function complementoRegistro($int, $tipo)
    {
        $space = '';
        if ($tipo == "zeros") {
            for ($i = 1; $i <= $int; $i++) {
                $space .= '0';
            }
        } else if ($tipo == "brancos") {
            for ($i = 1; $i <= $int; $i++) {
                $space .= ' ';
            }
        }
        return $space;
    }

    /**
     * Remove os caracteres especiais de uma string
     * @param $string
     * @return mixed
     */
    private static function retirar_caracteres_especiais($string)
    {
        $palavra = Helper::removeAcentos($string);
        $palavranova = str_replace("_", " ", $palavra);
        $palavranova = str_replace(array("-", ",", "."), "", $palavranova);
        return $palavranova;
    }

    /**
     * Gera o nosso n?mero de acordo com o banco
     * @param $banco
     * @param $parcela
     * @return string
     */
    private static function geraNossoNumero($banco, $parcela)
    {
        $nossoNumero = str_pad($parcela['id_parcela_contrato'], 12, '0', STR_PAD_LEFT);
        $nossoNumero .= self::modulo_11($nossoNumero);
        return $nossoNumero;
    }

    //Altera o versionamento do arquivo de acordo com o banco utilizado
    private static function versionamentoLayout($banco)
    {
        $versaoH = '040';
        $versaoL = '030';

        return array('header' => $versaoH, 'lote' => $versaoL);
    }

    /**
     * Verifica os codigos de carteira para os bancos especificamente
     * @return string
     */
    private static function verificaCodigoCarteira()
    {
        $codCarteira = '5';

        return $codCarteira;
    }

    /**
     * Gera arquivo remessa para inclus?o sem gravar registro no banco de dados
     * @param $parcelas
     * @param string $codMovimento
     * @return mixed
     */
    public static function geraRemessa($dados, $nmArquivo)
    {
        $contratos = $dados['contratos'];
        if (count($contratos) == 0)
            return false;

        //Cria os diretorios para onde o arquivo vai ser gravado
        $path = explode('.', $_SERVER['HTTP_HOST']);
        if ($path[0] == 'www') {
            $path = $path[1];
        } else {
            $path = $path[0];
        }
        $filename = $nmArquivo;
        $filepath = DIRETORIO_DOWNLOAD . "remessas/" . $path;
        $pathAno = DIRETORIO_DOWNLOAD . "remessas/" . $path . '/' . date('Y');

        if (is_dir($filepath)) {
            if (!is_dir($pathAno)) mkdir($pathAno);
        } else {
            mkdir($filepath);
            mkdir($pathAno);
        }

        //Grava o conteudo dos registro no corpo do arquivo a ser gerado
        $conteudo = self::gerarHeader($dados);

        $nrLote = 0;
        $nrRegistros = 0;
        foreach ($contratos as $idContrato) {
            $nrLote++;
            $parcelas = $idContrato['parcelas'];

            //Busca parcelas que j? foram criadas e n?o foram enviadas
            $idsParcela = array();
            foreach ($parcelas as $k => $parcela) {
                if ($parcela['id_remessa'])
                    unset($parcelas[$k]);
                else
                    $idsParcela[] = $parcela['id_parcela_contrato'];
            }

            $conteudo .= self::gerarDetalhe('01', $dados, $parcelas, $nrLote, $idContrato['id']);

            //Atualiza contadores de registros e lotes
            $nrRegistros += (count($idsParcela) * 3) + 2;
        }

        $conteudo .= self::gerarTrailer($dados['cdBanco'], $nrLote, $nrRegistros);

        if (!$handle = fopen($pathAno . '/' . $filename, 'w+')) {
            $msg = "N?o foi poss?vel abrir o arquivo ($filename)";
            $erro = true;
        } // Escreve $conteudo no nosso arquivo aberto.
        elseif (fwrite($handle, "$conteudo") === FALSE) {
            $msg = "N?o foi poss?vel escrever no arquivo ($filename)";
            $erro = true;
        } else {
            $msg = "Arquivo de remessa gerado com sucesso!";
            $erro = false;
        }
        fclose($handle);

        $retorno[0] = $conteudo;
        $retorno[1] = $erro;
        $retorno[2] = $msg;

        return $retorno;
    }

    /**
     * Gera o Header do arquivo utilizando os dados da tabela remessa instrucao
     * @param $emp
     * @return string
     */
    public static function gerarHeader($emp)
    {
        $cdBanco = $emp['cdBanco'];
        $cnpjCpfCedente = ($emp["cnpj_cedente"])?$emp["cnpj_cedente"]:$emp["cpf_cedente"];
        $codEmpresa = str_replace(array(".", "/", "-"), "", $cnpjCpfCedente);
        $empresa = strtoupper(self::retirar_caracteres_especiais($emp["nm_cedente"]));
        $nmBanco = strtoupper(Banco::findBancoNome($cdBanco));
        $nrRemessa = $emp['idRemessa'];

        $conteudo = '';

        ##  HEADER DO ARQUIVO
        #   NOME DO CAMPO           #SIGNIFICADO                               #POSICAO       #PICTURE
        $conteudo .= $cdBanco;                                                  //01  Codigo do banco    santander 033 ou 353         001 003        9(03)
        $conteudo .= '0000';                                                    //02  Lote de servi?o                                 004 007        9(04)
        $conteudo .= '0';                                                       //03  Registro do header                              008 008        9(01)
        $conteudo .= self::complementoRegistro(8, "brancos");                   //04  Uso exclusivo do banco                          009 016        9(08)
        $conteudo .= '2';                                                       //05  Tipo de inscricao da construtora  1-cpf/2-cnpj  017 017        9(01)
        $conteudo .= self::limit($codEmpresa, 15, "zeros");                     //06  Numero de inscri?ao da construtora              018 032        9(15)
        $conteudo .= self::limit($emp['agencia'], 4, "zeros");                  //07  Cod. de Transmissao (Agencia)                   033 036        9(04)
        $conteudo .= self::limit($emp['cd_cedente'], 11, "zeros");              //07  Cod. de Transmissao (Codigo do cedente)         037 047        9(11)
        $conteudo .= self::complementoRegistro(25, "brancos");                  //08  Uso exclusivo do santander                      048 072        9(25)
        $conteudo .= self::limit($empresa, 30);                                 //09  Nome da construtora                             073 102        9(30)
        $conteudo .= self::limit($nmBanco, 30);                                 //10  Nome do banco                                   103 132        X(30)
        $conteudo .= self::complementoRegistro(10, "brancos");                  //11  Uso exclusivo da caixa                          133 142        9(10)
        $conteudo .= '1';                                                       //12  Codigo 1 = remessa; 2 = retorno                 143 143        9(01)
        $conteudo .= date("dmY");                                               //13  Data de gera?o                                  144 151        9(08)
        $conteudo .= self::complementoRegistro(6, "brancos");                   //14  Uso do fenabran                                 232 239        9(08)
        $conteudo .= self::limit($nrRemessa, 6, "zeros");                       //15  Numero sequencial do arquivo                    158 163        9(06)
        $conteudo .= self::versionamentoLayout($cdBanco)['header'];             //16  Layout do arquivo                               164 166        9(03)
        $conteudo .= self::complementoRegistro(74, "brancos");                  //17  Uso do fenabran                                 232 239        9(08)
        $conteudo .= chr(13) . chr(10);                                         // quebra de linha

        return $conteudo;
    }

    /**
     * Gera o Trailer do arquivo
     * @param $cdBanco
     * @param $nrLote
     * @param $nrRegistros
     * @return string
     */
    public static function gerarTrailer($cdBanco, $nrLote, $nrRegistros)
    {
        ##  REGISTRO TRAILER DO ARQUIVO
        #   NOME DO CAMPO                                                                       #SIGNIFICADO                                           #POSICAO    #TAMANHO
        $conteudo = $cdBanco;                                                                   //  Codigo do Banco para compensa??o (104 = CAIXA)      001 003     9(03)
        $conteudo .= "9999";                                                                    //  Lote de servi?o (9999 = trailer do arquivo)         004 007     9(04)
        $conteudo .= "9";                                                                       //  tipo registro (9 = trailer)                         008 008     9(01)
        $conteudo .= self::complementoRegistro(9, "brancos");                                   //  USO FEBRABAN                                        009 017     X(06)
        $conteudo .= self::limit($nrLote, 6, "zeros");                                          //  Quantidade de lotes                                 018 023     X(06)
        $conteudo .= self::limit($nrRegistros + 2, 6, "zeros");                                 //  Quantidade de Registros                             024 029     X(06)
        $conteudo .= self::complementoRegistro(211, "brancos");                                 //  USO FEBRABAN                                        030 240     X(211)
        $conteudo .= chr(13) . chr(10);                                                         //  quebra de linha

        return $conteudo;
    }

    /**
     * * Fun??o que gera o registro detalhe utilizando os dados de empreendimento e dos contratos e parcelas
     * @param array $emp
     * @param array $dados
     * @param int $nrArquivo
     * @return mixed
     */
    public static function gerarDetalhe($codMovimento, $emp, $parcelas, $nrArquivo, $idContrato)
    {
        $contrato = Contrato::findContratoById($idContrato);

        //Verifica se existem parcelas e contrato
        if (count($parcelas) == 0 || !$contrato)
            return false;

        //Dados para gera??o
        $registro = '1';
        $empresa = strtoupper(self::retirar_caracteres_especiais($emp["nm_cedente"]));
        $cnpjCpfCedente = ($emp["cnpj_cedente"])?$emp["cnpj_cedente"]:$emp["cpf_cedente"];
        $codEmpresa = str_replace(array(".", "/", "-"), "", $cnpjCpfCedente);
        $cpfCnpj = (in_array($contrato["tp_pessoa"], array('F', 'C'))) ? str_replace(array(".", "/", "-"), "", $contrato["nr_cpf"]) : str_replace(array(".", "/", "-"), "", $contrato["nr_cnpj"]);
        $tipoRegistro = ($contrato["tp_pessoa"] == 'F') ? '1' : '2';
        $codCarteira = self::verificaCodigoCarteira();
        $dtContrato = str_replace("/", "", Helper::getDate($contrato["dt_contrato"]));

        ##  HEADER DO LOTE (OBRIGATORIO) - REGISTRO 1
        #  NOME DO CAMPO                                                                #SIGNIFICADO                                            #POSICAO    #TAMANHO
        $conteudo = $emp['cd_banco'];                                                   //  Codigo banco                                        001 003     9(03)
        $conteudo .= self::sequencial($nrArquivo, 4);                                   //  Lote                   Lote de servico              004 007     9(04)
        $conteudo .= '1';                                                               //  Registro header do lote                             008 008     9(01)
        $conteudo .= 'R';                                                               //  Tipo de operao                                  009 009     X(01)
        $conteudo .= '01';                                                              //  Tipo de servio                                    010 011     9(02)
        $conteudo .= '  ';                                                              //  Forma de Lanamento                                012 013     9(02)
        $conteudo .= self::versionamentoLayout($emp['cd_banco'])['lote'];               //  numero da vers?o do layout do lote                  014 016     9(03)
        $conteudo .= ' ';                                                               //  Uso exclusivo do Banco                              017 017     X(01)
        $conteudo .= '2';                                                               //  Tipo de inscrio do empreendimento 2 = CNPJ; 1 = CPF     018 018     9(01)
        $conteudo .= self::limit($codEmpresa, 15, "zeros");                             //  numero da inscri??o da empresa                      019 033     9(15)
        $conteudo .= self::complementoRegistro(20, "brancos");                          //  Uso exclusivo da caixa                              034 053     9(20)
        $conteudo .= self::limit($emp['agencia'], 4, "zeros");                          //  Cod. de Transmissao (Agencia)                       054 057     9(04)
        $conteudo .= self::limit($emp['cd_cedente'], 11, "zeros");                      //  Cod. de Transmissao (C?digo do cedente)             058 068     9(11)
        $conteudo .= self::complementoRegistro(5, "brancos");                           //  Reservado ao Banco                                  069 073     9(05)
        $conteudo .= self::limit($empresa, 30, "brancos");                              //  Nome da empresa                                     074 103     9(30)
        //Dados da mensagem de impress?o (dados do loteamento)
        $conteudo .= self::limit(Helper::tirarAcentos($emp['msg_boleto']), 40);         //  Mensagem do boleto                                  104-143     9(40)
        $conteudo .= self::limit(Helper::tirarAcentos($emp['msg_adicional']), 40);      //  Mensagem adicional do boleto                        144-183     9(40)
        $conteudo .= self::limit($emp['idRemessa'], 8, "zeros");                        //  N?mero de remessa (sequencial)                      184 191     9(08)
        $conteudo .= date("dmY");                                                       //  Data de grava?ao da remessa                         192 199     9(08)
        $conteudo .= self::complementoRegistro(41, "brancos");                          //  Uso exclusivo do Banco                              200 240     9(41)
        $conteudo .= chr(13) . chr(10);

        $vl_total = 0.00;
        $sequencial = 1;
        foreach ($parcelas as $k => $parcela) {
            $vl_parcela = str_pad(str_replace(array(".", ","), "", number_format($parcela["vl_parcela"], 2)), 15, '0', STR_PAD_LEFT);

            if ($emp["tp_juros"] != 'S') {
                $juros = ($emp["tp_juros"] == 'P') ? (float)$emp["juros"] * (float)$parcela["vl_parcela"] / 100 : $emp["juros"];
            } else {
                $juros = 0;
            }
            $juros = str_replace(array(".", ","), "", number_format($juros, 2));
            $multa = str_replace(array(".", ","), "", number_format($emp["multa"], 2));

            $desconto = str_replace(array(".", ","), "", number_format($parcela["desconto"], 2));
            $vl_total += $parcela["vl_total_pago"];
            $nossoNumero = self::geraNossoNumero($emp['cd_banco'], $parcela);
            $dias_permanencia = (isset($emp['qt_dias_permanencia']) && (int)$emp['qt_dias_permanencia'] > 5) ? $emp['qt_dias_permanencia'] : 90;

            $contrato['tp_parcela'] = $parcela['tp_parcela'];
            $contrato['dt_parcela'] = $parcela['dt_parcela'];

            $descontoParcela = Parcela::getDescontoParcela($contrato, $parcela['vl_parcela']);
            $vlDesconto = str_pad(str_replace(array(".", ","), "", number_format($descontoParcela['vlDesconto'], 2)), 15, '0', STR_PAD_LEFT);

            ## SEGMENTO P (OBRIGATORIO)                                                 ##  NOME DO CAMPO                                       POSICAO    TAMANHO
            $conteudo .= $emp['cd_banco'];                                              //  C?digo do banco                                     001 003     9(03)
            $conteudo .= self::sequencial($nrArquivo, 4);                               //  Lote do servico                                     004 007     9(04)
            $conteudo .= '3';                                                           //  Registro detalhe                                    008 008     9(01)
            $conteudo .= self::sequencial($sequencial, 5);                              //  Numero sequencial do registro no lote               009 013     9(05)
            $conteudo .= 'P';                                                           //  Codigo do segmento                                  014 014     X(01)
            $conteudo .= ' ';                                                           //  Uso do banco                                        015 015     X(01)
            $conteudo .= self::limit($codMovimento, 2, "zeros");                        //  C?digo de movimenta??o (Informado ao chamar fun??o) 016 017     9(02)
            $conteudo .= self::limit($emp["agencia"], 4, "zeros");                      //  Agencia                                             018 021     9(04)
            $conteudo .= self::limit($emp["agencia_dv"], 1, "zeros");                   //  Dv da agencia                                       022 022     9(01)
            $conteudo .= self::limit($emp['conta_corrente'], 9, "zeros");               //  Conta corrente                                      023 031     9(09)
            $conteudo .= self::limit($emp['conta_corrente_dv'], 1, "zeros");            //  D?gito verificador da Conta corrente                032 032     9(01)
            $conteudo .= self::limit($emp['conta_corrente'], 9, "zeros");               //  Conta cobran?a                                      033 041     9(09)
            $conteudo .= self::limit($emp['conta_corrente_dv'], 1, "zeros");            //  D?gito verificador da Conta cobran?a                042 042     9(01)
            $conteudo .= self::complementoRegistro(2, "brancos");                       //  Reservado pelo banco (padr?o brancos)               043 044     X(02)
            $conteudo .= self::limit($nossoNumero, 13, "zeros");                        //  Identific. do titulo no banco                       045 057     9(13)
            $conteudo .= $codCarteira;                                                  //  Cd da carteira 1= cob. simples. 2= cob. caucionada  058 058     9(01)
            $conteudo .= $registro;                                                     //  Forma de cadastramento do titulo no banco           059 059     9(01)
            $conteudo .= '2';                                                           //  Tipo de documento                                   060 060     9(01)
            $conteudo .= ' ';                                                           //  Reservado (uso Banco)                               061 061     9(01)
            $conteudo .= ' ';                                                           //  Reservado (uso Banco)                               062 062     9(01)
            $conteudo .= self::limit($parcela["id_parcela_contrato"], 15, "zeros");     //  Numero do documento de cobranca                     063 077     9(15)
            $conteudo .= date("dmY", strtotime($parcela["dt_parcela"]));                //  Vencimento da prestacao                             078 085     9(08)
            $conteudo .= $vl_parcela;                                                   //  Valor da prestacao                                  086 100     9(15)
            $conteudo .= self::limit($emp['agencia'], 4, "zeros");                      //  Ag?ncia encarregada da cobran?a FIDC                101 104     9(04)
            $conteudo .= self::limit($emp["agencia_dv"], 1, "zeros");                   //  D?gito da Ag?ncia do Benefici?rio FIDC              105 105     9(01)
            $conteudo .= self::complementoRegistro(1, "brancos");                       //  Reservado (uso Banco)                               106 106     9(01)
            $conteudo .= "02";                                                          //  Especie do titulo (99 = outros)                     107 108     9(02)
            $conteudo .= "N";                                                           //  Aceite A = Aceite N = Nao aceite                    109 109     X(01)
            $conteudo .= date("dmY");                                                   //  Data da emissao da parcela                          110 117     9(08)
            $conteudo .= ($juros == 0) ? "3" : "1";                                     //  Codigo do juros/mora (1 = di?rio)                   118 118     9(01)
            $conteudo .= date("dmY", strtotime($parcela["dt_parcela"]));                //  Data do juros. branco = data vencimento             119 126     9(08)
            $conteudo .= self::limit($juros, 15, "zeros");                              //  Juros por dia                                       127 141     9(13)
           if ($descontoParcela['flDesconto'] == 'V') {
               $conteudo .= "1";                                                       //  Codigo do desconto. 1 = valor 2 = percentual        142 142     9(01)
               $conteudo .= date("dmY", strtotime($parcela["dt_parcela"]));            //  Data do desconto                                    143 150     9(08)
           } else if($descontoParcela['flDesconto'] == 'P') {
               $conteudo .= "2";                                                       //  Codigo do desconto. 1 = valor 2 = percentual        142 142     9(01)
               $conteudo .= date("dmY", strtotime($parcela["dt_parcela"]));            //  Data do desconto                                    143 150     9(08)
           } else {
               $conteudo .= "0";                                                       //  Codigo do desconto. 1 = valor 2 = percentual        142 142     9(01)
               $conteudo .= self::complementoRegistro(8, "zeros");                     //  Data do desconto                                    143 150     9(08)
           }
            if ($descontoParcela['flDesconto'] != 'S') {
                $conteudo .= "1";                                                       //  Codigo do desconto. 1 = valor 2 = percentual        142 142     9(01)
                $conteudo .= date("dmY", strtotime($parcela["dt_parcela"]));            //  Data do desconto                                    143 150     9(08)
            } else {
                $conteudo .= "0";                                                       //  Codigo do desconto. 1 = valor 2 = percentual        142 142     9(01)
                $conteudo .= self::complementoRegistro(8, "zeros");                     //  Data do desconto                                    143 150     9(08)
            }
            $conteudo .= $vlDesconto;                                                   //  Valor do desconto                                   151 165     9(13)
            $conteudo .= self::complementoRegistro(15, "zeros");                        //  Valor IOF a pagar                                   166 180     9(13)
            $conteudo .= self::complementoRegistro(15, "zeros");                        //  Valor do abatimento                                 181 195     9(13)
            $conteudo .= self::limit($parcela["id_parcela_contrato"], 25, "zeros");     //  Codigo de identificacao da parcela na empresa       196 220     9(25)
            $conteudo .= "3";                                                           //  Codigo para protesto (3 = sem protesto)             221 221     9(01)
            $conteudo .= self::complementoRegistro(2, "zeros");                         //  Numero de dias para protesto                        222 223     9(02)
            $conteudo .= "1";                                                           //  Codigo de Baixa do boleto (2 = n?o baixar)          224 224     9(01)
            $conteudo .= "0";                                                           //  Reservado (uso Banco)                               225 225     9(01)
            $conteudo .= self::limit($dias_permanencia, 2, "zeros");                    //  Numero de dias para baixa                           226 227     9(02)
            $conteudo .= "00";                                                          //  Codigo da moeda (09 = real)                         228 229     9(02)
            $conteudo .= self::complementoRegistro(10, "brancos");                      //  Numero identificador do contrato na empresa         230 239     9(10)
            $conteudo .= self::complementoRegistro(1, "brancos");                       //  Uso exclusivo do FEBRABAN                           240 240     9(01)
            $conteudo .= chr(13) . chr(10);                                             //  essa e a quebra de linha

            $sequencial++;

            $cep = self::retirar_caracteres_especiais($parcela['nr_cep']);
            $nrCep = substr($cep, 0, 5);
            $sufixoCep = substr($cep, 5, 3);

            ## SEGMENTO Q (OBRIGATORIO)                                                 ##  NOME DO CAMPO                                       POSICAO    TAMANHO
            $conteudo .= $emp['cd_banco'];                                              //  C?digo do banco                                     001 003     9(03)
            $conteudo .= self::sequencial($nrArquivo, 4);                               //  Lote do servico                                     004 007     9(04)
            $conteudo .= '3';                                                           //  Registro detalhe                                    008 008     9(01)
            $conteudo .= self::sequencial($sequencial, 5);                              //  Numero sequencial do registro no lote               009 013     9(05)
            $conteudo .= 'Q';                                                           //  Codigo do segmento                                  014 014     X(01)
            $conteudo .= ' ';                                                           //  Uso do banco                                        015 015     X(01)
            $conteudo .= $codMovimento;                                                 //  C?digo de movimenta??o (Informado ao chamar fun??o) 016 017     9(02)
            $conteudo .= $tipoRegistro;                                                 //  Tipo de inscri??o do Sacado                         018 018     9(01)
            $conteudo .= self::limit($cpfCnpj, 15, "zeros");                            //  Numero de inscricao do Sacado                       019 033     9(15)
            $conteudo .= self::limit($parcela['nm_pessoa'], 40, 'brancos');             //  Nome do Sacado                                      034 073     X(40)
            $conteudo .= self::limit($parcela['endereco'], 40, 'brancos');              //  Endere?o do Sacado                                  074 113     X(40)
            $conteudo .= self::limit($parcela['nm_bairro'], 15, "brancos");             //  Bairro do Sacado                                    114 128     X(15)
            $conteudo .= self::limit($nrCep, 5, "brancos");                             //  CEP do Sacado                                       129 133     9(05)
            $conteudo .= self::limit($sufixoCep, 3, "brancos");                         //  Sufixo do Cep do sacado                             134 136     9(03)
            $conteudo .= self::limit($parcela['cidade'], 15, "brancos");                //  Nome da Cidade do Sacado                            137 151     X(15)
            $conteudo .= self::limit($parcela['uf'], 2, "brancos");                     //  Uf do Sacado                                        152 153     X(02)
            $conteudo .= '0';                                                           //  Tipo de inscri??o do pagador (se diferente)         154 154     9(01)
            $conteudo .= self::complementoRegistro(15, "zeros");                        //  Numero do documento do pagador (se diferente)       155 169     9(15)
            $conteudo .= self::complementoRegistro(40, "brancos");                      //  Nome do pagador (se diferente)                      170 209     X(40)
            $conteudo .= self::complementoRegistro(3, "zeros");                         //  Identificador de carne                              210 212     9(03)
            $conteudo .= self::complementoRegistro(3, "zeros");                         //  Seq?encial da Parcela                               213 215     9(03)
            $conteudo .= self::complementoRegistro(3, "zeros");                         //  Quantidade total de parcelas                        216 218     9(03)
            $conteudo .= self::complementoRegistro(3, "zeros");                         //  N?mero do plano                                     219 221     9(03)
            $conteudo .= self::complementoRegistro(19, "brancos");                      //  Nosso N? no Banco Correspondente                    222 240     X(19)
            $conteudo .= chr(13) . chr(10);                                             //  essa e a quebra de linha

            $sequencial++;

            ## SEGMENTO R (OPCIONAL)                                                    ##  NOME DO CAMPO                                       POSICAO    TAMANHO
            $conteudo .= $emp['cd_banco'];                                              //  C?digo do banco                                     001 003     9(03)
            $conteudo .= self::sequencial($nrArquivo, 4);                               //  Lote do servico                                     004 007     9(04)
            $conteudo .= '3';                                                           //  Registro detalhe                                    008 008     9(01)
            $conteudo .= self::sequencial($sequencial, 5);                              //  Numero sequencial do registro no lote               009 013     9(05)
            $conteudo .= 'R';                                                           //  Codigo do segmento                                  014 014     X(01)
            $conteudo .= ' ';                                                           //  Uso do banco                                        015 015     X(01)
            $conteudo .= $codMovimento;                                                 //  C?digo de movimenta??o (Informado ao chamar fun??o) 016 017     9(02)
            $conteudo .= '0';                                                           //  Tipo de Desconto2 do titulo                         018 018     9(01)
            $conteudo .= self::complementoRegistro(8, "zeros");                         //  Data do desconto2 do titulo                         019 026     9(08)
            $conteudo .= self::complementoRegistro(15, "zeros");                        //  Valor do desconto2 do titulo                        027 041     9(13)
            $conteudo .= self::complementoRegistro(24, "brancos");                      //  Uso do banco                                        042 065     X(24)
            $conteudo .= '2';                                                           //  Tipo de Multa do titulo (2 = percentual)            066 066     9(01)
            $conteudo .= date("dmY", strtotime($parcela["dt_parcela"]));                //  Data da multa do titulo                             067 074     9(08)
            $conteudo .= self::limit($multa, 15, "zeros");                              //  Valor da multa do titulo (porcento)                 075 089     9(15)
            $conteudo .= self::complementoRegistro(10, "brancos");                      //  Informa?oes do Pagador                              090 099     X(10)
            $conteudo .= self::complementoRegistro(40, "brancos");                      //  Mensagem nr 3                                       100 139     X(40)
            $conteudo .= self::complementoRegistro(40, "brancos");                      //  Mensagem nr 4                                       140 179     X(40)
            $conteudo .= self::complementoRegistro(50, "brancos");                      //  E-mail do pagador                                   180 229     X(50)
            $conteudo .= self::complementoRegistro(11, "brancos");                      //  Reservado para uso do banco                         231 240     X(11)
            $conteudo .= chr(13) . chr(10);                                             //  quebra de linha

            $sequencial++;
        }

        ##  TRAILER DO LOTE (OBRIGATORIO) - REGISTRO 5
        #  NOME DO CAMPO                                                                #SIGNIFICADO                                            #POSICAO    #TAMANHO
        $conteudo .= $emp['cd_banco'];                                                  //  Codigo banco                                        001 003     9(03)
        $conteudo .= self::sequencial($nrArquivo, 4);                                   //  Lote                   Lote de servico              004 007     9(04)
        $conteudo .= '5';                                                               //  Registro trailer do lote                            008 008     9(01)
        $conteudo .= self::complementoRegistro(9, "brancos");                           //  Filler                                              009 017     X(09)
        $conteudo .= self::limit($sequencial + 1, 6, "zeros");                          //  N?mero de registros no lote                         018 023     9(06)
        $conteudo .= self::complementoRegistro(217, "brancos");                         //  Filler                                              024 240     9(117)
        $conteudo .= chr(13) . chr(10);                                                 //  essa e a quebra de linha

        return $conteudo;
    }

}

?>