<?php

class RemessaItens extends Zend_Db_Table_Abstract
{

    protected $_name = TB_REMESSA_ITENS;

    /**
     * Busca todos os dados de pessoa do Contrato
     * @param $id
     * @return mixed
     */
    public static function findByRemessa($remessa)
    {
        $itens = self::getDefaultAdapter()->select()
            ->from(array('ri' => TB_REMESSA_ITENS), array('id_contrato', 'tp_parcela', 'nr_parcela', 'dt_parcela' => 'date_format(dt_parcela, "%d/%m/%Y")', 'vl_parcela' => "format(vl_parcela,2,'de_DE')"))
            ->join(array('l' => TB_LOTES), 'ri.id_lote = l.id', array('quadra', 'lote'))
            ->join(array('p' => TB_PESSOA), 'ri.id_pessoa = p.id', array('nm_pessoa'))
            ->where('ri.id_remessa = ?', $remessa)
            ->query()->fetchAll();
        return $itens;
    }

    /**
     * Adiciona um registro na tabela com os dados da parcela
     */
    public static function addParcela($parcela, $remessa)
    {
        $item = new RemessaItens();
        $item = $item->createRow();
        $item->id_remessa = $remessa;
        $item->id_pessoa = $parcela['id_pessoa'];
        $item->id_lote = $parcela['id_lote'];
        $item->id_contrato = $parcela['id_contrato'];
        $item->id_parcela = $parcela['id_parcela_contrato'];
        $item->nr_boleto = $parcela['nr_boleto'];
        $item->nr_parcela = $parcela['id_parcela'];
        $item->tp_parcela = $parcela['tp_parcela'];
        $item->dt_parcela = $parcela['dt_parcela'];
        $item->vl_parcela = $parcela['vl_parcela'];
        $item->ds_log = Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i';

        return $item->save();
    }
}