<?php

/*
 * @descr: Gera o arquivo de remessa para cobranca no padrao CNAB 240 vers. 10.01 FEBRABAN
 */

class RemessaInstrucaoAutomatica extends Zend_Db_Table_Abstract
{
    protected $_name = TB_REMESSA_INSTRUCAO;

    /***
     * Limita e trata as palavras e numeros para o formato dos campos
     * @param $palavra
     * @param $limite
     * @param $comp
     * @param $antecede
     * @return string
     */
    private static function limit($palavra, $limite, $comp = 'brancos', $antecede = false, $caracterEspecial = true)
    {
        $var = '';
        if ($caracterEspecial)
            $palavra = strtoupper(self::retirar_caracteres_especiais($palavra));

        if (strlen($palavra) >= $limite) {
            $var = substr($palavra, 0, $limite);
        } else {
            $max = (int)($limite - strlen($palavra));
            if ($comp == 'brancos') {
                if ($antecede) {
                    $var = self::complementoRegistro($max, "brancos") . $palavra;
                } else {
                    $var = $palavra . self::complementoRegistro($max, "brancos");
                }
            } elseif ($comp == 'zeros') {
                $var = self::complementoRegistro($max, "zeros") . $palavra;
            }
        }
        return $var;
    }

    public static function modulo_10($num)
    {
        $numtotal10 = 0;
        $fator = 2;

        // Separacao dos numeros
        for ($i = strlen($num); $i > 0; $i--) {
            // pega cada numero isoladamente
            $numeros[$i] = substr($num, $i - 1, 1);
            // Efetua multiplicacao do numero pelo (falor 10)
            // 2002-07-07 01:33:34 Macete para adequar ao Mod10 do Itau
            $temp = $numeros[$i] * $fator;
            $temp0 = 0;
            foreach (preg_split('//', $temp, -1, PREG_SPLIT_NO_EMPTY) as $k => $v) {
                $temp0 += $v;
            }
            $parcial10[$i] = $temp0; //$numeros[$i] * $fator;
            // monta sequencia para soma dos digitos no (modulo 10)
            $numtotal10 += $parcial10[$i];
            if ($fator == 2) {
                $fator = 1;
            } else {
                $fator = 2; // intercala fator de multiplicacao (modulo 10)
            }
        }

        // varias linhas removidas, vide funcao original
        // Calculo do modulo 10
        $resto = $numtotal10 % 10;
        $digito = 10 - $resto;
        if ($resto == 0) {
            $digito = 0;
        }

        return $digito;

    }

    public static function modulo_11($num, $base = 9, $r = 0)
    {
        $soma = 0;
        $fator = 2;

        /* Separacao dos numeros */
        for ($i = strlen($num); $i > 0; $i--) {
            // pega cada numero isoladamente
            $numeros[$i] = substr($num, $i - 1, 1);
            // Efetua multiplicacao do numero pelo falor
            $parcial[$i] = $numeros[$i] * $fator;
            // Soma dos digitos
            $soma += $parcial[$i];
            if ($fator == $base) {
                // restaura fator de multiplicacao para 2
                $fator = 1;
            }
            $fator++;
        }

        /* Calculo do modulo 11 */
        if ($r == 0) {
            $soma *= 10;
            $digito = $soma % 11;
            if ($digito == 10) {
                $digito = 0;
            }
            return $digito;
        } elseif ($r == 1) {
            $resto = $soma % 11;
            return $resto;
        }
        return false;
    }

    /**
     * Transforma o int do sequencial para o padrao febraban
     * @param $i
     * @param $length
     * @return string
     */
    private static function sequencial($i, $length)
    {
        return str_pad($i, $length, 0, STR_PAD_LEFT);
    }

    /**
     * Complementa os registros de acordo com as normas do febraban
     * @param $int
     * @param $tipo ('zeros','brancos')
     * @return string
     */
    private static function complementoRegistro($int, $tipo)
    {
        $space = '';
        if ($tipo == "zeros") {
            for ($i = 1; $i <= $int; $i++) {
                $space .= '0';
            }
        } else if ($tipo == "brancos") {
            for ($i = 1; $i <= $int; $i++) {
                $space .= ' ';
            }
        }
        return $space;
    }

    /**
     * Remove os caracteres especiais de uma string
     * @param $string
     * @return mixed
     */
    private static function retirar_caracteres_especiais($string)
    {
        $palavra = Helper::removeAcentos($string);
        $palavranova = str_replace("_", " ", $palavra);
        $palavranova = str_replace(array("-", ",", "."), "", $palavranova);
        return $palavranova;
    }

    /**
     * Funcao para calcular o digito desconsiderando o '10' e inserindo 'P' no lugar
     * @param $numero
     * @return int|string
     */
    public static function digitoVerificadorP($numero)
    {
        $resto2 = self::modulo_11($numero, 7, 1);
        $digito = 11 - $resto2;
        if ($digito == 10) {
            $dv = "P";
        } elseif ($digito == 11) {
            $dv = 0;
        } else {
            $dv = $digito;
        }
        return $dv;
    }

    /**
     * Gera o nosso numero de acordo com o banco
     * @param $banco
     * @param $parcela
     * @param null $adicionais
     * @return string
     */
    private static function geraNossoNumero($banco, $parcela, $emp = null)
    {
        $nossoNumero = '';
        switch ($banco) {
            case Banco::BANCO_SANTANDER:
                $nossoNumero = str_pad($parcela['id_parcela_contrato'], 20, '0', STR_PAD_LEFT);
                break;
            case Banco::BANCO_BRADESCO:
                $numeroCalculo = str_pad($emp['carteira'], 2, '0', STR_PAD_LEFT) .
                    str_pad($parcela['id_parcela_contrato'], 11, '0', STR_PAD_LEFT);
                $nossoNumero = str_pad($emp['carteira'], 3, '0', STR_PAD_LEFT) .
                    self::complementoRegistro(5, 'zeros') .
                    str_pad($parcela['id_parcela_contrato'], 11, '0', STR_PAD_LEFT);
                $nossoNumero = $nossoNumero . self::digitoVerificadorP($numeroCalculo);
                break;
            case Banco::BANCO_DO_BRASIL:
                if (strlen($emp['cd_cedente']) == 4) {
                    $nossoNumero = $emp['cd_cedente'] . str_pad($parcela['id_parcela_contrato'], 7, '0', STR_PAD_LEFT);
                    $nossoNumero = $nossoNumero . self::modulo_11($nossoNumero);
                } elseif (strlen($emp['cd_cedente']) == 6) {
                    $nossoNumero = $emp['cd_cedente'] . str_pad($parcela['id_parcela_contrato'], 5, '0', STR_PAD_LEFT);
                    $nossoNumero = $nossoNumero . self::modulo_11($nossoNumero);
                } elseif (strlen($emp['cd_cedente']) == 7) {
                    $nossoNumero = $emp['cd_cedente'] . str_pad($parcela['id_parcela_contrato'], 10, '0', STR_PAD_LEFT);
                } else {
                    $nossoNumero = self::complementoRegistro(15, 'zeros');
                }
                $nossoNumero = self::limit($nossoNumero, 20, 'brancos');
                break;
            case Banco::BANCO_SICREDI:
                $nossoNumero = date('y').substr($parcela['nr_boleto'], -6);
                $dvNossoNumero = self::modulo_11($emp['agencia'].$emp['carteira_variacao'].$emp['cd_cedente'].$nossoNumero);
                $nossoNumero = self::limit($nossoNumero.$dvNossoNumero, 20, 'brancos');
                break;
            case Banco::BANCO_ITAU:
                $nossoNumero = str_pad((int)$parcela['id_parcela_contrato'], 8, '0', STR_PAD_LEFT);
                $nossoNumero = $emp['carteira'] . $nossoNumero . self::modulo_10($nossoNumero);
                $nossoNumero = $nossoNumero . self::complementoRegistro(8, 'brancos');
                break;
            case Banco::BANCO_CAIXA_ECONOMICA:
                $nossoNumero = '00014' . str_pad($parcela['id_parcela_contrato'], 15, '0', STR_PAD_LEFT);
                break;
            case Banco::BANCO_SICOOB:
                $nossoNumero = str_pad((int)$parcela['id_parcela_contrato'], 9, '0', STR_PAD_LEFT);
                $nossoNumero .= self::digitoVerificadorSicoob($emp['agencia'],$emp['cd_cedente'],$nossoNumero);
                $nossoNumero .= '01014';
                $nossoNumero .= self::complementoRegistro(5, 'brancos');
                break;
            case Banco::BANCO_NORDESTE:
                $nossoNumero = str_pad((int)$parcela['id_parcela_contrato'], 7, '0', STR_PAD_LEFT);
                $nossoNumero .= self::modulo_11($nossoNumero);
                $nossoNumero .= self::complementoRegistro(12, 'brancos');
                break;
            case Banco::BANCO_BANPARA:
                $nossoNumero = '00000' . str_pad($parcela['id_parcela_contrato'], 15, '0', STR_PAD_LEFT);
                break;
            case Banco::BANCO_SAFRA:
                $nossoNumero = str_pad($parcela['id_parcela_contrato'], 10, '0', STR_PAD_LEFT);
                break;
            case Banco::BANCO_AILOS:
                $contacc = str_pad($emp['conta_corrente'].$emp['conta_corrente_dv'], 8, '0', STR_PAD_LEFT);
                $nossoNumeroN = ltrim($parcela['id_parcela_contrato'],'0');
                $nossoNumero = str_pad($contacc.self::limit($nossoNumeroN, 9, 'zeros'), 20, ' ', STR_PAD_RIGHT);
                break;
            case Banco::BANCO_UNIPRIME:
                $contacc = str_pad($emp['conta_corrente'].$emp['conta_corrente_dv'], 8, '0', STR_PAD_LEFT);
                $nossoNumeroN = ltrim($parcela['id_parcela_contrato'],'0');
                $nossoNumero = str_pad($contacc.self::limit($nossoNumeroN, 9, 'zeros'), 20, ' ', STR_PAD_RIGHT);
                break;
        }
        return $nossoNumero;
    }

    /**
     * calcula o digito verificador do Sicoob
     */
    private static function digitoVerificadorSicoob($agencia,$cedente,$nosso_numero) {
        $Dv = '';
        if($nosso_numero && $agencia && $cedente){
            $NossoNumero = self::formataNumDoc((int)$nosso_numero,7);
            $sequencia = self::formataNumDoc($agencia,4).self::formataNumDoc(str_replace("-","",$cedente),10).self::formataNumDoc($NossoNumero,7);
            $cont=0;
            $calculoDv = '';
            for($num=0;$num<=strlen($sequencia);$num++)
            {
                $cont++;
                // constante fixa Sicoob e 3197
                if($cont == 1)
                    $constante = 3;
                elseif($cont == 2)
                    $constante = 1;
                elseif($cont == 3)
                    $constante = 9;
                elseif($cont == 4){
                    $constante = 7;
                    $cont = 0;
                }
                $calculoDv = (float)$calculoDv + (float)(substr($sequencia,$num,1) * (int)$constante);
            }
            $Resto = $calculoDv % 11;
            $Dv = 11 - $Resto;
            $Dv = ($Dv > 9)?0:$Dv;
        }
        return $Dv;
    }

    private static function formataNumDoc($num,$tamanho)
    {
        while(strlen($num)<$tamanho)
        {
            $num="0".$num;
        }
        return $num;
    }

    //Altera o versionamento do arquivo de acordo com o banco utilizado
    private static function versionamentoLayout($banco, $cdCedente = null)
    {
        $versaoH = '060';
        $versaoL = '030';
        switch ($banco) {
            case Banco::BANCO_SANTANDER:
                $versaoH = '040';
                break;
            case Banco::BANCO_BRADESCO:
                $versaoH = '084';
                $versaoL = '042';
                break;
            case Banco::BANCO_DO_BRASIL:
                $versaoH = '083';
                $versaoL = '042';
                break;
            case Banco::BANCO_SICREDI:
                $versaoH = '081';
                $versaoL = '040';
                break;
            case Banco::BANCO_ITAU:
                $versaoH = '040';
                break;
            case Banco::BANCO_CAIXA_ECONOMICA:

                if (strlen($cdCedente) < 7) {
                    $versaoH = '050';
                } else {
                    $versaoH = '107';
                    $versaoL = '067';
                }

                break;
            case Banco::BANCO_SICOOB:
                $versaoL = '040';
                $versaoH = '081';
                break;
            case Banco::BANCO_BANPARA:
                $versaoH = '101';
                $versaoL = '060';
                break;
            case Banco::BANCO_SAFRA:
                $versaoH = '103';
                $versaoL = '060';
                break;
        }
        return array('header' => $versaoH, 'lote' => $versaoL);
    }

    /**
     * Verifica os codigos de carteira para os bancos especificamente
     * @param $banco
     * @param $carteira
     * @return string
     */
    private static function verificaCodigoCarteira($banco, $carteira)
    {
        $codCarteira = '1';
        switch ($banco) {
            case Banco::BANCO_SANTANDER:
                $codCarteira = '5';
                break;
            case Banco::BANCO_BRADESCO:
                $codCarteira = '1';
                break;
            case Banco::BANCO_DO_BRASIL:
                if ($carteira == '11' || $carteira == '12') {
                    $codCarteira = '1';
                } elseif ($carteira == '17') {
                    $codCarteira = '7';
                } else {
                    $codCarteira = '1';
                }
                break;
            case Banco::BANCO_SICREDI:
                //Numero da unicred possui 2 digitos entao o primeiro digito precisa estar anexado ao nosso numero
                $codCarteira = '1';
                break;
            case Banco::BANCO_ITAU:
                $codCarteira = '1';
                break;
            case Banco::BANCO_CAIXA_ECONOMICA:
                $codCarteira = '1';
                break;
        }
        return $codCarteira;
    }

    /**
     * Gera O registro no banco da remessa de alteracao de registros ja gerados
     * @param $idContrato
     * @param string $codMovimento
     * @return mixed
     */
    public static function geraRemessaInstrucao($idContrato, $codMovimento = '01')
    {
        $parcelas = Parcela::getInstance()->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('id_parcela_contrato', 'id_contrato', 'vl_parcela', 'dt_parcela', 'id_remessa', 'desconto', 'acrescimo', 'nr_boleto'))
            ->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', null)
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', array('idEmpreendimento' => 'id'))
            ->join(array('pe' => TB_PESSOA), 'pe.id = c.id_pessoa', array('nm_pessoa', 'endereco', 'nr_cep', 'nm_bairro', 'tp_pessoa'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pe.id = pf.id_pessoa', array('nr_cpf'))
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pe.id = pj.id_pessoa', array('nr_cnpj'))
            ->joinLeft(array('ci' => TB_CIDADE), 'pe.cd_cidade = ci.id', array('cidade' => 'nome', 'uf'))
            ->where('c.id = ' . $idContrato)
            ->where('p.pago = "0"')
            ->where('p.id_remessa IS NOT NULL')
            ->query()->fetchAll();

        if (count($parcelas) == 0)
            return false;

        //Busca parcelas que ja foram criadas e nao foram enviadas
        $remessaInstrucao = new RemessaInstrucaoAutomatica();
        $idsParcela = array();
        foreach ($parcelas as $k => $parcela) {
            $testeRemessa = $remessaInstrucao->fetchRow('id_remessa_instrucao = ' . $parcela['id_remessa'] . ' AND id_remessa IS NULL');
            if ($testeRemessa)
                unset($parcelas[$k]);
            else
                $idsParcela[] = $parcela['id_parcela_contrato'];
        }

        //Busca os dados necessarios para gerar o arquivo de lote
        $emp = Empreendimento::getDefaultAdapter()->select()
            ->from(array('emp' => TB_EMPREENDIMENTO), '*')
            ->join(array('b' => TB_BANCO), 'emp.id = b.id_empreendimento', array('*'))
            ->where('emp.id = ' . $parcelas[0]['idEmpreendimento'])
            ->query()->fetch();

        $emp['contrato'] = $idContrato;
        $emp['parcelas'] = $parcelas;

        //Verifica se existe alguma remessa de instrucao aberta para acrescentar o lote
        $remessa = $remessaInstrucao->fetchRow('id_empreendimento = ' . $emp['id'] .
            ' AND id_banco = ' . $emp['cd_banco'] . ' AND id_remessa IS NULL');

        //Calcula o numero de registro para incrementar ou aplicar na criacao da remessa instrucao
        $nrRegistros = (count($parcelas) * 3) + 2;

        if (!$remessa) {
            $remessa = $remessaInstrucao->createRow();
            $remessa->id_empreendimento = $emp['id'];
            $remessa->nr_registro = $nrRegistros + 2;
            $remessa->id_banco = $emp['cd_banco'];
            $remessa->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
            $remessa->save();
            $nrLote = 1;
        } else {
            //Se ja existe remessa busca os lotes da mesma para registrar o numero do lote atual
            $lotes = RemessaLote::getInstance()->fetchAll('id_remessa_instrucoes = ' . $remessa->id_remessa_instrucao);
            $nrLote = count($lotes) + 1;
            $remessa->nr_registro = (int)$remessa->nr_registro + ($nrRegistros + 2);
            $remessa->save();
        }

        $detalhe = $remessaInstrucao->gerarDetalhe($codMovimento, $emp, $parcelas, $nrLote, $idContrato);

        $lote = RemessaLote::getInstance()->createRow();
        $lote->id_remessa_instrucoes = $remessa->id_remessa_instrucao;
        $lote->id_contrato = $idContrato;
        $lote->ds_detalhes_registro = $detalhe;
        $lote->ds_codigo_movimento = $codMovimento;
        $lote->ds_ids_parcelas = implode(',', $idsParcela);
        $lote->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - D');

        $idLote = $lote->save();

        return $idLote;
    }

    /**
     * Gera arquivo remessa para inclusao sem gravar registro no banco de dados
     * @param array $dados
     * @param string $nmArquivo
     * @param boolean $loteUnico
     * @return mixed
     */
    public static function geraRemessa($dados, $nmArquivo, $loteUnico = false)
    {

        $contratos = $dados['contratos'];
        if (count($contratos) == 0)
            return false;

        //Cria os diretorios para onde o arquivo vai ser gravado
        $path = explode('.', $_SERVER['HTTP_HOST']);
        if ($path[0] == 'www') {
            $path = $path[1];
        } else {
            $path = $path[0];
        }
        $filename = $nmArquivo;
        $filepath = DIRETORIO_DOWNLOAD . "remessas/" . $path;
        $pathAno = DIRETORIO_DOWNLOAD . "remessas/" . $path . '/' . date('Y');

        if (is_dir($filepath)) {
            if (!is_dir($pathAno)) mkdir($pathAno);
        } else {
            mkdir($filepath);
            mkdir($pathAno);
        }

        //Grava o conteudo dos registro no corpo do arquivo a ser gerado
        //Se a op��o Tipo de Remessa no Menu Gerar Remessa for atualizar/padr�o ele utiliza o sistema novo de gera��o ou o antigo.
        $nrRegistros1 = 1;
        $conteudo = self::gerarHeader($dados,$nrRegistros1);
        $nrRegistros1++;
        //Seleciona na tabela Layout o Layout de acordo como C�digo do banco
        $dados_layout = Layout::getTabelaRemessaByCodBanco($dados['cod_layout_rem']);

        $id_layout = $dados_layout['id'];
        $idsParcela = array();

        //BRADESCO OU ITAU
        //if (in_array($dados['cdBanco'], ['237', '341', '001'])) {
        if (LayoutItens::getLayouItenstById($id_layout, '2')) {
            $nrRegistros = 1;
            $vlTotal = 0.00;
            $nrLote = 1;

            //Gera o header do lote e incrementa o numero de registros

            $conteudo .= self::geraHeaderLote($dados, $nrRegistros);

            $nrRegistros++;
            $nrRegistroLote = 1;
            foreach ($contratos as $idContrato) {
                $parcelas = $idContrato['parcelas'];

                //Busca parcelas que ja foram criadas e nao foram enviadas e gera registro para ela
                foreach ($parcelas as $k => $parcela) {
                    if ($parcela['id_remessa'])
                        unset($parcelas[$k]);
                    else {
                        $idsParcela[] = $parcela['id_parcela_contrato'];

                        $conteudo .= self::gerarDetalheApenas('01', $dados, $parcela, $nrLote, $idContrato['id'], $nrRegistroLote);

                        //Atualiza contadores de registros e lotes
                        $nrRegistros += 3;
                        $nrRegistroLote += 3;
                        $vlTotal += (float)$parcela['vl_parcela'];
                    }
                }
            }

            $conteudo .= self::gerarTrailerLote($nrRegistros, $dados, $idsParcela, $nrLote, $vlTotal);

        } else {
            //TODOS OUTROS BANCOS
            $nrLote = 0;
            $nrRegistros = 0;
            foreach ($contratos as $idContrato) {
                $nrLote++;
                $parcelas = $idContrato['parcelas'];

                //Busca parcelas que ja foram criadas e nao foram enviadas
                foreach ($parcelas as $k => $parcela) {
                    if ($parcela['id_remessa'])
                        unset($parcelas[$k]);
                    else {
                        if ($dados['cdBanco'] == '748') {
                            $idsParcela[] = $parcela['nr_boleto'];
                        } else {
                            $idsParcela[] = $parcela['id_parcela_contrato'];
                        }

                    }
                }
                //Atualiza contadores de registros e lotes
                $nrRegistros += (count($parcelas) * 3) + 2;

                $conteudo .= self::gerarDetalheApenas('01', $dados, $parcelas, $nrLote, $idContrato['id'], $nrRegistros);
            }
        }

        $conteudo .= self::gerarTrailer($dados['cod_layout_rem'],$dados['cdBanco'], $nrLote, $nrRegistros);

        if (!$handle = fopen($pathAno . '/' . $filename, 'w+')) {
            $msg = "N�o foi poss�vel abrir o arquivo ($filename)";
            $erro = true;
        } // Escreve $conteudo no nosso arquivo aberto.
        elseif (fwrite($handle, "$conteudo") === FALSE) {
            $msg = "N�o foi poss�vel escrever no arquivo ($filename)";
            $erro = true;
        } else {
            $msg = "Arquivo de remessa gerado com sucesso!";
            $erro = false;
        }
        fclose($handle);

        $retorno[0] = $conteudo;
        $retorno[1] = $erro;
        $retorno[2] = $msg;

        return $retorno;
    }

    /**
     * Gera arquivo remessa para envio utilizando os dados de RemessaInstrucao e RemessaLote
     * @param $idRemessa
     * @param $nmArquivo
     * @return mixed
     */
    public static function gerarArquivoInstrucao($idRemessa, $nmArquivo)
    {
        $remInst = new RemessaInstrucaoAutomatica();
        $remessaInstrucao = $remInst->fetchRow('id_remessa_instrucao = ' . $idRemessa);
        $lotesRemessa = RemessaLote::getInstance()->fetchAll('id_remessa_instrucoes = ' . $remessaInstrucao['id_remessa_instrucao']);

        if (count($lotesRemessa) > 0) {

            //Cria os diretorios para onde o arquivo vai ser gravado
            $path = explode('.', $_SERVER['HTTP_HOST']);
            if ($path[0] == 'www') {
                $path = $path[1];
            } else {
                $path = $path[0];
            }
            $filename = $nmArquivo;
            $filepath = DIRETORIO_DOWNLOAD . "remessas/" . $path;
            $pathAno = DIRETORIO_DOWNLOAD . "remessas/" . $path . '/' . date('Y');

            if (is_dir($filepath)) {
                if (!is_dir($pathAno)) mkdir($pathAno);
            } else {
                mkdir($filepath);
                mkdir($pathAno);
            }

            //Grava o conteudo dos registro no corpo do arquivo a ser gerado
            $conteudo = $remessaInstrucao['ds_header'];
            foreach ($lotesRemessa as $lote) {
                $conteudo .= $lote['ds_detalhes_registro'];
            }
            $conteudo .= $remessaInstrucao['ds_trailer'];

            if (!$handle = fopen($pathAno . '/' . $filename, 'w+')) {
                $msg = "N�o foi poss�vel abrir o arquivo ($filename)";
                $erro = true;
            } // Escreve $conteudo no nosso arquivo aberto.
            elseif (fwrite($handle, "$conteudo") === FALSE) {
                $msg = "N�o foi poss�vel escrever no arquivo ($filename)";
                $erro = true;
            } else {
                $msg = "Arquivo de remessa gerado com sucesso!";
                $erro = false;
            }
            fclose($handle);

            $retorno[0] = $msg;
            $retorno[1] = $erro;

        } else {
            $retorno[0] = 'N�o existem parcelas a serem incluidas no arquivo';
            $retorno[1] = true;
        }

        return $retorno;
    }

    /**
     * Gera o Header do arquivo utilizando os dados da tabela remessa instrucao
     * @param $emp
     * @return string
     */
    public static function gerarHeader($emp,$nrArquivo)
    {
        $cdBanco = $emp['cdBanco'];

        //Seleciona na tabela Layout o Layout de acordo como C�digo do banco
        $dados_layout = Layout::getTabelaRemessaByCodBanco($emp['cod_layout_rem']);

        $id_layout = $dados_layout['id'];

        //Obtem da tabela Layout_Itens a linha 1 que � a linha que tem a REGEX do Header do Arquivo de remessa.
        //O par�metro linha significa que � para pegar somente o id_layout que tem o n�mero da linha 1 da tabela Layout_Itens
        $dados_layout_itens = LayoutItens::getLayouItenstById($id_layout, '1');


        $cnpjCpfCedente = ($emp["cnpj_cedente"]) ? $emp["cnpj_cedente"] : $emp["cpf_cedente"];

        $tpInscricao = '2';
        $codEmpresa = str_replace(array(".", "/", "-"), "", $cnpjCpfCedente);
        $empresa = strtoupper(self::retirar_caracteres_especiais($emp["nm_cedente"]));
        $tipoRegistro = ($emp["cnpj_cedente"]) ? '2' : '1'; //1 = CPF, 2 = CNPJ
        $cpfCnpj = ($emp["cnpj_cedente"]) ? str_replace(array(".", "/", "-"), "", $emp["cnpj_cedente"]) : str_replace(array(".", "/", "-"), "", $emp["cpf_cedente"]);
        $nmBanco = strtoupper(Banco::findBancoNome($cdBanco));
        $nrRemessa = $emp['idRemessa'];

        $conteudo = '';

        $expressao = explode(";", $dados_layout_itens[0]['conteudo']); //Pega a linha conte�do e quebra a express�o regular

        for ($i = 0; $i < count($expressao); $i++) {
            $expressao2 = explode(":", $expressao[$i]); //Quebra a express�o pegando a primeira palavra
            $posicaoi = explode("-", $expressao2[1]); //Quebra a express�o novamente pegando a coluna inicial
            $posicaof = explode("+", $posicaoi[1]); //Quebra a express�o novamente pegando a coluna final e o preenchimento
            $valorTipo = explode(".", $posicaof[1]); //Quebra a express�o novamente pegando a coluna final e o preenchimento
            $pinicial = $posicaoi[0] + 1; //Seta a coluna onde ser� inserida a informa��o no arquivo de remessa
            $pfinal = $posicaof[0] + 1; //Sete a coluna onde ser� finalizada a informa��o no arquivo de remessa
            $preencher = $posicaof[1]; //Obtem se � para completar ou preencher os valores e qual ser� o preenchimento

            if (strpos($expressao2[0], 'cdBanco') !== false) {
                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($cdBanco, $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($cdBanco, $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($cdBanco, $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($cdBanco, $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'nr_boleto') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'tipoReg') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'lotServ') !== false) {
                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'lotReg') !== false) {
                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'nrArquivo') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::sequencial($nrArquivo, $limite);
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::sequencial($nrArquivo, $limite);
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);

                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::sequencial($nrArquivo, $limite);
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::sequencial($nrArquivo, $limite);
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'numRemessa') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['idRemessa'], $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['idRemessa'], $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['idRemessa'], $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['idRemessa'], $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoFebraban1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);

                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'agenciadvconta') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoFebraban2') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);

                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoFebraban3') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);

                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoFebraban4') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);

                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'reservadoEmpresa') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);

                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'excCNAB1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'tipoSacado') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($tipoRegistro, $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($tipoRegistro, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($tipoRegistro, $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($tipoRegistro, $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'inscSacado') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($cpfCnpj, $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($cpfCnpj, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($cpfCnpj, $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($cpfCnpj, $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'regHeader') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'agenciaRespNR') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoBanco1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }

            }
            if (strpos($expressao2[0], 'tipoInsc') !== false) {
                $conteudo = substr_replace($conteudo, $tpInscricao, $pinicial, 0);
            }
            if (strpos($expressao2[0], 'numInsc') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($codEmpresa, $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($codEmpresa, $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($codEmpresa, $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($codEmpresa, $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'cdCedente') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_cedente'], $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_cedente'], $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_cedente'], $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_cedente'], $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'cdFixoBanco') !== false) {
                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'carteiraNR') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['carteira'], $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['carteira'], $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['carteira'], $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['carteira'], $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'carteiravariacao') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['carteira_variacao'], $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['carteira_variacao'], $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['carteira_variacao'], $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['carteira_variacao'], $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoBanco2') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'agenciaNR') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia"], $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia"], $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia"], $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia"], $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'agenciadvNR') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia_dv"], $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia_dv"], $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia_dv"], $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia_dv"], $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'codConvenio') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["cd_cedente"], $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["cd_cedente"], $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["cd_cedente"], $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["cd_cedente"], $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoBanco3') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'contaCorrenteNR') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente"], $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente"], $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente"], $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente"], $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'contaCorrenteDV') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente_dv"], $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente_dv"], $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente_dv"], $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente_dv"], $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'digitoBanco') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente_dv"], $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente_dv"], $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente_dv"], $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente_dv"], $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            //Nome da Construtora
            if (strpos($expressao2[0], 'empresa') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($empresa, $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($empresa, $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($empresa, $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($empresa, $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            //Nome da Construtora
            if (strpos($expressao2[0], 'nmEmp') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($empresa, $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($empresa, $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($empresa, $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($empresa, $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            //Nome da institui��o Financeira
            if (strpos($expressao2[0], 'nmBanco') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nmBanco, $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nmBanco, $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nmBanco, $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nmBanco, $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'usoBanco4') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            //15  Codigo 1 = remessa; 2 = retorno
            if (strpos($expressao2[0], 'tipoDoc') !== false) {
                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            //16  Data de geracao
            if (strpos($expressao2[0], 'dtGeracao') !== false) {

                $conteudo = substr_replace($conteudo, date("dmY"), $pinicial, 0);
            }

            //17  Hora de geracao de geracao
            if (strpos($expressao2[0], 'hrGeracao') !== false) {

                $conteudo = substr_replace($conteudo, date("His"), $pinicial, 0);
            }

            //18  Numero sequencial do arquivo
            if (strpos($expressao2[0], 'nmrSeq') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrRemessa, $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrRemessa, $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrRemessa, $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrRemessa, $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            //19  Layout do arquivo
            if (strpos($expressao2[0], 'layoutArq') !== false) {
                if (strpos($preencher, 'NE') !== false) {
                    $layarq = self::versionamentoLayout($cdBanco, $emp['cd_cedente'])['header'];
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($layarq,$limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $layarq, $pinicial, 0);
                }
                if (strpos($preencher, 'ND') !== false) {
                    $layarq = self::versionamentoLayout($cdBanco, $emp['cd_cedente'])['header'];
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($layarq,$limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $layarq, $pinicial, 0);
                }
                if (strpos($preencher, '0E') !== false) {
                    $layarq = self::versionamentoLayout($cdBanco, $emp['cd_cedente'])['header'];
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($layarq,$limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $layarq, $pinicial, 0);
                }
                if (strpos($preencher, '0D') !== false) {
                    $layarq = self::versionamentoLayout($cdBanco, $emp['cd_cedente'])['header'];
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($layarq,$limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $layarq, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            //20  Densidade de gravacao do arquivo
            if (strpos($expressao2[0], 'densidadeArq') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            //21  Reservado banco
            if (strpos($expressao2[0], 'usoBanco5') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            //22  Tipo de remessa
            if (strpos($expressao2[0], 'tipoRemessa') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);

                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            //22  Tipo de remessa
            if (strpos($expressao2[0], 'idReg') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            //23  Uso do fenabran
            if (strpos($expressao2[0], 'remFebraban') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
        }

        $conteudo .= chr(13) . chr(10);                      //quebra de linha

        return $conteudo;
    }

    /**
     * Gera o Trailer do arquivo
     * @param $cdBanco
     * @param $nrLote
     * @param $nrRegistros
     * @return string
     */
    public static function gerarTrailer($cod_layout,$cdBanco, $nrLote, $nrRegistros)
    {
        $dados_layout = Layout::getTabelaRemessaByCodBanco($cod_layout);

        $id_layout = $dados_layout['id'];

        //Obtem da tabela Layout_Itens a linha 1 que � a linha que tem a REGEX do Header do Arquivo de remessa.
        //O par�metro linha significa que � para pegar somente o id_layout que tem o n�mero da linha 1 da tabela Layout_Itens
        $dados_layout_itens = LayoutItens::getLayouItenstById($id_layout, '7');

        $expressao = explode(";", $dados_layout_itens[0]['conteudo']); //Pega a linha conte�do e quebra a express�o regular

        for ($i = 0; $i < count($expressao); $i++) {
            $expressao2 = explode(":", $expressao[$i]); //Quebra a express�o pegando a primeira palavra
            $posicaoi = explode("-", $expressao2[1]); //Quebra a express�o novamente pegando a coluna inicial
            $posicaof = explode("+", $posicaoi[1]); //Quebra a express�o novamente pegando a coluna final e o preenchimento
            $valorTipo = explode(".", $posicaof[1]); //Quebra a express�o novamente pegando a coluna final e o preenchimento
            $pinicial = $posicaoi[0] + 1; //Seta a coluna onde ser� inserida a informa��o no arquivo de remessa
            $pfinal = $posicaof[0] + 1; //Sete a coluna onde ser� finalizada a informa��o no arquivo de remessa
            $preencher = $posicaof[1]; //Obtem se � para completar ou preencher os valores e qual ser� o preenchimento

            if (strpos($expressao2[0], 'cdBanco') !== false) {
                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($cdBanco, $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($cdBanco, $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($cdBanco, $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($cdBanco, $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'nr_boleto') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            //Lote de Registro
            if (strpos($expressao2[0], 'lotServ') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            //Tipo de Registro
            if (strpos($expressao2[0], 'tipoReg') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            //  Uso do febrabran
            if (strpos($expressao2[0], 'remFebraban') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);

                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            //  Quantidade de Lotes
            if (strpos($expressao2[0], 'qtdLotes') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrLote, $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrLote, $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);

                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrLote, $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrLote, $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            //  Quantidade de Registros
            if (strpos($expressao2[0], 'qtdRegistros') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrRegistros + 2, $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrRegistros + 2, $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);

                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrRegistros + 2, $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrRegistros + 2, $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            //  Quantidade de Contas
            if (strpos($expressao2[0], 'qtdContas') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrLote, $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrLote, $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);

                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrLote, $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrLote, $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'usoFebraban1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);

                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'usoFebraban2') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoFebraban3') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoFebraban4') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoBanco1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoBanco2') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoBanco3') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoBanco4') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoBanco5') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'excCNAB1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'avisoDebAut') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

        }

        $conteudo .= chr(13) . chr(10);       //  quebra de linha

        return $conteudo;
    }

    /**
     * Gera o header do lote apenas
     * @param $emp
     * @param $nrArquivo
     * @return string
     */
    public static function geraHeaderLote($emp, $nrArquivo)
    {
        //Seleciona na tabela Layout o Layout de acordo como C�digo do banco
        $dados_layout = Layout::getTabelaRemessaByCodBanco($emp['cod_layout_rem']);

        $id_layout = $dados_layout['id'];

        $empresa = strtoupper(self::retirar_caracteres_especiais($emp["nm_cedente"]));
        $cnpjCpfCedente = ($emp["cnpj_cedente"])?$emp["cnpj_cedente"]:$emp["cpf_cedente"];
        $tipoRegistro = ($emp["cnpj_cedente"]) ? '2' : '1'; //1 = CPF, 2 = CNPJ
        $cpfCnpj = ($emp["cnpj_cedente"]) ? str_replace(array(".", "/", "-"), "", $emp["cnpj_cedente"]) : str_replace(array(".", "/", "-"), "", $emp["cpf_cedente"]);

        //apenas para caixa verifica se e pessoa fisica ou juridica e seta 1 ou 2, para outros bancos, seta 2
        $tpInscricao = '2';
        if ($emp['cd_banco'] == '104' || $emp['cd_banco'] == '756'  || $emp['cd_banco'] == Banco::BANCO_BRADESCO || $emp['cd_banco'] == Banco::BANCO_DO_BRASIL || $emp['cd_banco'] == Banco::BANCO_SAFRA || $emp['cd_banco'] == Banco::BANCO_ITAU || $emp['cd_banco'] == Banco::BANCO_NORDESTE || $emp['cd_banco'] == Banco::BANCO_SANTANDER || $emp['cd_banco'] == Banco::BANCO_SICREDI) { //Registro complementar para caixa economica
            $tpInscricao = ($emp["cnpj_cedente"])?'2':'1';
        }

        $codEmpresa = str_replace(array(".", "/", "-"), "", $cnpjCpfCedente);
        $dados_layout_itens = LayoutItens::getLayouItenstById($id_layout, '2');
        $cnpjCpfCedente = ($emp["cnpj_cedente"]) ? $emp["cnpj_cedente"] : $emp["cpf_cedente"];

        $nmBanco = strtoupper(Banco::findBancoNome($emp['cdBanco']));
        $nrRemessa = $emp['idRemessa'];

        $conteudo = '';

        $expressao = explode(";", $dados_layout_itens[0]['conteudo']); //Pega a linha conte�do e quebra a express�o regular

        for ($i = 0; $i < count($expressao); $i++) {
            $expressao2 = explode(":", $expressao[$i]); //Quebra a express�o pegando a primeira palavra
            $posicaoi = explode("-", $expressao2[1]); //Quebra a express�o novamente pegando a coluna inicial
            $posicaof = explode("+", $posicaoi[1]); //Quebra a express�o novamente pegando a coluna final e o preenchimento
            $valorTipo = explode(".", $posicaof[1]); //Quebra a express�o novamente pegando a coluna final e o preenchimento
            $pinicial = $posicaoi[0] + 1; //Seta a coluna onde ser� inserida a informa��o no arquivo de remessa
            $pfinal = $posicaof[0] + 1; //Sete a coluna onde ser� finalizada a informa��o no arquivo de remessa
            $preencher = $posicaof[1]; //Obtem se � para completar ou preencher os valores e qual ser� o preenchimento

            if (strpos($expressao2[0], 'cdBanco') !== false) {
                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_banco'], $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_banco'], $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_banco'], $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_banco'], $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'nr_boleto') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'remFebraban') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'tipoReg') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'lotServ') !== false) {
                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'agenciadvconta') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'agenciaRespDV') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia_dv"], $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia_dv"], $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia_dv"], $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia_dv"], $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'nrArquivo') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::sequencial($nrArquivo, $limite);
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::sequencial($nrArquivo, $limite);
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);

                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::sequencial($nrArquivo, $limite);
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::sequencial($nrArquivo, $limite);
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'regHeader') !== false) {
                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);

                }
            }

            if (strpos($expressao2[0], 'tipoOperacao') !== false) {
                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'tipoServico') !== false) {
                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'usoFebraban1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::sequencial($nrArquivo, $limite);
                    $valor = self::limit($valor, $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::sequencial($nrArquivo, $limite);
                    $valor = self::limit($valor, $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);

                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::sequencial($nrArquivo, $limite);
                    $valor = self::limit($valor, $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::sequencial($nrArquivo, $limite);
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            //Numero da Vers�o do Layout do Lote
            if (strpos($expressao2[0], 'versaoLayout') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::versionamentoLayout($emp['cd_banco'], $emp['cd_cedente'])['lote'];
                    // $valor = self::limit($valor, $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::versionamentoLayout($emp['cd_banco'], $emp['cd_cedente'])['lote'];
                    //$valor = self::limit($valor, $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);

                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::versionamentoLayout($emp['cd_banco'], $emp['cd_cedente'])['lote'];
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::versionamentoLayout($emp['cd_banco'], $emp['cd_cedente'])['lote'];
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoFebraban2') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);

                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;

                    $valor = self::limit($valor, $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;

                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'usoFebraban3') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'tipoInsc') !== false) {
                $conteudo = substr_replace($conteudo, $tpInscricao, $pinicial, 0);
            }

            if (strpos($expressao2[0], 'numInsc') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($codEmpresa, $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($codEmpresa, $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($codEmpresa, $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($codEmpresa, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'tipoSacado') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($tipoRegistro, $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($tipoRegistro, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($tipoRegistro, $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($tipoRegistro, $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'inscSacado') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($cpfCnpj, $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($cpfCnpj, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($cpfCnpj, $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($cpfCnpj, $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'cdCedente') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_cedente'], $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_cedente'], $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_cedente'], $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_cedente'], $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'usoBanco1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'cobCedente') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'carteiraNR') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['carteira'], $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['carteira'], $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['carteira'], $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['carteira'], $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'carteiravariacao') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['carteira_variacao'], $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['carteira_variacao'], $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['carteira_variacao'], $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['carteira_variacao'], $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoBanco2') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'agenciaNR') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia"], $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia"], $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia"], $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia"], $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'complementoReg1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'agenciadvNR') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia_dv"], $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia_dv"], $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia_dv"], $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia_dv"], $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'codConvenio') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["cd_cedente"], $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["cd_cedente"], $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["cd_cedente"], $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["cd_cedente"], $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'usoBanco3') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'contaCorrenteNR') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente"], $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente"], $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente"], $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente"], $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'contaCorrenteDV') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente_dv"], $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente_dv"], $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente_dv"], $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente_dv"], $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'digitoBanco') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente_dv"], $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente_dv"], $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente_dv"], $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente_dv"], $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            //Nome da Construtora
            if (strpos($expressao2[0], 'empresa') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($empresa, $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($empresa, $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($empresa, $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($empresa, $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'nmEmp') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($empresa, $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($empresa, $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($empresa, $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($empresa, $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'charExtra1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'mensageNR1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'mensageNR2') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'numRemessa') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['idRemessa'], $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['idRemessa'], $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['idRemessa'], $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['idRemessa'], $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'dtGeracao') !== false) {

                $conteudo = substr_replace($conteudo, date("dmY"), $pinicial, 0);
            }

            if (strpos($expressao2[0], 'dtCredito') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'excCNAB1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
        }

        $conteudo .= chr(13) . chr(10);                                                 //  quebra de linha

        return $conteudo;
    }

    /**
     * Gera trailer do lote apenas
     * @param $sequencial
     * @param $emp
     * @param $parcelas
     * @param $nrArquivo
     * @param $vl_total
     * @return string
     */
    public static function gerarTrailerLote($sequencial, $emp, $parcelas, $nrArquivo, $vl_total)
    {
        $dados_layout = Layout::getTabelaRemessaByCodBanco($emp['cod_layout_rem']);

        $id_layout = $dados_layout['id'];

        //Obtem da tabela Layout_Itens a linha 1 que � a linha que tem a REGEX do Header do Arquivo de remessa.
        //O par�metro linha significa que � para pegar somente o id_layout que tem o n�mero da linha 1 da tabela Layout_Itens
        $dados_layout_itens = LayoutItens::getLayouItenstById($id_layout, '6');

        $expressao = explode(";", $dados_layout_itens[0]['conteudo']); //Pega a linha conte�do e quebra a express�o regular

        for ($i = 0; $i < count($expressao); $i++) {
            $expressao2 = explode(":", $expressao[$i]); //Quebra a express�o pegando a primeira palavra
            $posicaoi = explode("-", $expressao2[1]); //Quebra a express�o novamente pegando a coluna inicial
            $posicaof = explode("+", $posicaoi[1]); //Quebra a express�o novamente pegando a coluna final e o preenchimento
            $valorTipo = explode(".", $posicaof[1]); //Quebra a express�o novamente pegando a coluna final e o preenchimento
            $pinicial = $posicaoi[0] + 1; //Seta a coluna onde ser� inserida a informa��o no arquivo de remessa
            $pfinal = $posicaof[0] + 1; //Sete a coluna onde ser� finalizada a informa��o no arquivo de remessa
            $preencher = $posicaof[1]; //Obtem se � para completar ou preencher os valores e qual ser� o preenchimento

            ##  TRAILER DO LOTE (OBRIGATORIO) - REGISTRO 6
            #  NOME DO CAMPO

            if (strpos($expressao2[0], 'cdBanco') !== false) {
                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_banco'], $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_banco'], $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_banco'], $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_banco'], $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'nr_boleto') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'lotServ') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrArquivo, $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrArquivo, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrArquivo, $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrArquivo, $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'remFebraban') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);

                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'tipoReg') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            // Lote / Numero Sequencial do Arquivo
            if (strpos($expressao2[0], 'nrArquivo') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::sequencial($nrArquivo, $limite);
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::sequencial($nrArquivo, $limite);
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);

                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::sequencial($nrArquivo, $limite);
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::sequencial($nrArquivo, $limite);
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'qtdLotes') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::sequencial($nrArquivo, $limite);
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::sequencial($nrArquivo, $limite);
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);

                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::sequencial($nrArquivo, $limite);
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::sequencial($nrArquivo, $limite);
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'qtdContas') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrArquivo, $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrArquivo, $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);

                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrArquivo, $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrArquivo, $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            //Registro trailer do Lote
            if (strpos($expressao2[0], 'regTrailer') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            //Filler
            if (strpos($expressao2[0], 'filler1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            //Numero de registros no lote
            if (strpos($expressao2[0], 'numReg') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($sequencial, $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($sequencial, $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($sequencial, $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($sequencial, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            //Numero de registros no lote
            if (strpos($expressao2[0], 'qtdRegistros') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($sequencial, $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($sequencial, $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($sequencial, $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($sequencial, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            //  Numero de titulos no lote Bradesco ou Sicredi
            if (strpos($expressao2[0], 'nrTitulosBra') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            //  Numero de titulos no lote Bradesco ou Sicredi
            if (strpos($expressao2[0], 'numeroTitulos') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(count($parcelas), $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(count($parcelas), $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(count($parcelas), $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(count($parcelas), $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            //  Valor total dos titulos no lote
            if (strpos($expressao2[0], 'valorTotalT') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($vl_total, $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($vl_total, $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($vl_total, $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($vl_total, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            //Numero de titulos caucionados no lote
            if (strpos($expressao2[0], 'usoBanco1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoBanco2') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoBanco3') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoBanco4') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoBanco5') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoFebraban1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoFebraban2') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoFebraban3') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            //  Numero de titulos caucionados no lote

            if (strpos($expressao2[0], 'excCNAB1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
        }

        $conteudo .= chr(13) . chr(10);          //  essa e a quebra de linha

        return $conteudo;
    }

    /**
     * Gera apenas um registro de parcela e retorna o conteudo
     * @param $codMovimento
     * @param $emp
     * @param $parcela
     * @param $nrArquivo
     * @param $idContrato
     * @param $sequencial
     * @return string
     */
    public static function gerarDetalheApenas($codMovimento, $emp, $parcela, $nrArquivo, $idContrato, $sequencial)
    {

        $dados_layout = Layout::getTabelaRemessaByCodBanco($emp['cod_layout_rem']);

        $id_layout = $dados_layout['id'];

        //Obtem da tabela Layout_Itens a linha 1 que � a linha que tem a REGEX do Header do Arquivo de remessa.
        //O par�metro linha significa que � para pegar somente o id_layout que tem o n�mero da linha 1 da tabela Layout_Itens
        $dados_layout_itens_linha3 = LayoutItens::getLayouItenstById($id_layout, '3');
        $dados_layout_itens_linha4 = LayoutItens::getLayouItenstById($id_layout, '4');
        $dados_layout_itens_linha5 = LayoutItens::getLayouItenstById($id_layout, '5');

        $contrato = Contrato::findContratoById($idContrato);

        //Dados para geracao
        $registro = 1;
        $cpfCnpj = in_array($contrato["tp_pessoa"], array('F', 'C')) ? str_replace(array(".", "/", "-"), "", $contrato["nr_cpf"]) : str_replace(array(".", "/", "-"), "", $contrato["nr_cnpj"]);
        $tipoRegistro = in_array($contrato["tp_pessoa"], array('F', 'C')) ? '1' : '2';
        $codCarteira = self::verificaCodigoCarteira($emp['cd_banco'], $emp['carteira']);

        //Reduz do valor da parcela o desconto cadastrado
        $vl_parcela = str_pad(str_replace(array(".", ","), "", number_format($parcela["vl_parcela"], 2)), 15, '0', STR_PAD_LEFT);
        $vlParcela1 = $parcela["vl_parcela"];

        if ($emp["tp_juros"] != 'S') {
            $juros = ($emp["tp_juros"] == 'P') ? (float)$emp["juros"] * (float)$parcela["vl_parcela"] / 100 : $emp["juros"];
        } else {
            $juros = 0;
        }

        $juros = str_replace(array(".", ","), "", number_format($juros, 2));
        $multa = str_replace(array(".", ","), "", number_format($emp["multa"], 2));
        $nossoNumero = self::geraNossoNumero($emp['cd_banco'], $parcela, $emp);
        $dias_permanencia = (isset($emp['qt_dias_permanencia']) && (int)$emp['qt_dias_permanencia'] > 5) ? $emp['qt_dias_permanencia'] : 90;

        $contrato['tp_parcela'] = $parcela['tp_parcela'];
        $contrato['dt_parcela'] = $parcela['dt_parcela'];

        $descontoParcela = Parcela::getDescontoParcela($contrato, $vlParcela1);

        if((float)$parcela["vl_parcela_2avia"] > 0 && !$parcela['desconto_2via'])
            $descontoParcela['vlDesconto'] = 0;

        $vlDesconto = str_pad(str_replace(array(".", ","), "", number_format($descontoParcela['vlDesconto'], 2)), 15, '0', STR_PAD_LEFT);

        $expressao = explode(";", $dados_layout_itens_linha3[0]['conteudo']); //Pega a linha conte�do e quebra a express�o regular

        ## SEGMENTO P (OBRIGATORIO)                                                     ##  NOME DO CAMPO                                       POSICAO    TAMANHO
        //$conteudo = $emp['cd_banco'];                                                   //  Codigo do banco                                     001 003     9(03)
        for ($i = 0; $i < count($expressao); $i++) {
            $expressao2 = explode(":", $expressao[$i]); //Quebra a express�o pegando a primeira palavra
            $posicaoi = explode("-", $expressao2[1]); //Quebra a express�o novamente pegando a coluna inicial
            $posicaof = explode("+", $posicaoi[1]); //Quebra a express�o novamente pegando a coluna final e o preenchimento
            $valorTipo = explode(".", $posicaof[1]); //Quebra a express�o novamente pegando a coluna final e o preenchimento
            $pinicial = $posicaoi[0] + 1; //Seta a coluna onde ser� inserida a informa��o no arquivo de remessa
            $pfinal = $posicaof[0] + 1; //Sete a coluna onde ser� finalizada a informa��o no arquivo de remessa
            $preencher = $posicaof[1]; //Obtem se � para completar ou preencher os valores e qual ser� o preenchimento

            if (strpos($expressao2[0], 'cdBanco') !== false) {
                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_banco'], $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_banco'], $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_banco'], $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_banco'], $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'nr_boleto') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'bancoCompensacao') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'tipoReg') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            //  Uso do fenabran
            if (strpos($expressao2[0], 'usoFebraban1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'agenciadvconta') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'agenciaRespDV') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia_dv"], $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia_dv"], $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia_dv"], $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia_dv"], $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'dtDescontoTitulo1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'lotServ') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrArquivo, $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrArquivo, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrArquivo, $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrArquivo, $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'regDetalhe') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'tipoDoc') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'valorTitulo1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($vl_parcela, $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($vl_parcela, $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($vl_parcela, $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($vl_parcela, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'cadTituloBanco') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($registro, $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($registro, $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($registro, $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($registro, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'numSeqLote') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($sequencial, $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($sequencial, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($sequencial, $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($sequencial, $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'codSegmento1') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'usoBanco1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoBanco2') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'codMov1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($codMovimento, $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($codMovimento, $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($codMovimento, $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($codMovimento, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'agenciaNR') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia"], $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia"], $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia"], $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia"], $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'complementoReg1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'complementoReg2') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'complementoReg3') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'agenciadvNR') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia_dv"], $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia_dv"], $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia_dv"], $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia_dv"], $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'cdCedente') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_cedente'], $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_cedente'], $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_cedente'], $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_cedente'], $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'usoBanco2') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'contaCorrenteNR') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente"], $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente"], $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente"], $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente"], $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'contaCorrenteDV') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['conta_corrente_dv'], $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente_dv"], $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente_dv"], $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente_dv"], $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'nossoNumero') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nossoNumero, $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nossoNumero, $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nossoNumero, $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nossoNumero, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'numdocCob') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["id_parcela_contrato"], $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["id_parcela_contrato"], $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["id_parcela_contrato"], $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["id_parcela_contrato"], $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'nr_boleto') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'usoBanco3') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'nNumeroBS') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = substr($nossoNumero, -9);
                    $valor = self::limit($valor, $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = substr($nossoNumero, -9);
                    $valor = self::limit($valor, $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = substr($nossoNumero, -9);
                    $valor = self::limit($valor, $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = substr($nossoNumero, -9);
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'carteiraNR') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($codCarteira, $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($codCarteira, $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($codCarteira, $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($codCarteira, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'cTituloBancoS') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'emissaoBloqueto1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            //Identificacao da distribuicao
            if (strpos($expressao2[0], 'idDistribuicao') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'usoBanco4') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }

            }

            //Vencimento da Prestacao
            if (strpos($expressao2[0], 'vencimentoP') !== false) {
                $valor = date("dmY", strtotime($parcela["dt_parcela"]));
                $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);

            }

            if (strpos($expressao2[0], 'valorP') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($vl_parcela, $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($vl_parcela, $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($vl_parcela, $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($vl_parcela, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'agenciaRespNR') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'especieTitulo') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'aceite1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'dtemissaoP') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;

                    $conteudo = substr_replace($conteudo, date("dmY"), $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;

                    $conteudo = substr_replace($conteudo, date("dmY"), $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;

                    $conteudo = substr_replace($conteudo, date("dmY"), $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;

                    $conteudo = substr_replace($conteudo, date("dmY"), $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'codjurosmora') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            //  Data do juros. branco = data vencimento
            if (strpos($expressao2[0], 'dtjurosBanco') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = date("dmY", strtotime($parcela["dt_parcela"]));
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = date("dmY", strtotime($parcela["dt_parcela"]));
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = date("dmY", strtotime($parcela["dt_parcela"]));
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = date("dmY", strtotime($parcela["dt_parcela"]));
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            //  Data do juros. branco = data vencimento - Banco SICOOB
            if (strpos($expressao2[0], 'dtjurosBSICOOB') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = date("dmY", strtotime($parcela["dt_parcela"] . ' + 1 days'));
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = date("dmY", strtotime($parcela["dt_parcela"] . ' + 1 days'));
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = date("dmY", strtotime($parcela["dt_parcela"] . ' + 1 days'));
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = date("dmY", strtotime($parcela["dt_parcela"] . ' + 1 days'));
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            //  Juros por dia
            if (strpos($expressao2[0], 'jurosDia') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($juros, $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($juros, $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($juros, $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($juros, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            // C�digo do Desconto
            if (strpos($expressao2[0], 'codDesconto') !== false) {

                if ($descontoParcela['flDesconto'] != 'S' && (float)$descontoParcela['vlDesconto'] > 0) {
                    $conteudo = substr_replace($conteudo, '1', $pinicial, 0);
                } else {
                    $conteudo = substr_replace($conteudo, '0', $pinicial, 0);
                }
            }

            //Data do Desconto
            if (strpos($expressao2[0], 'dataDesconto') !== false) {
                if ($descontoParcela['flDesconto'] != 'S' && (float)$descontoParcela['vlDesconto'] > 0) {
                    $valor = date("dmY", strtotime($parcela["dt_parcela"]));
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                } else {
                    $valor = self::complementoRegistro(8, "zeros");
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }
            }
            //  Valor do desconto
            if (strpos($expressao2[0], 'valorDesconto') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($vlDesconto, $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($vlDesconto, $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($vlDesconto, $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($vlDesconto, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            //  Valor do IOF a pagar
            if (strpos($expressao2[0], 'valorIOF') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            //  Valor do abatimento
            if (strpos($expressao2[0], 'valorAbatimento') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'tituloEmpresa') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            //  Codigo de identificacao da parcela na empresa
            if (strpos($expressao2[0], 'codIdParcela') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["id_parcela_contrato"], $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["id_parcela_contrato"], $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["id_parcela_contrato"], $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["id_parcela_contrato"], $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            //  Codigo para protesto
            if (strpos($expressao2[0], 'codProtesto') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            //  N�mero de dias para protesto
            if (strpos($expressao2[0], 'numDiasProtesto') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            // Codigo de Baixa do boleto (2 = nao baixar)
            if (strpos($expressao2[0], 'codBaixaB') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            //  Numero de dias para baixa
            if (strpos($expressao2[0], 'numDiasBaixa') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($dias_permanencia, $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($dias_permanencia, $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($dias_permanencia, $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($dias_permanencia, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            //  Codigo da moeda
            if (strpos($expressao2[0], 'codMoeda') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }

            //  Numero identificador do contrato na empresa
            if (strpos($expressao2[0], 'numContratoEmp') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }


            //  Uso do fenabran
            if (strpos($expressao2[0], 'usoFebraban2') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            //  Uso do fenabran
            if (strpos($expressao2[0], 'usoFebraban3') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }


            //  Uso do febrabran
            if (strpos($expressao2[0], 'remFebraban') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);

                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
        }

        $conteudo .= chr(13) . chr(10);                                                 //  essa e a quebra de linha

        $sequencial++;

        //Impress�o da Linha R
        $cep = self::retirar_caracteres_especiais($parcela['nr_cep']);
        $nrCep = substr($cep, 0, 5);
        $sufixoCep = substr($cep, 5, 3);

        $expressao = explode(";", $dados_layout_itens_linha4[0]['conteudo']); //Pega a linha conte�do e quebra a express�o regular

        for ($i = 0; $i < count($expressao); $i++) {

            $expressao2 = explode(":", $expressao[$i]); //Quebra a express�o pegando a primeira palavra
            $posicaoi = explode("-", $expressao2[1]); //Quebra a express�o novamente pegando a coluna inicial
            $posicaof = explode("+", $posicaoi[1]); //Quebra a express�o novamente pegando a coluna final e o preenchimento
            $valorTipo = explode(".", $posicaof[1]); //Quebra a express�o novamente pegando a coluna final e o preenchimento
            $pinicial = $posicaoi[0] + 1; //Seta a coluna onde ser� inserida a informa��o no arquivo de remessa
            $pfinal = $posicaof[0] + 1; //Sete a coluna onde ser� finalizada a informa��o no arquivo de remessa
            $preencher = $posicaof[1]; //Obtem se � para completar ou preencher os valores e qual ser� o preenchimento

            if (strpos($expressao2[0], 'cdBanco') !== false) {
                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_banco'], $limite, "zeros",true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }
                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_banco'], $limite, "zeros",false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_banco'], $limite, "brancos",true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_banco'], $limite, "brancos",false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'jurosDia') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($juros, $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($juros, $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($juros, $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($juros, $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'valorMulta') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($multa, $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($multa, $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($multa, $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($multa, $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'nr_boleto') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'lotServ') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrArquivo, $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrArquivo, $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrArquivo, $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrArquivo, $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'tipoReg') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'regDetalhe') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'numSeqLote') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($sequencial, $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($sequencial, $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($sequencial, $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($sequencial, $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'agenciadvconta') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'agenciaRespDV') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia_dv"], $limite, "brancos",true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia_dv"], $limite, "brancos",false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia_dv"], $limite, "zeros",true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia_dv"], $limite, "zeros",false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'codSegmento1') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'excCNAB1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoBanco1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'codMov1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($codMovimento, $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($codMovimento, $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($codMovimento, $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($codMovimento, $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }
            //  Tipo de inscricao do Sacado
            if (strpos($expressao2[0], 'tipoSacado') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($tipoRegistro, $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($tipoRegistro, $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($tipoRegistro, $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($tipoRegistro, $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }
            //  Numero de inscricao do Sacado
            if (strpos($expressao2[0], 'inscSacado') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($cpfCnpj, $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($cpfCnpj, $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($cpfCnpj, $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($cpfCnpj, $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }
            //  Nome do Sacado
            if (strpos($expressao2[0], 'nomeSacado') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(strtoupper(Helper::removeCaracteresEspeciais($parcela['nm_pessoa'])), $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(strtoupper(Helper::removeCaracteresEspeciais($parcela['nm_pessoa'])), $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(strtoupper(Helper::removeCaracteresEspeciais($parcela['nm_pessoa'])), $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(strtoupper(Helper::removeCaracteresEspeciais($parcela['nm_pessoa'])), $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }
            //  Bairro do Sacado
            if (strpos($expressao2[0], 'bairroSacado') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(Helper::removeCaracteresEspeciais($parcela['nm_bairro']), $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(Helper::removeCaracteresEspeciais($parcela['nm_bairro']), $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(Helper::removeCaracteresEspeciais($parcela['nm_bairro']), $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(Helper::removeCaracteresEspeciais($parcela['nm_bairro']), $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }
            //  Endere�o do Sacado
            if (strpos($expressao2[0], 'enderecoSacado') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(strtoupper(Helper::removeCaracteresEspeciais($parcela['endereco'])), $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(strtoupper(Helper::removeCaracteresEspeciais($parcela['endereco'])), $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(strtoupper(Helper::removeCaracteresEspeciais($parcela['endereco'])), $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(strtoupper(Helper::removeCaracteresEspeciais($parcela['endereco'])), $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }
            //  CEP do Sacado
            if (strpos($expressao2[0], 'cepSacado') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrCep, $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrCep, $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrCep, $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrCep, $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }

            //  Sufixo do Cep do sacado
            if (strpos($expressao2[0], 'cepSufixo') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($sufixoCep, $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($sufixoCep, $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($sufixoCep, $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($sufixoCep, $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }

            //  Nome da Cidade do Sacado
            if (strpos($expressao2[0], 'cidadeSacado') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(strtoupper(Helper::removeCaracteresEspeciais($parcela['cidade'])), $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(strtoupper(Helper::removeCaracteresEspeciais($parcela['cidade'])), $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(strtoupper(Helper::removeCaracteresEspeciais($parcela['cidade'])), $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(strtoupper(Helper::removeCaracteresEspeciais($parcela['cidade'])), $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }

            //  Uf do Sacado
            if (strpos($expressao2[0], 'estadoSacado') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela['uf'], $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela['uf'], $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela['uf'], $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela['uf'], $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }

            //  Tipo de inscricao do pagador (se diferente)
            if (strpos($expressao2[0], 'tipoInscPag') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }

            //  N�mero do Documento do pagador
            if (strpos($expressao2[0], 'numDocPag') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }

            //  Nome do pagador
            if (strpos($expressao2[0], 'nomePag') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }

            //  Codigo do Banco Correspondente na Compensacao
            if (strpos($expressao2[0], 'codBancoCompensacao') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }

            //  Nosso Nr no Banco Correspondente
            if (strpos($expressao2[0], 'numBancoCorrespondente') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }

            //Uso do Banco
            if (strpos($expressao2[0], 'usoBanco2') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }

            }
            if (strpos($expressao2[0], 'usoBanco3') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }

            }
            if (strpos($expressao2[0], 'usoBanco4') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }

            }
            if (strpos($expressao2[0], 'usoBanco5') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }

            }
            if (strpos($expressao2[0], 'usoFebraban1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoFebraban2') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoFebraban3') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros", true);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo1 = substr_replace($conteudo1, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo1 = substr_replace($conteudo1, $valorTipo[1], $pinicial, 0);
                }
            }

        }

        $sequencial++;

        // Concatena a linha P com a linha Q

        $conteudo1 .= chr(13) . chr(10); //  quebra de linha

        $conteudo .= $conteudo1;

        $expressao = explode(";", $dados_layout_itens_linha5[0]['conteudo']); //Pega a linha conte�do e quebra a express�o regular

        for ($i = 0; $i < count($expressao); $i++) {
            $expressao2 = explode(":", $expressao[$i]); //Quebra a express�o pegando a primeira palavra
            $posicaoi = explode("-", $expressao2[1]); //Quebra a express�o novamente pegando a coluna inicial
            $posicaof = explode("+", $posicaoi[1]); //Quebra a express�o novamente pegando a coluna final e o preenchimento
            $valorTipo = explode(".", $posicaof[1]); //Quebra a express�o novamente pegando a coluna final e o preenchimento
            $pinicial = $posicaoi[0] + 1; //Seta a coluna onde ser� inserida a informa��o no arquivo de remessa
            $pfinal = $posicaof[0] + 1; //Sete a coluna onde ser� finalizada a informa��o no arquivo de remessa
            $preencher = $posicaof[1]; //Obtem se � para completar ou preencher os valores e qual ser� o preenchimento

            if (strpos($expressao2[0], 'cdBanco') !== false) {
                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_banco'], $limite, "zeros",true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }
                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_banco'], $limite, "zeros",false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_banco'], $limite, "brancos",true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['cd_banco'], $limite, "brancos",false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'nr_boleto') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "brancos", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "brancos", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "zeros", true);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($parcela["nr_parcela"], $limite, "zeros", false);
                    $conteudo = substr_replace($conteudo, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo = substr_replace($conteudo, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'lotServ') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrArquivo, $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrArquivo, $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrArquivo, $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($nrArquivo, $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'tipoReg') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'regDetalhe') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'numSeqLote') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($sequencial, $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($sequencial, $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($sequencial, $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($sequencial, $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'codSegmento1') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'contaCorrenteDV') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['conta_corrente_dv'], $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente_dv"], $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente_dv"], $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente_dv"], $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'excCNAB1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoBanco1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'codMov1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($codMovimento, $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($codMovimento, $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($codMovimento, $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($codMovimento, $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'codDesconto') !== false) {

                if ($descontoParcela['flDesconto'] != 'S' && (float)$descontoParcela['vlDesconto'] > 0) {
                    $conteudo2 = substr_replace($conteudo2, '1', $pinicial, 0);
                } else {

                    $conteudo2 = substr_replace($conteudo2, '0', $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoBanco2') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'dataDesconto1') !== false) {
                if ($descontoParcela['flDesconto'] != 'S' && (float)$descontoParcela['vlDesconto'] > 0) {
                    $valor = date("dmY", strtotime($parcela["dt_parcela"]));
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                } else {
                    $valor = self::complementoRegistro(8, "zeros");
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'dataDesconto2') !== false) {
                if ($descontoParcela['flDesconto'] != 'S' && (float)$descontoParcela['vlDesconto'] > 0) {
                    $valor = date("dmY", strtotime($parcela["dt_parcela"]));
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                } else {
                    $valor = self::complementoRegistro(8, "zeros");
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'valorDesconto1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($vlDesconto, $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($vlDesconto, $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($vlDesconto, $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($vlDesconto, $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoBanco3') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            //  Tipo de Desconto2 do titulo
            if (strpos($expressao2[0], 'tipoDesconto1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            //  Data do desconto2 do titulo
            if (strpos($expressao2[0], 'dtDescontoTitulo1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }

            //  Valor do desconto2 do titulo
            if (strpos($expressao2[0], 'valorDescontoTitulo1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }

            //  Tipo de Desconto2 do titulo
            if (strpos($expressao2[0], 'tipoDesconto2') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }

            //  Data do desconto2 do titulo
            if (strpos($expressao2[0], 'dtDescontoTitulo2') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }

            //  Valor do desconto2 do titulo
            if (strpos($expressao2[0], 'valorDescontoTitulo2') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }

            //Tipo da Multa
            if (strpos($expressao2[0], 'tipoMulta') !== false) {
                if ($emp["tp_multa"] == 'P') {
                    $conteudo2 = substr_replace($conteudo2, '2', $pinicial, 0);
                } elseif ($emp["tp_multa"] == 'V') {
                    $conteudo2 = substr_replace($conteudo2, '1', $pinicial, 0);
                } else {
                    $conteudo2 = substr_replace($conteudo2, '0', $pinicial, 0);
                }
                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }

            //Data da Multa
            if (strpos($expressao2[0], 'dataMulta') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(date("dmY", strtotime($parcela["dt_parcela"])), $limite, "zeros",true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(date("dmY", strtotime($parcela["dt_parcela"])), $limite, "zeros",false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(date("dmY", strtotime($parcela["dt_parcela"])), $limite, "zeros",true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(date("dmY", strtotime($parcela["dt_parcela"])), $limite, "zeros",false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }

            }

            //Data da Multa Banco SICOOB
            if (strpos($expressao2[0], 'dtMultaSICOOB') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(date("dmY", strtotime($parcela["dt_parcela"] . ' + 1 days')), $limite, "zeros",true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(date("dmY", strtotime($parcela["dt_parcela"] . ' + 1 days')), $limite, "zeros",false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(date("dmY", strtotime($parcela["dt_parcela"] . ' + 1 days')), $limite, "zeros",true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(date("dmY", strtotime($parcela["dt_parcela"] . ' + 1 days')),$limite, "zeros",false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }

            //Valor da Multa
            if (strpos($expressao2[0], 'valorMulta') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($multa, $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($multa, $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($multa, $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($multa, $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }

            //Informa��es do Pagador
            if (strpos($expressao2[0], 'infoPagador') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'nomeSacado') !== false) {

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(strtoupper(Helper::removeCaracteresEspeciais($parcela['nm_pessoa'])), $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(strtoupper(Helper::removeCaracteresEspeciais($parcela['nm_pessoa'])), $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(strtoupper(Helper::removeCaracteresEspeciais($parcela['nm_pessoa'])), $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit(strtoupper(Helper::removeCaracteresEspeciais($parcela['nm_pessoa'])), $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'mensageNR1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'mensageNR2') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }

            //Uso exclusivo FEBRABAN/CNAB
            if (strpos($expressao2[0], 'remFebraban') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",true);
                    $conteud2o = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }

            if (strpos($expressao2[0], 'avisoDebAut') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'agenciadvconta') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos",false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros",false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }

            //23  Uso do fenabran
            if (strpos($expressao2[0], 'usoFebraban1') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoFebraban2') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoFebraban3') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'ocorrenciaSacado') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'codBancoCompensacao') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'agenciaRespNR') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'agenciaRespDV') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'contaCorrenteNR') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente"], $limite, "brancos",true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente"], $limite, "brancos",false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente"], $limite, "zeros",true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente"], $limite, "zeros",false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'agenciaNR') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia"], $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia"], $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia"], $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["agencia"], $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'contaCorrenteDV') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp['conta_corrente_dv'], $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente_dv"], $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente_dv"], $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($emp["conta_corrente_dv"], $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
            if (strpos($expressao2[0], 'usoBanco5') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "brancos", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", true);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit('', $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }
                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }

            }
            //Email do Pagador
            if (strpos($expressao2[0], 'emailPagador') !== false) {

                if (strpos($preencher, 'NE') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'ND') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0E') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, '0D') !== false) {
                    $limite = $pfinal - $pinicial;
                    $limite = $limite + 1;
                    $valor = self::limit($valor, $limite, "zeros", false);
                    $conteudo2 = substr_replace($conteudo2, $valor, $pinicial, 0);
                }

                if (strpos($preencher, 'V') !== false) {
                    $conteudo2 = substr_replace($conteudo2, $valorTipo[1], $pinicial, 0);
                }
            }
        }

        // Impress�o do Segmento R

        $conteudo2 .= chr(13) . chr(10); //  quebra de linha

        $conteudo .=$conteudo2;

        return $conteudo;
    }

    /**
     * * Funcao que gera o registro detalhe utilizando os dados de empreendimento e dos contratos e parcelas
     * @param string $codMovimento
     * @param array $emp
     * @param array $parcelas
     * @param int $nrArquivo
     * @param $idContrato
     * @return mixed
     */
    public static function gerarDetalhe($codMovimento, $emp, $parcelas, $nrArquivo, $idContrato)
    {
        $contrato = Contrato::findContratoById($idContrato);

        //Verifica se existem parcelas e contrato
        if (count($parcelas) == 0 || !$contrato)
            return false;

        //Dados para geracao
        $empresa = strtoupper(self::retirar_caracteres_especiais($emp["nm_cedente"]));
        $cnpjCpfCedente = ($emp["cnpj_cedente"])?$emp["cnpj_cedente"]:$emp["cpf_cedente"];

        //apenas para caixa verifica se e pessoa fisica ou juridica e seta 1 ou 2, para outros bancos, seta 2
        $tpInscricao = '2';
        if ($emp['cd_banco'] == '104' || $emp['cd_banco'] == '756') { //Registro complementar para caixa economica
            $tpInscricao = ($emp["cnpj_cedente"])?'2':'1';
        }

        $codEmpresa = str_replace(array(".", "/", "-"), "", $cnpjCpfCedente);
        $cpfCnpj = (in_array($contrato["tp_pessoa"], array('F', 'C'))) ? str_replace(array(".", "/", "-"), "", $contrato["nr_cpf"]) : str_replace(array(".", "/", "-"), "", $contrato["nr_cnpj"]);
        $tipoRegistro = in_array($contrato["tp_pessoa"], array('F', 'C')) ? '1' : '2';
        $codCarteira = self::verificaCodigoCarteira($emp['cd_banco'], $emp['carteira']);
        $dtContrato = str_replace("/", "", Helper::getDate($contrato["dt_contrato"]));

        $conteudo = $emp['cd_banco'];                                                   //  Codigo banco                                        001 003     9(03)
        $conteudo .= self::sequencial($nrArquivo, 4);                                   //  Lote                   Lote de servico              004 007     9(04)
        $conteudo .= '1';                                                               //  Registro header do lote                             008 008     9(01)
        $conteudo .= 'R';                                                               //  Tipo de operacao                                    009 009     X(01)
        $conteudo .= '01';                                                          //  Tipo de servico                                     010 011     9(02)
        if (in_array($emp['cd_banco'], ['237', '341', '756', '037'])) {
            $conteudo .= '  ';                                                          //  Uso exclusivo Febraban                              012 013     X(02)
        } else {
            $conteudo .= '00';                                                          //  Uso exclusivo Febraban                              012 013     9(02)
        }
        $conteudo .= self::versionamentoLayout($emp['cd_banco'], $emp['cd_cedente'])['lote'];               //  nr da versao do layout do lote                      014 016     9(03)
        $conteudo .= ' ';                                                               //  Uso exclusivo do fenabran                           017 017     X(01)
        $conteudo .= $tpInscricao;                                                       //  Tipo de inscricao do empreendimento 2 = CNPJ        018 018     9(01)
        $conteudo .= self::limit($codEmpresa, 15, "zeros");                             //  nr de inscricao do empreendimento                   019 033     9(15)
        if ($emp['cd_banco'] == '104') { //Registro complementar para caixa economica

            if (strlen($emp['cd_cedente']) < 7) {
                $conteudo .= self::limit($emp['cd_cedente'], 6, "zeros");                   //  11.1 Codigo do cedente do empreendimento                 034 039     9(06)
                $conteudo .= self::complementoRegistro(14, "zeros");                        //  11.1A Uso exclusivo da caixa                              040 053     9(14)
            } else {
                $conteudo .= self::limit($emp['cd_cedente'], 7, "zeros");                   //  11.1 Codigo do cedente do empreendimento                 034 039     9(06)
                $conteudo .= self::complementoRegistro(13, "zeros");                        //  11.1A Uso exclusivo da caixa                              040 053     9(13)
            }


        } elseif ($emp['cd_banco'] == '001') {
            $conteudo .= self::limit($emp['cd_cedente'], 9, "zeros");                   //  Codigo do cedente do empreendimento                 034 042     9(09)
            $conteudo .= '0014';                                                        //  Codigo 0014 para cobranca cedente                   043 046     9(04)
            $conteudo .= self::limit($emp['carteira'], 2, "zeros");                     //  Codigo da carteira                                  047 048     9(02)
            $conteudo .= self::limit($emp['carteira_variacao'], 3, "zeros");            //  Codigo de variacao da carteira (019 padrao)         049 051     9(03)
            $conteudo .= self::complementoRegistro(2, "brancos");                       //  Uso exclusivo do banco                              052 053     9(02)
        } elseif ($emp['cd_banco'] == '237') {
            $conteudo .= self::limit($emp['cd_cedente'], 20, "zeros", true);            //  Codigo do convenio do cedente                       034 053     9(20)
        } elseif ($emp['cd_banco'] == Banco::BANCO_SAFRA) {
            $conteudo .= self::limit($emp['cd_cedente'], 20, "zeros");           //  Codigo do convenio do cedente                       034 053     9(20)
        } elseif ($emp['cd_banco'] == Banco::BANCO_BANPARA) {
            $conteudo .= self::limit($emp['cd_cedente'], 20, "brancos");           //  Codigo do convenio do cedente                       034 053     9(20)
        } elseif ($emp['cd_banco'] == '004') {                                         // Banco do Nordeste
            $conteudo .= self::complementoRegistro(20, "zeros");            // Uso exclusivo do banco                      034 053     9(20)
        } else {
            $conteudo .= self::complementoRegistro(20, "brancos");                      //  Uso exclusivo do banco                              034 053     X(20)
        }

        $conteudo .= self::limit($emp["agencia"], 5, "zeros");                          //  Agencia                                             054 058     9(05)
        if ($emp['cd_banco'] == '341')  //Banco Itau
            $conteudo .= self::complementoRegistro(1, "brancos");                       // Complemento de registro                              059 059     X(01)
        elseif ($emp['cd_banco'] == '748')  //Banco Sicredi
            $conteudo .= ($emp["agencia_dv"])?$emp["agencia_dv"]:' ';                   //  Digito verificador da agencia                       059 059     9(01)
        else
            $conteudo .= self::limit($emp["agencia_dv"], 1, "zeros");                   //  Digito verificador da agencia                       059 059     9(01)

        if ($emp['cd_banco'] == '104') { //Codicional se e caixa economica incluindo registro especifico

            if (strlen($emp['cd_cedente']) < 7) {
                $conteudo .= self::limit($emp['cd_cedente'], 6, "zeros");                   //  Codigo do convenio                                  060 065     9(06)
                $conteudo .= self::complementoRegistro(8, "zeros");                         //  Uso exclusivo da banco                              066 073     9(08)
            } else {
                $conteudo .= self::limit($emp['cd_cedente'], 7, "zeros");                   //  Codigo do convenio                                  060 065     9(06)
                $conteudo .= self::complementoRegistro(7, "zeros");                         //  Uso exclusivo da banco                              066 073     9(08)
            }


        } else {
            $conteudo .= self::limit($emp['conta_corrente'], 12, "zeros");              // Conta corrente                                       060 071     9(12)
            if ($emp['cd_banco'] == '341')  //Banco Itau
                $conteudo .= self::complementoRegistro(1, "brancos");                   // Complemento de registro                              072 072     X(01)
            else
                $conteudo .= self::limit($emp['conta_corrente_dv'], 1, "zeros");        // Digito verificador da Conta corrente                 072 072     9(01)
            if ($emp['cd_banco'] == '237' || $emp['cd_banco'] == '756')                 //Condicional do bradesco e Sicoob
                $conteudo .= self::complementoRegistro(1, "brancos");                   // Digito do banco (padrao brancos bradesco)            073 073     X(01)
            elseif ($emp['cd_banco'] == '341')
                $conteudo .= self::limit($emp['conta_corrente_dv'], 1, "brancos");      // Digito do banco (padrao brancos itau)                073 073     X(01)
            else
                $conteudo .= self::complementoRegistro(1, "zeros");                     // Digito do banco (padrao 0)                           073 073     9(01)
        }
        $conteudo .= self::limit($empresa, 30, "brancos");                              //  Nome da empresa                                     074 103     9(30)
        if ($emp['cd_banco'] == '756') { //Sicoob
            $conteudo .= self::complementoRegistro(80, "brancos");                          //  Mesangem 1 e Mensagem 2                         104 183     9(40)
        } else {
            //Dados da mensagem de impressao (dados do loteamento)
            $conteudo .= (in_array($contrato["tp_pessoa"], array('F', 'C'))) ? '1' : '2';   //  Tipo de pessoa 1 = Fisica 2 = Juridica          104 104     9(01)
            $conteudo .= self::limit($cpfCnpj, 15, "zeros");                                //  Cpf ou cnpj do comprador                        105 119     9(15)
            $conteudo .= self::limit($contrato["quadra"], 10, "brancos");                   //  Quadra                                          120 129     X(10)
            $conteudo .= self::limit($contrato["id_lote"], 10, "brancos");                  //  Numero da unidade                               130 139     X(10)
            $conteudo .= '5';                                                               //  Tipo de imovel 5 = outros                       140 140     9(01)
            $conteudo .= '5';                                                               //  Tipo da unidade 5 = outros                      141 141     X(01)
            $conteudo .= self::complementoRegistro(10, "brancos");                          //  Area util                                       142 151     9(06)
            $conteudo .= self::limit($dtContrato, 8, 'zeros');                              //  Data do contrato                                152 160     9(08)
            $conteudo .= '2';                                                               //  Contrato subrogado 2 = nao                      161 161     9(01)
            $conteudo .= self::complementoRegistro(8, "zeros");                             //  Data da ultima subrogacao                       162 169     9(08)
            $conteudo .= self::limit($contrato["prazo_finan"], 3, "zeros");                 //  Prazo de financiamento total                    170 172     9(03)
            $conteudo .= '07';                                                              //  Tipo de atualizacao de parcela                  173 174     9(02)
            $conteudo .= self::complementoRegistro(10, "brancos");                          //  Caracteres extras da mensagem                   175 183     9(10)
        }
        $conteudo .= self::limit($emp['idRemessa'], 8, "zeros");                        //  Numero de remessa (sequencial)                      184 191     9(08)
        $conteudo .= date("dmY");                                                       //  Data de gravacao da remessa                         192 199     9(08)
        $conteudo .= self::complementoRegistro(8, "zeros");                             //  Data do credito (apenas para retorno)               200 207     9(08)
        $conteudo .= self::complementoRegistro(33, "brancos");                          //  Uso exclusivo do CNAB                               208 240     9(33)
        $conteudo .= chr(13) . chr(10);                                                 //  quebra de linha

        $vl_total = 0.00;
        $sequencial = 1;
        foreach ($parcelas as $k => $parcela) {
            $vl_parcela = str_pad(str_replace(array(".", ","), "", number_format($parcela["vl_parcela"], 2)), 15, '0', STR_PAD_LEFT);
            //Condicao criaca para que essa alteracao do tipo de juros/multa sendo porcentagem/fixo seja apenas para CEF por enquanto
            $registro = 1;
            if ($emp["tp_juros"] != 'S') {
                $juros = ($emp["tp_juros"] == 'P') ? (float)$emp["juros"] * (float)$parcela["vl_parcela"] / 100 : $emp["juros"];
            } else {
                $juros = 0;
            }
            $juros = str_replace(array(".", ","), "", number_format($juros, 2));
            $multa = str_replace(array(".", ","), "", number_format($emp["multa"], 2));
            $vl_total += $vl_parcela;
            if ($emp['cd_banco'] == '237')
                if ($tipoRegistro == '1')
                    $cpfCnpj = substr($cpfCnpj, 0, 9) . '0000' . substr($cpfCnpj, 9, 3);
            $nossoNumero = self::geraNossoNumero($emp['cd_banco'], $parcela, $emp);
            $dias_permanencia = (isset($emp['qt_dias_permanencia']) && (int)$emp['qt_dias_permanencia'] > 5) ? $emp['qt_dias_permanencia'] : 90;

            $contrato['tp_parcela'] = $parcela['tp_parcela'];
            $contrato['dt_parcela'] = $parcela['dt_parcela'];

            $descontoParcela = Parcela::getDescontoParcela($contrato, $parcela['vl_parcela'] );

            if((float)$parcela['vl_parcela_2avia'] > 0 && !$parcela['desconto_2via'])
                $descontoParcela['vlDesconto'] = 0;
            $vlDesconto = str_pad(str_replace(array(".", ","), "", number_format($descontoParcela['vlDesconto'], 2)), 15, '0', STR_PAD_LEFT);


            ## SEGMENTO P (OBRIGATORIO)                                                 ##  NOME DO CAMPO                                       POSICAO    TAMANHO
            $conteudo .= $emp['cd_banco'];                                              //  Codigo do banco                                     001 003     9(03)
            $conteudo .= self::sequencial($nrArquivo, 4);                               //  Lote do servico                                     004 007     9(04)
            $conteudo .= '3';                                                           //  Registro detalhe                                    008 008     9(01)
            $conteudo .= self::sequencial($sequencial, 5);                              //  Numero sequencial do registro no lote               009 013     9(05)
            $conteudo .= 'P';                                                           //  Codigo do segmento                                  014 014     X(01)
            $conteudo .= ' ';                                                           //  Uso do banco                                        015 015     X(01)
            $conteudo .= $codMovimento;                                                 //  Codigo de movimentacao (Informado ao chamar funcao) 016 017     9(02)
            $conteudo .= self::limit($emp["agencia"], 5, "zeros");                      //  Agencia                                             018 022     9(05)
            if ($emp['cd_banco'] == '341')  //Banco Itau
                $conteudo .= self::complementoRegistro(1, "brancos");                   // Complemento de registro                          023 023        X(01)
            elseif ($emp['cd_banco'] == '748')  //Banco Sicredi
                $conteudo .= ($emp["agencia_dv"])?$emp["agencia_dv"]:' ';               //  Dv da agencia                                       023 023     9(01)
            else
                $conteudo .= self::limit($emp["agencia_dv"], 1, "zeros");               //  Dv da agencia                                       023 023     9(01)
            if ($emp['cd_banco'] == '104') { //Codicional se e caixa economica incluindo registro especifico

                if (strlen($emp['cd_cedente']) < 7) {
                    $conteudo .= self::limit($emp['cd_cedente'], 6, "zeros");               //10.3P Codigo do convenio do cedente                       024 029     9(06)
                    $conteudo .= self::complementoRegistro(8, "zeros");                     //11.3P Uso exclusivo da caixa                              030 037     9(08)
                } else {
                    $conteudo .= self::limit($emp['cd_cedente'], 7, "zeros");               //10.3P Codigo do convenio do cedente                       024 029     9(06)
                    $conteudo .= self::complementoRegistro(7, "zeros");                     //11.3P Uso exclusivo da caixa                              030 037     9(08)
                }
            } else {
                $conteudo .= self::limit($emp['conta_corrente'], 12, "zeros");          //  Conta corrente                                      024 035     9(12)
                if ($emp['cd_banco'] == '341')  //Banco Itau
                    $conteudo .= self::complementoRegistro(1, "brancos");               // Complemento de registro                          036 036        X(01)
                else
                    $conteudo .= self::limit($emp['conta_corrente_dv'], 1, "zeros");    //  Digito verificador da Conta corrente                036 036     9(01)
                if ($emp['cd_banco'] == '237' || $emp['cd_banco'] == '756')
                    $conteudo .= self::complementoRegistro(1, "brancos");               //  Digito do banco (padrao ' ')                        037 037     9(01)
                elseif ($emp['cd_banco'] == '341')
                    $conteudo .= self::limit($emp['conta_corrente_dv'], 1, "brancos");  // Digito do banco (padrao brancos itau)          037 037        X(01)
                elseif ($emp['cd_banco'] == Banco::BANCO_BANPARA)                                       //  Digito do banco                        037 037     9(01)
                    $conteudo .= self::limit($emp["agencia_dv"], 1, "zeros");
                else
                    $conteudo .= self::complementoRegistro(1, "zeros");                 //  Digito do banco (padrao 0)                          037 037     9(01)
            }
            if ($emp['cd_banco'] == '341') {
                $conteudo .= self::limit($nossoNumero, 20, "zeros");                    //  Identific. do titulo no banco                       038 057     9(20)
                $conteudo .= self::complementoRegistro(5, 'zeros');                     //  Complemento de registro                             058 062     9(01)
                $conteudo .= self::limit($parcela["id_parcela_contrato"], 10, "zeros"); //  Numero do documento de cobranca                     063 072     9(10)
                $conteudo .= self::complementoRegistro(5, "brancos");                   //  Reservado para uso do banco                         073 077     X(05)
            } else {
                if ($emp['cd_banco'] == Banco::BANCO_SAFRA) {                                    //  Identific. do titulo no banco                       038 057     9(20)
                    $conteudo .= substr($nossoNumero, -9); //  Identific. do titulo no banco                       038 057     9(20)
                    $conteudo .= self::complementoRegistro(11, "brancos");
                } elseif ($emp['cd_banco'] == Banco::BANCO_BANPARA){
                    $conteudo .= self::limit($nossoNumero, 20, "zeros");                        //  Identific. do titulo no banco                       038 057     9(20)
                }else {                                                                        //  Identific. do titulo no banco                       038 057     9(20)
                    $conteudo .= self::limit($nossoNumero, 20, "zeros");                        //  Identific. do titulo no banco                       038 057     9(20)
                }
                $conteudo .= $codCarteira;                                              //  Cd da carteira 1= cob. simples. 2= cob. caucionada  058 058     9(01)
                if ($emp['cd_banco'] == '756') { //Sicoob
                    $conteudo .= '0';                                                   //  Forma de cadastramento do titulo no banco           059 059     9(01)
                    $conteudo .= ' ';                                                   //  Tipo de documento                                   060 060     9(01)
                }  elseif ($emp['cd_banco'] == Banco::BANCO_BANPARA){
                    $conteudo .= '1';                                                       //  Tipo de documento  060 060     9(01)
                    $conteudo .= '1';                                                       //  Tipo de documento  060 060     9(01)
                } else {
                    $conteudo .= $registro;                                             //  Forma de cadastramento do titulo no banco           059 059     9(01)
                    $conteudo .= '2';                                                   //  Tipo de documento                                   060 060     9(01)
                }
                $conteudo .= '2';                                                       //  Emissao do bloqueto 2 = cliente emite               061 061     9(01)
                $conteudo .= ($emp['cd_banco'] == '104') ? '0' : '2';                           //  Identificacao da distribuicao 1 = Banco distribui   062 062     9(01)
                if ($emp['cd_banco'] == '756' || $emp['cd_banco'] == '004') { //Sicoob ou Banco Nordeste
                    $conteudo .= self::limit($parcela["id_parcela_contrato"], 15, "zeros");     //  Numero do documento de cobranca                     063 077     9(11)
                } else {
                    if ($emp['cd_banco'] == '748') {
                        $conteudo .= substr($parcela["nr_boleto"], -6);            //  Numero do documento de cobranca                     063 073     9(11)
                        $conteudo .= self::complementoRegistro(5, "zeros");     //  Numero do documento de cobranca                     063 073     9(11)
                    } elseif ($emp['cd_banco'] == Banco::BANCO_SAFRA){
                        $conteudo .= self::limit($parcela["id_parcela_contrato"], 10, "zeros");
                        $conteudo .= self::complementoRegistro(1, "brancos");
                    } else {
                        $conteudo .= self::limit($parcela["id_parcela_contrato"], 11, "zeros");     //  Numero do documento de cobranca                     063 073     9(11)
                    }
                    $conteudo .= self::complementoRegistro(4, "brancos");                       //  Reservado para uso do banco                         074 077     9(04)
                }                  //  Reservado para uso do banco                         074 077     9(04)
            }
            $conteudo .= date("dmY", strtotime($parcela["dt_parcela"]));                //  Vencimento da prestacao                             078 085     9(08)
            $conteudo .= $vl_parcela;                                                   //  Valor da prestacao                                  086 100     9(15)
            $conteudo .= self::complementoRegistro(5, "zeros");                         //  Agencia responsavel pela cobranca (USO DA CAIXA)    101 105     9(05)
            if ($emp['cd_banco'] == '756') { //Condicional do Sicoo
                $conteudo .= ' ';                                                       //  Digito verificador da agencia (USO DA CAIXA)        106 106     9(01)
            } else {
                $conteudo .= self::complementoRegistro(1, "zeros");                     //  Digito verificador da agencia (USO DA CAIXA)        106 106     9(01)
            }
            if ($emp['cd_banco'] == '001' || $emp['cd_banco'] == '756' || $emp['cd_banco'] == '004' || $emp['cd_banco'] == Banco::BANCO_BRADESCO || $emp['cd_banco'] == Banco::BANCO_CAIXA_ECONOMICA || $emp['cd_banco'] == Banco::BANCO_BANPARA || $emp['cd_banco'] == Banco::BANCO_SAFRA || $emp['cd_banco'] == Banco::BANCO_UNIPRIME) {  //  Especie do titulo (99 = outros)                     107 108     9(02)
                $conteudo .= '02';                                                      //  Especie do titulo (99 = outros)                     107 108     9(02)
            } elseif ($emp['cd_banco'] == '748' && $emp['especie_documento'] == 'DMI') {
                $conteudo .= '03';                                                      //  SOMENTE PARA O BANCO SICREDI. Especie do titulo (03 = DMI - Duplicata mercantil por indica��o)                     107 108     9(02) 
            } else {
                $conteudo .= '99';                                                      //  Especie do titulo (99 = outros)                     107 108     9(02)
            }
            $conteudo .= "N";                                                           //  Aceite A = Aceite N = Nao aceite                    109 109     X(01)
            $conteudo .= date("dmY");                                                   //  Data da emissao da parcela                          110 117     9(08)
            $conteudo .= "1";                                                           //  Cidigo do juros/mora (1 = diario)                   118 118     9(01)
            if (in_array($emp['cd_banco'], ['104', '422'])) { //Sicoob e Caixa
                $conteudo .= date("dmY", strtotime($parcela["dt_parcela"]));            //  Data do juros. branco = data vencimento             119 126     9(08)
            } elseif ($emp['cd_banco'] == '756') {
                $conteudo .= date("dmY", strtotime($parcela["dt_parcela"] . ' + 1 days'));  //  Data do juros, do Sicoob + 1 dia                119 126
            } else {
                $conteudo .= self::complementoRegistro(8, "zeros");                     //  Data do juros. branco = data vencimento             119 126     9(08)
            }
            $conteudo .= self::limit($juros, 15, "zeros");                              //  Juros por dia                                       127 141     9(13)
            if ($descontoParcela['flDesconto'] != 'S' && (float)$descontoParcela['vlDesconto'] > 0) {
                $conteudo .= "1";                                                       //  Codigo do desconto. 1 = valor 2 = percentual        142 142     9(01)
                $conteudo .= date("dmY", strtotime($parcela["dt_parcela"]));
            } else {
                $conteudo .= "0";                                                       //  Codigo do desconto. 1 = valor 2 = percentual        142 142     9(01)
                $conteudo .= self::complementoRegistro(8, "zeros");                     //  Data do desconto                                    143 150     9(08)
            }
            $conteudo .= $vlDesconto;                                                   //  Valor do desconto                                   151 165     9(13)
            $conteudo .= self::complementoRegistro(15, "zeros");                        //  Valor IOF a pagar                                   166 180     9(13)
            $conteudo .= self::complementoRegistro(15, "zeros");                        //  Valor do abatimento                                 181 195     9(13)
            if ($emp['cd_banco'] == '748') {
                $conteudo .= self::limit($parcela["nr_boleto"], 25, "zeros");     //  Codigo de identificacao da parcela na empresa       196 220     9(25)
            } else {
                $conteudo .= self::limit($parcela["id_parcela_contrato"], 25, "zeros");     //  Codigo de identificacao da parcela na empresa       196 220     9(25)
            }
            $conteudo .= "3";                                                           //  Codigo para protesto (3 = sem protesto)             221 221     9(01)
            $conteudo .= self::complementoRegistro(2, "zeros");                         //  Numero de dias para protesto                        222 223     9(02)
            if ($emp['cd_banco'] == '756') //Condicional do Sicoob
                $conteudo .= "0";                                                       //  Codigo de Baixa do boleto (2 = nao baixar)          224 224     9(01)
            else
                $conteudo .= "1";                                                       //  Codigo de Baixa do boleto (2 = nao baixar)          224 224     9(01)
            if ($emp['cd_banco'] == '341') { //ITAU
                $conteudo .= self::limit($dias_permanencia, 2, "zeros");                //  Numero de dias para baixa                           225 226     9(02)
                $conteudo .= '0';                                                       //  Numero de dias para baixa                           227 227     9(01)
            } elseif ($emp['cd_banco'] == '756') { //SICOOB
                $conteudo .= '   ';                                                     //  Numero de dias para baixa                           225 227     X(03)
            } else {
                $conteudo .= self::limit($dias_permanencia, 3, "zeros");                //  Numero de dias para baixa                           225 227     X(03)
            }
            $conteudo .= "09";                                                          //  Codigo da moeda (09 = real)                         228 229     9(02)
            $conteudo .= self::complementoRegistro(10, "zeros");                        //  Numero identificador do contrato na empresa         230 239     9(10)
            $conteudo .= self::complementoRegistro(1, "brancos");                       //  Uso exclusivo do FEBRABAN                           240 240     9(01)
            $conteudo .= chr(13) . chr(10);                                             //  essa e a quebra de linha

            $sequencial++;

            $cep = self::retirar_caracteres_especiais($parcela['nr_cep']);
            $nrCep = substr($cep, 0, 5);
            $sufixoCep = substr($cep, 5, 3);

            ## SEGMENTO Q (OBRIGATORIO)                                                 ##  NOME DO CAMPO                                       POSICAO    TAMANHO
            $conteudo .= $emp['cd_banco'];                                              //  Codigo do banco                                     001 003     9(03)
            $conteudo .= self::sequencial($nrArquivo, 4);                               //  Lote do servico                                     004 007     9(04)
            $conteudo .= '3';                                                           //  Registro detalhe                                    008 008     9(01)
            $conteudo .= self::sequencial($sequencial, 5);                              //  Numero sequencial do registro no lote               009 013     9(05)
            $conteudo .= 'Q';                                                           //  Codigo do segmento                                  014 014     X(01)
            $conteudo .= ' ';                                                           //  Uso do banco                                        015 015     X(01)
            $conteudo .= $codMovimento;                                                 //  Codigo de movimentacao (Informado ao chamar funcao) 016 017     9(02)
            $conteudo .= $tipoRegistro;                                                 //  Tipo de inscricao do Sacado                         018 018     9(01)
            $conteudo .= self::limit($cpfCnpj, 15, "zeros");                            //  Numero de inscricao do Sacado                       019 033     9(15)
            $conteudo .= self::limit($parcela['nm_pessoa'], 40, 'brancos');             //  Nome do Sacado                                      034 073     X(40)
            $conteudo .= self::limit($parcela['endereco'], 40, 'brancos');              //  Endereco do Sacado                                  074 113     X(40)
            $conteudo .= self::limit($parcela['nm_bairro'], 15, "brancos");             //  Bairro do Sacado                                    114 128     X(15)
            $conteudo .= self::limit($nrCep, 5, ($emp['cd_banco'] == '341') ? "zeros" : "brancos");  //  CEP do Sacado                                       129 133     9(05)
            $conteudo .= self::limit($sufixoCep, 3, ($emp['cd_banco'] == '341') ? "zeros" : "brancos");//  Sufixo do Cep do sacado                             134 136     9(03)
            $conteudo .= self::limit($parcela['cidade'], 15, "brancos");                //  Nome da Cidade do Sacado                            137 151     X(15)
            $conteudo .= self::limit($parcela['uf'], 2, "brancos");                     //  Uf do Sacado                                        152 153     X(02)
            $conteudo .= '0';                                                           //  Tipo de inscricao do pagador (se diferente)         154 154     9(01)
            if ($emp['cd_banco'] == Banco::BANCO_SICREDI) {
                $conteudo .= self::complementoRegistro(15, "brancos");                      //  Numero do documento do pagador (se diferente), SOMENTE PARA O SICREDI       155 169     9(15)
            } else {
                $conteudo .= self::complementoRegistro(15, "zeros");                        //  Numero do documento do pagador (se diferente)       155 169     9(15)
            }
            $conteudo .= self::complementoRegistro(40, "brancos");                      //  Nome do pagador (se diferente)                      170 209     X(40)
            if ($emp['cd_banco'] == '104'){                                                       //  Codigo do Banco Correspondente na Compensacao       210 212     9(03)
                $conteudo .= self::complementoRegistro(3, "brancos");                   // SE FOR CEF COLOCAR BRANCOS
            }else{
                $conteudo .= self::complementoRegistro(3, "zeros");                     // DEMAIS BANCOS, COLOCA ZERO!
            }
            $conteudo .= self::complementoRegistro(20, "brancos");                      //  Nosso Nr no Banco Correspondente                    213 232     X(20)
            $conteudo .= self::complementoRegistro(8, "brancos");                       //  Reservado para uso do banco                         233 240     X(08)
            $conteudo .= chr(13) . chr(10);                                             //  essa e a quebra de linha

            $sequencial++;

            ## SEGMENTO R (OPCIONAL)                                                    ##  NOME DO CAMPO                                       POSICAO    TAMANHO
            $conteudo .= $emp['cd_banco'];                                              //  Codigo do banco                                     001 003     9(03)
            $conteudo .= self::sequencial($nrArquivo, 4);                               //  Lote do servico                                     004 007     9(04)
            $conteudo .= '3';                                                           //  Registro detalhe                                    008 008     9(01)
            $conteudo .= self::sequencial($sequencial, 5);                              //  Numero sequencial do registro no lote               009 013     9(05)
            $conteudo .= 'R';                                                           //  Codigo do segmento                                  014 014     X(01)
            $conteudo .= ' ';                                                           //  Uso do banco                                        015 015     X(01)
            $conteudo .= $codMovimento;                                                 //  Codigo de movimentacao (Informado ao chamar funcao) 016 017     9(02)
            $conteudo .= '0';                                                           //  Tipo de Desconto2 do titulo                         018 018     9(01)
            $conteudo .= self::complementoRegistro(8, "zeros");                         //  Data do desconto2 do titulo                         019 026     9(08)
            $conteudo .= self::complementoRegistro(15, "zeros");                        //  Valor do desconto2 do titulo                        027 041     9(13)
            $conteudo .= '0';                                                           //  Tipo de Desconto3 do titulo                         042 042     9(01)
            $conteudo .= self::complementoRegistro(8, "zeros");                         //  Data do desconto3 do titulo                         043 050     9(08)
            $conteudo .= self::complementoRegistro(15, "zeros");                        //  Valor do desconto3 do titulo                        051 065     9(15)
            if ($emp['cd_banco'] == '748') { //Sicredi aceita apenas percentual
                $conteudo .= '2';                                                       //  Tipo de Multa (2 Percentual)                        066 066     9(01)
            } else {
                if ($emp["tp_multa"] == 'P') {
                    $conteudo .= '2';                                                   //  Tipo de Multa (0 sem multa/1 vlr fixo/2 Perc)       066 066     9(01)
                } elseif ($emp["tp_multa"] == 'V') {
                    $conteudo .= '1';                                                   //  Tipo de Multa (0 sem multa/1 vlr fixo/2 Perc)       066 066     9(01)
                } else {
                    $conteudo .= '0';                                                   //  Tipo de Multa (0 sem multa/1 vlr fixo/2 Perc)       066 066     9(01)
                }
            }
            if (in_array($emp['cd_banco'], ['104', '341','001','237','422'])) {
                $conteudo .= self::limit(date("dmY", strtotime($parcela["dt_parcela"])), 8, "zeros"); //Data da multa do titulo                 067 074     9(08)
            } elseif ($emp['cd_banco'] == '756') {
                $conteudo .= date("dmY", strtotime($parcela["dt_parcela"] . ' + 1 days'));  //  Data do multa, do Sicoob + 1 dia                067 074
            } else {
                $conteudo .= self::complementoRegistro(8, "zeros");                     //Data da multa do titulo                               067 074     9(08)
            }
            $conteudo .= self::limit($multa, 15, "zeros");                              //  Valor da multa do titulo (porcento)                 075 089     9(15)
            $conteudo .= self::complementoRegistro(10, "brancos");                      //  Informacoes do Pagador                              090 099     X(10)
            $conteudo .= self::complementoRegistro(40, "brancos");                      //  Mensagem nr 3                                       100 139     X(40)
            $conteudo .= self::complementoRegistro(40, "brancos");                      //  Mensagem nr 4                                       140 179     X(40)
            if (in_array($emp['cd_banco'], ['104', '341', '756'])) { //Condicional do Bradesco, Itau e Sicoob
                $conteudo .= self::complementoRegistro(20, "brancos");                  //  Uso Exclusivo FEBRABAN/CNAB                         180 199     X(20)
                $conteudo .= self::complementoRegistro(8, "zeros");                     //  Cod. Ocor. do Pagador                               200 207     9(08)
                $conteudo .= self::complementoRegistro(3, "zeros");                     //  Cod. do Banco na Conta do Debito                    208 210     9(03)
                $conteudo .= self::complementoRegistro(5, "zeros");                     //  Codigo da Agencia do Debito                         211 215     9(05)
                $conteudo .= self::complementoRegistro(1, "brancos");                   //  Digito Verificador da Agancia                       216 216     X(01)
                $conteudo .= self::complementoRegistro(12, "zeros");                    //  Conta Corrente para Debito                          217 228     9(12)
                $conteudo .= self::complementoRegistro(1, "brancos");                   //  Digito Verificador da Conta                         229 229     X(01)
                $conteudo .= self::complementoRegistro(1, "brancos");                   //  Digito Verificador Ag/Conta                         230 230     X(01)
                if ($emp['cd_banco'] == '237') { //Condicional do bradesco
                    $conteudo .= '2';                                                   //  Aviso para Dibito Automatico                        231 231     9(01)
                } else {
                    $conteudo .= self::complementoRegistro(1, "zeros");                 //  Aviso para Dibito Automatico                        231 231     9(01)
                }
                $conteudo .= self::complementoRegistro(9, "brancos");                   //  Uso Exclusivo FEBRABAN/CNAB                         232 240     X(09)
            } else {
                $conteudo .= self::complementoRegistro(50, "brancos");                  //  E-mail do pagador                                   180 229     X(50)
                $conteudo .= self::complementoRegistro(11, "brancos");                  //  Reservado para uso do banco                         231 240     X(11)
            }
            $conteudo .= chr(13) . chr(10);                                             //  quebra de linha

            $sequencial++;
        }
        $vl_total = number_format($vl_total, 2);
        $vl_total = str_replace(array(".", ","), "", $vl_total);

        ##  TRAILER DO LOTE (OBRIGATORIO) - REGISTRO 5
        #  NOME DO CAMPO                                                                #SIGNIFICADO                                            #POSICAO    #TAMANHO
        $conteudo .= $emp['cd_banco'];                                                  //  Codigo banco                                        001 003     9(03)
        $conteudo .= self::sequencial($nrArquivo, 4);                                   //  Lote                   Lote de servico            004 007     9(04)
        $conteudo .= '5';                                                               //  Registro trailer do lote                            008 008     9(01)
        $conteudo .= self::complementoRegistro(9, "brancos");                           //  Filler                                              009 017     X(09)
        $conteudo .= self::limit($sequencial + 1, 6, "zeros");                          //  Numero de registros no lote                        018 023     9(06)
        if ($emp['cd_banco'] == '237' || $emp['cd_banco'] == '748') { //Condicional do bradesco e sicredi
            $conteudo .= self::complementoRegistro(6, "zeros");                         //  Numero de titulos no lote                          024 029     9(06)
        } else {
            $conteudo .= self::limit(count($parcelas), 6, "zeros");                     //  Numero de titulos no lote                          024 029     9(06)
        }
        if ($emp['cd_banco'] == '748') { //SICREDI
            $conteudo .= self::complementoRegistro(17, "zeros");                               //  Valor total dos titulos no lote                     030 046     9(17)
        } else {
            $conteudo .= self::limit($vl_total, 17, "zeros");                               //  Valor total dos titulos no lote                     030 046     9(17)
        }
        $conteudo .= self::complementoRegistro(6, "zeros");                             //  Numero de titulos caucionados no lote              047 052     9(06)
        $conteudo .= self::complementoRegistro(17, "zeros");                            //  Valor total dos titulos caucionados no lote         053 069     9(17)
        $conteudo .= self::complementoRegistro(6, "zeros");                             //  Numero de titulos descontados no lote              070 075     9(06)
        $conteudo .= self::complementoRegistro(17, "zeros");                            //  Valor total dos titulos descontados no lote         076 092     9(17)
        if ($emp['cd_banco'] == '341' || $emp['cd_banco'] == '756' || $emp['cd_banco'] == Banco::BANCO_SAFRA) { //Condicional do Itau // ou Banco Sicob
            $conteudo .= self::complementoRegistro(6, "zeros");                         //  Uso exclusivo do banco                              093 098     9(06)
            $conteudo .= self::complementoRegistro(17, "zeros");                        //  Uso exclusivo do banco                              099 115     9(17)
            $conteudo .= self::complementoRegistro(8, "brancos");                       //  Uso exclusivo do banco                              116 123     9(08)
        }  else {
            $conteudo .= self::complementoRegistro(31, "brancos");                      //  Uso exclusivo do CNAB                               093 123     9(31)
        }
        $conteudo .= self::complementoRegistro(117, "brancos");                         //  Uso exclusivo do CNAB                               124 240     9(117)
        $conteudo .= chr(13) . chr(10);                                                 //  essa e a quebra de linha
        return $conteudo;
    }
}