<?php

/*
 * @descr: Gera o arquivo de remessa para cobranca no padrao CNAB 400 vers. 7.0 ITAU
 */

class RemessaBoletoCef extends Zend_Db_Table_Abstract
{

    protected $_name = TB_REMESSA;

    private function modulo_11($num, $base = 9, $r = 0)
    {

        $soma = 0;
        $fator = 2;

        /* Separacao dos numeros */
        for ($i = strlen($num); $i > 0; $i--) {
            // pega cada numero isoladamente
            $numeros[$i] = substr($num, $i - 1, 1);
            // Efetua multiplicacao do numero pelo fator
            $parcial[$i] = $numeros[$i] * $fator;
            // Soma dos digitos
            $soma += $parcial[$i];
            if ($fator == $base) {
                // restaura fator de multiplicacao para 2
                $fator = 1;
            }
            $fator++;
        }

        /* Calculo do modulo 11 */
        if ($r == 0) {
            $soma *= 10;
            $digito = $soma % 11;
            if ($digito == 10) {
                $digito = 0;
            }
            return $digito;
        } elseif ($r == 1) {
            $resto = $soma % 11;
            return $resto;
        }
    }

    private function limit($palavra, $limite, $comp = 'brancos')
    {
        $palavra = strtoupper(str_replace(array('�', '�'), '', Helper::removeAcentos($palavra, false)));
        if (strlen($palavra) >= $limite) {
            $var = substr($palavra, 0, $limite);
        } else {
            $max = (int)($limite - strlen($palavra));
            if ($comp == 'brancos') {
                $var = $palavra . $this->complementoRegistro($max, "brancos");
            } elseif ($comp == 'zeros') {
                $var = $this->complementoRegistro($max, "zeros") . $palavra;
            }
        }
        return $var;
    }

    private function sequencial($i, $length)
    {
        return str_pad($i, $length, 0, STR_PAD_LEFT);
    }

    private function zeros($min, $max)
    {
        $zeros = '';
        $x = ($max - strlen($min));
        for ($i = 0; $i < $x; $i++) {
            $zeros .= '0';
        }
        return $zeros . $min;
    }

    private function complementoRegistro($int, $tipo)
    {
        if ($tipo == "zeros") {
            $space = '';
            for ($i = 1; $i <= $int; $i++) {
                $space .= '0';
            }
        } else if ($tipo == "brancos") {
            $space = '';
            for ($i = 1; $i <= $int; $i++) {
                $space .= ' ';
            }
        }

        return $space;
    }

    private function formata_numero($numero, $loop, $insert, $tipo = "geral")
    {
        if ($tipo == "geral") {
            $numero = str_replace(",", "", $numero);
            while (strlen($numero) < $loop) {
                $numero = $insert . $numero;
            }
        }
        if ($tipo == "valor") {
            /*
              retira as virgulas
              formata o numero
              preenche com zeros
             */
            $numero = str_replace(",", "", $numero);
            while (strlen($numero) < $loop) {
                $numero = $insert . $numero;
            }
        }
        if ($tipo == "convenio") {
            while (strlen($numero) < $loop) {
                $numero = $numero . $insert;
            }
        }
        return $numero;
    }

    private function digitoVerificador_nossonumero($numero)
    {
        echo $numero;
        $resto2 = $this->modulo_11($numero, 7, 1);
        $digito = 11 - $resto2;
        if ($digito == 10) {
            $dv = "P";
        } elseif ($digito == 11) {
            $dv = 0;
        } else {
            $dv = $digito;
        }
        return $dv;
    }

    private function retirar_caracteres_especiais($string)
    {
        $palavra = Helper::removeAcentos($string);
        $palavranova = str_replace("_", " ", $palavra);
        return $palavranova;
    }

    /*
     * Função que gera o arquivo de remessa utilizando os dados de empreendimento e dos contratos e parcelas
     * @param array $emp, array $dados
     * @return string $msg (erro)
     */
    public function gerar($emp, $dados)
    {
        $nrArquivo = $dados['idRemessa'];

        //array de clientes
        $parcelas = $dados['parcelas'];

        //Registro de cobrança
        $registro = (isset($dados['registro']) && $dados['registro']=='1')?'1':'2';

        $fusohorario = 3;
        $timestamp = mktime(date("H") - $fusohorario, date("i"), date("s"), date("m"), date("d"), date("Y"));

        $cnpjCpfCedente = ($emp["cnpj_cedente"])?$emp["cnpj_cedente"]:$emp["cpf_cedente"];
        $codEmpresa = str_replace(array(".", "/", "-"), "", $cnpjCpfCedente);
        $empresa = strtoupper($this->retirar_caracteres_especiais($emp["nm_empreendimento"]));

        //Cria os diretorios para onde o arquivo vai ser gravado
        $path = explode('.',$_SERVER['HTTP_HOST']);
        if ($path[0] == 'www') {
            $path = $path[1];
        } else {
            $path = $path[0];
        }
        $filename = $dados['arquivo'];
        $filepath = DIRETORIO_DOWNLOAD . "remessas/" . $path;
        $pathAno = DIRETORIO_DOWNLOAD . "remessas/" . $path . '/' . date('Y');

        if (is_dir($filepath)) {
            if (!is_dir($pathAno)) mkdir($pathAno);
        } else {
            mkdir($filepath);
            mkdir($pathAno);
        }

        $conteudo = '';

        ##  HEADER DO ARQUIVO - REGISTRO 0
        #   NOME DO CAMPO           #SIGNIFICADO            #POSICAO       #PICTURE
        $conteudo .= Banco::BANCO_CAIXA_ECONOMICA;                                      //01  C�digo do banco    caixa 104                    001 003        9(03)
        $conteudo .= '0000';                                                            //02  Lote de servi�o                                 004 007        9(04)
        $conteudo .= '0';                                                               //03  Registro do header                              008 008        9(01)
        $conteudo .= $this->complementoRegistro(9, "brancos");                          //04  Uso exclusivo do banco                          009 017        9(09)
        $conteudo .= '2';                                                               //05  Tipo de inscricao da construtora                018 018        9(01)
        $conteudo .= $codEmpresa;                                                       //06  N�mero de inscri��o da construtora              019 032        9(14)
        $conteudo .= $this->complementoRegistro(20, "zeros");                           //07  Uso exclusivo da caixa                          033 052        9(04)
        $conteudo .= $this->limit($emp["agencia"], 5, "zeros");                         //08  Agencia                                         053 057        9(05)
        $conteudo .= $this->limit($emp["agencia_dv"], 1, "zeros");                      //09  Digito verificador da agencia ('0')             058 058        9(01)
        $conteudo .= $this->limit($emp['cd_cedente'], 6, "zeros");                      //10  C�digo do conv�nio                              059 064        9(12)
        $conteudo .= $this->complementoRegistro(8, "zeros");                            //11  Uso exclusivo da caixa                          065 072        9(08)
        $conteudo .= $this->limit($empresa, 30);                                        //12  Nome da construtora                             073 102        X(30)
        $conteudo .= $this->limit("CAIXA ECONOMICA FEDERAL", 30);                       //13  Nome do banco                                   103 132        X(30)
        $conteudo .= $this->complementoRegistro(10, "brancos");                         //14  Uso exclusivo da caixa                          133 142        9(10)
        $conteudo .= '1';                                                               //15  C�digo 1 = remessa; 2 = retorno                 143 143        9(01)
        $conteudo .= date("dmY");                                                       //16  Data de gera��o                                 144 151        9(08)
        $conteudo .= date("His");                                                       //17  Hora de gera��o de gera��o                      152 157        9(06)
        $conteudo .= "000001";                                                          //18  N�mero sequencial do arquivo                    158 163        9(06)
        $conteudo .= '050';                                                             //19  Layout do arquivo                               164 166        9(03)
        $conteudo .= '00000';                                                           //20  Densidade de grava��o do arquivo                167 171        9(05)
        $conteudo .= $this->complementoRegistro(20, "brancos");                         //21  Reservado caixa                                 172 191        9(20)
        $conteudo .= $this->complementoRegistro(20, "brancos");                         //22  Reservado empresa                               192 211        9(20)
        $conteudo .= $this->complementoRegistro(4, "zeros");                            //23  Vers�o do aplicativo CAIXA                      212 215        9(04)
        $conteudo .= $this->complementoRegistro(25, "brancos");                         //24  Uso do fenabran                                 232 239        9(08)
        $conteudo .= chr(13) . chr(10);                                                 // essa � a quebra de linha

        $i = 0; // contador de contratos
        $j = 0; // contador de parcelas

        foreach ($dados["contratosDasParcelas"] as $contrato) {
            $i++;

            $dadosContrato = Contrato::findContratoById(key($dados["contratosDasParcelas"]));
            $cpfCnpj = ($dadosContrato["tp_pessoa"] == 'F') ? str_replace(array(".", "/", "-"), "", $dadosContrato["nr_cpf"]) : str_replace(array(".", "/", "-"), "", $dadosContrato["nr_cnpj"]);
            $area = $this->limit(str_replace(".", "", number_format($dadosContrato["area"], 2)), 6, "zeros");
            $valor = $this->limit(str_replace(".", "", number_format($dadosContrato["valor"], 2)), 13, "zeros");
            $saldoDevedor = $this->limit(str_replace(".", "", number_format($contrato["saldo_devedor"], 2)), 13, "zeros");

            ##  HEADER DO LOTE (OBRIGATORIO) - REGISTRO 1
            #  NOME DO CAMPO                                                                #SIGNIFICADO                                            #POSICAO    #TAMANHO
            $conteudo .= '104';                                                             //  Codigo banco                                        001 003     9(03)
            $conteudo .= $this->sequencial($i, 4);                                          //  Lote                   Lote de servi�o              004 007     9(04)
            $conteudo .= '1';                                                               //  Registro header do lote                             008 008     9(01)
            $conteudo .= 'R';                                                               //  Tipo de opera��o                                    009 009     X(01)
            $conteudo .= '0'.$registro;                                                     //  Tipo de servi�o                                     010 011     9(02)
            $conteudo .= '00';                                                              //  Forma de Lan�amento                                 012 013     9(02)
            $conteudo .= '030';                                                             //  n� da vers�o do layout do lote                      014 016     9(03)
            $conteudo .= ' ';                                                               //  Uso exclusivo do fenabran                           017 017     X(01)
            $conteudo .= '2';                                                               //  Tipo de inscri��o do empreendimento 2 = CNPJ        018 018     9(01)
            $conteudo .= "0" . $codEmpresa;                                                 //  n� de inscri��o do empreendimento                   019 033     9(15)
            $conteudo .= $this->limit($emp['cd_cedente'], 6, "zeros");                      //  C�digo do cedente do empreendimento                 034 039     9(06)
            $conteudo .= $this->complementoRegistro(14, "zeros");                           //  Uso exclusivo da caixa                              040 053     9(14)
            $conteudo .= $this->limit($emp["agencia"], 5, "zeros");                         //  Agencia                                             054 058     9(05)
            $conteudo .= $this->limit($emp["agencia_dv"], 1, "zeros");                      //  Digito verificador da agencia                       059 059     9(01)
            $conteudo .= $this->limit($emp['cd_cedente'], 6, "zeros");                      //  Numero do conv�nio                                  060 065     9(06)
            $conteudo .= $this->complementoRegistro(7, "zeros");                            //  C�digo do modelo personalizado                      066 072     9(07)
            $conteudo .= $this->complementoRegistro(1, "zeros");                            //  Uso exclusivo CAIXA                                 073 073     9(01)
            $conteudo .= $this->complementoRegistro(30, "brancos");                         //  Nome da empresa                                     074 103     9(30)
            //mensagens para impress�o nos boletos
            $conteudo .= ($contrato["tp_pessoa"] == 'F') ? '1' : '2';                       //  Tipo de pessoa 1 = Fisica 2 = Juridica              104 104     9(01)
            $conteudo .= $this->limit($cpfCnpj, 15, "zeros");                               //  Cpf ou cnpj do comprador                            105 119     9(15)
            $conteudo .= $this->limit($dadosContrato["quadra"], 10, "brancos");             //  Quadra                                              120 129     X(10)
            $conteudo .= $this->limit($dadosContrato["id_lote"], 10, "brancos");            //  N�mero da unidade                                   130 139     X(10)
            $conteudo .= '5';                                                               //  Tipo de im�vel 5 = outros                           140 140     9(01)
            $conteudo .= '5';                                                               //  Tipo da unidade 5 = outros                          141 141     X(01)
            $conteudo .= $this->limit($area, 6, "brancos");                                 //  Area util                                           142 147     9(06)
            $conteudo .= $this->limit($area, 4, "brancos");                                 //  Area Total                                          148 151     9(04)
            $conteudo .= str_replace("/", "", Helper::getDate($dadosContrato["dt_contrato"])); //  Data do contrato                               152 160     9(08)
            $conteudo .= '2';                                                               //  Contrato subrogado 2 = n�o                          161 161     9(01)
            $conteudo .= $this->complementoRegistro(8, "zeros");                            //  Data da ultima subroga��o                           162 169     9(08)
            $conteudo .= $this->limit($dadosContrato["prazo_finan"], 3, "zeros");           //  Prazo de financiamento total                        170 172     9(03)
            $conteudo .= '07';                                                              //  Tipo de atualiza��o de parcela                      173 174     9(02)
            $conteudo .= $this->complementoRegistro(10, "brancos");                         //  Caracteres extras da mensagem                       175 183     9(10)
            //fim da mensagem nos boletos
            $conteudo .= $this->limit($nrArquivo, 8, "zeros");                              //  N�mero de remessa (sequencial)                      184 191     9(08)
            $conteudo .= date("dmY");                                                       //  Data de grava��o da remessa                         192 199     9(08)
            $conteudo .= $this->complementoRegistro(8, "zeros");                            //  Data do cr�dito (apenas para retorno)               200 207     9(08)
            $conteudo .= $this->complementoRegistro(33, "brancos");                         //  Uso exclusivo do CNAB                               208 240     9(33)
            $conteudo .= chr(13) . chr(10);                                                 //  essa � a quebra de linha

            $vl_total = 0.00;
            $p = 0;
            foreach ($parcelas as $parcela) {
                //incremento no inicio para registrar o numero total ao fim
                $j++;

                $vl_parcela = number_format($parcela["vl_parcela"], 2);
                $vl_parcela = str_replace(".", "", $vl_parcela);
                $vl_parcela = str_pad($vl_parcela, 15, '0', STR_PAD_LEFT);
                $juros = number_format($parcela["juros"], 2);
                $juros = str_replace(".", "", $juros);
                $desconto = number_format($parcela["desconto"], 2);
                $desconto = str_replace(".", "", $desconto);
                $vl_total += $parcela["vl_total_pago"];
                $nossoNumero = str_pad(str_pad($parcela['increment_id'],2,'0',STR_PAD_LEFT).str_pad($parcela["id_parcela_contrato"], 9, '0', STR_PAD_LEFT),15,'0',STR_PAD_LEFT);

                ## SEGMENTO P (OBRIGATORIO)                                                 ##  NOME DO CAMPO                                       POSICAO    TAMANHO
                $conteudo .= "104";                                                         //  C�digo do banco                                     001 003     9(03)
                $conteudo .= $this->sequencial($i, 4);                                      //  Lote do servi�o                                     004 007     9(04)
                $conteudo .= '3';                                                           //  Registro detalhe                                    008 008     9(01)
                $conteudo .= $this->sequencial($j, 5);                                      //  N�mero sequencial do registro no lote               009 013     9(05)
                $conteudo .= 'P';                                                           //  C�digo do segmento                                  014 014     X(01)
                $conteudo .= ' ';                                                           //  Uso do banco                                        015 015     X(01)
                $conteudo .= '01';                                                          //  C�digo de movimenta��o 1 = Entrada de Parcelas      016 017     9(02)
                $conteudo .= $this->limit($emp["agencia"], 5, "zeros");                     //  Agencia                                             018 022     9(05)
                $conteudo .= $this->limit($emp["agencia_dv"], 1, "zeros");                  //  Dv da agencia                                       023 023     9(01)
                $conteudo .= $this->limit($emp['cd_cedente'], 6, "zeros");                  //  Codigo do convênio do cedente                       024 029     9(06)
                $conteudo .= $this->complementoRegistro(8, "zeros");                        //  Uso exclusivo da caixa                              030 037     9(08)
                $conteudo .= $this->complementoRegistro(3, "zeros");                        //  Uso exclusivo da caixa                              038 040     9(03)
                $conteudo .= $registro.'4';                                                 //  Modalidade (14 = Com registro emissão pelo Cliente) 041 042     9(02)
                $conteudo .= $this->limit($nossoNumero, 15, "zeros");                       //  Identific. do titulo no banco (gerado pelo banco)   043 057     9(15)
                $conteudo .= '1';                                                           //  Cd da carteira 1= cob. simples. 2= cob. caucionada  058 058     9(01)
                $conteudo .= $registro;                                                     //  Forma de cadastramento do titulo no banco           059 059     9(01)
                $conteudo .= '2';                                                           //  Tipo de documento                                   060 060     9(01)
                $conteudo .= '2';                                                           //  Emiss�o do bloqueto 2 = cliente emite               061 061     9(01)
                $conteudo .= '0';                                                           //  Identifica��o da distribui��o 1 = Banco distribui   062 062     9(01)
                $conteudo .= $this->limit($parcela["id_parcela"], 11, "zeros");             //  N�mero do documento de cobran�a                     063 073     9(11)
                $conteudo .= $this->complementoRegistro(4, "brancos");                      //  Reservado para uso da caixa                         074 077     9(04)
                $conteudo .= date("dmY", strtotime($parcela["dt_parcela"]));                //  Vencimento da presta��o                             078 085     9(08)
                $conteudo .= $vl_parcela;                                                   //  Valor da presta��o                                  086 100     9(13)
                $conteudo .= $this->complementoRegistro(5, "zeros");                        //  Agencia responsãvel pela cobrança (USO DA CAIXA)    101 105     9(05)
                $conteudo .= $this->complementoRegistro(1, "zeros");                        //  Digito verificador da agencia (USO DA CAIXA)        106 106     9(01)
                $conteudo .= "99";                                                          //  Esp�cie do t�tulo (99 = outros)                     107 108     9(02)
                $conteudo .= "N";                                                           //  Aceite A = Aceite N = Nao aceite                    109 109     X(01)
                $conteudo .= date("dmY");                                                   //  Data da emiss�o da parcela                          110 117     9(08)
                $conteudo .= "1";                                                           //  C�digo do juros/mora (1 = diário)                   118 118     9(01)
                $conteudo .= $this->complementoRegistro(8, "zeros");                        //  Data do juros. branco = data vencimento             119 126     9(08)
                $conteudo .= $this->limit($juros, 15, "zeros");                             //  Juros por dia                                       127 141     9(13)
                $conteudo .= "0";                                                           //  C�digo do desconto. 2 = percentual at� a data       142 142     9(01)
                $conteudo .= $this->complementoRegistro(8, "zeros");                        //  Data do desconto                                    143 150     9(08)
                $conteudo .= $this->limit($desconto, 15, "zeros");                          //  Valor do desconto                                   151 165     9(13)
                $conteudo .= $this->complementoRegistro(15, "zeros");                       //  Valor IOF a pagar                                   166 180     9(13)
                $conteudo .= $this->complementoRegistro(15, "zeros");                       //  Valor do abatimento                                 181 195     9(13)
                $conteudo .= $this->limit($nossoNumero, 25, "zeros");                       //  C�digo de identifica��o da parcela na empresa       196 220     9(25)
                $conteudo .= "3";                                                           //  Codigo para protesto (3 = sem protesto)             221 221     9(01)
                $conteudo .= $this->complementoRegistro(2, "zeros");                        //  Numero de dias para protesto                        222 223     9(02)
                $conteudo .= "2";                                                           //  Codigo de Baixa do boleto (2 = não baixar)          224 224     9(01)
                $conteudo .= $this->complementoRegistro(3, "zeros");                        //  Numero de dias para baixa                           225 227     9(03)
                $conteudo .= "09";                                                          //  Codigo da moeda (09 = real)                         228 229     9(02)
                $conteudo .= $this->complementoRegistro(10, "zeros");                       //  Uso exclusivo da caixa                              230 239     9(10)
                $conteudo .= $this->complementoRegistro(1, "brancos");                      //  Uso exclusivo do FEBRABAN                           240 240     9(01)
                $conteudo .= chr(13) . chr(10);                                             //  essa � a quebra de linha

            }
            $vl_total = number_format($vl_total, 2);
            $vl_total = str_replace(".", "", $vl_total);

            ##  TRAILER DO LOTE (OBRIGATORIO) - REGISTRO 5
            #  NOME DO CAMPO                                                                #SIGNIFICADO                                            #POSICAO    #TAMANHO
            $conteudo .= '104';                                                             //  Codigo banco                                        001 003     9(03)
            $conteudo .= $this->sequencial($i, 4);                                          //  Lote                   Lote de servi�o              004 007     9(04)
            $conteudo .= '5';                                                               //  Registro trailer do lote                            008 008     9(01)
            $conteudo .= $this->complementoRegistro(9, "brancos");                          //  Filler                                              009 017     X(09)
            $conteudo .= $this->limit($p+2, 6, "zeros");                                    //  Número de registros no lote                         018 023     9(06)
            $conteudo .= $this->limit($p, 6, "zeros");                                      //  Número de titulos no lote                           024 029     9(06)
            $conteudo .= $this->limit($vl_total, 17, "zeros");                              //  Valor total dos titulos no lote                     030 046     9(17)
            $conteudo .= $this->complementoRegistro(6, "zeros");                            //  Número de titulos caucionados no lote               047 052     9(06)
            $conteudo .= $this->complementoRegistro(17, "zeros");                           //  Valor total dos titulos caucionados no lote         053 069     9(17)
            $conteudo .= $this->complementoRegistro(6, "zeros");                            //  Número de titulos descontados no lote               070 075     9(06)
            $conteudo .= $this->complementoRegistro(17, "zeros");                           //  Valor total dos titulos descontados no lote         076 092     9(17)
            $conteudo .= $this->complementoRegistro(31, "brancos");                         //  Uso exclusivo do CNAB                               093 123     9(31)
            $conteudo .= $this->complementoRegistro(117, "brancos");                        //  Uso exclusivo do CNAB                               124 240     9(117)
            $conteudo .= chr(13) . chr(10);                                                 //  essa � a quebra de linha
        }

        ##  REGISTRO TRAILER DO ARQUIVO
        #   NOME DO CAMPO                                                                       #SIGNIFICADO                                           #POSICAO    #TAMANHO
        $conteudo .= "104";                                                                     //  Codigo do Banco para compensação (104 = CAIXA)      001 003     9(03)
        $conteudo .= "9999";                                                                    //  Lote de serviço (9999 = trailer do arquivo)         004 007     9(04)
        $conteudo .= "9";                                                                       //  tipo registro (9 = trailer)                         008 008     9(01)
        $conteudo .= $this->complementoRegistro(9, "brancos");                                  //  USO FEBRABAN                                        009 017     X(06)
        $conteudo .= $this->limit($i, 6, "zeros");                                              //  Quantidade de lotes                                 018 023     X(06)
        $conteudo .= $this->limit(($i*2)+$j+2, 6, "zeros");                                     //  Quantidade de Registros                             024 029     X(06)
        $conteudo .= $this->complementoRegistro(6, "brancos");                                  //  USO FEBRABAN                                        030 035     X(06)
        $conteudo .= $this->complementoRegistro(205, "brancos");                                //  USO FEBRABAN                                        036 240     X(205)


        if (!$handle = fopen($pathAno . '/' . $filename, 'w+')) {
            $msg = "Não foi poss�vel abrir o arquivo ($filename)";
            $erro = true;
        }
        // Escreve $conteudo no nosso arquivo aberto.
        elseif (fwrite($handle, "$conteudo") === FALSE) {
            $msg = "Não foi poss�vel escrever no arquivo ($filename)";
            $erro = true;
        } else {
            $msg = "Arquivo de remessa gerado com sucesso!";
            $erro = false;
        }
        fclose($handle);

        $retorno[0] = $msg;
        $retorno[1] = $erro;
        return $retorno;
    }

}

?>