<?php
//@descr: Gera o arquivo de remessa para cobranca no padrao CNAB 400 vers. 7.0 ITAU

class RemessaBoleto extends Zend_Db_Table_Abstract
{
    protected $_name = TB_REMESSA;

    public static function getRemessaByBanco($idremessa)
    {
        $item = self::getDefaultAdapter()->select()
            ->from(array("r" => TB_REMESSA), array('*'))
            ->where('r.id = ?', $idremessa)
            ->query()->fetchAll();

        return $item;
    }

    public function getListaRemessaBanco($verificarPermissao = true)
    {

        //Buscando a lista de layouts para o select
        $listaItem = $this->getDefaultAdapter()->select()
            ->from(array('r' => TB_REMESSA), array('*'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = r.id_empreendimento', 'nm_empreendimento')
            ->where('r.tp_status = "P"')
            ->joinLeft(array('sc' => TB_AGRUPADA), 'sc.idTabela = "9" AND sc.idCampo = r.id_banco',  'descricao');
        return $listaItem->order('r.dtGeracao DESC')->query()->fetchAll();
    }

    public static function getDados($id)
    {
        $item = self::getDefaultAdapter()->select()
            ->from(array("r" => TB_REMESSA), array('*'))
            ->join(array("e" => TB_EMPREENDIMENTO), "r.id_empreendimento = e.id", array('nm_empreendimento'))
            ->where('r.id = ?', $id)
            ->query()->fetch();
        $item['nm_empreendimento'] = utf8_encode($item['nm_empreendimento']);

        if($item){
            $itens = RemessaItens::findByRemessa($id);
            foreach ($itens as &$i){
                $i['nm_pessoa'] = utf8_encode($i['nm_pessoa']);
            }
            $item['parcelas'] = $itens;
        }

        return $item;
    }

    private function modulo_11($num, $base = 9, $r = 0)
    {
        $soma = 0;
        $fator = 2;

        /* Separacao dos numeros */
        for ($i = strlen($num); $i > 0; $i--) {
            // pega cada numero isoladamente
            $numeros[$i] = substr($num, $i - 1, 1);
            // Efetua multiplicacao do numero pelo fator
            $parcial[$i] = $numeros[$i] * $fator;
            // Soma dos digitos
            $soma += $parcial[$i];
            if ($fator == $base) {
                // restaura fator de multiplicacao para 2
                $fator = 1;
            }
            $fator++;
        }

        /* Calculo do modulo 11 */
        if ($r == 0) {
            $soma *= 10;
            $digito = $soma % 11;
            if ($digito == 10) {
                $digito = 0;
            }
            return $digito;
        } else {
            $resto = $soma % 11;
            return $resto;
        }
    }

    private function limit($palavra, $limite, $comp = 'brancos')
    {
        $palavra = strtoupper(str_replace(array('�', '�'), '', Helper::removeAcentos($palavra, false)));
        if (strlen($palavra) >= $limite) {
            $var = substr($palavra, 0, $limite);
        } else {
            $max = (int)($limite - strlen($palavra));
            $var = $palavra . $this->complementoRegistro($max, $comp);
        }
        return $var;
    }

    private function sequencial($i)
    {
        if ($i < 10) {
            return $this->zeros(0, 5) . $i;
        } else if ($i >= 10 && $i < 100) {
            return $this->zeros(0, 4) . $i;
        } else if ($i >= 100 && $i < 1000) {
            return $this->zeros(0, 3) . $i;
        } else if ($i >= 1000 && $i < 10000) {
            return $this->zeros(0, 2) . $i;
        } else if ($i >= 10000 && $i < 100000) {
            return $this->zeros(0, 1) . $i;
        } else {
            return false;
        }
    }

    private function zeros($min, $max)
    {
        $x = ($max - strlen($min));
        $zeros = '';
        for ($i = 0; $i < $x; $i++) {
            $zeros .= '0';
        }
        return $zeros . $min;
    }

    private function complementoRegistro($int, $tipo)
    {
        $space = '';
        if ($tipo == "zeros") {
            for ($i = 1; $i <= $int; $i++) {
                $space .= '0';
            }
        } else if ($tipo == "brancos") {
            for ($i = 1; $i <= $int; $i++) {
                $space .= ' ';
            }
        }

        return $space;
    }

    private function formata_numero($numero, $loop, $insert, $tipo = "geral")
    {
        if ($tipo == "geral") {
            $numero = str_replace(",", "", $numero);
            while (strlen($numero) < $loop) {
                $numero = $insert . $numero;
            }
        }
        if ($tipo == "valor") {
            /*
              retira as virgulas
              formata o numero
              preenche com zeros
             */
            $numero = str_replace(",", "", $numero);
            while (strlen($numero) < $loop) {
                $numero = $insert . $numero;
            }
        }
        if ($tipo == "convenio") {
            while (strlen($numero) < $loop) {
                $numero = $numero . $insert;
            }
        }
        return $numero;
    }

    private function digitoVerificador_nossonumero($numero)
    {
        $resto2 = $this->modulo_11($numero, 7, 1);
        $digito = 11 - $resto2;
        if ($digito == 10) {
            $dv = "P";
        } elseif ($digito == 11) {
            $dv = 0;
        } else {
            $dv = $digito;
        }
        return $dv;
    }

    public function gerar($empreendimento, $dados)
    {

        $empresa = strtoupper($empreendimento['nm_empreendimento']);
        $nrArquivo = $dados['idRemessa'];
        $codEmpresa = $empreendimento['cd_cedente'];

        // codigo com 0 + carteira + agencia, conta e digito verificador da conta
        $idEmpresa = '0' . str_pad($empreendimento['carteira'], 3, '0', STR_PAD_LEFT) .
            str_pad($empreendimento['agencia'], 5, '0', STR_PAD_LEFT) .
            str_pad($empreendimento['conta_corrente'], 7, '0', STR_PAD_LEFT) .
            $empreendimento['conta_corrente_dv'];

        if ((float)$empreendimento['multa'] > 0.00) {
            $flMulta = 2;
            $percentualMulta = str_pad(str_replace('.', '', $empreendimento['multa']), 4, '0', STR_PAD_LEFT);
        } else {
            $flMulta = 0;
            $percentualMulta = '0000';
        }

        //array de clientes
        $parcelas = $dados['parcelas'];

        $fusohorario = 3;
        $timestamp = mktime(date("H") - $fusohorario, date("i"), date("s"), date("m"), date("d"), date("Y"));

        $DATAHORA['PT'] = gmdate("d/m/Y H:i:s", $timestamp);
        $DATAHORA['EN'] = gmdate("Y-m-d H:i:s", $timestamp);
        $DATA['PT'] = gmdate("d/m/Y", $timestamp);
        $DATA['EN'] = gmdate("Y-m-d", $timestamp);
        $DATA['DIA'] = gmdate("d", $timestamp);
        $DATA['MES'] = gmdate("m", $timestamp);
        $DATA['ANO'] = gmdate("y", $timestamp);

        //Cria os diretorios para onde o arquivo vai ser gravado
        $path = explode('.',$_SERVER['HTTP_HOST']);
        if ($path[0] == 'www') {
            $path = $path[1];
        } else {
            $path = $path[0];
        }
        $filename = $dados['arquivo'];
        $filepath = DIRETORIO_DOWNLOAD . "remessas/" . $path;
        $pathAno = DIRETORIO_DOWNLOAD . "remessas/" . $path . '/' . date('Y');

        if (is_dir($filepath)) {
            if (!is_dir($pathAno)) mkdir($pathAno);
        } else {
            mkdir($filepath);
            mkdir($pathAno);
        }
        $conteudo = '';

        ##  REGISTRO HEADER
        #   NOME DO CAMPO           #SIGNIFICADO            #POSICAO       #PICTURE
        $conteudo .= '0';                                         //  tipo de registro        id registro header      001 001        9(01)
        $conteudo .= 1;                                           //  operacao                tipo operacao remessa   002 002        9(01)
        $conteudo .= 'REMESSA';                                   //  literal remessa         escr. extenso           003 009        X(07)
        $conteudo .= '01';                                        //  codigo servico          id tipo servico         010 011        9(02)
        $conteudo .= $this->limit('COBRANCA', 15);                //  literal cobranca        escr. extenso           012 026        X(15)
        $conteudo .= str_pad($codEmpresa, 20, '0', STR_PAD_LEFT);  //  c�digo da empresa       fornecido pelo banco    027 046        9(20)
        $conteudo .= $this->limit($empresa, 30);                  //  nome da Empresa                                 047 076        X(30)
        $conteudo .= 237;                                         //  numero do banco         '237'                   077 079        9(03)
        $conteudo .= $this->limit('BRADESCO', 15);                //  nome do banco           'BRADESCO'              080 094        9(15)
        $conteudo .= $DATA['DIA'] . $DATA['MES'] . $DATA['ANO'];  //  data geracao arquivo                            095 100        9(06)
        $conteudo .= $this->complementoRegistro(8, "brancos");    //  bancos                                          101 108        X(08)
        $conteudo .= "MX";                                        //  Identifi��o do Sistema                          109 110        X(02)
        $conteudo .= str_pad($nrArquivo, 7, '0', STR_PAD_LEFT);    //  Sequencial do arquivo                           111 117        9(07)
        $conteudo .= $this->complementoRegistro(277, "brancos");  //  bancos                                          118 394        X(277)
        $conteudo .= $this->sequencial(1);                        //  numero sequencial        registro no arquivo    395 400        9(06)

        $conteudo .= chr(13) . chr(10);                            //essa � a quebra de linha

        $especies = Array('DM' => '01', 'NP' => '02', 'NS' => '03', 'CS' => '04', 'REC' => '05', 'LC' => '10', 'ND' => '11', 'DS' => '12', 'OU' => '99', '0' => '01');
        $especie = $especies[$empreendimento['especie_documento']];

        $i = 2;
        foreach ($parcelas as $parcela) {
            $chars = array(',', '.', '/', '-');
            $nossoNumero = str_pad($parcela['increment_id'],2,'0',STR_PAD_LEFT).str_pad($parcela["id_parcela_contrato"], 9, '0', STR_PAD_LEFT);
            $dvNossoNumero = $this->digitoVerificador_nossonumero($this->formata_numero($empreendimento['carteira'], 2, 0) . $this->formata_numero($parcela["id_parcela_contrato"], 11, 0));
            $dtVencimentoArr = explode('-', $parcela['dt_parcela']);
            $dtVencimento = $dtVencimentoArr['2'] . $dtVencimentoArr['1'] . substr($dtVencimentoArr['0'], 2);
            $vlParcela = str_replace('.', '', $parcela['vl_parcela']);
            $vlMultaDia = number_format((((int)$vlParcela * $empreendimento['juros']) / 10000), 2, '', '');
            if ($parcela['tp_pessoa'] == 'J') {
                $cpf_cnpj = str_replace($chars, '', $parcela['nr_cnpj']);
            } else {
                $cpf_cnpj = str_replace($chars, '', $parcela['nr_cpf']);

            }

            $cpf_cnpj = $this->limit($cpf_cnpj, 14);
            $cep_ini = substr($parcela['nr_cep'], 0, 5);
            $cep_fim = substr($parcela['nr_cep'], 6, 3);

            ##  REGISTRO DETALHE (OBRIGATORIO)
            #   NOME DO CAMPO          #SIGNIFICADO                 #POSICAO    #TAMANHO
            $conteudo .= 1;                                           //  tipo registro          id registro transacac.       001 001     9(01)
            $conteudo .= $this->complementoRegistro(5, "brancos");    //  Ag�ncia de D�bito      da empresa                   002 006     9(05)
            $conteudo .= $this->complementoRegistro(1, "brancos");    //  D�gito da Ag�ncia de d�bito                         007 007     9(01)
            $conteudo .= $this->complementoRegistro(5, "brancos");    //  Raz�o da Conta Corrente                             008 012     9(05)
            $conteudo .= $this->complementoRegistro(7, "brancos");    //  conta corrente         c/c do sacado                013 019     9(07)
            $conteudo .= $this->complementoRegistro(1, "brancos");    //  d�gito da Conta Corrente                            020 020     9(01)
            $conteudo .= str_pad($idEmpresa, 17, '0', STR_PAD_LEFT);   //  identif, da empresa    cendente, no banco           021 037     9(17)
            $conteudo .= str_pad($nrArquivo, 25, '0', STR_PAD_LEFT);   //  n� do controle do participante                      038 062     9(25)
            $conteudo .= $this->complementoRegistro(3, "brancos");    //  cod do banco a ser debitado                         063 065     9(03)
            $conteudo .= $flMulta;                                    //  campo de multa         2 se tiver ou 0 se n�o       066 066     9(01)
            $conteudo .= $percentualMulta;                            //  percentual de multa                                 067 070     9(04)
            $conteudo .= $nossoNumero;                                //  identifica��o do t�tulo no banco                    071 081     X(11)
            $conteudo .= $dvNossoNumero;                              //  digito de auto-conferencia do n� banc�rio           082 082     9(01)
            $conteudo .= $this->complementoRegistro(10, "zeros");     //  desconto bonificacao   por dia                      083 092     9(10)
            $conteudo .= 2;                                           //  emiss�o do boleto      1 banco ou 2 cliente         093 093     9(01)
            $conteudo .= 'N';                                         //  Ident. se emite Boleto para D�bito Autom�tico       094 094     9(01)
            $conteudo .= $this->complementoRegistro(10, "brancos");   //  ident opera��o do banco brancos                     095 104     9(10)
            $conteudo .= $this->complementoRegistro(1, "brancos");    //  indicador rateio cred  'R' opcional                 105 105     9(01)
            $conteudo .= '2';                                         //  Endere�amento para Aviso do D�b Autom em C/C        106 106     X(01)
            $conteudo .= $this->complementoRegistro(2, "brancos");    //  brancos                brancos                      107 108     X(02)
            $conteudo .= '01';                                        //  identifica��o da ocorr�ncia                         109 110     9(02)
            $conteudo .= $this->limit($nossoNumero, 10, 'zeros');     //  numero do documento                                 111 120     9(10)
            $conteudo .= $dtVencimento;                               //  data do vencimento     do t�tulo 'DDMMAA'           121 126     9(06)
            $conteudo .= str_pad($vlParcela, 13, '0', STR_PAD_LEFT);     //  valor do titulo        com duas casas decimais      127 139     9(13)
            $conteudo .= $this->complementoRegistro(3, 'zeros');      //  banco encarregado      zeros                        140 142     9(03)
            $conteudo .= $this->complementoRegistro(5, 'zeros');      //  ag�ncia deposit�ria    zeros                        143 147     X(05)
            $conteudo .= $especie;
            $conteudo .= 'N';                                         //  identifica��o          'N'                          150 150     X(01)
            $conteudo .= date('dmy');                                 //  data de emiss�o        do t�tulo 'DDMMAA'           151 156     X(06)
            $conteudo .= '00';                                        //  1� instru��o                                        157 158     9(02)
            $conteudo .= '00';                                        //  2� instru��o                                        159 160     9(02)
            $conteudo .= str_pad($vlMultaDia, 13, '0', STR_PAD_LEFT);    //  valor a ser cobrado por dia de atraso               161 173     X(13)
            $conteudo .= $this->complementoRegistro(6, 'zeros');;     //  data limite p/ conceder desconto  'DDMMAA'          174 179     9(06)
            $conteudo .= $this->complementoRegistro(13, 'zeros');     //  valor do desconto                                   180 192     9(13)
            $conteudo .= $this->complementoRegistro(13, 'brancos');   //  valor do abatimento    a ser concedido ou cancelado 193 205     9(13)
            $conteudo .= $this->complementoRegistro(13, 'brancos');   //  valor IOF                                           206 218     9(13)
            $conteudo .= '01';                                        //  identific. do tipo insc do sacado                   219 220     9(02)
            $conteudo .= $cpf_cnpj;                                   //  n� insc. do sacado     CNPJ/CPF                     221 234     9(14)
            $conteudo .= $this->limit($parcela['nm_pessoa'], 40);     //  nome sacado                                         235 274     X(40)
            $conteudo .= $this->limit($parcela['endereco'], 40);      //  endere�o sacado                                     275 314     X(40)
            $conteudo .= $this->complementoRegistro(12, "brancos");   //  1� mensagem                                         315 326     X(12)
            $conteudo .= $this->limit($cep_ini, 5, 'zeros');            //  cep                                                 327 331     X(05)
            $conteudo .= $this->limit($cep_fim, 3, 'zeros');            //  sufixo cep                                          332 334     X(03)
            $conteudo .= $this->complementoRegistro(60, "brancos");   //  sacador/ avalista      2� mensagem                  335 394     X(60)
            $conteudo .= $this->sequencial($i);                       //  numero sequencial      do registro no arquivo       395 400     9(06)
            $conteudo .= chr(13) . chr(10);
            $i++;
        }

        ##  REGISTRO TRAILER
        #   NOME DO CAMPO          #SIGNIFICADO                 #POSICAO    #TAMANHO
        $conteudo .= 9;                                           //  tipo registro               9                       001 001     9(01)
        $conteudo .= $this->complementoRegistro(393, "brancos");  //  Ag�ncia de D�bito      da empresa                   002 393     X(393)
        $conteudo .= str_pad($i, 6, '0', STR_PAD_LEFT);            //  numero sequencial      do registro no arquivo       394 400     9(06)
        $conteudo .= chr(13) . chr(10);

        //Inicializa o retorno
        $erro = false;
        $msg = '';

        if (!$handle = fopen($pathAno . '/' . $filename, 'w+')) {
            $msg = "N�o foi poss�vel abrir o arquivo ($filename)";
            $erro = true;
        }

        // Escreve $conteudo no nosso arquivo aberto.
        if (fwrite($handle, "$conteudo") === FALSE) {
            $msg = "N�o foi poss�vel escrever no arquivo ($filename)";
            $erro = true;
        } elseif(!$erro) {
            $msg = "Arquivo de remessa gerado com sucesso!";
            $erro = false;
        }
        fclose($handle);

        $retorno[0] = $msg;
        $retorno[1] = $erro;
        return $retorno;
    }

}
