<?php

class Relacionamento extends Zend_Db_Table_Abstract
{

    protected $_name = TB_RELACIONAMENTO;

    public static function fullSearch($termo, $count = false, $offset = false, $page = false)
    {
        $termo = "'%" . strtoupper($termo) . "%'";
        $adapter = Relacionamento::getDefaultAdapter();

        $res = $adapter->select()->from(array("c" => TB_RELACIONAMENTO), array('data', 'id'))
            ->join(array("contr" => TB_CONTRATO), "c.idContrato = contr.id", null)
            ->join(array("p" => TB_PESSOA), "contr.id_pessoa = p.id", array("nm_pessoa"))
            ->join(array("agr" => TB_AGRUPADA), "c.agr_idStatus = agr.idCampo AND idTabela = " . Db_TabelaAgrupada::TABLE_STATUS_CONTATO, array("status" => "descricao"))
            ->order("c.data DESC")->where("fl_distrato = '0'");

        if ($count && $offset === false && $page === false) {
            $res->where("CONCAT(UPPER(c.data),' ',UPPER(p.nm_pessoa),' ',UPPER(agr.descricao)) LIKE {$termo}");
            return count($res->query()->fetchAll());
        } else {
            $res->where("CONCAT(UPPER(c.data),' ',UPPER(p.nm_pessoa),' ',UPPER(agr.descricao)) LIKE {$termo}");

            if ($offset !== false && $page !== false)
                $res->limit("{$offset}, {$page}");
        }

        return $res->query()->fetchAll();
    }

    /**
     * Cria um contato com os parametros passados
     * @param $acao
     * @param $data
     * @param $idContrato
     * @param $assunto
     * @return mixed
     */
    public function saveContato($acao, $data, $idContrato, $assunto)
    {
        if ($idContrato && Login::getUsuario()) {
            $contato = $this->createRow();
            $contato->idContrato = $idContrato;
            $contato->data = $data;
            $contato->agr_idStatus = $acao;
            $contato->assunto = $assunto;
            $contato->usuario = Login::getUsuario()->getId();
            $contato->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i');
            return $contato->save();
        } else
            return false;
    }

    public static function getTotalContatos($where = false)
    {
        $contatos = self::getDefaultAdapter()->select()->from(array('c' => TB_RELACIONAMENTO), array('registros' => 'COUNT(c.id)'))
            ->join(array('cr' => TB_CONTRATO), 'c.idContrato = cr.id')
            ->join(array('l' => TB_LOTES), 'cr.id_lote = l.id')
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id');
        if ($where) {
            $contatos = $contatos->where($where);
        }
        $contatos = $contatos->query()->fetch();
        return $contatos['registros'];
    }

    public static function getListaContatos($where = false, $perPage = false, $from = false)
    {
        $contatos = self::getDefaultAdapter()->select()->from(array("c" => TB_RELACIONAMENTO), array('data', 'id'))
            ->join(array("contr" => TB_CONTRATO), "c.idContrato = contr.id", array('id_contrato' => 'id', 'fl_aprovar_contrato', 'fl_distrato'))
            ->join(array("p" => TB_PESSOA), "contr.id_pessoa = p.id", array("nm_pessoa"))
            ->join(array('l' => TB_LOTES), 'contr.id_lote = l.id', array('quadra', 'lote'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', 'nm_empreendimento')
            ->join(array("agr" => TB_AGRUPADA), "c.agr_idStatus = agr.idCampo AND idTabela = " . Db_TabelaAgrupada::TABLE_STATUS_CONTATO, array("status" => "descricao"));

        if ($where) {
            $contatos = $contatos->where($where);
        }

        $contatos = $contatos->order(array("c.id DESC"))
            ->limit($perPage, $from)->query()->fetchAll();

        return $contatos;
    }

    //Busca os registros para crm no encerrados e com data de retorno por empreendimento
    public static function getRetornoByEmpreendimentoUsuario($idEmp, $idUsuario = false)
    {
        $contatos = self::getDefaultAdapter()->select()->from(array("c" => TB_RELACIONAMENTO), array('*'))
            ->join(array("contr" => TB_CONTRATO), "c.idContrato = contr.id", array('id_contrato' => 'id'))
            ->join(array("p" => TB_PESSOA), "contr.id_pessoa = p.id", array("nm_pessoa"))
            ->join(array('l' => TB_LOTES), 'contr.id_lote = l.id', array('quadra', 'lote'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', 'nm_empreendimento')
            ->where('e.id = ?', $idEmp)
            ->where('c.dt_retorno IS NOT NULL AND c.dt_retorno != 0000-00-00')
            ->where('c.fl_encerrado = "0"');

        //Se existe usuario
        if ($idUsuario && $idUsuario != '*')
            $contatos = $contatos->where('c.usuario = ?', $idUsuario);

        $contatos = $contatos->query();

        return $contatos;
    }


    public static function findListaContatos($post, $count = false)
    {

        $search = utf8_decode($_POST['search']['value']);

        $order = $_POST['order'];

        $array = array(
            0 => 'e.nm_empreendimento',
            1 => 'l.quadra',
            2 => 'l.lote',
            3 => 'contr.id',
            4 => 'p.nm_pessoa',
            5 => 'pf.nr_cpf'
        );

        if ($search) {
            $where = 'contr.id LIKE "%' . $search . '%" ';
            $where .= 'or e.nm_empreendimento LIKE "%' . $search . '%" ';
            $where .= 'or l.quadra LIKE "%' . $search . '%" ';
            $where .= 'or l.lote LIKE "%' . $search . '%" ';
            $where .= 'or p.nm_pessoa LIKE "%' . $search . '%" ';
            $where .= 'or pf.nr_cpf LIKE "%' . $search . '%" ';
        }

        $contatos = self::getDefaultAdapter()->select()
            ->from(array("contr" => TB_CONTRATO), array('id', 'fl_aprovar_contrato', 'fl_distrato'))
            ->join(array("p" => TB_PESSOA), "contr.id_pessoa = p.id", array("nm_pessoa"))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), "p.id = pf.id_pessoa", array('nr_cpf'))
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), "p.id = pj.id_pessoa", array('nr_cnpj'))
            ->join(array('l' => TB_LOTES), 'contr.id_lote = l.id', array('quadra', 'lote'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', 'nm_empreendimento');


        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $contatos->where("e.id IN({$id})");
                }
            } catch (Exception $e) {
            }
        }

        if (isset($where)) {
            $contatos = $contatos->where($where);
        }

        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $contatos = $contatos->limit($post['length'], $post['start']);
            }

        foreach ($order as $ord)
            $orderByQuery[] = $array[$ord['column']] . ' ' . $ord['dir'];

        $contatos = $contatos->order(implode(',', $orderByQuery))->query()->fetchAll();


        return $contatos;
    }
}