<?php

class RelEmpreendimento extends Zend_Db_Table_Abstract
{
    protected $_name = TB_RELACIONAMENTO_EMPREENDIMENTO;

    public static function findListaContatos($post, $count = false)
    {

        $search = utf8_decode($_POST['search']['value']);

        $order = $_POST['order'];

        $array = array(
            0 => 'e.nm_empreendimento',            
        );

        if ($search) {            
            $where .= 'nm_empreendimento LIKE "%' . $search . '%" ';            
        }

        $contatos = self::getDefaultAdapter()->select()
            ->from(array("emp" => TB_EMPREENDIMENTO), array('*'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $contatos->where("e.id IN({$id})");
                }
            } catch (Exception $e) {
            }
        }

        if (isset($where)) {
            $contatos = $contatos->where($where);
        }

        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $contatos = $contatos->limit($post['length'], $post['start']);
            }

        if ($order) {
            foreach ($order as $ord)
            $orderByQuery[] = $array[$ord['column']] . ' ' . $ord['dir'];
        } else {
            $orderByQuery = [];
        }

        $contatos = $contatos->order(implode(',', $orderByQuery))->query()->fetchAll();

        return $contatos;
    }
    /**
     * Cria um contato com os parametros passados
     * @param $acao
     * @param $data
     * @param $idContrato
     * @param $assunto
     * @return mixed
     */
    public function saveContato($acao, $data, $id_empreendimento, $assunto)
    {
        if ($id_empreendimento && Login::getUsuario()) {
            $contato = $this->createRow();
            $contato->id_empreendimento = $id_empreendimento;
            $contato->data = $data;
            $contato->agr_idStatus = $acao;
            $contato->assunto = $assunto;
            $contato->usuario = Login::getUsuario()->getId();
            $contato->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i');
            return $contato->save();
        } else
            return false;
    }
}