<?php

class Recibo extends Zend_Db_Table_Abstract
{

    protected $_name = TB_RECIBO;
    static $reciboInstacia;

    /**
     * SINGLETON de recibo
     * @return Recibo
     */
    public static function getInstance()
    {
        if (!self::$reciboInstacia) {
            self::$reciboInstacia = new Recibo();
        }
        return self::$reciboInstacia;
    }

    /**
     * Busca o recibo por id
     * @param string $termo
     * @return array
     */
    public static function findById($id)
    {
        $recibo = self::getInstance()->getAdapter()->select()
            ->from(array('r' => TB_RECIBO), array('*'))
            ->where('r.id_recibo = ?', $id)->query()->fetch();

        return $recibo;
    }

    /**
     * Busca o recibo por id
     * @param string $termo
     * @return array
     */
    public static function getLista($post, $count = false)
    {
        $search = utf8_decode($post['search']['value']);
        $order = $post['order'];

        $array = array(
            0 => 'r.id_recibo',
            1 => 'e.nm_empreendimento',
            2 => 'p.nm_pessoa',
            3 => 'agr.descricao',
            4 => 'r.vl_recibo',
            5 => 'r.dt_recibo',
        );
        if ($search) {
            $where = 'e.nm_empreendimento LIKE "%' . $search . '%" ';
            $where .= 'or r.id_recibo LIKE "%' . $search . '%" ';
            $where .= 'or p.nm_pessoa LIKE "%' . $search . '%" ';
            $where .= 'or agr.descricao LIKE "%' . $search . '%" ';
            $where .= 'or r.vl_recibo LIKE "%' . $search . '%" ';
            $where .= 'or r.dt_recibo LIKE "%' . $search . '%" ';
            $where .= 'or DAY(r.dt_recibo) = "' . $search . '" ';
            $where .= 'or MONTH(r.dt_recibo) = "' . $search . '" ';
            $where .= 'or YEAR(r.dt_recibo) = "' . $search . '" ';
        }

        $recibos = self::getDefaultAdapter()->select()
            ->from(array('r' => TB_RECIBO), array('*'))
            ->joinLeft(array('e' => TB_EMPREENDIMENTO), 'r.id_empreendimento = e.id', array('nm_empreendimento'))
            ->join(array('p' => TB_PESSOA), 'r.id_pessoa = p.id', array('nm_pessoa'))
            ->joinLeft(array('t' => TB_TAXA_VALOR), 't.id_taxas = r.id_taxa', array(''))
            ->joinLeft(array('agr' => TB_AGRUPADA), 't.id_tipo_taxa = agr.idCampo AND agr.idTabela = "17" ', array('descricao'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']->getSuper() != '1') {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $recibos->where("e.id IN({$id})");
                }
            } catch (Exception $e) {
            }
        }
        if (isset($where)) {
            $recibos = $recibos->where($where);
        }


        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $recibos = $recibos->limit($post['length'], $post['start']);
            }

        foreach ($order as $ord)
            $orderByQuery[] = $array[$ord['column']] . ' ' . $ord['dir'];

        $recibos = $recibos->order(implode(',', $orderByQuery))->query()->fetchAll();

        return $recibos;
    }

}