<?php

class PortalSenha extends Zend_Db_Table_Abstract {

    protected $_name = TB_PORTAL_SENHA;
    private static $portalSenhaInstacia;

        /**
     * Busca os dados do Usuário
     * @param integer $id
     * @return array
     */
    public static function findUserById($id)
    {
        $db = Db::getInstance();
        $stmt = $db->prepare("SELECT * FROM " . TB_PORTAL_SENHA . " e WHERE e.id = ?");
        $stmt->execute(array($id));
        return $stmt->fetch(\PDO::FETCH_ASSOC);
    }

    public static function buscaUsuarioPortalPorIdPessoa($idPessoa)
    {
        $contrato = self::getInstance()->getDefaultAdapter()->select()
            ->from(array('p' => TB_PORTAL_SENHA), 'id_cliente')
            ->where('id_cliente = ' . $idPessoa)
            ->query()->fetch();
        
        return $contrato;
    }

    /**
     * @return PortalSenha
     */
    public static function getInstance()
    {
        if (!self::$portalSenhaInstacia) {
            self::$portalSenhaInstacia = new Contrato();
        }
        return self::$portalSenhaInstacia;
    }

}
