<?php
class Ponto{
	const EXPEDIENTE_MANHA = 0;
	const EXPEDIENTE_TARDE = 1;
	const EXPEDIENTE_EXTRA_A = 2;
	const EXPEDIENTE_EXTRA_B = 3;
	
	public static function getExpedienteDisponivel($grade,$data){
		if(!$grade instanceof Db_Rh_Grade) $grade = Db_Rh_Grade::find($grade);
		$expedientes = array();
		#Converso do formato da data
		
		$timestamp = strtotime($data);
		$diaSemana = date("w",$timestamp);
		
		$feriado = Db_Rh_Feriado::find($data);

		#sbado e domingo
		if(in_array($diaSemana,array(0,6))){
			#tem expediente no sabado
			if($grade->getFlagSabado() && $diaSemana == 6){
				$expedientes[] = self::EXPEDIENTE_MANHA;
			}else{
				$expedientes[] = self::EXPEDIENTE_EXTRA_A;
			}
			$expedientes[] = self::EXPEDIENTE_EXTRA_B;
			
		#feriado	
		}elseif($feriado){
			$expedientes[] = self::EXPEDIENTE_EXTRA_A;
			$expedientes[] = self::EXPEDIENTE_EXTRA_B;
		#dias teis	
		}else{
			if($grade->getHoraEntradaA() && $grade->getHoraSaidaA()) $expedientes[] = self::EXPEDIENTE_MANHA;
			if($grade->getHoraEntradaB() && $grade->getHoraSaidaB()) $expedientes[] = self::EXPEDIENTE_TARDE;
			
			$expedientes[] = self::EXPEDIENTE_EXTRA_A;
			if(!in_array(self::EXPEDIENTE_MANHA,$expedientes) && !in_array(self::EXPEDIENTE_TARDE,$expedientes)){
				$expedientes[] = self::EXPEDIENTE_EXTRA_B;
			}
		}
		return $expedientes;
	}
	
	
	
}