<?php
class Cp_PessoaTelefone extends BD {
    
    protected $_name = TB_PESSOA_TELEFONE;

    /**
     * Retorna um array com os dados do telefone no formato que esta sendo
     * utilizado nos formularios.
     *
     * @param int $idPessoa   ID da Pessoa
     * @param string $tipoTelefone    Tipo de Telefone (Ex: C = Celular, F = Fixo)
     * @return Array $telefone
     */
    public function findTelefone($idPessoa, $tipoTelefone) {

      $dados = $this->select()->where("idPessoa = ? ", $idPessoa)
                              ->where("tipoTelefone = ?",$tipoTelefone)
                              ->query()->fetch();

      switch ($tipoTelefone) {
        case 'C':
          $telefone['dddCelular']       = $dados['ddd'];
          $telefone['celular']          = $dados['numero'];
          $telefone['operadoraCelular'] = $dados['operadora'];
          break;
        case 'F':
          $telefone['dddTelefone']       = $dados['ddd'];
          $telefone['telefone']          = $dados['numero'];
          $telefone['operadoraTelefone'] = $dados['operadora'];
          break;
        case 'T':
          $telefone['dddTrabalho']       = $dados['ddd'];
          $telefone['trabalho']          = $dados['numero'];
          $telefone['operadoraTrabalho'] = $dados['operadora'];
          break;
        case 'R':
          $telefone['dddRecado']       = $dados['ddd'];
          $telefone['recado']          = $dados['numero'];
          $telefone['operadoraRecado'] = $dados['operadora'];
          break;
        case 'X':
          $telefone['dddFax']       = $dados['ddd'];
          $telefone['fax']          = $dados['numero'];
          $telefone['operadoraFax'] = $dados['operadora'];
          break;
      }

      return $telefone;
    }

}

