<?php
class Pessoa_Juridica extends Zend_Db_Table_Abstract {

    protected $_name = TB_PESSOA_JURIDICA;

    /**
     *
     * @param string $termo
     * @return array
     */
    public static function fullSearch($termo, $count = false, $offset = false, $page = false) {
        $result = array();
        $termo = "'%".strtoupper($termo)."%'";
        $db = DB::getInstance();
        if($count && $offset === false && $page === false) {
            $select = "SELECT count(p.id) AS count FROM ".TB_PESSOA_JURIDICA." pf JOIN ".TB_PESSOA." p  ON pf.id_pessoa = p.id WHERE CONCAT(p.id,' ',UPPER(p.nm_pessoa),' ',pf.nr_cnpj) LIKE {$termo}";
        } else {
            $select = "SELECT p.id FROM ".TB_PESSOA_JURIDICA." pf JOIN ".TB_PESSOA." p  ON pf.id_pessoa = p.id WHERE CONCAT(p.id,' ',UPPER(p.nm_pessoa),' ',pf.nr_cnpj) LIKE {$termo} ";
            if($offset !== false && $page !== false)
                $select .= " LIMIT {$offset}, {$page} ";
        }
        $stmt = $db->prepare($select);
        $stmt->execute();
        $ids = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if($count && $offset === false && $page === false) return $ids;

        if(is_array($ids) && count($ids)) {
            foreach ($ids as $id) {
                $result[] = self::findPessoaJuridica($id['id']);
            }
        }
        return $result;
    }

    public static function findDadosPessoaJuridica($id, $cidade = false)
    {
        $db = Db::getInstance();
        $query = "SELECT pj.*, p.*, c.* FROM " . TB_PESSOA_JURIDICA . " pj JOIN " . TB_PESSOA . " p ON pj.id_pessoa = p.id";
        $query .= " LEFT JOIN " . TB_CIDADE . " c ON c.id = p.cd_cidade";
        $query .= " WHERE p.id = ?";
        $stmt = $db->prepare($query);
        $stmt->execute(array($id));
        $stmt->setFetchMode(PDO::FETCH_CLASS, "Pessoa_Juridica");
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    /**
     *
     * @param integer $id
     * @return array
     */
    public static function findPessoaJuridica($id) {
        $db = Db::getInstance();
        $stmt = $db->prepare("SELECT p.id, p.nm_pessoa, pf.nr_cnpj FROM ".TB_PESSOA_JURIDICA." pf JOIN ".TB_PESSOA." p ON pf.id_pessoa = p.id WHERE p.id = ?");
        $stmt->execute(array($id));
        $stmt->setFetchMode(PDO::FETCH_CLASS,"Pessoa_Juridica");
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public static function findLista($post, $count = false)
    {
        $search = utf8_decode($_POST['search']['value']);
        $order = $_POST['order'];

        $array = array(
            0 => 'p.id',
            1 => 'p.nm_pessoa',
            2 => 'pj.nr_cnpj'
        );

        if ($search) {
            $where = 'p.id LIKE "%' . $search . '%" ';
            $where .= 'or p.nm_pessoa LIKE "%' . $search . '%" ';
            $where .= 'or pj.nr_cnpj LIKE "%' . $search . '%" ';
        }

        $itens = self::getDefaultAdapter()->select()
            ->from(array('p' => TB_PESSOA), array('p.id', 'p.nm_pessoa'))
            ->join(array('pj' => TB_PESSOA_JURIDICA), 'p.id = pj.id_pessoa', array('*'));

        if (isset($where)) {
            $itens = $itens->where($where);
        }
        //Apenas pessoas ativas
        $itens = $itens->where('p.fl_status = "1"');

        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $itens = $itens->limit($post['length'], $post['start']);
            }

        $orderByQuery = array();
        foreach ($order as $ord)
            $orderByQuery[] = $array[$ord['column']] . ' ' . $ord['dir'];

        $itens = $itens->order(implode(',', $orderByQuery))->query()->fetchAll();


        return $itens;
    }

}

