<?php

class Pessoa_Fisica extends Zend_Db_Table_Abstract
{

    protected $_name = TB_PESSOA_FISICA;


    protected static function getQuery($campos)
    {
        return "SELECT {$campos} FROM " . TB_PESSOA_FISICA . " pf JOIN " . TB_PESSOA . " p  ON pf.id_pessoa = p.id WHERE CONCAT(p.id,' ',UPPER(p.nm_pessoa),' ',IFNULL(CONCAT(pf.nr_cpf,' '), '')) LIKE ";
    }

    /**
     *
     * @param string $termo
     * @return int quantidade de linhas encontradas com o termo
     */
    public static function searchFound($termo)
    {
        $termo = "'%" . strtoupper($termo) . "%'";
        $db = Db::getInstance();
        $select = self::getQuery('count(*) AS count') . " {$termo}";
        $stmt = $db->prepare($select);
        $stmt->execute();
        $count = $stmt->fetch();
        return $count['count'];
    }

    /**
     *
     * @param string $termo
     * @return array
     */
    public static function fullSearch($termo, $offset, $count)
    {
        $result = array();
        $termo = "'%" . strtoupper($termo) . "%'";
        $db = Db::getInstance();
        $select = self::getQuery('*') . " {$termo} ";
        if ($offset !== false)
            $select .= " LIMIT {$offset}, {$count} ";
        $stmt = $db->prepare($select);
        $stmt->execute();
        $ids = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (is_array($ids) && count($ids)) {
            foreach ($ids as $id) {
                $result[] = self::findPessoaFisica($id['id']);
            }
        }
        return $result;
    }


    /**
     * @param $cpf
     * @return bool|null|Zend_Db_Table_Row_Abstract
     */
    public static function findByCpf($cpf)
    {
        if (Helper::validaCPF($cpf)) {
            $pessoa = new Pessoa_Fisica();
            $pessoa = $pessoa->fetchRow('nr_cpf = "' . $cpf . '"');
        }
        if (!$pessoa) {
            $pessoa = new Pessoa_Juridica();
            $pessoa = $pessoa->fetchRow('nr_cnpj = "' . $cpf . '"');
        }
        if ($pessoa) {
            $pessoa = Pessoa::findById($pessoa->id_pessoa);

            return $pessoa;
        } else {
            return false;
        }
    }

    /**
     *
     * @param integer $id
     * @return array
     */
    public static function findPessoaFisica($id)
    {
        $db = Db::getInstance();
        $stmt = $db->prepare("SELECT p.id, p.nm_pessoa, p.fl_status, pf.nr_cpf FROM " . TB_PESSOA_FISICA . " pf JOIN " . TB_PESSOA . " p ON pf.id_pessoa = p.id WHERE p.id = ? AND p.fl_status = 1");
        $stmt->execute(array($id));
        $stmt->setFetchMode(PDO::FETCH_CLASS, "Pessoa_Fisica");
        return $stmt->fetch();
    }

    /**
     *
     * @param integer $id
     * @return array
     */
    public static function findDadosPessoaFisica($id, $cidade = false)
    {
        $db = Db::getInstance();
        $query = "SELECT pf.*, p.*, c.* FROM " . TB_PESSOA_FISICA . " pf JOIN " . TB_PESSOA . " p ON pf.id_pessoa = p.id";
        $query .= " LEFT JOIN " . TB_CIDADE . " c ON c.id = p.cd_cidade";
        $query .= " WHERE p.id = ?";
        $stmt = $db->prepare($query);
        $stmt->execute(array($id));
        $stmt->setFetchMode(PDO::FETCH_CLASS, "Pessoa_Fisica");
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public static function findLista($post, $count = false)
    {
        $search = utf8_decode($_POST['search']['value']);
        $order = $_POST['order'];

        $array = array(
            0 => 'p.id',
            1 => 'p.nm_pessoa',
            2 => 'pf.nr_cpf'
        );

        if ($search) {
            $where = 'p.id LIKE "%' . $search . '%" ';
            $where .= 'or p.nm_pessoa LIKE "%' . $search . '%" ';
            $where .= 'or pf.nr_cpf LIKE "%' . $search . '%" ';
        }

        $itens = self::getDefaultAdapter()->select()
            ->from(array('p' => TB_PESSOA), array('p.id', 'p.nm_pessoa'))
            ->join(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', array('*'));

        if (isset($where)) {
            $itens = $itens->where($where);
        }
        //Apenas pessoas ativas
        $itens = $itens->where('p.fl_status = "1"');

        if (!$count)
            if (isset($post['start']) && $post['length'] != '-1') {
                $itens = $itens->limit($post['length'], $post['start']);
            }

        $orderByQuery = array();
        foreach ($order as $ord)
            $orderByQuery[] = $array[$ord['column']] . ' ' . $ord['dir'];

        $itens = $itens->order(implode(',', $orderByQuery))->query()->fetchAll();


        return $itens;
    }
}