<?php

class Pessoa extends Zend_Db_Table_Abstract
{

    protected $_name = TB_PESSOA;

    /**
     * Pesquisa uma pessoa atrav�s do where
     * @param $where
     * @return mixed
     */
    private function findPessoaFisica($where)
    {
        return $this->getAdapter()->select()
            ->from(array('p' => TB_PESSOA), array('*'))
            ->join(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = p.id', array('*'))
            ->joinLeft(array('c' => TB_CIDADE), 'c.id = p.cd_cidade', array('nm_cidade' => 'nome'))
            ->where('p.fl_status = 1')
            ->where($where)
            ->query()->fetch();
    }
    private function findPessoaJuridica($where)
    {
        return $this->getAdapter()->select()
            ->from(array('p' => TB_PESSOA), array('*'))
            ->join(array('pj' => TB_PESSOA_JURIDICA), 'pj.id_pessoa = p.id', array('*'))
            ->joinLeft(array('c' => TB_CIDADE), 'c.id = p.cd_cidade', array('nm_cidade' => 'nome'))
            ->where('p.fl_status = 1')
            ->where($where)
            ->query()->fetch();
    }

    public static function findPessoaFisicaByNome($termo){
        $listaPessoas = Pessoa::getDefaultAdapter()->select()
            ->from(array('p' => TB_PESSOA), array('idPessoa' => 'id', 'nm_pessoa', 'endereco', 'nr_telefone', 'nr_celular', 'nr_fax', 'nr_recado', 'nm_bairro', 'nr_cep'))
            ->join(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', array('nr_cpf'))
            ->where('p.nm_pessoa LIKE "%' . $termo . '%" OR pf.nr_cpf LIKE "%' . $termo . '%"');

        return $listaPessoas->where('p.fl_status = "1"')->query()->fetchAll();
    }

    public static function findPessoaByNome($termo){
        $listaPessoas = Pessoa::getDefaultAdapter()->select()
            ->from(array('p' => TB_PESSOA), array('idPessoa' => 'id', 'nm_pessoa', 'endereco', 'nr_telefone', 'nr_celular', 'nr_fax', 'nr_recado', 'nm_bairro', 'nr_cep'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', array('nr_cpf'))
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'p.id = pj.id_pessoa', array('nr_cnpj'))
            ->where('p.nm_pessoa LIKE "%' . $termo . '%" OR pf.nr_cpf LIKE "%' . $termo . '%" OR pj.nr_cnpj LIKE "%' . $termo . '%"');

        return $listaPessoas->where('p.fl_status = "1"')->query()->fetchAll();
    }

    public static function findPessoaById($id){
        $pessoa = Pessoa::getDefaultAdapter()->select()
            ->from(array('p' => TB_PESSOA), array('id', 'nm_pessoa', 'endereco', 'nr_telefone', 'nr_celular', 'nr_fax', 'nr_recado', 'nm_bairro', 'nr_cep'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', array('nr_cpf'))
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'p.id = pj.id_pessoa', array('nr_cnpj'))
            ->where('p.id = ?', $id);

        return $pessoa->where('p.fl_status = "1"')->query()->fetch();
    }

    public static function findPessoaJuridicaByNome($termo){
        $listaPessoas = Pessoa::getDefaultAdapter()->select()
            ->from(array('p' => TB_PESSOA), array('idPessoa' => 'id', 'nm_pessoa', 'endereco', 'nr_telefone', 'nr_celular', 'nr_fax', 'nr_recado', 'nm_bairro', 'nr_cep'))
            ->join(array('pj' => TB_PESSOA_JURIDICA), 'p.id = pj.id_pessoa', array('nr_cnpj'))
            ->where('p.nm_pessoa LIKE "%' . $termo . '%" OR pj.nr_cnpj LIKE "%' . $termo . '%"');

        return $listaPessoas->where('p.fl_status = "1"')->query()->fetchAll();
    }

    //busca uma pessoa física pelo ID
    public function findFisicaById($id)
    {
        $pessoa = $this->getAdapter()->select()
            ->from(array('p' => TB_PESSOA), array('*'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = p.id', array('*'))
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pj.id_pessoa = p.id', array('*'))
            ->joinLeft(array('cp' => TB_CONTRATO_PESSOA), 'cp.id_pessoa = p.id', 'porcentagem_participacao_contrato')
            ->where('p.id = ?', $id)
            ->query()->fetch();

        return $pessoa;
    }

    public function findFisicaById2($id, $contrato)
    {
        $pessoa = $this->getAdapter()->select()
            ->from(array('p' => TB_PESSOA), array('*'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = p.id', array('*'))
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pj.id_pessoa = p.id', array('*'))
            ->joinLeft(array('cp' => TB_CONTRATO_PESSOA), 'cp.id_pessoa = p.id', array('*'))
            ->where('p.id = ?', $id)
            ->where('cp.id_contrato = ?', $contrato)
            ->query()->fetch();

        return $pessoa;
    }

    /**
     * Retorna o nome da Pessoa pelo ID
     * @param $id
     * @return mixed
     */
    public static function findNomeById($id)
    {
        $pessoa = self::getDefaultAdapter()->select()
            ->from(array('p' => TB_PESSOA), array('nm_pessoa'))
            ->where('p.id = ?', $id)
            ->query()->fetch();

        return $pessoa['nm_pessoa'];
    }

    /**
     * Retorna todos os dados de uma pessoa pelo seu id, seja juridica ou fisica
     * @param $id
     * @return mixed
     */
    public static function findById($id){
        $pessoa = self::getDefaultAdapter()->select()->from(array("p" => TB_PESSOA), "*")
            ->joinLeft(array("pf" => TB_PESSOA_FISICA), "p.id = pf.id_pessoa", "*")
            ->joinLeft(array("pj" => TB_PESSOA_JURIDICA), "p.id = pj.id_pessoa", "*")
            ->where("id = {$id}")->query()->fetch();

        return $pessoa;

    }

    /**
     * Pesquisa a pessoa fisica de acordo com o cpf
     *
     * @param $cpf
     * @return mixed
     */
    public function findPessoaFisicaByCpf($cpf, $idPessoaAtual = null)
    {
        $wherePessoaAtual = ($idPessoaAtual) ? ' AND pf.id_pessoa <> ' . $idPessoaAtual : '';

        return self::findPessoaFisica('pf.nr_cpf = "' . $cpf . '"' . $wherePessoaAtual);
    }

    /**
     * Pesquisa a pessoa fisica de acordo com o cpf
     *
     * @param $cpf
     * @return mixed
     */
    public function findPessoaJuridicaByCnpj($cnpj, $idPessoaAtual = null)
    {
        $wherePessoaAtual = ($idPessoaAtual) ? ' AND pj.id_pessoa <> ' . $idPessoaAtual : '';

        return self::findPessoaJuridica('pj.nr_cnpj = "' . $cnpj . '"' . $wherePessoaAtual);
    }

    public static function findPessoaFisicaByName($term)
    {
        //Pesquisa todas pessoas Física pelo nome
        $listPessoaFisica =  Pessoa::getDefaultAdapter()->select()
            ->from(array("p" => TB_PESSOA), array("id", "nm_pessoa"))
            ->join(array("pf" => TB_PESSOA_FISICA), "p.id = pf.id_pessoa", "")
            ->where('UPPER(nm_pessoa) LIKE "' . mb_strtoupper(Helper::str2Upper($term, 'UTF-8')) . '%"')
            ->order("nm_pessoa")
            ->query()->fetchAll();

        return $listPessoaFisica;
    }

    public static function findPessoaJuridicaByName($term)
    {
        //Pesquisa todas pessoas Jurídicas pelo nome
        $pessoasJuridicas =  Pessoa::getDefaultAdapter()->select()
            ->from(array("p" => TB_PESSOA), array("id", "nm_pessoa"))
            ->join(array("pj" => TB_PESSOA_JURIDICA), "p.id = pj.id_pessoa", "")
            ->where('UPPER(nm_pessoa) LIKE "' . mb_strtoupper(Helper::str2Upper($term, 'UTF-8')) . '%"')
            ->order("nm_pessoa")
            ->query()->fetchAll();

        return $pessoasJuridicas;
    }

    public static function findAllPessoasJuridicas() {
        $listaPessoas = Pessoa::getDefaultAdapter()->select()
            ->from(array('p' => TB_PESSOA), array('idPessoa' => 'id', 'nm_pessoa', 'nr_cep'))
            ->join(array('pj' => TB_PESSOA_JURIDICA), 'p.id = pj.id_pessoa', array('nr_cnpj'))
            ->where('p.fl_status = "1"')
            ->query()->fetchAll();

        return $listaPessoas;
    }

}

