<?php

class ParceriaComissao extends Zend_Db_Table_Abstract{

    protected $_name = TB_PARCERIA_COMISSAO;

    /**
     *
     * @param string $termo
     * @return array
     */
    public static function fullSearch($termo, $count = false, $offset = false, $page = false, $where = false) {
        $termo = "'%".strtoupper($termo)."%'";
        $db = DB::getInstance();

        if($count && $offset === false && $page === false) {
            $select = "SELECT count(c.id_empreendimento) AS count FROM ".TB_PARCERIA_COMISSAO." c
                    JOIN ".TB_PESSOA." p  ON c.id_pessoa = p.id
                    JOIN ".TB_EMPREENDIMENTO." e  ON c.id_empreendimento = e.id
                  WHERE CONCAT(UPPER(e.nm_empreendimento), ' ', UPPER(p.nm_pessoa)) LIKE {$termo}
                  OR UPPER(i.nm_fantasia) LIKE {$termo}
                  ";
            if ($where) {
                $select .= " AND $where";
            }
        } else {
            $select = "SELECT c.* FROM ".TB_PARCERIA_COMISSAO." c
                    JOIN ".TB_PESSOA." p  ON c.id_pessoa = p.id
                    JOIN ".TB_EMPREENDIMENTO." e  ON c.id_empreendimento = e.id
                  WHERE CONCAT(UPPER(e.nm_empreendimento), ' ', UPPER(p.nm_pessoa)) LIKE {$termo}
                  OR UPPER(i.nm_fantasia) LIKE {$termo}
                  ";
            if ($where) {
                $select .= " AND $where";
            }
            if($offset !== false && $page !== false)
                $select .= " LIMIT {$offset}, {$page} ";
        }
        $stmt = $db->prepare($select);
        $stmt->execute();
        $ids = $stmt->fetchAll(PDO::FETCH_ASSOC);

        return  $ids;
    }

    /**
     * Busca as parcerias pelo id do empreendimento
     * @param $idEmp
     * @return array
     */
    public static function findByEmpreendimento($idEmp){
        $parcerias = self::getDefaultAdapter()->select()->from(array('pa' => TB_PARCERIA_COMISSAO), '*')
            ->join(array('e' => TB_EMPREENDIMENTO),'pa.id_empreendimento = e.id',null)
            ->join(array('pe' => TB_PESSOA),'pe.id = pa.id_pessoa','pe.nm_pessoa')
            ->where('e.id = ?',$idEmp)->query()->fetchAll();

        return $parcerias;
    }



    /**
     * Monta um array com os tipos de parcela pelo empreendimento
     * @param $id
     * @param $idEmpreendimento
     * @return array
     */
    public static function getArrayTiposParcela($id,$idEmpreendimento = false)
    {
        $corretorEmpreendimento = self::getDefaultAdapter()->select()
            ->from(array('pc' => TB_PARCERIA_COMISSAO), array('*'))
            ->where('pc.id_pessoa = ?', $id);
        if ($idEmpreendimento) {
            $corretorEmpreendimento = $corretorEmpreendimento->where('pc.id_empreendimento = ?', $idEmpreendimento);
        }
        $corretorEmpreendimento = $corretorEmpreendimento->query()->fetch();

        $arrayParcelas = array();
        if ($corretorEmpreendimento['fl_parcela_normal'] == '1')
            $arrayParcelas[] = 'N';
        if ($corretorEmpreendimento['fl_parcela_sinal'] == '1')
            $arrayParcelas[] = 'S';
        if ($corretorEmpreendimento['fl_parcela_intercalada'] == '1')
            $arrayParcelas[] = 'I';
        if ($corretorEmpreendimento['fl_parcela_chave'] == '1')
            $arrayParcelas[] = 'C';
        if ($corretorEmpreendimento['fl_parcela_negociada'] == '1')
            $arrayParcelas[] = 'G';
        if ($corretorEmpreendimento['fl_parcela_quitacao'] == '1')
            $arrayParcelas[] = 'Q';
        if ($corretorEmpreendimento['fl_parcela_avulsa'] == '1')
            $arrayParcelas[] = 'A';
        return $arrayParcelas;
    }
}